/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.thread;

import com.scudata.array.IArray;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.ComputeStack;
import com.scudata.dm.Context;
import com.scudata.dm.Current;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Record;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.expression.Expression;
import com.scudata.thread.Job;

class DeriveJob
extends Job {
    private Sequence src;
    private int start;
    private int end;
    private DataStruct newDs;
    private Expression[] exps;
    private String opt;
    private Context ctx;
    private Table result;

    public DeriveJob(Sequence src, int start, int end, DataStruct newDs, Expression[] exps, String opt, Context ctx) {
        this.src = src;
        this.start = start;
        this.end = end;
        this.newDs = newDs;
        this.exps = exps;
        this.opt = opt;
        this.ctx = ctx;
    }

    @Override
    public void run() {
        block9: {
            Table table;
            Sequence src = this.src;
            int start = this.start;
            int end = this.end;
            DataStruct newDs = this.newDs;
            Context ctx = this.ctx;
            this.result = table = new Table(newDs, end - start);
            int colCount = this.exps.length;
            int newColCount = newDs.getFieldCount();
            int oldColCount = newColCount - colCount;
            IArray srcMems = src.getMems();
            IArray mems = table.getMems();
            ComputeStack stack = ctx.getComputeStack();
            Current newCurrent = new Current(table);
            stack.push(newCurrent);
            Current current = new Current(src);
            stack.push(current);
            try {
                if (this.opt == null || this.opt.indexOf(105) == -1) {
                    int i = 1;
                    while (start < end) {
                        Record r = new Record(newDs);
                        mems.add(r);
                        r.set((BaseRecord)srcMems.get(start));
                        newCurrent.setCurrent(i);
                        current.setCurrent(start);
                        int c = 0;
                        while (c < colCount) {
                            r.setNormalFieldValue(c + oldColCount, this.exps[c].calculate(ctx));
                            ++c;
                        }
                        ++start;
                        ++i;
                    }
                    break block9;
                }
                int i = 1;
                while (start < end) {
                    block10: {
                        Record r = new Record(newDs);
                        mems.add(r);
                        r.set((BaseRecord)srcMems.get(start));
                        newCurrent.setCurrent(i);
                        current.setCurrent(start);
                        int c = 0;
                        while (c < colCount) {
                            Object obj = this.exps[c].calculate(ctx);
                            if (obj == null) {
                                mems.remove(i);
                                break block10;
                            }
                            r.setNormalFieldValue(c + oldColCount, obj);
                            ++c;
                        }
                        ++i;
                    }
                    ++start;
                }
            }
            finally {
                stack.pop();
                stack.pop();
            }
        }
    }

    public void getResult(Table table) {
        table.getMems().addAll(this.result.getMems());
    }
}

