/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.thread;

import com.scudata.dm.ComputeStack;
import com.scudata.dm.Context;
import com.scudata.dm.Current;
import com.scudata.dm.Sequence;
import com.scudata.expression.Expression;
import com.scudata.thread.Job;

class RunJob
extends Job {
    private Sequence src;
    private int start;
    private int end;
    private Expression exp;
    private Context ctx;
    private Expression[] assignExps;
    private Expression[] exps;

    public RunJob(Sequence src, int start, int end, Expression exp, Context ctx) {
        this.src = src;
        this.start = start;
        this.end = end;
        this.exp = exp;
        this.ctx = ctx;
    }

    public RunJob(Sequence src, int start, int end, Expression[] assignExps, Expression[] exps, Context ctx) {
        this.src = src;
        this.start = start;
        this.end = end;
        this.assignExps = assignExps;
        this.exps = exps;
        this.ctx = ctx;
    }

    @Override
    public void run() {
        if (this.exp != null) {
            this.run1();
        } else {
            this.run2();
        }
    }

    public void run1() {
        int end = this.end;
        Expression exp = this.exp;
        Context ctx = this.ctx;
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(this.src);
        stack.push(current);
        try {
            int i = this.start;
            while (i < end) {
                current.setCurrent(i);
                exp.calculate(ctx);
                ++i;
            }
        }
        finally {
            stack.pop();
        }
    }

    public void run2() {
        int end = this.end;
        Expression[] exps = this.exps;
        Expression[] assignExps = this.assignExps;
        Context ctx = this.ctx;
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(this.src);
        stack.push(current);
        int colCount = exps.length;
        try {
            int i = this.start;
            while (i < end) {
                current.setCurrent(i);
                int c = 0;
                while (c < colCount) {
                    if (assignExps[c] == null) {
                        exps[c].calculate(ctx);
                    } else {
                        assignExps[c].assign(exps[c].calculate(ctx), ctx);
                    }
                    ++c;
                }
                ++i;
            }
        }
        finally {
            stack.pop();
        }
    }
}

