/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.thread;

import com.scudata.dm.Env;
import com.scudata.thread.Job;
import java.util.LinkedList;

public class ThreadPool {
    private static ThreadPool instance;
    private WorkThread[] threads;
    private LinkedList<Job> jobList = new LinkedList();
    private boolean shutdown;

    private ThreadPool(int threadCount) {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        this.threads = new WorkThread[threadCount];
        int i = 0;
        while (i < threadCount) {
            this.threads[i] = new WorkThread(group, "ThreadPool" + i);
            this.threads[i].setDaemon(true);
            this.threads[i].start();
            ++i;
        }
    }

    public static synchronized ThreadPool instance() {
        if (instance == null || ThreadPool.instance.shutdown) {
            int n = Env.getParallelNum();
            if (n < 2) {
                n = 2;
            }
            instance = new ThreadPool(n);
        } else {
            WorkThread[] threads = ThreadPool.instance.threads;
            int i = 0;
            int len = threads.length;
            while (i < len) {
                if (!threads[i].isAlive()) {
                    ThreadPool threadPool = instance;
                    threadPool.getClass();
                    threads[i] = threadPool.new WorkThread(threads[i].getThreadGroup(), "ThreadPool" + i);
                    threads[i].setDaemon(true);
                    threads[i].start();
                }
                ++i;
            }
        }
        return instance;
    }

    public static synchronized ThreadPool newInstance(int threadCount) {
        int n = Env.getParallelNum();
        if (threadCount > n) {
            threadCount = n < 1 ? 1 : n;
        }
        return new ThreadPool(threadCount);
    }

    public static synchronized ThreadPool newSpecifiedInstance(int size) {
        int n = size;
        if (n < 1) {
            n = 1;
        }
        return new ThreadPool(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() {
        this.shutdown = true;
        LinkedList<Job> linkedList = this.jobList;
        synchronized (linkedList) {
            this.jobList.notifyAll();
            this.jobList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submit(Job job) {
        job.reset();
        LinkedList<Job> linkedList = this.jobList;
        synchronized (linkedList) {
            this.jobList.add(job);
            this.jobList.notify();
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.shutdown) {
                this.jobList.notifyAll();
                this.jobList.clear();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int getThreadCount() {
        return this.threads.length;
    }

    private class WorkThread
    extends Thread {
        private WorkThread(ThreadGroup group, String name) {
            super(group, name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                LinkedList linkedList = ThreadPool.this.jobList;
                synchronized (linkedList) {
                    block14: {
                        if (ThreadPool.this.shutdown) {
                            return;
                        }
                        if (ThreadPool.this.jobList.size() == 0) {
                            try {
                                ThreadPool.this.jobList.wait();
                            }
                            catch (InterruptedException e) {
                                if (!ThreadPool.this.shutdown) break block14;
                                return;
                            }
                        }
                    }
                }
                Job job = null;
                LinkedList e = ThreadPool.this.jobList;
                synchronized (e) {
                    if (ThreadPool.this.jobList.size() > 0) {
                        job = (Job)ThreadPool.this.jobList.removeFirst();
                    }
                }
                if (job == null) continue;
                try {
                    job.run();
                }
                catch (Throwable e2) {
                    job.setError(e2);
                }
                job.finish();
            }
        }
    }
}

