/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.util;

import com.scudata.array.IArray;
import com.scudata.common.IntArrayList;
import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.BFileReader;
import com.scudata.dm.BFileWriter;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.ComputeStack;
import com.scudata.dm.Context;
import com.scudata.dm.Current;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Env;
import com.scudata.dm.FileObject;
import com.scudata.dm.HashArraySet;
import com.scudata.dm.IndexTable;
import com.scudata.dm.ListBase1;
import com.scudata.dm.Record;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.dm.comparator.ArrayComparator;
import com.scudata.dm.comparator.BaseComparator;
import com.scudata.dm.comparator.PSortComparator;
import com.scudata.dm.comparator.PSortItem;
import com.scudata.dm.cursor.BFileCursor;
import com.scudata.dm.cursor.GroupxnCursor;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.cursor.IMultipath;
import com.scudata.dm.cursor.JoinmCursor;
import com.scudata.dm.cursor.JoinxCursor;
import com.scudata.dm.cursor.JoinxCursor2;
import com.scudata.dm.cursor.MemoryCursor;
import com.scudata.dm.cursor.MergeCursor;
import com.scudata.dm.cursor.MergeCursor2;
import com.scudata.dm.cursor.MergeFilterCursor;
import com.scudata.dm.cursor.MergesCursor;
import com.scudata.dm.cursor.MultipathCursors;
import com.scudata.dm.cursor.PJoinCursor;
import com.scudata.dm.cursor.SortxCursor;
import com.scudata.dm.op.DiffJoin;
import com.scudata.dm.op.FilterJoin;
import com.scudata.dm.op.IGroupsResult;
import com.scudata.dm.op.Join;
import com.scudata.dm.op.Operation;
import com.scudata.dw.ColPhyTable;
import com.scudata.dw.IDWCursor;
import com.scudata.dw.PhyTable;
import com.scudata.expression.CurrentSeq;
import com.scudata.expression.Expression;
import com.scudata.expression.Node;
import com.scudata.expression.fn.gather.ICount;
import com.scudata.parallel.ClusterCursor;
import com.scudata.resources.EngineMessage;
import com.scudata.thread.GroupsJob;
import com.scudata.thread.GroupsJob2;
import com.scudata.thread.GroupxJob;
import com.scudata.thread.MultithreadUtil;
import com.scudata.thread.ThreadPool;
import com.scudata.util.EnvUtil;
import com.scudata.util.HashUtil;
import com.scudata.util.MinHeap;
import com.scudata.util.Variant;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeMap;

public final class CursorUtil {
    public static DataStruct getDataStruct(ICursor cs) {
        DataStruct ds = cs.getDataStruct();
        if (ds == null) {
            Sequence seq = cs.peek(999);
            ds = cs.getDataStruct();
            if (ds == null && seq != null) {
                ds = seq.dataStruct();
            }
        }
        return ds;
    }

    public static Table groups_m(Sequence src, Expression[] exps, String[] names, Expression[] calcExps, String[] calcNames, String opt, Context ctx) {
        int len = src.length();
        int parallelNum = Env.getParallelNum();
        if (len <= MultithreadUtil.SINGLE_PROSS_COUNT || parallelNum < 2) {
            return src.groups(exps, names, calcExps, calcNames, opt, ctx);
        }
        int threadCount = (len - 1) / MultithreadUtil.SINGLE_PROSS_COUNT + 1;
        if (threadCount > parallelNum) {
            threadCount = parallelNum;
        }
        int singleCount = len / threadCount;
        int keyCount = exps == null ? 0 : exps.length;
        ThreadPool pool = ThreadPool.instance();
        GroupsJob[] jobs = new GroupsJob[threadCount];
        int start = 1;
        int i = 0;
        while (i < threadCount) {
            int end = i + 1 == threadCount ? len + 1 : start + singleCount;
            Context tmpCtx = ctx.newComputeContext();
            Expression[] tmpExps = Operation.dupExpressions(exps, tmpCtx);
            Expression[] tmpCalcExps = Operation.dupExpressions(calcExps, tmpCtx);
            Sequence seq = src.get(start, end);
            jobs[i] = new GroupsJob(seq, tmpExps, names, tmpCalcExps, calcNames, opt, tmpCtx);
            pool.submit(jobs[i]);
            start = end;
            ++i;
        }
        Sequence result = null;
        IGroupsResult groupsResult = null;
        int i2 = 0;
        while (i2 < threadCount) {
            jobs[i2].join();
            groupsResult = jobs[i2].getGroupsResult();
            if (result == null) {
                result = groupsResult.getTempResult();
            } else {
                result.addAll(groupsResult.getTempResult());
            }
            ++i2;
        }
        if (result == null || result.length() == 0) {
            return result;
        }
        Expression[] keyExps = null;
        if (keyCount > 0) {
            keyExps = new Expression[keyCount];
            int i3 = 0;
            int q = 1;
            while (i3 < keyCount) {
                keyExps[i3] = new Expression(ctx, "#" + q);
                ++i3;
                ++q;
            }
        }
        Expression[] valExps = groupsResult.getRegatherExpressions();
        DataStruct tempDs = groupsResult.getRegatherDataStruct();
        int tempFieldCount = tempDs.getFieldCount();
        if (keyCount > 0) {
            if (names == null) {
                names = new String[keyCount];
            }
            int i4 = 0;
            while (i4 < keyCount) {
                names[i4] = tempDs.getFieldName(i4);
                ++i4;
            }
        }
        if (tempFieldCount > keyCount) {
            int gatherCount = tempFieldCount - keyCount;
            calcNames = new String[gatherCount];
            int i5 = 0;
            while (i5 < gatherCount) {
                calcNames[i5] = tempDs.getFieldName(keyCount + i5);
                ++i5;
            }
        }
        result = result.groups(keyExps, names, valExps, calcNames, opt, ctx);
        Expression[] newExps = groupsResult.getResultExpressions();
        if (newExps != null) {
            return result.newTable(groupsResult.getResultDataStruct(), newExps, null, ctx);
        }
        return result;
    }

    public static Table groups_z(Sequence src, Expression[] exps, String[] names, Expression[] calcExps, String[] calcNames, String opt, Context ctx, int hashCapacity) {
        int capacity = hashCapacity > 0 ? hashCapacity : Env.getDefaultHashCapacity();
        HashUtil hashUtil = new HashUtil(capacity);
        capacity = hashUtil.getCapacity();
        int parallelNum = Env.getParallelNum();
        ThreadPool pool = ThreadPool.newInstance(parallelNum);
        GroupsJob2[] jobs = new GroupsJob2[parallelNum];
        Table groupsResult = null;
        try {
            int i = 0;
            while (i < parallelNum) {
                Context tmpCtx = ctx.newComputeContext();
                Expression[] tmpExps = Operation.dupExpressions(exps, tmpCtx);
                Expression[] tmpCalcExps = Operation.dupExpressions(calcExps, tmpCtx);
                GroupsJob2 job = new GroupsJob2(src, hashUtil, null, tmpExps, names, tmpCalcExps, calcNames, opt, tmpCtx, capacity);
                job.setHashStart(i);
                job.setHashEnd(parallelNum);
                jobs[i] = job;
                pool.submit(jobs[i]);
                ++i;
            }
            i = 0;
            while (i < parallelNum) {
                jobs[i].join();
                if (i == 0) {
                    groupsResult = jobs[i].getGroupsResult().getResultTable();
                } else {
                    Table t = jobs[i].getGroupsResult().getResultTable();
                    groupsResult.addAll(t);
                }
                ++i;
            }
        }
        finally {
            pool.shutdown();
        }
        if (opt == null || opt.indexOf(117) == -1) {
            int keyCount = exps.length;
            int[] fields = new int[keyCount];
            int i = 0;
            while (i < keyCount) {
                fields[i] = i;
                ++i;
            }
            groupsResult.sortFields(fields);
        }
        return groupsResult;
    }

    public static Table fuzzyGroups(ICursor cursor, Expression[] exps, String[] names, Expression[] calcExps, String[] calcNames, String opt, Context ctx, int maxGroupCount) {
        Sequence src;
        DataStruct ds = cursor.getDataStruct();
        int count = exps.length;
        if (names == null) {
            names = new String[count];
        }
        int i = 0;
        while (i < count) {
            if (names[i] == null || names[i].length() == 0) {
                names[i] = exps[i].getFieldName(ds);
            }
            ++i;
        }
        if (calcExps != null) {
            count = calcExps.length;
            if (calcNames == null) {
                calcNames = new String[count];
            }
            i = 0;
            while (i < count) {
                if (calcNames[i] == null || calcNames[i].length() == 0) {
                    calcNames[i] = calcExps[i].getFieldName(ds);
                }
                ++i;
            }
        }
        int keyCount = exps.length;
        int valCount = calcExps == null ? 0 : calcExps.length;
        int INIT_GROUPSIZE = HashUtil.getInitGroupSize();
        HashUtil hashUtil = new HashUtil(maxGroupCount);
        ListBase1[] groups = new ListBase1[hashUtil.getCapacity()];
        Object[] keys = new Object[keyCount];
        String[] colNames = new String[keyCount + valCount];
        System.arraycopy(names, 0, colNames, 0, keyCount);
        if (calcNames != null) {
            System.arraycopy(calcNames, 0, colNames, keyCount, valCount);
        }
        Table table = new Table(colNames, hashUtil.getCapacity());
        table.setPrimary(names);
        Node[] gathers = Sequence.prepareGatherMethods(calcExps, ctx);
        ComputeStack stack = ctx.getComputeStack();
        while ((src = cursor.fetch(ICursor.FETCHCOUNT)) != null && src.length() != 0) {
            Current current = new Current(src);
            stack.push(current);
            try {
                int i2 = 1;
                int len = src.length();
                while (i2 <= len) {
                    BaseRecord r;
                    current.setCurrent(i2);
                    int k = 0;
                    while (k < keyCount) {
                        keys[k] = exps[k].calculate(ctx);
                        ++k;
                    }
                    int hash = hashUtil.hashCode(keys);
                    if (groups[hash] == null) {
                        groups[hash] = new ListBase1(INIT_GROUPSIZE);
                        r = table.newLast(keys);
                        groups[hash].add(r);
                        int v = 0;
                        int f = keyCount;
                        while (v < valCount) {
                            Object val = gathers[v].gather(ctx);
                            r.setNormalFieldValue(f, val);
                            ++v;
                            ++f;
                        }
                    } else {
                        Object val;
                        int v;
                        int index = HashUtil.bsearch_r(groups[hash], keys);
                        if (index < 1) {
                            r = table.newLast(keys);
                            groups[hash].add(-index, r);
                            v = 0;
                            int f = keyCount;
                            while (v < valCount) {
                                val = gathers[v].gather(ctx);
                                r.setNormalFieldValue(f, val);
                                ++v;
                                ++f;
                            }
                        } else {
                            r = (BaseRecord)groups[hash].get(index);
                            v = 0;
                            int f = keyCount;
                            while (v < valCount) {
                                val = gathers[v].gather(r.getNormalFieldValue(f), ctx);
                                r.setNormalFieldValue(f, val);
                                ++v;
                                ++f;
                            }
                        }
                    }
                    ++i2;
                }
            }
            finally {
                stack.pop();
            }
            if (table.length() < maxGroupCount) continue;
        }
        if (opt == null || opt.indexOf(117) == -1) {
            int[] fields = new int[keyCount];
            int i3 = 0;
            while (i3 < keyCount) {
                fields[i3] = i3;
                ++i3;
            }
            table.sortFields(fields);
        }
        table.finishGather(gathers);
        return table;
    }

    public static Sequence hashGroup(Sequence src, Expression[] exps, String opt, Context ctx) {
        if (src == null || src.length() == 0) {
            return new Sequence(0);
        }
        int srcLen = src.length();
        boolean isAll = true;
        boolean isSort = true;
        boolean isPos = false;
        boolean isConj = false;
        boolean deleteNull = false;
        if (opt != null) {
            if (opt.indexOf(49) != -1) {
                isAll = false;
            }
            if (opt.indexOf(117) != -1) {
                isSort = false;
            }
            if (opt.indexOf(112) != -1) {
                isPos = true;
            }
            if (opt.indexOf(115) != -1) {
                isConj = true;
            }
            if (opt.indexOf(48) != -1) {
                deleteNull = true;
            }
        }
        int keyCount = exps.length;
        int INIT_GROUPSIZE = HashUtil.getInitGroupSize();
        HashUtil hashUtil = new HashUtil(srcLen / 2);
        ListBase1[] groups = new ListBase1[hashUtil.getCapacity()];
        Sequence result = new Sequence(hashUtil.getCapacity());
        boolean isSingleField = keyCount == 1 && !isAll;
        ListBase1 keyList = null;
        if (isSort) {
            keyList = new ListBase1(hashUtil.getCapacity());
        }
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(src);
        stack.push(current);
        try {
            int hash;
            int i;
            if (isSingleField) {
                Expression exp = exps[0];
                i = 1;
                while (i <= srcLen) {
                    current.setCurrent(i);
                    Object key = exp.calculate(ctx);
                    if (!deleteNull || key != null) {
                        hash = hashUtil.hashCode(key);
                        if (groups[hash] == null) {
                            result.add(isPos ? new Integer(i) : current.getCurrent());
                            groups[hash] = new ListBase1(INIT_GROUPSIZE);
                            groups[hash].add(key);
                            if (isSort) {
                                keyList.add(key);
                            }
                        } else {
                            int index = groups[hash].binarySearch(key);
                            if (index < 1) {
                                result.add(isPos ? new Integer(i) : current.getCurrent());
                                groups[hash].add(-index, key);
                                if (isSort) {
                                    keyList.add(key);
                                }
                            }
                        }
                    }
                    ++i;
                }
            } else {
                int count = isAll ? keyCount + 1 : keyCount;
                i = 1;
                while (i <= srcLen) {
                    current.setCurrent(i);
                    Object[] keys = new Object[count];
                    int k = 0;
                    while (k < keyCount) {
                        keys[k] = exps[k].calculate(ctx);
                        ++k;
                    }
                    if (!deleteNull || keys[0] != null) {
                        hash = hashUtil.hashCode(keys, keyCount);
                        if (groups[hash] == null) {
                            if (isAll) {
                                Sequence group = new Sequence(INIT_GROUPSIZE);
                                group.add(isPos ? new Integer(i) : current.getCurrent());
                                keys[keyCount] = group;
                                result.add(group);
                            } else {
                                result.add(isPos ? new Integer(i) : current.getCurrent());
                            }
                            groups[hash] = new ListBase1(INIT_GROUPSIZE);
                            groups[hash].add(keys);
                            if (isSort) {
                                keyList.add(keys);
                            }
                        } else {
                            int index = HashUtil.bsearch_a(groups[hash], keys, keyCount);
                            if (index < 1) {
                                if (isAll) {
                                    Sequence group = new Sequence(INIT_GROUPSIZE);
                                    group.add(isPos ? new Integer(i) : current.getCurrent());
                                    keys[keyCount] = group;
                                    result.add(group);
                                } else {
                                    result.add(isPos ? new Integer(i) : current.getCurrent());
                                }
                                groups[hash].add(-index, keys);
                                if (isSort) {
                                    keyList.add(keys);
                                }
                            } else if (isAll) {
                                Object[] tmps = (Object[])groups[hash].get(index);
                                ((Sequence)tmps[keyCount]).add(isPos ? new Integer(i) : current.getCurrent());
                            }
                        }
                    }
                    ++i;
                }
            }
        }
        finally {
            stack.pop();
        }
        if (isSort) {
            int len = result.length();
            Object[] infos = new PSortItem[len + 1];
            int i = 1;
            while (i <= len) {
                infos[i] = new PSortItem(i, keyList.get(i));
                ++i;
            }
            Comparator<Object> comparator = isSingleField ? new BaseComparator() : new ArrayComparator(keyCount);
            comparator = new PSortComparator(comparator);
            MultithreadUtil.sort(infos, 1, infos.length, comparator);
            Sequence retSeries = new Sequence(len);
            int i2 = 1;
            while (i2 <= len) {
                retSeries.add(result.getMem(((PSortItem)infos[i2]).index));
                ++i2;
            }
            if (isAll && isConj) {
                return retSeries.conj(null);
            }
            return retSeries;
        }
        if (isAll && isConj) {
            return result.conj(null);
        }
        return result;
    }

    public static Sequence hashGroup(Sequence src, String opt) {
        if (src == null || src.length() == 0) {
            return new Sequence(0);
        }
        boolean isAll = true;
        boolean isSort = true;
        boolean isPos = false;
        boolean isConj = false;
        if (opt != null) {
            if (opt.indexOf(49) != -1) {
                isAll = false;
            }
            if (opt.indexOf(117) != -1) {
                isSort = false;
            }
            if (opt.indexOf(112) != -1) {
                isPos = true;
            }
            if (opt.indexOf(115) != -1) {
                isConj = true;
            }
        }
        if (!isAll) {
            return CursorUtil.hashId(src, opt);
        }
        if (isPos) {
            Context ctx = new Context();
            Expression exp = new Expression("~");
            return CursorUtil.hashGroup(src, new Expression[]{exp}, opt, ctx);
        }
        int INIT_GROUPSIZE = HashUtil.getInitGroupSize();
        HashUtil hashUtil = new HashUtil(src.length() / 2);
        ListBase1[] groups = new ListBase1[hashUtil.getCapacity()];
        Sequence result = new Sequence(hashUtil.getCapacity());
        int i = 1;
        int len = src.length();
        while (i <= len) {
            Object mem = src.getMem(i);
            int hash = hashUtil.hashCode(mem);
            if (groups[hash] == null) {
                Sequence group = new Sequence(INIT_GROUPSIZE);
                group.add(mem);
                result.add(group);
                groups[hash] = new ListBase1(INIT_GROUPSIZE);
                groups[hash].add(group);
            } else {
                Sequence group;
                int index = HashUtil.bsearch_g(groups[hash], mem);
                if (index < 1) {
                    group = new Sequence(INIT_GROUPSIZE);
                    group.add(mem);
                    result.add(group);
                    groups[hash].add(-index, group);
                } else {
                    group = (Sequence)groups[hash].get(index);
                    group.add(mem);
                }
            }
            ++i;
        }
        if (isSort) {
            Comparator<Object> comparator = new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    return Variant.compare(((Sequence)o1).getMem(1), ((Sequence)o2).getMem(1), true);
                }
            };
            result.getMems().sort(comparator);
        }
        if (isConj) {
            return result.conj(null);
        }
        return result;
    }

    public static Sequence hashId(Sequence src, String opt) {
        int len = src.length();
        if (len == 0) {
            return new Sequence();
        }
        if (opt != null && opt.indexOf(109) != -1) {
            return MultithreadUtil.hashId(src, opt);
        }
        HashUtil hashUtil = new HashUtil(len / 2);
        Sequence out = new Sequence(len);
        if (opt != null && opt.indexOf(110) != -1) {
            ICount.ICountPositionSet set = new ICount.ICountPositionSet();
            int i = 1;
            while (i <= len) {
                Object item = src.getMem(i);
                if (item instanceof Number && set.add(((Number)item).intValue())) {
                    out.add(item);
                }
                ++i;
            }
        } else if (opt != null && opt.indexOf(98) != -1) {
            ICount.ICountBitSet set = new ICount.ICountBitSet();
            int i = 1;
            while (i <= len) {
                Object item = src.getMem(i);
                if (item instanceof Number && set.add(((Number)item).intValue())) {
                    out.add(item);
                }
                ++i;
            }
        } else {
            int INIT_GROUPSIZE = HashUtil.getInitGroupSize();
            ListBase1[] groups = new ListBase1[hashUtil.getCapacity()];
            boolean removeNull = opt != null && opt.indexOf(48) != -1;
            int i = 1;
            while (i <= len) {
                Object item = src.getMem(i);
                if (!removeNull || item != null) {
                    int hash = hashUtil.hashCode(item);
                    if (groups[hash] == null) {
                        groups[hash] = new ListBase1(INIT_GROUPSIZE);
                        groups[hash].add(item);
                        out.add(item);
                    } else {
                        int index = groups[hash].binarySearch(item);
                        if (index < 1) {
                            groups[hash].add(-index, item);
                            out.add(item);
                        }
                    }
                }
                ++i;
            }
        }
        if (opt == null || opt.indexOf(117) == -1) {
            BaseComparator comparator = new BaseComparator();
            out.getMems().sort(comparator);
        }
        return out;
    }

    /*
     * Unable to fully structure code
     */
    public static void join_m(ListBase1[] groups, int fcount, int type, Table out) {
        srcCount = groups.length;
        ranks = new int[srcCount];
        curIndex = new int[srcCount];
        i = 0;
        while (i < srcCount) {
            curIndex[i] = 1;
            ++i;
        }
        block1: while (true) {
            has = false;
            equals = true;
            i = 0;
            while (i < srcCount) {
                group = groups[i];
                if (group != null && group.size() >= curIndex[i]) {
                    has = true;
                    ranks[i] = 0;
                    curValues = (Object[])group.get(curIndex[i]);
                    j = 0;
                    while (j < i) {
                        if (ranks[j] == 0) {
                            prevValues = (Object[])groups[j].get(curIndex[j]);
                            cmp = Variant.compareArrays(curValues, prevValues, fcount);
                            if (cmp < 0) {
                                equals = false;
                                ranks[j] = 1;
                                ++j;
                                while (j < i) {
                                    if (ranks[j] == 0) {
                                        ranks[j] = 1;
                                    }
                                    ++j;
                                }
                            } else if (cmp > 0) {
                                equals = false;
                                ranks[i] = 1;
                            }
                            break;
                        }
                        ++j;
                    }
                } else {
                    if (type == 0 || type == 1 && i == 0) break block1;
                    equals = false;
                    ranks[i] = -1;
                }
                ++i;
            }
            if (!has) break;
            if (!equals && type == 0 || ranks[0] != 0 && type == 1) {
                i = 0;
                while (true) {
                    if (i >= srcCount) continue block1;
                    if (ranks[i] == 0) {
                        group = groups[i];
                        len = group.size();
                        cur = curIndex[i];
                        curValues = (Object[])group.get(cur);
                        ++cur;
                        while (cur <= len) {
                            if (Variant.compareArrays(curValues, (Object[])group.get(cur), fcount) != 0) break;
                            ++cur;
                        }
                        curIndex[i] = cur;
                    }
                    ++i;
                }
            }
            start = -1;
            i = 0;
            while (true) {
                if (i < srcCount) ** break;
                continue block1;
                if (ranks[i] == 0) {
                    group = groups[i];
                    len = group.size();
                    cur = curIndex[i];
                    curValues = (Object[])group.get(cur);
                    if (start == -1) {
                        r = out.newLast();
                        r.setNormalFieldValue(i, curValues[fcount]);
                        start = out.length();
                        ++cur;
                        while (cur <= len) {
                            tmp = (Object[])group.get(cur);
                            if (Variant.compareArrays(curValues, tmp, fcount) != 0) break;
                            r = out.newLast();
                            r.setNormalFieldValue(i, tmp[fcount]);
                            ++cur;
                        }
                        curIndex[i] = cur;
                    } else {
                        end = out.length();
                        p = start;
                        while (p <= end) {
                            pr = (BaseRecord)out.getMem(p);
                            pr.setNormalFieldValue(i, curValues[fcount]);
                            ++p;
                        }
                        ++cur;
                        while (cur <= len) {
                            tmp = (Object[])group.get(cur);
                            if (Variant.compareArrays(curValues, tmp, fcount) != 0) break;
                            p = start;
                            while (p <= end) {
                                pr = (BaseRecord)out.getMem(p);
                                r = out.newLast(pr.getFieldValues());
                                r.setNormalFieldValue(i, tmp[fcount]);
                                ++p;
                            }
                            ++cur;
                        }
                        curIndex[i] = cur;
                    }
                }
                ++i;
            }
            break;
        }
    }

    public static Table mergeJoin(Sequence[] srcs, Expression[][] exps, String[] names, int type, Context ctx) {
        int srcCount = srcs.length;
        ListBase1[] groups = new ListBase1[srcCount];
        int keyCount = exps[0] == null ? 1 : exps[0].length;
        int count = keyCount + 1;
        ComputeStack stack = ctx.getComputeStack();
        int s = 0;
        while (s < srcCount) {
            ListBase1 group;
            Sequence src = srcs[s];
            int len = src.length();
            groups[s] = group = new ListBase1(len);
            Expression[] srcExps = exps[s];
            Current current = new Current(src);
            stack.push(current);
            try {
                int i = 1;
                while (i <= len) {
                    Object[] keys = new Object[count];
                    keys[keyCount] = src.getMem(i);
                    current.setCurrent(i);
                    if (srcExps == null) {
                        keys[0] = keys[keyCount];
                    } else {
                        int k = 0;
                        while (k < keyCount) {
                            keys[k] = srcExps[k].calculate(ctx);
                            ++k;
                        }
                    }
                    groups[s].add(keys);
                    ++i;
                }
            }
            finally {
                stack.pop();
            }
            ++s;
        }
        Table out = new Table(names);
        CursorUtil.join_m(groups, keyCount, type, out);
        return out;
    }

    public static Table hashJoin(Sequence[] srcs, Expression[][] exps, String[] names, int type, Context ctx) {
        int srcCount = srcs.length;
        int keyCount = exps[0] == null ? 1 : exps[0].length;
        int count = keyCount + 1;
        int INIT_GROUPSIZE = HashUtil.getInitGroupSize();
        HashUtil hashUtil = new HashUtil();
        ListBase1[][] hashGroups = new ListBase1[hashUtil.getCapacity()][];
        ComputeStack stack = ctx.getComputeStack();
        int s = 0;
        while (s < srcCount) {
            Sequence src = srcs[s];
            if (src != null && src.length() != 0) {
                Expression[] srcExps = exps[s];
                Current current = new Current(src);
                stack.push(current);
                try {
                    int i = 1;
                    int len = src.length();
                    while (i <= len) {
                        Object[] keys = new Object[count];
                        keys[keyCount] = src.getMem(i);
                        current.setCurrent(i);
                        if (srcExps == null) {
                            keys[0] = keys[keyCount];
                        } else {
                            int k = 0;
                            while (k < keyCount) {
                                keys[k] = srcExps[k].calculate(ctx);
                                ++k;
                            }
                        }
                        int hash = hashUtil.hashCode(keys, keyCount);
                        ListBase1[] groups = hashGroups[hash];
                        if (groups == null) {
                            hashGroups[hash] = groups = new ListBase1[srcCount];
                        }
                        if (groups[s] == null) {
                            groups[s] = new ListBase1(INIT_GROUPSIZE);
                            groups[s].add(keys);
                        } else {
                            int index = HashUtil.bsearch_a(groups[s], keys, keyCount);
                            if (index < 1) {
                                groups[s].add(-index, keys);
                            } else {
                                groups[s].add(index + 1, keys);
                            }
                        }
                        ++i;
                    }
                }
                finally {
                    stack.pop();
                }
            }
            ++s;
        }
        Table out = new Table(names);
        int i = 0;
        int len = hashGroups.length;
        while (i < len) {
            if (hashGroups[i] != null) {
                CursorUtil.join_m(hashGroups[i], keyCount, type, out);
                hashGroups[i] = null;
            }
            ++i;
        }
        return out;
    }

    public static Table mixJoin(Sequence[] srcs, Expression[][] exps, String[] names, int type, Context ctx) {
        int tcount = srcs.length;
        int expCount = exps[0].length;
        Expression[] prevExps = exps[1];
        int prevLen = prevExps.length;
        IntArrayList seqList = new IntArrayList(expCount);
        int i = 0;
        while (i < prevLen) {
            if (prevExps[i] != null) {
                seqList.addInt(i);
            }
            ++i;
        }
        int next = 2;
        while (next < tcount) {
            Expression[] tmp = exps[next];
            if (tmp.length != prevLen) break;
            int i2 = 0;
            while (i2 < tmp.length) {
                if (tmp[i2] == null && prevExps[i2] != null || tmp[i2] != null && prevExps[i2] == null) break;
                ++i2;
            }
            ++next;
        }
        Sequence[] tmpSeqs = new Sequence[next];
        Expression[][] tmpExps = new Expression[next][];
        String[] tmpNames = new String[next];
        int i3 = 0;
        while (i3 < next) {
            Expression[] curExps = new Expression[prevLen];
            tmpSeqs[i3] = srcs[i3];
            tmpExps[i3] = curExps;
            tmpNames[i3] = names[i3];
            Expression[] srcExps = exps[i3];
            int j = 0;
            while (j < prevLen) {
                curExps[j] = srcExps[seqList.getInt(j)];
                ++j;
            }
            ++i3;
        }
        Table prevResult = CursorUtil.hashJoin(tmpSeqs, tmpExps, tmpNames, type, ctx);
        int INIT_GROUPSIZE = HashUtil.getInitGroupSize();
        HashUtil hashUtil = new HashUtil();
        ComputeStack stack = ctx.getComputeStack();
        while (next < tcount) {
            int index;
            ListBase1[] groups;
            int hash;
            int k;
            Object[] keys;
            int len;
            int i4;
            prevExps = exps[next];
            prevLen = prevExps.length;
            seqList.clear();
            int i5 = 0;
            while (i5 < prevLen) {
                if (prevExps[i5] != null) {
                    seqList.addInt(i5);
                }
                ++i5;
            }
            int keyCount = seqList.size();
            Expression[] exps1 = new Expression[keyCount];
            Expression[] exps2 = new Expression[keyCount];
            int j = 0;
            while (j < prevLen) {
                exps1[j] = exps[0][seqList.getInt(j)];
                exps2[j] = exps[next][seqList.getInt(j)];
                ++j;
            }
            int count = keyCount + 1;
            ListBase1[][] hashGroups = new ListBase1[hashUtil.getCapacity()][];
            Sequence value = prevResult.fieldValues(0);
            Current current = new Current(value);
            stack.push(current);
            try {
                i4 = 1;
                len = value.length();
                while (i4 <= len) {
                    keys = new Object[count];
                    keys[keyCount] = prevResult.getMem(i4);
                    current.setCurrent(i4);
                    k = 0;
                    while (k < keyCount) {
                        keys[k] = exps1[k].calculate(ctx);
                        ++k;
                    }
                    hash = hashUtil.hashCode(keys, keyCount);
                    groups = hashGroups[hash];
                    if (groups == null) {
                        hashGroups[hash] = groups = new ListBase1[2];
                    }
                    if (groups[0] == null) {
                        groups[0] = new ListBase1(INIT_GROUPSIZE);
                        groups[0].add(keys);
                    } else {
                        index = HashUtil.bsearch_a(groups[0], keys, keyCount);
                        if (index < 1) {
                            groups[0].add(-index, keys);
                        } else {
                            groups[0].add(index + 1, keys);
                        }
                    }
                    ++i4;
                }
            }
            finally {
                stack.pop();
            }
            value = srcs[next];
            current = new Current(value);
            stack.push(current);
            try {
                i4 = 1;
                len = value.length();
                while (i4 <= len) {
                    keys = new Object[count];
                    keys[keyCount] = value.getMem(i4);
                    current.setCurrent(i4);
                    k = 0;
                    while (k < keyCount) {
                        keys[k] = exps2[k].calculate(ctx);
                        ++k;
                    }
                    hash = hashUtil.hashCode(keys, keyCount);
                    groups = hashGroups[hash];
                    if (groups == null) {
                        hashGroups[hash] = groups = new ListBase1[2];
                    }
                    if (groups[1] == null) {
                        groups[1] = new ListBase1(INIT_GROUPSIZE);
                        groups[1].add(keys);
                    } else {
                        index = HashUtil.bsearch_a(groups[1], keys, keyCount);
                        if (index < 1) {
                            groups[1].add(-index, keys);
                        } else {
                            groups[1].add(index + 1, keys);
                        }
                    }
                    ++i4;
                }
            }
            finally {
                stack.pop();
            }
            Table out = new Table(new String[2]);
            int i6 = 0;
            int len2 = hashGroups.length;
            while (i6 < len2) {
                if (hashGroups[i6] != null) {
                    CursorUtil.join_m(hashGroups[i6], keyCount, type, out);
                    hashGroups[i6] = null;
                }
                ++i6;
            }
            String[] curNames = new String[next + 1];
            System.arraycopy(names, 0, curNames, 0, next + 1);
            len2 = out.length();
            prevResult = new Table(curNames, len2);
            int i7 = 1;
            while (i7 <= len2) {
                BaseRecord r = (BaseRecord)out.getMem(i7);
                BaseRecord nr = prevResult.newLast();
                nr.set((BaseRecord)r.getNormalFieldValue(0));
                nr.setNormalFieldValue(next, r.getNormalFieldValue(1));
                ++i7;
            }
            ++next;
        }
        return prevResult;
    }

    public static Sequence filterJoin(Sequence[] srcs, Expression[][] exps, String opt, Context ctx) {
        if (opt.indexOf(109) != -1) {
            int count = srcs.length;
            ICursor[] cursors = new ICursor[count];
            int i = 0;
            while (i < count) {
                cursors[i] = new MemoryCursor(srcs[i]);
                ++i;
            }
            MergeFilterCursor cs = new MergeFilterCursor(cursors, exps, opt, ctx);
            return cs.fetch();
        }
        ComputeStack stack = ctx.getComputeStack();
        Expression[] exps0 = exps[0];
        Sequence seq = srcs[0];
        int s = 1;
        while (s < srcs.length) {
            int k;
            if (seq == null || seq.length() == 0) {
                return new Sequence();
            }
            ArrayList<Expression> expList0 = new ArrayList<Expression>();
            ArrayList<Expression> expList = new ArrayList<Expression>();
            Expression[] curExps = exps[s];
            int i = 0;
            while (i < curExps.length) {
                if (curExps[i] != null) {
                    expList0.add(exps0[i]);
                    expList.add(curExps[i]);
                }
                ++i;
            }
            int keyCount = expList0.size();
            Expression[] curExps0 = new Expression[keyCount];
            curExps = new Expression[keyCount];
            expList0.toArray(curExps0);
            expList.toArray(curExps);
            Sequence result = new Sequence(seq.length());
            Sequence curSeq = srcs[s];
            Current current = new Current(curSeq);
            stack.push(current);
            int len = curSeq.length();
            HashArraySet set = new HashArraySet(len);
            try {
                int i2 = 1;
                while (i2 <= len) {
                    Object[] keys = new Object[keyCount];
                    current.setCurrent(i2);
                    k = 0;
                    while (k < keyCount) {
                        keys[k] = curExps[k].calculate(ctx);
                        ++k;
                    }
                    set.put(keys);
                    ++i2;
                }
            }
            finally {
                stack.pop();
            }
            len = seq.length();
            Object[] keys = new Object[keyCount];
            current = new Current(seq);
            stack.push(current);
            try {
                int i3;
                if (opt.indexOf(105) != -1) {
                    i3 = 1;
                    while (i3 <= len) {
                        current.setCurrent(i3);
                        k = 0;
                        while (k < keyCount) {
                            keys[k] = curExps0[k].calculate(ctx);
                            ++k;
                        }
                        if (set.contains(keys)) {
                            result.add(seq.getMem(i3));
                        }
                        ++i3;
                    }
                } else {
                    i3 = 1;
                    while (i3 <= len) {
                        current.setCurrent(i3);
                        k = 0;
                        while (k < keyCount) {
                            keys[k] = curExps0[k].calculate(ctx);
                            ++k;
                        }
                        if (!set.contains(keys)) {
                            result.add(seq.getMem(i3));
                        }
                        ++i3;
                    }
                }
            }
            finally {
                stack.pop();
            }
            seq = result;
            ++s;
        }
        return seq;
    }

    public static ICursor joinx(ICursor[] cursors, String[] names, Expression[][] exps, String opt, Context ctx) {
        boolean isPJoin = false;
        boolean isIsect = false;
        boolean isDiff = false;
        boolean isXJoin = false;
        if (opt != null) {
            boolean bl = isXJoin = opt.indexOf(120) != -1;
            if (opt.indexOf(112) != -1) {
                isPJoin = true;
            } else if (opt.indexOf(105) != -1) {
                isIsect = true;
            } else if (opt.indexOf(100) != -1) {
                isDiff = true;
            }
        }
        int count = cursors.length;
        boolean isCluster = true;
        boolean isMultipath = false;
        int pathCount = 1;
        int i = 0;
        while (i < count) {
            if (cursors[i] instanceof IMultipath) {
                if (i == 0) {
                    isMultipath = true;
                    pathCount = ((IMultipath)((Object)cursors[i])).getPathCount();
                } else if (pathCount != ((IMultipath)((Object)cursors[i])).getPathCount()) {
                    isMultipath = false;
                }
            } else {
                isMultipath = false;
            }
            if (!(cursors[i] instanceof ClusterCursor)) {
                isCluster = false;
            }
            ++i;
        }
        if (isCluster) {
            ClusterCursor[] tmp = new ClusterCursor[count];
            System.arraycopy(cursors, 0, tmp, 0, count);
            return ClusterCursor.joinx(tmp, exps, names, opt, ctx);
        }
        if (isMultipath && pathCount > 1) {
            ICursor[] result = new ICursor[pathCount];
            ICursor[][] multiCursors = new ICursor[count][];
            int i2 = 0;
            while (i2 < count) {
                IMultipath multipath = (IMultipath)((Object)cursors[i2]);
                multiCursors[i2] = multipath.getParallelCursors();
                ++i2;
            }
            i2 = 0;
            while (i2 < pathCount) {
                Expression[][] tmpExps;
                ICursor[] curs;
                if (isPJoin) {
                    curs = new ICursor[count];
                    int c = 0;
                    while (c < count) {
                        curs[c] = multiCursors[c][i2];
                        ++c;
                    }
                    result[i2] = new PJoinCursor(curs, names);
                } else if (isIsect || isDiff) {
                    curs = new ICursor[count];
                    int c = 0;
                    while (c < count) {
                        curs[c] = multiCursors[c][i2];
                        ++c;
                    }
                    Context tmpCtx = ctx.newComputeContext();
                    tmpExps = Operation.dupExpressions(exps, tmpCtx);
                    result[i2] = new MergeFilterCursor(curs, tmpExps, opt, tmpCtx);
                } else if (count == 2 && exps[0].length == 1) {
                    Context tmpCtx = ctx.newComputeContext();
                    Expression exp1 = Operation.dupExpression(exps[0][0], tmpCtx);
                    Expression exp2 = Operation.dupExpression(exps[1][0], tmpCtx);
                    result[i2] = isXJoin ? new JoinmCursor(multiCursors[0][i2], exp1, multiCursors[1][i2], exp2, names, opt, tmpCtx) : new JoinxCursor2(multiCursors[0][i2], exp1, multiCursors[1][i2], exp2, names, opt, tmpCtx);
                } else {
                    curs = new ICursor[count];
                    int c = 0;
                    while (c < count) {
                        curs[c] = multiCursors[c][i2];
                        ++c;
                    }
                    Context tmpCtx = ctx.newComputeContext();
                    tmpExps = Operation.dupExpressions(exps, tmpCtx);
                    result[i2] = new JoinxCursor(curs, tmpExps, names, opt, tmpCtx);
                }
                ++i2;
            }
            return new MultipathCursors(result, ctx);
        }
        if (isPJoin) {
            return new PJoinCursor(cursors, names);
        }
        if (isIsect || isDiff) {
            return new MergeFilterCursor(cursors, exps, opt, ctx);
        }
        if (count == 2 && exps[0].length == 1) {
            if (isXJoin) {
                return new JoinmCursor(cursors[0], exps[0][0], cursors[1], exps[1][0], names, opt, ctx);
            }
            return new JoinxCursor2(cursors[0], exps[0][0], cursors[1], exps[1][0], names, opt, ctx);
        }
        return new JoinxCursor(cursors, exps, names, opt, ctx);
    }

    public static Sequence joinx(Sequence seq, Expression[][] fields, Object[] fileTable, Expression[][] keys, Expression[][] exps, String[][] expNames, String fname, Context ctx, String option) {
        if (seq.length() == 0) {
            return null;
        }
        boolean hasC = option != null && option.indexOf(99) != -1;
        boolean hasNewExps = false;
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(seq);
        int len = seq.length();
        int fileCount = fileTable.length;
        Sequence[] seqs = new Sequence[fileCount];
        int i = 0;
        while (i < fileCount) {
            if (exps[i] != null && exps[i].length > 0) {
                hasNewExps = true;
            }
            Expression[] curExps = fields[i];
            if (fileTable[i] != null) {
                int pkCount = curExps.length;
                Object fileOrTable = fileTable[i];
                ColPhyTable table = null;
                BFileReader reader = null;
                Sequence pkSeq = new Sequence();
                String[] refFields = null;
                if (fileOrTable instanceof ColPhyTable) {
                    table = (ColPhyTable)fileOrTable;
                    int fcount = keys[i].length;
                    ArrayList<String> fieldList = new ArrayList<String>(fcount);
                    int j = 0;
                    while (j < fcount) {
                        fieldList.add(keys[i][j].toString());
                        ++j;
                    }
                    Expression[] expressionArray = exps[i];
                    int n = expressionArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Expression exp = expressionArray[n2];
                        exp.getUsedFields(ctx, fieldList);
                        ++n2;
                    }
                    refFields = new String[fieldList.size()];
                    fieldList.toArray(refFields);
                } else if (fileOrTable instanceof FileObject) {
                    reader = new BFileReader((FileObject)fileOrTable);
                }
                stack.push(current);
                try {
                    int j = 1;
                    while (j <= len) {
                        current.setCurrent(j);
                        Sequence temp = new Sequence();
                        if (pkCount > 1) {
                            int f = 0;
                            while (f < pkCount) {
                                temp.add(curExps[f].calculate(ctx));
                                ++f;
                            }
                        } else {
                            temp.add(curExps[0].calculate(ctx));
                        }
                        pkSeq.add(temp);
                        ++j;
                    }
                }
                finally {
                    stack.pop();
                }
                Sequence valueSeq = null;
                if (!hasC || i != 0) {
                    pkSeq.sort("o");
                }
                try {
                    if (table != null) {
                        valueSeq = table.finds(pkSeq, refFields);
                    } else if (fileOrTable instanceof FileObject) {
                        refFields = new String[pkCount];
                        int j = 0;
                        while (j < pkCount) {
                            refFields[j] = keys[i][j].toString();
                            ++j;
                        }
                        reader.open();
                        valueSeq = reader.iselectFields(refFields, pkSeq, null, null, ctx).fetch();
                        reader.close();
                    }
                }
                catch (IOException e) {
                    throw new RQException(e);
                }
                seqs[i] = valueSeq;
            }
            ++i;
        }
        boolean isIsect = false;
        boolean isDiff = false;
        if (!hasNewExps && option != null) {
            if (option.indexOf(105) != -1) {
                isIsect = true;
            } else if (option.indexOf(100) != -1) {
                isDiff = true;
            }
        }
        Operation op = isIsect ? new FilterJoin(null, fields, seqs, keys, option) : (isDiff ? new DiffJoin(null, fields, seqs, keys, option) : new Join(null, fname, fields, seqs, keys, exps, expNames, option));
        return ((Operation)op).process(seq, ctx);
    }

    public static void hashSwitch(Sequence data, String fkName, Sequence code, Expression exp, String opt, Context ctx) {
        if (data.length() == 0) {
            return;
        }
        boolean isIsect = false;
        boolean isDiff = false;
        boolean isLeft = false;
        if (opt != null) {
            if (opt.indexOf(105) != -1) {
                isIsect = true;
            } else if (opt.indexOf(100) != -1) {
                isDiff = true;
            } else if (opt.indexOf(49) != -1) {
                isLeft = true;
            }
        }
        int col = -1;
        BaseRecord prevRecord = null;
        if (exp == null || !(exp.getHome() instanceof CurrentSeq)) {
            IndexTable indexTable = code.getIndexTable(exp, ctx);
            if (indexTable == null) {
                indexTable = code.newIndexTable(exp, ctx);
            }
            if (isDiff) {
                int i = 1;
                int len = data.length();
                while (i <= len) {
                    Object obj = data.getMem(i);
                    if (obj instanceof BaseRecord) {
                        Object key;
                        BaseRecord cur = (BaseRecord)obj;
                        if (prevRecord == null || !prevRecord.isSameDataStruct(cur)) {
                            col = cur.getFieldIndex(fkName);
                            if (col < 0) {
                                MessageManager mm = EngineMessage.get();
                                throw new RQException(String.valueOf(fkName) + mm.getMessage("ds.fieldNotExist"));
                            }
                            prevRecord = cur;
                        }
                        if (indexTable.find(key = cur.getNormalFieldValue(col)) != null) {
                            cur.setNormalFieldValue(col, null);
                        }
                    } else if (obj != null) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(mm.getMessage("engine.needPmt"));
                    }
                    ++i;
                }
            } else if (isLeft) {
                int[] pks;
                DataStruct codeDs = code.dataStruct();
                if (codeDs == null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("engine.needPurePmt"));
                }
                int keySeq = -1;
                if (exp != null) {
                    keySeq = codeDs.getFieldIndex(exp.getIdentifierName());
                }
                if (keySeq == -1 && (pks = codeDs.getPKIndex()) != null && pks.length == 1) {
                    keySeq = pks[0];
                }
                if (keySeq == -1) {
                    keySeq = 0;
                }
                int i = 1;
                int len = data.length();
                while (i <= len) {
                    Object obj = data.getMem(i);
                    if (obj instanceof BaseRecord) {
                        Object key;
                        Object p;
                        BaseRecord cur = (BaseRecord)obj;
                        if (prevRecord == null || !prevRecord.isSameDataStruct(cur)) {
                            col = cur.getFieldIndex(fkName);
                            if (col < 0) {
                                MessageManager mm = EngineMessage.get();
                                throw new RQException(String.valueOf(fkName) + mm.getMessage("ds.fieldNotExist"));
                            }
                            prevRecord = cur;
                        }
                        if ((p = indexTable.find(key = cur.getNormalFieldValue(col))) != null) {
                            cur.setNormalFieldValue(col, p);
                        } else {
                            Record record = new Record(codeDs);
                            record.setNormalFieldValue(keySeq, key);
                            cur.setNormalFieldValue(col, record);
                        }
                    } else if (obj != null) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(mm.getMessage("engine.needPmt"));
                    }
                    ++i;
                }
            } else {
                int i = 1;
                int len = data.length();
                while (i <= len) {
                    Object obj = data.getMem(i);
                    if (obj instanceof BaseRecord) {
                        BaseRecord cur = (BaseRecord)obj;
                        if (prevRecord == null || !prevRecord.isSameDataStruct(cur)) {
                            col = cur.getFieldIndex(fkName);
                            if (col < 0) {
                                MessageManager mm = EngineMessage.get();
                                throw new RQException(String.valueOf(fkName) + mm.getMessage("ds.fieldNotExist"));
                            }
                            prevRecord = cur;
                        }
                        Object key = cur.getNormalFieldValue(col);
                        Object p = indexTable.find(key);
                        cur.setNormalFieldValue(col, p);
                    } else if (obj != null) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(mm.getMessage("engine.needPmt"));
                    }
                    ++i;
                }
            }
        } else {
            int codeLen = code.length();
            int i = 1;
            int len = data.length();
            while (i <= len) {
                Object obj = data.getMem(i);
                if (obj instanceof BaseRecord) {
                    Object val;
                    BaseRecord cur = (BaseRecord)obj;
                    if (prevRecord == null || !prevRecord.isSameDataStruct(cur)) {
                        col = cur.getFieldIndex(fkName);
                        if (col < 0) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException(String.valueOf(fkName) + mm.getMessage("ds.fieldNotExist"));
                        }
                        prevRecord = cur;
                    }
                    if ((val = cur.getNormalFieldValue(col)) instanceof Number) {
                        int seq = ((Number)val).intValue();
                        if (isDiff) {
                            if (seq > 0 && seq <= codeLen) {
                                cur.setNormalFieldValue(col, null);
                            }
                        } else if (seq > 0 && seq <= codeLen) {
                            cur.setNormalFieldValue(col, code.getMem(seq));
                        } else {
                            cur.setNormalFieldValue(col, null);
                        }
                    }
                } else if (obj != null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("engine.needPmt"));
                }
                ++i;
            }
        }
        if (isIsect || isDiff) {
            data.deleteNullFieldRecord(fkName);
        }
    }

    public static Sequence tryFetch(ICursor cursor) {
        Runtime rt = Runtime.getRuntime();
        EnvUtil.runGC(rt);
        long usedMemory = rt.totalMemory() - rt.freeMemory();
        int baseCount = ICursor.INITSIZE;
        Sequence seq = cursor.fetch(baseCount);
        if (seq == null || seq.length() == 0) {
            return null;
        }
        usedMemory = rt.totalMemory() - rt.freeMemory() - usedMemory;
        int fcount = 1;
        Object obj = seq.get(1);
        if (obj instanceof BaseRecord) {
            fcount = ((BaseRecord)obj).getFieldCount();
        }
        obj = null;
        long size = seq.length() * fcount * 48;
        if (size < usedMemory) {
            size = usedMemory;
        }
        while (EnvUtil.memoryTest(rt, seq, size)) {
            Sequence seq2 = cursor.fetch(baseCount);
            if (seq2 == null || seq2.length() == 0) break;
            seq = seq.append(seq2);
        }
        return seq;
    }

    public static ICursor sortx(ICursor cursor, Expression[] exps, Context ctx, int capacity, String opt) {
        Sequence table;
        int fcount = exps.length;
        ArrayList<BFileCursor> cursorList = new ArrayList<BFileCursor>();
        if (capacity <= 1) {
            table = CursorUtil.tryFetch(cursor);
            if (table != null) {
                capacity = table.length();
            }
        } else {
            table = cursor.fetch(capacity);
        }
        MessageManager mm = EngineMessage.get();
        String msg = mm.getMessage("engine.createTmpFile");
        Expression[] tempExps = (Expression[])exps.clone();
        while (table != null && table.length() > 0) {
            int i = 0;
            int len = tempExps.length;
            while (i < len) {
                tempExps[i] = exps[i].newExpression(ctx);
                ++i;
            }
            Sequence sequence = fcount == 1 ? table.sort(tempExps[0], null, opt, ctx) : table.sort(tempExps, null, opt, ctx);
            table = null;
            int i2 = 0;
            int len2 = tempExps.length;
            while (i2 < len2) {
                tempExps[i2] = null;
                ++i2;
            }
            FileObject fo = FileObject.createTempFileObject();
            Logger.info(String.valueOf(msg) + fo.getFileName());
            fo.exportSeries(sequence, "b", null);
            sequence = null;
            BFileCursor bfc = new BFileCursor(fo, null, "x", ctx);
            cursorList.add(bfc);
            table = cursor.fetch(capacity);
        }
        int size = cursorList.size();
        if (size == 0) {
            return new MemoryCursor(null);
        }
        if (size == 1) {
            return (ICursor)cursorList.get(0);
        }
        int bufSize = Env.getMergeFileBufSize(size);
        int i = 0;
        while (i < size) {
            BFileCursor bfc = (BFileCursor)cursorList.get(i);
            bfc.setFileBufferSize(bufSize);
            ++i;
        }
        ICursor[] cursors = new ICursor[size];
        cursorList.toArray(cursors);
        return CursorUtil.merge(cursors, exps, opt, ctx);
    }

    /*
     * Unable to fully structure code
     */
    public static ICursor sortx(ICursor cursor, Expression[] exps, Expression gexp, Context ctx, String opt) {
        block9: {
            fetchCount = ICursor.getInitSize();
            seq = cursor.fetch(fetchCount);
            if (seq == null || seq.length() == 0) {
                return null;
            }
            ds = seq.dataStruct();
            if (ds == null) {
                mm = EngineMessage.get();
                throw new RQException(mm.getMessage("engine.needPurePmt"));
            }
            map = new TreeMap<Object, BFileWriter>();
            mm = EngineMessage.get();
            msg = mm.getMessage("engine.createTmpFile");
            try {
                do {
                    groups = seq.group(gexp, null, ctx);
                    gcount = groups.length();
                    i = 1;
                    while (i <= gcount) {
                        group = (Sequence)groups.getMem(i);
                        gval = group.calc(1, gexp, ctx);
                        writer = (BFileWriter)map.get(gval);
                        if (writer == null) {
                            fo = FileObject.createTempFileObject();
                            Logger.info(String.valueOf(msg) + fo.getFileName());
                            writer = new BFileWriter(fo, null);
                            writer.prepareWrite(ds, false);
                            map.put(gval, writer);
                        }
                        writer.write(group);
                        ++i;
                    }
                    seq = null;
                    groups = null;
                } while ((seq = cursor.fetch(fetchCount)) != null && seq.length() != 0);
                break block9;
            }
            catch (IOException e) {
                writers = map.values();
                ** for (writer : writers)
            }
lbl-1000:
            // 1 sources

            {
                writer.close();
                writer.getFile().delete();
                continue;
            }
lbl42:
            // 1 sources

            throw new RQException(e);
        }
        size = map.size();
        files = new FileObject[size];
        index = 0;
        writers = map.values();
        for (BFileWriter writer : writers) {
            writer.close();
            files[index++] = writer.getFile();
        }
        return new SortxCursor(files, exps, ds, ctx);
    }

    public static Sequence diff(Sequence seq1, Sequence seq2) {
        int len2 = seq2.length();
        int INIT_GROUPSIZE = HashUtil.getInitGroupSize();
        HashUtil hashUtil = new HashUtil((int)((double)len2 * 1.2));
        ListBase1[] groups = new ListBase1[hashUtil.getCapacity()];
        int i = 1;
        while (i <= len2) {
            Object val = seq2.getMem(i);
            int hash = hashUtil.hashCode(val);
            if (groups[hash] == null) {
                groups[hash] = new ListBase1(INIT_GROUPSIZE);
                groups[hash].add(val);
            } else {
                int index = groups[hash].binarySearch(val);
                if (index < 1) {
                    groups[hash].add(-index, val);
                } else {
                    groups[hash].add(index, val);
                }
            }
            ++i;
        }
        int len1 = seq1.length();
        Sequence result = new Sequence(len1);
        int i2 = 1;
        while (i2 <= len1) {
            Object val = seq1.getMem(i2);
            int hash = hashUtil.hashCode(val);
            if (groups[hash] == null) {
                result.add(val);
            } else {
                int index = groups[hash].binarySearch(val);
                if (index < 1) {
                    result.add(val);
                } else {
                    groups[hash].remove(index);
                }
            }
            ++i2;
        }
        return result;
    }

    public static Sequence diff(Sequence seq1, Sequence seq2, Expression[] exps, Context ctx) {
        if (exps == null) {
            return CursorUtil.diff(seq1, seq2);
        }
        int keyCount = exps.length;
        int len2 = seq2.length();
        int INIT_GROUPSIZE = HashUtil.getInitGroupSize();
        HashUtil hashUtil = new HashUtil((int)((double)len2 * 1.2));
        ListBase1[] groups = new ListBase1[hashUtil.getCapacity()];
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(seq2);
        stack.push(current);
        try {
            int i = 1;
            while (i <= len2) {
                Object[] keys = new Object[keyCount];
                current.setCurrent(i);
                int c = 0;
                while (c < keyCount) {
                    keys[c] = exps[c].calculate(ctx);
                    ++c;
                }
                int hash = hashUtil.hashCode(keys, keyCount);
                if (groups[hash] == null) {
                    groups[hash] = new ListBase1(INIT_GROUPSIZE);
                    groups[hash].add(keys);
                } else {
                    int index = HashUtil.bsearch_a(groups[hash], keys, keyCount);
                    if (index < 1) {
                        groups[hash].add(-index, keys);
                    } else {
                        groups[hash].add(index, keys);
                    }
                }
                ++i;
            }
        }
        finally {
            stack.pop();
        }
        int len1 = seq1.length();
        Sequence result = new Sequence(len1);
        current = new Current(seq1);
        stack.push(current);
        try {
            int i = 1;
            while (i <= len1) {
                Object[] keys = new Object[keyCount];
                current.setCurrent(i);
                int c = 0;
                while (c < keyCount) {
                    keys[c] = exps[c].calculate(ctx);
                    ++c;
                }
                int hash = hashUtil.hashCode(keys, keyCount);
                if (groups[hash] == null) {
                    result.add(seq1.getMem(i));
                } else {
                    int index = HashUtil.bsearch_a(groups[hash], keys, keyCount);
                    if (index < 1) {
                        result.add(seq1.getMem(i));
                    } else {
                        groups[hash].remove(index);
                    }
                }
                ++i;
            }
        }
        finally {
            stack.pop();
        }
        return result;
    }

    public static Sequence union(Sequence seq1, Sequence seq2) {
        IArray mems1 = seq1.getMems();
        int len1 = mems1.size();
        int INIT_GROUPSIZE = HashUtil.getInitGroupSize();
        HashUtil hashUtil = new HashUtil((int)((double)len1 * 1.2));
        ListBase1[] groups = new ListBase1[hashUtil.getCapacity()];
        int i = 1;
        while (i <= len1) {
            Object val = mems1.get(i);
            int hash = hashUtil.hashCode(val);
            if (groups[hash] == null) {
                groups[hash] = new ListBase1(INIT_GROUPSIZE);
                groups[hash].add(val);
            } else {
                int index = groups[hash].binarySearch(val);
                if (index < 1) {
                    groups[hash].add(-index, val);
                } else {
                    groups[hash].add(index, val);
                }
            }
            ++i;
        }
        IArray mems2 = seq2.getMems();
        int len2 = mems2.size();
        Sequence result = new Sequence(len1 + len2);
        result.addAll(seq1);
        int i2 = 1;
        while (i2 <= len2) {
            Object val = mems2.get(i2);
            int hash = hashUtil.hashCode(val);
            if (groups[hash] == null) {
                result.add(val);
            } else {
                int index = groups[hash].binarySearch(val);
                if (index < 1) {
                    result.add(val);
                } else {
                    groups[hash].remove(index);
                }
            }
            ++i2;
        }
        return result;
    }

    public static Sequence union(Sequence seq1, Sequence seq2, Expression[] exps, Context ctx) {
        if (exps == null) {
            return CursorUtil.union(seq1, seq2);
        }
        int keyCount = exps.length;
        IArray mems1 = seq1.getMems();
        int len1 = mems1.size();
        int INIT_GROUPSIZE = HashUtil.getInitGroupSize();
        HashUtil hashUtil = new HashUtil((int)((double)len1 * 1.2));
        ListBase1[] groups = new ListBase1[hashUtil.getCapacity()];
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(seq1);
        stack.push(current);
        try {
            int i = 1;
            while (i <= len1) {
                Object[] keys = new Object[keyCount];
                current.setCurrent(i);
                int c = 0;
                while (c < keyCount) {
                    keys[c] = exps[c].calculate(ctx);
                    ++c;
                }
                int hash = hashUtil.hashCode(keys, keyCount);
                if (groups[hash] == null) {
                    groups[hash] = new ListBase1(INIT_GROUPSIZE);
                    groups[hash].add(keys);
                } else {
                    int index = HashUtil.bsearch_a(groups[hash], keys, keyCount);
                    if (index < 1) {
                        groups[hash].add(-index, keys);
                    } else {
                        groups[hash].add(index, keys);
                    }
                }
                ++i;
            }
        }
        finally {
            stack.pop();
        }
        IArray mems2 = seq2.getMems();
        int len2 = mems2.size();
        Sequence result = new Sequence(len1 + len2);
        result.addAll(seq1);
        current = new Current(seq2);
        stack.push(current);
        try {
            int i = 1;
            while (i <= len2) {
                Object[] keys = new Object[keyCount];
                current.setCurrent(i);
                int c = 0;
                while (c < keyCount) {
                    keys[c] = exps[c].calculate(ctx);
                    ++c;
                }
                int hash = hashUtil.hashCode(keys, keyCount);
                if (groups[hash] == null) {
                    result.add(mems2.get(i));
                } else {
                    int index = HashUtil.bsearch_a(groups[hash], keys, keyCount);
                    if (index < 1) {
                        result.add(mems2.get(i));
                    } else {
                        groups[hash].remove(index);
                    }
                }
                ++i;
            }
        }
        finally {
            stack.pop();
        }
        return result;
    }

    public static Sequence isect(Sequence seq1, Sequence seq2) {
        IArray mems1 = seq1.getMems();
        int len1 = mems1.size();
        IArray mems2 = seq2.getMems();
        int len2 = mems2.size();
        if (len1 < 12 && len2 < 12) {
            Sequence result = new Sequence(len1);
            int i = 1;
            while (i <= len1) {
                Object v1 = mems1.get(i);
                int j = 1;
                while (j <= len2) {
                    if (Variant.isEquals(v1, mems2.get(j))) {
                        result.add(v1);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            return result;
        }
        int INIT_GROUPSIZE = HashUtil.getInitGroupSize();
        HashUtil hashUtil = new HashUtil((int)((double)len2 * 1.2));
        ListBase1[] groups = new ListBase1[hashUtil.getCapacity()];
        int i = 1;
        while (i <= len2) {
            Object val = mems2.get(i);
            int hash = hashUtil.hashCode(val);
            if (groups[hash] == null) {
                groups[hash] = new ListBase1(INIT_GROUPSIZE);
                groups[hash].add(val);
            } else {
                int index = groups[hash].binarySearch(val);
                if (index < 1) {
                    groups[hash].add(-index, val);
                } else {
                    groups[hash].add(index, val);
                }
            }
            ++i;
        }
        Sequence result = new Sequence(len1);
        int i2 = 1;
        while (i2 <= len1) {
            int index;
            Object val = mems1.get(i2);
            int hash = hashUtil.hashCode(val);
            if (groups[hash] != null && (index = groups[hash].binarySearch(val)) > 0) {
                result.add(val);
                groups[hash].remove(index);
            }
            ++i2;
        }
        return result;
    }

    public static Sequence isect(Sequence seq1, Sequence seq2, Expression[] exps, Context ctx) {
        if (exps == null) {
            return CursorUtil.isect(seq1, seq2);
        }
        int keyCount = exps.length;
        IArray mems2 = seq2.getMems();
        int len2 = mems2.size();
        int INIT_GROUPSIZE = HashUtil.getInitGroupSize();
        HashUtil hashUtil = new HashUtil((int)((double)len2 * 1.2));
        ListBase1[] groups = new ListBase1[hashUtil.getCapacity()];
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(seq2);
        stack.push(current);
        try {
            int i = 1;
            while (i <= len2) {
                Object[] keys = new Object[keyCount];
                current.setCurrent(i);
                int c = 0;
                while (c < keyCount) {
                    keys[c] = exps[c].calculate(ctx);
                    ++c;
                }
                int hash = hashUtil.hashCode(keys, keyCount);
                if (groups[hash] == null) {
                    groups[hash] = new ListBase1(INIT_GROUPSIZE);
                    groups[hash].add(keys);
                } else {
                    int index = HashUtil.bsearch_a(groups[hash], keys, keyCount);
                    if (index < 1) {
                        groups[hash].add(-index, keys);
                    } else {
                        groups[hash].add(index, keys);
                    }
                }
                ++i;
            }
        }
        finally {
            stack.pop();
        }
        IArray mems1 = seq1.getMems();
        int len1 = mems1.size();
        Sequence result = new Sequence(len1);
        current = new Current(seq1);
        stack.push(current);
        try {
            int i = 1;
            while (i <= len1) {
                int index;
                Object[] keys = new Object[keyCount];
                current.setCurrent(i);
                int c = 0;
                while (c < keyCount) {
                    keys[c] = exps[c].calculate(ctx);
                    ++c;
                }
                int hash = hashUtil.hashCode(keys, keyCount);
                if (groups[hash] != null && (index = HashUtil.bsearch_a(groups[hash], keys, keyCount)) > 0) {
                    result.add(mems1.get(i));
                    groups[hash].remove(index);
                }
                ++i;
            }
        }
        finally {
            stack.pop();
        }
        return result;
    }

    public static Object top(ICursor cursor, int count, Expression exp, Expression getExp, Context ctx) {
        Sequence src;
        ArrayComparator comparator = new ArrayComparator(1);
        MinHeap heap = new MinHeap(count, comparator);
        while ((src = cursor.fuzzyFetch(ICursor.FETCHCOUNT)) != null && src.length() != 0) {
            if ((src = src.calc(getExp, ctx)).getMem(1) instanceof Sequence) {
                src = src.conj(null);
            }
            Sequence v = src.calc(exp, ctx);
            int i = 1;
            int len = src.length();
            while (i <= len) {
                Object[] vals = new Object[]{v.getMem(i), src.getMem(i)};
                heap.insert(vals);
                ++i;
            }
        }
        Object[] objs = heap.toArray();
        Arrays.sort(objs, comparator);
        int size = objs.length;
        Sequence seq = new Sequence(size);
        int i = 0;
        while (i < size) {
            Object[] tmp = (Object[])objs[i];
            seq.add(tmp[1]);
            ++i;
        }
        return seq;
    }

    public static Sequence xor(Sequence seq1, Sequence seq2) {
        Sequence s1 = CursorUtil.diff(seq1, seq2);
        Sequence s2 = CursorUtil.diff(seq2, seq1);
        s1.addAll(s2);
        return s1;
    }

    public static Sequence xor(Sequence seq1, Sequence seq2, Expression[] exps, Context ctx) {
        Sequence s1 = CursorUtil.diff(seq1, seq2, exps, ctx);
        Sequence s2 = CursorUtil.diff(seq2, seq1, exps, ctx);
        s1.addAll(s2);
        return s1;
    }

    /*
     * Unable to fully structure code
     */
    public static ICursor groupx_g(ICursor cursor, Expression gexp, Expression[] exps, String[] names, Expression[] calcExps, String[] calcNames, String opt, Context ctx) {
        block9: {
            if (cursor instanceof MultipathCursors) {
                return CursorUtil.groupx_g((MultipathCursors)cursor, gexp, exps, names, calcExps, calcNames, ctx);
            }
            fetchCount = ICursor.INITSIZE;
            mm = EngineMessage.get();
            msg = mm.getMessage("engine.createTmpFile");
            map = new TreeMap<Object, BFileWriter>();
            ds = cursor.getDataStruct();
            try {
                while ((seq = cursor.fetch(fetchCount)) != null && seq.length() != 0) {
                    groups = seq.group(gexp, null, ctx);
                    gcount = groups.length();
                    i = 1;
                    while (i <= gcount) {
                        group = (Sequence)groups.getMem(i);
                        gresult = IGroupsResult.instance(exps, names, calcExps, calcNames, ds, null, ctx);
                        gresult.push(group, ctx);
                        result = gresult.getTempResult();
                        gval = group.calc(1, gexp, ctx);
                        writer = (BFileWriter)map.get(gval);
                        if (writer == null) {
                            fo = FileObject.createTempFileObject();
                            Logger.info(String.valueOf(msg) + fo.getFileName());
                            writer = new BFileWriter(fo, null);
                            writer.prepareWrite(gresult.getResultDataStruct(), false);
                            map.put(gval, writer);
                        }
                        writer.write(result);
                        ++i;
                    }
                }
                break block9;
            }
            catch (IOException e) {
                writers = map.values();
                ** for (writer : writers)
            }
lbl-1000:
            // 1 sources

            {
                writer.close();
                writer.getFile().delete();
                continue;
            }
lbl39:
            // 1 sources

            throw new RQException(e);
        }
        size = map.size();
        if (size == 0) {
            return null;
        }
        files = new FileObject[size];
        index = 0;
        writers = map.values();
        for (BFileWriter writer : writers) {
            writer.close();
            files[index++] = writer.getFile();
        }
        return new GroupxnCursor(files, exps, names, calcExps, calcNames, ctx);
    }

    private static ICursor groupx_g(MultipathCursors mcs, Expression gexp, Expression[] exps, String[] names, Expression[] calcExps, String[] calcNames, Context ctx) {
        int fetchCount = ICursor.INITSIZE;
        ICursor[] cursors = mcs.getParallelCursors();
        int cursorCount = cursors.length;
        TreeMap<Object, BFileWriter> map = new TreeMap<Object, BFileWriter>();
        ThreadPool pool = ThreadPool.newInstance(cursorCount);
        RuntimeException exception = null;
        try {
            GroupxJob[] jobs = new GroupxJob[cursorCount];
            int i = 0;
            while (i < cursorCount) {
                Context tmpCtx = ctx.newComputeContext();
                Expression tmpGroupExp = Operation.dupExpression(gexp, tmpCtx);
                Expression[] tmpExps = Operation.dupExpressions(exps, tmpCtx);
                Expression[] tmpCalcExps = Operation.dupExpressions(calcExps, tmpCtx);
                jobs[i] = new GroupxJob(cursors[i], tmpGroupExp, tmpExps, names, tmpCalcExps, calcNames, tmpCtx, fetchCount, map);
                pool.submit(jobs[i]);
                ++i;
            }
            i = 0;
            while (i < cursorCount) {
                try {
                    jobs[i].join();
                }
                catch (RuntimeException e) {
                    exception = e;
                }
                ++i;
            }
        }
        finally {
            pool.shutdown();
        }
        if (exception != null) {
            Collection writers = map.values();
            for (BFileWriter writer : writers) {
                writer.close();
                writer.getFile().delete();
            }
            if (exception instanceof RQException) {
                throw (RQException)exception;
            }
            throw new RQException(exception);
        }
        int size = map.size();
        if (size == 0) {
            return null;
        }
        FileObject[] files = new FileObject[size];
        int index = 0;
        Collection writers = map.values();
        for (BFileWriter writer : writers) {
            writer.close();
            files[index++] = writer.getFile();
        }
        return new GroupxnCursor(files, exps, names, calcExps, calcNames, ctx);
    }

    public static Sequence group_n(Sequence seq, int capacity) {
        IArray mems = seq.getMems();
        int size = mems.size();
        Sequence result = new Sequence(size / 4);
        IArray resultMems = result.getMems();
        int len = 0;
        int i = 1;
        while (i <= size) {
            BaseRecord r = (BaseRecord)mems.get(i);
            Object value = r.getNormalFieldValue(0);
            if (!(value instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("group: " + mm.getMessage("engine.needIntExp"));
            }
            int index = ((Number)value).intValue() / capacity + 1;
            if (index > len) {
                resultMems.ensureCapacity(index);
                int j = len;
                while (j < index) {
                    resultMems.add(new Sequence(7));
                    ++j;
                }
                len = index;
            } else if (index < 1) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(String.valueOf(index) + mm.getMessage("engine.indexOutofBound"));
            }
            Sequence group = (Sequence)resultMems.get(index);
            group.add(r);
            ++i;
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public static ICursor groupx_n(ICursor cursor, Expression[] exps, String[] names, Expression[] calcExps, String[] calcNames, Context ctx, int capacity) {
        block10: {
            if (cursor instanceof MultipathCursors) {
                return CursorUtil.groupx_n((MultipathCursors)cursor, exps, names, calcExps, calcNames, ctx, capacity);
            }
            fetchCount = ICursor.INITSIZE;
            mm = EngineMessage.get();
            msg = mm.getMessage("engine.createTmpFile");
            map = new TreeMap<Integer, BFileWriter>();
            ds = cursor.getDataStruct();
            try {
                while ((seq = cursor.fetch(fetchCount)) != null && seq.length() != 0) {
                    gresult = IGroupsResult.instance(exps, names, calcExps, calcNames, ds, null, ctx);
                    gresult.push(seq, ctx);
                    seq = gresult.getTempResult();
                    groups = CursorUtil.group_n(seq, capacity);
                    gcount = groups.length();
                    i = 1;
                    while (i <= gcount) {
                        group = (Sequence)groups.getMem(i);
                        if (group.length() != 0) {
                            gval = new Integer(i);
                            writer = (BFileWriter)map.get(gval);
                            if (writer == null) {
                                fo = FileObject.createTempFileObject();
                                Logger.info(String.valueOf(msg) + fo.getFileName());
                                writer = new BFileWriter(fo, null);
                                writer.prepareWrite(gresult.getResultDataStruct(), false);
                                map.put(gval, writer);
                            }
                            writer.write(group);
                        }
                        ++i;
                    }
                }
                break block10;
            }
            catch (IOException e) {
                writers = map.values();
                ** for (writer : writers)
            }
lbl-1000:
            // 1 sources

            {
                writer.close();
                writer.getFile().delete();
                continue;
            }
lbl40:
            // 1 sources

            throw new RQException(e);
        }
        size = map.size();
        if (size == 0) {
            return null;
        }
        files = new FileObject[size];
        index = 0;
        writers = map.values();
        for (BFileWriter writer : writers) {
            writer.close();
            files[index++] = writer.getFile();
        }
        return new GroupxnCursor(files, exps, names, calcExps, calcNames, ctx);
    }

    private static ICursor groupx_n(MultipathCursors mcs, Expression[] exps, String[] names, Expression[] calcExps, String[] calcNames, Context ctx, int capacity) {
        ICursor[] cursors = mcs.getParallelCursors();
        int cursorCount = cursors.length;
        TreeMap<Object, BFileWriter> map = new TreeMap<Object, BFileWriter>();
        int fetchCount = capacity / cursorCount;
        ThreadPool pool = ThreadPool.newInstance(cursorCount);
        RuntimeException exception = null;
        try {
            GroupxJob[] jobs = new GroupxJob[cursorCount];
            int i = 0;
            while (i < cursorCount) {
                Context tmpCtx = ctx.newComputeContext();
                Expression[] tmpExps = Operation.dupExpressions(exps, tmpCtx);
                Expression[] tmpCalcExps = Operation.dupExpressions(calcExps, tmpCtx);
                jobs[i] = new GroupxJob(cursors[i], tmpExps, names, tmpCalcExps, calcNames, tmpCtx, capacity, fetchCount, map);
                pool.submit(jobs[i]);
                ++i;
            }
            i = 0;
            while (i < cursorCount) {
                try {
                    jobs[i].join();
                }
                catch (RuntimeException e) {
                    exception = e;
                }
                ++i;
            }
        }
        finally {
            pool.shutdown();
        }
        if (exception != null) {
            Collection writers = map.values();
            for (BFileWriter writer : writers) {
                writer.close();
                writer.getFile().delete();
            }
            if (exception instanceof RQException) {
                throw (RQException)exception;
            }
            throw new RQException(exception);
        }
        int size = map.size();
        if (size == 0) {
            return null;
        }
        FileObject[] files = new FileObject[size];
        int index = 0;
        Collection writers = map.values();
        for (BFileWriter writer : writers) {
            writer.close();
            files[index++] = writer.getFile();
        }
        return new GroupxnCursor(files, exps, names, calcExps, calcNames, ctx);
    }

    public static PhyTable getTableMetaData(ICursor cs) {
        if (cs instanceof IDWCursor) {
            return ((IDWCursor)cs).getTableMetaData();
        }
        if (cs instanceof MultipathCursors) {
            MultipathCursors mcs = (MultipathCursors)cs;
            ICursor[] cursors = mcs.getCursors();
            return CursorUtil.getTableMetaData(cursors[0]);
        }
        if (cs instanceof MergeCursor2) {
            MergeCursor2 mc = (MergeCursor2)cs;
            return CursorUtil.getTableMetaData(mc.getCursor1());
        }
        return null;
    }

    public static ICursor merge(ICursor[] cursors, Expression[] exps, String opt, Context ctx) {
        DataStruct ds = null;
        if (opt == null || opt.indexOf(117) == -1 && opt.indexOf(105) == -1 && opt.indexOf(100) == -1 && opt.indexOf(120) == -1) {
            ds = CursorUtil.getDataStruct(cursors[0]);
            int i = 1;
            int count = cursors.length;
            while (ds != null && i < count) {
                if (!ds.isCompatible(CursorUtil.getDataStruct(cursors[i]))) {
                    ds = null;
                    break;
                }
                ++i;
            }
        }
        int[] fields = null;
        if (ds != null) {
            if (exps == null) {
                String[] sortFields = cursors[0].getSortFields();
                if (sortFields != null) {
                    int fcount = sortFields.length;
                    fields = new int[fcount];
                    int f = 0;
                    while (f < fcount) {
                        fields[f] = ds.getFieldIndex(sortFields[f]);
                        ++f;
                    }
                } else {
                    int fcount = ds.getFieldCount();
                    fields = new int[fcount];
                    int f = 0;
                    while (f < fcount) {
                        fields[f] = f;
                        ++f;
                    }
                }
            } else {
                int fcount = exps.length;
                fields = new int[fcount];
                int f = 0;
                while (f < fcount) {
                    fields[f] = exps[f].getFieldIndex(ds);
                    if (fields[f] < 0) {
                        fields = null;
                        break;
                    }
                    ++f;
                }
            }
        } else if (exps == null) {
            Expression exp = new Expression("~.v()");
            exps = new Expression[]{exp};
        }
        if (fields != null) {
            if (cursors.length == 2) {
                return new MergeCursor2(cursors[0], cursors[1], fields, opt, ctx);
            }
            return new MergeCursor(cursors, fields, opt, ctx);
        }
        return new MergesCursor(cursors, exps, opt, ctx);
    }

    public static ICursor cursor(Sequence data, int pathCount, String opt, Context ctx) {
        boolean psign;
        int len = data.length();
        boolean bl = psign = opt != null && opt.indexOf(112) != -1;
        if (pathCount > 1 && pathCount < len) {
            if (ctx == null) {
                ctx = new Context();
            }
            int blockSize = len / pathCount;
            ICursor[] cursors = new ICursor[pathCount];
            int start = 1;
            int i = 1;
            while (i <= pathCount) {
                int end = i == pathCount ? len + 1 : blockSize * i + 1;
                if (start >= end) {
                    cursors[i - 1] = data.cursor(start, start);
                } else {
                    if (psign) {
                        BaseRecord record = (BaseRecord)data.get(end - 1);
                        Object value = record.getNormalFieldValue(0);
                        int next = end;
                        end = len + 1;
                        while (next <= len) {
                            record = (BaseRecord)data.get(next);
                            if (!Variant.isEquals(record.getNormalFieldValue(0), value)) {
                                end = next;
                                break;
                            }
                            ++next;
                        }
                    }
                    cursors[i - 1] = data.cursor(start, end);
                    start = end;
                }
                ++i;
            }
            return new MultipathCursors(cursors, ctx);
        }
        return data.cursor();
    }

    public static ICursor cursor(Sequence data, int path, int pathCount, String opt, Context ctx) {
        int len = data.length();
        if (opt == null || opt.indexOf(112) == -1) {
            int end;
            int start;
            int blockSize = len / pathCount;
            if (path == pathCount) {
                start = blockSize * (path - 1) + 1;
                end = len + 1;
            } else {
                start = blockSize * (path - 1) + 1;
                end = blockSize * path + 1;
            }
            return data.cursor(start, end);
        }
        ICursor cs = null;
        if (pathCount > 1 && pathCount < len) {
            if (ctx == null) {
                ctx = new Context();
            }
            int blockSize = len / pathCount;
            int start = 1;
            int i = 1;
            while (i <= path) {
                int end = i == pathCount ? len + 1 : blockSize * i + 1;
                if (start >= end) {
                    cs = data.cursor(start, start);
                    break;
                }
                BaseRecord record = (BaseRecord)data.get(end - 1);
                Object value = record.getNormalFieldValue(0);
                int next = end;
                end = len + 1;
                while (next <= len) {
                    record = (BaseRecord)data.get(next);
                    if (!Variant.isEquals(record.getNormalFieldValue(0), value)) {
                        end = next;
                        break;
                    }
                    ++next;
                }
                cs = data.cursor(start, end);
                start = end;
                ++i;
            }
        } else {
            cs = path == 1 ? data.cursor() : data.cursor(len + 1, len + 1);
        }
        return cs;
    }
}

