/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.util;

import com.scudata.common.ISessionFactory;
import com.scudata.dm.Context;
import com.scudata.dm.Env;
import com.scudata.dm.JobSpace;
import com.scudata.dm.Param;
import com.scudata.dm.Sequence;

public class EnvUtil {
    private static final int FIELDSIZE = 50;
    private static final int MAXRECORDCOUNT = 20000000;
    private static double MAX_USEDMEMORY_PERCENT = 0.4;

    public static void setMaxUsedMemoryPercent(double d) {
        MAX_USEDMEMORY_PERCENT = d;
    }

    public static double getMaxUsedMemoryPercent() {
        return MAX_USEDMEMORY_PERCENT;
    }

    public static int getCapacity(int fcount) {
        Runtime rt = Runtime.getRuntime();
        EnvUtil.runGC(rt);
        long freeMemory = rt.maxMemory() - rt.totalMemory() + rt.freeMemory();
        long recordCount = freeMemory / (long)fcount / 50L / 3L;
        if (recordCount > 20000000L) {
            return 20000000;
        }
        return (int)recordCount;
    }

    public static boolean memoryTest(Runtime rt, Sequence table, long readSize) {
        int len = table.length();
        if (len >= 20000000) {
            return false;
        }
        long maxUseMemory = (long)((double)rt.maxMemory() * MAX_USEDMEMORY_PERCENT);
        long usedMemory = rt.totalMemory() - rt.freeMemory();
        return usedMemory <= maxUseMemory && usedMemory + readSize <= maxUseMemory;
    }

    public static void runGC(Runtime rt) {
        int i = 0;
        while (i < 2) {
            rt.gc();
            Thread.yield();
            ++i;
        }
    }

    public static Param getParam(String varName, Context ctx) {
        if (ctx != null) {
            Param p = ctx.getParam(varName);
            if (p != null) {
                return p;
            }
            JobSpace js = ctx.getJobSpace();
            if (js != null && (p = js.getParam(varName)) != null) {
                return p;
            }
        }
        return Env.getParam(varName);
    }

    public static Param removeParam(String varName, Context ctx) {
        if (ctx != null) {
            Param p = ctx.removeParam(varName);
            if (p != null) {
                return p;
            }
            JobSpace js = ctx.getJobSpace();
            if (js != null && (p = js.removeParam(varName)) != null) {
                return p;
            }
        }
        return Env.removeParam(varName);
    }

    public static ISessionFactory getDBSessionFactory(String dbName, Context ctx) {
        if (ctx == null) {
            return Env.getDBSessionFactory(dbName);
        }
        ISessionFactory dbsf = ctx.getDBSessionFactory(dbName);
        return dbsf == null ? Env.getDBSessionFactory(dbName) : dbsf;
    }
}

