/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.util;

class FDBigInt {
    int nWords;
    int[] data;

    public FDBigInt(int v) {
        this.nWords = 1;
        this.data = new int[1];
        this.data[0] = v;
    }

    public FDBigInt(long v) {
        this.data = new int[2];
        this.data[0] = (int)v;
        this.data[1] = (int)(v >>> 32);
        this.nWords = this.data[1] == 0 ? 1 : 2;
    }

    public FDBigInt(FDBigInt other) {
        this.nWords = other.nWords;
        this.data = new int[this.nWords];
        System.arraycopy(other.data, 0, this.data, 0, this.nWords);
    }

    private FDBigInt(int[] d, int n) {
        this.data = d;
        this.nWords = n;
    }

    public FDBigInt(long seed, char[] digit, int nd0, int nd) {
        int v;
        int n = (nd + 8) / 9;
        if (n < 2) {
            n = 2;
        }
        this.data = new int[n];
        this.data[0] = (int)seed;
        this.data[1] = (int)(seed >>> 32);
        this.nWords = this.data[1] == 0 ? 1 : 2;
        int i = nd0;
        int limit = nd - 5;
        while (i < limit) {
            int ilim = i + 5;
            v = digit[i++] - 48;
            while (i < ilim) {
                v = 10 * v + digit[i++] - 48;
            }
            this.multaddMe(100000, v);
        }
        int factor = 1;
        v = 0;
        while (i < nd) {
            v = 10 * v + digit[i++] - 48;
            factor *= 10;
        }
        if (factor != 1) {
            this.multaddMe(factor, v);
        }
    }

    public void lshiftMe(int c) throws IllegalArgumentException {
        if (c <= 0) {
            if (c == 0) {
                return;
            }
            throw new IllegalArgumentException("negative shift count");
        }
        int wordcount = c >> 5;
        int bitcount = c & 0x1F;
        int anticount = 32 - bitcount;
        int[] t = this.data;
        int[] s = this.data;
        if (this.nWords + wordcount + 1 > t.length) {
            t = new int[this.nWords + wordcount + 1];
        }
        int target = this.nWords + wordcount;
        int src = this.nWords - 1;
        if (bitcount == 0) {
            System.arraycopy(s, 0, t, wordcount, this.nWords);
            target = wordcount - 1;
        } else {
            t[target--] = s[src] >>> anticount;
            while (src >= 1) {
                t[target--] = s[src] << bitcount | s[--src] >>> anticount;
            }
            t[target--] = s[src] << bitcount;
        }
        while (target >= 0) {
            t[target--] = 0;
        }
        this.data = t;
        this.nWords += wordcount + 1;
        while (this.nWords > 1 && this.data[this.nWords - 1] == 0) {
            --this.nWords;
        }
    }

    /*
     * Unable to fully structure code
     */
    public int normalizeMe() throws IllegalArgumentException {
        block6: {
            wordcount = 0;
            bitcount = 0;
            v = 0;
            src = this.nWords - 1;
            while (src >= 0 && (v = this.data[src]) == 0) {
                ++wordcount;
                --src;
            }
            if (src < 0) {
                throw new IllegalArgumentException("zero value");
            }
            this.nWords -= wordcount;
            if ((v & -268435456) == 0) ** GOTO lbl21
            bitcount = 32;
            while ((v & -268435456) != 0) {
                v >>>= 1;
                --bitcount;
            }
            break block6;
lbl-1000:
            // 1 sources

            {
                v <<= 8;
                bitcount += 8;
lbl21:
                // 2 sources

                ** while (v <= 1048575)
            }
lbl22:
            // 2 sources

            while (v <= 0x7FFFFFF) {
                v <<= 1;
                ++bitcount;
            }
        }
        if (bitcount != 0) {
            this.lshiftMe(bitcount);
        }
        return bitcount;
    }

    public FDBigInt mult(int iv) {
        long v = iv;
        int[] r = new int[v * ((long)this.data[this.nWords - 1] & 0xFFFFFFFFL) > 0xFFFFFFFL ? this.nWords + 1 : this.nWords];
        long p = 0L;
        int i = 0;
        while (i < this.nWords) {
            r[i] = (int)(p += v * ((long)this.data[i] & 0xFFFFFFFFL));
            p >>>= 32;
            ++i;
        }
        if (p == 0L) {
            return new FDBigInt(r, this.nWords);
        }
        r[this.nWords] = (int)p;
        return new FDBigInt(r, this.nWords + 1);
    }

    public void multaddMe(int iv, int addend) {
        long v = iv;
        long p = v * ((long)this.data[0] & 0xFFFFFFFFL) + ((long)addend & 0xFFFFFFFFL);
        this.data[0] = (int)p;
        p >>>= 32;
        int i = 1;
        while (i < this.nWords) {
            this.data[i] = (int)(p += v * ((long)this.data[i] & 0xFFFFFFFFL));
            p >>>= 32;
            ++i;
        }
        if (p != 0L) {
            this.data[this.nWords] = (int)p;
            ++this.nWords;
        }
    }

    public FDBigInt mult(FDBigInt other) {
        int[] r = new int[this.nWords + other.nWords];
        int i = 0;
        while (i < this.nWords) {
            long v = (long)this.data[i] & 0xFFFFFFFFL;
            long p = 0L;
            int j = 0;
            while (j < other.nWords) {
                r[i + j] = (int)(p += ((long)r[i + j] & 0xFFFFFFFFL) + v * ((long)other.data[j] & 0xFFFFFFFFL));
                p >>>= 32;
                ++j;
            }
            r[i + j] = (int)p;
            ++i;
        }
        i = r.length - 1;
        while (i > 0) {
            if (r[i] != 0) break;
            --i;
        }
        return new FDBigInt(r, i + 1);
    }

    public FDBigInt add(FDBigInt other) {
        int m;
        int[] b;
        int n;
        int[] a;
        long c = 0L;
        if (this.nWords >= other.nWords) {
            a = this.data;
            n = this.nWords;
            b = other.data;
            m = other.nWords;
        } else {
            a = other.data;
            n = other.nWords;
            b = this.data;
            m = this.nWords;
        }
        int[] r = new int[n];
        int i = 0;
        while (i < n) {
            c += (long)a[i] & 0xFFFFFFFFL;
            if (i < m) {
                c += (long)b[i] & 0xFFFFFFFFL;
            }
            r[i] = (int)c;
            c >>= 32;
            ++i;
        }
        if (c != 0L) {
            int[] s = new int[r.length + 1];
            System.arraycopy(r, 0, s, 0, r.length);
            s[i++] = (int)c;
            return new FDBigInt(s, i);
        }
        return new FDBigInt(r, i);
    }

    /*
     * Unable to fully structure code
     */
    public FDBigInt sub(FDBigInt other) {
        r = new int[this.nWords];
        n = this.nWords;
        m = other.nWords;
        nzeros = 0;
        c = 0L;
        i = 0;
        while (i < n) {
            c += (long)this.data[i] & 0xFFFFFFFFL;
            if (i < m) {
                c -= (long)other.data[i] & 0xFFFFFFFFL;
            }
            nzeros = (r[i] = (int)c) == 0 ? ++nzeros : 0;
            c >>= 32;
            ++i;
        }
        if (c == 0L) ** GOTO lbl19
        throw new RuntimeException("Assertion botch: borrow out of subtract");
lbl-1000:
        // 1 sources

        {
            if (other.data[i++] == 0) continue;
            throw new RuntimeException("Assertion botch: negative result of subtract");
lbl19:
            // 2 sources

            ** while (i < m)
        }
lbl20:
        // 1 sources

        return new FDBigInt(r, n - nzeros);
    }

    public int cmp(FDBigInt other) {
        int i;
        int j;
        if (this.nWords > other.nWords) {
            j = other.nWords - 1;
            i = this.nWords - 1;
            while (i > j) {
                if (this.data[i] != 0) {
                    return 1;
                }
                --i;
            }
        } else if (this.nWords < other.nWords) {
            j = this.nWords - 1;
            i = other.nWords - 1;
            while (i > j) {
                if (other.data[i] != 0) {
                    return -1;
                }
                --i;
            }
        } else {
            i = this.nWords - 1;
        }
        while (i > 0) {
            if (this.data[i] != other.data[i]) break;
            --i;
        }
        int a = this.data[i];
        int b = other.data[i];
        if (a < 0) {
            if (b < 0) {
                return a - b;
            }
            return 1;
        }
        if (b < 0) {
            return -1;
        }
        return a - b;
    }

    public int quoRemIteration(FDBigInt S) throws IllegalArgumentException {
        int i;
        if (this.nWords != S.nWords) {
            throw new IllegalArgumentException("disparate values");
        }
        int n = this.nWords - 1;
        long q = ((long)this.data[n] & 0xFFFFFFFFL) / (long)S.data[n];
        long diff = 0L;
        int i2 = 0;
        while (i2 <= n) {
            this.data[i2] = (int)(diff += ((long)this.data[i2] & 0xFFFFFFFFL) - q * ((long)S.data[i2] & 0xFFFFFFFFL));
            diff >>= 32;
            ++i2;
        }
        if (diff != 0L) {
            long sum = 0L;
            while (sum == 0L) {
                sum = 0L;
                i = 0;
                while (i <= n) {
                    this.data[i] = (int)(sum += ((long)this.data[i] & 0xFFFFFFFFL) + ((long)S.data[i] & 0xFFFFFFFFL));
                    sum >>= 32;
                    ++i;
                }
                if (sum != 0L && sum != 1L) {
                    throw new RuntimeException("Assertion botch: " + sum + " carry out of division correction");
                }
                --q;
            }
        }
        long p = 0L;
        i = 0;
        while (i <= n) {
            this.data[i] = (int)(p += 10L * ((long)this.data[i] & 0xFFFFFFFFL));
            p >>= 32;
            ++i;
        }
        if (p != 0L) {
            throw new RuntimeException("Assertion botch: carry out of *10");
        }
        return (int)q;
    }

    public long longValue() {
        int i = this.nWords - 1;
        while (i > 1) {
            if (this.data[i] != 0) {
                throw new RuntimeException("Assertion botch: value too big");
            }
            --i;
        }
        switch (i) {
            case 1: {
                if (this.data[1] < 0) {
                    throw new RuntimeException("Assertion botch: value too big");
                }
                return (long)this.data[1] << 32 | (long)this.data[0] & 0xFFFFFFFFL;
            }
            case 0: {
                return (long)this.data[0] & 0xFFFFFFFFL;
            }
        }
        throw new RuntimeException("Assertion botch: longValue confused");
    }

    public String toString() {
        StringBuffer r = new StringBuffer(30);
        r.append('[');
        int i = Math.min(this.nWords - 1, this.data.length - 1);
        if (this.nWords > this.data.length) {
            r.append("(" + this.data.length + "<" + this.nWords + "!)");
        }
        while (i > 0) {
            r.append(Integer.toHexString(this.data[i]));
            r.append(' ');
            --i;
        }
        r.append(Integer.toHexString(this.data[0]));
        r.append(']');
        return new String(r);
    }
}

