/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.util;

import com.scudata.array.IArray;
import com.scudata.common.Escape;
import com.scudata.common.Sentence;
import com.scudata.common.StringUtils;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Record;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.util.Variant;
import java.util.ArrayList;
import java.util.Date;

public final class JSONUtil {
    private static int scanQuotation(char[] chars, int start, int end) {
        while (start <= end) {
            if (chars[start] == '\"') {
                return start;
            }
            if (chars[start] == '\\') {
                ++start;
            }
            ++start;
        }
        return -1;
    }

    private static int indexOf(char[] chars, int start, int end, char c) {
        while (start <= end) {
            if (chars[start] == c) {
                return start;
            }
            switch (chars[start]) {
                case '[': {
                    start = JSONUtil.indexOf(chars, start + 1, end, ']');
                    if (start >= 0) break;
                    return -1;
                }
                case '{': {
                    start = JSONUtil.indexOf(chars, start + 1, end, '}');
                    if (start >= 0) break;
                    return -1;
                }
                case '\"': {
                    start = JSONUtil.scanQuotation(chars, start + 1, end);
                    if (start >= 0) break;
                    return -1;
                }
                case '\\': {
                    ++start;
                }
            }
            ++start;
        }
        return -1;
    }

    private static Sequence parseSequence(char[] chars, int start, int end, String opt) {
        while (start <= end && Character.isWhitespace(chars[start])) {
            ++start;
        }
        Sequence sequence = new Sequence();
        while (start <= end) {
            Object value;
            int index = JSONUtil.indexOf(chars, start, end, ',');
            if (index < 0) {
                value = JSONUtil.parseJSON(chars, start, end, opt);
                sequence.add(value);
                break;
            }
            value = JSONUtil.parseJSON(chars, start, index - 1, opt);
            sequence.add(value);
            start = index + 1;
            while (start <= end && Character.isWhitespace(chars[start])) {
                ++start;
            }
            if (start <= end) continue;
            sequence.add(null);
            break;
        }
        if (!sequence.isPmt()) {
            return sequence;
        }
        DataStruct ds = sequence.dataStruct();
        if (ds != null) {
            int len = sequence.length();
            Table table = new Table(ds, len);
            IArray memes = table.getMems();
            int i = 1;
            while (i <= len) {
                Record r = (Record)sequence.getMem(i);
                r.setDataStruct(ds);
                memes.add(r);
                ++i;
            }
            return table;
        }
        if (opt != null && opt.indexOf(116) != -1) {
            ArrayList<String> nameList = new ArrayList<String>();
            int len = sequence.length();
            int i = 1;
            while (i <= len) {
                BaseRecord r = (BaseRecord)sequence.getMem(i);
                if (r != null) {
                    String[] names;
                    String[] stringArray = names = r.getFieldNames();
                    int n = names.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String name = stringArray[n2];
                        if (!nameList.contains(name)) {
                            nameList.add(name);
                        }
                        ++n2;
                    }
                }
                ++i;
            }
            String[] names = new String[nameList.size()];
            nameList.toArray(names);
            ds = new DataStruct(names);
            Table table = new Table(ds, len);
            int i2 = 1;
            while (i2 <= len) {
                BaseRecord nr = table.newLast();
                BaseRecord r = (BaseRecord)sequence.getMem(i2);
                if (r != null) {
                    int f = 0;
                    String[] stringArray = names = r.getFieldNames();
                    int n = names.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String name = stringArray[n3];
                        int nf = ds.getFieldIndex(name);
                        nr.setNormalFieldValue(nf, r.getNormalFieldValue(f++));
                        ++n3;
                    }
                }
                ++i2;
            }
            return table;
        }
        return sequence;
    }

    private static BaseRecord parseRecord(char[] chars, int start, int end, String opt) {
        if (start > end) {
            return null;
        }
        ArrayList<String> nameList = new ArrayList<String>();
        ArrayList<Object> valueList = new ArrayList<Object>();
        while (start <= end) {
            Object value;
            int index = JSONUtil.indexOf(chars, start, end, ':');
            if (index < 0) {
                while (start <= end) {
                    if (!Character.isWhitespace(start)) {
                        return null;
                    }
                    ++start;
                }
                break;
            }
            String name = new String(chars, start, index - start);
            int len = (name = name.trim()).length();
            if (len > 2 && name.charAt(0) == '\"' && name.charAt(len - 1) == '\"') {
                name = name.substring(1, len - 1);
            }
            nameList.add(name);
            start = index + 1;
            index = JSONUtil.indexOf(chars, start, end, ',');
            if (index < 0) {
                value = JSONUtil.parseJSON(chars, start, end, opt);
                valueList.add(value);
                break;
            }
            value = JSONUtil.parseJSON(chars, start, index - 1, opt);
            valueList.add(value);
            start = index + 1;
        }
        int size = nameList.size();
        if (size == 0) {
            return null;
        }
        String[] names = new String[size];
        nameList.toArray(names);
        DataStruct ds = new DataStruct(names);
        Record r = new Record(ds);
        valueList.toArray(r.getFieldValues());
        return r;
    }

    public static Object parseJSON(char[] chars, int start, int end, String opt) {
        while (start <= end && Character.isWhitespace(chars[end])) {
            --end;
        }
        while (start <= end) {
            char c = chars[start];
            if (c == '[') {
                if (chars[end] == ']') {
                    return JSONUtil.parseSequence(chars, start + 1, end - 1, opt);
                }
                return new String(chars, start, end - start + 1).trim();
            }
            if (c == '{') {
                if (chars[end] == '}') {
                    BaseRecord r = JSONUtil.parseRecord(chars, start + 1, end - 1, opt);
                    if (r != null) {
                        return r;
                    }
                    return new String(chars, start, end - start + 1).trim();
                }
                return new String(chars, start, end - start + 1).trim();
            }
            if (!Character.isWhitespace(c)) {
                String str = new String(chars, start, end - start + 1);
                return JSONUtil.parse(str);
            }
            ++start;
        }
        return null;
    }

    public static Object parseJSON(char[] chars, int start, int end) {
        return JSONUtil.parseJSON(chars, start, end, null);
    }

    public static void toJSON(Object obj, StringBuffer sb) {
        if (obj == null) {
            sb.append("null");
        } else if (obj instanceof BaseRecord) {
            BaseRecord r = (BaseRecord)obj;
            String[] names = r.getFieldNames();
            Object[] vals = r.getFieldValues();
            sb.append('{');
            int f = 0;
            int fcount = vals.length;
            while (f < fcount) {
                if (f > 0) {
                    sb.append(',');
                }
                sb.append(Escape.addEscAndQuote(names[f]));
                sb.append(':');
                JSONUtil.toJSON(vals[f], sb);
                ++f;
            }
            sb.append('}');
        } else if (obj instanceof Sequence) {
            IArray mems = ((Sequence)obj).getMems();
            sb.append('[');
            int i = 1;
            int len = mems.size();
            while (i <= len) {
                if (i > 1) {
                    sb.append(',');
                }
                JSONUtil.toJSON(mems.get(i), sb);
                ++i;
            }
            sb.append(']');
        } else if (obj instanceof String) {
            sb.append(Escape.addEscAndQuote((String)obj));
        } else if (obj instanceof Date) {
            String str = Variant.toString(obj);
            sb.append(Escape.addEscAndQuote(str));
        } else {
            sb.append(Variant.toString(obj));
        }
    }

    public static String toJSON(Sequence seq) {
        StringBuffer sb = new StringBuffer(1024);
        IArray mems = seq.getMems();
        sb.append('[');
        int i = 1;
        int len = mems.size();
        while (i <= len) {
            if (i > 1) {
                sb.append(',');
            }
            JSONUtil.toJSON(mems.get(i), sb);
            ++i;
        }
        sb.append(']');
        return sb.toString();
    }

    public static String toJSON(BaseRecord r) {
        StringBuffer sb = new StringBuffer(1024);
        String[] names = r.getFieldNames();
        Object[] vals = r.getFieldValues();
        sb.append('{');
        int f = 0;
        int fcount = vals.length;
        while (f < fcount) {
            if (f > 0) {
                sb.append(',');
            }
            sb.append(Escape.addEscAndQuote(names[f]));
            sb.append(':');
            JSONUtil.toJSON(vals[f], sb);
            ++f;
        }
        sb.append('}');
        return sb.toString();
    }

    private static Object parse(String s) {
        char ch0 = s.charAt(0);
        if (ch0 == '\"' || ch0 == '\'') {
            int match = Sentence.scanQuotation(s, 0);
            if (match == s.length() - 1) {
                s = s.substring(1, match);
            }
            return StringUtils.unicode(s);
        }
        return Variant.parse(s, true);
    }
}

