/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.util;

import com.scudata.util.ILoserTreeNode;

public class LoserTree {
    private ILoserTreeNode[] nodes;
    private int[] tree;
    private int size;

    public LoserTree(ILoserTreeNode[] nodes) {
        int q = 0;
        int i = 0;
        int len = nodes.length;
        while (i < len) {
            if (nodes[i].hasNext()) {
                if (i != q) {
                    nodes[q] = nodes[i];
                }
                ++q;
            }
            ++i;
        }
        this.nodes = nodes;
        this.size = q;
        this.tree = new int[q];
        this.init();
    }

    private void init() {
        int size = this.size;
        int i = 0;
        while (i < size) {
            this.tree[i] = -1;
            ++i;
        }
        i = size - 1;
        while (i >= 0) {
            this.initAdjust(i);
            --i;
        }
    }

    private void initAdjust(int s) {
        ILoserTreeNode[] nodes = this.nodes;
        int[] tree = this.tree;
        int t = (s + this.size) / 2;
        while (t > 0) {
            int p = tree[t];
            if (p == -1) {
                tree[t] = s;
                tree[0] = -1;
                return;
            }
            if (nodes[s].compareTo(nodes[p]) > 0) {
                tree[t] = s;
                s = p;
            }
            t /= 2;
        }
        tree[0] = s;
    }

    private void adjust(int s) {
        ILoserTreeNode[] nodes = this.nodes;
        int[] tree = this.tree;
        int t = (s + this.size) / 2;
        while (t > 0) {
            int p = tree[t];
            int cmp = nodes[s].compareTo(nodes[p]);
            if (cmp > 0 || cmp == 0 && s > p) {
                tree[t] = s;
                s = p;
            }
            t /= 2;
        }
        tree[0] = s;
    }

    public boolean hasNext() {
        return this.size > 0;
    }

    public Object pop() {
        int p = this.tree[0];
        Object obj = this.nodes[p].popCurrent();
        if (this.nodes[p].hasNext()) {
            this.adjust(p);
        } else {
            --this.size;
            int size = this.size;
            System.arraycopy(this.nodes, p + 1, this.nodes, p, size - p);
            this.init();
        }
        return obj;
    }
}

