/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.util;

import com.scudata.util.Variant;

public class MaxHeap {
    private Object[] heap;
    private int maxSize;
    private int currentSize;

    public MaxHeap(int maxSize) {
        this.heap = new Object[maxSize + 1];
        this.maxSize = maxSize;
        this.currentSize = 0;
    }

    public int size() {
        return this.currentSize;
    }

    public boolean insert(Object o) {
        Object[] heap = this.heap;
        if (this.currentSize == this.maxSize) {
            if (Variant.compare(o, heap[1], true) <= 0) {
                return false;
            }
            this.deleteRoot();
            return this.insert(o);
        }
        int i = ++this.currentSize;
        while (i != 1 && Variant.compare(o, heap[i / 2], true) < 0) {
            heap[i] = heap[i / 2];
            i /= 2;
        }
        heap[i] = o;
        return true;
    }

    private void deleteRoot() {
        Object[] heap = this.heap;
        int currentSize = this.currentSize;
        Object o = heap[currentSize];
        int i = 1;
        int c = 2;
        while (c < currentSize) {
            int rc = c + 1;
            if (rc < currentSize && Variant.compare(heap[rc], heap[c], true) < 0) {
                c = rc;
            }
            if (Variant.compare(o, heap[c], true) <= 0) break;
            heap[i] = heap[c];
            i = c;
            c *= 2;
        }
        heap[i] = o;
        heap[currentSize] = null;
        --this.currentSize;
    }

    public Object[] toArray() {
        Object[] objs = new Object[this.currentSize];
        System.arraycopy(this.heap, 1, objs, 0, this.currentSize);
        return objs;
    }
}

