/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.util;

import com.scudata.dm.comparator.BaseComparator;
import java.util.Comparator;

public class MinHeap {
    private Object[] heap;
    private int maxSize;
    private int currentSize;
    private Comparator<Object> comparator;

    public MinHeap(int maxSize) {
        this(maxSize, new BaseComparator());
    }

    public MinHeap(int maxSize, Comparator<Object> comparator) {
        this.heap = new Object[maxSize + 1];
        this.maxSize = maxSize;
        this.currentSize = 0;
        this.comparator = comparator;
    }

    public int size() {
        return this.currentSize;
    }

    public boolean insert(Object o) {
        Object[] heap = this.heap;
        if (this.currentSize == this.maxSize) {
            if (this.comparator.compare(o, heap[1]) >= 0) {
                return false;
            }
            this.deleteRoot();
            return this.insert(o);
        }
        int i = ++this.currentSize;
        while (i != 1 && this.comparator.compare(o, heap[i / 2]) > 0) {
            heap[i] = heap[i / 2];
            i /= 2;
        }
        heap[i] = o;
        return true;
    }

    public void insertAll(MinHeap other) {
        Object[] heap = other.heap;
        int i = 1;
        int currentSize = other.currentSize;
        while (i <= currentSize) {
            this.insert(heap[i]);
            ++i;
        }
    }

    private void deleteRoot() {
        Object[] heap = this.heap;
        int currentSize = this.currentSize;
        Object o = heap[currentSize];
        int i = 1;
        int c = 2;
        while (c < currentSize) {
            int rc = c + 1;
            if (rc < currentSize && this.comparator.compare(heap[rc], heap[c]) > 0) {
                c = rc;
            }
            if (this.comparator.compare(o, heap[c]) >= 0) break;
            heap[i] = heap[c];
            i = c;
            c *= 2;
        }
        heap[i] = o;
        heap[currentSize] = null;
        --this.currentSize;
    }

    public Object[] toArray() {
        Object[] objs = new Object[this.currentSize];
        System.arraycopy(this.heap, 1, objs, 0, this.currentSize);
        return objs;
    }

    public Object getTop() {
        return this.heap[1];
    }
}

