/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.vdb;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.ObjectReader;
import com.scudata.dm.ObjectWriter;
import com.scudata.dm.Record;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.expression.Expression;
import com.scudata.resources.EngineMessage;
import com.scudata.util.HashUtil;
import com.scudata.vdb.ArchiveDir;
import com.scudata.vdb.BlockManager;
import com.scudata.vdb.Filter;
import com.scudata.vdb.IDir;
import com.scudata.vdb.ISection;
import com.scudata.vdb.Library;
import com.scudata.vdb.Section;
import com.scudata.vdb.VDB;
import com.scudata.vdb.VS;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;

class ArchiveSection
extends ISection {
    private byte sign;
    private int subDataHeader = -1;
    private ArchiveDir[] subDirs;
    private IDir dir;
    private int header = -1;
    private int[] otherBlocks;
    private Sequence subDatas;

    public ArchiveSection() {
    }

    public ArchiveSection(IDir dir) {
        this.dir = dir;
    }

    public ArchiveSection(IDir dir, int header, byte[] bytes) throws IOException {
        this.dir = dir;
        this.header = header;
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        ObjectReader reader = new ObjectReader(bis);
        int count = reader.readInt32();
        if (count > 0) {
            this.otherBlocks = new int[count];
            int i = 0;
            while (i < count) {
                this.otherBlocks[i] = reader.readInt32();
                ++i;
            }
        }
        this.sign = reader.readByte();
        this.subDataHeader = reader.readInt();
        int subCount = reader.readInt();
        if (subCount > 0) {
            ArchiveDir[] subDirs = new ArchiveDir[subCount];
            this.subDirs = subDirs;
            int i = 0;
            while (i < subCount) {
                subDirs[i] = new ArchiveDir(this);
                subDirs[i].read(reader);
                ++i;
            }
        }
        reader.close();
    }

    private ArchiveSection(VDB vdb, Section section, ArchiveDir dir) throws IOException {
        ISection sub;
        int subCount;
        Library library = vdb.getLibrary();
        this.header = dir == null ? library.applyHeaderBlock() : dir.getHeader();
        this.sign = (byte)(this.sign | ISection.SIGN_ARCHIVE);
        if (section.isKeySection()) {
            this.sign = (byte)(this.sign | ISection.SIGN_KEY_SECTION);
        }
        Sequence fileDatas = null;
        ArchiveDir[] subDirs = null;
        ArrayList<ISection> subSections = section.getSubList(library);
        int n = subCount = subSections != null ? subSections.size() : 0;
        if (subCount > 0) {
            fileDatas = new Sequence(subCount + 1);
            subDirs = new ArchiveDir[subCount];
            int i = 0;
            while (i < subCount) {
                ArchiveDir subDir;
                sub = subSections.get(i);
                subDirs[i] = subDir = new ArchiveDir(sub.getValue(), sub.getName(), sub.getCommitTime(), this);
                if (sub.isFile()) {
                    Object data = sub.load(vdb, null);
                    fileDatas.add(data);
                    subDir.setFileIndex(fileDatas.length());
                }
                if (sub.isDir()) {
                    if (sub instanceof ArchiveSection) {
                        subDir.setHeader(((ArchiveSection)sub).header);
                    } else {
                        int subHeader = library.applyHeaderBlock();
                        subDir.setHeader(subHeader);
                    }
                }
                ++i;
            }
        }
        if (dir == null && section.isFile()) {
            if (fileDatas == null) {
                fileDatas = new Sequence(1);
            }
            Object data = section.load(vdb, null);
            fileDatas.add(data);
            this.sign = (byte)(this.sign | ISection.SIGN_ARCHIVE_FILE);
        }
        this.subDirs = subDirs;
        if (fileDatas != null) {
            this.subDataHeader = library.writeDataBlock(this.header, fileDatas);
        }
        this.commit(library);
        fileDatas = null;
        int i = 0;
        while (i < subCount) {
            if (subDirs[i].getHeader() > 0 && (sub = subSections.get(i)) instanceof Section) {
                new ArchiveSection(vdb, (Section)sub, subDirs[i]);
            }
            ++i;
        }
    }

    public static int archive(VDB vdb, Section section) throws IOException {
        ArchiveSection as = new ArchiveSection(vdb, section, null);
        return as.header;
    }

    private void commit(Library library) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        ObjectWriter writer = new ObjectWriter(bos);
        writer.writeByte(this.sign);
        writer.writeInt(this.subDataHeader);
        ArchiveDir[] subDirs = this.subDirs;
        int count = subDirs == null ? 0 : subDirs.length;
        writer.writeInt(count);
        if (count > 0) {
            ArchiveDir[] archiveDirArray = subDirs;
            int n = subDirs.length;
            int n2 = 0;
            while (n2 < n) {
                ArchiveDir dir = archiveDirArray[n2];
                dir.write(writer);
                ++n2;
            }
        }
        writer.close();
        byte[] bytes = bos.toByteArray();
        this.otherBlocks = library.writeHeaderBlock(this.header, this.otherBlocks, bytes);
    }

    @Override
    public IDir getDir() {
        return this.dir;
    }

    private boolean isKeySection() {
        return (this.sign & ISection.SIGN_KEY_SECTION) != 0;
    }

    private void loadSubDatas(VDB vdb) throws IOException {
        if (this.subDatas == null) {
            this.subDatas = (Sequence)vdb.getLibrary().readDataBlock(this.subDataHeader);
        }
    }

    @Override
    public boolean isFile() {
        if (this.dir instanceof ArchiveDir) {
            return ((ArchiveDir)this.dir).isFile();
        }
        return (this.sign & ISection.SIGN_ARCHIVE_FILE) != 0;
    }

    @Override
    public boolean isDir() {
        return this.subDirs != null;
    }

    public Object getSubFileData(VDB vdb, int fileIndex) throws IOException {
        this.loadSubDatas(vdb);
        return this.subDatas.getMem(fileIndex);
    }

    private ArchiveSection getSubSection(Library library, int index) {
        return this.subDirs[index].getSection(library);
    }

    @Override
    public ISection getSub(VDB vdb, Object path) {
        ArchiveDir[] subDirs = this.subDirs;
        if (subDirs == null) {
            return null;
        }
        if (this.isKeySection()) {
            int hash = HashUtil.hashCode(path, subDirs.length);
            ArchiveSection section = this.getSubSection(vdb.getLibrary(), hash);
            return section.getSub(vdb, path);
        }
        int i = 0;
        int count = subDirs.length;
        while (i < count) {
            if (subDirs[i].isEqualValue(path)) {
                return this.getSubSection(vdb.getLibrary(), i);
            }
            ++i;
        }
        return null;
    }

    @Override
    public Section getSubForMove(VDB vdb, Object path) {
        throw ArchiveSection.getModifyException();
    }

    @Override
    public ISection getSubForMove(VDB vdb, Sequence paths) {
        throw ArchiveSection.getModifyException();
    }

    @Override
    public Sequence list(VDB vdb, String opt) {
        ArchiveDir[] subDirs = this.subDirs;
        if (subDirs == null) {
            return null;
        }
        int size = subDirs.length;
        Sequence seq = new Sequence(size);
        boolean listFiles = true;
        boolean listDirs = false;
        if (opt != null) {
            if (opt.indexOf(119) != -1) {
                listFiles = false;
            } else if (opt.indexOf(100) != -1) {
                listDirs = true;
                listFiles = false;
            }
        }
        int i = 0;
        while (i < size) {
            ArchiveSection section;
            if (listFiles) {
                if (subDirs[i].isFile()) {
                    section = subDirs[i].getSection(vdb.getLibrary());
                    seq.add(new VS(vdb, section));
                }
            } else if (listDirs) {
                if (subDirs[i].isDir()) {
                    section = subDirs[i].getSection(vdb.getLibrary());
                    seq.add(new VS(vdb, section));
                }
            } else {
                section = subDirs[i].getSection(vdb.getLibrary());
                seq.add(new VS(vdb, section));
            }
            ++i;
        }
        return seq;
    }

    @Override
    public Object load(VDB vdb, String opt) throws IOException {
        if (this.dir instanceof ArchiveDir) {
            ArchiveDir archiveDir = (ArchiveDir)this.dir;
            if (archiveDir.isFile()) {
                return archiveDir.getFileData(vdb);
            }
        } else if ((this.sign & ISection.SIGN_ARCHIVE_FILE) != 0) {
            this.loadSubDatas(vdb);
            return this.subDatas.getMem(this.subDatas.length());
        }
        return null;
    }

    @Override
    protected void importTable(VDB vdb, Table table, Object[] values, boolean[] signs) throws IOException {
        ArchiveDir[] subDirs;
        Object data = this.load(vdb, null);
        if (data != null) {
            ArchiveSection.addDataToTable(table, values, signs, data);
        }
        if ((subDirs = this.subDirs) == null) {
            return;
        }
        Library library = vdb.getLibrary();
        DataStruct ds = table.dataStruct();
        ArchiveDir[] archiveDirArray = subDirs;
        int n = subDirs.length;
        int n2 = 0;
        while (n2 < n) {
            ArchiveDir dir = archiveDirArray[n2];
            ArchiveSection sub = dir.getSection(library);
            int findex = ds.getFieldIndex(dir.getName());
            if (findex != -1) {
                values[findex] = dir.getValue();
                signs[findex] = true;
                sub.importTable(vdb, table, values, signs);
                values[findex] = null;
                signs[findex] = false;
            } else {
                sub.importTable(vdb, table, values, signs);
            }
            ++n2;
        }
    }

    @Override
    protected void importTable(VDB vdb, Table table, Object[] values, boolean[] signs, Expression filter, int[] filterIndex, Context ctx) throws IOException {
        ArchiveDir[] subDirs;
        Object data = this.load(vdb, null);
        if (data != null) {
            ArchiveSection.addDataToTable(table, values, signs, data, filter, ctx);
        }
        if ((subDirs = this.subDirs) == null) {
            return;
        }
        Library library = vdb.getLibrary();
        DataStruct ds = table.dataStruct();
        ArchiveDir[] archiveDirArray = subDirs;
        int n = subDirs.length;
        int n2 = 0;
        while (n2 < n) {
            ArchiveDir dir = archiveDirArray[n2];
            ArchiveSection sub = dir.getSection(library);
            int findex = ds.getFieldIndex(dir.getName());
            if (findex != -1) {
                values[findex] = dir.getValue();
                signs[findex] = true;
                boolean isAll = true;
                int[] nArray = filterIndex;
                int n3 = filterIndex.length;
                int n4 = 0;
                while (n4 < n3) {
                    int index = nArray[n4];
                    if (!signs[index]) {
                        isAll = false;
                        break;
                    }
                    ++n4;
                }
                if (isAll) {
                    Record r = new Record(ds, values);
                    Object result = r.calc(filter, ctx);
                    if (!(result instanceof Boolean)) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(mm.getMessage("engine.needBoolExp"));
                    }
                    if (((Boolean)result).booleanValue()) {
                        sub.importTable(vdb, table, values, signs);
                    }
                } else {
                    sub.importTable(vdb, table, values, signs, filter, filterIndex, ctx);
                }
                values[findex] = null;
                signs[findex] = false;
            } else {
                sub.importTable(vdb, table, values, signs, filter, filterIndex, ctx);
            }
            ++n2;
        }
    }

    @Override
    protected void retrieve(VDB vdb, Filter filter, boolean isRecursion, Sequence out) throws IOException {
        ArchiveDir[] subDirs;
        if (filter.isDirMatch()) {
            Sequence seq;
            Object data = this.load(vdb, null);
            if (data != null && (seq = filter.select(data)) != null) {
                out.addAll(seq);
            }
            if (!isRecursion) {
                return;
            }
        }
        if ((subDirs = this.subDirs) == null) {
            return;
        }
        Library library = vdb.getLibrary();
        ArchiveDir[] archiveDirArray = subDirs;
        int n = subDirs.length;
        int n2 = 0;
        while (n2 < n) {
            ArchiveDir dir = archiveDirArray[n2];
            ArchiveSection sub = dir.getSection(library);
            if (filter.pushDir(dir.getName(), dir.getValue())) {
                sub.retrieve(vdb, filter, isRecursion, out);
                filter.popDir();
            }
            ++n2;
        }
    }

    static RQException getModifyException() {
        return new RQException("\u5f52\u6863\u8def\u5f84\u57df\u4e0d\u53ef\u4ee5\u518d\u88ab\u4fee\u6539");
    }

    @Override
    public int lockForWrite(VDB vdb) {
        throw ArchiveSection.getModifyException();
    }

    @Override
    public void unlock(VDB vdb) {
    }

    @Override
    public void rollBack(Library library) {
    }

    @Override
    public int save(VDB vdb, Object value) {
        throw ArchiveSection.getModifyException();
    }

    @Override
    public int save(VDB vdb, Object value, Object path, Object name) {
        throw ArchiveSection.getModifyException();
    }

    @Override
    public int makeDir(VDB vdb, Object path, Object name) {
        throw ArchiveSection.getModifyException();
    }

    @Override
    public int createSubKeyDir(VDB vdb, Object key, int len) {
        throw ArchiveSection.getModifyException();
    }

    @Override
    public Sequence saveBlob(VDB vdb, Sequence oldValues, Sequence newValues, String name) {
        throw ArchiveSection.getModifyException();
    }

    @Override
    public int update(VDB vdb, String[] dirNames, Object[] dirValues, boolean[] valueSigns, Object[] fvals, String[] fields, Expression exp, boolean isRecursion, Context ctx) {
        throw ArchiveSection.getModifyException();
    }

    @Override
    public int delete(VDB vdb) {
        throw ArchiveSection.getModifyException();
    }

    @Override
    public boolean deleteNullSection(VDB vdb) {
        return false;
    }

    @Override
    public int move(VDB vdb, Section dest, Object value) {
        throw ArchiveSection.getModifyException();
    }

    @Override
    public void deleteOutdatedZone(Library library, int outerSeq, long txSeq) {
    }

    @Override
    public void commit(Library library, int outerSeq, long innerSeq) throws IOException {
    }

    @Override
    public long getCommitTime() {
        if (this.dir instanceof ArchiveDir) {
            return ((ArchiveDir)this.dir).getCommitTime();
        }
        return 0L;
    }

    @Override
    public int rename(VDB vdb, Object path, String name) {
        throw ArchiveSection.getModifyException();
    }

    @Override
    public void scanUsedBlocks(Library library, BlockManager manager) throws IOException {
        ArchiveDir[] subDirs;
        if (this.header < 1) {
            return;
        }
        manager.setBlockUsed(this.header);
        if (this.otherBlocks != null) {
            manager.setBlocksUsed(this.otherBlocks);
        }
        if (this.subDataHeader > 0) {
            manager.setBlockUsed(this.subDataHeader);
            int[] others = library.readOtherBlocks(this.subDataHeader);
            if (others != null) {
                manager.setBlocksUsed(others);
            }
        }
        if ((subDirs = this.subDirs) != null) {
            ArchiveDir[] archiveDirArray = subDirs;
            int n = subDirs.length;
            int n2 = 0;
            while (n2 < n) {
                ArchiveDir dir = archiveDirArray[n2];
                if (dir.getHeader() > 0) {
                    ArchiveSection section = dir.getSection(library);
                    section.scanUsedBlocks(library, manager);
                    dir.releaseSubSection();
                }
                ++n2;
            }
        }
    }

    @Override
    public void releaseSubSection() {
        ArchiveDir[] subDirs = this.subDirs;
        if (subDirs != null) {
            ArchiveDir[] archiveDirArray = subDirs;
            int n = subDirs.length;
            int n2 = 0;
            while (n2 < n) {
                ArchiveDir dir = archiveDirArray[n2];
                dir.releaseSubSection();
                ++n2;
            }
        }
        this.subDatas = null;
    }

    @Override
    public void reset(Library srcLib, Library destLib, int destHeader) throws IOException {
        int subCount;
        ArchiveSection destSection = new ArchiveSection();
        destSection.header = destHeader;
        destSection.sign = this.sign;
        if (this.subDataHeader > 0) {
            byte[] bytes = srcLib.readBlocks(this.subDataHeader);
            int dataPos = Library.getDataPos(bytes);
            int dataLen = bytes.length - dataPos;
            byte[] datas = new byte[dataLen];
            System.arraycopy(bytes, dataPos, datas, 0, dataLen);
            destSection.subDataHeader = destLib.writeDataBlock(destHeader, datas);
        }
        ArchiveDir[] srcSubDirs = this.subDirs;
        ArchiveDir[] destSubDirs = null;
        int n = subCount = srcSubDirs != null ? srcSubDirs.length : 0;
        if (srcSubDirs != null) {
            destSubDirs = new ArchiveDir[subCount];
            int i = 0;
            while (i < subCount) {
                destSubDirs[i] = new ArchiveDir(srcSubDirs[i]);
                if (destSubDirs[i].getHeader() > 0) {
                    int subHeader = destLib.applyHeaderBlock();
                    destSubDirs[i].setHeader(subHeader);
                }
                ++i;
            }
        }
        destSection.subDirs = destSubDirs;
        destSection.commit(destLib);
        int i = 0;
        while (i < subCount) {
            if (srcSubDirs[i].getHeader() > 0) {
                ArchiveSection srcSection = srcSubDirs[i].getSection(srcLib);
                ((ISection)srcSection).reset(srcLib, destLib, destSubDirs[i].getHeader());
                srcSubDirs[i].releaseSubSection();
            }
            ++i;
        }
    }
}

