/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.vdb;

import com.scudata.vdb.ISection;
import com.scudata.vdb.Library;
import java.io.IOException;
import java.io.RandomAccessFile;

class BlockManager {
    private static final int ALLUSED = -1;
    private Library library;
    private volatile int totalBlockCount;
    private int[] blockSigns;
    private int signIndex;
    private boolean stopSign = false;

    public BlockManager(Library library) {
        this.library = library;
    }

    private void setBlockCount(int n) {
        int len = n / 32;
        if (n % 32 != 0) {
            ++len;
        }
        if (this.blockSigns == null) {
            this.blockSigns = new int[len];
        } else {
            int[] tmp = new int[len];
            System.arraycopy(this.blockSigns, 0, tmp, 0, this.blockSigns.length);
            this.blockSigns = tmp;
        }
    }

    private void setBlockUnused(int block) {
        int m = block / 32;
        int n = block % 32;
        int n2 = m;
        this.blockSigns[n2] = this.blockSigns[n2] & ~(1 << n);
        if (this.signIndex > m) {
            this.signIndex = m;
        }
    }

    public void setBlockUsed(int block) {
        int m = block / 32;
        int n = block % 32;
        int n2 = m;
        this.blockSigns[n2] = this.blockSigns[n2] | 1 << n;
    }

    public void setBlocksUsed(int[] blocks) {
        int[] nArray = blocks;
        int n = blocks.length;
        int n2 = 0;
        while (n2 < n) {
            int block = nArray[n2];
            int m = block / 32;
            int n3 = block % 32;
            int n4 = m;
            this.blockSigns[n4] = this.blockSigns[n4] | 1 << n3;
            ++n2;
        }
    }

    public void start(RandomAccessFile file) throws IOException {
        if (file == null) {
            this.scanUsedBlocks();
        } else {
            this.totalBlockCount = file.readInt();
            int len = file.readInt();
            int[] blockSigns = new int[len];
            this.blockSigns = blockSigns;
            int i = 0;
            while (i < len) {
                blockSigns[i] = file.readInt();
                ++i;
            }
        }
    }

    boolean getStopSign() {
        return this.stopSign;
    }

    public void stop() {
        this.stopSign = true;
    }

    void doThreadScan() throws IOException {
        int total;
        this.totalBlockCount = total = (int)(this.library.getFile().length() / 1024L);
        this.setBlockCount(total);
        ISection section = this.library.getRootSection();
        section.scanUsedBlocks(this.library, this);
        this.setBlockUsed(0);
    }

    private void scanUsedBlocks() throws IOException {
        int total;
        this.totalBlockCount = total = (int)(this.library.getFile().length() / 1024L);
        this.setBlockCount(total);
        ISection section = this.library.getRootSection();
        section.scanUsedBlocks(this.library, this);
        this.setBlockUsed(0);
    }

    private void enlargeFile() {
        this.totalBlockCount += 8192;
        this.library.enlargeFile((long)this.totalBlockCount * 1024L);
        this.setBlockCount(this.totalBlockCount);
    }

    /*
     * Unable to fully structure code
     */
    public synchronized int[] applyHeaderBlocks(int block, int blockCount) {
        if (blockCount == 1) {
            return new int[]{block};
        }
        blocks = new int[blockCount];
        blocks[0] = block;
        m = block / 32;
        if (m < this.signIndex) {
            m = this.signIndex;
        }
        blockSigns = this.blockSigns;
        count = blockSigns.length;
        i = 1;
        ** GOTO lbl32
        {
            block5: {
                if (blockSigns[m] == -1) break block5;
                sign = blockSigns[m];
                n = 0;
                while (n < 32) {
                    block6: {
                        if ((sign & 1 << n) != 0) break block6;
                        v0 = m;
                        blockSigns[v0] = blockSigns[v0] | 1 << n;
                        blocks[i] = m * 32 + n;
                        ** GOTO lbl31
                    }
                    ++n;
                }
            }
            ++m;
            do {
                if (m < count) continue block0;
                blocks[i] = this.totalBlockCount;
                this.enlargeFile();
                this.setBlockUsed(blocks[i]);
lbl31:
                // 2 sources

                ++i;
lbl32:
                // 2 sources

            } while (i < blockCount);
        }
        this.signIndex = m;
        return blocks;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized int[] applyDataBlocks(int block, int blockCount) {
        m = block / 32;
        if (m < this.signIndex) {
            m = this.signIndex;
        }
        blockSigns = this.blockSigns;
        count = blockSigns.length;
        blocks = new int[blockCount];
        i = 0;
        ** GOTO lbl29
        {
            block4: {
                if (blockSigns[m] == -1) break block4;
                sign = blockSigns[m];
                n = 0;
                while (n < 32) {
                    block5: {
                        if ((sign & 1 << n) != 0) break block5;
                        v0 = m;
                        blockSigns[v0] = blockSigns[v0] | 1 << n;
                        blocks[i] = m * 32 + n;
                        ** GOTO lbl28
                    }
                    ++n;
                }
            }
            ++m;
            do {
                if (m < count) continue block0;
                blocks[i] = this.totalBlockCount;
                this.enlargeFile();
                this.setBlockUsed(blocks[i]);
lbl28:
                // 2 sources

                ++i;
lbl29:
                // 2 sources

            } while (i < blockCount);
        }
        this.signIndex = m;
        return blocks;
    }

    public synchronized int applyHeaderBlock() {
        int[] blockSigns = this.blockSigns;
        int count = blockSigns.length;
        int m = this.signIndex;
        while (m < count) {
            if (blockSigns[m] != -1) {
                int sign = blockSigns[m];
                int n = 0;
                while (n < 32) {
                    if ((sign & 1 << n) == 0) {
                        this.signIndex = m;
                        int n2 = m;
                        blockSigns[n2] = blockSigns[n2] | 1 << n;
                        return m * 32 + n;
                    }
                    ++n;
                }
            }
            ++m;
        }
        int result = this.totalBlockCount;
        this.signIndex = count;
        this.enlargeFile();
        this.setBlockUsed(result);
        return result;
    }

    public synchronized void recycleBlock(int block) {
        this.setBlockUnused(block);
    }

    public synchronized void recycleBlocks(int[] blocks) {
        int[] nArray = blocks;
        int n = blocks.length;
        int n2 = 0;
        while (n2 < n) {
            int block = nArray[n2];
            this.setBlockUnused(block);
            ++n2;
        }
    }

    public synchronized void recycleBlocks(int[] blocks, int pos) {
        int len = blocks.length;
        while (pos < len) {
            this.setBlockUnused(blocks[pos]);
            ++pos;
        }
    }

    void writeTempFile(RandomAccessFile file) throws IOException {
        int[] blockSigns = this.blockSigns;
        int len = blockSigns.length;
        file.writeInt(this.totalBlockCount);
        file.writeInt(len);
        int[] nArray = blockSigns;
        int n = blockSigns.length;
        int n2 = 0;
        while (n2 < n) {
            int sign = nArray[n2];
            file.writeInt(sign);
            ++n2;
        }
    }
}

