/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.vdb;

import com.scudata.dm.ObjectReader;
import com.scudata.dm.ObjectWriter;
import com.scudata.util.HashUtil;
import com.scudata.vdb.BlockManager;
import com.scudata.vdb.Dir;
import com.scudata.vdb.DirZone;
import com.scudata.vdb.ISection;
import com.scudata.vdb.Library;
import com.scudata.vdb.Section;
import com.scudata.vdb.VDB;
import com.scudata.vdb.Zone;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;

class HeaderBlock {
    private int[] otherBlocks;
    private byte sign;
    private long commitTime;
    private ArrayList<Zone> fileZones;
    private ArrayList<Dir> subDirs;

    public void read(byte[] bytes, Section section) throws IOException {
        int i;
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        ObjectReader reader = new ObjectReader(bis);
        int count = reader.readInt32();
        if (count > 0) {
            this.otherBlocks = new int[count];
            i = 0;
            while (i < count) {
                this.otherBlocks[i] = reader.readInt32();
                ++i;
            }
        }
        this.sign = reader.readByte();
        this.commitTime = reader.readLong64();
        count = reader.readInt();
        if (count > 0) {
            this.fileZones = new ArrayList(count);
            i = 0;
            while (i < count) {
                Zone zone = new Zone();
                zone.read(reader);
                this.fileZones.add(zone);
                ++i;
            }
        }
        if ((count = reader.readInt()) > 0) {
            this.subDirs = new ArrayList(count);
            i = 0;
            while (i < count) {
                Dir dir = new Dir(section);
                dir.read(reader);
                this.subDirs.add(dir);
                ++i;
            }
        }
        reader.close();
    }

    private byte[] toBytes() throws IOException {
        int count;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        ObjectWriter writer = new ObjectWriter(bos);
        writer.writeByte(this.sign);
        writer.writeLong64(this.commitTime);
        ArrayList<Zone> fileZones = this.fileZones;
        int n = count = fileZones == null ? 0 : fileZones.size();
        if (count > 0) {
            Zone lastZone = fileZones.get(count - 1);
            writer.writeInt(1);
            lastZone.write(writer);
        } else {
            writer.writeInt(0);
        }
        ArrayList<Dir> subDirs = this.subDirs;
        count = subDirs == null ? 0 : subDirs.size();
        writer.writeInt(count);
        if (count > 0) {
            for (Dir dir : subDirs) {
                dir.write(writer);
            }
        }
        writer.close();
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Library library, int header, int outerSeq, long innerSeq) throws IOException {
        ArrayList<Dir> subDirs;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        ObjectWriter writer = new ObjectWriter(bos);
        this.commitTime = System.currentTimeMillis();
        writer.writeByte(this.sign);
        writer.writeLong64(this.commitTime);
        ArrayList<Zone> fileZones = this.fileZones;
        int count = fileZones == null ? 0 : fileZones.size();
        writer.writeInt(count);
        if (count > 0) {
            Zone lastZone = fileZones.get(count - 1);
            if (!lastZone.isCommitted()) {
                HeaderBlock headerBlock = this;
                synchronized (headerBlock) {
                    lastZone.setTxSeq(outerSeq, innerSeq);
                }
            }
            for (Zone zone : fileZones) {
                zone.write(writer);
            }
        }
        count = (subDirs = this.subDirs) == null ? 0 : subDirs.size();
        writer.writeInt(count);
        if (count > 0) {
            for (Dir dir : subDirs) {
                dir.write(writer, library, outerSeq, innerSeq);
            }
        }
        writer.close();
        byte[] bytes = bos.toByteArray();
        this.otherBlocks = library.writeHeaderBlock(header, this.otherBlocks, bytes);
    }

    public synchronized Dir getSubDir(Object path) {
        if (this.subDirs == null) {
            return null;
        }
        for (Dir dir : this.subDirs) {
            if (!dir.isEqualValue(path)) continue;
            return dir;
        }
        return null;
    }

    public synchronized Dir[] getSubDirs() {
        if (this.subDirs == null || this.subDirs.size() == 0) {
            return null;
        }
        Dir[] dirs = new Dir[this.subDirs.size()];
        this.subDirs.toArray(dirs);
        return dirs;
    }

    public ArrayList<ISection> getSubList(Library library) {
        if (this.subDirs == null || this.subDirs.size() == 0) {
            return null;
        }
        int size = this.subDirs.size();
        ArrayList<ISection> list = new ArrayList<ISection>(size);
        for (Dir dir : this.subDirs) {
            DirZone zone = dir.getLastZone();
            if (!zone.valid()) continue;
            list.add(zone.getSection(library, dir));
        }
        return list;
    }

    public synchronized Dir createSubDir(Object path, String name, Section section) {
        Dir dir2;
        if (this.subDirs == null) {
            this.subDirs = new ArrayList();
        } else {
            for (Dir dir2 : this.subDirs) {
                if (!dir2.isEqualValue(path)) continue;
                dir2.addZone(0);
                return dir2;
            }
        }
        dir2 = new Dir(path, name, section);
        this.subDirs.add(dir2);
        return dir2;
    }

    public synchronized void createFileZone(Library library, int block) {
        if (this.fileZones == null) {
            this.fileZones = new ArrayList();
        } else {
            Zone zone;
            int size = this.fileZones.size();
            if (size > 0 && !(zone = this.fileZones.get(size - 1)).isCommitted()) {
                library.recycleData(zone.getBlock());
                zone.setBlock(block);
                return;
            }
        }
        this.fileZones.add(new Zone(block));
    }

    public synchronized Zone getFileZone(VDB vdb, boolean isLockVDB) {
        ArrayList<Zone> fileZones = this.fileZones;
        if (fileZones == null) {
            return null;
        }
        int i = fileZones.size() - 1;
        while (i >= 0) {
            Zone zone = fileZones.get(i);
            if (zone.match(vdb, isLockVDB)) {
                return zone;
            }
            --i;
        }
        return null;
    }

    public synchronized void roolBack(Library library) {
        ArrayList<Dir> subDirs;
        int last;
        Zone zone;
        if (this.fileZones != null && this.fileZones.size() > 0 && !(zone = this.fileZones.get(last = this.fileZones.size() - 1)).isCommitted()) {
            int block = zone.getBlock();
            library.recycleData(block);
            if (last == 0) {
                this.fileZones = null;
            } else {
                this.fileZones.remove(last);
            }
        }
        if ((subDirs = this.subDirs) != null) {
            int i = subDirs.size() - 1;
            while (i >= 0) {
                Dir dir = subDirs.get(i);
                if (dir.roolBack() == 0) {
                    subDirs.remove(i);
                }
                --i;
            }
            if (subDirs.size() == 0) {
                subDirs = null;
            }
        }
    }

    public synchronized void deleteOutdatedZone(Library library, int outerSeq, long txSeq) {
        ArrayList<Dir> subDirs;
        ArrayList<Zone> fileZones = this.fileZones;
        if (fileZones != null && fileZones.size() > 1) {
            int last = fileZones.size() - 1;
            last = fileZones.get(last).isCommitted() ? --last : (last -= 2);
            while (last >= 0) {
                Zone zone = fileZones.get(last);
                if (zone.canDelete(outerSeq, txSeq)) {
                    while (last >= 0) {
                        fileZones.remove(last);
                        --last;
                    }
                    break;
                }
                --last;
            }
        }
        if ((subDirs = this.subDirs) != null) {
            for (Dir dir : subDirs) {
                dir.deleteOutdatedZone(library, outerSeq, txSeq);
            }
        }
    }

    public void scanUsedBlocks(Library library, BlockManager manager) throws IOException {
        ArrayList<Dir> subDirs;
        ArrayList<Zone> fileZones;
        if (this.otherBlocks != null) {
            manager.setBlocksUsed(this.otherBlocks);
        }
        if ((fileZones = this.fileZones) != null) {
            Zone zone;
            if (manager.getStopSign()) {
                return;
            }
            int size = fileZones.size();
            if (size > 1) {
                zone = fileZones.get(size - 1);
                fileZones.clear();
                fileZones.add(zone);
            } else {
                zone = fileZones.get(0);
            }
            int block = zone.getBlock();
            manager.setBlockUsed(block);
            int[] otherBlocks = library.readOtherBlocks(block);
            if (otherBlocks != null) {
                manager.setBlocksUsed(otherBlocks);
            }
        }
        if ((subDirs = this.subDirs) != null) {
            int i = subDirs.size() - 1;
            while (i >= 0) {
                if (manager.getStopSign()) {
                    return;
                }
                Dir dir = subDirs.get(i);
                dir.scanUsedBlocks(library, manager);
                --i;
            }
        }
    }

    public synchronized boolean isFile() {
        return this.fileZones != null;
    }

    public synchronized boolean isDir() {
        return this.subDirs != null;
    }

    public synchronized boolean isNullSection() {
        if (this.fileZones != null && this.fileZones.size() > 0) {
            return false;
        }
        if (this.subDirs == null) {
            return true;
        }
        for (Dir dir : this.subDirs) {
            DirZone lastZone = dir.getLastZone();
            if (lastZone == null || !lastZone.valid()) continue;
            return false;
        }
        return true;
    }

    public void removeSubDir(Dir dir) {
        this.subDirs.remove(dir);
    }

    public void deleteSubDir(Dir dir) {
        dir.addZone(-1);
    }

    public void moveSubDir(Dir dir, ISection section) {
        dir.addZone(-2);
    }

    public void deleteAllSubDirs() {
        if (this.subDirs != null) {
            for (Dir dir : this.subDirs) {
                dir.addZone(-1);
            }
        }
    }

    public long getCommitTime() {
        return this.commitTime;
    }

    public boolean isKeySection() {
        return (this.sign & ISection.SIGN_KEY_SECTION) != 0;
    }

    public Dir getSubKeyDir(Object path) {
        int len = this.subDirs.size();
        int hash = HashUtil.hashCode(path, len);
        return this.subDirs.get(hash);
    }

    public void setKeySection(VDB vdb, Section section, int len) {
        this.sign = (byte)(this.sign | ISection.SIGN_KEY_SECTION);
        ArrayList<Dir> subDirs = new ArrayList<Dir>(len);
        this.subDirs = subDirs;
        int i = 0;
        while (i < len) {
            Dir dir = new Dir(i, null, section);
            subDirs.add(dir);
            ++i;
        }
    }

    public void releaseSubSection() {
        if (this.subDirs != null) {
            for (Dir dir : this.subDirs) {
                dir.releaseSubSection();
            }
        }
    }

    public Zone getFileZone() {
        if (this.fileZones != null && this.fileZones.size() > 0) {
            return this.fileZones.get(this.fileZones.size() - 1);
        }
        return null;
    }

    public void reset(Library srcLib, Library destLib, int destHeader) throws IOException {
        int subDirCount;
        HeaderBlock dest = new HeaderBlock();
        dest.sign = this.sign;
        dest.commitTime = this.commitTime;
        int outerSeq = destLib.getOuterTxSeq();
        long innerSeq = destLib.getNextInnerTxSeq();
        Zone zone = this.getFileZone();
        if (zone != null) {
            Object data = zone.getData(srcLib);
            int block = destLib.writeDataBlock(destHeader, data);
            Zone destZone = new Zone(block);
            destZone.setTxSeq(outerSeq, innerSeq);
            dest.fileZones = new ArrayList(1);
            dest.fileZones.add(destZone);
        }
        ArrayList<Dir> srcSubDirs = this.subDirs;
        ArrayList<Dir> destSubDirs = null;
        if (srcSubDirs != null) {
            int subCount = srcSubDirs.size();
            destSubDirs = new ArrayList<Dir>(subCount);
            for (Dir srcDir : srcSubDirs) {
                DirZone srcDirZone = srcDir.getLastZone();
                if (srcDirZone == null || !srcDirZone.valid()) continue;
                Dir destDir = new Dir(srcDir.getValue(), srcDir.getName(), null);
                destSubDirs.add(destDir);
                DirZone destDirZone = destDir.getLastZone();
                destDirZone.setBlock(destLib.applyHeaderBlock());
                destDirZone.setTxSeq(outerSeq, innerSeq);
            }
        }
        int n = subDirCount = destSubDirs != null ? destSubDirs.size() : 0;
        if (subDirCount > 0) {
            dest.subDirs = destSubDirs;
        }
        byte[] bytes = dest.toBytes();
        destLib.writeHeaderBlock(destHeader, null, bytes);
        if (subDirCount > 0) {
            int q = 0;
            for (Dir srcDir : srcSubDirs) {
                DirZone srcDirZone = srcDir.getLastZone();
                if (srcDirZone == null || !srcDirZone.valid()) continue;
                ISection srcSection = srcDirZone.getSection(srcLib, srcDir);
                Dir destDir = (Dir)destSubDirs.get(q++);
                int destSubHeader = destDir.getLastZone().getBlock();
                srcSection.reset(srcLib, destLib, destSubHeader);
                srcDirZone.releaseSection();
            }
        }
    }
}

