/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.vdb;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.ObjectReader;
import com.scudata.dm.ObjectWriter;
import com.scudata.dm.Param;
import com.scudata.dm.ParamList;
import com.scudata.dm.Record;
import com.scudata.dm.Sequence;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;
import com.scudata.vdb.BlockManager;
import com.scudata.vdb.ISection;
import com.scudata.vdb.VDB;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.LinkedList;

public class Library {
    public static final long MAXWAITTIME = 8000L;
    public static final int BLOCKSIZE = 1024;
    public static final int ENLARGE_BLOCKCOUNT = 8192;
    private static final long SLEEPTIME = 300000L;
    private static final long SCANFILEINTERVAL = 3600000L;
    private static ParamList libList = new ParamList();
    private long createTime;
    private long startTime;
    private long stopTime;
    private int rootHeaderBlock = 1;
    private int outerTxSeq = 1;
    private transient long innerTxSeq = 0L;
    private transient long loadTxSeq = 0L;
    private String pathName;
    private RandomAccessFile file;
    private FileChannel channel;
    private boolean isStarted = false;
    private BlockManager blockManager;
    private LinkedList<VDB> vdbList = new LinkedList();
    private ISection rootSection;
    private volatile long lastConnectTime = System.currentTimeMillis();
    private OptimizeThread optThread;

    public Library(String pathName) {
        this.pathName = pathName;
    }

    private static String getParamName(String path) {
        String paramName = path.replace('\\', '/');
        return paramName.toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Library instance(String pathName) {
        Library library;
        String paramName = Library.getParamName(pathName);
        ParamList paramList = libList;
        synchronized (paramList) {
            Param p = libList.get(paramName);
            if (p != null) {
                library = (Library)p.getValue();
            } else {
                System.out.println("\u542f\u52a8\u6570\u636e\u5e93\uff1a" + pathName);
                library = new Library(pathName);
                library.start();
                libList.add(new Param(paramName, 0, library));
            }
        }
        return library;
    }

    public String getPathName() {
        return this.pathName;
    }

    RandomAccessFile getFile() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enlargeFile(long size) {
        try {
            RandomAccessFile randomAccessFile = this.file;
            synchronized (randomAccessFile) {
                this.file.setLength(size);
            }
        }
        catch (IOException e) {
            this.processIOException(e);
        }
    }

    private void processIOException(IOException e) {
        e.printStackTrace();
    }

    int applyHeaderBlock() {
        return this.blockManager.applyHeaderBlock();
    }

    void recycleBlock(int block) {
        this.blockManager.recycleBlock(block);
    }

    void recycleBlocks(int[] blocks) {
        this.blockManager.recycleBlocks(blocks);
    }

    void recycleData(int block) {
        try {
            int[] blocks = this.readOtherBlocks(block);
            if (blocks != null) {
                this.blockManager.recycleBlocks(blocks);
            }
        }
        catch (IOException e) {
            this.processIOException(e);
        }
        this.blockManager.recycleBlock(block);
    }

    public synchronized boolean start() {
        if (this.file != null) {
            return false;
        }
        RandomAccessFile tempFile = null;
        try {
            try {
                block24: {
                    this.startTime = System.currentTimeMillis();
                    this.innerTxSeq = 0L;
                    this.loadTxSeq = 0L;
                    File tmp = new File(this.pathName);
                    if (!tmp.exists() || tmp.length() == 0L) {
                        this.file = new RandomAccessFile(this.pathName, "rw");
                        this.file.setLength(0x800000L);
                        this.createTime = this.startTime;
                    } else {
                        this.file = new RandomAccessFile(this.pathName, "rw");
                        this.readDBHeader(this.file);
                        ++this.outerTxSeq;
                        try {
                            tempFile = new RandomAccessFile(String.valueOf(this.pathName) + ".tmp", "r");
                            tempFile.seek(0L);
                            if (tempFile.length() >= 16L && tempFile.readInt() != 0 && tempFile.readLong() == this.stopTime) break block24;
                            try {
                                try {
                                    tempFile.close();
                                }
                                catch (IOException iOException) {
                                    tempFile = null;
                                    break block24;
                                }
                            }
                            catch (Throwable throwable) {
                                tempFile = null;
                                throw throwable;
                            }
                            tempFile = null;
                        }
                        catch (Exception e) {
                            try {
                                try {
                                    if (tempFile != null) {
                                        tempFile.close();
                                    }
                                }
                                catch (IOException iOException) {
                                    tempFile = null;
                                    break block24;
                                }
                            }
                            catch (Throwable throwable) {
                                tempFile = null;
                                throw throwable;
                            }
                            tempFile = null;
                        }
                    }
                }
                this.channel = this.file.getChannel();
                this.writeDBHeader(this.file);
                this.rootSection = ISection.read(this, this.rootHeaderBlock, null);
                this.blockManager = new BlockManager(this);
                this.blockManager.start(tempFile);
            }
            catch (IOException e) {
                throw new RQException(e.getMessage(), e);
            }
        }
        finally {
            try {
                if (tempFile != null) {
                    tempFile.close();
                }
            }
            catch (IOException iOException) {}
        }
        this.isStarted = true;
        this.optThread = new OptimizeThread();
        this.optThread.start();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean stop(boolean sign) {
        if (!this.isStarted) {
            return false;
        }
        this.isStarted = false;
        this.rootSection = null;
        Object object = libList;
        synchronized (object) {
            int i = 0;
            while (i < libList.count()) {
                Param param = libList.get(i);
                if (param.getValue() == this) {
                    libList.remove(i);
                    break;
                }
                ++i;
            }
        }
        object = this.file;
        synchronized (object) {
            try {
                this.writeDBHeader(this.file);
                this.file.close();
            }
            catch (IOException e) {
                throw new RQException(e.getMessage(), e);
            }
        }
        if (sign) {
            this.writeTempFile();
        }
        this.blockManager.stop();
        this.blockManager = null;
        this.file = null;
        this.channel = null;
        return true;
    }

    public synchronized boolean stop() {
        return this.stop(true);
    }

    private void writeTempFile() {
        RandomAccessFile tempFile = null;
        try {
            try {
                tempFile = new RandomAccessFile(String.valueOf(this.pathName) + ".tmp", "rw");
                tempFile.seek(0L);
                tempFile.writeInt(0);
                tempFile.writeLong(this.stopTime);
                this.blockManager.writeTempFile(tempFile);
                tempFile.seek(0L);
                tempFile.writeInt(1);
            }
            catch (IOException iOException) {
                try {
                    if (tempFile != null) {
                        tempFile.close();
                    }
                }
                catch (IOException iOException2) {}
            }
        }
        finally {
            try {
                if (tempFile != null) {
                    tempFile.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public synchronized boolean isStarted() {
        return this.isStarted;
    }

    synchronized long getLoadTxSeq() {
        return this.loadTxSeq;
    }

    synchronized void addTxSeq() {
        this.loadTxSeq = ++this.innerTxSeq;
    }

    long getNextInnerTxSeq() {
        return this.innerTxSeq + 1L;
    }

    int getOuterTxSeq() {
        return this.outerTxSeq;
    }

    ISection getRootSection() {
        return this.rootSection;
    }

    private void writeDBHeader(RandomAccessFile file) throws IOException {
        file.seek(0L);
        byte[] signs = new byte[]{114, 113, 118, 100, 98};
        file.write(signs);
        file.writeLong(this.createTime);
        file.writeLong(this.startTime);
        file.writeInt(this.rootHeaderBlock);
        file.writeInt(this.outerTxSeq);
        this.stopTime = System.currentTimeMillis();
        file.writeLong(this.stopTime);
        this.channel.force(false);
    }

    private void readDBHeader(RandomAccessFile file) throws IOException {
        file.seek(0L);
        if (file.read() != 114 || file.read() != 113 || file.read() != 118 || file.read() != 100 || file.read() != 98) {
            file.close();
            file = null;
            throw new RQException("\u975e\u6cd5\u7684\u6570\u636e\u5e93\u6587\u4ef6");
        }
        this.createTime = file.readLong();
        this.startTime = file.readLong();
        this.rootHeaderBlock = file.readInt();
        this.outerTxSeq = file.readInt();
        this.stopTime = file.readLong();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VDB createVDB() {
        if (!this.isStarted()) {
            throw new RQException("\u6570\u636e\u5e93\u5c1a\u672a\u542f\u52a8");
        }
        VDB vdb = new VDB(this);
        LinkedList<VDB> linkedList = this.vdbList;
        synchronized (linkedList) {
            this.vdbList.addLast(vdb);
            this.lastConnectTime = System.currentTimeMillis();
            this.optThread.setUserOn();
        }
        return vdb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteVDB(VDB vdb) {
        LinkedList<VDB> linkedList = this.vdbList;
        synchronized (linkedList) {
            this.vdbList.remove(vdb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int commit(VDB vdb) {
        ArrayList<ISection> modifySections = vdb.getModifySections();
        if (modifySections.size() == 0) {
            return 0;
        }
        long txSeq = this.getEarliestTxSeq();
        int outerSeq = this.getOuterTxSeq();
        for (ISection section : modifySections) {
            section.deleteOutdatedZone(this, outerSeq, txSeq);
        }
        RandomAccessFile randomAccessFile = this.file;
        synchronized (randomAccessFile) {
            try {
                long innerSeq = this.getNextInnerTxSeq();
                for (ISection section : modifySections) {
                    section.commit(this, outerSeq, innerSeq);
                }
                this.addTxSeq();
                this.channel.force(false);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.rollback(vdb);
            }
        }
        return 0;
    }

    void rollback(VDB vdb) {
        ArrayList<ISection> modifySections = vdb.getModifySections();
        for (ISection section : modifySections) {
            section.rollBack(this);
        }
    }

    BlockManager getBlockManager() {
        return this.blockManager;
    }

    private int getBlockCount(int dataLen) {
        int count = dataLen / 1020;
        int mod = dataLen % 1020;
        return mod != 0 ? count + 1 : count;
    }

    private long getBlockPos(int block) {
        return 1024L * (long)block;
    }

    private static byte[] toByteArray(Object data) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        ObjectWriter writer = new ObjectWriter(bos);
        writer.writeByte(0);
        if (data instanceof Record) {
            Sequence seq = new Sequence(1);
            seq.add(data);
            writer.writeObject(seq);
        } else {
            writer.writeObject(data);
        }
        writer.close();
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBlocks(int[] blocks, byte[] data) throws IOException {
        RandomAccessFile file;
        int count = blocks.length;
        int headerSize = count * 4;
        RandomAccessFile randomAccessFile = file = this.file;
        synchronized (randomAccessFile) {
            int i;
            file.seek(this.getBlockPos(blocks[0]));
            file.writeInt(count - 1);
            int b = 0;
            int pos = headerSize;
            if (headerSize <= 1024) {
                i = 1;
                while (i < count) {
                    file.writeInt(blocks[i]);
                    ++i;
                }
            } else {
                pos = 4;
                i = 1;
                while (i < count) {
                    if (pos == 1024) {
                        pos = 0;
                        file.seek(this.getBlockPos(blocks[++b]));
                    }
                    file.writeInt(blocks[i]);
                    pos += 4;
                    ++i;
                }
            }
            if (count == 1) {
                file.write(data);
            } else {
                int len = data.length;
                int index = 1024 - pos;
                file.write(data, 0, index);
                ++b;
                while (b < count) {
                    file.seek(this.getBlockPos(blocks[b]));
                    if (len - index >= 1024) {
                        file.write(data, index, 1024);
                        index += 1024;
                    } else {
                        file.write(data, index, len - index);
                    }
                    ++b;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] readBlocks(int block) throws IOException {
        RandomAccessFile file;
        RandomAccessFile randomAccessFile = file = this.file;
        synchronized (randomAccessFile) {
            file.seek(this.getBlockPos(block));
            int count = file.readInt();
            if (count == 0) {
                byte[] bytes = new byte[1024];
                file.read(bytes, 4, 1020);
                return bytes;
            }
            int[] blocks = new int[++count];
            blocks[0] = block;
            int headerSize = count * 4;
            if (headerSize <= 1024) {
                int i = 1;
                while (i < count) {
                    blocks[i] = file.readInt();
                    ++i;
                }
            } else {
                int b = 0;
                int pos = 4;
                int i = 1;
                while (i < count) {
                    if (pos == 1024) {
                        pos = 0;
                        file.seek(this.getBlockPos(blocks[++b]));
                    }
                    blocks[i] = file.readInt();
                    pos += 4;
                    ++i;
                }
            }
            byte[] bytes = new byte[1024 * count];
            int i = 0;
            while (i < count) {
                file.seek(this.getBlockPos(blocks[i]));
                file.read(bytes, 1024 * i, 1024);
                ++i;
            }
            return bytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int[] readOtherBlocks(int block) throws IOException {
        RandomAccessFile file;
        RandomAccessFile randomAccessFile = file = this.file;
        synchronized (randomAccessFile) {
            int count;
            block6: {
                file.seek(this.getBlockPos(block));
                count = file.readInt();
                if (count != 0) break block6;
                return null;
            }
            int[] blocks = new int[count];
            int b = 0;
            int pos = 4;
            int i = 0;
            while (i < count) {
                if (pos == 1024) {
                    file.seek(this.getBlockPos(blocks[b]));
                    ++b;
                    pos = 0;
                }
                blocks[i] = file.readInt();
                pos += 4;
                ++i;
            }
            return blocks;
        }
    }

    int writeDataBlock(int pos, Object data) {
        try {
            byte[] bytes = Library.toByteArray(data);
            return this.writeDataBlock(pos, bytes);
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
    }

    int writeDataBlock(int pos, byte[] bytes) throws IOException {
        int blockCount = this.getBlockCount(bytes.length);
        int[] blocks = this.blockManager.applyDataBlocks(pos, blockCount);
        this.writeBlocks(blocks, bytes);
        return blocks[0];
    }

    Object readDataBlock(int block) throws IOException {
        byte[] bytes = this.readBlocks(block);
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        ObjectReader reader = new ObjectReader(bis);
        int blockCount = reader.readInt32();
        int i = 0;
        while (i < blockCount) {
            reader.readInt32();
            ++i;
        }
        reader.readByte();
        Object data = reader.readObject();
        reader.close();
        return data;
    }

    static int getDataPos(byte[] bytes) {
        int blockCount = (bytes[0] << 24) + ((bytes[1] & 0xFF) << 16) + ((bytes[2] & 0xFF) << 8) + (bytes[3] & 0xFF);
        return blockCount * 4 + 4;
    }

    int[] writeHeaderBlock(int block, int[] otherBlocks, byte[] bytes) throws IOException {
        int[] blocks;
        int blockCount;
        int oldCount;
        block10: {
            try {
                oldCount = 1;
                blockCount = this.getBlockCount(bytes.length);
                if (otherBlocks == null) {
                    blocks = this.blockManager.applyHeaderBlocks(block, blockCount);
                } else if ((oldCount += otherBlocks.length) == blockCount) {
                    blocks = new int[blockCount];
                    blocks[0] = block;
                    System.arraycopy(otherBlocks, 0, blocks, 1, blockCount - 1);
                } else if (oldCount < blockCount) {
                    this.blockManager.recycleBlocks(otherBlocks);
                    blocks = this.blockManager.applyHeaderBlocks(block, blockCount);
                } else {
                    blocks = new int[blockCount];
                    blocks[0] = block;
                    System.arraycopy(otherBlocks, 0, blocks, 1, blockCount - 1);
                    this.blockManager.recycleBlocks(otherBlocks, blockCount - 1);
                }
                this.writeBlocks(blocks, bytes);
                if (blockCount != 1) break block10;
                return null;
            }
            catch (IOException e) {
                throw new RQException(e.getMessage(), e);
            }
        }
        if (oldCount == blockCount) {
            return otherBlocks;
        }
        otherBlocks = new int[blockCount - 1];
        System.arraycopy(blocks, 1, otherBlocks, 0, blockCount - 1);
        return otherBlocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getEarliestTxSeq() {
        VDB[] vdbs;
        long seq = this.getLoadTxSeq();
        LinkedList<VDB> linkedList = this.vdbList;
        synchronized (linkedList) {
            int size = this.vdbList.size();
            vdbs = new VDB[size];
            this.vdbList.toArray(vdbs);
        }
        VDB[] vDBArray = vdbs;
        int n = vdbs.length;
        int n2 = 0;
        while (n2 < n) {
            VDB vdb = vDBArray[n2];
            long q = vdb.getLoadTxSeq();
            if (q < seq) {
                seq = q;
            }
            ++n2;
        }
        return seq;
    }

    public int createKeyLibrary(Object[] keys, int[] lens) {
        int count = keys.length;
        ISection rootSection = this.rootSection;
        VDB vdb = new VDB(this);
        int i = 0;
        while (i < count) {
            Object key = keys[i];
            int j = i + 1;
            while (j < count) {
                if (Variant.isEquals(key, keys[j])) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(key + mm.getMessage("engine.dupKeys"));
                }
                ++j;
            }
            if (rootSection.getSub(vdb, key) != null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(key + mm.getMessage("engine.dupKeys"));
            }
            int result = rootSection.createSubKeyDir(vdb, key, lens[i]);
            if (result != 0) {
                this.rollback(vdb);
                return result;
            }
            ++i;
        }
        this.commit(vdb);
        return 0;
    }

    public boolean reset(String destFileName) {
        VDB vdb = this.createVDB();
        Library dest = new Library(destFileName);
        try {
            dest.start();
            dest.createVDB();
            this.rootSection.reset(this, dest, dest.rootHeaderBlock);
            dest.stop(false);
            return true;
        }
        catch (Exception e) {
            if (dest.file != null) {
                try {
                    dest.file.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        finally {
            this.deleteVDB(vdb);
        }
        return false;
    }

    private class OptimizeThread
    extends Thread {
        private long scanTime = 0L;
        private volatile boolean userOn;
        private BlockManager manager = null;

        private OptimizeThread() {
        }

        public void setUserOn() {
            this.userOn = true;
            if (this.manager != null) {
                this.manager.stop();
            }
        }

        @Override
        public void run() {
            while (Library.this.isStarted) {
                try {
                    OptimizeThread.sleep(300000L);
                    if (!Library.this.isStarted) continue;
                    this.doWork();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doWork() throws IOException {
            LinkedList linkedList = Library.this.vdbList;
            synchronized (linkedList) {
                if (Library.this.vdbList.size() == 0) {
                    Library.this.rootSection.releaseSubSection();
                    this.userOn = false;
                    long now = System.currentTimeMillis();
                    if (now - Library.this.lastConnectTime < 300000L || Library.this.lastConnectTime - this.scanTime < 3600000L) {
                        return;
                    }
                } else {
                    return;
                }
            }
            this.manager = new BlockManager(Library.this);
            this.manager.doThreadScan();
            linkedList = Library.this.vdbList;
            synchronized (linkedList) {
                if (Library.this.vdbList.size() == 0) {
                    Library.this.rootSection.releaseSubSection();
                    if (!this.userOn) {
                        this.scanTime = System.currentTimeMillis();
                        Library.this.blockManager = this.manager;
                    }
                }
                this.manager = null;
            }
        }
    }
}

