/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.vdb;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.ComputeStack;
import com.scudata.dm.Context;
import com.scudata.dm.Current;
import com.scudata.dm.DataStruct;
import com.scudata.dm.IResource;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.expression.Expression;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;
import com.scudata.vdb.ArchiveSection;
import com.scudata.vdb.ISection;
import com.scudata.vdb.IVS;
import com.scudata.vdb.Library;
import com.scudata.vdb.Section;
import com.scudata.vdb.VS;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;

public class VDB
implements IVS,
IResource {
    public static final int S_SUCCESS = 0;
    public static final int S_LOCKTIMEOUT = 1;
    public static final int S_LOCKTWICE = -1;
    public static final int S_PATHNOTEXIST = 2;
    public static final int S_TARGETPATHEXIST = 3;
    public static final int S_IOERROR = 4;
    public static final int S_PARAMTYPEERROR = 5;
    public static final int S_PARAMERROR = 6;
    public static final int S_ACHEIVED = 7;
    private static final long LATEST_TX_SEQ = Long.MAX_VALUE;
    private Library library;
    private ISection rootSection;
    private ArrayList<ISection> modifySections = new ArrayList();
    private int error = 0;
    private boolean isAutoCommit = true;
    private long loadTxSeq = Long.MAX_VALUE;

    public VDB(Library library) {
        this.library = library;
        this.rootSection = library.getRootSection();
    }

    public void checkValid() {
        if (this.library == null) {
            throw new RQException("\u8fde\u63a5\u5173\u95ed");
        }
    }

    int getOuterTxSeq() {
        return this.library.getOuterTxSeq();
    }

    long getLoadTxSeq() {
        return this.loadTxSeq;
    }

    public Library getLibrary() {
        return this.library;
    }

    public boolean begin() {
        this.checkValid();
        if (!this.isAutoCommit) {
            return false;
        }
        this.error = 0;
        this.isAutoCommit = false;
        this.loadTxSeq = this.library.getLoadTxSeq();
        return true;
    }

    public int commit() {
        if (this.error != 0) {
            int result = this.error;
            this.rollback();
            return result;
        }
        this.checkValid();
        this.isAutoCommit = true;
        this.loadTxSeq = Long.MAX_VALUE;
        this.library.commit(this);
        this.modifySections.clear();
        return 0;
    }

    public void rollback() {
        this.checkValid();
        this.error = 0;
        this.isAutoCommit = true;
        this.loadTxSeq = Long.MAX_VALUE;
        this.library.rollback(this);
        this.modifySections.clear();
    }

    @Override
    public void close() {
        if (this.library != null) {
            this.rollback();
            this.library.deleteVDB(this);
            this.library = null;
            this.rootSection = null;
            this.modifySections = null;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    @Override
    public VDB getVDB() {
        return this;
    }

    @Override
    public ISection getHome() {
        return this.rootSection;
    }

    @Override
    public IVS home(Object path) {
        return this.home(this.rootSection, path);
    }

    @Override
    public Object path(String opt) {
        return null;
    }

    private boolean isAutoCommit() {
        return this.isAutoCommit;
    }

    private void resetError() {
        this.error = 0;
    }

    void setError(int error) {
        this.error = error;
        this.library.rollback(this);
        this.modifySections.clear();
    }

    int getError() {
        return this.error;
    }

    ArrayList<ISection> getModifySections() {
        return this.modifySections;
    }

    void addModifySection(ISection section) {
        this.modifySections.add(section);
    }

    void removeModifySection(ISection section) {
        this.modifySections.remove(section);
        section.rollBack(this.library);
    }

    @Override
    public int save(Object value) {
        return this.save(this.rootSection, value);
    }

    @Override
    public int save(Object value, Object path, Object name) {
        return this.save(this.rootSection, value, path, name);
    }

    @Override
    public int makeDir(Object path, Object name) {
        return this.makeDir(this.rootSection, path, name);
    }

    @Override
    public int lock(String opt) {
        return this.lock(this.rootSection, opt);
    }

    @Override
    public int lock(Object path, String opt) {
        return this.lock(this.rootSection, path, opt);
    }

    @Override
    public Sequence list(String opt) {
        return this.list(this.rootSection, opt);
    }

    @Override
    public Sequence list(Object path, String opt) {
        return this.list(this.rootSection, path, opt);
    }

    @Override
    public Object load(String opt) {
        return this.load(this.rootSection, opt);
    }

    @Override
    public Object load(Object path, String opt) {
        return this.load(this.rootSection, path, opt);
    }

    @Override
    public Timestamp date() {
        return this.date(this.rootSection);
    }

    @Override
    public Table importTable(String[] fields) {
        return this.importTable(this.rootSection, fields);
    }

    @Override
    public Table importTable(String[] fields, Expression[] filters, Context ctx) {
        return this.importTable(this.rootSection, fields, filters, ctx);
    }

    IVS home(ISection section, Object path) {
        this.checkValid();
        ISection sub = path instanceof Sequence ? section.getSub(this, (Sequence)path) : section.getSub(this, path);
        if (sub != null) {
            return new VS(this, sub);
        }
        return null;
    }

    Object load(ISection section, String opt) {
        this.checkValid();
        try {
            return section.load(this, opt);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.setError(4);
            return null;
        }
    }

    Object load(ISection section, Object path, String opt) {
        this.checkValid();
        try {
            return section.load(this, path, opt);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.setError(4);
            return null;
        }
    }

    Timestamp date(ISection section) {
        this.checkValid();
        return new Timestamp(section.getCommitTime());
    }

    Table importTable(ISection section, String[] fields) {
        this.checkValid();
        try {
            return section.importTable(this, fields);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.setError(4);
            return null;
        }
    }

    Table importTable(ISection section, String[] fields, Expression[] filters, Context ctx) {
        this.checkValid();
        try {
            return section.importTable(this, fields, filters, ctx);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.setError(4);
            return null;
        }
    }

    int save(ISection section, Object value) {
        this.checkValid();
        if (this.isAutoCommit) {
            this.resetError();
        } else if (this.error != 0) {
            return this.error;
        }
        int result = section.save(this, value);
        if (this.isAutoCommit()) {
            this.commit();
        }
        return result;
    }

    int save(ISection section, Object value, Object path, Object name) {
        this.checkValid();
        if (this.isAutoCommit) {
            this.resetError();
        } else if (this.error != 0) {
            return this.error;
        }
        int result = section.save(this, value, path, name);
        if (this.isAutoCommit()) {
            this.commit();
        }
        return result;
    }

    int makeDir(ISection section, Object path, Object name) {
        this.checkValid();
        if (this.isAutoCommit) {
            this.resetError();
        } else if (this.error != 0) {
            return this.error;
        }
        int result = section.makeDir(this, path, name);
        if (this.isAutoCommit()) {
            this.commit();
        }
        return result;
    }

    int lock(ISection section, String opt) {
        this.checkValid();
        if (!this.isAutoCommit && this.error != 0) {
            return this.error;
        }
        if (opt == null || opt.indexOf(117) == -1) {
            return section.lockForWrite(this);
        }
        section.unlock(this);
        return 0;
    }

    int lock(ISection section, Object path, String opt) {
        this.checkValid();
        if (!this.isAutoCommit && this.error != 0) {
            return this.error;
        }
        if (path instanceof Sequence) {
            ISection sub = section.getSub(this, (Sequence)path);
            if (sub != null) {
                if (opt == null || opt.indexOf(117) == -1) {
                    return sub.lockForWrite(this);
                }
                sub.unlock(this);
                return 0;
            }
            this.setError(2);
            return 2;
        }
        ISection sub = section.getSub(this, path);
        if (sub != null) {
            if (opt == null || opt.indexOf(117) == -1) {
                return sub.lockForWrite(this);
            }
            sub.unlock(this);
            return 0;
        }
        this.setError(2);
        return 2;
    }

    Sequence list(ISection section, String opt) {
        this.checkValid();
        return section.list(this, opt);
    }

    Sequence list(ISection section, Object path, String opt) {
        this.checkValid();
        if (path instanceof Sequence) {
            ISection sub = section.getSub(this, (Sequence)path);
            if (sub != null) {
                return sub.list(this, opt);
            }
            return null;
        }
        ISection sub = section.getSub(this, path);
        if (sub != null) {
            return sub.list(this, opt);
        }
        return null;
    }

    @Override
    public int delete(String opt) {
        return this.delete(this.rootSection, opt);
    }

    @Override
    public int delete(Object path, String opt) {
        ISection sub = path instanceof Sequence ? this.rootSection.getSub(this, (Sequence)path) : this.rootSection.getSub(this, path);
        return this.delete(sub, opt);
    }

    @Override
    public int deleteAll(Sequence paths) {
        return this.deleteAll(this.rootSection, paths);
    }

    int deleteAll(ISection root, Sequence paths) {
        this.checkValid();
        if (this.isAutoCommit) {
            this.resetError();
        } else if (this.error != 0) {
            return this.error;
        }
        int len = paths.length();
        if (len == 0) {
            return 0;
        }
        int result = 0;
        int i = 1;
        while (i <= len) {
            Object path = paths.getMem(i);
            ISection sub = path instanceof Sequence ? root.getSub(this, (Sequence)path) : root.getSub(this, path);
            if (sub != null && (result = sub.delete(this)) != 0) break;
            ++i;
        }
        if (this.isAutoCommit()) {
            this.commit();
        }
        return result;
    }

    int delete(ISection section, String opt) {
        this.checkValid();
        if (this.isAutoCommit) {
            this.resetError();
        } else if (this.error != 0) {
            return this.error;
        }
        if (section == null) {
            return 0;
        }
        int result = 0;
        if (opt == null || opt.indexOf(101) == -1) {
            result = section.delete(this);
        } else {
            section.deleteNullSection(this);
        }
        if (this.isAutoCommit()) {
            this.commit();
        }
        return result;
    }

    @Override
    public int move(Object srcPath, Object destPath, Object name) {
        return this.move(this.rootSection, srcPath, destPath, name);
    }

    /*
     * Unable to fully structure code
     */
    int move(ISection section, Object srcPath, Object destPath, Object name) {
        this.checkValid();
        if (this.isAutoCommit) {
            this.resetError();
        } else if (this.error != 0) {
            return this.error;
        }
        sub = null;
        if (srcPath instanceof Sequence) {
            sub = section.getSubForMove(this, (Sequence)srcPath);
        } else if (srcPath != null) {
            sub = section.getSubForMove(this, srcPath);
        }
        if (sub == null) {
            return 0;
        }
        dest = null;
        value = null;
        if (!(destPath instanceof Sequence)) ** GOTO lbl39
        seq = (Sequence)destPath;
        len = seq.length();
        if (len > 1) {
            tmp = new Sequence(len - 1);
            i = 1;
            while (i < len) {
                tmp.add(seq.getMem(i));
                ++i;
            }
            result = section.makeDir(this, tmp, name);
            if (result != 0) {
                return result;
            }
            dest = section.getSubForMove(this, tmp);
            value = seq.getMem(len);
        } else if (len == 1) {
            dest = sub.getParent();
            value = seq.getMem(1);
        } else {
            this.setError(2);
            return 2;
lbl39:
            // 1 sources

            if (destPath != null) {
                dest = sub.getParent();
                value = destPath;
            }
        }
        if (dest == null) {
            this.setError(2);
            return 2;
        }
        if (!(dest instanceof Section)) {
            throw ArchiveSection.getModifyException();
        }
        result = sub.move(this, (Section)dest, value);
        if (result != 0) {
            this.setError(result);
        }
        if (this.isAutoCommit()) {
            this.commit();
        }
        return result;
    }

    @Override
    public Table read(Sequence seq, Expression pathExp, String[] fields, Expression filter, Context ctx) {
        return this.read(this.rootSection, seq, pathExp, fields, filter, ctx);
    }

    Table read(ISection root, Sequence seq, Expression pathExp, String[] fields, Expression filter, Context ctx) {
        if (fields == null) {
            return this.read(root, seq, pathExp, filter, ctx);
        }
        this.checkValid();
        if (seq == null || seq.length() == 0) {
            return null;
        }
        DataStruct ds = seq.dataStruct();
        if (ds == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.needPurePmt"));
        }
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(seq);
        stack.push(current);
        String[] srcFields = ds.getFieldNames();
        int srcCount = srcFields.length;
        int len = seq.length();
        try {
            int count = fields.length;
            int totalCount = srcCount + count;
            String[] totalFields = new String[totalCount];
            System.arraycopy(srcFields, 0, totalFields, 0, srcCount);
            System.arraycopy(fields, 0, totalFields, srcCount, count);
            Table table = new Table(totalFields);
            int i = 1;
            while (i <= len) {
                BaseRecord sr = (BaseRecord)seq.getMem(i);
                current.setCurrent(i);
                Object path = pathExp.calculate(ctx);
                Object val = root.load(this, path, null);
                if (val instanceof Sequence) {
                    int curLen;
                    Sequence data = (Sequence)val;
                    if (filter != null) {
                        data = (Sequence)data.select(filter, null, ctx);
                    }
                    if ((curLen = data.length()) > 0) {
                        data = data.fieldsValues(fields);
                        int j = 1;
                        while (j <= curLen) {
                            BaseRecord r = (BaseRecord)data.getMem(j);
                            BaseRecord nr = table.newLast(sr.getFieldValues());
                            nr.setStart(srcCount, r);
                            ++j;
                        }
                    }
                } else if (val instanceof BaseRecord) {
                    BaseRecord r = (BaseRecord)val;
                    if (filter == null || Variant.isTrue(r.calc(filter, ctx))) {
                        BaseRecord nr = table.newLast(sr.getFieldValues());
                        int f = 0;
                        int j = srcCount;
                        while (f < count) {
                            nr.setNormalFieldValue(j, r.getFieldValue(fields[f]));
                            ++f;
                            ++j;
                        }
                    }
                }
                ++i;
            }
            Table table2 = table;
            return table2;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.setError(4);
            return null;
        }
        finally {
            stack.pop();
        }
    }

    Table read(ISection root, Sequence seq, Expression pathExp, Expression filter, Context ctx) {
        this.checkValid();
        if (seq == null || seq.length() == 0) {
            return null;
        }
        DataStruct ds = seq.dataStruct();
        if (ds == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.needPurePmt"));
        }
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(seq);
        stack.push(current);
        String[] srcFields = ds.getFieldNames();
        int srcCount = srcFields.length;
        int len = seq.length();
        try {
            Table table = null;
            DataStruct deriveDs = null;
            int i = 1;
            while (i <= len) {
                BaseRecord sr = (BaseRecord)seq.getMem(i);
                current.setCurrent(i);
                Object path = pathExp.calculate(ctx);
                Object val = root.load(this, path, null);
                if (val instanceof Sequence) {
                    int curLen;
                    Sequence data = (Sequence)val;
                    if (filter != null) {
                        data = (Sequence)data.select(filter, null, ctx);
                    }
                    if ((curLen = data.length()) > 0) {
                        DataStruct curDs = data.dataStruct();
                        if (curDs == null) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException(mm.getMessage("engine.needPurePmt"));
                        }
                        if (deriveDs == null) {
                            deriveDs = curDs;
                            String[] fields = deriveDs.getFieldNames();
                            int count = fields.length;
                            int totalCount = srcCount + count;
                            String[] totalFields = new String[totalCount];
                            System.arraycopy(srcFields, 0, totalFields, 0, srcCount);
                            System.arraycopy(fields, 0, totalFields, srcCount, count);
                            table = new Table(totalFields);
                        } else if (deriveDs.getFieldCount() != curDs.getFieldCount()) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException(mm.getMessage("engine.dsNotMatch"));
                        }
                        int j = 1;
                        while (j <= curLen) {
                            BaseRecord r = (BaseRecord)data.getMem(j);
                            BaseRecord nr = table.newLast(sr.getFieldValues());
                            nr.setStart(srcCount, r);
                            ++j;
                        }
                    }
                } else if (val instanceof BaseRecord) {
                    BaseRecord r = (BaseRecord)val;
                    if (filter == null || Variant.isTrue(r.calc(filter, ctx))) {
                        if (deriveDs == null) {
                            deriveDs = r.dataStruct();
                            String[] fields = deriveDs.getFieldNames();
                            int count = fields.length;
                            int totalCount = srcCount + count;
                            String[] totalFields = new String[totalCount];
                            System.arraycopy(srcFields, 0, totalFields, 0, srcCount);
                            System.arraycopy(fields, 0, totalFields, srcCount, count);
                            table = new Table(totalFields);
                        } else if (deriveDs.getFieldCount() != r.getFieldCount()) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException(mm.getMessage("engine.dsNotMatch"));
                        }
                        BaseRecord nr = table.newLast(sr.getFieldValues());
                        nr.setStart(srcCount, r);
                    }
                }
                ++i;
            }
            Table table2 = table;
            return table2;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.setError(4);
            return null;
        }
        finally {
            stack.pop();
        }
    }

    @Override
    public int write(Sequence seq, Expression pathExp, Expression[] fieldExps, String[] fields, Expression filter, Context ctx) {
        return this.write(this.rootSection, seq, pathExp, fieldExps, fields, filter, ctx);
    }

    int write(ISection root, Sequence seq, Expression pathExp, Expression[] fieldExps, String[] fields, Expression filter, Context ctx) {
        int result;
        block25: {
            this.checkValid();
            if (this.isAutoCommit) {
                this.resetError();
            } else if (this.error != 0) {
                return this.error;
            }
            if (seq == null || seq.length() == 0) {
                return 0;
            }
            result = 0;
            ComputeStack stack = ctx.getComputeStack();
            Current current = new Current(seq);
            stack.push(current);
            try {
                try {
                    int len = seq.length();
                    int i = 1;
                    while (i <= len) {
                        current.setCurrent(i);
                        Object path = pathExp.calculate(ctx);
                        ISection sub = path instanceof Sequence ? root.getSub(this, (Sequence)path) : root.getSub(this, path);
                        if (sub != null) {
                            Object value = sub.load(this, null);
                            boolean isModified = false;
                            if (value instanceof Sequence) {
                                Sequence data = (Sequence)value;
                                if (fieldExps == null) {
                                    value = data.select(filter, "x", ctx);
                                    if (data.length() != ((Sequence)value).length()) {
                                        isModified = true;
                                    }
                                } else {
                                    if (filter != null) {
                                        data = (Sequence)data.select(filter, null, ctx);
                                    }
                                    if (data.length() > 0) {
                                        data.modifyFields(fieldExps, fields, ctx);
                                        isModified = true;
                                    }
                                }
                            } else if (value instanceof BaseRecord) {
                                BaseRecord r = (BaseRecord)value;
                                if (fieldExps == null) {
                                    if (Variant.isTrue(r.calc(filter, ctx))) {
                                        value = null;
                                        isModified = true;
                                    }
                                } else if (filter == null || Variant.isTrue(r.calc(filter, ctx))) {
                                    r.modify(fieldExps, fields, ctx);
                                    isModified = true;
                                }
                            }
                            if (isModified) {
                                sub.save(this, value);
                            }
                        }
                        ++i;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.setError(4);
                    stack.pop();
                    break block25;
                }
            }
            catch (Throwable throwable) {
                stack.pop();
                throw throwable;
            }
            stack.pop();
        }
        if (this.isAutoCommit()) {
            this.commit();
        }
        return result;
    }

    @Override
    public Sequence retrieve(String[] dirNames, Object[] dirValues, boolean[] valueSigns, String[] fields, Expression filter, String opt, Context ctx) {
        return this.retrieve(this.rootSection, dirNames, dirValues, valueSigns, fields, filter, opt, ctx);
    }

    Sequence retrieve(ISection section, String[] dirNames, Object[] dirValues, boolean[] valueSigns, String[] fields, Expression filter, String opt, Context ctx) {
        this.checkValid();
        boolean isRecursion = opt != null && opt.indexOf(114) != -1;
        try {
            return section.retrieve(this, dirNames, dirValues, valueSigns, fields, filter, isRecursion, ctx);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.setError(4);
            return null;
        }
    }

    @Override
    public int update(String[] dirNames, Object[] dirValues, boolean[] valueSigns, Object[] fvals, String[] fields, Expression filter, String opt, Context ctx) {
        return this.update(this.rootSection, dirNames, dirValues, valueSigns, fvals, fields, filter, opt, ctx);
    }

    int update(ISection section, String[] dirNames, Object[] dirValues, boolean[] valueSigns, Object[] fvals, String[] fields, Expression filter, String opt, Context ctx) {
        this.checkValid();
        if (this.isAutoCommit) {
            this.resetError();
        } else if (this.error != 0) {
            return this.error;
        }
        boolean isRecursion = opt != null && opt.indexOf(114) != -1;
        int result = section.update(this, dirNames, dirValues, valueSigns, fvals, fields, filter, isRecursion, ctx);
        if (this.isAutoCommit()) {
            this.commit();
        }
        return result;
    }

    @Override
    public Sequence saveBlob(Sequence oldValues, Sequence newValues, Object path, String name) {
        return this.saveBlob(this.rootSection, oldValues, newValues, path, name);
    }

    Sequence saveBlob(ISection section, Sequence oldValues, Sequence newValues, Object path, String name) {
        this.checkValid();
        if (this.isAutoCommit) {
            this.resetError();
        } else if (this.error != 0) {
            return null;
        }
        if (path != null && (section = path instanceof Sequence ? section.getSub(this, (Sequence)path) : section.getSub(this, path)) == null) {
            this.setError(2);
            return null;
        }
        Sequence result = section.saveBlob(this, oldValues, newValues, name);
        if (this.isAutoCommit()) {
            this.commit();
        }
        return result;
    }

    @Override
    public int rename(Object path, String name) {
        return this.rename(this.rootSection, path, name);
    }

    int rename(ISection section, Object path, String name) {
        this.checkValid();
        if (this.isAutoCommit) {
            this.resetError();
        } else if (this.error != 0) {
            return this.error;
        }
        int result = section.rename(this, path, name);
        if (this.isAutoCommit()) {
            this.commit();
        }
        return result;
    }

    @Override
    public int archive(Object path) {
        return this.archive(this.rootSection, path);
    }

    int archive(ISection section, Object path) {
        if (section instanceof ArchiveSection) {
            return 7;
        }
        this.checkValid();
        if (this.isAutoCommit) {
            this.resetError();
        } else if (this.error != 0) {
            return this.error;
        }
        int result = ((Section)section).archive(this, path);
        if (this.isAutoCommit()) {
            this.commit();
        }
        return result;
    }

    @Override
    public int copy(Object destPath, Object destName, IVS src, Object srcPath) {
        return this.copy(this.rootSection, destPath, destName, src, srcPath);
    }

    /*
     * Unable to fully structure code
     */
    int copy(ISection destHome, Object destPath, Object destName, IVS src, Object srcPath) {
        block14: {
            this.checkValid();
            if (this.isAutoCommit) {
                this.resetError();
            } else if (this.error != 0) {
                return this.error;
            }
            if (!(destHome instanceof Section)) {
                throw ArchiveSection.getModifyException();
            }
            if (destPath != null) {
                state = ((Section)destHome).makeDir(this, destPath, destName);
                if (state == 0) {
                    destHome = destPath instanceof Sequence != false ? destHome.getSub(this, (Sequence)destPath) : destHome.getSub(this, destPath);
                    if (!(destHome instanceof Section)) {
                        throw ArchiveSection.getModifyException();
                    }
                } else {
                    if (this.isAutoCommit()) {
                        this.commit();
                    }
                    return state;
                }
            }
            destSection = (Section)destHome;
            if (srcPath != null) {
                src = src.home(srcPath);
            }
            if ((srcVdb = src.getVDB()) != this) break block14;
            srcDir = src.getHome().getDir();
            destDir = destSection.getDir();
            if (srcDir.getParent().getDir() != destDir) ** GOTO lbl35
            return 0;
lbl-1000:
            // 1 sources

            {
                if (destDir == srcDir) {
                    this.setError(6);
                    if (this.isAutoCommit()) {
                        this.commit();
                    }
                    return 6;
                }
                destDir = destDir.getParent().getDir();
lbl35:
                // 2 sources

                ** while (destDir != null)
            }
        }
        state = destSection.copy(this, srcVdb, src.getHome());
        if (this.isAutoCommit()) {
            this.commit();
        }
        return state;
    }
}

