/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.vdb;

import com.scudata.dm.ObjectReader;
import com.scudata.dm.ObjectWriter;
import com.scudata.vdb.Library;
import com.scudata.vdb.VDB;
import java.io.IOException;

class Zone {
    protected int outerSeq;
    protected long innerSeq;
    protected int block;

    public Zone() {
    }

    public Zone(int block) {
        this.block = block;
    }

    public boolean isCommitted() {
        return this.outerSeq > 0;
    }

    public int getBlock() {
        return this.block;
    }

    public void setBlock(int block) {
        this.block = block;
    }

    public void setTxSeq(int outerSeq, long innerSeq) {
        this.outerSeq = outerSeq;
        this.innerSeq = innerSeq;
    }

    public void read(ObjectReader reader) throws IOException {
        this.outerSeq = reader.readInt();
        this.innerSeq = reader.readLong();
        this.block = reader.readInt();
    }

    public void write(ObjectWriter writer) throws IOException {
        writer.writeInt(this.outerSeq);
        writer.writeLong(this.innerSeq);
        writer.writeInt(this.block);
    }

    public boolean match(VDB vdb, boolean isLockVDB) {
        if (this.outerSeq == 0) {
            return isLockVDB;
        }
        if (this.outerSeq < vdb.getOuterTxSeq()) {
            return true;
        }
        return this.innerSeq <= vdb.getLoadTxSeq();
    }

    public boolean canDelete(int outerSeq, long txSeq) {
        if (this.outerSeq < outerSeq) {
            return true;
        }
        return this.innerSeq < txSeq;
    }

    public Object getData(Library library) throws IOException {
        return library.readDataBlock(this.block);
    }
}

