/*
 * Decompiled with CFR 0.152.
 */
package com.esproc.jdbc;

import com.esproc.jdbc.JDBCUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;

public class Clob
implements java.sql.Clob {
    private String str;

    public Clob(String str) {
        this.str = str;
    }

    public String getString() {
        return this.str;
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        ByteArrayInputStream is = new ByteArrayInputStream(this.str.getBytes());
        return is;
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return new StringReader(this.str);
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        return this.str.substring(new Long(pos).intValue(), new Long(pos + (long)length).intValue());
    }

    @Override
    public long length() throws SQLException {
        if (this.str == null) {
            return 0L;
        }
        return this.str.length();
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        return (long)this.str.substring(new Long(start).intValue()).indexOf(searchstr) + start;
    }

    @Override
    public long position(java.sql.Clob searchstr, long start) throws SQLException {
        String s = JDBCUtil.clobToString(searchstr);
        return this.position(s, start);
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this.str.substring(new Long(pos).intValue()).getBytes());
            return baos;
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        StringWriter sw = new StringWriter();
        sw.write(this.str.substring(new Long(pos).intValue()));
        return sw;
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        char[] c1 = str.toCharArray();
        char[] c2 = str.toCharArray();
        int i = 0;
        while (i < c2.length) {
            if ((long)i + pos == (long)c1.length) break;
            c1[new Long((long)((long)i + pos)).intValue()] = c2[i];
            ++i;
        }
        return i;
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        return this.setString(pos, str.substring(offset, offset + len));
    }

    @Override
    public void truncate(long len) throws SQLException {
        this.str = this.str.substring(new Long(len).intValue());
    }

    @Override
    public void free() throws SQLException {
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        String subStr = this.getSubString(pos, (int)length);
        return new StringReader(subStr);
    }
}

