/*
 * Decompiled with CFR 0.152.
 */
package com.esproc.jdbc;

import com.esproc.jdbc.InternalConnection;
import com.esproc.jdbc.JDBCMessage;
import com.esproc.jdbc.JDBCUtil;
import com.esproc.jdbc.ResultSet;
import com.scudata.common.Logger;
import com.scudata.common.StringUtils;
import java.sql.RowIdLifetime;
import java.sql.SQLException;

public abstract class DatabaseMetaData
implements java.sql.DatabaseMetaData {
    private final String PRODUCT_NAME = "esProc";
    private String url;
    private String driverName;
    private int driverMajorVersion;
    private int driverMinorVersion;

    public DatabaseMetaData() {
        JDBCUtil.log("DatabaseMetaData()");
    }

    public DatabaseMetaData(String url, String driverName, int driverMajorVersion, int driverMinorVersion) throws SQLException {
        JDBCUtil.log("DatabaseMetaData(" + url + "," + driverName + "," + driverMajorVersion + "," + driverMinorVersion + ")");
        this.url = url;
        this.driverName = driverName;
        this.driverMajorVersion = driverMajorVersion;
        this.driverMinorVersion = driverMinorVersion;
    }

    @Override
    public abstract InternalConnection getConnection();

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.allProceduresAreCallable()");
        return true;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.allTablesAreSelectable()");
        return true;
    }

    @Override
    public String getURL() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getURL()");
        return this.url;
    }

    @Override
    public String getUserName() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getUserName()");
        return null;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.isReadOnly()");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "isReadOnly()"));
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.nullsAreSortedHigh()");
        return true;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.nullsAreSortedLow()");
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.nullsAreSortedAtStart()");
        return true;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.nullsAreSortedAtEnd()");
        return false;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getDatabaseProductName()");
        return "esProc";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getDatabaseProductVersion()");
        return "1.0";
    }

    @Override
    public String getDriverName() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getDriverName()");
        return this.driverName;
    }

    @Override
    public String getDriverVersion() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getDriverVersion()");
        return String.valueOf(this.getDriverMajorVersion()) + "." + this.getDriverMinorVersion();
    }

    @Override
    public int getDriverMajorVersion() {
        JDBCUtil.log("DatabaseMetaData.getDriverMajorVersion()");
        return this.driverMajorVersion;
    }

    @Override
    public int getDriverMinorVersion() {
        JDBCUtil.log("DatabaseMetaData.getDriverMinorVersion()");
        return this.driverMinorVersion;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.usesLocalFiles()");
        InternalConnection connt = this.getConnection();
        if (connt == null || connt.isClosed()) {
            throw new SQLException(JDBCMessage.get().getMessage("error.conclosed"));
        }
        return !connt.isOnlyServer();
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.usesLocalFilePerTable()");
        return true;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsMixedCaseIdentifiers()");
        return true;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.storesUpperCaseIdentifiers()");
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.storesLowerCaseIdentifiers()");
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.storesMixedCaseIdentifiers()");
        return true;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsMixedCaseQuotedIdentifiers()");
        return true;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.storesUpperCaseQuotedIdentifiers()");
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.storesLowerCaseQuotedIdentifiers()");
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.storesMixedCaseQuotedIdentifiers()");
        return true;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getIdentifierQuoteString()");
        return "'";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getSQLKeywords()");
        return null;
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getNumericFunctions()");
        return null;
    }

    @Override
    public String getStringFunctions() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getStringFunctions()");
        return null;
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getSystemFunctions()");
        return null;
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getTimeDateFunctions()");
        return null;
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getSearchStringEscape()");
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getExtraNameCharacters()");
        return "";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsAlterTableWithAddColumn()");
        return false;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsAlterTableWithDropColumn()");
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsColumnAliasing()");
        return false;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.nullPlusNonNullIsNull()");
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsConvert()");
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsConvert(" + fromType + "," + toType + ")");
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsTableCorrelationNames()");
        return false;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsDifferentTableCorrelationNames()");
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsExpressionsInOrderBy()");
        return false;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsOrderByUnrelated()");
        return false;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsGroupBy()");
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsGroupByUnrelated()");
        return false;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsGroupByBeyondSelect()");
        return false;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsLikeEscapeClause()");
        return false;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsMultipleResultSets()");
        return true;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsMultipleTransactions()");
        return false;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsNonNullableColumns()");
        return false;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsMinimumSQLGrammar()");
        return false;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsCoreSQLGrammar()");
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsExtendedSQLGrammar()");
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsANSI92EntryLevelSQL()");
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsANSI92IntermediateSQL()");
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsANSI92FullSQL()");
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsIntegrityEnhancementFacility()");
        return false;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsOuterJoins()");
        return false;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsFullOuterJoins()");
        return false;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsLimitedOuterJoins()");
        return false;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getSchemaTerm()");
        return null;
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getProcedureTerm()");
        return null;
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getCatalogTerm()");
        return null;
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.isCatalogAtStart()");
        return false;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getCatalogSeparator()");
        return ".";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsSchemasInDataManipulation()");
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsSchemasInProcedureCalls()");
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsSchemasInTableDefinitions()");
        return false;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsSchemasInIndexDefinitions()");
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsSchemasInPrivilegeDefinitions()");
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsCatalogsInDataManipulation()");
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsCatalogsInProcedureCalls()");
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsCatalogsInTableDefinitions()");
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsCatalogsInIndexDefinitions()");
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsCatalogsInPrivilegeDefinitions()");
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsPositionedDelete()");
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsPositionedUpdate()");
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsSelectForUpdate()");
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsStoredProcedures()");
        return true;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsSubqueriesInComparisons()");
        return false;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsSubqueriesInExists()");
        return false;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsSubqueriesInIns()");
        return false;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsSubqueriesInQuantifieds()");
        return false;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsCorrelatedSubqueries()");
        return false;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsUnion()");
        return false;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsUnionAll()");
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsOpenCursorsAcrossCommit()");
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsOpenCursorsAcrossRollback()");
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsOpenStatementsAcrossCommit()");
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsOpenStatementsAcrossRollback()");
        return false;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getMaxBinaryLiteralLength()");
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getMaxCharLiteralLength()");
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getMaxColumnNameLength()");
        return 0;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getMaxColumnsInGroupBy()");
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getMaxColumnsInIndex()");
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getMaxColumnsInOrderBy()");
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getMaxColumnsInSelect()");
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getMaxColumnsInTable()");
        return 0;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getMaxConnections()");
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getMaxCursorNameLength()");
        return 0;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getMaxIndexLength()");
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getMaxSchemaNameLength()");
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getMaxProcedureNameLength()");
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getMaxCatalogNameLength()");
        return 0;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getMaxRowSize()");
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.doesMaxRowSizeIncludeBlobs()");
        return false;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getMaxStatementLength()");
        return 0;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getMaxStatements()");
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getMaxTableNameLength()");
        return 0;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getMaxTablesInSelect()");
        return 0;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getMaxUserNameLength()");
        return 0;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getDefaultTransactionIsolation()");
        return 0;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsTransactions()");
        return false;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsTransactionIsolationLevel(" + level + ")");
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsDataDefinitionAndDataManipulationTransactions()");
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsDataManipulationTransactionsOnly()");
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.dataDefinitionCausesTransactionCommit()");
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.dataDefinitionIgnoredInTransactions()");
        return false;
    }

    @Override
    public java.sql.ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getProcedures(" + catalog + "," + schemaPattern + "," + procedureNamePattern + ")");
        InternalConnection connt = this.getConnection();
        if (connt == null || connt.isClosed()) {
            throw new SQLException(JDBCMessage.get().getMessage("error.conclosed"));
        }
        procedureNamePattern = this.getRealPattern(schemaPattern, procedureNamePattern);
        return connt.getProcedures(procedureNamePattern);
    }

    @Override
    public java.sql.ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getProcedureColumns(" + catalog + "," + schemaPattern + "," + procedureNamePattern + "," + columnNamePattern + ")");
        InternalConnection connt = this.getConnection();
        if (connt == null || connt.isClosed()) {
            throw new SQLException(JDBCMessage.get().getMessage("error.conclosed"));
        }
        procedureNamePattern = this.getRealPattern(schemaPattern, procedureNamePattern);
        return connt.getProcedureColumns(procedureNamePattern, columnNamePattern);
    }

    @Override
    public java.sql.ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getTables(" + catalog + "," + schemaPattern + "," + tableNamePattern + "," + JDBCUtil.array2String(types) + ")");
        InternalConnection connt = this.getConnection();
        if (connt == null || connt.isClosed()) {
            throw new SQLException(JDBCMessage.get().getMessage("error.conclosed"));
        }
        tableNamePattern = this.getRealPattern(schemaPattern, tableNamePattern);
        return connt.getTables(tableNamePattern);
    }

    @Override
    public java.sql.ResultSet getSchemas() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getSchemas()");
        return new ResultSet(3);
    }

    @Override
    public java.sql.ResultSet getCatalogs() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getCatalogs()");
        return new ResultSet(6);
    }

    @Override
    public java.sql.ResultSet getTableTypes() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getTableTypes()");
        return new ResultSet(7);
    }

    private String getRealPattern(String schemaPattern, String tableNamePattern) {
        if (StringUtils.isValidString(schemaPattern) && StringUtils.isValidString(tableNamePattern)) {
            String[] exts;
            String str = "btx,txt,csv,xls,xlsx,splx,spl,dfx";
            String[] stringArray = exts = str.split(",");
            int n = exts.length;
            int n2 = 0;
            while (n2 < n) {
                String ext = stringArray[n2];
                if (ext.equalsIgnoreCase(tableNamePattern)) {
                    tableNamePattern = String.valueOf(schemaPattern) + "." + tableNamePattern;
                    break;
                }
                if (tableNamePattern != null && tableNamePattern.toLowerCase().endsWith("." + ext)) {
                    tableNamePattern = String.valueOf(schemaPattern) + "." + tableNamePattern;
                    break;
                }
                ++n2;
            }
        }
        return tableNamePattern;
    }

    @Override
    public java.sql.ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getColumns(" + catalog + "," + schemaPattern + "," + tableNamePattern + "," + columnNamePattern + ")");
        InternalConnection connt = this.getConnection();
        if (connt == null || connt.isClosed()) {
            throw new SQLException(JDBCMessage.get().getMessage("error.conclosed"));
        }
        tableNamePattern = this.getRealPattern(schemaPattern, tableNamePattern);
        return connt.getColumns(tableNamePattern, columnNamePattern);
    }

    @Override
    public java.sql.ResultSet getColumnPrivileges(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getColumnPrivileges(" + catalog + "," + schemaPattern + "," + tableNamePattern + "," + columnNamePattern + ")");
        return JDBCUtil.getEmptyResultSet();
    }

    @Override
    public java.sql.ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getTablePrivileges(" + catalog + "," + schemaPattern + "," + tableNamePattern + ")");
        return JDBCUtil.getEmptyResultSet();
    }

    @Override
    public java.sql.ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getBestRowIdentifier(" + catalog + "," + schema + "," + table + "," + scope + "," + nullable + ")");
        return JDBCUtil.getEmptyResultSet();
    }

    @Override
    public java.sql.ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getVersionColumns(" + catalog + "," + schema + "," + table + ")");
        return JDBCUtil.getEmptyResultSet();
    }

    @Override
    public java.sql.ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getPrimaryKeys(" + catalog + "," + schema + "," + table + ")");
        return JDBCUtil.getEmptyResultSet();
    }

    @Override
    public java.sql.ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getImportedKeys(" + catalog + "," + schema + "," + table + ")");
        return JDBCUtil.getEmptyResultSet();
    }

    @Override
    public java.sql.ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getExportedKeys(" + catalog + "," + schema + "," + table + ")");
        return JDBCUtil.getEmptyResultSet();
    }

    @Override
    public java.sql.ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getCrossReference(" + primaryCatalog + "," + primarySchema + "," + primaryTable + "," + foreignCatalog + "," + foreignSchema + "," + foreignTable + ")");
        return JDBCUtil.getEmptyResultSet();
    }

    @Override
    public java.sql.ResultSet getTypeInfo() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getTypeInfo()");
        return JDBCUtil.getEmptyResultSet();
    }

    @Override
    public java.sql.ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getIndexInfo(" + catalog + "," + table + "," + unique + "," + approximate + ")");
        return JDBCUtil.getEmptyResultSet();
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsResultSetType(" + type + ")");
        return type == 1003;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsResultSetConcurrency(" + type + "," + concurrency + ")");
        return type == 1003 && 1007 == concurrency;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        JDBCUtil.log("DatabaseMetaData.ownUpdatesAreVisible(" + type + ")");
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        JDBCUtil.log("DatabaseMetaData.ownDeletesAreVisible(" + type + ")");
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        JDBCUtil.log("DatabaseMetaData.ownInsertsAreVisible(" + type + ")");
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        JDBCUtil.log("DatabaseMetaData.othersUpdatesAreVisible(" + type + ")");
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        JDBCUtil.log("DatabaseMetaData.othersDeletesAreVisible(" + type + ")");
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        JDBCUtil.log("DatabaseMetaData.othersInsertsAreVisible(" + type + ")");
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        JDBCUtil.log("DatabaseMetaData.updatesAreDetected(" + type + ")");
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        JDBCUtil.log("DatabaseMetaData.deletesAreDetected(" + type + ")");
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        JDBCUtil.log("DatabaseMetaData.insertsAreDetected(" + type + ")");
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsBatchUpdates()");
        return false;
    }

    @Override
    public java.sql.ResultSet getUDTs(String catalog, String schemaPattern, String tableNamePattern, int[] types) throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getUDTs(" + catalog + "," + schemaPattern + "," + tableNamePattern + "," + JDBCUtil.array2String(types) + ")");
        return JDBCUtil.getEmptyResultSet();
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsSavepoints()");
        return false;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsNamedParameters()");
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsMultipleOpenResults()");
        return true;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsGetGeneratedKeys()");
        return false;
    }

    @Override
    public java.sql.ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getSuperTypes(" + catalog + "," + schemaPattern + "," + typeNamePattern + ")");
        return JDBCUtil.getEmptyResultSet();
    }

    @Override
    public java.sql.ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getSuperTables(" + catalog + "," + schemaPattern + "," + tableNamePattern + ")");
        return JDBCUtil.getEmptyResultSet();
    }

    @Override
    public java.sql.ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getAttributes(" + catalog + "," + schemaPattern + "," + typeNamePattern + "," + attributeNamePattern + ")");
        return JDBCUtil.getEmptyResultSet();
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsResultSetHoldability(" + holdability + ")");
        return false;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getResultSetHoldability()");
        return 2;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getDatabaseMajorVersion()");
        return 1;
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getDatabaseMinorVersion()");
        return 0;
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getJDBCMajorVersion()");
        return 8;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getJDBCMinorVersion()");
        return 0;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getSQLStateType()");
        return 2;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.locatorsUpdateCopy()");
        return false;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsStatementPooling()");
        return false;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.autoCommitFailureClosesAllResultSets()");
        return false;
    }

    @Override
    public java.sql.ResultSet getClientInfoProperties() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getClientInfoProperties()");
        return JDBCUtil.getEmptyResultSet();
    }

    @Override
    public java.sql.ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getFunctions(" + catalog + "," + schemaPattern + "," + functionNamePattern + ")");
        return JDBCUtil.getEmptyResultSet();
    }

    @Override
    public java.sql.ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getFunctionColumns(" + catalog + "," + schemaPattern + "," + functionNamePattern + "," + columnNamePattern + ")");
        return JDBCUtil.getEmptyResultSet();
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getRowIdLifetime()");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getRowIdLifetime()"));
        return null;
    }

    @Override
    public java.sql.ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getSchemas(" + catalog + "," + schemaPattern + ")");
        return JDBCUtil.getEmptyResultSet();
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.supportsStoredFunctionsUsingCallSyntax()");
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        JDBCUtil.log("DatabaseMetaData.isWrapperFor(Class<T> iface)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "isWrapperFor(Class<?> iface)"));
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        JDBCUtil.log("DatabaseMetaData.unwrap(Class<T> iface)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "unwrap(Class<T> iface)"));
        return null;
    }

    @Override
    public java.sql.ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        JDBCUtil.log("DatabaseMetaData.getPseudoColumns(" + catalog + "," + schemaPattern + "," + tableNamePattern + "," + columnNamePattern + ")");
        return JDBCUtil.getEmptyResultSet();
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        JDBCUtil.log("DatabaseMetaData.generatedKeyAlwaysReturned()");
        return false;
    }
}

