/*
 * Decompiled with CFR 0.152.
 */
package com.esproc.jdbc;

import com.esproc.jdbc.InternalConnection;
import com.esproc.jdbc.InternalStatement;
import com.esproc.jdbc.JDBCMessage;
import com.esproc.jdbc.JDBCUtil;
import com.scudata.common.Logger;
import com.scudata.dm.Sequence;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;

public abstract class InternalPStatement
extends InternalStatement
implements PreparedStatement {
    protected ArrayList<Object> parameters = new ArrayList();
    protected ArrayList<ArrayList<?>> paramsList = new ArrayList();
    protected ArrayList<Sequence> callsParameters = new ArrayList();

    public InternalPStatement() {
    }

    public InternalPStatement(int id, String sql) {
        super(id);
        this.sql = sql;
    }

    public ArrayList<Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(ArrayList<Object> parameters) {
        this.parameters = parameters;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        JDBCUtil.log("InternalPStatement.executeQuery()");
        InternalConnection connt = this.getConnection();
        if (connt == null || connt.isClosed()) {
            throw new SQLException(JDBCMessage.get().getMessage("error.conclosed"));
        }
        if (sql.startsWith(">")) {
            throw new SQLException(JDBCMessage.get().getMessage("error.cantreturnrs"));
        }
        this.sql = sql;
        this.parameters.clear();
        return this.executeQuery();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        JDBCUtil.log("InternalPStatement.execute(" + sql + ")");
        InternalConnection connt = this.getConnection();
        if (connt == null || connt.isClosed()) {
            throw new SQLException(JDBCMessage.get().getMessage("error.conclosed"));
        }
        this.sql = sql;
        this.parameters.clear();
        return this.execute();
    }

    @Override
    public boolean execute() throws SQLException {
        JDBCUtil.log("InternalPStatement.execute()");
        InternalConnection connt = this.getConnection();
        if (connt == null || connt.isClosed()) {
            throw new SQLException(JDBCMessage.get().getMessage("error.conclosed"));
        }
        boolean isSucc = JDBCUtil.isCallsStatement(this.sql) ? this.executeJDBC(this.callsParameters) : this.executeJDBC(this.parameters);
        if (!isSucc) {
            return false;
        }
        this.getMoreResults();
        this.set = null;
        return this.result != null;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        boolean isSucc;
        JDBCUtil.log("InternalPStatement.executeQuery()");
        InternalConnection connt = this.getConnection();
        if (connt == null || connt.isClosed()) {
            throw new SQLException(JDBCMessage.get().getMessage("error.conclosed"));
        }
        if (this.sql.startsWith(">")) {
            throw new SQLException(JDBCMessage.get().getMessage("error.cantreturnrs"));
        }
        if (JDBCUtil.isCallsStatement(this.sql)) {
            if (this.callsParameters.isEmpty() && !this.parameters.isEmpty()) {
                int i = 0;
                while (i < this.parameters.size()) {
                    if (this.callsParameters.size() <= i) {
                        this.callsParameters.add(new Sequence());
                    }
                    Sequence seq = this.callsParameters.get(i);
                    seq.add(this.parameters.get(i));
                    ++i;
                }
            }
            isSucc = this.executeJDBC(this.callsParameters);
        } else {
            isSucc = this.executeJDBC(this.parameters);
        }
        if (!isSucc) {
            return JDBCUtil.getEmptyResultSet();
        }
        this.set = null;
        if (this.getMoreResults()) {
            return this.getResultSet();
        }
        return JDBCUtil.getEmptyResultSet();
    }

    @Override
    public int executeUpdate() throws SQLException {
        JDBCUtil.log("InternalPStatement.executeUpdate()");
        InternalConnection connt = this.getConnection();
        if (connt == null || connt.isClosed()) {
            throw new SQLException(JDBCMessage.get().getMessage("error.conclosed"));
        }
        this.updateCount = this.executeUpdateJDBC(this.parameters);
        return this.updateCount;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        block1: {
            JDBCUtil.log("InternalPStatement.setArray(" + parameterIndex + ",Array x)");
            if (this.parameters.size() <= parameterIndex - 1) ** GOTO lbl8
            this.parameters.set(parameterIndex - 1, x);
            break block1;
lbl-1000:
            // 1 sources

            {
                this.parameters.add(null);
lbl8:
                // 2 sources

                ** while (this.parameters.size() < parameterIndex - 1)
            }
lbl9:
            // 1 sources

            this.parameters.add(parameterIndex - 1, x);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        JDBCUtil.log("InternalPStatement.setAsciiStream(" + parameterIndex + "InputStream x," + length + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "setAsciiStream(int parameterIndex, InputStream x, int length)"));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        block1: {
            JDBCUtil.log("InternalPStatement.setBigDecimal(" + parameterIndex + "," + x + ")");
            if (this.parameters.size() <= parameterIndex - 1) ** GOTO lbl8
            this.parameters.set(parameterIndex - 1, x);
            break block1;
lbl-1000:
            // 1 sources

            {
                this.parameters.add(null);
lbl8:
                // 2 sources

                ** while (this.parameters.size() < parameterIndex - 1)
            }
lbl9:
            // 1 sources

            this.parameters.add(parameterIndex - 1, x);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        JDBCUtil.log("InternalPStatement.setBinaryStream(" + parameterIndex + ",InputStream x," + length + ")");
        try {
            byte[] bs = new byte[length];
            x.read(bs);
            if (this.parameters.size() > parameterIndex - 1) {
                this.parameters.set(parameterIndex - 1, bs);
                return;
            }
            while (true) {
                if (this.parameters.size() >= parameterIndex - 1) {
                    this.parameters.add(parameterIndex - 1, bs);
                    return;
                }
                this.parameters.add(null);
            }
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        block1: {
            JDBCUtil.log("InternalPStatement.setBlob(" + parameterIndex + ",Blob x)");
            bs = x.getBytes(1L, (int)x.length());
            if (this.parameters.size() <= parameterIndex - 1) ** GOTO lbl9
            this.parameters.set(parameterIndex - 1, bs);
            break block1;
lbl-1000:
            // 1 sources

            {
                this.parameters.add(null);
lbl9:
                // 2 sources

                ** while (this.parameters.size() < parameterIndex - 1)
            }
lbl10:
            // 1 sources

            this.parameters.add(parameterIndex - 1, bs);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        block1: {
            JDBCUtil.log("InternalPStatement.setBoolean(" + parameterIndex + "," + x + ")");
            if (this.parameters.size() <= parameterIndex - 1) ** GOTO lbl8
            this.parameters.set(parameterIndex - 1, new Boolean(x));
            break block1;
lbl-1000:
            // 1 sources

            {
                this.parameters.add(null);
lbl8:
                // 2 sources

                ** while (this.parameters.size() < parameterIndex - 1)
            }
lbl9:
            // 1 sources

            this.parameters.add(parameterIndex - 1, new Boolean(x));
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        block1: {
            JDBCUtil.log("InternalPStatement.setByte(" + parameterIndex + "," + x + ")");
            if (this.parameters.size() <= parameterIndex - 1) ** GOTO lbl8
            this.parameters.set(parameterIndex - 1, new Byte(x));
            break block1;
lbl-1000:
            // 1 sources

            {
                this.parameters.add(null);
lbl8:
                // 2 sources

                ** while (this.parameters.size() < parameterIndex - 1)
            }
lbl9:
            // 1 sources

            this.parameters.add(parameterIndex - 1, new Byte(x));
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        block1: {
            JDBCUtil.log("InternalPStatement.setBytes(" + parameterIndex + ",byte[] x)");
            if (this.parameters.size() <= parameterIndex - 1) ** GOTO lbl8
            this.parameters.set(parameterIndex - 1, x);
            break block1;
lbl-1000:
            // 1 sources

            {
                this.parameters.add(null);
lbl8:
                // 2 sources

                ** while (this.parameters.size() < parameterIndex - 1)
            }
lbl9:
            // 1 sources

            this.parameters.add(parameterIndex - 1, x);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        JDBCUtil.log("InternalPStatement.setCharacterStream(" + parameterIndex + ",Reader reader," + length + ")");
        try {
            char[] cs = new char[length];
            reader.read(cs);
            String s = new String(cs);
            if (this.parameters.size() > parameterIndex - 1) {
                this.parameters.set(parameterIndex - 1, new String(s));
                return;
            }
            while (true) {
                if (this.parameters.size() >= parameterIndex - 1) {
                    this.parameters.add(parameterIndex - 1, s);
                    return;
                }
                this.parameters.add(null);
            }
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        block1: {
            JDBCUtil.log("InternalPStatement.setClob(" + parameterIndex + ",Clob x)");
            s = JDBCUtil.clobToString(x);
            if (this.parameters.size() <= parameterIndex - 1) ** GOTO lbl9
            this.parameters.set(parameterIndex - 1, s);
            break block1;
lbl-1000:
            // 1 sources

            {
                this.parameters.add(null);
lbl9:
                // 2 sources

                ** while (this.parameters.size() < parameterIndex - 1)
            }
lbl10:
            // 1 sources

            this.parameters.add(parameterIndex - 1, s);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        block1: {
            JDBCUtil.log("InternalPStatement.setDate(" + parameterIndex + "," + x + ")");
            if (this.parameters.size() <= parameterIndex - 1) ** GOTO lbl8
            this.parameters.set(parameterIndex - 1, x);
            break block1;
lbl-1000:
            // 1 sources

            {
                this.parameters.add(null);
lbl8:
                // 2 sources

                ** while (this.parameters.size() < parameterIndex - 1)
            }
lbl9:
            // 1 sources

            this.parameters.add(parameterIndex - 1, x);
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        JDBCUtil.log("InternalPStatement.setDate(" + parameterIndex + "," + x + ",Calendar cal)");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        block1: {
            JDBCUtil.log("InternalPStatement.setDouble(" + parameterIndex + "," + x + ")");
            if (this.parameters.size() <= parameterIndex - 1) ** GOTO lbl8
            this.parameters.set(parameterIndex - 1, new Double(x));
            break block1;
lbl-1000:
            // 1 sources

            {
                this.parameters.add(null);
lbl8:
                // 2 sources

                ** while (this.parameters.size() < parameterIndex - 1)
            }
lbl9:
            // 1 sources

            this.parameters.add(parameterIndex - 1, new Double(x));
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        block1: {
            JDBCUtil.log("InternalPStatement.setFloat(" + parameterIndex + "," + x + ")");
            if (this.parameters.size() <= parameterIndex - 1) ** GOTO lbl8
            this.parameters.set(parameterIndex - 1, new Float(x));
            break block1;
lbl-1000:
            // 1 sources

            {
                this.parameters.add(null);
lbl8:
                // 2 sources

                ** while (this.parameters.size() < parameterIndex - 1)
            }
lbl9:
            // 1 sources

            this.parameters.add(parameterIndex - 1, new Float(x));
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        block1: {
            JDBCUtil.log("InternalPStatement.setInt(" + parameterIndex + "," + x + ")");
            if (this.parameters.size() <= parameterIndex - 1) ** GOTO lbl8
            this.parameters.set(parameterIndex - 1, new Integer(x));
            break block1;
lbl-1000:
            // 1 sources

            {
                this.parameters.add(null);
lbl8:
                // 2 sources

                ** while (this.parameters.size() < parameterIndex - 1)
            }
lbl9:
            // 1 sources

            this.parameters.add(parameterIndex - 1, new Integer(x));
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        block1: {
            JDBCUtil.log("InternalPStatement.setLong(" + parameterIndex + "," + x + ")");
            if (this.parameters.size() <= parameterIndex - 1) ** GOTO lbl8
            this.parameters.set(parameterIndex - 1, new Long(x));
            break block1;
lbl-1000:
            // 1 sources

            {
                this.parameters.add(null);
lbl8:
                // 2 sources

                ** while (this.parameters.size() < parameterIndex - 1)
            }
lbl9:
            // 1 sources

            this.parameters.add(parameterIndex - 1, new Long(x));
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        JDBCUtil.log("InternalPStatement.setNull(" + parameterIndex + "," + sqlType + ")");
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        JDBCUtil.log("InternalPStatement.setNull(" + parameterIndex + "," + sqlType + "," + typeName + ")");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        block1: {
            JDBCUtil.log("InternalPStatement.setObject(" + parameterIndex + "," + x + ")");
            if (this.parameters.size() <= parameterIndex - 1) ** GOTO lbl8
            this.parameters.set(parameterIndex - 1, x);
            break block1;
lbl-1000:
            // 1 sources

            {
                this.parameters.add(null);
lbl8:
                // 2 sources

                ** while (this.parameters.size() < parameterIndex - 1)
            }
lbl9:
            // 1 sources

            this.parameters.add(parameterIndex - 1, x);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        JDBCUtil.log("InternalPStatement.setObject(" + parameterIndex + "," + x + "," + targetSqlType + ")");
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        JDBCUtil.log("InternalPStatement.setObject(" + parameterIndex + "," + x + "," + targetSqlType + "," + scaleOrLength + ")");
        this.setObject(parameterIndex, x, targetSqlType);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        block1: {
            JDBCUtil.log("InternalPStatement.setRef(" + parameterIndex + "," + x + ")");
            if (this.parameters.size() <= parameterIndex - 1) ** GOTO lbl8
            this.parameters.set(parameterIndex - 1, x);
            break block1;
lbl-1000:
            // 1 sources

            {
                this.parameters.add(null);
lbl8:
                // 2 sources

                ** while (this.parameters.size() < parameterIndex - 1)
            }
lbl9:
            // 1 sources

            this.parameters.add(parameterIndex - 1, x);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        block1: {
            JDBCUtil.log("InternalPStatement.setShort(" + parameterIndex + "," + x + ")");
            if (this.parameters.size() <= parameterIndex - 1) ** GOTO lbl8
            this.parameters.set(parameterIndex - 1, new Short(x));
            break block1;
lbl-1000:
            // 1 sources

            {
                this.parameters.add(null);
lbl8:
                // 2 sources

                ** while (this.parameters.size() < parameterIndex - 1)
            }
lbl9:
            // 1 sources

            this.parameters.add(parameterIndex - 1, new Short(x));
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        block1: {
            JDBCUtil.log("InternalPStatement.setString(" + parameterIndex + "," + x + ")");
            if (this.parameters.size() <= parameterIndex - 1) ** GOTO lbl8
            this.parameters.set(parameterIndex - 1, x);
            break block1;
lbl-1000:
            // 1 sources

            {
                this.parameters.add(null);
lbl8:
                // 2 sources

                ** while (this.parameters.size() < parameterIndex - 1)
            }
lbl9:
            // 1 sources

            this.parameters.add(parameterIndex - 1, x);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        block1: {
            JDBCUtil.log("InternalPStatement.setTime(" + parameterIndex + "," + x + ")");
            if (this.parameters.size() <= parameterIndex - 1) ** GOTO lbl8
            this.parameters.set(parameterIndex - 1, x);
            break block1;
lbl-1000:
            // 1 sources

            {
                this.parameters.add(null);
lbl8:
                // 2 sources

                ** while (this.parameters.size() < parameterIndex - 1)
            }
lbl9:
            // 1 sources

            this.parameters.add(parameterIndex - 1, x);
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        JDBCUtil.log("InternalPStatement.setTime(" + parameterIndex + "," + x + "," + cal + ")");
        this.setTime(parameterIndex, x);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        block1: {
            JDBCUtil.log("InternalPStatement.setTimestamp(" + parameterIndex + "," + x + ")");
            if (this.parameters.size() <= parameterIndex - 1) ** GOTO lbl8
            this.parameters.set(parameterIndex - 1, x);
            break block1;
lbl-1000:
            // 1 sources

            {
                this.parameters.add(null);
lbl8:
                // 2 sources

                ** while (this.parameters.size() < parameterIndex - 1)
            }
lbl9:
            // 1 sources

            this.parameters.add(parameterIndex - 1, x);
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        JDBCUtil.log("InternalPStatement.setTimestamp(" + parameterIndex + "," + x + "," + cal + ")");
        this.setTimestamp(parameterIndex, x);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        block1: {
            JDBCUtil.log("InternalPStatement.setURL(" + parameterIndex + "," + x + ")");
            if (this.parameters.size() <= parameterIndex - 1) ** GOTO lbl8
            this.parameters.set(parameterIndex - 1, x);
            break block1;
lbl-1000:
            // 1 sources

            {
                this.parameters.add(null);
lbl8:
                // 2 sources

                ** while (this.parameters.size() < parameterIndex - 1)
            }
lbl9:
            // 1 sources

            this.parameters.add(parameterIndex - 1, x);
        }
    }

    @Override
    public void addBatch() throws SQLException {
        JDBCUtil.log("InternalPStatement.addBatch()");
        if (JDBCUtil.isCallsStatement(this.sql)) {
            int i = 0;
            while (i < this.parameters.size()) {
                if (this.callsParameters.size() <= i) {
                    this.callsParameters.add(new Sequence());
                }
                Sequence seq = this.callsParameters.get(i);
                seq.add(this.parameters.get(i));
                ++i;
            }
        } else {
            this.addBatch(this.sql);
        }
        this.parameters.clear();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        JDBCUtil.log("InternalPStatement.addBatch(" + sql + ")");
        this.splList.add(sql);
        ArrayList<Object> cloneParams = new ArrayList<Object>();
        cloneParams.addAll(this.parameters);
        this.paramsList.add(cloneParams);
    }

    @Override
    public void clearBatch() throws SQLException {
        JDBCUtil.log("InternalPStatement.clearBatch()");
        this.splList.clear();
        this.paramsList.clear();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        JDBCUtil.log("InternalPStatement.executeBatch()");
        if (this.splList.isEmpty()) {
            throw new SQLException("No statements to execute.");
        }
        return this.executeBatch(this.paramsList);
    }

    @Override
    public void clearParameters() throws SQLException {
        JDBCUtil.log("InternalPStatement.clearParameters()");
        this.parameters.clear();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        JDBCUtil.log("InternalPStatement.getMetaData()");
        if (this.set == null) {
            return null;
        }
        return this.set.getMetaData();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        JDBCUtil.log("InternalPStatement.getParameterMetaData()");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getParameterMetaData()"));
        return null;
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        JDBCUtil.log("InternalPStatement.setUnicodeStream(" + parameterIndex + ",InputStream x," + length + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "setUnicodeStream(int parameterIndex, InputStream x, int length)"));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        JDBCUtil.log("InternalPStatement.setAsciiStream(" + parameterIndex + ",InputStream x)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "setAsciiStream(int parameterIndex, InputStream x)"));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        JDBCUtil.log("InternalPStatement.setAsciiStream(" + parameterIndex + ",InputStream x," + length + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "setAsciiStream(int parameterIndex, InputStream x, long length)"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        JDBCUtil.log("InternalPStatement.setBinaryStream(" + parameterIndex + ",InputStream x)");
        try {
            byte[] bs = this.inputStream2Bytes(x);
            if (this.parameters.size() > parameterIndex - 1) {
                this.parameters.set(parameterIndex - 1, bs);
                return;
            }
            while (true) {
                if (this.parameters.size() >= parameterIndex - 1) {
                    this.parameters.add(parameterIndex - 1, bs);
                    return;
                }
                this.parameters.add(null);
            }
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    private byte[] inputStream2Bytes(InputStream is) throws Exception {
        if (is == null) {
            return new byte[0];
        }
        byte[] bytes = new byte[65536];
        ByteArrayOutputStream baos = null;
        try {
            int len;
            baos = new ByteArrayOutputStream();
            while ((len = is.read(bytes)) != -1) {
                baos.write(bytes, 0, len);
            }
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (Exception exception) {}
            }
        }
        return baos.toByteArray();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        JDBCUtil.log("InternalPStatement.setBinaryStream(" + parameterIndex + ",InputStream x," + length + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "setBinaryStream(int parameterIndex, InputStream x, long length)"));
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        JDBCUtil.log("InternalPStatement.setBlob(" + parameterIndex + ",InputStream inputStream)");
        this.setBinaryStream(parameterIndex, inputStream);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        JDBCUtil.log("InternalPStatement.setBlob(" + parameterIndex + ",InputStream inputStream," + length + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "setBlob(int parameterIndex, InputStream inputStream, long length)"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        JDBCUtil.log("InternalPStatement.setCharacterStream(" + parameterIndex + ",Reader reader)");
        try {
            String s = this.reader2String(reader);
            if (this.parameters.size() > parameterIndex - 1) {
                this.parameters.set(parameterIndex - 1, new String(s));
                return;
            }
            while (true) {
                if (this.parameters.size() >= parameterIndex - 1) {
                    this.parameters.add(parameterIndex - 1, s);
                    return;
                }
                this.parameters.add(null);
            }
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    private String reader2String(Reader reader) throws Exception {
        if (reader == null) {
            return null;
        }
        char[] chars = new char[65536];
        StringWriter writer = null;
        try {
            int len;
            writer = new StringWriter();
            while ((len = reader.read(chars)) != -1) {
                writer.write(chars, 0, len);
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        }
        return writer.getBuffer().toString();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        JDBCUtil.log("InternalPStatement.setCharacterStream(" + parameterIndex + ",Reader reader," + length + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "setCharacterStream(int parameterIndex, Reader reader, long length)"));
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        JDBCUtil.log("InternalPStatement.setClob(" + parameterIndex + ",Reader reader)");
        this.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        JDBCUtil.log("InternalPStatement.setClob(" + parameterIndex + ",Reader reader," + length + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "setClob(int parameterIndex, Reader reader, long length)"));
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        JDBCUtil.log("InternalPStatement.setNCharacterStream(" + parameterIndex + ",Reader reader)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "setNCharacterStream(int parameterIndex, Reader value)"));
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        JDBCUtil.log("InternalPStatement.setNCharacterStream(" + parameterIndex + ",Reader reader," + length + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "setNCharacterStream(int parameterIndex, Reader value, long length)"));
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        JDBCUtil.log("InternalPStatement.setNClob(" + parameterIndex + ",NClob value)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "setNClob(int parameterIndex, NClob value)"));
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        JDBCUtil.log("InternalPStatement.setNClob(" + parameterIndex + ",Reader reader)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "setNClob(int parameterIndex, Reader reader)"));
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        JDBCUtil.log("InternalPStatement.setNClob(" + parameterIndex + ",Reader reader," + length + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "setNClob(int parameterIndex, Reader reader, long length)"));
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        JDBCUtil.log("InternalPStatement.setNString(" + parameterIndex + "," + value + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "setNString(int parameterIndex, String value)"));
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        JDBCUtil.log("InternalPStatement.setRowId(" + parameterIndex + ",RowId x)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "setRowId(int parameterIndex, RowId x)"));
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        JDBCUtil.log("InternalPStatement.setSQLXML(" + parameterIndex + ",SQLXML xmlObject)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "setSQLXML(int parameterIndex, SQLXML xmlObject)"));
    }
}

