/*
 * Decompiled with CFR 0.152.
 */
package com.esproc.jdbc;

import com.esproc.jdbc.InternalConnection;
import com.esproc.jdbc.JDBCMessage;
import com.esproc.jdbc.JDBCUtil;
import com.esproc.jdbc.MultiResult;
import com.esproc.jdbc.ResultSet;
import com.scudata.app.common.AppUtil;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.common.DBSession;
import com.scudata.common.Logger;
import com.scudata.common.StringUtils;
import com.scudata.dm.Context;
import com.scudata.dm.IResource;
import com.scudata.dm.JobSpace;
import com.scudata.dm.ParamList;
import com.scudata.dm.RetryException;
import com.scudata.parallel.UnitClient;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class InternalStatement
implements Statement {
    protected String sql = null;
    protected java.sql.ResultSet set;
    protected int id;
    protected Object result;
    protected Object currentResult;
    protected Thread execThread = null;
    protected int unitStateId;
    private SQLException ex;
    private boolean isCanceled = false;
    private int fetchSize = 102400;
    protected int queryTimeout = 5;
    private Context ctx;
    private boolean isClosed = false;
    protected int updateCount = -1;
    protected List<String> splList = new ArrayList<String>();
    protected int[] updateCounts;

    public InternalStatement() {
    }

    public InternalStatement(int id) {
        this.id = id;
        this.initContext();
    }

    public void initContext() {
        this.ctx = new Context();
        this.setParentContext(this.ctx);
    }

    private void setParentContext(Context ctx) {
        InternalConnection connt = this.getConnection();
        try {
            if (connt == null || connt.isClosed()) {
                return;
            }
        }
        catch (SQLException e) {
            return;
        }
        Context parentCtx = connt.getParentContext();
        if (parentCtx != null) {
            Map<String, DBSession> dbSessionMap = parentCtx.getDBSessionMap();
            if (dbSessionMap != null) {
                try {
                    for (String dbName : dbSessionMap.keySet()) {
                        DBSession dbSession = dbSessionMap.get(dbName);
                        ctx.setDBSession(dbName, dbSession);
                    }
                }
                catch (Exception ex) {
                    Logger.error(ex);
                }
            }
            JobSpace jobSpace = parentCtx.getJobSpace();
            ctx.setJobSpace(jobSpace);
        }
    }

    @Override
    public abstract InternalConnection getConnection();

    public int getUnitStatementID() {
        return this.unitStateId;
    }

    protected boolean executeJDBC(ArrayList<?> parameters) throws SQLException {
        Object result = this.executeJDBC(parameters, false);
        return result == null ? false : (Boolean)result;
    }

    protected int executeUpdateJDBC(ArrayList<Object> parameters) throws SQLException {
        Object result = this.executeJDBC(parameters, true);
        return this.getUpdateCountByResult(result);
    }

    protected Object executeJDBC(final ArrayList<?> parameters, final boolean isUpdate) throws SQLException {
        this.checkExec();
        try {
            this.ex = null;
            this.isCanceled = false;
            this.execThread = new Thread(){

                @Override
                public void run() {
                    try {
                        InternalConnection connt = InternalStatement.this.getConnection();
                        InternalStatement.this.result = InternalStatement.this.executeJDBC(InternalStatement.this.sql, parameters, connt, isUpdate);
                    }
                    catch (InterruptedException ie) {
                        InternalStatement.this.isCanceled = true;
                    }
                    catch (ThreadDeath td) {
                        InternalStatement.this.isCanceled = true;
                    }
                    catch (SQLException e) {
                        InternalStatement.this.ex = e;
                    }
                }
            };
            this.execThread.start();
            try {
                this.execThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.ex != null) {
                throw this.ex;
            }
        }
        catch (ThreadDeath td) {
            this.isCanceled = true;
        }
        if (isUpdate) {
            return this.result;
        }
        return !this.isCanceled;
    }

    protected void checkExec() throws SQLException {
        if (this.isClosed) {
            throw new SQLException(JDBCMessage.get().getMessage("error.statementclosed"));
        }
        InternalConnection connt = this.getConnection();
        if (connt == null || connt.isClosed()) {
            throw new SQLException(JDBCMessage.get().getMessage("error.conclosed"));
        }
        connt.checkExec();
    }

    protected String handleSql(String sql) throws SQLException {
        return JDBCUtil.trimSql(sql);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Object executeJDBC(String sql, ArrayList<?> parameters, InternalConnection con, boolean isUpdate) throws SQLException, InterruptedException {
        block25: {
            block24: {
                Logger.debug("SQL:[" + sql + "]");
                if (StringUtils.isValidString(sql)) break block24;
                return null;
            }
            sql = this.handleSql(sql);
            sqlType = this.getJdbcSqlType(sql);
            isOnlyServer = con.isOnlyServer();
            config = con.getConfig();
            gateway = null;
            if (config != null) {
                gateway = config.getGateway();
            }
            if (!StringUtils.isValidString(gateway) && sqlType == 0) {
                throw new SQLException(JDBCMessage.get().getMessage("statement.unsupportsql", sql));
            }
            if (!isOnlyServer && config != null && StringUtils.isValidString(gateway)) {
                try {
                    return JDBCUtil.executeGateway(sql, parameters, this.ctx, gateway);
                }
                catch (RetryException var9_13) {
                }
                catch (Exception e) {
                    throw new SQLException(e.getMessage(), e);
                }
            }
            Logger.debug("param size=" + (parameters == null ? "0" : "" + parameters.size()));
            isRemote = false;
            if (isOnlyServer) {
                isRemote = true;
            } else if (!(sqlType != 3 && sqlType != 4 && sqlType != 5 || (hosts = con.getHostNames()) == null || hosts.isEmpty())) {
                try {
                    splFile = JDBCUtil.getSplName(sql);
                    try {
                        AppUtil.searchSplFilePath(splFile);
                    }
                    catch (Exception ex) {
                        isRemote = true;
                    }
                }
                catch (Exception splFile) {
                    // empty catch block
                }
            }
            if (isRemote) {
                uc = con.getUnitClient(this.queryTimeout * 1000);
                connId = con.getUnitConnectionId();
                args = sqlType == 4 ? JDBCUtil.prepareCallsArg(parameters) : JDBCUtil.prepareArg(parameters);
                params = null;
                if (args != null && args.length() > 0) {
                    params = args.toArray();
                }
                envParams = new HashMap<String, Object>();
                envParams.put("sqlfirst", false);
                envParams.put("gateway", gateway);
                this.unitStateId = uc.JDBCPrepare(connId, sql, params, envParams);
                seq = uc.JDBCExecute(connId, this.unitStateId);
                result = new MultiResult(seq);
            } else {
                this.ctx = this.prepareContext(this.ctx, sql, sqlType);
                result = this.executeLocal(sql, parameters, sqlType, this.ctx);
            }
            if (sqlType != 1) break block25;
            return null;
        }
        try {
            return result;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (Exception e) {
            t /* !! */  = e;
            ** while (t /* !! */  != null)
        }
lbl-1000:
        // 1 sources

        {
            if (t /* !! */  instanceof ThreadDeath) {
                throw new InterruptedException();
            }
            t /* !! */  = t /* !! */ .getCause();
            continue;
        }
lbl74:
        // 1 sources

        se = new SQLException(e.getMessage());
        se.initCause(e);
        throw se;
    }

    protected byte getJdbcSqlType(String sql) {
        return JDBCUtil.getJdbcSqlType(sql);
    }

    private int getUpdateCountByResult(Object result) {
        MultiResult mr;
        boolean hasMore;
        if (result == null) {
            return 0;
        }
        if (result instanceof PgmCellSet) {
            PgmCellSet pcs = (PgmCellSet)result;
            boolean hasMore2 = pcs.hasNextResult();
            if (hasMore2) {
                result = pcs.nextResult();
            }
        } else if (result instanceof MultiResult && (hasMore = (mr = (MultiResult)result).hasNext())) {
            result = mr.next();
        }
        if (result == null || !(result instanceof Number)) {
            return 0;
        }
        return ((Number)result).intValue();
    }

    protected Object executeLocal(String sql, ArrayList<?> parameters, byte sqlType, Context ctx) throws Exception {
        return JDBCUtil.execute(sql, parameters, ctx, false);
    }

    private Context prepareContext(Context ctx, String sql, byte sqlType) {
        boolean isGrid = false;
        if (sqlType == 3 || sqlType == 4 || sqlType == 5) {
            isGrid = true;
        } else if (sqlType == 2) {
            sql = sql.substring(1);
            isGrid = AppUtil.isGrid(sql);
        }
        if (isGrid) {
            ctx = ctx.newComputeContext();
        }
        return ctx;
    }

    @Override
    public java.sql.ResultSet executeQuery(String sql) throws SQLException {
        JDBCUtil.log("InternalStatement.executeQuery(" + sql + ")");
        InternalConnection connt = this.getConnection();
        if (connt == null || connt.isClosed()) {
            throw new SQLException(JDBCMessage.get().getMessage("error.conclosed"));
        }
        this.sql = sql;
        boolean isSucc = this.executeJDBC(null);
        if (!isSucc) {
            return JDBCUtil.getEmptyResultSet();
        }
        this.set = null;
        if (this.getMoreResults()) {
            this.set = this.getResultSet();
        }
        return this.set;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        JDBCUtil.log("InternalStatement.executeUpdate(" + sql + ")");
        InternalConnection connt = this.getConnection();
        if (connt == null || connt.isClosed()) {
            throw new SQLException(JDBCMessage.get().getMessage("error.conclosed"));
        }
        this.sql = sql;
        this.updateCount = this.executeUpdateJDBC(null);
        return this.updateCount;
    }

    @Override
    public void close() throws SQLException {
        InternalConnection connt;
        JobSpace jobSpace;
        JDBCUtil.log("InternalStatement.close()");
        if (this.result != null && this.result instanceof IResource) {
            ((IResource)this.result).close();
        }
        if (this.set != null) {
            this.set.close();
        }
        this.result = null;
        this.set = null;
        if (this.ctx != null && (jobSpace = this.ctx.getJobSpace()) != null) {
            jobSpace.closeResource();
        }
        if ((connt = this.getConnection()) == null || connt.isClosed()) {
            throw new SQLException(JDBCMessage.get().getMessage("error.conclosed"));
        }
        if (this.ctx != null) {
            Map<String, DBSession> map = this.ctx.getDBSessionMap();
            if (map != null) {
                Iterator<String> iter = map.keySet().iterator();
                while (iter.hasNext()) {
                    Object o;
                    DBSession dbSession;
                    String name = iter.next().toString();
                    if (connt.isAutoConnection(name, dbSession = this.ctx.getDBSession(name)) || dbSession == null || dbSession.isClosed() || (o = dbSession.getSession()) == null || !(o instanceof Connection)) continue;
                    try {
                        ((Connection)o).close();
                    }
                    catch (Exception e) {
                        Logger.warn(e.getMessage(), e);
                    }
                }
            }
            ParamList pl = this.ctx.getParamList();
            int i = 0;
            while (i < pl.count()) {
                Object o = pl.get(i).getValue();
                if (o != null && o instanceof Connection) {
                    try {
                        ((Connection)o).close();
                    }
                    catch (Exception e) {
                        Logger.warn(e.getMessage(), e);
                    }
                }
                ++i;
            }
        }
        connt.closeStatement(this);
        this.isClosed = true;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        JDBCUtil.log("InternalStatement.getMaxFieldSize()");
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        JDBCUtil.log("InternalStatement.setMaxFieldSize(" + max + ")");
    }

    @Override
    public int getMaxRows() throws SQLException {
        JDBCUtil.log("InternalStatement.getMaxRows()");
        return 0;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        JDBCUtil.log("InternalStatement.setMaxRows(" + max + ")");
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        JDBCUtil.log("InternalStatement.setEscapeProcessing(" + enable + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "setEscapeProcessing(boolean enable)"));
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        JDBCUtil.log("InternalStatement.getQueryTimeout()");
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        JDBCUtil.log("InternalStatement.setQueryTimeout(" + seconds + ")");
        this.queryTimeout = seconds;
    }

    @Override
    public void cancel() throws SQLException {
        JDBCUtil.log("InternalStatement.cancel()");
        if (this.execThread != null) {
            UnitClient uc;
            InternalConnection connt = this.getConnection();
            if (connt == null || connt.isClosed()) {
                throw new SQLException(JDBCMessage.get().getMessage("error.conclosed"));
            }
            if (this.isClosed) {
                throw new SQLException(JDBCMessage.get().getMessage("error.statementclosed"));
            }
            if (connt.isOnlyServer() && (uc = connt.getUnitClient(this.queryTimeout * 1000)) != null) {
                try {
                    uc.JDBCCancel(connt.getUnitConnectionId(), this.unitStateId);
                }
                catch (Exception e) {
                    throw new SQLException(e.getMessage(), e);
                }
            }
            AppUtil.destroyThread(this.execThread);
            this.execThread = null;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        JDBCUtil.log("InternalStatement.getWarnings()");
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        JDBCUtil.log("InternalStatement.clearWarnings()");
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        JDBCUtil.log("InternalStatement.setCursorName(" + name + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "setCursorName(String name)"));
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        JDBCUtil.log("InternalStatement.execute(" + sql + ")");
        InternalConnection connt = this.getConnection();
        if (connt == null || connt.isClosed()) {
            throw new SQLException(JDBCMessage.get().getMessage("error.conclosed"));
        }
        this.sql = sql;
        boolean isSucc = this.executeJDBC(null);
        if (!isSucc) {
            return false;
        }
        this.getMoreResults();
        this.set = null;
        return this.result != null;
    }

    @Override
    public java.sql.ResultSet getResultSet() throws SQLException {
        JDBCUtil.log("InternalStatement.getResultSet()");
        InternalConnection connt = this.getConnection();
        if (connt == null || connt.isClosed()) {
            throw new SQLException(JDBCMessage.get().getMessage("error.conclosed"));
        }
        if (this.isClosed) {
            throw new SQLException(JDBCMessage.get().getMessage("error.statementclosed"));
        }
        if (this.set != null) {
            this.set.close();
        }
        if (this.result == null) {
            return null;
        }
        if (this.result instanceof PgmCellSet || this.result instanceof MultiResult) {
            if (this.currentResult == null) {
                return null;
            }
            this.set = JDBCUtil.generateResultSet(this.currentResult, this.fetchSize);
        } else {
            this.set = JDBCUtil.generateResultSet(this.result, this.fetchSize);
        }
        if (this.set != null) {
            ((ResultSet)this.set).setStatement(this);
        }
        return this.set;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        JDBCUtil.log("InternalStatement.getUpdateCount()");
        return this.updateCount;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        JDBCUtil.log("InternalStatement.getMoreResults()");
        InternalConnection connt = this.getConnection();
        if (connt == null || connt.isClosed()) {
            throw new SQLException(JDBCMessage.get().getMessage("error.conclosed"));
        }
        if (this.isClosed) {
            throw new SQLException(JDBCMessage.get().getMessage("error.statementclosed"));
        }
        if (this.result == null) {
            return false;
        }
        if (this.result instanceof PgmCellSet) {
            PgmCellSet pcs = (PgmCellSet)this.result;
            boolean hasMore = pcs.hasNextResult();
            this.currentResult = hasMore ? pcs.nextResult() : null;
            return hasMore;
        }
        if (this.result instanceof MultiResult) {
            MultiResult mr = (MultiResult)this.result;
            boolean hasMore = mr.hasNext();
            this.currentResult = hasMore ? mr.next() : null;
            return hasMore;
        }
        return this.set == null;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        JDBCUtil.log("InternalStatement.setFetchDirection(" + direction + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "setFetchDirection(int direction)"));
    }

    @Override
    public int getFetchDirection() throws SQLException {
        JDBCUtil.log("InternalStatement.getFetchDirection()");
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        JDBCUtil.log("InternalStatement.setFetchSize(" + rows + ")");
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        JDBCUtil.log("InternalStatement.getFetchSize()");
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        JDBCUtil.log("InternalStatement.getResultSetConcurrency()");
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        JDBCUtil.log("InternalStatement.getResultSetType()");
        return 1003;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        JDBCUtil.log("InternalStatement.addBatch(" + sql + ")");
        this.splList.add(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        JDBCUtil.log("InternalStatement.clearBatch()");
        this.splList.clear();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        JDBCUtil.log("InternalStatement.executeBatch()");
        return this.executeBatch(null);
    }

    protected int[] executeBatch(final ArrayList<ArrayList<?>> paramsList) throws SQLException {
        final InternalConnection connt = this.getConnection();
        if (connt == null || connt.isClosed()) {
            throw new SQLException(JDBCMessage.get().getMessage("error.conclosed"));
        }
        this.checkExec();
        if (this.splList.isEmpty()) {
            throw new SQLException("No statements to execute.");
        }
        this.updateCounts = new int[this.splList.size()];
        try {
            this.ex = null;
            this.isCanceled = false;
            this.execThread = new Thread(){

                @Override
                public void run() {
                    try {
                        int i = 0;
                        while (i < InternalStatement.this.splList.size()) {
                            Object result = InternalStatement.this.executeJDBC(InternalStatement.this.splList.get(i), paramsList == null ? null : (ArrayList)paramsList.get(i), connt, true);
                            InternalStatement.this.updateCounts[i] = InternalStatement.this.getUpdateCountByResult(result);
                            ++i;
                        }
                    }
                    catch (InterruptedException ie) {
                        InternalStatement.this.isCanceled = true;
                    }
                    catch (ThreadDeath td) {
                        InternalStatement.this.isCanceled = true;
                    }
                    catch (SQLException e) {
                        InternalStatement.this.ex = e;
                    }
                }
            };
            this.execThread.start();
            try {
                this.execThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.ex != null) {
                throw this.ex;
            }
        }
        catch (ThreadDeath td) {
            this.isCanceled = true;
        }
        return this.updateCounts;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        JDBCUtil.log("InternalStatement.getMoreResults(" + current + ")");
        return false;
    }

    @Override
    public java.sql.ResultSet getGeneratedKeys() throws SQLException {
        JDBCUtil.log("InternalStatement.getGeneratedKeys()");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "getGeneratedKeys()"));
        return JDBCUtil.getEmptyResultSet();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        JDBCUtil.log("InternalStatement.executeUpdate(" + sql + "," + autoGeneratedKeys + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "executeUpdate(String sql, int autoGeneratedKeys)"));
        return 0;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        JDBCUtil.log("InternalStatement.executeUpdate(" + sql + "," + JDBCUtil.array2String(columnIndexes) + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "executeUpdate(String sql, int[] columnIndexes)"));
        return 0;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        JDBCUtil.log("InternalStatement.executeUpdate(" + sql + "," + JDBCUtil.array2String(columnNames) + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "executeUpdate(String sql, String[] columnNames)"));
        return 0;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        JDBCUtil.log("InternalStatement.execute(" + sql + "," + autoGeneratedKeys + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "execute(String sql, int autoGeneratedKeys)"));
        return false;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        JDBCUtil.log("InternalStatement.execute(" + sql + "," + JDBCUtil.array2String(columnIndexes) + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "execute(String sql, int[] columnIndexes)"));
        return false;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        JDBCUtil.log("InternalStatement.execute(" + sql + "," + JDBCUtil.array2String(columnNames) + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "execute(String sql, String[] columnNames)"));
        return false;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        JDBCUtil.log("InternalStatement.getResultSetHoldability()");
        return 1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        JDBCUtil.log("InternalStatement.isClosed()");
        return false;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        JDBCUtil.log("InternalStatement.isPoolable()");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "isPoolable()"));
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        JDBCUtil.log("InternalStatement.setPoolable(" + poolable + ")");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "setPoolable(boolean poolable)"));
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        JDBCUtil.log("InternalStatement.isWrapperFor(Class<?> iface)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "isWrapperFor(Class<?> iface)"));
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        JDBCUtil.log("InternalStatement.unwrap(Class<T> iface)");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "unwrap(Class<T> iface)"));
        return null;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        JDBCUtil.log("InternalStatement.closeOnCompletion()");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "closeOnCompletion()"));
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        JDBCUtil.log("InternalStatement.isCloseOnCompletion()");
        Logger.debug(JDBCMessage.get().getMessage("error.methodnotimpl", "isCloseOnCompletion()"));
        return false;
    }

    public int getID() {
        return this.id;
    }
}

