/*
 * Decompiled with CFR 0.152.
 */
package com.esproc.jdbc;

import com.esproc.jdbc.JDBCUtil;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.SQLException;
import java.util.ArrayList;

public class ResultSetMetaData
implements java.sql.ResultSetMetaData,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final int AUTO_INCREMENT = 1;
    private static final int CASE_SENSITIVE = 2;
    private static final int SEARCHABLE = 3;
    private static final int CURRENCY = 4;
    private static final int SIGNED = 5;
    private static final int READ_ONLY = 6;
    private static final int WRITABLE = 7;
    private static final int DEFINITELY_WRITABLE = 8;
    private int colCount = 0;
    private ArrayList<Object> columnNames = null;
    private int[] columnTypes = null;
    private ArrayList<Object> columnTypeNames = null;
    private ArrayList<Object> columnLabels = null;
    private ArrayList<Object> columnClassNames = null;
    private int[] columnDisplaySizes = null;
    private ArrayList<Object> schemaNames = null;
    private ArrayList<Object> catalogNames = null;
    private int[] precisions = null;
    private int[] scales = null;
    private ArrayList<Object> tableNames = null;
    private int[] properties = null;
    private int[] nullables = null;

    public ResultSetMetaData() {
        JDBCUtil.log("ResultSetMetaData()");
    }

    public ResultSetMetaData(byte type) {
        JDBCUtil.log("ResultSetMetaData(" + type + ")");
        if (type == 1) {
            this.colCount = 9;
            this.columnNames = new ArrayList(this.colCount);
            this.columnNames.add("PROCEDURE_CAT");
            this.columnNames.add("PROCEDURE_SCHEM");
            this.columnNames.add("PROCEDURE_NAME");
            this.columnNames.add("reserved1");
            this.columnNames.add("reserved2");
            this.columnNames.add("reserved3");
            this.columnNames.add("REMARKS");
            this.columnNames.add("PROCEDURE_TYPE");
            this.columnNames.add("SPECIFIC_NAME");
            this.columnTypes = new int[this.colCount];
            this.columnTypes[0] = 12;
            this.columnTypes[1] = 12;
            this.columnTypes[2] = 12;
            this.columnTypes[3] = 12;
            this.columnTypes[4] = 12;
            this.columnTypes[5] = 12;
            this.columnTypes[6] = 12;
            this.columnTypes[7] = 4;
            this.columnTypes[8] = 12;
        } else if (type == 2) {
            this.colCount = 20;
            this.columnNames = new ArrayList(this.colCount);
            this.columnNames.add("PROCEDURE_CAT");
            this.columnNames.add("PROCEDURE_SCHEM");
            this.columnNames.add("PROCEDURE_NAME");
            this.columnNames.add("COLUMN_NAME");
            this.columnNames.add("COLUMN_TYPE");
            this.columnNames.add("DATA_TYPE");
            this.columnNames.add("TYPE_NAME");
            this.columnNames.add("precisions");
            this.columnNames.add("LENGTH");
            this.columnNames.add("scales");
            this.columnNames.add("RADIX");
            this.columnNames.add("nullables");
            this.columnNames.add("REMARKS");
            this.columnNames.add("COLUMN_DEF");
            this.columnNames.add("SQL_DATA_TYPE");
            this.columnNames.add("SQL_DATETIME_SUB");
            this.columnNames.add("CHAR_OCTET_LENGTH");
            this.columnNames.add("ORDINAL_POSITION");
            this.columnNames.add("IS_NULLABLE");
            this.columnNames.add("SPECIFIC_NAME");
            this.columnTypes = new int[this.colCount];
            this.columnTypes[0] = 12;
            this.columnTypes[1] = 12;
            this.columnTypes[2] = 12;
            this.columnTypes[3] = 12;
            this.columnTypes[4] = 4;
            this.columnTypes[5] = 4;
            this.columnTypes[6] = 12;
            this.columnTypes[7] = 4;
            this.columnTypes[8] = 4;
            this.columnTypes[9] = 4;
            this.columnTypes[10] = 4;
            this.columnTypes[11] = 4;
            this.columnTypes[12] = 12;
            this.columnTypes[13] = 12;
            this.columnTypes[14] = 4;
            this.columnTypes[15] = 4;
            this.columnTypes[16] = 4;
            this.columnTypes[17] = 4;
            this.columnTypes[18] = 12;
            this.columnTypes[19] = 12;
        } else if (type == 3) {
            this.colCount = 2;
            this.columnNames = new ArrayList(this.colCount);
            this.columnNames.add("TABLE_SCHEM");
            this.columnNames.add("TABLE_CATALOG");
            this.columnTypes = new int[this.colCount];
            this.columnTypes[0] = 12;
            this.columnTypes[1] = 12;
        } else if (type == 4) {
            this.colCount = 10;
            this.columnNames = new ArrayList(this.colCount);
            this.columnNames.add("TABLE_CAT");
            this.columnNames.add("TABLE_SCHEM");
            this.columnNames.add("TABLE_NAME");
            this.columnNames.add("TABLE_TYPE");
            this.columnNames.add("REMARKS");
            this.columnNames.add("TYPE_CAT");
            this.columnNames.add("TYPE_SCHEM");
            this.columnNames.add("TYPE_NAME");
            this.columnNames.add("SELF_REFERENCING_COL_NAME");
            this.columnNames.add("REF_GENERATION");
            this.columnTypes = new int[this.colCount];
            this.columnTypes[0] = 12;
            this.columnTypes[1] = 12;
            this.columnTypes[2] = 12;
            this.columnTypes[3] = 12;
            this.columnTypes[4] = 12;
            this.columnTypes[5] = 12;
            this.columnTypes[6] = 12;
            this.columnTypes[7] = 12;
            this.columnTypes[8] = 12;
            this.columnTypes[9] = 12;
        } else if (type == 5) {
            this.colCount = 24;
            this.columnNames = new ArrayList(this.colCount);
            this.columnNames.add("TABLE_CAT");
            this.columnNames.add("TABLE_SCHEM");
            this.columnNames.add("TABLE_NAME");
            this.columnNames.add("COLUMN_NAME");
            this.columnNames.add("DATA_TYPE");
            this.columnNames.add("TYPE_NAME");
            this.columnNames.add("COLUMN_SIZE");
            this.columnNames.add("BUFFER_LENGTH");
            this.columnNames.add("DECIMAL_DIGITS");
            this.columnNames.add("NUM_PREC_RADIX");
            this.columnNames.add("nullables");
            this.columnNames.add("REMARKS");
            this.columnNames.add("COLUMN_DEF");
            this.columnNames.add("SQL_DATA_TYPE");
            this.columnNames.add("SQL_DATETIME_SUB");
            this.columnNames.add("CHAR_OCTET_LENGTH");
            this.columnNames.add("ORDINAL_POSITION");
            this.columnNames.add("IS_NULLABLE");
            this.columnNames.add("SCOPE_CATLOG");
            this.columnNames.add("SCOPE_SCHEMA");
            this.columnNames.add("SCOPE_TABLE");
            this.columnNames.add("SOURCE_DATA_TYPE");
            this.columnNames.add("IS_AUTOINCREMENT");
            this.columnNames.add("IS_GENERATEDCOLUMN");
            this.columnTypes = new int[this.colCount];
            this.columnTypes[0] = 12;
            this.columnTypes[1] = 12;
            this.columnTypes[2] = 12;
            this.columnTypes[3] = 12;
            this.columnTypes[4] = 4;
            this.columnTypes[5] = 12;
            this.columnTypes[6] = 4;
            this.columnTypes[7] = 4;
            this.columnTypes[8] = 4;
            this.columnTypes[9] = 4;
            this.columnTypes[10] = 4;
            this.columnTypes[11] = 12;
            this.columnTypes[12] = 12;
            this.columnTypes[13] = 4;
            this.columnTypes[14] = 4;
            this.columnTypes[15] = 4;
            this.columnTypes[16] = 4;
            this.columnTypes[17] = 12;
            this.columnTypes[18] = 12;
            this.columnTypes[19] = 12;
            this.columnTypes[20] = 12;
            this.columnTypes[21] = 4;
            this.columnTypes[22] = 12;
            this.columnTypes[23] = 12;
        } else if (type == 6) {
            this.colCount = 1;
            this.columnNames = new ArrayList(this.colCount);
            this.columnNames.add("TABLE_CAT");
            this.columnTypes = new int[this.colCount];
            this.columnTypes[0] = 12;
        } else if (type == 7) {
            this.colCount = 1;
            this.columnNames = new ArrayList(this.colCount);
            this.columnNames.add("TABLE_TYPE");
            this.columnTypes = new int[this.colCount];
            this.columnTypes[0] = 12;
        } else if (type == 0) {
            this.colCount = 1;
            this.columnNames = new ArrayList(this.colCount);
            this.columnNames.add("UNSUPPORTED");
            this.columnTypes = new int[this.colCount];
            this.columnTypes[0] = 12;
        } else if (type == 8) {
            this.colCount = 14;
            this.columnNames = new ArrayList(this.colCount);
            this.columnNames.add("PKTABLE_CAT");
            this.columnNames.add("PKTABLE_SCHEM");
            this.columnNames.add("PKTABLE_NAME");
            this.columnNames.add("PKCOLUMN_NAME");
            this.columnNames.add("FKTABLE_CAT");
            this.columnNames.add("FKTABLE_SCHEM");
            this.columnNames.add("FKTABLE_NAME");
            this.columnNames.add("FKCOLUMN_NAME");
            this.columnNames.add("KEY_SEQ");
            this.columnNames.add("UPDATE_RULE");
            this.columnNames.add("DELETE_RULE");
            this.columnNames.add("FK_NAME");
            this.columnNames.add("PK_NAME");
            this.columnNames.add("DEFERRABILITY");
            this.columnTypes = new int[this.colCount];
            this.columnTypes[0] = 12;
            this.columnTypes[1] = 12;
            this.columnTypes[2] = 12;
            this.columnTypes[3] = 12;
            this.columnTypes[4] = 12;
            this.columnTypes[5] = 12;
            this.columnTypes[6] = 12;
            this.columnTypes[7] = 12;
            this.columnTypes[8] = 4;
            this.columnTypes[9] = 4;
            this.columnTypes[10] = 4;
            this.columnTypes[11] = 12;
            this.columnTypes[12] = 12;
            this.columnTypes[13] = 4;
        } else if (type == 9) {
            this.colCount = 14;
            this.columnNames = new ArrayList(this.colCount);
            this.columnNames.add("PKTABLE_CAT");
            this.columnNames.add("PKTABLE_SCHEM");
            this.columnNames.add("PKTABLE_NAME");
            this.columnNames.add("PKCOLUMN_NAME");
            this.columnNames.add("FKTABLE_CAT");
            this.columnNames.add("FKTABLE_SCHEM");
            this.columnNames.add("FKTABLE_NAME");
            this.columnNames.add("FKCOLUMN_NAME");
            this.columnNames.add("KEY_SEQ");
            this.columnNames.add("UPDATE_RULE");
            this.columnNames.add("DELETE_RULE");
            this.columnNames.add("FK_NAME");
            this.columnNames.add("PK_NAME");
            this.columnNames.add("DEFERRABILITY");
            this.columnTypes = new int[this.colCount];
            this.columnTypes[0] = 12;
            this.columnTypes[1] = 12;
            this.columnTypes[2] = 12;
            this.columnTypes[3] = 12;
            this.columnTypes[4] = 12;
            this.columnTypes[5] = 12;
            this.columnTypes[6] = 12;
            this.columnTypes[7] = 12;
            this.columnTypes[8] = 4;
            this.columnTypes[9] = 4;
            this.columnTypes[10] = 4;
            this.columnTypes[11] = 12;
            this.columnTypes[12] = 12;
            this.columnTypes[13] = 4;
        } else if (type == 10) {
            this.colCount = 6;
            this.columnNames = new ArrayList(this.colCount);
            this.columnNames.add("TABLE_CAT");
            this.columnNames.add("TABLE_SCHEM");
            this.columnNames.add("TABLE_NAME");
            this.columnNames.add("COLUMN_NAME");
            this.columnNames.add("KEY_SEQ");
            this.columnNames.add("PK_NAME");
            this.columnTypes = new int[this.colCount];
            this.columnTypes[0] = 12;
            this.columnTypes[1] = 12;
            this.columnTypes[2] = 12;
            this.columnTypes[3] = 12;
            this.columnTypes[4] = 4;
            this.columnTypes[5] = 12;
        }
        this.columnLabels = new ArrayList(this.colCount);
        this.columnLabels.addAll(this.columnNames);
        this.columnTypeNames = new ArrayList(this.colCount);
        this.columnClassNames = this.initArrayList(this.colCount);
        this.columnDisplaySizes = new int[this.colCount];
        this.schemaNames = this.initArrayList(this.colCount);
        this.catalogNames = this.initArrayList(this.colCount);
        this.precisions = new int[this.colCount];
        this.scales = new int[this.colCount];
        this.properties = new int[this.colCount];
        this.tableNames = this.initArrayList(this.colCount);
        this.nullables = new int[this.colCount];
        this.initColumnProperties();
    }

    public ResultSetMetaData(String[] names, int[] types) throws SQLException {
        JDBCUtil.log("ResultSetMetaData(" + JDBCUtil.array2String(names) + "," + JDBCUtil.array2String(types) + ")");
        this.colCount = names.length;
        this.columnNames = new ArrayList(this.colCount);
        this.columnTypes = types;
        this.columnTypeNames = new ArrayList(this.colCount);
        this.columnLabels = new ArrayList(this.colCount);
        this.columnClassNames = new ArrayList(this.colCount);
        this.columnDisplaySizes = new int[this.colCount];
        this.schemaNames = new ArrayList(this.colCount);
        this.catalogNames = new ArrayList(this.colCount);
        this.precisions = new int[this.colCount];
        this.scales = new int[this.colCount];
        this.properties = new int[this.colCount];
        this.tableNames = new ArrayList(this.colCount);
        this.nullables = new int[this.colCount];
        int i = 0;
        while (i < names.length) {
            this.columnNames.add(names[i]);
            this.columnLabels.add(names[i]);
            ++i;
        }
        this.initColumnProperties();
    }

    private void initColumnProperties() {
        int i = 0;
        while (i < this.columnNames.size()) {
            this.columnTypeNames.add(JDBCUtil.getTypeName(this.columnTypes[i]));
            this.columnClassNames.add(JDBCUtil.getTypeClassName(this.columnTypes[i]));
            this.columnDisplaySizes[i] = Integer.MAX_VALUE;
            this.precisions[i] = this.columnTypes[i] == 12 ? Integer.MAX_VALUE : 0;
            this.scales[i] = 0;
            this.properties[i] = 0x100110;
            this.nullables[i] = 1;
            ++i;
        }
    }

    @Override
    public int getColumnCount() throws SQLException {
        JDBCUtil.log("ResultSetMetaData.getColumnCount()");
        return this.colCount;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        JDBCUtil.log("ResultSetMetaData.isAutoIncrement(" + column + ")");
        return (this.properties[column - 1] & 2) != 0;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        JDBCUtil.log("ResultSetMetaData.isCaseSensitive(" + column + ")");
        return (this.properties[column - 1] & 4) != 0;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        JDBCUtil.log("ResultSetMetaData.isSearchable(" + column + ")");
        return (this.properties[column - 1] & 8) != 0;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        JDBCUtil.log("ResultSetMetaData.isCurrency(" + column + ")");
        return (this.properties[column - 1] & 0x10) != 0;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        JDBCUtil.log("ResultSetMetaData.isNullable(" + column + ")");
        return this.nullables[column - 1];
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        JDBCUtil.log("ResultSetMetaData.isSigned(" + column + ")");
        return (this.properties[column - 1] & 0x20) != 0;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        JDBCUtil.log("ResultSetMetaData.getColumnDisplaySize(" + column + ")");
        return 10000;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        JDBCUtil.log("ResultSetMetaData.getColumnLabel(" + column + ")");
        if (this.columnLabels == null || this.columnLabels.size() <= column - 1) {
            return null;
        }
        Object o = this.columnLabels.get(column - 1);
        return o == null ? null : o.toString();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        JDBCUtil.log("ResultSetMetaData.getColumnName(" + column + ")");
        if (this.columnNames == null || this.columnNames.size() <= column - 1) {
            return null;
        }
        Object o = this.columnNames.get(column - 1);
        return o == null ? null : o.toString();
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        JDBCUtil.log("ResultSetMetaData.getSchemaName(" + column + ")");
        return "";
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        JDBCUtil.log("ResultSetMetaData.getPrecision(" + column + ")");
        if (this.precisions == null || this.precisions.length <= column - 1) {
            return 0;
        }
        return this.precisions[column - 1];
    }

    @Override
    public int getScale(int column) throws SQLException {
        JDBCUtil.log("ResultSetMetaData.getScale(" + column + ")");
        if (this.scales == null || this.scales.length <= column - 1) {
            return 0;
        }
        JDBCUtil.log("ResultSetMetaData.()16:" + this.scales[column - 1]);
        return this.scales[column - 1];
    }

    @Override
    public String getTableName(int column) throws SQLException {
        JDBCUtil.log("ResultSetMetaData.getTableName(" + column + ")");
        if (this.tableNames == null || this.tableNames.size() <= column - 1) {
            return null;
        }
        Object o = this.tableNames.get(column - 1);
        return o == null ? null : o.toString();
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        JDBCUtil.log("ResultSetMetaData.getCatalogName(" + column + ")");
        if (this.catalogNames == null || this.catalogNames.size() <= column - 1) {
            return null;
        }
        Object o = this.catalogNames.get(column - 1);
        return o == null ? null : o.toString();
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        JDBCUtil.log("ResultSetMetaData.getColumnType(" + column + ")");
        if (this.columnTypes == null || this.columnTypes.length <= column - 1) {
            return 12;
        }
        JDBCUtil.log("ResultSetMetaData.()19-type[" + this.columnTypes[column - 1] + "]");
        return this.columnTypes[column - 1] == 0 ? 12 : this.columnTypes[column - 1];
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        JDBCUtil.log("ResultSetMetaData.getColumnTypeName(" + column + ")");
        if (this.columnTypeNames == null || this.columnTypeNames.size() <= column - 1) {
            return null;
        }
        Object o = this.columnTypeNames.get(column - 1);
        return o == null ? null : o.toString();
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        JDBCUtil.log("ResultSetMetaData.isReadOnly(" + column + ")");
        return (this.properties[column - 1] & 0x40) != 0;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        JDBCUtil.log("ResultSetMetaData.isWritable(" + column + ")");
        return (this.properties[column - 1] & 0x80) != 0;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        JDBCUtil.log("ResultSetMetaData.isDefinitelyWritable(" + column + ")");
        return (this.properties[column - 1] & 0x100) != 0;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        JDBCUtil.log("ResultSetMetaData.getColumnClassName(" + column + ")");
        if (this.columnClassNames == null || this.columnClassNames.size() <= column - 1) {
            return null;
        }
        Object o = this.columnClassNames.get(column - 1);
        return o == null ? null : o.toString();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        JDBCUtil.log("ResultSetMetaData.isWrapperFor(Class<?> iface)");
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        JDBCUtil.log("ResultSetMetaData.unwrap(Class<T> iface)");
        return null;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        JDBCUtil.log("ResultSetMetaData.readExternal(ObjectInput in)");
        in.readByte();
        this.colCount = in.readInt();
        this.columnNames = JDBCUtil.readArrayList(in);
        this.columnTypes = (int[])in.readObject();
        this.columnTypeNames = JDBCUtil.readArrayList(in);
        this.columnLabels = JDBCUtil.readArrayList(in);
        this.columnClassNames = JDBCUtil.readArrayList(in);
        this.columnDisplaySizes = (int[])in.readObject();
        this.schemaNames = JDBCUtil.readArrayList(in);
        this.catalogNames = JDBCUtil.readArrayList(in);
        this.precisions = (int[])in.readObject();
        this.scales = (int[])in.readObject();
        this.tableNames = JDBCUtil.readArrayList(in);
        this.properties = (int[])in.readObject();
        this.nullables = (int[])in.readObject();
        JDBCUtil.log("ResultSetMetaData.()25-end");
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        JDBCUtil.log("ResultSetMetaData.writeExternal(ObjectOutput out)");
        out.writeByte(1);
        out.writeInt(this.colCount);
        JDBCUtil.writeArrayList(out, this.columnNames);
        out.writeObject(this.columnTypes);
        JDBCUtil.writeArrayList(out, this.columnTypeNames);
        JDBCUtil.writeArrayList(out, this.columnLabels);
        JDBCUtil.writeArrayList(out, this.columnClassNames);
        out.writeObject(this.columnDisplaySizes);
        JDBCUtil.writeArrayList(out, this.schemaNames);
        JDBCUtil.writeArrayList(out, this.catalogNames);
        out.writeObject(this.precisions);
        out.writeObject(this.scales);
        JDBCUtil.writeArrayList(out, this.tableNames);
        out.writeObject(this.properties);
        out.writeObject(this.nullables);
    }

    private ArrayList<Object> initArrayList(int colCount) {
        ArrayList<Object> list = new ArrayList<Object>(colCount);
        return list;
    }
}

