/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.app.common;

import com.scudata.app.config.RaqsoftConfig;
import com.scudata.cellset.datamodel.Command;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.cellset.datamodel.PgmNormalCell;
import com.scudata.common.Escape;
import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.common.Sentence;
import com.scudata.common.StringUtils;
import com.scudata.common.UUID;
import com.scudata.dm.ComputeStack;
import com.scudata.dm.Context;
import com.scudata.dm.Env;
import com.scudata.dm.FileObject;
import com.scudata.dm.JobSpace;
import com.scudata.dm.JobSpaceManager;
import com.scudata.dm.KeyWord;
import com.scudata.dm.Param;
import com.scudata.dm.ParamList;
import com.scudata.dm.Sequence;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.query.SimpleSQL;
import com.scudata.expression.fn.Eval;
import com.scudata.resources.EngineMessage;
import com.scudata.util.CellSetUtil;
import com.scudata.util.DatabaseUtil;
import com.scudata.util.Variant;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import sun.net.util.IPAddressUtil;

public class AppUtil {
    private static HashMap<Integer, Object> colorMap = new HashMap();
    public static final int TRANSPARENT_COLOR = 0xFFFFFF;
    private static volatile String[] ips = null;

    public static Object executeCmd(String cmd, Context ctx) throws SQLException {
        return AppUtil.executeCmd(cmd, null, ctx);
    }

    public static Object executeCmd(String cmd, Sequence args, Context ctx) throws SQLException {
        return AppUtil.executeCmd(cmd, args, ctx, true);
    }

    public static Object executeCmd(String cmd, Sequence args, Context ctx, boolean escape) throws SQLException {
        Object val;
        if (!StringUtils.isValidString(cmd)) {
            return null;
        }
        boolean returnValue = true;
        boolean isExp = false;
        boolean isGrid = false;
        if (cmd.startsWith(">")) {
            returnValue = false;
            isExp = true;
        } else if (cmd.startsWith("=")) {
            cmd = cmd.substring(1);
            isExp = true;
            isGrid = AppUtil.isGrid(cmd);
        }
        if (escape) {
            cmd = Escape.removeEscAndQuote(cmd);
        }
        if (!isExp && cmd.startsWith("$")) {
            String s = cmd;
            if ((s = s.substring(1).trim()).startsWith("(")) {
                if ((s = s.substring(1).trim()).startsWith(")")) {
                    cmd = s.substring(1).trim();
                    return AppUtil.executeSql(cmd, AppUtil.sequence2List(args), ctx);
                }
                cmd = AppUtil.prepareSql(cmd, args);
                return AppUtil.execute(cmd, args, ctx);
            }
            if (AppUtil.isSQL(cmd)) {
                if (cmd.startsWith("$")) {
                    cmd = cmd.substring(1);
                    cmd = cmd.trim();
                }
                return AppUtil.executeSql(cmd, AppUtil.sequence2List(args), ctx);
            }
        }
        if (isGrid) {
            val = AppUtil.execute(cmd, args, ctx);
        } else {
            if (cmd.startsWith("=") || cmd.startsWith(">")) {
                cmd = cmd.substring(1);
            }
            val = AppUtil.execute1(cmd, args, ctx);
        }
        if (returnValue) {
            return val;
        }
        return null;
    }

    public static String prepareSql(String cmd, Sequence args) {
        if (args != null && args.length() > 0) {
            int argIndex;
            if (cmd.endsWith(";")) {
                cmd = cmd.substring(0, cmd.length() - 1).trim();
            }
            if ((argIndex = cmd.lastIndexOf(";")) < 0) {
                int len = args.length();
                int pc = 0;
                int i = 0;
                while (i < cmd.length()) {
                    if (cmd.charAt(i) == '?') {
                        ++pc;
                    }
                    ++i;
                }
                len = Math.min(len, pc);
                i = 1;
                while (i <= len) {
                    String argName = "?" + i;
                    cmd = i == 1 ? String.valueOf(cmd) + ";" : String.valueOf(cmd) + ",";
                    cmd = String.valueOf(cmd) + argName;
                    ++i;
                }
            }
        }
        cmd = String.valueOf(cmd) + "\treturn A1";
        return cmd;
    }

    private static List<Object> sequence2List(Sequence args) {
        if (args == null || args.length() == 0) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 1;
        int len = args.length();
        while (i <= len) {
            list.add(args.get(i));
            ++i;
        }
        return list;
    }

    public static Object executeSql(String sql, List<Object> args, Context ctx) {
        ComputeStack stack = ctx.getComputeStack();
        try {
            Sequence argSeq = new Sequence();
            if (args != null) {
                for (Object arg : args) {
                    argSeq.add(arg);
                }
            }
            stack.pushArg(argSeq);
            SimpleSQL lq = new SimpleSQL(sql, args, ctx);
            Object object = lq.execute();
            return object;
        }
        finally {
            stack.popArg();
        }
    }

    public static boolean isSQL(String sql) {
        if (sql.startsWith("$")) {
            sql = sql.substring(1);
            sql = sql.trim();
        }
        sql = sql.trim();
        while (sql.startsWith("(") || sql.startsWith(")")) {
            sql = sql.substring(1);
            sql = sql.trim();
        }
        return sql.toLowerCase().startsWith("select") ? (sql = sql.substring("select".length())).length() > 1 && StringUtils.isSpaceString(sql.substring(0, 1)) : sql.toLowerCase().startsWith("with") && (sql = sql.substring("with".length())).length() > 1 && StringUtils.isSpaceString(sql.substring(0, 1));
    }

    public static boolean isGrid(String sql) {
        if (sql == null || sql.trim().length() == 0) {
            return false;
        }
        if (sql.startsWith("#")) {
            return true;
        }
        try {
            PgmCellSet cs = CellSetUtil.toPgmCellSet(sql);
            if (cs.getRowCount() > 1 || cs.getColCount() > 1) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Command.isCommand(sql);
    }

    public static Object execute1(String src, Sequence args, Context ctx) {
        Object obj = Eval.calc(src, args, null, ctx);
        return obj;
    }

    public static Object execute(String src, Sequence args, Context ctx) {
        PgmCellSet pcs = CellSetUtil.toPgmCellSet(src);
        ComputeStack stack = null;
        try {
            pcs.setParamToContext();
            Context csCtx = pcs.getContext();
            stack = csCtx.getComputeStack();
            stack.pushArg(args);
            AppUtil.setParamToCellSet(pcs, args);
            csCtx.setEnv(ctx);
            pcs.calculateResult();
            PgmCellSet pgmCellSet = pcs;
            return pgmCellSet;
        }
        finally {
            if (stack != null) {
                stack.popArg();
            }
        }
    }

    public static Object executeResult(String exp, Sequence args, Context ctx) throws SQLException {
        if (exp == null) {
            return null;
        }
        Object val = AppUtil.executeCmd(exp = "=" + exp, args, ctx);
        if (val == null) {
            return null;
        }
        if (val instanceof PgmCellSet) {
            PgmCellSet result = (PgmCellSet)val;
            if (result.hasNextResult()) {
                val = result.nextResult();
            } else {
                return null;
            }
        }
        if (val instanceof ICursor) {
            ICursor cursor = (ICursor)val;
            return cursor.fetch();
        }
        return val;
    }

    public static void setParamToCellSet(PgmCellSet cellSet, Sequence args) {
        if (cellSet == null) {
            return;
        }
        ParamList list = cellSet.getParamList();
        if (list == null) {
            return;
        }
        ParamList varList = new ParamList();
        list.getAllVarParams(varList);
        int paramCount = varList.count();
        if (paramCount == 0) {
            return;
        }
        int argCount = args == null ? 0 : args.length();
        boolean isDynamicParam = cellSet.isDynamicParam();
        Context ctx = cellSet.getContext();
        if (!isDynamicParam || argCount < paramCount) {
            int i = 0;
            while (i < paramCount) {
                Param p = varList.get(i);
                if (i < argCount) {
                    ctx.setParamValue(p.getName(), args.get(i + 1));
                } else {
                    Object obj = p.getEditValue();
                    if (obj == null) {
                        obj = p.getValue();
                    }
                    if (obj != null && obj instanceof String) {
                        obj = PgmNormalCell.parseConstValue((String)obj);
                    }
                    ctx.setParamValue(p.getName(), obj);
                }
                ++i;
            }
        } else {
            Param p;
            int i = 0;
            while (i < paramCount - 1) {
                p = varList.get(i);
                ctx.setParamValue(p.getName(), args.get(i + 1));
                ++i;
            }
            Sequence dynamicParam = args.get(paramCount, argCount + 1);
            p = varList.get(paramCount - 1);
            ctx.setParamValue(p.getName(), dynamicParam);
        }
    }

    public static String scanId(String expStr, int location) {
        int len = expStr.length();
        int begin = location;
        while (location < len) {
            char c = expStr.charAt(location);
            if (KeyWord.isSymbol(c)) break;
            ++location;
        }
        return expStr.substring(begin, location);
    }

    public static boolean isNextChar(char c, String expStr, int location) {
        int len = expStr.length();
        int i = location;
        while (i < len) {
            if (expStr.charAt(i) == c) {
                return true;
            }
            if (!Character.isWhitespace(expStr.charAt(i))) {
                return false;
            }
            ++i;
        }
        return false;
    }

    public static Color getColor(int c) {
        if (c == 0xFFFFFF) {
            return null;
        }
        Color CC = (Color)colorMap.get(c);
        if (CC == null) {
            CC = new Color(c);
            colorMap.put(c, CC);
        }
        return CC;
    }

    public static Format getFormatter(String fmt, byte dataType) {
        Format formatter = null;
        if (StringUtils.isValidString(fmt)) {
            formatter = fmt.indexOf(35) >= 0 ? new DecimalFormat(fmt) : new SimpleDateFormat(fmt);
        } else {
            fmt = null;
            switch (dataType) {
                case 8: {
                    fmt = Env.getDateFormat();
                    break;
                }
                case 9: {
                    fmt = Env.getTimeFormat();
                    break;
                }
                case 10: {
                    fmt = Env.getDateTimeFormat();
                }
            }
            if (fmt != null) {
                formatter = new SimpleDateFormat(fmt);
            }
        }
        return formatter;
    }

    public static Object invokeMethod(Object owner, String methodName, Object[] args) throws Exception {
        return AppUtil.invokeMethod(owner, methodName, args, null);
    }

    public static Object invokeMethod(Object owner, String methodName, Object[] args, Class[] argClasses) throws Exception {
        Class<?> ownerClass = owner.getClass();
        if (argClasses == null) {
            Method[] ms = ownerClass.getMethods();
            int i = 0;
            while (i < ms.length) {
                Method m = ms[i];
                if (m.getName().equals(methodName) && AppUtil.isArgsMatchMethod(m, args)) {
                    return m.invoke(owner, args);
                }
                ++i;
            }
            StringBuffer argNames = new StringBuffer();
            argNames.append("(");
            int i2 = 0;
            while (i2 < args.length) {
                if (i2 > 0) {
                    argNames.append(",");
                }
                argNames.append(args[i2].getClass().getName());
                ++i2;
            }
            argNames.append(")");
            throw new Exception(String.valueOf(methodName) + argNames + " not found.");
        }
        Method m = ownerClass.getMethod(methodName, argClasses);
        return m.invoke(owner, args);
    }

    private static boolean isArgsMatchMethod(Method m, Object[] args) {
        Class<?>[] mArgs = m.getParameterTypes();
        if (mArgs.length != args.length) {
            return false;
        }
        int i = 0;
        while (i < args.length) {
            if (!mArgs[i].isInstance(args[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static Object invokeStaticMethod(String classPath, String methodName, Object[] args, Class[] argClasses) throws Exception {
        Class<?> ownerClass = Class.forName(classPath);
        Method m = ownerClass.getMethod(methodName, argClasses);
        return m.invoke(ownerClass, args);
    }

    public static byte[] getStreamBytes(InputStream is) throws Exception {
        ArrayList<byte[]> al = new ArrayList<byte[]>();
        int totalBytes = 0;
        byte[] b = new byte[102400];
        int readBytes = 0;
        while ((readBytes = is.read(b)) > 0) {
            byte[] bb = new byte[readBytes];
            System.arraycopy(b, 0, bb, 0, readBytes);
            al.add(bb);
            totalBytes += readBytes;
        }
        b = new byte[totalBytes];
        int pos = 0;
        int i = 0;
        while (i < al.size()) {
            byte[] bb = (byte[])al.get(i);
            System.arraycopy(bb, 0, b, pos, bb.length);
            pos += bb.length;
            ++i;
        }
        return b;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean isLocalIP(String ip) {
        if (ip.startsWith("127.") || ip.equalsIgnoreCase("localhost")) {
            return true;
        }
        boolean isIp4 = IPAddressUtil.isIPv4LiteralAddress(ip);
        String[] ips = AppUtil.getLocalIps();
        if (isIp4) {
            if (ips.length > 0) {
                int i = 0;
                while (i < ips.length) {
                    String tmpHost = ips[i];
                    if (tmpHost.equalsIgnoreCase(ip)) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }
        try {
            byte[] ia1 = IPAddressUtil.textToNumericFormatV6(ip);
            if (ips.length > 0) {
                int i = 0;
                while (i < ips.length) {
                    byte[] ia2;
                    String tmpHost = ips[i];
                    if (!IPAddressUtil.isIPv4LiteralAddress(tmpHost) && Arrays.equals(ia1, ia2 = IPAddressUtil.textToNumericFormatV6(tmpHost))) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static String[] getLocalIps() {
        if (ips == null) {
            ips = AppUtil.getAllLocalHosts();
        }
        return ips;
    }

    public static String[] getAllLocalHosts() {
        ArrayList<String> ips = new ArrayList<String>();
        try {
            InetAddress[] inets = AppUtil.getAllLocalInet();
            int i = 0;
            while (i < inets.length) {
                String hostIp = inets[i].getHostAddress();
                ips.add(hostIp);
                ++i;
            }
        }
        catch (Exception x) {
            Logger.info("Error on get localhost:" + x.getMessage());
        }
        if (ips.isEmpty()) {
            return new String[0];
        }
        return StringUtils.toStringArray(ips);
    }

    public static InetAddress[] getAllLocalInet() throws UnknownHostException {
        InetAddress[] localIAs = InetAddress.getAllByName("127.0.0.1");
        if (localIAs.length != 1) {
            return localIAs;
        }
        if (!localIAs[0].isLoopbackAddress()) {
            return localIAs;
        }
        localIAs = AppUtil.getAllLocalUsingNetworkInterface();
        return localIAs;
    }

    /*
     * Unable to fully structure code
     */
    private static InetAddress[] getAllLocalUsingNetworkInterface() throws UnknownHostException {
        addresses = new ArrayList<InetAddress>();
        e = null;
        try {
            e = NetworkInterface.getNetworkInterfaces();
            if (true) ** GOTO lbl23
        }
        catch (SocketException ex) {
            throw new UnknownHostException("127.0.0.1");
        }
        do {
            ni = e.nextElement();
            try {
                if (!ni.isUp()) {
                    continue;
                }
            }
            catch (Exception var3_5) {
                // empty catch block
            }
            e2 = ni.getInetAddresses();
            while (e2.hasMoreElements()) {
                ia = e2.nextElement();
                if (ia.getHostAddress().equals("0:0:0:0:0:0:0:1")) continue;
                addresses.add(ia);
            }
lbl23:
            // 3 sources

        } while (e.hasMoreElements());
        iAddresses = new InetAddress[addresses.size()];
        i = 0;
        while (i < iAddresses.length) {
            iAddresses[i] = (InetAddress)addresses.get(i);
            ++i;
        }
        return iAddresses;
    }

    public static boolean isWindowsOS() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.indexOf("windows") > -1;
    }

    public static PgmCellSet readSPL(String filePath) throws Exception {
        String spl = AppUtil.readSPLString(filePath);
        return AppUtil.spl2CellSet(spl);
    }

    public static PgmCellSet readSPL(InputStream in) throws Exception {
        String spl = AppUtil.readSPLString(in);
        return AppUtil.spl2CellSet(spl);
    }

    public static PgmCellSet spl2CellSet(String spl) {
        ParamList pl;
        if (!StringUtils.isValidString(spl)) {
            return null;
        }
        PgmCellSet cellSet = CellSetUtil.toPgmCellSet(spl);
        if (cellSet != null && (pl = cellSet.getParamList()) != null) {
            int i = 0;
            while (i < pl.count()) {
                Object value;
                Param p = pl.get(i);
                if (p != null && (value = p.getValue()) != null && p.getEditValue() == null) {
                    p.setEditValue(AppUtil.getEditValueByValue(value));
                }
                ++i;
            }
        }
        return cellSet;
    }

    public static Object getEditValueByValue(Object value) {
        if (value != null) {
            Object editValue = value;
            if (editValue instanceof String) {
                if (!StringUtils.isValidString(editValue)) {
                    editValue = null;
                }
            } else {
                editValue = Variant.toString(value);
            }
            return editValue;
        }
        return null;
    }

    private static String readSPLString(String filePath) throws Exception {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(filePath);
            String string = AppUtil.readSPLString(fis);
            return string;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static String readSPLString(InputStream is) throws Exception {
        InputStreamReader isr = null;
        BufferedReader br = null;
        StringBuffer buf = new StringBuffer();
        try {
            isr = new InputStreamReader(is, Env.getDefaultCharsetName());
            br = new BufferedReader(isr);
            String rowStr = br.readLine();
            boolean isFirst = true;
            while (rowStr != null) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    buf.append('\n');
                }
                buf.append(rowStr);
                rowStr = br.readLine();
            }
            String string = buf.toString();
            return string;
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (isr != null) {
                    isr.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void writeSPLFile(String filePath, PgmCellSet cellSet) throws Exception {
        String cellSetStr = CellSetUtil.toString(cellSet);
        AppUtil.writeSPLFile(filePath, cellSetStr);
    }

    public static void writeSPLFile(String filePath, String cellSetStr) throws Exception {
        FileOutputStream fo = null;
        OutputStreamWriter ow = null;
        BufferedWriter bw = null;
        try {
            fo = new FileOutputStream(filePath);
            ow = new OutputStreamWriter((OutputStream)fo, Env.getDefaultCharsetName());
            bw = new BufferedWriter(ow);
            bw.write(cellSetStr);
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (Exception exception) {}
            }
            if (ow != null) {
                try {
                    ow.close();
                }
                catch (Exception exception) {}
            }
            if (fo != null) {
                try {
                    fo.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static boolean isSPLFile(String fileName) {
        String[] fileExts;
        if (!StringUtils.isValidString(fileName)) {
            return false;
        }
        String[] stringArray = fileExts = "splx,spl,dfx".split(",");
        int n = fileExts.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            if (fileName.toLowerCase().endsWith("." + ext)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static PgmCellSet readCellSet(String filePath) throws Exception {
        if ((filePath = AppUtil.searchSplFilePath(filePath)) == null) {
            return null;
        }
        PgmCellSet cs = null;
        BufferedInputStream bis = null;
        InputStream is = null;
        try {
            FileObject fo = new FileObject(filePath, "s");
            is = fo.getInputStream();
            bis = new BufferedInputStream(is);
            cs = filePath.toLowerCase().endsWith(".spl") ? AppUtil.readSPL(bis) : CellSetUtil.readPgmCellSet(bis);
            if (cs != null) {
                cs.setName(filePath);
            }
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception exception) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return cs;
    }

    public static String searchSplFilePath(String filePath) {
        if (filePath == null) {
            return null;
        }
        filePath = filePath.trim();
        boolean isSearched = false;
        if (AppUtil.isSPLFile(filePath)) {
            isSearched = true;
        } else {
            String[] splExts = "splx,spl,dfx".split(",");
            boolean endWithPoint = filePath.endsWith(".");
            String[] stringArray = splExts;
            int n = splExts.length;
            int n2 = 0;
            while (n2 < n) {
                FileObject fo;
                String ext = stringArray[n2];
                String searchFile = filePath;
                if (!endWithPoint) {
                    searchFile = String.valueOf(searchFile) + ".";
                }
                if ((fo = new FileObject(searchFile = String.valueOf(searchFile) + ext, "s")).isExists()) {
                    isSearched = true;
                    filePath = searchFile;
                    break;
                }
                ++n2;
            }
        }
        if (!isSearched) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("file.fileNotExist", filePath));
        }
        return filePath;
    }

    public static String getThrowableString(Throwable e) {
        if (e != null) {
            if (e instanceof ThreadDeath) {
                return null;
            }
            Throwable cause = e.getCause();
            int i = 0;
            while (cause != null) {
                if (cause instanceof ThreadDeath) {
                    return null;
                }
                cause = cause.getCause();
                if (++i <= 10) {
                    continue;
                }
                break;
            }
        } else {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            e.printStackTrace(new PrintStream(baos));
        }
        finally {
            try {
                baos.close();
            }
            catch (Exception exception) {}
        }
        return baos.toString();
    }

    public static void destroyThread(Thread runThread) {
        if (runThread != null) {
            try {
                runThread.stop();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static int[] matchBrackets(String text, int caret, int searchType) {
        block8: {
            if (StringUtils.isValidString(text)) break block8;
            return null;
        }
        try {
            if (caret >= text.length()) {
                --caret;
            }
            int matchDot = -1;
            int md = AppUtil.findBrackets(text, caret, searchType);
            if (md > -1) {
                matchDot = md;
            } else if (caret > 0 && (md = AppUtil.findBrackets(text, --caret, searchType)) > -1) {
                matchDot = md;
            }
            if (matchDot > -1) {
                return new int[]{caret, matchDot};
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static int findBrackets(String text, int caret, int searchType) {
        block17: {
            int inBrackets;
            char c;
            block16: {
                c = text.charAt(caret);
                inBrackets = 0;
                if (c != '(') break block16;
                if (!AppUtil.isValidChar(text, caret, searchType)) {
                    return -1;
                }
                ++inBrackets;
                int i = caret + 1;
                while (i < text.length()) {
                    char c1 = text.charAt(i);
                    if (c1 == '(') {
                        if (AppUtil.isValidChar(text, i, searchType)) {
                            ++inBrackets;
                        }
                    } else if (c1 == ')' && AppUtil.isValidChar(text, i, searchType)) {
                        if (--inBrackets == 0) {
                            return i;
                        }
                        if (inBrackets < 0) {
                            return -1;
                        }
                    }
                    ++i;
                }
                break block17;
            }
            if (c != ')') break block17;
            if (!AppUtil.isValidChar(text, caret, searchType)) {
                return -1;
            }
            ++inBrackets;
            int i = caret - 1;
            while (i >= 0) {
                char c1 = text.charAt(i);
                if (c1 == ')') {
                    if (AppUtil.isValidChar(text, i, searchType)) {
                        ++inBrackets;
                    }
                } else if (c1 == '(' && AppUtil.isValidChar(text, i, searchType)) {
                    if (--inBrackets == 0) {
                        return i;
                    }
                    if (inBrackets < 0) {
                        return -1;
                    }
                }
                --i;
            }
        }
        return -1;
    }

    private static boolean isValidChar(String text, int index, int searchType) {
        return AppUtil.isValidString(text, index, 1, searchType);
    }

    private static boolean isValidString(String text, int index, int len, int searchType) {
        int i = Sentence.indexOf(text, index, text.substring(index, index + len), searchType);
        return index == i;
    }

    public static Context prepareEnv(RaqsoftConfig config) {
        Context ctx;
        try {
            ctx = new Context();
            if (config != null) {
                DatabaseUtil.connectAutoDBs(ctx, config.getAutoConnectList());
            }
        }
        catch (Throwable x) {
            Logger.debug(x);
            ctx = new Context();
        }
        String uuid = AppUtil.getUUID();
        JobSpace js = JobSpaceManager.getSpace(uuid);
        ctx.setJobSpace(js);
        return ctx;
    }

    public static synchronized String getUUID() {
        return UUID.randomUUID().toString();
    }
}

