/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.app.common;

import com.scudata.common.ArgumentTokenizer;
import com.scudata.common.Escape;
import com.scudata.common.StringUtils;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class Section {
    public Vector sections = new Vector();
    private boolean allowSame = false;

    public Section() {
        this(false);
    }

    public Section(boolean allowSameSection) {
        this.allowSame = allowSameSection;
    }

    public Section(Vector items) {
        this(items, false);
    }

    public Section(Vector items, boolean allowSameSection) {
        this(allowSameSection);
        if (items == null) {
            return;
        }
        this.sections = (Vector)items.clone();
    }

    public Section(Set items) {
        this(items, false);
    }

    public Section(Set items, boolean allowSameSection) {
        this(allowSameSection);
        if (items == null) {
            return;
        }
        Iterator all = items.iterator();
        while (all.hasNext()) {
            this.sections.add(all.next());
        }
    }

    public Section(Object[] items) {
        this(items, false);
    }

    public Section(Object[] items, boolean allowSameSection) {
        this(allowSameSection);
        if (items == null) {
            return;
        }
        int i = 0;
        while (i < items.length) {
            this.sections.add(items[i]);
            ++i;
        }
    }

    public Section(String items) {
        this(items, false);
    }

    public Section(String items, boolean allowSameSection) {
        this(allowSameSection);
        if (items == null) {
            return;
        }
        this.unionSection(items);
    }

    public Section(String items, char delim) {
        this(items, delim, false);
    }

    public Section(String items, char delim, boolean allowSameSection) {
        this(items, delim, allowSameSection, true);
    }

    public Section(String items, char delim, boolean allowSameSection, boolean removeEscape) {
        this(allowSameSection);
        if (items == null) {
            return;
        }
        this.unionSection(items, delim, removeEscape);
    }

    public void unionSection(String items) {
        this.unionSection(items, ',');
    }

    public void unionSection(String items, char delim) {
        this.unionSection(items, delim, true);
    }

    public void unionSection(String items, char delim, boolean removeEscape) {
        if (items == null) {
            return;
        }
        ArgumentTokenizer st = new ArgumentTokenizer(items, delim);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (removeEscape) {
                s = Escape.removeEscAndQuote(s);
            }
            this.addSection(s);
        }
    }

    public void addSection(String item) {
        if (item == null) {
            item = "";
        }
        if (this.allowSame || !this.sections.contains(item)) {
            this.sections.add(item);
        }
    }

    public void insertSection(String item, int index) {
        if (!StringUtils.isValidString(item)) {
            return;
        }
        if (this.allowSame || !this.sections.contains(item)) {
            this.sections.insertElementAt(item, index);
        }
    }

    public void removeSection(String items) {
        if (items == null) {
            return;
        }
        ArgumentTokenizer st = new ArgumentTokenizer(items, ',');
        while (st.hasMoreTokens()) {
            this.sections.remove(st.nextToken());
        }
    }

    public void removeSection(int index) {
        this.sections.remove(index);
    }

    public void unionSection(Section items) {
        this.unionSection(items.toString());
    }

    public String toSectionString() {
        StringBuffer buf = new StringBuffer(1024);
        int i = 0;
        while (i < this.sections.size()) {
            buf.append(',');
            buf.append(Escape.addEscAndQuote((String)this.sections.get(i)));
            ++i;
        }
        if (buf.length() == 0) {
            return "";
        }
        return buf.substring(1);
    }

    public String toString() {
        return this.toString(',');
    }

    public String toString(char delim) {
        StringBuffer buf = new StringBuffer(1024);
        int i = 0;
        while (i < this.sections.size()) {
            buf.append(delim);
            buf.append(this.sections.get(i));
            ++i;
        }
        if (buf.length() == 0) {
            return "";
        }
        return buf.substring(1);
    }

    public String getSection(int i) {
        if (this.sections.size() == 0) {
            return "";
        }
        if (i < 0 || i >= this.sections.size()) {
            return "";
        }
        return this.sections.get(i).toString();
    }

    public String get(int i) {
        return this.getSection(i);
    }

    public int indexOf(String section) {
        return this.sections.indexOf(section);
    }

    public void replaceSection(int index, String newItem) {
        this.sections.set(index, newItem);
    }

    public boolean containsSection(String item) {
        return this.sections.contains(item);
    }

    public int size() {
        return this.sections.size();
    }

    public void clear() {
        this.sections.clear();
    }

    public Vector toVector() {
        return this.sections;
    }

    public String[] toStringArray() {
        Object[] oa = this.sections.toArray();
        String[] sa = new String[oa.length];
        int i = 0;
        while (i < oa.length) {
            sa[i] = ((String)oa[i]).trim();
            ++i;
        }
        return sa;
    }
}

