/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.app.common;

import com.scudata.common.Escape;
import com.scudata.common.SegmentSet;
import java.util.Iterator;
import java.util.Set;

public class Segment {
    public SegmentSet ss = new SegmentSet();

    public Segment() {
        this("");
    }

    public Segment(boolean caseSense) {
        this("", caseSense);
    }

    public Segment(String str) {
        this.ss = new SegmentSet(str);
    }

    public Segment(String str, boolean caseSense) {
        this.ss = new SegmentSet(str, caseSense);
    }

    public String put(String key, String val) {
        return this.put(key, val, true);
    }

    public String put(String key, String val, boolean addQuote) {
        if (addQuote) {
            val = Escape.addEscAndQuote(val, true, "()[]{}", '\\');
        }
        return this.ss.put(key, val);
    }

    public String remove(String key) {
        return this.ss.remove(key);
    }

    public String get(String key) {
        String tmp = this.ss.get(key);
        return Escape.removeEscAndQuote(tmp);
    }

    public String getValueWithoutRemove(String key) {
        String tmp = this.ss.get(key);
        return tmp;
    }

    public void union(Segment other) {
        Iterator otherKeys = other.keySet().iterator();
        while (otherKeys.hasNext()) {
            String key = otherKeys.next().toString();
            String val = other.get(key);
            this.put(key, val);
        }
    }

    public Set keySet() {
        return this.ss.keySet();
    }

    public String toString() {
        return this.ss.toString();
    }
}

