/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.app.config;

import com.scudata.app.config.ConfigConsts;
import com.scudata.app.config.ConfigUtil;
import com.scudata.app.config.RaqsoftConfig;
import com.scudata.app.config.RemoteStoreConfig;
import com.scudata.app.config.Xmla;
import com.scudata.common.DBConfig;
import com.scudata.common.DBInfo;
import com.scudata.common.DBTypes;
import com.scudata.common.JNDIConfig;
import com.scudata.common.Logger;
import com.scudata.common.PwdUtils;
import com.scudata.common.SpringDBConfig;
import com.scudata.common.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigHandler
extends DefaultHandler {
    protected int version = 3;
    protected StringBuffer buf = new StringBuffer();
    protected RaqsoftConfig config;
    protected static final short RUNTIME = 1;
    protected static final short RUNTIME_DB = 2;
    protected static final short RUNTIME_XMLA = 3;
    protected static final short RUNTIME_ESPROC = 4;
    protected static final short RUNTIME_LOGGER = 8;
    protected static final short INIT = 10;
    protected static final short SERVER = 11;
    protected static final short SERVER_JNDI = 12;
    protected static final short SERVER_SPRING_DB = 13;
    protected static final short JDBC = 14;
    protected short activeNode = (short)2;

    public ConfigHandler() {
        this.config = new RaqsoftConfig();
    }

    public RaqsoftConfig getRaqsoftConfig() {
        return this.config;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String value;
        String name;
        DBInfo db;
        this.buf.setLength(0);
        if (qName.equalsIgnoreCase(ConfigConsts.CONFIG)) {
            String sVersion = attributes.getValue(ConfigConsts.VERSION);
            if (StringUtils.isValidString(sVersion)) {
                try {
                    this.version = Integer.parseInt(sVersion);
                }
                catch (Exception ex) {
                    Logger.debug("Invalid version: " + sVersion);
                }
            }
            return;
        }
        if (qName.equalsIgnoreCase(ConfigConsts.RUNTIME)) {
            this.activeNode = 1;
        } else if (qName.equalsIgnoreCase(ConfigConsts.REMOTE_STORES)) {
            this.config.setRemoteStoreList(new ArrayList<RemoteStoreConfig>());
            String defaultName = attributes.getValue(ConfigConsts.DEFAULT);
            if (StringUtils.isValidString(defaultName)) {
                this.config.setDefaultRemoteStore(defaultName);
            } else {
                this.config.setDefaultRemoteStore(null);
            }
        } else if (qName.equalsIgnoreCase(ConfigConsts.REMOTE_STORE)) {
            String sBlockBufferSize;
            RemoteStoreConfig rs = new RemoteStoreConfig();
            rs.setName(attributes.getValue(ConfigConsts.NAME));
            rs.setType(attributes.getValue(ConfigConsts.TYPE));
            rs.setOption(attributes.getValue(ConfigConsts.OPTION));
            rs.setCachePath(attributes.getValue(ConfigConsts.CACHE_PATH));
            String sMinFreeSpace = attributes.getValue(ConfigConsts.MIN_FREE_SPACE);
            if (StringUtils.isValidString(sMinFreeSpace)) {
                try {
                    long minFreeSpace = Long.parseLong(sMinFreeSpace);
                    rs.setMinFreeSpace(minFreeSpace);
                }
                catch (Exception ex) {
                    Logger.debug("Invalid " + ConfigConsts.MIN_FREE_SPACE + ": " + sMinFreeSpace);
                }
            }
            if (StringUtils.isValidString(sBlockBufferSize = attributes.getValue(ConfigConsts.BLOCK_BUFFER_SIZE))) {
                try {
                    int blockBufferSize = Integer.parseInt(sBlockBufferSize);
                    rs.setBlockBufferSize(blockBufferSize);
                }
                catch (Exception ex) {
                    Logger.debug("Invalid " + ConfigConsts.BLOCK_BUFFER_SIZE + ": " + sBlockBufferSize);
                }
            }
            if (this.config.getRemoteStoreList() == null) {
                this.config.setRemoteStoreList(new ArrayList<RemoteStoreConfig>());
            }
            this.config.getRemoteStoreList().add(rs);
        } else if (qName.equalsIgnoreCase(ConfigConsts.DB_LIST)) {
            this.config.setDBList(new ArrayList<DBConfig>());
            this.activeNode = (short)2;
            String sEncryptLevel = null;
            try {
                sEncryptLevel = attributes.getValue(ConfigConsts.ENCRYPT_LEVEL);
            }
            catch (Exception sMinFreeSpace) {
                // empty catch block
            }
            if (StringUtils.isValidString(sEncryptLevel)) {
                try {
                    byte encryptLevel = Byte.parseByte(sEncryptLevel);
                    switch (encryptLevel) {
                        case 0: 
                        case 1: 
                        case 2: {
                            this.config.setEncryptLevel(encryptLevel);
                            break;
                        }
                        default: {
                            Logger.debug("Invalid " + ConfigConsts.ENCRYPT_LEVEL + ": " + sEncryptLevel);
                            break;
                        }
                    }
                }
                catch (Exception ex) {
                    Logger.debug("Invalid " + ConfigConsts.ENCRYPT_LEVEL + ": " + sEncryptLevel);
                }
            }
            String pwdClass = null;
            try {
                pwdClass = attributes.getValue(ConfigConsts.PWD_CLASS);
            }
            catch (Exception sBlockBufferSize) {
                // empty catch block
            }
            if (StringUtils.isValidString(pwdClass)) {
                this.config.setPwdClass(pwdClass);
                try {
                    ConfigUtil.setPwdClass(pwdClass);
                }
                catch (Exception e) {
                    Logger.debug("Invalid " + ConfigConsts.PWD_CLASS + ": " + pwdClass);
                    Logger.error(e);
                }
            }
        } else if (qName.equalsIgnoreCase(ConfigConsts.XMLA_LIST)) {
            this.config.setXmlaList(new ArrayList<Xmla>());
            this.activeNode = (short)3;
        } else if (qName.equalsIgnoreCase(ConfigConsts.ESPROC)) {
            this.activeNode = (short)4;
        } else if (qName.equalsIgnoreCase("dfxPathList")) {
            if (this.version < 3) {
                this.config.setSplPathList(new ArrayList<String>());
            }
        } else if (qName.equalsIgnoreCase(ConfigConsts.SPL_PATH_LIST)) {
            this.config.setSplPathList(new ArrayList<String>());
        } else if (qName.equalsIgnoreCase(ConfigConsts.IMPORT_LIBS)) {
            this.config.setImportLibs(new ArrayList<String>());
        } else if (qName.equalsIgnoreCase(ConfigConsts.LOGGER)) {
            this.activeNode = (short)8;
        } else if (qName.equalsIgnoreCase(ConfigConsts.INIT)) {
            this.activeNode = (short)10;
        } else if (qName.equalsIgnoreCase(ConfigConsts.SERVER)) {
            this.activeNode = (short)11;
        } else if (qName.equalsIgnoreCase(ConfigConsts.JNDI_LIST)) {
            this.activeNode = (short)12;
            this.config.setJNDIList(new ArrayList<JNDIConfig>());
        } else if (qName.equalsIgnoreCase(ConfigConsts.SPRING_DB_LIST)) {
            this.activeNode = (short)13;
            this.config.setSpringDBList(new ArrayList<SpringDBConfig>());
        } else if (qName.equalsIgnoreCase(ConfigConsts.JDBC)) {
            this.activeNode = (short)14;
            this.config.setJdbcNode(true);
        } else if (qName.equalsIgnoreCase(ConfigConsts.UNITS)) {
            this.config.setUnitList(new ArrayList<String>());
        }
        if (this.activeNode == 2) {
            if (qName.equalsIgnoreCase(ConfigConsts.DB)) {
                db = new DBConfig();
                db.setName(attributes.getValue(ConfigConsts.NAME));
                this.config.getDBList().add((DBConfig)db);
            } else if (qName.equalsIgnoreCase(ConfigConsts.PROPERTY)) {
                db = this.getActiveDB();
                if (db != null) {
                    name = attributes.getValue(ConfigConsts.NAME);
                    value = attributes.getValue(ConfigConsts.VALUE);
                    if (name != null && name.trim().length() > 0 && value != null && value.trim().length() > 0) {
                        byte encryptLevel;
                        if (name.equalsIgnoreCase(ConfigConsts.DB_URL)) {
                            encryptLevel = this.config.getEncryptLevel();
                            if (encryptLevel == 2) {
                                try {
                                    value = PwdUtils.decrypt(value);
                                }
                                catch (Exception e) {
                                    Logger.debug("Invalid " + ConfigConsts.DB_URL + ": " + value);
                                    Logger.error(e);
                                }
                            }
                            ((DBConfig)db).setUrl(value);
                        } else if (name.equalsIgnoreCase(ConfigConsts.DB_DRIVER)) {
                            ((DBConfig)db).setDriver(value);
                        } else if (name.equalsIgnoreCase(ConfigConsts.DB_TYPE)) {
                            try {
                                int dbType = Integer.parseInt(value);
                                db.setDBType(dbType);
                            }
                            catch (Exception e) {
                                db.setDBType(DBTypes.getDBType(value));
                            }
                        } else if (name.equalsIgnoreCase(ConfigConsts.DB_USER)) {
                            encryptLevel = this.config.getEncryptLevel();
                            if (encryptLevel == 2) {
                                try {
                                    value = PwdUtils.decrypt(value);
                                }
                                catch (Exception e) {
                                    Logger.debug("Invalid " + ConfigConsts.DB_USER + ": " + value);
                                    Logger.error(e);
                                }
                            }
                            ((DBConfig)db).setUser(value);
                        } else if (name.equalsIgnoreCase(ConfigConsts.DB_PASSWORD)) {
                            encryptLevel = this.config.getEncryptLevel();
                            if (encryptLevel == 1 || encryptLevel == 2) {
                                try {
                                    value = PwdUtils.decrypt(value);
                                }
                                catch (Exception e) {
                                    Logger.debug("Invalid " + ConfigConsts.DB_PASSWORD + ": " + value);
                                    Logger.error(e);
                                }
                            }
                            ((DBConfig)db).setPassword(value);
                        } else if (name.equalsIgnoreCase(ConfigConsts.DB_BATCH_SIZE)) {
                            try {
                                int batchSize = Integer.parseInt(value);
                                db.setBatchSize(batchSize);
                            }
                            catch (Exception e) {
                                Logger.debug("Invalid property " + ConfigConsts.DB_BATCH_SIZE + ":" + value + " of " + db.getName() + " DB.");
                            }
                        } else if (name.equalsIgnoreCase(ConfigConsts.DB_AUTO_CONNECT)) {
                            try {
                                boolean autoConnect = Boolean.valueOf(value);
                                if (autoConnect) {
                                    List<String> autoConnectList = this.config.getAutoConnectList();
                                    if (autoConnectList == null) {
                                        autoConnectList = new ArrayList<String>();
                                        this.config.setAutoConnectList(autoConnectList);
                                    }
                                    autoConnectList.add(db.getName());
                                }
                            }
                            catch (Exception ex) {
                                Logger.debug("Invalid property " + ConfigConsts.DB_AUTO_CONNECT + ":" + value + " of " + db.getName() + " DB.");
                            }
                        } else if (name.equalsIgnoreCase(ConfigConsts.DB_USE_SCHEMA)) {
                            try {
                                boolean useSchema = Boolean.valueOf(value);
                                ((DBConfig)db).setUseSchema(useSchema);
                            }
                            catch (Exception ex) {
                                Logger.debug("Invalid property " + ConfigConsts.DB_USE_SCHEMA + ":" + value + " of " + db.getName() + " DB.");
                            }
                        } else if (name.equalsIgnoreCase(ConfigConsts.DB_ADD_TILDE)) {
                            try {
                                boolean addTilde = Boolean.valueOf(value);
                                ((DBConfig)db).setAddTilde(addTilde);
                            }
                            catch (Exception ex) {
                                Logger.debug("Invalid property " + ConfigConsts.DB_ADD_TILDE + ":" + value + " of " + db.getName() + " DB.");
                            }
                        } else if (name.equalsIgnoreCase(ConfigConsts.DB_CHARSET)) {
                            db.setDBCharset(value);
                        } else if (name.equalsIgnoreCase(ConfigConsts.DB_CLIENT_CHARSET)) {
                            db.setClientCharset(value);
                        } else if (name.equalsIgnoreCase(ConfigConsts.DB_TRANS_CONTENT)) {
                            try {
                                boolean needTranContent = Boolean.valueOf(value);
                                db.setNeedTranContent(needTranContent);
                            }
                            catch (Exception ex) {
                                Logger.debug("Invalid property " + ConfigConsts.DB_TRANS_CONTENT + ":" + value + " of " + db.getName() + " DB.");
                            }
                        } else if (name.equalsIgnoreCase(ConfigConsts.DB_TRANS_SENTENCE)) {
                            try {
                                boolean needTranSentence = Boolean.valueOf(value);
                                db.setNeedTranSentence(needTranSentence);
                            }
                            catch (Exception ex) {
                                Logger.debug("Invalid property " + ConfigConsts.DB_TRANS_SENTENCE + ":" + value + " of " + db.getName() + " DB.");
                            }
                        } else if (name.equalsIgnoreCase(ConfigConsts.DB_CASE_SENTENCE)) {
                            try {
                                boolean bcase = Boolean.valueOf(value);
                                ((DBConfig)db).setCaseSentence(bcase);
                            }
                            catch (Exception ex) {
                                Logger.debug("Invalid property " + ConfigConsts.DB_CASE_SENTENCE + ":" + value + " of " + db.getName() + " DB.");
                            }
                        }
                    }
                }
            } else if (qName.equalsIgnoreCase(ConfigConsts.EXTENDED) && (db = this.getActiveDB()) != null) {
                name = attributes.getValue(ConfigConsts.NAME);
                value = attributes.getValue(ConfigConsts.VALUE);
                if (name != null && name.trim().length() > 0 && value != null && value.trim().length() > 0) {
                    String extend = ((DBConfig)db).getExtend();
                    if (extend == null) {
                        extend = "";
                    }
                    if (extend.length() > 0 && !extend.endsWith(";")) {
                        extend = String.valueOf(extend) + ";";
                    }
                    extend = String.valueOf(extend) + name.trim() + "=" + value.trim();
                    ((DBConfig)db).setExtend(extend);
                    Properties props = ((DBConfig)db).getInfo();
                    if (props == null) {
                        props = new Properties();
                        ((DBConfig)db).setInfo(props);
                    }
                    props.put(name.trim(), value.trim());
                }
            }
        } else if (this.activeNode == 3) {
            Xmla xmla;
            if (qName.equalsIgnoreCase(ConfigConsts.XMLA)) {
                xmla = new Xmla();
                xmla.setName(attributes.getValue(ConfigConsts.NAME));
                this.config.getXmlaList().add(xmla);
            } else if (qName.equalsIgnoreCase(ConfigConsts.PROPERTY)) {
                xmla = this.getActiveXmla();
                name = attributes.getValue(ConfigConsts.NAME);
                value = attributes.getValue(ConfigConsts.VALUE);
                if (name != null && name.trim().length() > 0 && value != null && value.trim().length() > 0) {
                    if (name.equalsIgnoreCase(ConfigConsts.XMLA_TYPE)) {
                        xmla.setType(value);
                    } else if (name.equalsIgnoreCase(ConfigConsts.XMLA_URL)) {
                        xmla.setUrl(value);
                    } else if (name.equalsIgnoreCase(ConfigConsts.XMLA_CATALOG)) {
                        xmla.setCatalog(value);
                    } else if (name.equalsIgnoreCase(ConfigConsts.XMLA_USER)) {
                        xmla.setUser(value);
                    } else if (name.equalsIgnoreCase(ConfigConsts.XMLA_PASSWORD)) {
                        xmla.setPassword(value);
                    }
                }
            }
        } else if (this.activeNode == 12) {
            if (qName.equalsIgnoreCase(ConfigConsts.JNDI)) {
                db = new JNDIConfig(0);
                String jndi = attributes.getValue(ConfigConsts.NAME);
                db.setName(jndi);
                this.config.getJNDIList().add((JNDIConfig)db);
            } else if (qName.equalsIgnoreCase(ConfigConsts.PROPERTY) && (db = this.getActiveJNDI()) != null) {
                name = attributes.getValue(ConfigConsts.NAME);
                value = attributes.getValue(ConfigConsts.VALUE);
                if (name != null && name.trim().length() > 0 && value != null && value.trim().length() > 0) {
                    if (name.equalsIgnoreCase(ConfigConsts.DB_TYPE)) {
                        try {
                            db.setDBType(Integer.parseInt(value));
                        }
                        catch (Exception ex) {
                            Logger.info("The " + ConfigConsts.DB_TYPE + " of " + db.getName() + " should be Integer. Can not be: " + value);
                        }
                    } else if (name.equalsIgnoreCase(ConfigConsts.BATCH_SIZE)) {
                        try {
                            db.setBatchSize(Integer.parseInt(value));
                        }
                        catch (Exception ex) {
                            Logger.info("The " + ConfigConsts.BATCH_SIZE + " of " + db.getName() + " should be Integer. Can not be: " + value);
                        }
                    } else if (name.equalsIgnoreCase(ConfigConsts.LOOKUP)) {
                        if (StringUtils.isValidString(value)) {
                            ((JNDIConfig)db).setJNDI(value);
                        }
                    } else if (name.equalsIgnoreCase(ConfigConsts.DB_CHARSET) && StringUtils.isValidString(value)) {
                        db.setDBCharset(value);
                    }
                }
            }
        } else if (this.activeNode == 13) {
            if (qName.equalsIgnoreCase(ConfigConsts.SPRING_DB)) {
                db = new SpringDBConfig(0);
                name = attributes.getValue(ConfigConsts.NAME);
                db.setName(name);
                this.config.getSpringDBList().add((SpringDBConfig)db);
            } else if (qName.equalsIgnoreCase(ConfigConsts.PROPERTY) && (db = this.getActiveSpringDB()) != null) {
                name = attributes.getValue(ConfigConsts.NAME);
                value = attributes.getValue(ConfigConsts.VALUE);
                if (name != null && name.trim().length() > 0 && value != null && value.trim().length() > 0) {
                    if (name.equalsIgnoreCase(ConfigConsts.DB_TYPE)) {
                        try {
                            db.setDBType(Integer.parseInt(value));
                        }
                        catch (Exception ex) {
                            Logger.info("The " + ConfigConsts.DB_TYPE + " of " + db.getName() + " should be Integer. Can not be: " + value);
                        }
                    } else if (name.equalsIgnoreCase(ConfigConsts.SPRING_ID)) {
                        ((SpringDBConfig)db).setId(value);
                    }
                }
            }
        } else if (this.activeNode == 11 && qName.equalsIgnoreCase(ConfigConsts.PROPERTY)) {
            String name2 = attributes.getValue(ConfigConsts.NAME);
            String value2 = attributes.getValue(ConfigConsts.VALUE);
            Properties props = this.config.getServerProperties();
            if (props == null) {
                props = new Properties();
                this.config.setServerProperties(props);
            }
            props.setProperty(name2, value2);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase(ConfigConsts.JNDI_LIST) || qName.equalsIgnoreCase(ConfigConsts.SPRING_DB_LIST)) {
            this.activeNode = (short)11;
            return;
        }
        String value = this.buf.toString();
        if (!StringUtils.isValidString(value)) {
            if (this.activeNode >= 11 && qName.equalsIgnoreCase(ConfigConsts.LOAD)) {
                this.config.setJdbcLoad("");
                this.config.setJdbcNode(true);
            }
            return;
        }
        if (this.activeNode == 4) {
            RemoteStoreConfig rs;
            if (qName.equalsIgnoreCase(ConfigConsts.CHAR_SET)) {
                this.config.setCharSet(value);
            } else if (qName.equalsIgnoreCase("dfxPath")) {
                if (this.version < 3) {
                    this.config.getSplPathList().add(value);
                }
            } else if (qName.equalsIgnoreCase(ConfigConsts.SPL_PATH)) {
                this.config.getSplPathList().add(value);
            } else if (qName.equalsIgnoreCase(ConfigConsts.DATE_FORMAT)) {
                this.config.setDateFormat(value);
            } else if (qName.equalsIgnoreCase(ConfigConsts.TIME_FORMAT)) {
                this.config.setTimeFormat(value);
            } else if (qName.equalsIgnoreCase(ConfigConsts.DATE_TIME_FORMAT)) {
                this.config.setDateTimeFormat(value);
            } else if (qName.equalsIgnoreCase(ConfigConsts.MAIN_PATH)) {
                this.config.setMainPath(value);
            } else if (qName.equalsIgnoreCase(ConfigConsts.TEMP_PATH)) {
                this.config.setTempPath(value);
            } else if (qName.equalsIgnoreCase(ConfigConsts.BUF_SIZE)) {
                this.config.setBufSize(value);
            } else if (qName.equalsIgnoreCase(ConfigConsts.BLOCK_SIZE) || qName.equalsIgnoreCase("simpleTableBlockSize")) {
                this.config.setBlockSize(value);
            } else if (qName.equalsIgnoreCase("logLevel")) {
                if (this.version < 2 && this.config.getLogLevel() == null) {
                    this.config.setLogLevel(value);
                }
            } else if (qName.equalsIgnoreCase(ConfigConsts.PARALLEL_NUM)) {
                if (StringUtils.isValidString(value)) {
                    this.config.setParallelNum(value);
                    if (this.version < 2) {
                        this.config.setCursorParallelNum(value);
                    }
                }
            } else if (qName.equalsIgnoreCase(ConfigConsts.CURSOR_PARALLEL_NUM)) {
                if (StringUtils.isValidString(value)) {
                    this.config.setCursorParallelNum(value);
                }
            } else if (qName.equalsIgnoreCase(ConfigConsts.NULL_STRINGS)) {
                this.config.setNullStrings(value);
            } else if (qName.equalsIgnoreCase(ConfigConsts.FETCH_COUNT)) {
                this.config.setFetchCount(value);
            } else if (qName.equalsIgnoreCase(ConfigConsts.EXTLIBS)) {
                this.config.setExtLibsPath(value);
            } else if (qName.equalsIgnoreCase(ConfigConsts.LIB)) {
                List<String> importLibs = this.config.getImportLibs();
                if (importLibs == null) {
                    importLibs = new ArrayList<String>();
                    this.config.setImportLibs(importLibs);
                }
                importLibs.add(value);
            } else if (qName.equalsIgnoreCase(ConfigConsts.CUSTOM_FUNCTION_FILE)) {
                this.config.setCustomFunctionFile(value);
            } else if (qName.equalsIgnoreCase(ConfigConsts.SERIAL_NO)) {
                this.config.setEsprocSerialNo(value);
            } else if (qName.equalsIgnoreCase(ConfigConsts.REMOTE_STORE) && (rs = this.getActiveRemoteStoreConfig()) != null) {
                rs.setOption(value);
            }
        } else if (this.activeNode == 8) {
            if (qName.equalsIgnoreCase(ConfigConsts.LEVEL)) {
                this.config.setLogLevel(value);
            } else if (qName.equalsIgnoreCase(ConfigConsts.LOG_TYPE)) {
                value = this.getValidLogType(value);
                this.config.setLogType(value);
            }
        } else if (this.activeNode == 10) {
            if (this.version < 3 && qName.equalsIgnoreCase("dfx") && this.config.getInitSpl() == null) {
                this.config.setInitSpl(value);
            }
            if (qName.equalsIgnoreCase(ConfigConsts.SPL)) {
                this.config.setInitSpl(value);
            }
        } else if (this.activeNode >= 11) {
            if (qName.equalsIgnoreCase(ConfigConsts.DEF_DATA_SOURCE)) {
                this.config.setDefDataSource(value);
            } else if (qName.equalsIgnoreCase(ConfigConsts.LOAD)) {
                this.config.setJdbcLoad(value);
            } else if (qName.equalsIgnoreCase(ConfigConsts.GATEWAY)) {
                this.config.setGateway(value);
            } else if (qName.equalsIgnoreCase(ConfigConsts.UNIT)) {
                List<String> unitList = this.config.getUnitList();
                if (unitList == null) {
                    unitList = new ArrayList<String>();
                    this.config.setUnitList(unitList);
                }
                unitList.add(value);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.buf.append(ch, start, length);
    }

    protected DBConfig getActiveDB() {
        List<DBConfig> dbList = this.config.getDBList();
        if (dbList == null || dbList.isEmpty()) {
            return null;
        }
        return dbList.get(dbList.size() - 1);
    }

    protected Xmla getActiveXmla() {
        List<Xmla> xmlaList = this.config.getXmlaList();
        if (xmlaList == null || xmlaList.isEmpty()) {
            return null;
        }
        return xmlaList.get(xmlaList.size() - 1);
    }

    protected JNDIConfig getActiveJNDI() {
        List<JNDIConfig> dbList = this.config.getJNDIList();
        if (dbList == null || dbList.isEmpty()) {
            return null;
        }
        return dbList.get(dbList.size() - 1);
    }

    protected SpringDBConfig getActiveSpringDB() {
        List<SpringDBConfig> dbList = this.config.getSpringDBList();
        if (dbList == null || dbList.isEmpty()) {
            return null;
        }
        return dbList.get(dbList.size() - 1);
    }

    protected RemoteStoreConfig getActiveRemoteStoreConfig() {
        List<RemoteStoreConfig> rsList = this.config.getRemoteStoreList();
        if (rsList == null || rsList.isEmpty()) {
            return null;
        }
        return rsList.get(rsList.size() - 1);
    }

    private String getValidLogType(String typeStr) {
        if (typeStr != null && "slf4j".equalsIgnoreCase(typeStr)) {
            return "slf4j";
        }
        return "default";
    }
}

