/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.app.config;

import com.scudata.app.common.Segment;
import com.scudata.app.config.ConfigConsts;
import com.scudata.app.config.RaqsoftConfig;
import com.scudata.app.config.RemoteStoreConfig;
import com.scudata.app.config.Xmla;
import com.scudata.common.DBConfig;
import com.scudata.common.JNDIConfig;
import com.scudata.common.PwdUtils;
import com.scudata.common.SpringDBConfig;
import com.scudata.common.StringUtils;
import com.scudata.parallel.UnitConfig;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ConfigWriter {
    protected TransformerHandler handler = null;
    protected String version = "3";
    protected int level = 0;
    protected final String tab = "    ";
    protected final String separator = System.getProperties().getProperty("os.name").toUpperCase().indexOf("WINDOWS") != -1 ? "\n" : System.getProperties().getProperty("line.separator");

    public ConfigWriter() {
        try {
            SAXTransformerFactory fac = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            this.handler = fac.newTransformerHandler();
            Transformer transformer = this.handler.getTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "no");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void startElement(String objectElement, AttributesImpl attrs) throws SAXException {
        if (attrs == null) {
            attrs = new AttributesImpl();
        }
        this.appendTab();
        if (objectElement != null) {
            this.handler.startElement("", "", objectElement, attrs);
        }
    }

    protected void endElement(String objectElement) throws SAXException {
        this.appendTab();
        if (objectElement != null) {
            this.handler.endElement("", "", objectElement);
        }
    }

    protected void endEmptyElement(String objectElement) throws SAXException {
        this.handler.endElement("", "", objectElement);
    }

    protected void writeAttribute(String key, String value) throws SAXException {
        if (value == null) {
            value = "";
        }
        this.appendTab();
        this.handler.startElement("", "", key, new AttributesImpl());
        this.handler.characters(value.toCharArray(), 0, value.length());
        this.handler.endElement("", "", key);
    }

    private void appendTab() throws SAXException {
        StringBuffer sb = new StringBuffer(this.separator);
        int i = 0;
        while (i < this.level) {
            sb.append("    ");
            ++i;
        }
        String indent = sb.toString();
        this.handler.characters(indent.toCharArray(), 0, indent.length());
    }

    public void write(OutputStream out, RaqsoftConfig config) throws Exception {
        StreamResult resultxml = new StreamResult(out);
        this.handler.setResult(resultxml);
        this.level = 0;
        this.handler.startDocument();
        this.handler.startElement("", "", ConfigConsts.CONFIG, this.getAttributesImpl(new String[]{ConfigConsts.VERSION, this.version}));
        this.writeRuntime(config);
        this.writeInit(config);
        this.writeServer(config);
        this.writeJDBC(config);
        this.handler.endElement("", "", ConfigConsts.CONFIG);
        this.handler.endDocument();
    }

    protected void writeRuntime(RaqsoftConfig config) throws SAXException {
        this.level = 1;
        this.startElement(ConfigConsts.RUNTIME, null);
        this.writeDBList(config);
        this.writeXmlaList(config);
        this.writeRuntimeEsproc(config);
        this.writeLogger(config);
        this.level = 1;
        this.endElement(ConfigConsts.RUNTIME);
    }

    protected void writeDBList(RaqsoftConfig config) throws SAXException {
        List<DBConfig> dbList = config.getDBList();
        List<String> autoConnectedList = config.getAutoConnectList();
        this.level = 2;
        this.startElement(ConfigConsts.DB_LIST, this.getAttributesImpl(new String[]{ConfigConsts.ENCRYPT_LEVEL, String.valueOf(config.getEncryptLevel()), ConfigConsts.PWD_CLASS, config.getPwdClass()}));
        if (dbList != null) {
            byte encryptLevel = config.getEncryptLevel();
            int i = 0;
            int size = dbList.size();
            while (i < size) {
                DBConfig dbConfig = dbList.get(i);
                this.level = 3;
                this.startElement(ConfigConsts.DB, this.getAttributesImpl(new String[]{ConfigConsts.NAME, dbConfig.getName()}));
                this.level = 4;
                String url = dbConfig.getUrl();
                if (encryptLevel == 2) {
                    url = PwdUtils.encrypt(url);
                }
                this.writeNameValueElement(ConfigConsts.DB_URL, url);
                this.writeNameValueElement(ConfigConsts.DB_DRIVER, dbConfig.getDriver());
                this.writeNameValueElement(ConfigConsts.DB_TYPE, String.valueOf(dbConfig.getDBType()));
                String user = dbConfig.getUser();
                if (encryptLevel == 2) {
                    user = PwdUtils.encrypt(user);
                }
                this.writeNameValueElement(ConfigConsts.DB_USER, user);
                String pwd = dbConfig.getPassword();
                if (encryptLevel == 1 || encryptLevel == 2) {
                    pwd = PwdUtils.encrypt(pwd);
                }
                this.writeNameValueElement(ConfigConsts.DB_PASSWORD, pwd);
                this.writeNameValueElement(ConfigConsts.DB_BATCH_SIZE, String.valueOf(dbConfig.getBatchSize()));
                this.writeNameValueElement(ConfigConsts.DB_AUTO_CONNECT, String.valueOf(autoConnectedList != null && autoConnectedList.contains(dbConfig.getName())));
                this.writeNameValueElement(ConfigConsts.DB_USE_SCHEMA, String.valueOf(dbConfig.isUseSchema()));
                this.writeNameValueElement(ConfigConsts.DB_ADD_TILDE, String.valueOf(dbConfig.isAddTilde()));
                String extend = dbConfig.getExtend();
                if (extend != null && extend.trim().length() > 0) {
                    Segment s = new Segment(extend);
                    for (String key : s.keySet()) {
                        String value = s.get(key);
                        this.writeExtendedDBElement(key, value);
                    }
                }
                boolean needTrans = false;
                if (StringUtils.isValidString(dbConfig.getDBCharset())) {
                    needTrans = true;
                    this.writeNameValueElement(ConfigConsts.DB_CHARSET, dbConfig.getDBCharset());
                }
                if (StringUtils.isValidString(dbConfig.getClientCharset())) {
                    needTrans = true;
                    this.writeNameValueElement(ConfigConsts.DB_CLIENT_CHARSET, dbConfig.getClientCharset());
                }
                if (needTrans || dbConfig.getNeedTranContent() || dbConfig.getNeedTranSentence()) {
                    this.writeNameValueElement(ConfigConsts.DB_TRANS_CONTENT, String.valueOf(dbConfig.getNeedTranContent()));
                    this.writeNameValueElement(ConfigConsts.DB_TRANS_SENTENCE, String.valueOf(dbConfig.getNeedTranSentence()));
                }
                this.writeNameValueElement(ConfigConsts.DB_CASE_SENTENCE, String.valueOf(dbConfig.isCaseSentence()));
                this.level = 3;
                this.endElement(ConfigConsts.DB);
                ++i;
            }
            this.level = 2;
            this.endElement(ConfigConsts.DB_LIST);
        } else {
            this.endEmptyElement(ConfigConsts.DB_LIST);
        }
    }

    protected void writeXmlaList(RaqsoftConfig config) throws SAXException {
        List<Xmla> xmlaList = config.getXmlaList();
        if (xmlaList == null || xmlaList.isEmpty()) {
            return;
        }
        this.level = 2;
        this.startElement(ConfigConsts.XMLA_LIST, null);
        int i = 0;
        int size = xmlaList.size();
        while (i < size) {
            Xmla xmla = xmlaList.get(i);
            this.level = 3;
            this.startElement(ConfigConsts.XMLA, this.getAttributesImpl(new String[]{ConfigConsts.NAME, xmla.getName()}));
            this.level = 4;
            this.writeNameValueElement(ConfigConsts.XMLA_TYPE, xmla.getType());
            this.writeNameValueElement(ConfigConsts.XMLA_URL, xmla.getUrl());
            this.writeNameValueElement(ConfigConsts.XMLA_CATALOG, xmla.getCatalog());
            this.writeNameValueElement(ConfigConsts.XMLA_USER, xmla.getUser());
            this.writeNameValueElement(ConfigConsts.XMLA_PASSWORD, xmla.getPassword());
            this.level = 3;
            this.endElement(ConfigConsts.XMLA);
            ++i;
        }
        this.level = 2;
        this.endElement(ConfigConsts.XMLA_LIST);
    }

    protected void writeRuntimeEsproc(RaqsoftConfig config) throws SAXException {
        this.level = 2;
        this.startElement(ConfigConsts.ESPROC, null);
        this.level = 3;
        this.writeAttribute(ConfigConsts.CHAR_SET, config.getCharSet());
        List<String> paths = config.getSplPathList();
        if (paths != null && !paths.isEmpty()) {
            this.startElement(ConfigConsts.SPL_PATH_LIST, null);
            this.level = 4;
            int i = 0;
            while (i < paths.size()) {
                this.writeAttribute(ConfigConsts.SPL_PATH, paths.get(i));
                ++i;
            }
            this.level = 3;
            this.endElement(ConfigConsts.SPL_PATH_LIST);
        }
        this.writeAttribute(ConfigConsts.DATE_FORMAT, config.getDateFormat());
        this.writeAttribute(ConfigConsts.TIME_FORMAT, config.getTimeFormat());
        this.writeAttribute(ConfigConsts.DATE_TIME_FORMAT, config.getDateTimeFormat());
        this.writeAttribute(ConfigConsts.MAIN_PATH, config.getMainPath());
        this.writeAttribute(ConfigConsts.TEMP_PATH, config.getTempPath());
        this.writeAttribute(ConfigConsts.BUF_SIZE, config.getBufSize());
        this.writeAttribute(ConfigConsts.PARALLEL_NUM, config.getParallelNum());
        this.writeAttribute(ConfigConsts.CURSOR_PARALLEL_NUM, config.getCursorParallelNum());
        this.writeAttribute(ConfigConsts.BLOCK_SIZE, config.getBlockSize());
        this.writeAttribute(ConfigConsts.NULL_STRINGS, config.getNullStrings());
        this.writeAttribute(ConfigConsts.FETCH_COUNT, config.getFetchCount());
        this.writeAttribute(ConfigConsts.EXTLIBS, config.getExtLibsPath());
        this.writeImportLibList(config.getImportLibs());
        this.writeAttribute(ConfigConsts.CUSTOM_FUNCTION_FILE, config.getCustomFunctionFile());
        this.writeAttribute(ConfigConsts.SERIAL_NO, config.getEsprocSerialNo());
        this.writeRemoteStoreList(config);
        this.level = 2;
        this.endElement(ConfigConsts.ESPROC);
    }

    protected void writeRemoteStoreList(RaqsoftConfig config) throws SAXException {
        List<RemoteStoreConfig> list = config.getRemoteStoreList();
        if (list == null || list.isEmpty()) {
            return;
        }
        this.level = 3;
        this.startElement(ConfigConsts.REMOTE_STORES, this.getAttributesImpl(new String[]{ConfigConsts.DEFAULT, config.getDefaultRemoteStore()}));
        for (RemoteStoreConfig rs : list) {
            this.level = 4;
            this.startElement(ConfigConsts.REMOTE_STORE, this.getAttributesImpl(new String[]{ConfigConsts.NAME, rs.getName(), ConfigConsts.TYPE, rs.getType(), ConfigConsts.CACHE_PATH, rs.getCachePath(), ConfigConsts.MIN_FREE_SPACE, String.valueOf(rs.getMinFreeSpace()), ConfigConsts.BLOCK_BUFFER_SIZE, String.valueOf(rs.getBlockBufferSize())}));
            String option = rs.getOption();
            if (option != null) {
                option = option.trim();
                StringBuffer sb = new StringBuffer(this.separator);
                int i = 0;
                while (i < this.level + 1) {
                    sb.append("    ");
                    ++i;
                }
                sb.append(option);
                String optionOut = sb.toString();
                this.handler.characters(optionOut.toCharArray(), 0, optionOut.length());
            }
            this.appendTab();
            this.endEmptyElement(ConfigConsts.REMOTE_STORE);
        }
        this.level = 3;
        this.endElement(ConfigConsts.REMOTE_STORES);
    }

    protected void writeImportLibList(List<String> importLibs) throws SAXException {
        if (importLibs == null || importLibs.isEmpty()) {
            return;
        }
        this.level = 3;
        this.startElement(ConfigConsts.IMPORT_LIBS, null);
        this.level = 4;
        int i = 0;
        int size = importLibs.size();
        while (i < size) {
            this.writeAttribute(ConfigConsts.LIB, importLibs.get(i));
            ++i;
        }
        this.level = 3;
        this.endElement(ConfigConsts.IMPORT_LIBS);
    }

    protected void writeLogger(RaqsoftConfig config) throws SAXException {
        this.level = 2;
        this.startElement(ConfigConsts.LOGGER, null);
        this.level = 3;
        this.writeAttribute(ConfigConsts.LEVEL, config.getLogLevel());
        this.writeAttribute(ConfigConsts.LOG_TYPE, config.getLogType());
        this.level = 2;
        this.endElement(ConfigConsts.LOGGER);
    }

    protected void writeServer(RaqsoftConfig config) throws SAXException {
        String defDataSource = config.getDefDataSource();
        if (!(StringUtils.isValidString(defDataSource) || config.getJNDIList() != null && !config.getJNDIList().isEmpty() || config.getSpringDBList() != null && !config.getSpringDBList().isEmpty() || config.getServerProperties() != null && !config.getServerProperties().isEmpty())) {
            return;
        }
        this.level = 1;
        this.startElement(ConfigConsts.SERVER, null);
        this.level = 2;
        if (StringUtils.isValidString(defDataSource)) {
            this.writeAttribute(ConfigConsts.DEF_DATA_SOURCE, config.getDefDataSource());
        }
        this.writeJNDIList(config.getJNDIList());
        this.writeSpringDBList(config.getSpringDBList());
        this.writeServerProperties(config.getServerProperties());
        this.level = 1;
        this.endElement(ConfigConsts.SERVER);
    }

    private void writeJNDIList(List<JNDIConfig> jndiList) throws SAXException {
        if (jndiList == null || jndiList.isEmpty()) {
            return;
        }
        this.level = 2;
        this.startElement(ConfigConsts.JNDI_LIST, null);
        for (JNDIConfig config : jndiList) {
            this.writeJNDIConfig(config);
        }
        this.level = 2;
        this.endElement(ConfigConsts.JNDI_LIST);
    }

    private void writeJNDIConfig(JNDIConfig config) throws SAXException {
        if (config == null) {
            return;
        }
        this.level = 3;
        this.startElement(ConfigConsts.JNDI, this.getAttributesImpl(new String[]{ConfigConsts.NAME, config.getName()}));
        this.writeNameValueElement(ConfigConsts.DB_TYPE, String.valueOf(config.getDBType()));
        this.writeNameValueElement(ConfigConsts.BATCH_SIZE, String.valueOf(config.getBatchSize()));
        this.writeNameValueElement(ConfigConsts.LOOKUP, config.getJNDI());
        if (StringUtils.isValidString(config.getDBCharset())) {
            this.writeNameValueElement(ConfigConsts.DB_CHARSET, config.getDBCharset());
        }
        this.endElement(ConfigConsts.JNDI);
    }

    private void writeSpringDBList(List<SpringDBConfig> springDBList) throws SAXException {
        if (springDBList == null || springDBList.isEmpty()) {
            return;
        }
        this.level = 2;
        this.startElement(ConfigConsts.SPRING_DB_LIST, null);
        for (SpringDBConfig config : springDBList) {
            this.writeSpringDBConfig(config);
        }
        this.level = 2;
        this.endElement(ConfigConsts.SPRING_DB_LIST);
    }

    private void writeSpringDBConfig(SpringDBConfig config) throws SAXException {
        if (config == null) {
            return;
        }
        this.level = 3;
        this.startElement(ConfigConsts.SPRING_DB, this.getAttributesImpl(new String[]{ConfigConsts.NAME, config.getName()}));
        this.writeNameValueElement(ConfigConsts.SPRING_ID, config.getId());
        this.writeNameValueElement(ConfigConsts.DB_TYPE, String.valueOf(config.getDBType()));
        this.endElement(ConfigConsts.SPRING_DB);
    }

    private void writeServerProperties(Properties props) throws SAXException {
        if (props == null || props.isEmpty()) {
            return;
        }
        this.level = 2;
        Iterator<Object> it = props.keySet().iterator();
        while (it.hasNext()) {
            String key;
            String value = props.getProperty(key = (String)it.next());
            this.writeNameValueElement(key, value == null ? "" : value.toString());
        }
    }

    protected void writeNameValueElement(String name, String value) throws SAXException {
        this.writeNameValueElement(ConfigConsts.PROPERTY, name, value);
    }

    protected void writeExtendedDBElement(String name, String value) throws SAXException {
        this.writeNameValueElement(ConfigConsts.EXTENDED, name, value);
    }

    protected void writeNameValueElement(String elementName, String name, String value) throws SAXException {
        this.startElement(elementName, this.getAttributesImpl(new String[]{ConfigConsts.NAME, name, ConfigConsts.VALUE, value}));
        this.endEmptyElement(elementName);
    }

    protected void writeInit(RaqsoftConfig config) throws SAXException {
        if (!StringUtils.isValidString(config.getInitSpl())) {
            return;
        }
        this.level = 1;
        this.startElement(ConfigConsts.INIT, null);
        this.level = 2;
        this.writeAttribute(ConfigConsts.SPL, config.getInitSpl());
        this.level = 1;
        this.endElement(ConfigConsts.INIT);
    }

    protected void writeJDBC(RaqsoftConfig config) throws SAXException {
        boolean hasUnit;
        boolean hasLoad = !new RaqsoftConfig().getJdbcLoad().equals(config.getJdbcLoad());
        boolean hasGateway = StringUtils.isValidString(config.getGateway());
        boolean bl = hasUnit = config.getUnitList() != null && !config.getUnitList().isEmpty();
        if (!(config.isJdbcNode() || hasGateway || hasUnit)) {
            return;
        }
        this.level = 1;
        this.startElement(ConfigConsts.JDBC, null);
        this.level = 2;
        if (hasLoad) {
            this.writeAttribute(ConfigConsts.LOAD, config.getJdbcLoad());
        }
        if (hasGateway) {
            this.writeAttribute(ConfigConsts.GATEWAY, config.getGateway());
        }
        this.writeUnitList(config.getUnitList());
        this.level = 1;
        this.endElement(ConfigConsts.JDBC);
    }

    private void writeUnitList(List<String> unitList) throws SAXException {
        if (unitList == null || unitList.isEmpty()) {
            return;
        }
        this.level = 2;
        this.startElement(ConfigConsts.UNITS, null);
        this.level = 3;
        for (String unit : unitList) {
            if (!StringUtils.isValidString(unit)) continue;
            this.writeAttribute(ConfigConsts.UNIT, unit);
        }
        this.level = 2;
        this.endElement(ConfigConsts.UNITS);
    }

    protected AttributesImpl getAttributesImpl(String[] attrs) {
        AttributesImpl attrImpl = new AttributesImpl();
        int size = attrs.length;
        int i = 0;
        while (i < size) {
            if (attrs[i + 1] != null) {
                attrImpl.addAttribute("", "", attrs[i], String.class.getName(), String.valueOf(attrs[i + 1]));
            }
            i += 2;
        }
        return attrImpl;
    }

    public void writeUnitConfig(String filePath, UnitConfig config) throws SAXException, IOException {
        FileOutputStream fos = null;
        FilterOutputStream bos = null;
        try {
            fos = new FileOutputStream(filePath);
            bos = new BufferedOutputStream(fos);
            this.writeUnitConfig(bos, config);
            ((BufferedOutputStream)bos).flush();
        }
        finally {
            if (fos != null) {
                fos.close();
            }
            if (bos != null) {
                bos.close();
            }
        }
    }

    public void writeUnitConfig(OutputStream out, UnitConfig config) throws SAXException {
        StreamResult resultxml = new StreamResult(out);
        this.handler.setResult(resultxml);
        this.level = 0;
        this.handler.startDocument();
        this.handler.startElement("", "", "SERVER", this.getAttributesImpl(new String[]{ConfigConsts.VERSION, "1"}));
        this.level = 1;
        this.writeAttribute("TempTimeOut", String.valueOf(config.getTempTimeOut()));
        this.writeAttribute("Interval", String.valueOf(config.getInterval()));
        this.writeAttribute("ProxyTimeOut", String.valueOf(config.getProxyTimeOut()));
        this.handler.endElement("", "", "SERVER");
        this.handler.endDocument();
    }
}

