/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.array;

import com.scudata.array.ArrayUtil;
import com.scudata.array.BoolArray;
import com.scudata.array.ConstArray;
import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.array.ObjectArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.expression.Relation;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Comparator;

public class ByteBufferArray
implements IArray {
    private static final long serialVersionUID = 1L;
    private byte[] buffer;
    private int[] pos;
    private byte[] len;
    private int size;

    public ByteBufferArray(byte[] buffer, int[] pos, byte[] len, int size) {
        this.buffer = buffer;
        this.pos = pos;
        this.len = len;
        this.size = size;
    }

    public ByteBufferArray(byte[] buffer, int initialCapacity) {
        this.pos = new int[++initialCapacity];
        this.len = new byte[initialCapacity];
        this.buffer = buffer;
    }

    private static int compareArrays(byte[] b1, int pos1, int len1, byte[] b2) {
        int len2 = b2.length;
        if (len1 == len2) {
            int i = 0;
            while (i < len1) {
                if (b1[i + pos1] < b2[i]) {
                    return -1;
                }
                if (b1[i + pos1] > b2[i]) {
                    return 1;
                }
                ++i;
            }
            return 0;
        }
        if (len1 < len2) {
            int i = 0;
            while (i < len1) {
                if (b1[i + pos1] < b2[i]) {
                    return -1;
                }
                if (b1[i + pos1] > b2[i]) {
                    return 1;
                }
                ++i;
            }
            return -1;
        }
        int i = 0;
        while (i < len2) {
            if (b1[i + pos1] < b2[i]) {
                return -1;
            }
            if (b1[i + pos1] > b2[i]) {
                return 1;
            }
            ++i;
        }
        return 1;
    }

    public static int compare(byte[] d1, int pos1, int len1, byte[] d2) {
        if (pos1 == -1) {
            return d2 == null ? 0 : -1;
        }
        if (d2 == null) {
            return 1;
        }
        int cmp = ByteBufferArray.compareArrays(d1, pos1, len1, d2);
        return cmp < 0 ? -1 : (cmp > 0 ? 1 : 0);
    }

    private static int compare(byte[] d1, int pos1, int len1, Object d2) {
        if (d2 instanceof byte[]) {
            if (d1 == null) {
                return -1;
            }
            int cmp = ByteBufferArray.compareArrays(d1, pos1, len1, (byte[])d2);
            return cmp < 0 ? -1 : (cmp > 0 ? 1 : 0);
        }
        if (d2 == null) {
            return d1 == null ? 0 : 1;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("Variant2.illCompare", d1, d2, mm.getMessage("DataType.String"), Variant.getDataType(d2)));
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    @Override
    public String getDataType() {
        throw new RuntimeException();
    }

    @Override
    public IArray dup() {
        throw new RuntimeException();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        throw new RuntimeException();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        throw new RuntimeException();
    }

    @Override
    public byte[] serialize() throws IOException {
        throw new RuntimeException();
    }

    @Override
    public void fillRecord(byte[] buf) throws IOException, ClassNotFoundException {
        throw new RuntimeException();
    }

    @Override
    public IArray newInstance(int count) {
        throw new RuntimeException();
    }

    @Override
    public void add(Object o) {
        throw new RuntimeException();
    }

    @Override
    public void addAll(IArray array) {
        throw new RuntimeException();
    }

    @Override
    public void addAll(IArray array, int count) {
        throw new RuntimeException();
    }

    @Override
    public void addAll(IArray array, int index, int count) {
        throw new RuntimeException();
    }

    @Override
    public void addAll(Object[] array) {
        throw new RuntimeException();
    }

    @Override
    public void insert(int index, Object o) {
        throw new RuntimeException();
    }

    @Override
    public void insertAll(int pos, IArray array) {
        throw new RuntimeException();
    }

    @Override
    public void insertAll(int pos, Object[] array) {
        throw new RuntimeException();
    }

    public void push(byte[] str) {
        throw new RuntimeException();
    }

    public void pushString(byte[] str) {
        throw new RuntimeException();
    }

    @Override
    public void push(Object o) {
        throw new RuntimeException();
    }

    @Override
    public void pushNull() {
        throw new RuntimeException();
    }

    @Override
    public void push(IArray array, int index) {
        throw new RuntimeException();
    }

    @Override
    public void add(IArray array, int index) {
        throw new RuntimeException();
    }

    @Override
    public void set(int curIndex, IArray array, int index) {
        throw new RuntimeException();
    }

    @Override
    public Object get(int index) {
        return new String(this.buffer, this.pos[index], (int)this.len[index]);
    }

    @Override
    public int getInt(int index) {
        throw new RuntimeException();
    }

    @Override
    public long getLong(int index) {
        throw new RuntimeException();
    }

    @Override
    public IArray get(int[] indexArray) {
        throw new RuntimeException();
    }

    @Override
    public IArray get(int[] indexArray, int start, int end, boolean doCheck) {
        throw new RuntimeException();
    }

    @Override
    public IArray get(IArray indexArray) {
        throw new RuntimeException();
    }

    @Override
    public IArray get(int start, int end) {
        throw new RuntimeException();
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        throw new RuntimeException();
    }

    @Override
    public void trimToSize() {
        throw new RuntimeException();
    }

    @Override
    public boolean isNull(int index) {
        return this.pos[index] == -1;
    }

    @Override
    public BoolArray isTrue() {
        int size = this.size;
        int[] pos = this.pos;
        boolean[] resultDatas = new boolean[size + 1];
        int i = 1;
        while (i <= size) {
            resultDatas[i] = pos[i] >= 0;
            ++i;
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    @Override
    public BoolArray isFalse() {
        int size = this.size;
        int[] pos = this.pos;
        boolean[] resultDatas = new boolean[size + 1];
        int i = 1;
        while (i <= size) {
            resultDatas[i] = pos[i] < 0;
            ++i;
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    @Override
    public boolean isTrue(int index) {
        return this.pos[index] != -1;
    }

    @Override
    public boolean isFalse(int index) {
        return this.pos[index] == -1;
    }

    @Override
    public boolean isTemporary() {
        return false;
    }

    @Override
    public void setTemporary(boolean ifTemporary) {
    }

    @Override
    public void removeLast() {
        throw new RuntimeException();
    }

    @Override
    public void remove(int index) {
        throw new RuntimeException();
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        throw new RuntimeException();
    }

    @Override
    public void remove(int[] seqs) {
        throw new RuntimeException();
    }

    @Override
    public void reserve(int start, int end) {
        throw new RuntimeException();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int count() {
        int size;
        int[] pos = this.pos;
        int count = size = this.size;
        int i = 1;
        while (i <= size) {
            if (pos[i] == -1) {
                --count;
            }
            ++i;
        }
        return count;
    }

    @Override
    public boolean containTrue() {
        int size = this.size;
        if (size == 0) {
            return false;
        }
        int[] pos = this.pos;
        int i = 1;
        while (i <= size) {
            if (pos[i] != -1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public Object ifn() {
        throw new RuntimeException();
    }

    @Override
    public void set(int index, Object obj) {
        throw new RuntimeException();
    }

    @Override
    public void clear() {
        throw new RuntimeException();
    }

    @Override
    public int binarySearch(Object elem) {
        if (elem instanceof String) {
            byte[] v = ((String)elem).getBytes();
            byte[] buf = this.buffer;
            int[] pos = this.pos;
            byte[] len = this.len;
            int low = 1;
            int high = this.size;
            while (low <= high) {
                int mid = low + high >> 1;
                int cmp = ByteBufferArray.compare(buf, pos[mid], (int)len[mid], v);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return -low;
        }
        if (elem == null) {
            if (this.size > 0 && this.pos[1] == -1) {
                return 1;
            }
            return -1;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("Variant2.illCompare"));
    }

    @Override
    public int binarySearch(Object elem, int start, int end) {
        if (elem instanceof String) {
            byte[] v = ((String)elem).getBytes();
            byte[] buffer = this.buffer;
            int[] pos = this.pos;
            byte[] len = this.len;
            int low = start;
            int high = end;
            while (low <= high) {
                int mid = low + high >> 1;
                int cmp = ByteBufferArray.compare(buffer, pos[mid], (int)len[mid], v);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return -low;
        }
        if (elem == null) {
            if (end > 0 && this.pos[start] == -1) {
                return start;
            }
            return -1;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("Variant2.illCompare"));
    }

    @Override
    public boolean contains(Object elem) {
        if (elem instanceof String) {
            byte[] v = ((String)elem).getBytes();
            byte[] buffer = this.buffer;
            int[] pos = this.pos;
            byte[] len = this.len;
            int size = this.size;
            int i = 1;
            while (i <= size) {
                if (pos[i] != -1 && ByteBufferArray.compare(buffer, pos[i], (int)len[i], v) == 0) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (elem == null) {
            int size = this.size;
            int[] pos = this.pos;
            int i = 1;
            while (i <= size) {
                if (pos[i] == -1) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return false;
    }

    @Override
    public void contains(boolean isSorted, IArray array, BoolArray result) {
        int resultSize = result.size();
        if (isSorted) {
            int i = 1;
            while (i <= resultSize) {
                if (result.isTrue(i) && this.binarySearch(array.get(i)) < 1) {
                    result.set(i, false);
                }
                ++i;
            }
        } else {
            int i = 1;
            while (i <= resultSize) {
                if (result.isTrue(i) && !this.contains(array.get(i))) {
                    result.set(i, false);
                }
                ++i;
            }
        }
    }

    @Override
    public boolean objectContains(Object elem) {
        throw new RuntimeException();
    }

    @Override
    public int firstIndexOf(Object elem, int start) {
        throw new RuntimeException();
    }

    @Override
    public int lastIndexOf(Object elem, int start) {
        throw new RuntimeException();
    }

    @Override
    public IntArray indexOfAll(Object elem, int start, boolean isSorted, boolean isFromHead) {
        throw new RuntimeException();
    }

    @Override
    public IArray abs() {
        MessageManager mm = EngineMessage.get();
        throw new RuntimeException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.illAbs"));
    }

    @Override
    public IArray negate() {
        throw new RuntimeException();
    }

    @Override
    public IArray not() {
        int[] pos = this.pos;
        int size = this.size;
        boolean[] newDatas = new boolean[size + 1];
        int i = 1;
        while (i <= size) {
            newDatas[i] = pos[i] == -1;
            ++i;
        }
        BoolArray result = new BoolArray(newDatas, size);
        result.setTemporary(true);
        return result;
    }

    @Override
    public boolean isNumberArray() {
        return false;
    }

    @Override
    public IArray memberAdd(IArray array) {
        throw new RuntimeException();
    }

    @Override
    public IArray memberAdd(Object value) {
        throw new RuntimeException();
    }

    @Override
    public IArray memberSubtract(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illSubtract"));
    }

    @Override
    public IArray memberMultiply(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMultiply"));
    }

    @Override
    public IArray memberMultiply(Object value) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + Variant.getDataType(value) + mm.getMessage("Variant2.illMultiply"));
    }

    @Override
    public IArray memberDivide(IArray array) {
        throw new RuntimeException();
    }

    @Override
    public IArray memberMod(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMod"));
    }

    @Override
    public IArray memberIntDivide(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illDivide"));
    }

    @Override
    public BoolArray calcRelation(IArray array, int relation) {
        if (array instanceof ConstArray) {
            return this.calcRelation(array.get(1), relation);
        }
        return array.calcRelation(this, Relation.getInverseRelation(relation));
    }

    @Override
    public BoolArray calcRelation(Object value, int relation) {
        if (value instanceof String) {
            return this.calcRelation(((String)value).getBytes(), relation);
        }
        if (value == null) {
            return ByteBufferArray.calcRelationNull(this.pos, this.size, relation);
        }
        boolean b = Variant.isTrue(value);
        int size = this.size;
        int[] pos = this.pos;
        if (relation == 7) {
            BoolArray result;
            if (!b) {
                result = new BoolArray(false, size);
            } else {
                boolean[] resultDatas = new boolean[size + 1];
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = pos[i] != -1;
                    ++i;
                }
                result = new BoolArray(resultDatas, size);
            }
            result.setTemporary(true);
            return result;
        }
        if (relation == 8) {
            BoolArray result;
            if (b) {
                result = new BoolArray(true, size);
            } else {
                boolean[] resultDatas = new boolean[size + 1];
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = pos[i] != -1;
                    ++i;
                }
                result = new BoolArray(resultDatas, size);
            }
            result.setTemporary(true);
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), value, this.getDataType(), Variant.getDataType(value)));
    }

    private static BoolArray calcRelationNull(int[] pos, int size, int relation) {
        int i;
        boolean[] signs = null;
        int i2 = 1;
        while (i2 <= size) {
            if (pos[i2] == -1) {
                if (signs == null) {
                    signs = new boolean[size];
                }
                signs[i2] = true;
            }
            ++i2;
        }
        boolean[] resultDatas = new boolean[size + 1];
        if (relation == 1) {
            if (signs != null) {
                System.arraycopy(signs, 1, resultDatas, 1, size);
            }
        } else if (relation == 2) {
            if (signs == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = true;
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    if (!signs[i]) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
        } else if (relation == 3) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = true;
                ++i;
            }
        } else if (relation != 4) {
            if (relation == 5) {
                if (signs != null) {
                    System.arraycopy(signs, 1, resultDatas, 1, size);
                }
            } else if (relation == 6) {
                if (signs == null) {
                    i = 1;
                    while (i <= size) {
                        resultDatas[i] = true;
                        ++i;
                    }
                } else {
                    i = 1;
                    while (i <= size) {
                        if (!signs[i]) {
                            resultDatas[i] = true;
                        }
                        ++i;
                    }
                }
            } else if (relation == 8) {
                if (signs == null) {
                    i = 1;
                    while (i <= size) {
                        resultDatas[i] = true;
                        ++i;
                    }
                } else {
                    i = 1;
                    while (i <= size) {
                        resultDatas[i] = !signs[i];
                        ++i;
                    }
                }
            }
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    private BoolArray calcRelation(byte[] value, int relation) {
        int i;
        int size = this.size;
        int[] pos = this.pos;
        byte[] len = this.len;
        byte[] d1 = this.buffer;
        boolean[] resultDatas = new boolean[size + 1];
        if (relation == 1) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = ByteBufferArray.compare(d1, pos[i], (int)len[i], value) == 0;
                ++i;
            }
        } else if (relation == 2) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = ByteBufferArray.compare(d1, pos[i], (int)len[i], value) > 0;
                ++i;
            }
        } else if (relation == 3) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = ByteBufferArray.compare(d1, pos[i], (int)len[i], value) >= 0;
                ++i;
            }
        } else if (relation == 4) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = ByteBufferArray.compare(d1, pos[i], (int)len[i], value) < 0;
                ++i;
            }
        } else if (relation == 5) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = ByteBufferArray.compare(d1, pos[i], (int)len[i], value) <= 0;
                ++i;
            }
        } else if (relation == 6) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = ByteBufferArray.compare(d1, pos[i], (int)len[i], value) != 0;
                ++i;
            }
        } else if (relation == 7) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = pos[i] != -1;
                ++i;
            }
        } else {
            i = 1;
            while (i <= size) {
                resultDatas[i] = true;
                ++i;
            }
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    @Override
    public int compareTo(IArray array) {
        throw new RuntimeException();
    }

    @Override
    public int memberCompare(int index1, int index2) {
        throw new RuntimeException();
    }

    @Override
    public boolean isMemberEquals(int index1, int index2) {
        throw new RuntimeException();
    }

    @Override
    public boolean isEquals(int curIndex, IArray array, int index) {
        throw new RuntimeException();
    }

    @Override
    public boolean isEquals(int curIndex, Object value) {
        if (value instanceof String) {
            return ByteBufferArray.compare(this.buffer, this.pos[curIndex], (int)this.len[curIndex], ((String)value).getBytes()) == 0;
        }
        if (value == null) {
            return this.pos[curIndex] == -1;
        }
        return false;
    }

    @Override
    public int compareTo(int curIndex, IArray array, int index) {
        return ByteBufferArray.compare(this.buffer, this.pos[curIndex], (int)this.len[curIndex], array.get(index));
    }

    @Override
    public int compareTo(int curIndex, Object value) {
        return ByteBufferArray.compare(this.buffer, this.pos[curIndex], (int)this.len[curIndex], value);
    }

    @Override
    public int hashCode(int index) {
        if (this.pos[index] != -1) {
            return this.get(index).hashCode();
        }
        return 0;
    }

    @Override
    public Object sum() {
        return null;
    }

    @Override
    public Object average() {
        return null;
    }

    @Override
    public Object max() {
        throw new RuntimeException();
    }

    @Override
    public Object min() {
        throw new RuntimeException();
    }

    @Override
    public void calcRelations(IArray array, int relation, BoolArray result, boolean isAnd) {
        if (!(array instanceof ConstArray)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), array.get(1), this.getDataType(), array.getDataType()));
        }
        this.calcRelations(array.get(1), relation, result, isAnd);
    }

    @Override
    public void calcRelations(Object value, int relation, BoolArray result, boolean isAnd) {
        if (value instanceof String) {
            this.calcRelations(((String)value).getBytes(), relation, result, isAnd);
        } else if (value == null) {
            ByteBufferArray.calcRelationsNull(this.pos, this.size, relation, result, isAnd);
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), value, this.getDataType(), Variant.getDataType(value)));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void calcRelationsNull(int[] pos, int size, int relation, BoolArray result, boolean isAnd) {
        boolean[] signs = null;
        int i = 1;
        while (i <= size) {
            if (pos[i] == -1) {
                if (signs == null) {
                    signs = new boolean[size];
                }
                signs[i] = true;
            }
            ++i;
        }
        boolean[] resultDatas = result.getDatas();
        if (isAnd) {
            if (relation == 1) {
                if (signs == null) {
                    int i2 = 1;
                    while (i2 <= size) {
                        resultDatas[i2] = false;
                        ++i2;
                    }
                    return;
                } else {
                    int i3 = 1;
                    while (i3 <= size) {
                        if (!signs[i3]) {
                            resultDatas[i3] = false;
                        }
                        ++i3;
                    }
                }
                return;
            } else if (relation == 2) {
                if (signs == null) return;
                int i4 = 1;
                while (i4 <= size) {
                    if (signs[i4]) {
                        resultDatas[i4] = false;
                    }
                    ++i4;
                }
                return;
            } else {
                if (relation == 3) return;
                if (relation == 4) {
                    int i5 = 1;
                    while (i5 <= size) {
                        resultDatas[i5] = false;
                        ++i5;
                    }
                    return;
                } else if (relation == 5) {
                    if (signs == null) return;
                    int i6 = 1;
                    while (i6 <= size) {
                        if (!signs[i6]) {
                            resultDatas[i6] = false;
                        }
                        ++i6;
                    }
                    return;
                } else {
                    if (relation != 6) throw new RuntimeException();
                    if (signs == null) return;
                    int i7 = 1;
                    while (i7 <= size) {
                        if (signs[i7]) {
                            resultDatas[i7] = false;
                        }
                        ++i7;
                    }
                }
            }
            return;
        } else if (relation == 1) {
            if (signs == null) return;
            int i8 = 1;
            while (i8 <= size) {
                if (signs[i8]) {
                    resultDatas[i8] = true;
                }
                ++i8;
            }
            return;
        } else if (relation == 2) {
            if (signs == null) {
                int i9 = 1;
                while (i9 <= size) {
                    resultDatas[i9] = true;
                    ++i9;
                }
                return;
            } else {
                int i10 = 1;
                while (i10 <= size) {
                    if (!signs[i10]) {
                        resultDatas[i10] = true;
                    }
                    ++i10;
                }
            }
            return;
        } else if (relation == 3) {
            int i11 = 1;
            while (i11 <= size) {
                resultDatas[i11] = true;
                ++i11;
            }
            return;
        } else {
            if (relation == 4) return;
            if (relation == 5) {
                if (signs == null) return;
                int i12 = 1;
                while (i12 <= size) {
                    if (signs[i12]) {
                        resultDatas[i12] = true;
                    }
                    ++i12;
                }
                return;
            } else {
                if (relation != 6) throw new RuntimeException();
                if (signs == null) {
                    int i13 = 1;
                    while (i13 <= size) {
                        resultDatas[i13] = true;
                        ++i13;
                    }
                    return;
                } else {
                    int i14 = 1;
                    while (i14 <= size) {
                        if (!signs[i14]) {
                            resultDatas[i14] = true;
                        }
                        ++i14;
                    }
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void calcRelations(byte[] value, int relation, BoolArray result, boolean isAnd) {
        int size = this.size;
        byte[] d1 = this.buffer;
        int[] pos = this.pos;
        byte[] len = this.len;
        boolean[] resultDatas = result.getDatas();
        if (isAnd) {
            if (relation == 1) {
                int i = 1;
                while (i <= size) {
                    if (resultDatas[i] && ByteBufferArray.compare(d1, pos[i], (int)len[i], value) != 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
                return;
            } else if (relation == 2) {
                int i = 1;
                while (i <= size) {
                    if (resultDatas[i] && ByteBufferArray.compare(d1, pos[i], (int)len[i], value) <= 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
                return;
            } else if (relation == 3) {
                int i = 1;
                while (i <= size) {
                    if (resultDatas[i] && ByteBufferArray.compare(d1, pos[i], (int)len[i], value) < 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
                return;
            } else if (relation == 4) {
                int i = 1;
                while (i <= size) {
                    if (resultDatas[i] && ByteBufferArray.compare(d1, pos[i], (int)len[i], value) >= 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
                return;
            } else if (relation == 5) {
                int i = 1;
                while (i <= size) {
                    if (resultDatas[i] && ByteBufferArray.compare(d1, pos[i], (int)len[i], value) > 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
                return;
            } else {
                if (relation != 6) throw new RuntimeException();
                int i = 1;
                while (i <= size) {
                    if (resultDatas[i] && ByteBufferArray.compare(d1, pos[i], (int)len[i], value) == 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
            }
            return;
        } else if (relation == 1) {
            int i = 1;
            while (i <= size) {
                if (!resultDatas[i] && ByteBufferArray.compare(d1, pos[i], (int)len[i], value) == 0) {
                    resultDatas[i] = true;
                }
                ++i;
            }
            return;
        } else if (relation == 2) {
            int i = 1;
            while (i <= size) {
                if (!resultDatas[i] && ByteBufferArray.compare(d1, pos[i], (int)len[i], value) > 0) {
                    resultDatas[i] = true;
                }
                ++i;
            }
            return;
        } else if (relation == 3) {
            int i = 1;
            while (i <= size) {
                if (!resultDatas[i] && ByteBufferArray.compare(d1, pos[i], (int)len[i], value) >= 0) {
                    resultDatas[i] = true;
                }
                ++i;
            }
            return;
        } else if (relation == 4) {
            int i = 1;
            while (i <= size) {
                if (!resultDatas[i] && ByteBufferArray.compare(d1, pos[i], (int)len[i], value) < 0) {
                    resultDatas[i] = true;
                }
                ++i;
            }
            return;
        } else if (relation == 5) {
            int i = 1;
            while (i <= size) {
                if (!resultDatas[i] && ByteBufferArray.compare(d1, pos[i], (int)len[i], value) <= 0) {
                    resultDatas[i] = true;
                }
                ++i;
            }
            return;
        } else {
            if (relation != 6) throw new RuntimeException();
            int i = 1;
            while (i <= size) {
                if (!resultDatas[i] && ByteBufferArray.compare(d1, pos[i], (int)len[i], value) != 0) {
                    resultDatas[i] = true;
                }
                ++i;
            }
        }
    }

    @Override
    public IArray bitwiseAnd(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException("and" + mm.getMessage("function.paramTypeError"));
    }

    @Override
    public IArray bitwiseOr(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException("or" + mm.getMessage("function.paramTypeError"));
    }

    @Override
    public IArray bitwiseXOr(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException("xor" + mm.getMessage("function.paramTypeError"));
    }

    @Override
    public IArray bitwiseNot() {
        MessageManager mm = EngineMessage.get();
        throw new RQException("not" + mm.getMessage("function.paramTypeError"));
    }

    @Override
    public IArray select(IArray signArray) {
        throw new RuntimeException();
    }

    @Override
    public IArray select(int start, int end, IArray signArray) {
        throw new RuntimeException();
    }

    @Override
    public IArray memberAdd(int curIndex, IArray array, int index) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illAdd"));
    }

    @Override
    public Object[] toArray() {
        throw new RuntimeException();
    }

    @Override
    public void toArray(Object[] result) {
        throw new RuntimeException();
    }

    @Override
    public IArray split(int pos) {
        throw new RuntimeException();
    }

    @Override
    public IArray split(int from, int to) {
        throw new RuntimeException();
    }

    @Override
    public void sort() {
        throw new RuntimeException();
    }

    @Override
    public void sort(Comparator<Object> comparator) {
        throw new RuntimeException();
    }

    @Override
    public boolean hasRecord() {
        return false;
    }

    @Override
    public boolean isPmt(boolean isPure) {
        return false;
    }

    @Override
    public IArray rvs() {
        throw new RuntimeException();
    }

    @Override
    public IntArray ptop(int count, boolean isAll, boolean isLast, boolean ignoreNull) {
        throw new RuntimeException();
    }

    @Override
    public IntArray ptopRank(int count, boolean ignoreNull, boolean iopt) {
        throw new RuntimeException();
    }

    @Override
    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public ObjectArray toObjectArray() {
        throw new RuntimeException();
    }

    @Override
    public IArray toPureArray() {
        return this;
    }

    @Override
    public IArray reserve(boolean refOrigin) {
        if (this.isTemporary()) {
            this.setTemporary(false);
            return this;
        }
        if (refOrigin) {
            return this;
        }
        return this.dup();
    }

    @Override
    public IArray combine(IArray signArray, IArray other) {
        throw new RuntimeException();
    }

    @Override
    public IArray combine(IArray signArray, Object value) {
        throw new RuntimeException();
    }

    public int[] getPos() {
        return this.pos;
    }

    public byte[] getLen() {
        return this.len;
    }

    @Override
    public Object pos(IArray array, String opt) {
        return ArrayUtil.pos(this, array, opt);
    }

    @Override
    public int bit1() {
        MessageManager mm = EngineMessage.get();
        throw new RQException("bit1" + mm.getMessage("function.paramTypeError"));
    }

    @Override
    public int bit1(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException("bit1" + mm.getMessage("function.paramTypeError"));
    }

    @Override
    public int getNextEqualCount(int index) {
        throw new RuntimeException();
    }
}

