/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.array;

import com.scudata.array.ArrayUtil;
import com.scudata.array.BoolArray;
import com.scudata.array.DateArray;
import com.scudata.array.DoubleArray;
import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.array.LongArray;
import com.scudata.array.ObjectArray;
import com.scudata.array.StringArray;
import com.scudata.common.ByteArrayInputRecord;
import com.scudata.common.ByteArrayOutputRecord;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Sequence;
import com.scudata.expression.Relation;
import com.scudata.expression.fn.math.And;
import com.scudata.expression.fn.math.Bit1;
import com.scudata.expression.fn.math.Or;
import com.scudata.expression.fn.math.Xor;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;

public class ConstArray
implements IArray {
    private static final long serialVersionUID = 1L;
    private Object data;
    private int size;

    public ConstArray() {
    }

    public ConstArray(Object data, int size) {
        this.data = data;
        this.size = size;
    }

    @Override
    public String getDataType() {
        return Variant.getDataType(this.data);
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    @Override
    public void add(Object o) {
        if (Variant.isEquals(this.data, o)) {
            ++this.size;
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("pdm.modifyConstArrayError"));
        }
    }

    @Override
    public void addAll(IArray array) {
        if (array.size() == 0) {
            return;
        }
        if (array instanceof ConstArray && Variant.isEquals(this.data, array.get(1))) {
            this.size += array.size();
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("pdm.modifyConstArrayError"));
        }
    }

    @Override
    public void addAll(IArray array, int count) {
        if (count == 0) {
            return;
        }
        if (array instanceof ConstArray && Variant.isEquals(this.data, array.get(1))) {
            this.size += count;
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("pdm.modifyConstArrayError"));
        }
    }

    @Override
    public void addAll(IArray array, int index, int count) {
        if (array instanceof ConstArray && Variant.isEquals(this.data, array.get(1))) {
            this.size += count;
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("pdm.modifyConstArrayError"));
        }
    }

    @Override
    public void addAll(Object[] array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyConstArrayError"));
    }

    @Override
    public void insert(int index, Object o) {
        if (Variant.isEquals(this.data, o)) {
            ++this.size;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyConstArrayError"));
    }

    @Override
    public void insertAll(int pos, IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyConstArrayError"));
    }

    @Override
    public void insertAll(int pos, Object[] array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyConstArrayError"));
    }

    @Override
    public void push(Object o) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyConstArrayError"));
    }

    @Override
    public void pushNull() {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyConstArrayError"));
    }

    @Override
    public void push(IArray array, int index) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyConstArrayError"));
    }

    @Override
    public void add(IArray array, int index) {
        if (Variant.isEquals(this.data, array.get(index))) {
            ++this.size;
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("pdm.modifyConstArrayError"));
        }
    }

    @Override
    public void set(int curIndex, IArray array, int index) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyConstArrayError"));
    }

    @Override
    public Object get(int index) {
        return this.data;
    }

    @Override
    public int getInt(int index) {
        return ((Number)this.data).intValue();
    }

    @Override
    public long getLong(int index) {
        return ((Number)this.data).longValue();
    }

    @Override
    public IArray get(int[] indexArray) {
        return new ConstArray(this.data, indexArray.length);
    }

    @Override
    public IArray get(int[] indexArray, int start, int end, boolean doCheck) {
        int len = end - start + 1;
        Object data = this.data;
        if (doCheck && data != null) {
            Object[] resultDatas = new Object[len + 1];
            int i = 1;
            while (start <= end) {
                int q = indexArray[start];
                if (q > 0) {
                    resultDatas[i] = data;
                }
                ++start;
                ++i;
            }
            return new ObjectArray(resultDatas, len);
        }
        return new ConstArray(data, len);
    }

    @Override
    public IArray get(IArray indexArray) {
        Object data = this.data;
        int len = indexArray.size();
        ObjectArray result = new ObjectArray(len);
        int i = 1;
        while (i <= len) {
            if (indexArray.isNull(i)) {
                result.pushNull();
            } else {
                result.push(data);
            }
            ++i;
        }
        return result;
    }

    @Override
    public IArray get(int start, int end) {
        return new ConstArray(this.data, end - start);
    }

    @Override
    public void ensureCapacity(int minCapacity) {
    }

    @Override
    public void trimToSize() {
    }

    @Override
    public boolean isNull(int index) {
        return this.data == null;
    }

    @Override
    public BoolArray isTrue() {
        int size = this.size;
        boolean[] resultDatas = new boolean[size + 1];
        boolean value = Variant.isTrue(this.data);
        int i = 1;
        while (i <= size) {
            resultDatas[i] = value;
            ++i;
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    @Override
    public BoolArray isFalse() {
        int size = this.size;
        boolean[] resultDatas = new boolean[size + 1];
        boolean value = Variant.isFalse(this.data);
        int i = 1;
        while (i <= size) {
            resultDatas[i] = value;
            ++i;
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    @Override
    public boolean isTrue(int index) {
        return Variant.isTrue(this.data);
    }

    @Override
    public boolean isFalse(int index) {
        return Variant.isFalse(this.data);
    }

    @Override
    public boolean isTemporary() {
        return false;
    }

    @Override
    public void setTemporary(boolean ifTemporary) {
    }

    @Override
    public void removeLast() {
        --this.size;
    }

    @Override
    public void remove(int index) {
        --this.size;
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        this.size -= toIndex - fromIndex + 1;
    }

    @Override
    public void remove(int[] seqs) {
        this.size -= seqs.length;
    }

    @Override
    public void reserve(int start, int end) {
        this.size = end - start + 1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int count() {
        return this.data != null ? this.size : 0;
    }

    @Override
    public boolean containTrue() {
        return Variant.isTrue(this.data);
    }

    @Override
    public Object ifn() {
        return this.data;
    }

    @Override
    public void set(int index, Object obj) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyConstArrayError"));
    }

    @Override
    public void clear() {
        this.data = null;
        this.size = 0;
    }

    @Override
    public int binarySearch(Object elem) {
        if (this.size == 0) {
            return -1;
        }
        int cmp = Variant.compare(this.data, elem, true);
        if (cmp == 0) {
            return 1;
        }
        if (cmp < 0) {
            return -1;
        }
        return -this.size - 1;
    }

    @Override
    public int binarySearch(Object elem, int start, int end) {
        if (end == 0) {
            return -1;
        }
        int cmp = Variant.compare(this.data, elem, true);
        if (cmp == 0) {
            return start;
        }
        if (cmp < 0) {
            return -1;
        }
        return -this.size - 1;
    }

    @Override
    public boolean contains(Object elem) {
        if (this.size == 0) {
            return false;
        }
        return Variant.isEquals(this.data, elem);
    }

    @Override
    public void contains(boolean isSorted, IArray array, BoolArray result) {
        int resultSize = result.size();
        if (this.size > 0) {
            Object data = this.data;
            int i = 1;
            while (i <= resultSize) {
                if (result.isTrue(i) && !Variant.isEquals(data, array.get(i))) {
                    result.set(i, false);
                }
                ++i;
            }
        } else {
            int i = 1;
            while (i <= resultSize) {
                result.set(i, false);
                ++i;
            }
        }
    }

    @Override
    public boolean objectContains(Object elem) {
        return this.data == elem;
    }

    @Override
    public int firstIndexOf(Object elem, int start) {
        if (this.size == 0) {
            return 0;
        }
        return Variant.isEquals(this.data, elem) ? start : 0;
    }

    @Override
    public int lastIndexOf(Object elem, int start) {
        if (this.size == 0) {
            return 0;
        }
        return Variant.isEquals(this.data, elem) ? start : 0;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public IntArray indexOfAll(Object elem, int start, boolean isSorted, boolean isFromHead) {
        block3: {
            block4: {
                if (this.size <= 0 || !Variant.isEquals(this.data, elem)) break block3;
                end = this.size;
                if (!isFromHead) {
                    end = start;
                    start = 1;
                }
                result = new IntArray(end - start + 1);
                if (!isFromHead) ** GOTO lbl15
                while (start <= end) {
                    result.pushInt(start);
                    ++start;
                }
                break block4;
lbl-1000:
                // 1 sources

                {
                    result.pushInt(end);
                    --end;
lbl15:
                    // 2 sources

                    ** while (end >= start)
                }
            }
            return result;
        }
        return new IntArray(1);
    }

    @Override
    public IArray dup() {
        return new ConstArray(this.data, this.size);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        out.writeInt(this.size);
        out.writeObject(this.data);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        this.size = in.readInt();
        this.data = in.readObject();
    }

    @Override
    public byte[] serialize() throws IOException {
        ByteArrayOutputRecord out = new ByteArrayOutputRecord();
        out.writeByte(1);
        out.writeInt(this.size);
        out.writeObject(this.data, true);
        return out.toByteArray();
    }

    @Override
    public void fillRecord(byte[] buf) throws IOException, ClassNotFoundException {
        ByteArrayInputRecord in = new ByteArrayInputRecord(buf);
        in.readByte();
        this.size = in.readInt();
        this.data = in.readObject(true);
    }

    @Override
    public IArray newInstance(int count) {
        if (this.data instanceof Integer) {
            return new IntArray(count);
        }
        if (this.data instanceof Long) {
            return new LongArray(count);
        }
        if (this.data instanceof Double) {
            return new DoubleArray(count);
        }
        if (this.data instanceof String) {
            return new StringArray(count);
        }
        if (this.data instanceof Date) {
            return new DateArray(count);
        }
        if (this.data instanceof Boolean) {
            return new BoolArray(count);
        }
        return new ObjectArray(count);
    }

    @Override
    public IArray abs() {
        if (this.data == null) {
            return this;
        }
        return new ConstArray(Variant.abs(this.data), this.size);
    }

    @Override
    public IArray negate() {
        if (this.data == null) {
            return this;
        }
        return new ConstArray(Variant.negate(this.data), this.size);
    }

    @Override
    public IArray not() {
        Boolean b = Variant.isFalse(this.data);
        return new ConstArray(b, this.size);
    }

    @Override
    public boolean isNumberArray() {
        return this.data == null || this.data instanceof Number;
    }

    @Override
    public IArray memberAdd(IArray array) {
        return array.memberAdd(this.data);
    }

    @Override
    public IArray memberAdd(Object value) {
        value = Variant.add(this.data, value);
        return new ConstArray(value, this.size);
    }

    @Override
    public IArray memberSubtract(IArray array) {
        if (array instanceof IntArray) {
            return this.memberSubtract((IntArray)array);
        }
        if (array instanceof LongArray) {
            return this.memberSubtract((LongArray)array);
        }
        if (array instanceof DoubleArray) {
            return this.memberSubtract((DoubleArray)array);
        }
        if (array instanceof ConstArray) {
            Object value = array.get(1);
            value = Variant.subtract(this.data, value);
            return new ConstArray(value, this.size);
        }
        if (array instanceof ObjectArray) {
            return this.memberSubtract((ObjectArray)array);
        }
        if (array instanceof DateArray) {
            return this.memberSubtract((DateArray)array);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(Variant.getDataType(this.data)) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illSubtract"));
    }

    private IArray memberSubtract(IntArray array) {
        int size = this.size;
        int[] datas = array.getDatas();
        boolean[] signs = array.getSigns();
        if (this.data instanceof Long) {
            int i;
            long v = (Long)this.data;
            long[] resultDatas = new long[size + 1];
            if (signs == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = v - (long)datas[i];
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = signs[i] ? v : v - (long)datas[i];
                    ++i;
                }
            }
            LongArray result = new LongArray(resultDatas, null, size);
            result.setTemporary(true);
            return result;
        }
        if (this.data instanceof Double || this.data instanceof Float) {
            int i;
            double v = ((Number)this.data).doubleValue();
            double[] resultDatas = new double[size + 1];
            if (signs == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = v - (double)datas[i];
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = signs[i] ? v : v - (double)datas[i];
                    ++i;
                }
            }
            DoubleArray result = new DoubleArray(resultDatas, null, size);
            result.setTemporary(true);
            return result;
        }
        if (this.data instanceof BigDecimal || this.data instanceof BigInteger) {
            int i;
            BigDecimal decimal = this.data instanceof BigDecimal ? (BigDecimal)this.data : new BigDecimal((BigInteger)this.data);
            Object[] resultDatas = new Object[size + 1];
            if (signs == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = decimal.subtract(new BigDecimal(datas[i]));
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = signs[i] ? decimal : decimal.subtract(new BigDecimal(datas[i]));
                    ++i;
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (this.data instanceof Number) {
            int i;
            int v = ((Number)this.data).intValue();
            if (array.isTemporary()) {
                if (signs == null) {
                    int i2 = 1;
                    while (i2 <= size) {
                        datas[i2] = v - datas[i2];
                        ++i2;
                    }
                } else {
                    int i3 = 1;
                    while (i3 <= size) {
                        datas[i3] = signs[i3] ? v : v - datas[i3];
                        ++i3;
                    }
                    array.setSigns(null);
                }
                return array;
            }
            int[] resultDatas = new int[size + 1];
            if (signs == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = v - datas[i];
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = signs[i] ? v : v - datas[i];
                    ++i;
                }
            }
            IntArray result = new IntArray(resultDatas, null, size);
            result.setTemporary(true);
            return result;
        }
        if (this.data instanceof Date) {
            Date date = (Date)this.data;
            long time = date.getTime();
            Calendar calendar = Calendar.getInstance();
            Object[] resultDatas = new Object[size + 1];
            int i = 1;
            while (i <= size) {
                if (signs == null || !signs[i]) {
                    calendar.setTimeInMillis(time);
                    calendar.add(5, -datas[i]);
                    Date resultDate = (Date)date.clone();
                    resultDate.setTime(calendar.getTimeInMillis());
                    resultDatas[i] = resultDate;
                } else {
                    resultDatas[i] = date;
                }
                ++i;
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (this.data == null) {
            return array.negate();
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(Variant.getDataType(this.data)) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illSubtract"));
    }

    private IArray memberSubtract(LongArray array) {
        int size = this.size;
        long[] datas = array.getDatas();
        boolean[] signs = array.getSigns();
        if (this.data instanceof Double || this.data instanceof Float) {
            int i;
            double v = ((Number)this.data).doubleValue();
            double[] resultDatas = new double[size + 1];
            if (signs == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = v - (double)datas[i];
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = signs[i] ? v : v - (double)datas[i];
                    ++i;
                }
            }
            DoubleArray result = new DoubleArray(resultDatas, null, size);
            result.setTemporary(true);
            return result;
        }
        if (this.data instanceof BigDecimal || this.data instanceof BigInteger) {
            int i;
            BigDecimal decimal = this.data instanceof BigDecimal ? (BigDecimal)this.data : new BigDecimal((BigInteger)this.data);
            Object[] resultDatas = new Object[size + 1];
            if (signs == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = decimal.subtract(new BigDecimal(datas[i]));
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = signs[i] ? decimal : decimal.subtract(new BigDecimal(datas[i]));
                    ++i;
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (this.data instanceof Number) {
            int i;
            long v = ((Number)this.data).longValue();
            if (array.isTemporary()) {
                if (signs == null) {
                    int i2 = 1;
                    while (i2 <= size) {
                        datas[i2] = v - datas[i2];
                        ++i2;
                    }
                } else {
                    int i3 = 1;
                    while (i3 <= size) {
                        datas[i3] = signs[i3] ? v : v - datas[i3];
                        ++i3;
                    }
                    array.setSigns(null);
                }
                return array;
            }
            long[] resultDatas = new long[size + 1];
            if (signs == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = v - datas[i];
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = signs[i] ? v : v - datas[i];
                    ++i;
                }
            }
            LongArray result = new LongArray(resultDatas, null, size);
            result.setTemporary(true);
            return result;
        }
        if (this.data instanceof Date) {
            Date date = (Date)this.data;
            long time = date.getTime();
            Calendar calendar = Calendar.getInstance();
            Object[] resultDatas = new Object[size + 1];
            int i = 1;
            while (i <= size) {
                if (signs == null || !signs[i]) {
                    calendar.setTimeInMillis(time);
                    calendar.add(5, -((int)datas[i]));
                    Date resultDate = (Date)date.clone();
                    resultDate.setTime(calendar.getTimeInMillis());
                    resultDatas[i] = resultDate;
                } else {
                    resultDatas[i] = date;
                }
                ++i;
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (this.data == null) {
            return array.negate();
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(Variant.getDataType(this.data)) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illSubtract"));
    }

    private IArray memberSubtract(DoubleArray array) {
        int size = this.size;
        double[] datas = array.getDatas();
        boolean[] signs = array.getSigns();
        if (this.data instanceof BigDecimal || this.data instanceof BigInteger) {
            int i;
            BigDecimal decimal = this.data instanceof BigDecimal ? (BigDecimal)this.data : new BigDecimal((BigInteger)this.data);
            Object[] resultDatas = new Object[size + 1];
            if (signs == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = decimal.subtract(new BigDecimal(datas[i]));
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = signs[i] ? decimal : decimal.subtract(new BigDecimal(datas[i]));
                    ++i;
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (this.data instanceof Number) {
            int i;
            double v = ((Number)this.data).doubleValue();
            if (array.isTemporary()) {
                if (signs == null) {
                    int i2 = 1;
                    while (i2 <= size) {
                        datas[i2] = v - datas[i2];
                        ++i2;
                    }
                } else {
                    int i3 = 1;
                    while (i3 <= size) {
                        datas[i3] = signs[i3] ? v : v - datas[i3];
                        ++i3;
                    }
                    array.setSigns(null);
                }
                return array;
            }
            double[] resultDatas = new double[size + 1];
            if (signs == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = v - datas[i];
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = signs[i] ? v : v - datas[i];
                    ++i;
                }
            }
            DoubleArray result = new DoubleArray(resultDatas, null, size);
            result.setTemporary(true);
            return result;
        }
        if (this.data instanceof Date) {
            Date date = (Date)this.data;
            long time = date.getTime();
            Calendar calendar = Calendar.getInstance();
            Object[] resultDatas = new Object[size + 1];
            int i = 1;
            while (i <= size) {
                if (signs == null || !signs[i]) {
                    calendar.setTimeInMillis(time);
                    calendar.add(5, -((int)datas[i]));
                    Date resultDate = (Date)date.clone();
                    resultDate.setTime(calendar.getTimeInMillis());
                    resultDatas[i] = resultDate;
                } else {
                    resultDatas[i] = date;
                }
                ++i;
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (this.data == null) {
            return array.negate();
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(Variant.getDataType(this.data)) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illSubtract"));
    }

    private IArray memberSubtract(DateArray array) {
        if (this.data instanceof Date) {
            int size = this.size;
            Date date = (Date)this.data;
            Date[] datas = array.getDatas();
            long[] resultDatas = new long[size + 1];
            boolean[] resultSigns = null;
            int i = 1;
            while (i <= size) {
                if (datas[i] == null) {
                    if (resultSigns == null) {
                        resultSigns = new boolean[size + 1];
                    }
                    resultSigns[i] = true;
                } else {
                    resultDatas[i] = Variant.dayInterval(datas[i], date);
                }
                ++i;
            }
            LongArray result = new LongArray(resultDatas, resultSigns, size);
            result.setTemporary(true);
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(Variant.getDataType(this.data)) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illSubtract"));
    }

    private ObjectArray memberSubtract(ObjectArray array) {
        Object data = this.data;
        int size = this.size;
        Object[] datas = array.getDatas();
        if (array.isTemporary()) {
            int i = 1;
            while (i <= size) {
                datas[i] = Variant.subtract(data, datas[i]);
                ++i;
            }
            return array;
        }
        Object[] resultDatas = new Object[size + 1];
        int i = 1;
        while (i <= size) {
            resultDatas[i] = Variant.subtract(data, datas[i]);
            ++i;
        }
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    @Override
    public IArray memberMultiply(IArray array) {
        return array.memberMultiply(this.data);
    }

    @Override
    public IArray memberMultiply(Object value) {
        value = Variant.multiply(this.data, value);
        return new ConstArray(value, this.size);
    }

    @Override
    public IArray memberDivide(IArray array) {
        if (array instanceof IntArray) {
            return this.memberDivide((IntArray)array);
        }
        if (array instanceof LongArray) {
            return this.memberDivide((LongArray)array);
        }
        if (array instanceof DoubleArray) {
            return this.memberDivide((DoubleArray)array);
        }
        if (array instanceof ConstArray) {
            Object value = array.get(1);
            value = Variant.divide(this.data, value);
            return new ConstArray(value, this.size);
        }
        if (array instanceof ObjectArray) {
            return this.memberDivide((ObjectArray)array);
        }
        if (array instanceof StringArray) {
            return this.memberDivide((StringArray)array);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illDivide"));
    }

    private StringArray memberDivide(StringArray array) {
        if (this.data == null) {
            return array;
        }
        String str = this.data.toString();
        int size = this.size;
        String[] d2 = array.getDatas();
        if (this.isTemporary()) {
            int i = 1;
            while (i <= size) {
                d2[i] = d2[i] != null ? String.valueOf(str) + d2[i] : str;
                ++i;
            }
            return array;
        }
        String[] resultDatas = new String[size + 1];
        int i = 1;
        while (i <= size) {
            resultDatas[i] = d2[i] != null ? String.valueOf(str) + d2[i] : str;
            ++i;
        }
        StringArray result = new StringArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    private IArray memberDivide(IntArray array) {
        Object data = this.data;
        int size = this.size;
        int[] d2 = array.getDatas();
        boolean[] s2 = array.getSigns();
        if (data instanceof BigDecimal || data instanceof BigInteger) {
            int i;
            BigDecimal decimal = data instanceof BigDecimal ? (BigDecimal)data : new BigDecimal((BigInteger)data);
            Object[] resultDatas = new Object[size + 1];
            if (s2 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = decimal.divide(new BigDecimal(d2[i]), 16, 4);
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    if (!s2[i]) {
                        resultDatas[i] = decimal.divide(new BigDecimal(d2[i]), 16, 4);
                    }
                    ++i;
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (data instanceof Number) {
            int i;
            double v = ((Number)data).doubleValue();
            double[] resultDatas = new double[size + 1];
            boolean[] resultSigns = null;
            if (s2 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = v / (double)d2[i];
                    ++i;
                }
            } else {
                resultSigns = new boolean[size + 1];
                i = 1;
                while (i <= size) {
                    if (s2[i]) {
                        resultSigns[i] = true;
                    } else {
                        resultDatas[i] = v / (double)d2[i];
                    }
                    ++i;
                }
            }
            DoubleArray result = new DoubleArray(resultDatas, resultSigns, size);
            result.setTemporary(true);
            return result;
        }
        if (data instanceof String) {
            int i;
            String str = (String)data;
            Object[] resultDatas = new Object[size + 1];
            if (s2 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = String.valueOf(str) + d2[i];
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    if (!s2[i]) {
                        resultDatas[i] = String.valueOf(str) + d2[i];
                    }
                    ++i;
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (data == null) {
            return new ConstArray(null, size);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(Variant.getDataType(data)) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illDivide"));
    }

    private IArray memberDivide(LongArray array) {
        Object data = this.data;
        int size = this.size;
        long[] d2 = array.getDatas();
        boolean[] s2 = array.getSigns();
        if (data instanceof BigDecimal || data instanceof BigInteger) {
            int i;
            BigDecimal decimal = data instanceof BigDecimal ? (BigDecimal)data : new BigDecimal((BigInteger)data);
            Object[] resultDatas = new Object[size + 1];
            if (s2 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = decimal.divide(new BigDecimal(d2[i]), 16, 4);
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    if (!s2[i]) {
                        resultDatas[i] = decimal.divide(new BigDecimal(d2[i]), 16, 4);
                    }
                    ++i;
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (data instanceof Number) {
            int i;
            double v = ((Number)data).doubleValue();
            double[] resultDatas = new double[size + 1];
            boolean[] resultSigns = null;
            if (s2 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = v / (double)d2[i];
                    ++i;
                }
            } else {
                resultSigns = new boolean[size + 1];
                i = 1;
                while (i <= size) {
                    if (s2[i]) {
                        resultSigns[i] = true;
                    } else {
                        resultDatas[i] = v / (double)d2[i];
                    }
                    ++i;
                }
            }
            DoubleArray result = new DoubleArray(resultDatas, resultSigns, size);
            result.setTemporary(true);
            return result;
        }
        if (data instanceof String) {
            int i;
            String str = (String)data;
            Object[] resultDatas = new Object[size + 1];
            if (s2 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = String.valueOf(str) + d2[i];
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    if (!s2[i]) {
                        resultDatas[i] = String.valueOf(str) + d2[i];
                    }
                    ++i;
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (data == null) {
            return new ConstArray(null, size);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(Variant.getDataType(data)) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illDivide"));
    }

    private IArray memberDivide(DoubleArray array) {
        Object data = this.data;
        int size = this.size;
        double[] d2 = array.getDatas();
        boolean[] s2 = array.getSigns();
        if (data instanceof BigDecimal || data instanceof BigInteger) {
            int i;
            BigDecimal decimal = data instanceof BigDecimal ? (BigDecimal)data : new BigDecimal((BigInteger)data);
            Object[] resultDatas = new Object[size + 1];
            if (s2 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = decimal.divide(new BigDecimal(d2[i]), 16, 4);
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    if (!s2[i]) {
                        resultDatas[i] = decimal.divide(new BigDecimal(d2[i]), 16, 4);
                    }
                    ++i;
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (data instanceof Number) {
            int i;
            double v = ((Number)data).doubleValue();
            if (array.isTemporary()) {
                if (s2 == null) {
                    int i2 = 1;
                    while (i2 <= size) {
                        d2[i2] = v / d2[i2];
                        ++i2;
                    }
                } else {
                    int i3 = 1;
                    while (i3 <= size) {
                        if (!s2[i3]) {
                            d2[i3] = v / d2[i3];
                        }
                        ++i3;
                    }
                }
                return array;
            }
            double[] resultDatas = new double[size + 1];
            boolean[] resultSigns = null;
            if (s2 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = v / d2[i];
                    ++i;
                }
            } else {
                resultSigns = new boolean[size + 1];
                i = 1;
                while (i <= size) {
                    if (s2[i]) {
                        resultSigns[i] = true;
                    } else {
                        resultDatas[i] = v / d2[i];
                    }
                    ++i;
                }
            }
            DoubleArray result = new DoubleArray(resultDatas, resultSigns, size);
            result.setTemporary(true);
            return result;
        }
        if (data instanceof String) {
            int i;
            String str = (String)data;
            Object[] resultDatas = new Object[size + 1];
            if (s2 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = String.valueOf(str) + d2[i];
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    if (!s2[i]) {
                        resultDatas[i] = String.valueOf(str) + d2[i];
                    }
                    ++i;
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (data == null) {
            return new ConstArray(null, size);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(Variant.getDataType(data)) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illDivide"));
    }

    private ObjectArray memberDivide(ObjectArray array) {
        Object data = this.data;
        int size = this.size;
        Object[] datas = array.getDatas();
        if (array.isTemporary()) {
            int i = 1;
            while (i <= size) {
                datas[i] = Variant.divide(data, datas[i]);
                ++i;
            }
            return array;
        }
        Object[] resultDatas = new Object[size + 1];
        int i = 1;
        while (i <= size) {
            resultDatas[i] = Variant.divide(data, datas[i]);
            ++i;
        }
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    @Override
    public IArray memberMod(IArray array) {
        if (array instanceof IntArray) {
            return this.memberMod((IntArray)array);
        }
        if (array instanceof LongArray) {
            return this.memberMod((LongArray)array);
        }
        if (array instanceof DoubleArray) {
            return this.memberMod((DoubleArray)array);
        }
        if (array instanceof ConstArray) {
            Object value = ArrayUtil.mod(this.data, array.get(1));
            return new ConstArray(value, this.size);
        }
        if (array instanceof ObjectArray) {
            return this.memberMod((ObjectArray)array);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMod"));
    }

    private IArray memberMod(IntArray array) {
        Object data = this.data;
        int size = this.size;
        int[] d2 = array.getDatas();
        boolean[] s2 = array.getSigns();
        if (data instanceof Long) {
            int i;
            long v = ((Number)data).longValue();
            long[] resultDatas = new long[size + 1];
            boolean[] resultSigns = null;
            if (s2 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = v % (long)d2[i];
                    ++i;
                }
            } else {
                resultSigns = new boolean[size + 1];
                i = 1;
                while (i <= size) {
                    if (s2[i]) {
                        resultSigns[i] = true;
                    } else {
                        resultDatas[i] = v % (long)d2[i];
                    }
                    ++i;
                }
            }
            LongArray result = new LongArray(resultDatas, resultSigns, size);
            result.setTemporary(true);
            return result;
        }
        if (data instanceof Double || data instanceof Float) {
            int i;
            double v = ((Number)data).doubleValue();
            double[] resultDatas = new double[size + 1];
            boolean[] resultSigns = null;
            if (s2 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = v % (double)d2[i];
                    ++i;
                }
            } else {
                resultSigns = new boolean[size + 1];
                i = 1;
                while (i <= size) {
                    if (s2[i]) {
                        resultSigns[i] = true;
                    } else {
                        resultDatas[i] = v % (double)d2[i];
                    }
                    ++i;
                }
            }
            DoubleArray result = new DoubleArray(resultDatas, resultSigns, size);
            result.setTemporary(true);
            return result;
        }
        if (data instanceof BigDecimal || data instanceof BigInteger) {
            int i;
            BigInteger v = data instanceof BigDecimal ? ((BigDecimal)data).toBigInteger() : (BigInteger)data;
            Object[] resultDatas = new Object[size + 1];
            if (s2 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = new BigDecimal(v.mod(BigInteger.valueOf(d2[i])));
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    if (!s2[i]) {
                        resultDatas[i] = new BigDecimal(v.mod(BigInteger.valueOf(d2[i])));
                    }
                    ++i;
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (data instanceof Number) {
            int i;
            int v = ((Number)data).intValue();
            if (array.isTemporary()) {
                if (s2 == null) {
                    int i2 = 1;
                    while (i2 <= size) {
                        d2[i2] = v % d2[i2];
                        ++i2;
                    }
                } else {
                    int i3 = 1;
                    while (i3 <= size) {
                        if (!s2[i3]) {
                            d2[i3] = v % d2[i3];
                        }
                        ++i3;
                    }
                }
                return array;
            }
            int[] resultDatas = new int[size + 1];
            boolean[] resultSigns = null;
            if (s2 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = v % d2[i];
                    ++i;
                }
            } else {
                resultSigns = new boolean[size + 1];
                i = 1;
                while (i <= size) {
                    if (s2[i]) {
                        resultSigns[i] = true;
                    } else {
                        resultDatas[i] = v % d2[i];
                    }
                    ++i;
                }
            }
            IntArray result = new IntArray(resultDatas, resultSigns, size);
            result.setTemporary(true);
            return result;
        }
        if (data == null) {
            return new ConstArray(null, size);
        }
        if (data instanceof Sequence) {
            int i;
            Object[] resultDatas = new Object[size + 1];
            if (s2 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = ArrayUtil.mod(data, d2[i]);
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s2[i] ? data : ArrayUtil.mod(data, d2[i]);
                    ++i;
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(Variant.getDataType(data)) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMod"));
    }

    private IArray memberMod(LongArray array) {
        Object data = this.data;
        int size = this.size;
        long[] d2 = array.getDatas();
        boolean[] s2 = array.getSigns();
        if (data instanceof Double || data instanceof Float) {
            int i;
            double v = ((Number)data).doubleValue();
            double[] resultDatas = new double[size + 1];
            boolean[] resultSigns = null;
            if (s2 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = v % (double)d2[i];
                    ++i;
                }
            } else {
                resultSigns = new boolean[size + 1];
                i = 1;
                while (i <= size) {
                    if (s2[i]) {
                        resultSigns[i] = true;
                    } else {
                        resultDatas[i] = v % (double)d2[i];
                    }
                    ++i;
                }
            }
            DoubleArray result = new DoubleArray(resultDatas, resultSigns, size);
            result.setTemporary(true);
            return result;
        }
        if (data instanceof BigDecimal || data instanceof BigInteger) {
            int i;
            BigInteger v = data instanceof BigDecimal ? ((BigDecimal)data).toBigInteger() : (BigInteger)data;
            Object[] resultDatas = new Object[size + 1];
            if (s2 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = new BigDecimal(v.mod(BigInteger.valueOf(d2[i])));
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    if (!s2[i]) {
                        resultDatas[i] = new BigDecimal(v.mod(BigInteger.valueOf(d2[i])));
                    }
                    ++i;
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (data instanceof Number) {
            int i;
            long v = ((Number)data).longValue();
            if (array.isTemporary()) {
                if (s2 == null) {
                    int i2 = 1;
                    while (i2 <= size) {
                        d2[i2] = v % d2[i2];
                        ++i2;
                    }
                } else {
                    int i3 = 1;
                    while (i3 <= size) {
                        if (!s2[i3]) {
                            d2[i3] = v % d2[i3];
                        }
                        ++i3;
                    }
                }
                return array;
            }
            long[] resultDatas = new long[size + 1];
            boolean[] resultSigns = null;
            if (s2 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = v % d2[i];
                    ++i;
                }
            } else {
                resultSigns = new boolean[size + 1];
                i = 1;
                while (i <= size) {
                    if (s2[i]) {
                        resultSigns[i] = true;
                    } else {
                        resultDatas[i] = v % d2[i];
                    }
                    ++i;
                }
            }
            LongArray result = new LongArray(resultDatas, resultSigns, size);
            result.setTemporary(true);
            return result;
        }
        if (data == null) {
            return new ConstArray(null, size);
        }
        if (data instanceof Sequence) {
            int i;
            Object[] resultDatas = new Object[size + 1];
            if (s2 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = ArrayUtil.mod(data, d2[i]);
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s2[i] ? data : ArrayUtil.mod(data, d2[i]);
                    ++i;
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(Variant.getDataType(data)) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMod"));
    }

    private IArray memberMod(DoubleArray array) {
        Object data = this.data;
        int size = this.size;
        double[] d2 = array.getDatas();
        boolean[] s2 = array.getSigns();
        if (data instanceof BigDecimal || data instanceof BigInteger) {
            int i;
            BigInteger v = data instanceof BigDecimal ? ((BigDecimal)data).toBigInteger() : (BigInteger)data;
            Object[] resultDatas = new Object[size + 1];
            if (s2 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = new BigDecimal(v.mod(BigInteger.valueOf((long)d2[i])));
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    if (!s2[i]) {
                        resultDatas[i] = new BigDecimal(v.mod(BigInteger.valueOf((long)d2[i])));
                    }
                    ++i;
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (data instanceof Number) {
            int i;
            double v = ((Number)data).longValue();
            if (array.isTemporary()) {
                if (s2 == null) {
                    int i2 = 1;
                    while (i2 <= size) {
                        d2[i2] = v % d2[i2];
                        ++i2;
                    }
                } else {
                    int i3 = 1;
                    while (i3 <= size) {
                        if (!s2[i3]) {
                            d2[i3] = v % d2[i3];
                        }
                        ++i3;
                    }
                }
                return array;
            }
            double[] resultDatas = new double[size + 1];
            boolean[] resultSigns = null;
            if (s2 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = v % d2[i];
                    ++i;
                }
            } else {
                resultSigns = new boolean[size + 1];
                i = 1;
                while (i <= size) {
                    if (s2[i]) {
                        resultSigns[i] = true;
                    } else {
                        resultDatas[i] = v % d2[i];
                    }
                    ++i;
                }
            }
            DoubleArray result = new DoubleArray(resultDatas, resultSigns, size);
            result.setTemporary(true);
            return result;
        }
        if (data == null) {
            return new ConstArray(null, size);
        }
        if (data instanceof Sequence) {
            int i;
            Object[] resultDatas = new Object[size + 1];
            if (s2 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = ArrayUtil.mod(data, d2[i]);
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s2[i] ? data : ArrayUtil.mod(data, d2[i]);
                    ++i;
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(Variant.getDataType(data)) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMod"));
    }

    private IArray memberMod(ObjectArray array) {
        Object data = this.data;
        int size = this.size;
        Object[] datas = array.getDatas();
        if (array.isTemporary()) {
            int i = 1;
            while (i <= size) {
                datas[i] = ArrayUtil.mod(data, datas[i]);
                ++i;
            }
            return array;
        }
        Object[] resultDatas = new Object[size + 1];
        int i = 1;
        while (i <= size) {
            resultDatas[i] = ArrayUtil.mod(data, datas[i]);
            ++i;
        }
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    @Override
    public IArray memberIntDivide(IArray array) {
        if (array instanceof IntArray) {
            return this.memberIntDivide((IntArray)array);
        }
        if (array instanceof LongArray) {
            return this.memberIntDivide((LongArray)array);
        }
        if (array instanceof DoubleArray) {
            return this.memberIntDivide((DoubleArray)array);
        }
        if (array instanceof ConstArray) {
            Object value = ArrayUtil.intDivide(this.data, array.get(1));
            return new ConstArray(value, this.size);
        }
        if (array instanceof ObjectArray) {
            return this.memberIntDivide((ObjectArray)array);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illDivide"));
    }

    private IArray memberIntDivide(IntArray array) {
        Object data = this.data;
        int size = this.size;
        int[] d2 = array.getDatas();
        boolean[] s2 = array.getSigns();
        if (data instanceof Long || data instanceof Double || data instanceof Float) {
            int i;
            long v = ((Number)data).longValue();
            long[] resultDatas = new long[size + 1];
            boolean[] resultSigns = null;
            if (s2 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = v / (long)d2[i];
                    ++i;
                }
            } else {
                resultSigns = new boolean[size + 1];
                i = 1;
                while (i <= size) {
                    if (s2[i]) {
                        resultSigns[i] = true;
                    } else {
                        resultDatas[i] = v / (long)d2[i];
                    }
                    ++i;
                }
            }
            LongArray result = new LongArray(resultDatas, resultSigns, size);
            result.setTemporary(true);
            return result;
        }
        if (data instanceof BigDecimal || data instanceof BigInteger) {
            int i;
            BigInteger v = data instanceof BigDecimal ? ((BigDecimal)data).toBigInteger() : (BigInteger)data;
            Object[] resultDatas = new Object[size + 1];
            if (s2 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = new BigDecimal(v.divide(BigInteger.valueOf(d2[i])));
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    if (!s2[i]) {
                        resultDatas[i] = new BigDecimal(v.divide(BigInteger.valueOf(d2[i])));
                    }
                    ++i;
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (data instanceof Number) {
            int i;
            int v = ((Number)data).intValue();
            if (array.isTemporary()) {
                if (s2 == null) {
                    int i2 = 1;
                    while (i2 <= size) {
                        d2[i2] = v / d2[i2];
                        ++i2;
                    }
                } else {
                    int i3 = 1;
                    while (i3 <= size) {
                        if (!s2[i3]) {
                            d2[i3] = v / d2[i3];
                        }
                        ++i3;
                    }
                }
                return array;
            }
            int[] resultDatas = new int[size + 1];
            boolean[] resultSigns = null;
            if (s2 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = v / d2[i];
                    ++i;
                }
            } else {
                resultSigns = new boolean[size + 1];
                i = 1;
                while (i <= size) {
                    if (s2[i]) {
                        resultSigns[i] = true;
                    } else {
                        resultDatas[i] = v / d2[i];
                    }
                    ++i;
                }
            }
            IntArray result = new IntArray(resultDatas, resultSigns, size);
            result.setTemporary(true);
            return result;
        }
        if (data == null) {
            return new ConstArray(null, size);
        }
        if (data instanceof Sequence) {
            int i;
            Sequence seq1 = (Sequence)data;
            Object[] resultDatas = new Object[size + 1];
            if (s2 == null) {
                i = 1;
                while (i <= size) {
                    Sequence seq2 = new Sequence(1);
                    seq2.add(d2[i]);
                    resultDatas[i] = seq1.diff(seq2, false);
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    if (s2[i]) {
                        resultDatas[i] = seq1;
                    } else {
                        Sequence seq2 = new Sequence(1);
                        seq2.add(d2[i]);
                        resultDatas[i] = seq1.diff(seq2, false);
                    }
                    ++i;
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(Variant.getDataType(data)) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illDivide"));
    }

    private IArray memberIntDivide(LongArray array) {
        Object data = this.data;
        int size = this.size;
        long[] d2 = array.getDatas();
        boolean[] s2 = array.getSigns();
        if (data instanceof BigDecimal || data instanceof BigInteger) {
            int i;
            BigInteger v = data instanceof BigDecimal ? ((BigDecimal)data).toBigInteger() : (BigInteger)data;
            Object[] resultDatas = new Object[size + 1];
            if (s2 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = new BigDecimal(v.divide(BigInteger.valueOf(d2[i])));
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    if (!s2[i]) {
                        resultDatas[i] = new BigDecimal(v.divide(BigInteger.valueOf(d2[i])));
                    }
                    ++i;
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (data instanceof Number) {
            int i;
            long v = ((Number)data).longValue();
            if (array.isTemporary()) {
                if (s2 == null) {
                    int i2 = 1;
                    while (i2 <= size) {
                        d2[i2] = v / d2[i2];
                        ++i2;
                    }
                } else {
                    int i3 = 1;
                    while (i3 <= size) {
                        if (!s2[i3]) {
                            d2[i3] = v / d2[i3];
                        }
                        ++i3;
                    }
                }
                return array;
            }
            long[] resultDatas = new long[size + 1];
            boolean[] resultSigns = null;
            if (s2 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = v / d2[i];
                    ++i;
                }
            } else {
                resultSigns = new boolean[size + 1];
                i = 1;
                while (i <= size) {
                    if (s2[i]) {
                        resultSigns[i] = true;
                    } else {
                        resultDatas[i] = v / d2[i];
                    }
                    ++i;
                }
            }
            LongArray result = new LongArray(resultDatas, resultSigns, size);
            result.setTemporary(true);
            return result;
        }
        if (data == null) {
            return new ConstArray(null, size);
        }
        if (data instanceof Sequence) {
            int i;
            Sequence seq1 = (Sequence)data;
            Object[] resultDatas = new Object[size + 1];
            if (s2 == null) {
                i = 1;
                while (i <= size) {
                    Sequence seq2 = new Sequence(1);
                    seq2.add(d2[i]);
                    resultDatas[i] = seq1.diff(seq2, false);
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    if (s2[i]) {
                        resultDatas[i] = seq1;
                    } else {
                        Sequence seq2 = new Sequence(1);
                        seq2.add(d2[i]);
                        resultDatas[i] = seq1.diff(seq2, false);
                    }
                    ++i;
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(Variant.getDataType(data)) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illDivide"));
    }

    private IArray memberIntDivide(DoubleArray array) {
        Object data = this.data;
        int size = this.size;
        double[] d2 = array.getDatas();
        boolean[] s2 = array.getSigns();
        if (data instanceof BigDecimal || data instanceof BigInteger) {
            int i;
            BigInteger v = data instanceof BigDecimal ? ((BigDecimal)data).toBigInteger() : (BigInteger)data;
            Object[] resultDatas = new Object[size + 1];
            if (s2 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = new BigDecimal(v.divide(BigInteger.valueOf((long)d2[i])));
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    if (!s2[i]) {
                        resultDatas[i] = new BigDecimal(v.divide(BigInteger.valueOf((long)d2[i])));
                    }
                    ++i;
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (data instanceof Number) {
            int i;
            long v = ((Number)data).longValue();
            long[] resultDatas = new long[size + 1];
            boolean[] resultSigns = null;
            if (s2 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = v / (long)d2[i];
                    ++i;
                }
            } else {
                resultSigns = new boolean[size + 1];
                i = 1;
                while (i <= size) {
                    if (s2[i]) {
                        resultSigns[i] = true;
                    } else {
                        resultDatas[i] = v / (long)d2[i];
                    }
                    ++i;
                }
            }
            LongArray result = new LongArray(resultDatas, resultSigns, size);
            result.setTemporary(true);
            return result;
        }
        if (data == null) {
            return new ConstArray(null, size);
        }
        if (data instanceof Sequence) {
            int i;
            Sequence seq1 = (Sequence)data;
            Object[] resultDatas = new Object[size + 1];
            if (s2 == null) {
                i = 1;
                while (i <= size) {
                    Sequence seq2 = new Sequence(1);
                    seq2.add(d2[i]);
                    resultDatas[i] = seq1.diff(seq2, false);
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    if (s2[i]) {
                        resultDatas[i] = seq1;
                    } else {
                        Sequence seq2 = new Sequence(1);
                        seq2.add(d2[i]);
                        resultDatas[i] = seq1.diff(seq2, false);
                    }
                    ++i;
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(Variant.getDataType(data)) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illDivide"));
    }

    private IArray memberIntDivide(ObjectArray array) {
        Object data = this.data;
        int size = this.size;
        Object[] datas = array.getDatas();
        if (array.isTemporary()) {
            int i = 1;
            while (i <= size) {
                datas[i] = ArrayUtil.intDivide(data, datas[i]);
                ++i;
            }
            return array;
        }
        Object[] resultDatas = new Object[size + 1];
        int i = 1;
        while (i <= size) {
            resultDatas[i] = ArrayUtil.intDivide(data, datas[i]);
            ++i;
        }
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    @Override
    public BoolArray calcRelation(IArray array, int relation) {
        return array.calcRelation(this.data, Relation.getInverseRelation(relation));
    }

    @Override
    public BoolArray calcRelation(Object value, int relation) {
        boolean result = relation == 1 ? Variant.compare(this.data, value, true) == 0 : (relation == 2 ? Variant.compare(this.data, value, true) > 0 : (relation == 3 ? Variant.compare(this.data, value, true) >= 0 : (relation == 4 ? Variant.compare(this.data, value, true) < 0 : (relation == 5 ? Variant.compare(this.data, value, true) <= 0 : (relation == 6 ? Variant.compare(this.data, value, true) != 0 : (relation == 7 ? Variant.isTrue(this.data) && Variant.isTrue(value) : Variant.isTrue(this.data) || Variant.isTrue(value)))))));
        return new BoolArray(result, this.size);
    }

    @Override
    public int compareTo(IArray array) {
        if (array instanceof ConstArray) {
            int cmp = Variant.compare(this.data, array.get(1), true);
            if (cmp != 0) {
                return cmp;
            }
            if (this.size == array.size()) {
                return 0;
            }
            if (this.size < array.size()) {
                return -1;
            }
            return 1;
        }
        return -array.compareTo(this);
    }

    @Override
    public int memberCompare(int index1, int index2) {
        return 0;
    }

    @Override
    public boolean isMemberEquals(int index1, int index2) {
        return true;
    }

    @Override
    public boolean isEquals(int curIndex, IArray array, int index) {
        return Variant.isEquals(this.data, array.get(index));
    }

    @Override
    public boolean isEquals(int curIndex, Object value) {
        return Variant.isEquals(this.data, value);
    }

    @Override
    public int compareTo(int curIndex, IArray array, int index) {
        return Variant.compare(this.data, array.get(index), true);
    }

    @Override
    public int compareTo(int curIndex, Object value) {
        return Variant.compare(this.data, value, true);
    }

    @Override
    public int hashCode(int index) {
        if (this.data != null) {
            return this.data.hashCode();
        }
        return 0;
    }

    @Override
    public Object sum() {
        if (this.data instanceof Number) {
            return Variant.multiply(this.data, this.size);
        }
        return null;
    }

    @Override
    public Object average() {
        if (this.data instanceof Number) {
            if (this.data instanceof BigDecimal || this.data instanceof Double) {
                return this.data;
            }
            if (this.data instanceof BigInteger) {
                return new BigDecimal((BigInteger)this.data);
            }
            return ((Number)this.data).doubleValue();
        }
        return null;
    }

    @Override
    public Object max() {
        return this.data;
    }

    @Override
    public Object min() {
        return this.data;
    }

    @Override
    public void calcRelations(IArray array, int relation, BoolArray result, boolean isAnd) {
        array.calcRelations(this.data, Relation.getInverseRelation(relation), result, isAnd);
    }

    @Override
    public void calcRelations(Object value, int relation, BoolArray result, boolean isAnd) {
        block15: {
            boolean b;
            block14: {
                boolean[] resultDatas = result.getDatas();
                if (relation == 1) {
                    b = Variant.compare(this.data, value, true) == 0;
                } else if (relation == 2) {
                    b = Variant.compare(this.data, value, true) > 0;
                } else if (relation == 3) {
                    b = Variant.compare(this.data, value, true) >= 0;
                } else if (relation == 4) {
                    b = Variant.compare(this.data, value, true) < 0;
                } else if (relation == 5) {
                    b = Variant.compare(this.data, value, true) <= 0;
                } else if (relation == 6) {
                    b = Variant.compare(this.data, value, true) != 0;
                } else {
                    throw new RuntimeException();
                }
                if (!isAnd || b) break block14;
                int i = 1;
                while (i <= this.size) {
                    resultDatas[i] = false;
                    ++i;
                }
                break block15;
            }
            if (isAnd || !b) break block15;
            int i = 1;
            while (i <= this.size) {
                resultDatas[i] = true;
                ++i;
            }
        }
    }

    @Override
    public IArray bitwiseAnd(IArray array) {
        if (array instanceof ConstArray) {
            Object value = And.and(this.data, array.get(1));
            return new ConstArray(value, this.size);
        }
        return array.bitwiseAnd(this);
    }

    @Override
    public IArray bitwiseOr(IArray array) {
        if (array instanceof ConstArray) {
            Object value = Or.or(this.data, array.get(1));
            return new ConstArray(value, this.size);
        }
        return array.bitwiseOr(this);
    }

    @Override
    public IArray bitwiseXOr(IArray array) {
        if (array instanceof ConstArray) {
            Object value = Xor.xor(this.data, array.get(1));
            return new ConstArray(value, this.size);
        }
        return array.bitwiseXOr(this);
    }

    @Override
    public IArray bitwiseNot() {
        if (this.data instanceof BigDecimal) {
            BigInteger bi = ((BigDecimal)this.data).toBigInteger().not();
            return new ConstArray(bi, this.size);
        }
        if (this.data instanceof BigInteger) {
            BigInteger bi = ((BigInteger)this.data).not();
            return new ConstArray(bi, this.size);
        }
        if (this.data instanceof Number) {
            long v = ((Number)this.data).longValue() ^ 0xFFFFFFFFFFFFFFFFL;
            return new ConstArray(v, this.size);
        }
        if (this.data == null) {
            return new ConstArray(null, this.size);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("not" + mm.getMessage("function.paramTypeError"));
    }

    @Override
    public IArray select(IArray signArray) {
        int size = signArray.size();
        int count = 0;
        if (signArray instanceof BoolArray) {
            BoolArray array = (BoolArray)signArray;
            boolean[] d2 = array.getDatas();
            boolean[] s2 = array.getSigns();
            if (s2 == null) {
                int i = 1;
                while (i <= size) {
                    if (d2[i]) {
                        ++count;
                    }
                    ++i;
                }
            } else {
                int i = 1;
                while (i <= size) {
                    if (!s2[i] && d2[i]) {
                        ++count;
                    }
                    ++i;
                }
            }
        } else {
            int i = 1;
            while (i <= size) {
                if (signArray.isTrue(i)) {
                    ++count;
                }
                ++i;
            }
        }
        return new ConstArray(this.data, count);
    }

    @Override
    public IArray select(int start, int end, IArray signArray) {
        int count = 0;
        if (signArray instanceof BoolArray) {
            BoolArray array = (BoolArray)signArray;
            boolean[] d2 = array.getDatas();
            boolean[] s2 = array.getSigns();
            if (s2 == null) {
                int i = start;
                while (i < end) {
                    if (d2[i]) {
                        ++count;
                    }
                    ++i;
                }
            } else {
                int i = start;
                while (i < end) {
                    if (!s2[i] && d2[i]) {
                        ++count;
                    }
                    ++i;
                }
            }
        } else {
            int i = start;
            while (i < end) {
                if (signArray.isTrue(i)) {
                    ++count;
                }
                ++i;
            }
        }
        return new ConstArray(this.data, count);
    }

    @Override
    public IArray memberAdd(int curIndex, IArray array, int index) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illAdd"));
    }

    @Override
    public Object[] toArray() {
        int size = this.size;
        Object data = this.data;
        Object[] result = new Object[size];
        int i = 0;
        while (i < size) {
            result[i] = data;
            ++i;
        }
        return result;
    }

    @Override
    public void toArray(Object[] result) {
        int size = this.size;
        Object data = this.data;
        int i = 0;
        while (i < size) {
            result[i] = data;
            ++i;
        }
    }

    @Override
    public IArray split(int pos) {
        int resultSize = this.size - pos + 1;
        this.size = pos - 1;
        return new ConstArray(this.data, resultSize);
    }

    @Override
    public IArray split(int from, int to) {
        int resultSize = to - from + 1;
        this.size -= resultSize;
        return new ConstArray(this.data, resultSize);
    }

    @Override
    public void sort() {
    }

    @Override
    public void sort(Comparator<Object> comparator) {
    }

    @Override
    public boolean hasRecord() {
        return this.data instanceof BaseRecord;
    }

    @Override
    public boolean isPmt(boolean isPure) {
        return this.data instanceof BaseRecord;
    }

    @Override
    public IArray rvs() {
        return new ConstArray(this.data, this.size);
    }

    @Override
    public IntArray ptop(int count, boolean isAll, boolean isLast, boolean ignoreNull) {
        if (this.size == 0 || this.data == null && ignoreNull) {
            return new IntArray(0);
        }
        if (count == 1 || count == -1) {
            if (isAll) {
                return new IntArray(1, this.size);
            }
            if (isLast) {
                IntArray result = new IntArray(1);
                result.pushInt(this.size);
                return result;
            }
            IntArray result = new IntArray(1);
            result.pushInt(1);
            return result;
        }
        if (count > 1) {
            return new IntArray(1, count);
        }
        if (count < -1) {
            return new IntArray(1, -count);
        }
        return new IntArray(1);
    }

    @Override
    public IntArray ptopRank(int count, boolean ignoreNull, boolean iopt) {
        if (this.size == 0 || this.data == null && ignoreNull) {
            return new IntArray(0);
        }
        return new IntArray(1, this.size);
    }

    @Override
    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public ObjectArray toObjectArray() {
        int size = this.size;
        Object data = this.data;
        Object[] resultDatas = new Object[size + 1];
        int i = 1;
        while (i <= size) {
            resultDatas[i] = data;
            ++i;
        }
        return new ObjectArray(resultDatas, size);
    }

    @Override
    public IArray toPureArray() {
        int size = this.size;
        Object data = this.data;
        if (data instanceof String) {
            String str = (String)data;
            String[] resultDatas = new String[size + 1];
            int i = 1;
            while (i <= size) {
                resultDatas[i] = str;
                ++i;
            }
            return new StringArray(resultDatas, size);
        }
        if (data instanceof Date) {
            Date date = (Date)data;
            Date[] resultDatas = new Date[size + 1];
            int i = 1;
            while (i <= size) {
                resultDatas[i] = date;
                ++i;
            }
            return new DateArray(resultDatas, size);
        }
        if (data instanceof Double) {
            double d = (Double)data;
            double[] resultDatas = new double[size + 1];
            int i = 1;
            while (i <= size) {
                resultDatas[i] = d;
                ++i;
            }
            return new DoubleArray(resultDatas, null, size);
        }
        if (data instanceof Long) {
            long d = (Long)data;
            long[] resultDatas = new long[size + 1];
            int i = 1;
            while (i <= size) {
                resultDatas[i] = d;
                ++i;
            }
            return new LongArray(resultDatas, null, size);
        }
        if (data instanceof Integer) {
            int n = (Integer)data;
            int[] resultDatas = new int[size + 1];
            int i = 1;
            while (i <= size) {
                resultDatas[i] = n;
                ++i;
            }
            return new IntArray(resultDatas, null, size);
        }
        if (data instanceof Boolean) {
            return new BoolArray((Boolean)data, size);
        }
        if (data == null) {
            Object[] resultDatas = new Object[size + 1];
            return new ObjectArray(resultDatas, size);
        }
        Object[] resultDatas = new Object[size + 1];
        int i = 1;
        while (i <= size) {
            resultDatas[i] = data;
            ++i;
        }
        return new ObjectArray(resultDatas, size);
    }

    @Override
    public IArray reserve(boolean refOrigin) {
        return this.toPureArray();
    }

    @Override
    public IArray combine(IArray signArray, IArray other) {
        if (other instanceof ConstArray) {
            return this.combine(signArray, ((ConstArray)other).getData());
        }
        return other.combine((IArray)signArray.isFalse(), this.data);
    }

    @Override
    public IArray combine(IArray signArray, Object value) {
        int size = this.size;
        Object data = this.data;
        Object[] resultDatas = new Object[size + 1];
        int i = 1;
        while (i <= size) {
            resultDatas[i] = signArray.isTrue(i) ? data : value;
            ++i;
        }
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    @Override
    public Object pos(IArray array, String opt) {
        return ArrayUtil.pos(this, array, opt);
    }

    @Override
    public int bit1() {
        MessageManager mm = EngineMessage.get();
        throw new RQException("bit1" + mm.getMessage("function.paramTypeError"));
    }

    @Override
    public int bit1(IArray array) {
        int count = 0;
        Object data = this.data;
        int i = 1;
        while (i <= this.size) {
            count += Bit1.bitCount(data, array.get(i));
            ++i;
        }
        return count;
    }

    @Override
    public int getNextEqualCount(int index) {
        return this.size - index + 1;
    }
}

