/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.array;

import com.scudata.array.ArrayUtil;
import com.scudata.array.BoolArray;
import com.scudata.array.ConstArray;
import com.scudata.array.DateArray;
import com.scudata.array.DoubleArray;
import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.array.NumberArray;
import com.scudata.array.ObjectArray;
import com.scudata.array.StringArray;
import com.scudata.common.ByteArrayInputRecord;
import com.scudata.common.ByteArrayOutputRecord;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Sequence;
import com.scudata.expression.Relation;
import com.scudata.expression.fn.math.Bit1;
import com.scudata.resources.EngineMessage;
import com.scudata.thread.MultithreadUtil;
import com.scudata.util.Variant;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.Date;

public class LongArray
implements NumberArray {
    private static final long serialVersionUID = 1L;
    private static final byte NULL_SIGN = 60;
    private long[] datas;
    private boolean[] signs;
    private int size;

    public LongArray() {
        this.datas = new long[8];
    }

    public LongArray(int initialCapacity) {
        this.datas = new long[++initialCapacity];
    }

    public LongArray(long[] datas, boolean[] signs, int size) {
        this.datas = datas;
        this.signs = signs;
        this.size = size;
    }

    public static int compare(long n1, long n2) {
        return n1 < n2 ? -1 : (n1 > n2 ? 1 : 0);
    }

    private static int compare(long n1, Object o2) {
        if (o2 instanceof Integer || o2 instanceof Long) {
            long n2 = ((Number)o2).longValue();
            return n1 < n2 ? -1 : (n1 > n2 ? 1 : 0);
        }
        if (o2 instanceof BigDecimal) {
            return new BigDecimal(n1).compareTo((BigDecimal)o2);
        }
        if (o2 instanceof BigInteger) {
            return BigInteger.valueOf(n1).compareTo((BigInteger)o2);
        }
        if (o2 instanceof Number) {
            return Double.compare(n1, ((Number)o2).doubleValue());
        }
        if (o2 == null) {
            return 1;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("Variant2.illCompare", n1, o2, mm.getMessage("DataType.Long"), Variant.getDataType(o2)));
    }

    public long[] getDatas() {
        return this.datas;
    }

    public boolean[] getSigns() {
        return this.signs;
    }

    public void setSigns(boolean[] signs) {
        this.signs = signs;
    }

    @Override
    public String getDataType() {
        MessageManager mm = EngineMessage.get();
        return mm.getMessage("DataType.Long");
    }

    @Override
    public IArray dup() {
        int len = this.size + 1;
        long[] newDatas = new long[len];
        System.arraycopy(this.datas, 0, newDatas, 0, len);
        boolean[] newSigns = null;
        if (this.signs != null) {
            newSigns = new boolean[len];
            System.arraycopy(this.signs, 0, newSigns, 0, len);
        }
        return new LongArray(newDatas, newSigns, this.size);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int size = this.size;
        long[] datas = this.datas;
        boolean[] signs = this.signs;
        if (signs == null) {
            out.writeByte(1);
        } else {
            out.writeByte(61);
        }
        out.writeInt(size);
        int i = 1;
        while (i <= size) {
            out.writeLong(datas[i]);
            ++i;
        }
        if (signs != null) {
            i = 1;
            while (i <= size) {
                out.writeBoolean(signs[i]);
                ++i;
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte sign = in.readByte();
        this.size = in.readInt();
        int len = this.size + 1;
        this.datas = new long[len];
        long[] datas = this.datas;
        int i = 1;
        while (i < len) {
            datas[i] = in.readLong();
            ++i;
        }
        if (sign > 60) {
            this.signs = new boolean[len];
            boolean[] signs = this.signs;
            int i2 = 1;
            while (i2 < len) {
                signs[i2] = in.readBoolean();
                ++i2;
            }
        }
    }

    @Override
    public byte[] serialize() throws IOException {
        ByteArrayOutputRecord out = new ByteArrayOutputRecord();
        int size = this.size;
        long[] datas = this.datas;
        boolean[] signs = this.signs;
        if (signs == null) {
            out.writeByte(1);
        } else {
            out.writeByte(61);
        }
        out.writeInt(size);
        int i = 1;
        while (i <= size) {
            out.writeLong(datas[i]);
            ++i;
        }
        if (signs != null) {
            i = 1;
            while (i <= size) {
                out.writeBoolean(signs[i]);
                ++i;
            }
        }
        return out.toByteArray();
    }

    @Override
    public void fillRecord(byte[] buf) throws IOException, ClassNotFoundException {
        ByteArrayInputRecord in = new ByteArrayInputRecord(buf);
        byte sign = in.readByte();
        this.size = in.readInt();
        int len = this.size + 1;
        this.datas = new long[len];
        long[] datas = this.datas;
        int i = 1;
        while (i < len) {
            datas[i] = in.readLong();
            ++i;
        }
        if (sign > 60) {
            this.signs = new boolean[len];
            boolean[] signs = this.signs;
            int i2 = 1;
            while (i2 < len) {
                signs[i2] = in.readBoolean();
                ++i2;
            }
        }
    }

    @Override
    public IArray newInstance(int count) {
        return new LongArray(count);
    }

    @Override
    public void add(Object o) {
        if (o instanceof Long || o instanceof Integer) {
            this.ensureCapacity(this.size + 1);
            this.datas[++this.size] = ((Number)o).longValue();
        } else if (o == null) {
            this.ensureCapacity(this.size + 1);
            if (this.signs == null) {
                this.signs = new boolean[this.datas.length];
            }
            this.signs[++this.size] = true;
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.Long"), Variant.getDataType(o)));
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void addAll(IArray array) {
        block15: {
            block16: {
                size2 = array.size();
                if (size2 == 0) break block15;
                if (!(array instanceof LongArray)) break block16;
                longArray = (LongArray)array;
                this.ensureCapacity(this.size + size2);
                System.arraycopy(longArray.datas, 1, this.datas, this.size + 1, size2);
                if (longArray.signs != null) {
                    if (this.signs == null) {
                        this.signs = new boolean[this.datas.length];
                    }
                    System.arraycopy(longArray.signs, 1, this.signs, this.size + 1, size2);
                }
                this.size += size2;
                break block15;
            }
            if (!(array instanceof ConstArray)) ** GOTO lbl39
            obj = array.get(1);
            if (obj instanceof Long) {
                this.ensureCapacity(this.size + size2);
                v = ((Number)obj).longValue();
                datas = this.datas;
                i = 0;
                while (i < size2) {
                    datas[++this.size] = v;
                    ++i;
                }
            } else if (obj == null) {
                this.ensureCapacity(this.size + size2);
                signs = this.signs;
                if (signs == null) {
                    this.signs = signs = new boolean[this.datas.length];
                }
                i = 0;
                while (i < size2) {
                    signs[++this.size] = true;
                    ++i;
                }
            } else {
                mm = EngineMessage.get();
                throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.Long"), array.getDataType()));
lbl39:
                // 1 sources

                this.ensureCapacity(this.size + size2);
                datas = this.datas;
                i = 1;
                while (i <= size2) {
                    obj = array.get(i);
                    if (obj instanceof Long) {
                        datas[++this.size] = (Long)obj;
                    } else if (obj == null) {
                        if (this.signs == null) {
                            this.signs = new boolean[datas.length];
                        }
                        this.signs[++this.size] = true;
                    } else {
                        mm = EngineMessage.get();
                        throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.Long"), Variant.getDataType(obj)));
                    }
                    ++i;
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void addAll(IArray array, int count) {
        block15: {
            block16: {
                if (count == 0) break block15;
                if (!(array instanceof LongArray)) break block16;
                longArray = (LongArray)array;
                this.ensureCapacity(this.size + count);
                System.arraycopy(longArray.datas, 1, this.datas, this.size + 1, count);
                if (longArray.signs != null) {
                    if (this.signs == null) {
                        this.signs = new boolean[this.datas.length];
                    }
                    System.arraycopy(longArray.signs, 1, this.signs, this.size + 1, count);
                }
                this.size += count;
                break block15;
            }
            if (!(array instanceof ConstArray)) ** GOTO lbl38
            obj = array.get(1);
            if (obj instanceof Long) {
                this.ensureCapacity(this.size + count);
                v = ((Number)obj).longValue();
                datas = this.datas;
                i = 0;
                while (i < count) {
                    datas[++this.size] = v;
                    ++i;
                }
            } else if (obj == null) {
                this.ensureCapacity(this.size + count);
                signs = this.signs;
                if (signs == null) {
                    this.signs = signs = new boolean[this.datas.length];
                }
                i = 0;
                while (i < count) {
                    signs[++this.size] = true;
                    ++i;
                }
            } else {
                mm = EngineMessage.get();
                throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.Long"), array.getDataType()));
lbl38:
                // 1 sources

                this.ensureCapacity(this.size + count);
                datas = this.datas;
                i = 1;
                while (i <= count) {
                    obj = array.get(i);
                    if (obj instanceof Long) {
                        datas[++this.size] = (Long)obj;
                    } else if (obj == null) {
                        if (this.signs == null) {
                            this.signs = new boolean[datas.length];
                        }
                        this.signs[++this.size] = true;
                    } else {
                        mm = EngineMessage.get();
                        throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.Long"), Variant.getDataType(obj)));
                    }
                    ++i;
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void addAll(IArray array, int index, int count) {
        block10: {
            block9: {
                if (!(array instanceof LongArray)) break block9;
                longArray = (LongArray)array;
                this.ensureCapacity(this.size + count);
                System.arraycopy(longArray.datas, index, this.datas, this.size + 1, count);
                if (longArray.signs != null) {
                    if (this.signs == null) {
                        this.signs = new boolean[this.datas.length];
                    }
                    System.arraycopy(longArray.signs, index, this.signs, this.size + 1, count);
                }
                this.size += count;
                break block10;
            }
            if (!(array instanceof ConstArray)) ** GOTO lbl37
            obj = array.get(1);
            if (obj instanceof Long) {
                this.ensureCapacity(this.size + count);
                v = ((Number)obj).longValue();
                datas = this.datas;
                i = 0;
                while (i < count) {
                    datas[++this.size] = v;
                    ++i;
                }
            } else if (obj == null) {
                this.ensureCapacity(this.size + count);
                signs = this.signs;
                if (signs == null) {
                    this.signs = signs = new boolean[this.datas.length];
                }
                i = 0;
                while (i < count) {
                    signs[++this.size] = true;
                    ++i;
                }
            } else {
                mm = EngineMessage.get();
                throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.Long"), array.getDataType()));
lbl37:
                // 1 sources

                mm = EngineMessage.get();
                throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.Long"), array.getDataType()));
            }
        }
    }

    @Override
    public void addAll(Object[] array) {
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj != null && !(obj instanceof Long)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.Long"), Variant.getDataType(obj)));
            }
            ++n2;
        }
        int size2 = array.length;
        this.ensureCapacity(this.size + size2);
        long[] datas = this.datas;
        boolean[] signs = this.signs;
        int i = 0;
        while (i < size2) {
            if (array[i] != null) {
                datas[++this.size] = ((Number)array[i]).longValue();
            } else {
                if (signs == null) {
                    this.signs = signs = new boolean[datas.length];
                }
                signs[++this.size] = true;
            }
            ++i;
        }
    }

    @Override
    public void insert(int index, Object o) {
        if (o instanceof Long) {
            this.ensureCapacity(this.size + 1);
            ++this.size;
            System.arraycopy(this.datas, index, this.datas, index + 1, this.size - index);
            this.datas[index] = ((Long)o).intValue();
            if (this.signs != null) {
                System.arraycopy(this.signs, index, this.signs, index + 1, this.size - index);
                this.signs[index] = false;
            }
        } else if (o == null) {
            this.ensureCapacity(this.size + 1);
            ++this.size;
            System.arraycopy(this.datas, index, this.datas, index + 1, this.size - index);
            if (this.signs == null) {
                this.signs = new boolean[this.datas.length];
            } else {
                System.arraycopy(this.signs, index, this.signs, index + 1, this.size - index);
            }
            this.datas[index] = 0L;
            this.signs[index] = true;
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.Long"), Variant.getDataType(o)));
        }
    }

    public void insertLong(int index, long o) {
        this.ensureCapacity(this.size + 1);
        ++this.size;
        System.arraycopy(this.datas, index, this.datas, index + 1, this.size - index);
        this.datas[index] = o;
        if (this.signs != null) {
            System.arraycopy(this.signs, index, this.signs, index + 1, this.size - index);
            this.signs[index] = false;
        }
    }

    @Override
    public void insertAll(int pos, IArray array) {
        if (array instanceof LongArray) {
            int numNew = array.size();
            LongArray longArray = (LongArray)array;
            this.ensureCapacity(this.size + numNew);
            System.arraycopy(this.datas, pos, this.datas, pos + numNew, this.size - pos + 1);
            if (this.signs != null) {
                System.arraycopy(this.signs, pos, this.signs, pos + numNew, this.size - pos + 1);
            }
            System.arraycopy(longArray.datas, 1, this.datas, pos, numNew);
            if (longArray.signs == null) {
                if (this.signs != null) {
                    boolean[] signs = this.signs;
                    int i = 0;
                    while (i < numNew) {
                        signs[pos + i] = false;
                        ++i;
                    }
                }
            } else {
                if (this.signs == null) {
                    this.signs = new boolean[this.datas.length];
                }
                System.arraycopy(longArray.signs, 1, this.signs, pos, numNew);
            }
            this.size += numNew;
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.Long"), array.getDataType()));
        }
    }

    @Override
    public void insertAll(int pos, Object[] array) {
        boolean containNull = false;
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj == null) {
                containNull = true;
            } else if (!(obj instanceof Long)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.Long"), Variant.getDataType(obj)));
            }
            ++n2;
        }
        int numNew = array.length;
        this.ensureCapacity(this.size + numNew);
        long[] datas = this.datas;
        boolean[] signs = this.signs;
        System.arraycopy(datas, pos, datas, pos + numNew, this.size - pos + 1);
        if (signs != null) {
            System.arraycopy(signs, pos, signs, pos + numNew, this.size - pos + 1);
        }
        if (containNull) {
            if (signs == null) {
                this.signs = signs = new boolean[datas.length];
            }
            int i = 0;
            while (i < numNew) {
                if (array[i] == null) {
                    signs[pos + i] = true;
                } else {
                    datas[pos + i] = (Long)array[i];
                    signs[pos + i] = false;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < numNew) {
                datas[pos + i] = (Long)array[i];
                if (signs != null) {
                    signs[pos + i] = false;
                }
                ++i;
            }
        }
        this.size += numNew;
    }

    @Override
    public void push(Object o) {
        if (o instanceof Long) {
            this.datas[++this.size] = (Long)o;
        } else if (o == null) {
            if (this.signs == null) {
                this.signs = new boolean[this.datas.length];
            }
            this.signs[++this.size] = true;
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.Long"), Variant.getDataType(o)));
        }
    }

    @Override
    public void push(IArray array, int index) {
        if (array instanceof LongArray) {
            if (array.isNull(index)) {
                if (this.signs == null) {
                    this.signs = new boolean[this.datas.length];
                }
                this.signs[++this.size] = true;
            } else {
                this.datas[++this.size] = ((LongArray)array).getLong(index);
            }
        } else {
            this.push(array.get(index));
        }
    }

    @Override
    public void add(IArray array, int index) {
        if (array.isNull(index)) {
            this.ensureCapacity(this.size + 1);
            if (this.signs == null) {
                this.signs = new boolean[this.datas.length];
            }
            this.signs[++this.size] = true;
        } else if (array instanceof LongArray || array instanceof IntArray) {
            this.ensureCapacity(this.size + 1);
            this.datas[++this.size] = array.getLong(index);
        } else {
            this.add(array.get(index));
        }
    }

    @Override
    public void set(int curIndex, IArray array, int index) {
        if (array.isNull(index)) {
            if (this.signs == null) {
                this.signs = new boolean[this.datas.length];
            }
            this.signs[curIndex] = true;
        } else if (array instanceof LongArray) {
            this.datas[curIndex] = ((LongArray)array).getLong(index);
        } else {
            this.set(curIndex, array.get(index));
        }
    }

    public void addLong(long n) {
        this.ensureCapacity(this.size + 1);
        this.datas[++this.size] = n;
    }

    public void plus1(int index) {
        int n = index;
        this.datas[n] = this.datas[n] + 1L;
    }

    @Override
    public void pushNull() {
        if (this.signs == null) {
            this.signs = new boolean[this.datas.length];
        }
        this.signs[++this.size] = true;
    }

    public void push(long n) {
        this.datas[++this.size] = n;
    }

    public void pushLong(long n) {
        this.datas[++this.size] = n;
    }

    @Override
    public Object get(int index) {
        if (this.signs == null || !this.signs[index]) {
            return this.datas[index];
        }
        return null;
    }

    @Override
    public int getInt(int index) {
        return (int)this.datas[index];
    }

    @Override
    public long getLong(int index) {
        return this.datas[index];
    }

    @Override
    public double getDouble(int index) {
        return this.datas[index];
    }

    @Override
    public IArray get(int[] indexArray) {
        long[] datas = this.datas;
        boolean[] signs = this.signs;
        int len = indexArray.length;
        LongArray result = new LongArray(len);
        if (signs == null) {
            int[] nArray = indexArray;
            int n = indexArray.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                result.pushLong(datas[i]);
                ++n2;
            }
        } else {
            int[] nArray = indexArray;
            int n = indexArray.length;
            int n3 = 0;
            while (n3 < n) {
                int i = nArray[n3];
                if (signs[i]) {
                    result.pushNull();
                } else {
                    result.pushLong(datas[i]);
                }
                ++n3;
            }
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public IArray get(int[] indexArray, int start, int end, boolean doCheck) {
        block11: {
            block12: {
                datas = this.datas;
                signs = this.signs;
                len = end - start + 1;
                if (!doCheck) break block11;
                result = new LongArray(len);
                if (signs != null) ** GOTO lbl22
                while (start <= end) {
                    q = indexArray[start];
                    if (q > 0) {
                        result.pushLong(datas[q]);
                    } else {
                        result.pushNull();
                    }
                    ++start;
                }
                break block12;
lbl-1000:
                // 1 sources

                {
                    q = indexArray[start];
                    if (q < 1 || signs[q]) {
                        result.pushNull();
                    } else {
                        result.pushLong(datas[q]);
                    }
                    ++start;
lbl22:
                    // 2 sources

                    ** while (start <= end)
                }
            }
            return result;
        }
        if (signs == null) {
            resultDatas = new long[len + 1];
            i = 1;
            while (start <= end) {
                resultDatas[i++] = datas[indexArray[start]];
                ++start;
            }
            return new LongArray(resultDatas, null, len);
        }
        result = new LongArray(len);
        while (start <= end) {
            q = indexArray[start];
            if (signs[q]) {
                result.pushNull();
            } else {
                result.pushLong(datas[q]);
            }
            ++start;
        }
        return result;
    }

    @Override
    public IArray get(IArray indexArray) {
        long[] datas = this.datas;
        boolean[] signs = this.signs;
        int len = indexArray.size();
        LongArray result = new LongArray(len);
        if (signs == null) {
            int i = 1;
            while (i <= len) {
                result.pushLong(datas[indexArray.getInt(i)]);
                ++i;
            }
        } else {
            int i = 1;
            while (i <= len) {
                int index = indexArray.getInt(i);
                if (signs[index]) {
                    result.pushNull();
                } else {
                    result.pushLong(datas[index]);
                }
                ++i;
            }
        }
        return result;
    }

    @Override
    public IArray get(int start, int end) {
        int newSize = end - start;
        long[] newDatas = new long[newSize + 1];
        System.arraycopy(this.datas, start, newDatas, 1, newSize);
        if (this.signs == null) {
            return new LongArray(newDatas, null, newSize);
        }
        boolean[] newSigns = new boolean[newSize + 1];
        System.arraycopy(this.signs, start, newSigns, 1, newSize);
        return new LongArray(newDatas, newSigns, newSize);
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.datas.length;
        if (oldCapacity <= minCapacity) {
            int newCapacity;
            if (minCapacity < 8) {
                newCapacity = 8;
            } else {
                newCapacity = oldCapacity + (oldCapacity >> 1);
                if (newCapacity < 0) {
                    newCapacity = oldCapacity + 0xFFFFFFF;
                    if (newCapacity < 0) {
                        newCapacity = Integer.MAX_VALUE;
                    }
                } else if (newCapacity <= minCapacity) {
                    newCapacity = minCapacity + 1;
                }
            }
            long[] newDatas = new long[newCapacity];
            System.arraycopy(this.datas, 0, newDatas, 0, this.size + 1);
            this.datas = newDatas;
            if (this.signs != null) {
                boolean[] newSigns = new boolean[newCapacity];
                System.arraycopy(this.signs, 0, newSigns, 0, this.size + 1);
                this.signs = newSigns;
            }
        }
    }

    @Override
    public void trimToSize() {
        int newLen = this.size + 1;
        if (newLen < this.datas.length) {
            long[] newDatas = new long[newLen];
            System.arraycopy(this.datas, 0, newDatas, 0, newLen);
            this.datas = newDatas;
            if (this.signs != null) {
                boolean[] newSigns = new boolean[newLen];
                System.arraycopy(this.signs, 0, newSigns, 0, newLen);
                this.signs = newSigns;
            }
        }
    }

    @Override
    public boolean isNull(int index) {
        return this.signs != null && this.signs[index];
    }

    @Override
    public BoolArray isTrue() {
        int i;
        boolean[] signs = this.signs;
        int size = this.size;
        boolean[] resultDatas = new boolean[size + 1];
        if (signs == null) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = true;
                ++i;
            }
        } else {
            i = 1;
            while (i <= size) {
                resultDatas[i] = !signs[i];
                ++i;
            }
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    @Override
    public BoolArray isFalse() {
        int size = this.size;
        boolean[] resultDatas = new boolean[size + 1];
        if (this.signs == null) {
            int i = 1;
            while (i <= size) {
                resultDatas[i] = false;
                ++i;
            }
        } else {
            System.arraycopy(this.signs, 1, resultDatas, 1, size);
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    @Override
    public boolean isTrue(int index) {
        return this.signs == null || !this.signs[index];
    }

    @Override
    public boolean isFalse(int index) {
        return this.signs != null && this.signs[index];
    }

    @Override
    public boolean isTemporary() {
        return this.datas[0] == 1L;
    }

    @Override
    public void setTemporary(boolean ifTemporary) {
        this.datas[0] = ifTemporary ? 1 : 0;
    }

    @Override
    public void removeLast() {
        if (this.signs != null) {
            this.signs[this.size] = false;
        }
        --this.size;
    }

    @Override
    public void remove(int index) {
        System.arraycopy(this.datas, index + 1, this.datas, index, this.size - index);
        if (this.signs != null) {
            System.arraycopy(this.signs, index + 1, this.signs, index, this.size - index);
            this.signs[this.size] = false;
        }
        --this.size;
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        System.arraycopy(this.datas, toIndex + 1, this.datas, fromIndex, this.size - toIndex);
        if (this.signs != null) {
            System.arraycopy(this.signs, toIndex + 1, this.signs, fromIndex, this.size - toIndex);
            int i = this.size - toIndex + fromIndex;
            while (i <= this.size) {
                this.signs[i] = false;
                ++i;
            }
        }
        this.size -= toIndex - fromIndex + 1;
    }

    @Override
    public void remove(int[] seqs) {
        int delCount = 0;
        long[] datas = this.datas;
        boolean[] signs = this.signs;
        int i = 0;
        int len = seqs.length;
        while (i < len) {
            int moveCount;
            int cur = seqs[i];
            if ((moveCount = ++i < len ? seqs[i] - cur - 1 : this.size - cur) > 0) {
                System.arraycopy(datas, cur + 1, datas, cur - delCount, moveCount);
                if (signs != null) {
                    System.arraycopy(signs, cur + 1, signs, cur - delCount, moveCount);
                }
            }
            ++delCount;
        }
        if (signs != null) {
            i = 0;
            int q = this.size;
            while (i < delCount) {
                signs[q - i] = false;
                ++i;
            }
        }
        this.size -= delCount;
    }

    @Override
    public void reserve(int start, int end) {
        int newSize = end - start + 1;
        System.arraycopy(this.datas, start, this.datas, 1, newSize);
        if (this.signs != null) {
            System.arraycopy(this.signs, start, this.signs, 1, newSize);
            int i = this.size;
            while (i > newSize) {
                this.signs[i] = false;
                --i;
            }
        }
        this.size = newSize;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int count() {
        boolean[] signs = this.signs;
        int size = this.size;
        if (signs == null) {
            return size;
        }
        int count = size;
        int i = 1;
        while (i <= size) {
            if (signs[i]) {
                --count;
            }
            ++i;
        }
        return count;
    }

    @Override
    public boolean containTrue() {
        int size = this.size;
        if (size == 0) {
            return false;
        }
        boolean[] signs = this.signs;
        if (signs == null) {
            return true;
        }
        int i = 1;
        while (i <= size) {
            if (!signs[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public Object ifn() {
        int size = this.size;
        if (size == 0) {
            return null;
        }
        boolean[] signs = this.signs;
        if (signs == null) {
            return this.datas[1];
        }
        int i = 1;
        while (i <= size) {
            if (!signs[i]) {
                return this.datas[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public void set(int index, Object obj) {
        if (obj == null) {
            if (this.signs == null) {
                this.signs = new boolean[this.datas.length];
            }
            this.signs[index] = true;
        } else if (obj instanceof Long) {
            this.datas[index] = (Long)obj;
            if (this.signs != null) {
                this.signs[index] = false;
            }
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("pdm.arrayTypeError", mm.getMessage("DataType.Long"), Variant.getDataType(obj)));
        }
    }

    @Override
    public void clear() {
        this.signs = null;
        this.size = 0;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int binarySearch(Object elem) {
        block9: {
            block10: {
                if (!(elem instanceof Number)) break block9;
                number = (Number)elem;
                v = number.longValue();
                datas = this.datas;
                signs = this.signs;
                low = 1;
                high = this.size;
                if (signs != null) {
                    while (low <= high) {
                        if (!signs[low]) break;
                        ++low;
                    }
                }
                if (LongArray.compare(v, number) != 0) ** GOTO lbl29
                while (low <= high) {
                    mid = low + high >> 1;
                    if (datas[mid] < v) {
                        low = mid + 1;
                        continue;
                    }
                    if (datas[mid] > v) {
                        high = mid - 1;
                        continue;
                    }
                    return mid;
                }
                break block10;
lbl-1000:
                // 1 sources

                {
                    mid = low + high >> 1;
                    if (LongArray.compare(datas[mid], elem) < 0) {
                        low = mid + 1;
                        continue;
                    }
                    high = mid - 1;
lbl29:
                    // 3 sources

                    ** while (low <= high)
                }
            }
            return -low;
        }
        if (elem == null) {
            if (this.size > 0 && this.signs != null && this.signs[1]) {
                return 1;
            }
            return -1;
        }
        mm = EngineMessage.get();
        throw new RQException(mm.getMessage("Variant2.illCompare", this.datas[1], elem, this.getDataType(), Variant.getDataType(elem)));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int binarySearch(Object elem, int start, int end) {
        block9: {
            block10: {
                if (!(elem instanceof Number)) break block9;
                number = (Number)elem;
                v = number.longValue();
                datas = this.datas;
                signs = this.signs;
                low = start;
                high = end;
                if (signs != null) {
                    while (low <= high) {
                        if (!signs[low]) break;
                        ++low;
                    }
                }
                if (LongArray.compare(v, number) != 0) ** GOTO lbl29
                while (low <= high) {
                    mid = low + high >> 1;
                    if (datas[mid] < v) {
                        low = mid + 1;
                        continue;
                    }
                    if (datas[mid] > v) {
                        high = mid - 1;
                        continue;
                    }
                    return mid;
                }
                break block10;
lbl-1000:
                // 1 sources

                {
                    mid = low + high >> 1;
                    if (LongArray.compare(datas[mid], elem) < 0) {
                        low = mid + 1;
                        continue;
                    }
                    high = mid - 1;
lbl29:
                    // 3 sources

                    ** while (low <= high)
                }
            }
            return -low;
        }
        if (elem == null) {
            if (end > 0 && this.signs != null && this.signs[start]) {
                return start;
            }
            return -1;
        }
        mm = EngineMessage.get();
        throw new RQException(mm.getMessage("Variant2.illCompare", this.datas[1], elem, this.getDataType(), Variant.getDataType(elem)));
    }

    private int binarySearch(long v, int low, int high) {
        long[] datas = this.datas;
        boolean[] signs = this.signs;
        if (signs != null) {
            while (low <= high) {
                if (!signs[low]) break;
                ++low;
            }
        }
        while (low <= high) {
            int mid = low + high >> 1;
            if (datas[mid] < v) {
                low = mid + 1;
                continue;
            }
            if (datas[mid] > v) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -low;
    }

    public int binarySearch(long v) {
        long[] datas = this.datas;
        boolean[] signs = this.signs;
        int low = 1;
        int high = this.size;
        if (signs != null) {
            while (low <= high) {
                if (!signs[low]) break;
                ++low;
            }
        }
        while (low <= high) {
            int mid = low + high >> 1;
            if (datas[mid] < v) {
                low = mid + 1;
                continue;
            }
            if (datas[mid] > v) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -low;
    }

    private int descBinarySearch(long elem) {
        long[] datas = this.datas;
        int low = 1;
        int high = this.size;
        while (low <= high) {
            int mid = low + high >> 1;
            int cmp = LongArray.compare(datas[mid], elem);
            if (cmp < 0) {
                high = mid - 1;
                continue;
            }
            if (cmp > 0) {
                low = mid + 1;
                continue;
            }
            return mid;
        }
        return -low;
    }

    @Override
    public boolean contains(Object elem) {
        if (elem instanceof Number) {
            Number number = (Number)elem;
            long v = number.longValue();
            if (LongArray.compare(v, number) != 0) {
                return false;
            }
            long[] datas = this.datas;
            boolean[] signs = this.signs;
            int size = this.size;
            if (signs == null) {
                int i = 1;
                while (i <= size) {
                    if (datas[i] == v) {
                        return true;
                    }
                    ++i;
                }
            } else {
                int i = 1;
                while (i <= size) {
                    if (!signs[i] && datas[i] == v) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }
        if (elem == null) {
            boolean[] signs = this.signs;
            if (signs == null) {
                return false;
            }
            int size = this.size;
            int i = 1;
            while (i <= size) {
                if (signs[i]) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return false;
    }

    public boolean contains(long v) {
        long[] datas = this.datas;
        boolean[] signs = this.signs;
        int size = this.size;
        if (signs == null) {
            int i = 1;
            while (i <= size) {
                if (datas[i] == v) {
                    return true;
                }
                ++i;
            }
        } else {
            int i = 1;
            while (i <= size) {
                if (!signs[i] && datas[i] == v) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    public void contains(boolean isSorted, IArray array, BoolArray result) {
        int resultSize = result.size();
        if (array instanceof LongArray || array instanceof IntArray) {
            if (isSorted) {
                int i = 1;
                while (i <= resultSize) {
                    if (result.isTrue(i)) {
                        if (array.isNull(i)) {
                            if (this.binarySearch(null) < 1) {
                                result.set(i, false);
                            }
                        } else if (this.binarySearch(array.getLong(i)) < 1) {
                            result.set(i, false);
                        }
                    }
                    ++i;
                }
            } else {
                int i = 1;
                while (i <= resultSize) {
                    if (result.isTrue(i)) {
                        if (array.isNull(i)) {
                            if (!this.contains(null)) {
                                result.set(i, false);
                            }
                        } else if (!this.contains(array.getLong(i))) {
                            result.set(i, false);
                        }
                    }
                    ++i;
                }
            }
        } else if (isSorted) {
            int i = 1;
            while (i <= resultSize) {
                if (result.isTrue(i) && this.binarySearch(array.get(i)) < 1) {
                    result.set(i, false);
                }
                ++i;
            }
        } else {
            int i = 1;
            while (i <= resultSize) {
                if (result.isTrue(i) && !this.contains(array.get(i))) {
                    result.set(i, false);
                }
                ++i;
            }
        }
    }

    @Override
    public boolean objectContains(Object elem) {
        return false;
    }

    @Override
    public int firstIndexOf(Object elem, int start) {
        if (elem instanceof Number) {
            Number number = (Number)elem;
            long v = number.longValue();
            if (LongArray.compare(v, number) != 0) {
                return 0;
            }
            long[] datas = this.datas;
            boolean[] signs = this.signs;
            int size = this.size;
            if (signs == null) {
                int i = start;
                while (i <= size) {
                    if (datas[i] == v) {
                        return i;
                    }
                    ++i;
                }
            } else {
                int i = start;
                while (i <= size) {
                    if (!signs[i] && datas[i] == v) {
                        return i;
                    }
                    ++i;
                }
            }
            return 0;
        }
        if (elem == null) {
            boolean[] signs = this.signs;
            if (signs == null) {
                return 0;
            }
            int i = start;
            int size = this.size;
            while (i <= size) {
                if (signs[i]) {
                    return i;
                }
                ++i;
            }
            return 0;
        }
        return 0;
    }

    private int firstIndexOf(long v, int start) {
        long[] datas = this.datas;
        boolean[] signs = this.signs;
        int size = this.size;
        if (signs == null) {
            int i = start;
            while (i <= size) {
                if (datas[i] == v) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = start;
            while (i <= size) {
                if (!signs[i] && datas[i] == v) {
                    return i;
                }
                ++i;
            }
        }
        return 0;
    }

    @Override
    public int lastIndexOf(Object elem, int start) {
        if (elem instanceof Number) {
            Number number = (Number)elem;
            long v = number.longValue();
            if (LongArray.compare(v, number) != 0) {
                return 0;
            }
            long[] datas = this.datas;
            boolean[] signs = this.signs;
            if (signs == null) {
                int i = start;
                while (i > 0) {
                    if (datas[i] == v) {
                        return i;
                    }
                    --i;
                }
            } else {
                int i = start;
                while (i > 0) {
                    if (!signs[i] && datas[i] == v) {
                        return i;
                    }
                    --i;
                }
            }
            return 0;
        }
        if (elem == null) {
            boolean[] signs = this.signs;
            if (signs == null) {
                return 0;
            }
            int i = start;
            while (i > 0) {
                if (signs[i]) {
                    return i;
                }
                --i;
            }
            return 0;
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public IntArray indexOfAll(Object elem, int start, boolean isSorted, boolean isFromHead) {
        block31: {
            block32: {
                size = this.size;
                signs = this.signs;
                if (elem == null) {
                    result = new IntArray(7);
                    if (signs != null) {
                        if (isSorted) {
                            if (isFromHead) {
                                i = start;
                                while (i <= size) {
                                    if (signs[i]) {
                                        result.addInt(i);
                                        ++i;
                                        continue;
                                    }
                                    break;
                                }
                            } else {
                                i = start;
                                while (i > 0) {
                                    if (signs[i]) {
                                        result.addInt(i);
                                    }
                                    --i;
                                }
                            }
                        } else if (isFromHead) {
                            i = start;
                            while (i <= size) {
                                if (signs[i]) {
                                    result.addInt(i);
                                }
                                ++i;
                            }
                        } else {
                            i = start;
                            while (i > 0) {
                                if (signs[i]) {
                                    result.addInt(i);
                                }
                                --i;
                            }
                        }
                    }
                    return result;
                }
                if (!(elem instanceof Number)) {
                    return new IntArray(1);
                }
                number = (Number)elem;
                if (!isSorted) break block31;
                end = size;
                if (!isFromHead) {
                    end = start;
                    start = 1;
                }
                if ((index = this.binarySearch(number, start, end)) < 1) {
                    return new IntArray(1);
                }
                datas = this.datas;
                v = number.longValue();
                first = index;
                while (!(first <= start || signs != null && signs[first - 1] || datas[first - 1] != v)) {
                    --first;
                }
                last = index;
                while (!(last >= end || signs != null && signs[last + 1] || datas[last + 1] != v)) {
                    ++last;
                }
                result = new IntArray(last - first + 1);
                if (!isFromHead) ** GOTO lbl68
                while (first <= last) {
                    result.pushInt(first);
                    ++first;
                }
                break block32;
lbl-1000:
                // 1 sources

                {
                    result.pushInt(last);
                    --last;
lbl68:
                    // 2 sources

                    ** while (last >= first)
                }
            }
            return result;
        }
        datas = this.datas;
        v = number.longValue();
        if (LongArray.compare(v, number) != 0) {
            return new IntArray(1);
        }
        result = new IntArray(7);
        if (isFromHead) {
            i = start;
            while (i <= size) {
                if (!(signs != null && signs[i] || datas[i] != v)) {
                    result.addInt(i);
                }
                ++i;
            }
        } else {
            i = start;
            while (i > 0) {
                if (!(signs != null && signs[i] || datas[i] != v)) {
                    result.addInt(i);
                }
                --i;
            }
        }
        return result;
    }

    @Override
    public IArray abs() {
        long[] datas;
        LongArray result;
        int size = this.size;
        if (this.isTemporary()) {
            result = this;
            datas = this.datas;
        } else {
            datas = new long[size + 1];
            System.arraycopy(this.datas, 1, datas, 1, size);
            boolean[] signs = null;
            if (this.signs != null) {
                signs = new boolean[size + 1];
                System.arraycopy(this.signs, 1, signs, 1, size);
            }
            result = new LongArray(datas, signs, size);
            result.setTemporary(true);
        }
        int i = 1;
        while (i <= size) {
            if (datas[i] < 0L) {
                datas[i] = -datas[i];
            }
            ++i;
        }
        return result;
    }

    @Override
    public IArray negate() {
        int size = this.size;
        long[] datas = this.datas;
        if (this.isTemporary()) {
            int i = 1;
            while (i <= size) {
                datas[i] = -datas[i];
                ++i;
            }
            return this;
        }
        long[] newDatas = new long[size + 1];
        int i = 1;
        while (i <= size) {
            newDatas[i] = -datas[i];
            ++i;
        }
        boolean[] newSigns = null;
        if (this.signs != null) {
            newSigns = new boolean[size + 1];
            System.arraycopy(this.signs, 1, newSigns, 1, size);
        }
        LongArray result = new LongArray(newDatas, newSigns, size);
        result.setTemporary(true);
        return result;
    }

    @Override
    public IArray not() {
        boolean[] signs = this.signs;
        int size = this.size;
        if (signs == null) {
            return new ConstArray(Boolean.FALSE, size);
        }
        boolean[] newDatas = new boolean[size + 1];
        System.arraycopy(signs, 1, newDatas, 1, size);
        BoolArray result = new BoolArray(newDatas, size);
        result.setTemporary(true);
        return result;
    }

    @Override
    public boolean isNumberArray() {
        return true;
    }

    @Override
    public IArray memberAdd(IArray array) {
        if (array instanceof IntArray) {
            return this.memberAdd((IntArray)array);
        }
        if (array instanceof LongArray) {
            return this.memberAdd((LongArray)array);
        }
        if (array instanceof DoubleArray) {
            return ((DoubleArray)array).memberAdd(this);
        }
        if (array instanceof ConstArray) {
            return this.memberAdd(array.get(1));
        }
        if (array instanceof ObjectArray) {
            return ((ObjectArray)array).memberAdd(this);
        }
        if (array instanceof DateArray) {
            return ((DateArray)array).memberAdd(this);
        }
        if (array instanceof StringArray) {
            return ((StringArray)array).memberAdd(this);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illAdd"));
    }

    @Override
    public IArray memberAdd(Object value) {
        if (value instanceof String) {
            value = Variant.parseNumber((String)value);
        }
        if (value == null) {
            return this;
        }
        int size = this.size;
        long[] datas = this.datas;
        boolean[] signs = this.signs;
        if (value instanceof Double || value instanceof Float) {
            int i;
            double v = ((Number)value).doubleValue();
            double[] resultDatas = new double[size + 1];
            if (signs == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = v + (double)datas[i];
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = signs[i] ? v : v + (double)datas[i];
                    ++i;
                }
            }
            DoubleArray result = new DoubleArray(resultDatas, null, size);
            result.setTemporary(true);
            return result;
        }
        if (value instanceof BigDecimal || value instanceof BigInteger) {
            int i;
            Object[] resultDatas = new Object[size + 1];
            BigDecimal v = value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal((BigInteger)value);
            if (signs == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = v.add(new BigDecimal(datas[i]));
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = signs[i] ? v : v.add(new BigDecimal(datas[i]));
                    ++i;
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (value instanceof Number) {
            int i;
            long v = ((Number)value).longValue();
            if (this.isTemporary()) {
                if (signs == null) {
                    int i2 = 1;
                    while (i2 <= size) {
                        int n = i2++;
                        datas[n] = datas[n] + v;
                    }
                } else {
                    int i3 = 1;
                    while (i3 <= size) {
                        if (signs[i3]) {
                            datas[i3] = v;
                        } else {
                            int n = i3;
                            datas[n] = datas[n] + v;
                        }
                        ++i3;
                    }
                    this.signs = null;
                }
                return this;
            }
            long[] resultDatas = new long[size + 1];
            if (signs == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = v + datas[i];
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = signs[i] ? v : v + datas[i];
                    ++i;
                }
            }
            LongArray result = new LongArray(resultDatas, null, size);
            result.setTemporary(true);
            return result;
        }
        if (value instanceof Date) {
            int i;
            Date v = (Date)value;
            Object[] resultDatas = new Object[size + 1];
            if (signs == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = Variant.elapse(v, (int)datas[i], null);
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = signs[i] ? v : Variant.elapse(v, (int)datas[i], null);
                    ++i;
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + Variant.getDataType(value) + mm.getMessage("Variant2.illAdd"));
    }

    protected LongArray memberAdd(IntArray array) {
        int size = this.size;
        if (!this.isTemporary()) {
            long[] newDatas = new long[size + 1];
            System.arraycopy(this.datas, 1, newDatas, 1, size);
            boolean[] newSigns = null;
            if (this.signs != null) {
                newSigns = new boolean[size + 1];
                System.arraycopy(this.signs, 1, newSigns, 1, size);
            }
            LongArray result = new LongArray(newDatas, newSigns, size);
            result.setTemporary(true);
            return result.memberAdd(array);
        }
        long[] datas = this.datas;
        boolean[] signs = this.signs;
        int[] d2 = array.getDatas();
        boolean[] s2 = array.getSigns();
        if (signs == null) {
            if (s2 == null) {
                int i = 1;
                while (i <= size) {
                    int n = i;
                    datas[n] = datas[n] + (long)d2[i];
                    ++i;
                }
            } else {
                int i = 1;
                while (i <= size) {
                    if (!s2[i]) {
                        int n = i;
                        datas[n] = datas[n] + (long)d2[i];
                    }
                    ++i;
                }
            }
        } else if (s2 == null) {
            int i = 1;
            while (i <= size) {
                if (signs[i]) {
                    datas[i] = d2[i];
                } else {
                    int n = i;
                    datas[n] = datas[n] + (long)d2[i];
                }
                ++i;
            }
            this.signs = null;
        } else {
            int i = 1;
            while (i <= size) {
                if (signs[i]) {
                    if (!s2[i]) {
                        signs[i] = false;
                        datas[i] = d2[i];
                    }
                } else if (!s2[i]) {
                    int n = i;
                    datas[n] = datas[n] + (long)d2[i];
                }
                ++i;
            }
        }
        return this;
    }

    private LongArray memberAdd(LongArray array) {
        int size = this.size;
        if (!this.isTemporary()) {
            if (array.isTemporary()) {
                return array.memberAdd(this);
            }
            long[] newDatas = new long[size + 1];
            System.arraycopy(this.datas, 1, newDatas, 1, size);
            boolean[] newSigns = null;
            if (this.signs != null) {
                newSigns = new boolean[size + 1];
                System.arraycopy(this.signs, 1, newSigns, 1, size);
            }
            LongArray result = new LongArray(newDatas, newSigns, size);
            result.setTemporary(true);
            return result.memberAdd(array);
        }
        long[] datas = this.datas;
        boolean[] signs = this.signs;
        long[] d2 = array.datas;
        boolean[] s2 = array.signs;
        if (signs == null) {
            if (s2 == null) {
                int i = 1;
                while (i <= size) {
                    int n = i;
                    datas[n] = datas[n] + d2[i];
                    ++i;
                }
            } else {
                int i = 1;
                while (i <= size) {
                    if (!s2[i]) {
                        int n = i;
                        datas[n] = datas[n] + d2[i];
                    }
                    ++i;
                }
            }
        } else if (s2 == null) {
            int i = 1;
            while (i <= size) {
                if (signs[i]) {
                    datas[i] = d2[i];
                } else {
                    int n = i;
                    datas[n] = datas[n] + d2[i];
                }
                ++i;
            }
            this.signs = null;
        } else {
            int i = 1;
            while (i <= size) {
                if (signs[i]) {
                    if (!s2[i]) {
                        signs[i] = false;
                        datas[i] = d2[i];
                    }
                } else if (!s2[i]) {
                    int n = i;
                    datas[n] = datas[n] + d2[i];
                }
                ++i;
            }
        }
        return this;
    }

    @Override
    public IArray memberSubtract(IArray array) {
        if (array instanceof IntArray) {
            return this.memberSubtract((IntArray)array);
        }
        if (array instanceof LongArray) {
            return this.memberSubtract((LongArray)array);
        }
        if (array instanceof DoubleArray) {
            return this.memberSubtract((DoubleArray)array);
        }
        if (array instanceof ConstArray) {
            return this.memberSubtract(array.get(1));
        }
        if (array instanceof ObjectArray) {
            return this.memberSubtract((ObjectArray)array);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illSubtract"));
    }

    private IArray memberSubtract(Object value) {
        if (value == null) {
            return this;
        }
        int size = this.size;
        long[] datas = this.datas;
        boolean[] signs = this.signs;
        if (value instanceof Double || value instanceof Float) {
            int i;
            double v = ((Number)value).doubleValue();
            double[] resultDatas = new double[size + 1];
            if (signs == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = (double)datas[i] - v;
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = signs[i] ? -v : (double)datas[i] - v;
                    ++i;
                }
            }
            DoubleArray result = new DoubleArray(resultDatas, null, size);
            result.setTemporary(true);
            return result;
        }
        if (value instanceof BigDecimal || value instanceof BigInteger) {
            int i;
            Object[] resultDatas = new Object[size + 1];
            BigDecimal v = value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal((BigInteger)value);
            if (signs == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = new BigDecimal(datas[i]).subtract(v);
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = signs[i] ? v.negate() : new BigDecimal(datas[i]).subtract(v);
                    ++i;
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (value instanceof Number) {
            int i;
            long v = ((Number)value).longValue();
            if (this.isTemporary()) {
                if (signs == null) {
                    int i2 = 1;
                    while (i2 <= size) {
                        int n = i2++;
                        datas[n] = datas[n] - v;
                    }
                } else {
                    int i3 = 1;
                    while (i3 <= size) {
                        if (signs[i3]) {
                            datas[i3] = -v;
                        } else {
                            int n = i3;
                            datas[n] = datas[n] - v;
                        }
                        ++i3;
                    }
                    this.signs = null;
                }
                return this;
            }
            long[] resultDatas = new long[size + 1];
            if (signs == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = datas[i] - v;
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = signs[i] ? -v : datas[i] - v;
                    ++i;
                }
            }
            LongArray result = new LongArray(resultDatas, null, size);
            result.setTemporary(true);
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + Variant.getDataType(value) + mm.getMessage("Variant2.illSubtract"));
    }

    private LongArray memberSubtract(IntArray array) {
        Object resultSigns;
        long[] resultDatas;
        LongArray result;
        int size = this.size;
        long[] d1 = this.datas;
        boolean[] s1 = this.signs;
        int[] d2 = array.getDatas();
        boolean[] s2 = array.getSigns();
        if (this.isTemporary()) {
            result = this;
            resultDatas = d1;
            resultSigns = s1;
        } else {
            resultDatas = new long[size + 1];
            resultSigns = s1 != null && s2 != null ? new boolean[size + 1] : null;
            result = new LongArray(resultDatas, (boolean[])resultSigns, size);
            result.setTemporary(true);
        }
        if (s1 == null) {
            if (s2 == null) {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = d1[i] - (long)d2[i];
                    ++i;
                }
            } else {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = s2[i] ? d1[i] : d1[i] - (long)d2[i];
                    ++i;
                }
            }
            result.signs = null;
        } else if (s2 == null) {
            int i = 1;
            while (i <= size) {
                resultDatas[i] = s1[i] ? (long)(-d2[i]) : d1[i] - (long)d2[i];
                ++i;
            }
            result.signs = null;
        } else {
            int i = 1;
            while (i <= size) {
                if (s1[i]) {
                    if (s2[i]) {
                        resultSigns[i] = true;
                    } else {
                        resultDatas[i] = -d2[i];
                    }
                } else {
                    resultDatas[i] = s2[i] ? d1[i] : d1[i] - (long)d2[i];
                }
                ++i;
            }
        }
        return result;
    }

    private LongArray memberSubtract(LongArray array) {
        Object resultSigns;
        long[] resultDatas;
        LongArray result;
        int size = this.size;
        long[] d1 = this.datas;
        boolean[] s1 = this.signs;
        long[] d2 = array.datas;
        boolean[] s2 = array.signs;
        if (this.isTemporary()) {
            result = this;
            resultDatas = d1;
            resultSigns = s1;
        } else if (array.isTemporary()) {
            result = array;
            resultDatas = d2;
            resultSigns = s2;
        } else {
            resultDatas = new long[size + 1];
            resultSigns = s1 != null && s2 != null ? new boolean[size + 1] : null;
            result = new LongArray(resultDatas, (boolean[])resultSigns, size);
            result.setTemporary(true);
        }
        if (s1 == null) {
            if (s2 == null) {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = d1[i] - d2[i];
                    ++i;
                }
            } else {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = s2[i] ? d1[i] : d1[i] - d2[i];
                    ++i;
                }
            }
            result.setSigns(null);
        } else if (s2 == null) {
            int i = 1;
            while (i <= size) {
                resultDatas[i] = s1[i] ? -d2[i] : d1[i] - d2[i];
                ++i;
            }
            result.setSigns(null);
        } else {
            int i = 1;
            while (i <= size) {
                if (s1[i]) {
                    if (s2[i]) {
                        resultSigns[i] = true;
                    } else {
                        resultDatas[i] = -d2[i];
                    }
                } else {
                    resultDatas[i] = s2[i] ? d1[i] : d1[i] - d2[i];
                }
                ++i;
            }
        }
        return result;
    }

    private DoubleArray memberSubtract(DoubleArray array) {
        Object resultSigns;
        double[] resultDatas;
        DoubleArray result;
        int size = this.size;
        long[] d1 = this.datas;
        boolean[] s1 = this.signs;
        double[] d2 = array.getDatas();
        boolean[] s2 = array.getSigns();
        if (array.isTemporary()) {
            result = array;
            resultDatas = d2;
            resultSigns = s2;
        } else {
            resultDatas = new double[size + 1];
            resultSigns = s1 != null && s2 != null ? new boolean[size + 1] : null;
            result = new DoubleArray(resultDatas, (boolean[])resultSigns, size);
            result.setTemporary(true);
        }
        if (s1 == null) {
            if (s2 == null) {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = (double)d1[i] - d2[i];
                    ++i;
                }
            } else {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = s2[i] ? (double)d1[i] : (double)d1[i] - d2[i];
                    ++i;
                }
            }
            result.setSigns(null);
        } else if (s2 == null) {
            int i = 1;
            while (i <= size) {
                resultDatas[i] = s1[i] ? -d2[i] : (double)d1[i] - d2[i];
                ++i;
            }
            result.setSigns(null);
        } else {
            int i = 1;
            while (i <= size) {
                if (s1[i]) {
                    if (s2[i]) {
                        resultSigns[i] = true;
                    } else {
                        resultDatas[i] = -d2[i];
                    }
                } else {
                    resultDatas[i] = s2[i] ? (double)d1[i] : (double)d1[i] - d2[i];
                }
                ++i;
            }
        }
        return result;
    }

    private ObjectArray memberSubtract(ObjectArray array) {
        Object[] resultDatas;
        ObjectArray result;
        int size = this.size;
        long[] d1 = this.datas;
        boolean[] s1 = this.signs;
        Object[] d2 = array.getDatas();
        if (array.isTemporary()) {
            result = array;
            resultDatas = d2;
        } else {
            resultDatas = new Object[size + 1];
            result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
        }
        int i = 1;
        while (i <= size) {
            Object v = d2[i];
            if (v == null) {
                if (s1 == null || !s1[i]) {
                    resultDatas[i] = d1[i];
                }
            } else if (v instanceof Double || v instanceof Float) {
                resultDatas[i] = s1 == null || !s1[i] ? Double.valueOf((double)d1[i] - ((Number)v).doubleValue()) : Double.valueOf(-((Number)v).doubleValue());
            } else if (v instanceof BigDecimal) {
                resultDatas[i] = s1 == null || !s1[i] ? new BigDecimal(d1[i]).subtract((BigDecimal)v) : ((BigDecimal)v).negate();
            } else if (v instanceof BigInteger) {
                resultDatas[i] = s1 == null || !s1[i] ? new BigDecimal(d1[i]).subtract(new BigDecimal((BigInteger)v)) : new BigDecimal((BigInteger)v).negate();
            } else if (v instanceof Number) {
                resultDatas[i] = s1 == null || !s1[i] ? Long.valueOf(d1[i] - ((Number)v).longValue()) : Long.valueOf(-((Number)v).longValue());
            } else {
                MessageManager mm = EngineMessage.get();
                throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + Variant.getDataType(v) + mm.getMessage("Variant2.illSubtract"));
            }
            ++i;
        }
        return result;
    }

    @Override
    public IArray memberMultiply(IArray array) {
        if (array instanceof IntArray) {
            return this.memberMultiply((IntArray)array);
        }
        if (array instanceof LongArray) {
            return this.memberMultiply((LongArray)array);
        }
        if (array instanceof DoubleArray) {
            return ((DoubleArray)array).memberMultiply(this);
        }
        if (array instanceof ConstArray) {
            return this.memberMultiply(array.get(1));
        }
        if (array instanceof ObjectArray) {
            return ((ObjectArray)array).memberMultiply(this);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMultiply"));
    }

    @Override
    public IArray memberMultiply(Object value) {
        int size = this.size;
        long[] datas = this.datas;
        boolean[] signs = this.signs;
        if (value instanceof Double || value instanceof Float) {
            int i;
            double v = ((Number)value).doubleValue();
            double[] resultDatas = new double[size + 1];
            boolean[] resultSigns = null;
            if (signs == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = v * (double)datas[i];
                    ++i;
                }
            } else {
                resultSigns = new boolean[size + 1];
                i = 1;
                while (i <= size) {
                    if (signs[i]) {
                        resultSigns[i] = true;
                    } else {
                        resultDatas[i] = v * (double)datas[i];
                    }
                    ++i;
                }
            }
            DoubleArray result = new DoubleArray(resultDatas, resultSigns, size);
            result.setTemporary(true);
            return result;
        }
        if (value instanceof BigDecimal || value instanceof BigInteger) {
            int i;
            Object[] resultDatas = new Object[size + 1];
            BigDecimal v = value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal((BigInteger)value);
            if (signs == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = v.multiply(new BigDecimal(datas[i]));
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    if (!signs[i]) {
                        resultDatas[i] = v.multiply(new BigDecimal(datas[i]));
                    }
                    ++i;
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (value instanceof Number) {
            int i;
            long v = ((Number)value).longValue();
            if (this.isTemporary()) {
                if (signs == null) {
                    int i2 = 1;
                    while (i2 <= size) {
                        int n = i2++;
                        datas[n] = datas[n] * v;
                    }
                } else {
                    int i3 = 1;
                    while (i3 <= size) {
                        if (!signs[i3]) {
                            int n = i3;
                            datas[n] = datas[n] * v;
                        }
                        ++i3;
                    }
                }
                return this;
            }
            long[] resultDatas = new long[size + 1];
            boolean[] resultSigns = null;
            if (signs == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = v * datas[i];
                    ++i;
                }
            } else {
                resultSigns = new boolean[size + 1];
                i = 1;
                while (i <= size) {
                    if (signs[i]) {
                        resultSigns[i] = true;
                    } else {
                        resultDatas[i] = v * datas[i];
                    }
                    ++i;
                }
            }
            LongArray result = new LongArray(resultDatas, resultSigns, size);
            result.setTemporary(true);
            return result;
        }
        if (value == null) {
            return new ConstArray(null, size);
        }
        if (value instanceof Sequence) {
            int i;
            Sequence sequence = (Sequence)value;
            Object[] resultDatas = new Object[size + 1];
            if (signs == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = sequence.multiply((int)datas[i]);
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = signs[i] ? null : sequence.multiply((int)datas[i]);
                    ++i;
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + Variant.getDataType(value) + mm.getMessage("Variant2.illMultiply"));
    }

    protected LongArray memberMultiply(IntArray array) {
        int size = this.size;
        if (!this.isTemporary()) {
            long[] newDatas = new long[size + 1];
            System.arraycopy(this.datas, 1, newDatas, 1, size);
            boolean[] newSigns = null;
            if (this.signs != null) {
                newSigns = new boolean[size + 1];
                System.arraycopy(this.signs, 1, newSigns, 1, size);
            }
            LongArray result = new LongArray(newDatas, newSigns, size);
            result.setTemporary(true);
            return result.memberMultiply(array);
        }
        long[] datas = this.datas;
        boolean[] signs = this.signs;
        int[] d2 = array.getDatas();
        boolean[] s2 = array.getSigns();
        if (signs == null) {
            if (s2 == null) {
                int i = 1;
                while (i <= size) {
                    int n = i;
                    datas[n] = datas[n] * (long)d2[i];
                    ++i;
                }
            } else {
                this.signs = signs = new boolean[size + 1];
                System.arraycopy(s2, 1, signs, 1, size);
                int i = 1;
                while (i <= size) {
                    if (!s2[i]) {
                        int n = i;
                        datas[n] = datas[n] * (long)d2[i];
                    }
                    ++i;
                }
            }
        } else if (s2 == null) {
            int i = 1;
            while (i <= size) {
                if (!signs[i]) {
                    int n = i;
                    datas[n] = datas[n] * (long)d2[i];
                }
                ++i;
            }
        } else {
            int i = 1;
            while (i <= size) {
                if (s2[i]) {
                    signs[i] = true;
                } else if (!signs[i]) {
                    int n = i;
                    datas[n] = datas[n] * (long)d2[i];
                }
                ++i;
            }
        }
        return this;
    }

    private LongArray memberMultiply(LongArray array) {
        int size = this.size;
        if (!this.isTemporary()) {
            if (array.isTemporary()) {
                return array.memberMultiply(this);
            }
            long[] newDatas = new long[size + 1];
            System.arraycopy(this.datas, 1, newDatas, 1, size);
            boolean[] newSigns = null;
            if (this.signs != null) {
                newSigns = new boolean[size + 1];
                System.arraycopy(this.signs, 1, newSigns, 1, size);
            }
            LongArray result = new LongArray(newDatas, newSigns, size);
            result.setTemporary(true);
            return result.memberMultiply(array);
        }
        long[] datas = this.datas;
        boolean[] signs = this.signs;
        long[] d2 = array.datas;
        boolean[] s2 = array.signs;
        if (signs == null) {
            if (s2 == null) {
                int i = 1;
                while (i <= size) {
                    int n = i;
                    datas[n] = datas[n] * d2[i];
                    ++i;
                }
            } else {
                this.signs = signs = new boolean[size + 1];
                System.arraycopy(s2, 1, signs, 1, size);
                int i = 1;
                while (i <= size) {
                    if (!s2[i]) {
                        int n = i;
                        datas[n] = datas[n] * d2[i];
                    }
                    ++i;
                }
            }
        } else if (s2 == null) {
            int i = 1;
            while (i <= size) {
                if (!signs[i]) {
                    int n = i;
                    datas[n] = datas[n] * d2[i];
                }
                ++i;
            }
        } else {
            int i = 1;
            while (i <= size) {
                if (s2[i]) {
                    signs[i] = true;
                } else if (!signs[i]) {
                    int n = i;
                    datas[n] = datas[n] * d2[i];
                }
                ++i;
            }
        }
        return this;
    }

    @Override
    public IArray memberDivide(IArray array) {
        if (array instanceof IntArray) {
            return this.memberDivide((IntArray)array);
        }
        if (array instanceof LongArray) {
            return this.memberDivide((LongArray)array);
        }
        if (array instanceof DoubleArray) {
            return this.memberDivide((DoubleArray)array);
        }
        if (array instanceof ConstArray) {
            return this.memberDivide(array.get(1));
        }
        if (array instanceof ObjectArray) {
            return this.memberDivide((ObjectArray)array);
        }
        if (array instanceof StringArray) {
            return this.memberDivide((StringArray)array);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illDivide"));
    }

    private IArray memberDivide(Object value) {
        int size = this.size;
        long[] datas = this.datas;
        boolean[] signs = this.signs;
        if (value instanceof BigDecimal || value instanceof BigInteger) {
            int i;
            BigDecimal v = value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal((BigInteger)value);
            Object[] resultDatas = new Object[size + 1];
            if (signs == null) {
                i = 1;
                while (i <= size) {
                    BigDecimal decimal = new BigDecimal(datas[i]);
                    resultDatas[i] = decimal.divide(v, 16, 4);
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    if (!signs[i]) {
                        BigDecimal decimal = new BigDecimal(datas[i]);
                        resultDatas[i] = decimal.divide(v, 16, 4);
                    }
                    ++i;
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (value instanceof Number) {
            int i;
            double v = ((Number)value).doubleValue();
            double[] resultDatas = new double[size + 1];
            boolean[] resultSigns = null;
            if (signs == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = (double)datas[i] / v;
                    ++i;
                }
            } else {
                resultSigns = new boolean[size + 1];
                i = 1;
                while (i <= size) {
                    if (signs[i]) {
                        resultSigns[i] = true;
                    } else {
                        resultDatas[i] = (double)datas[i] / v;
                    }
                    ++i;
                }
            }
            DoubleArray result = new DoubleArray(resultDatas, resultSigns, size);
            result.setTemporary(true);
            return result;
        }
        if (value instanceof String) {
            int i;
            String str = (String)value;
            Object[] resultDatas = new Object[size + 1];
            if (signs == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = String.valueOf(datas[i]) + str;
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    if (!signs[i]) {
                        resultDatas[i] = String.valueOf(datas[i]) + str;
                    }
                    ++i;
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (value == null) {
            return new ConstArray(null, size);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + Variant.getDataType(value) + mm.getMessage("Variant2.illDivide"));
    }

    private DoubleArray memberDivide(IntArray array) {
        int i;
        int size = this.size;
        long[] d1 = this.datas;
        boolean[] s1 = this.signs;
        int[] d2 = array.getDatas();
        boolean[] s2 = array.getSigns();
        double[] resultDatas = new double[size + 1];
        boolean[] resultSigns = null;
        if (s1 != null) {
            resultSigns = new boolean[size + 1];
            if (s2 != null) {
                System.arraycopy(s2, 1, resultSigns, 1, size);
                i = 1;
                while (i <= size) {
                    if (s1[i]) {
                        resultSigns[i] = true;
                    }
                    ++i;
                }
            } else {
                System.arraycopy(s1, 1, resultSigns, 1, size);
            }
        } else if (s2 != null) {
            resultSigns = new boolean[size + 1];
            System.arraycopy(s2, 1, resultSigns, 1, size);
        }
        if (resultSigns == null) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = (double)d1[i] / (double)d2[i];
                ++i;
            }
        } else {
            i = 1;
            while (i <= size) {
                if (!resultSigns[i]) {
                    resultDatas[i] = (double)d1[i] / (double)d2[i];
                }
                ++i;
            }
        }
        DoubleArray result = new DoubleArray(resultDatas, resultSigns, size);
        result.setTemporary(true);
        return result;
    }

    private DoubleArray memberDivide(LongArray array) {
        int i;
        int size = this.size;
        long[] d1 = this.datas;
        boolean[] s1 = this.signs;
        long[] d2 = array.getDatas();
        boolean[] s2 = array.getSigns();
        double[] resultDatas = new double[size + 1];
        boolean[] resultSigns = null;
        if (s1 != null) {
            resultSigns = new boolean[size + 1];
            if (s2 != null) {
                System.arraycopy(s2, 1, resultSigns, 1, size);
                i = 1;
                while (i <= size) {
                    if (s1[i]) {
                        resultSigns[i] = true;
                    }
                    ++i;
                }
            } else {
                System.arraycopy(s1, 1, resultSigns, 1, size);
            }
        } else if (s2 != null) {
            resultSigns = new boolean[size + 1];
            System.arraycopy(s2, 1, resultSigns, 1, size);
        }
        if (resultSigns == null) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = (double)d1[i] / (double)d2[i];
                ++i;
            }
        } else {
            i = 1;
            while (i <= size) {
                if (!resultSigns[i]) {
                    resultDatas[i] = (double)d1[i] / (double)d2[i];
                }
                ++i;
            }
        }
        DoubleArray result = new DoubleArray(resultDatas, resultSigns, size);
        result.setTemporary(true);
        return result;
    }

    private DoubleArray memberDivide(DoubleArray array) {
        int i;
        double[] resultDatas;
        DoubleArray result;
        int size = this.size;
        long[] d1 = this.datas;
        boolean[] s1 = this.signs;
        double[] d2 = array.getDatas();
        boolean[] s2 = array.getSigns();
        boolean[] resultSigns = null;
        if (array.isTemporary()) {
            result = array;
            resultDatas = d2;
            if (s1 != null) {
                if (s2 == null) {
                    resultSigns = new boolean[size + 1];
                    System.arraycopy(s1, 1, resultSigns, 1, size);
                    array.setSigns(resultSigns);
                } else {
                    resultSigns = s2;
                    i = 1;
                    while (i <= size) {
                        if (s1[i]) {
                            resultSigns[i] = true;
                        }
                        ++i;
                    }
                }
            } else {
                resultSigns = s2;
            }
        } else {
            resultDatas = new double[size + 1];
            if (s1 != null) {
                resultSigns = new boolean[size + 1];
                if (s2 != null) {
                    System.arraycopy(s2, 1, resultSigns, 1, size);
                    i = 1;
                    while (i <= size) {
                        if (s1[i]) {
                            resultSigns[i] = true;
                        }
                        ++i;
                    }
                } else {
                    System.arraycopy(s1, 1, resultSigns, 1, size);
                }
            } else if (s2 != null) {
                resultSigns = new boolean[size + 1];
                System.arraycopy(s2, 1, resultSigns, 1, size);
            }
            result = new DoubleArray(resultDatas, resultSigns, size);
            result.setTemporary(true);
        }
        if (resultSigns == null) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = (double)d1[i] / d2[i];
                ++i;
            }
        } else {
            i = 1;
            while (i <= size) {
                if (!resultSigns[i]) {
                    resultDatas[i] = (double)d1[i] / d2[i];
                }
                ++i;
            }
        }
        return result;
    }

    private StringArray memberDivide(StringArray array) {
        int size = this.size;
        long[] d1 = this.datas;
        boolean[] s1 = this.signs;
        String[] d2 = array.getDatas();
        if (array.isTemporary()) {
            int i = 1;
            while (i <= size) {
                if (s1 == null || !s1[i]) {
                    d2[i] = d2[i] != null ? String.valueOf(d1[i]) + d2[i] : Long.toString(d1[i]);
                }
                ++i;
            }
            return array;
        }
        String[] resultDatas = new String[size + 1];
        int i = 1;
        while (i <= size) {
            if (d2[i] != null) {
                resultDatas[i] = s1 == null || !s1[i] ? String.valueOf(d1[i]) + d2[i] : d2[i];
            } else if (s1 == null || !s1[i]) {
                resultDatas[i] = Long.toString(d1[i]);
            }
            ++i;
        }
        StringArray result = new StringArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    private ObjectArray memberDivide(ObjectArray array) {
        Object[] resultDatas;
        ObjectArray result;
        int size = this.size;
        long[] d1 = this.datas;
        boolean[] s1 = this.signs;
        Object[] d2 = array.getDatas();
        if (array.isTemporary()) {
            result = array;
            resultDatas = d2;
        } else {
            resultDatas = new Object[size + 1];
            result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
        }
        int i = 1;
        while (i <= size) {
            BigDecimal decimal;
            Object v = d2[i];
            if (v instanceof BigDecimal) {
                if (s1 == null || !s1[i]) {
                    decimal = new BigDecimal(d1[i]);
                    resultDatas[i] = decimal.divide((BigDecimal)v, 16, 4);
                } else {
                    resultDatas[i] = null;
                }
            } else if (v instanceof BigInteger) {
                if (s1 == null || !s1[i]) {
                    decimal = new BigDecimal(d1[i]);
                    resultDatas[i] = decimal.divide(new BigDecimal((BigInteger)v), 16, 4);
                } else {
                    resultDatas[i] = null;
                }
            } else if (v instanceof Number) {
                resultDatas[i] = s1 == null || !s1[i] ? Double.valueOf((double)d1[i] / ((Number)v).doubleValue()) : null;
            } else if (v instanceof String) {
                resultDatas[i] = s1 == null || !s1[i] ? String.valueOf(d1[i]) + (String)v : v;
            } else if (v != null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + Variant.getDataType(v) + mm.getMessage("Variant2.illDivide"));
            }
            ++i;
        }
        return result;
    }

    @Override
    public IArray memberMod(IArray array) {
        if (array instanceof IntArray) {
            return this.memberMod((IntArray)array);
        }
        if (array instanceof LongArray) {
            return this.memberMod((LongArray)array);
        }
        if (array instanceof DoubleArray) {
            return this.memberMod((DoubleArray)array);
        }
        if (array instanceof ConstArray) {
            return this.memberMod(array.get(1));
        }
        if (array instanceof ObjectArray) {
            return this.memberMod((ObjectArray)array);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMod"));
    }

    private LongArray memberMod(IntArray array) {
        int i;
        long[] resultDatas;
        LongArray result;
        int size = this.size;
        long[] d1 = this.datas;
        boolean[] s1 = this.signs;
        int[] d2 = array.getDatas();
        boolean[] s2 = array.getSigns();
        boolean[] resultSigns = null;
        if (this.isTemporary()) {
            result = this;
            resultDatas = d1;
            if (s2 == null) {
                resultSigns = s1;
            } else if (s1 == null) {
                resultSigns = new boolean[size + 1];
                System.arraycopy(s2, 1, resultSigns, 1, size);
                this.signs = resultSigns;
            } else {
                resultSigns = s1;
                i = 1;
                while (i <= size) {
                    if (s2[i]) {
                        resultSigns[i] = true;
                    }
                    ++i;
                }
            }
        } else {
            resultDatas = new long[size + 1];
            if (s1 != null) {
                resultSigns = new boolean[size + 1];
                if (s2 != null) {
                    System.arraycopy(s2, 1, resultSigns, 1, size);
                    i = 1;
                    while (i <= size) {
                        if (s1[i]) {
                            resultSigns[i] = true;
                        }
                        ++i;
                    }
                } else {
                    System.arraycopy(s1, 1, resultSigns, 1, size);
                }
            } else if (s2 != null) {
                resultSigns = new boolean[size + 1];
                System.arraycopy(s2, 1, resultSigns, 1, size);
            }
            result = new LongArray(resultDatas, resultSigns, size);
            result.setTemporary(true);
        }
        if (resultSigns == null) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = d1[i] % (long)d2[i];
                ++i;
            }
        } else {
            i = 1;
            while (i <= size) {
                if (!resultSigns[i]) {
                    resultDatas[i] = d1[i] % (long)d2[i];
                }
                ++i;
            }
        }
        return result;
    }

    private LongArray memberMod(LongArray array) {
        int i;
        long[] resultDatas;
        LongArray result;
        int size = this.size;
        long[] d1 = this.datas;
        boolean[] s1 = this.signs;
        long[] d2 = array.datas;
        boolean[] s2 = array.signs;
        boolean[] resultSigns = null;
        if (this.isTemporary()) {
            result = this;
            resultDatas = d1;
            if (s2 == null) {
                resultSigns = s1;
            } else if (s1 == null) {
                resultSigns = new boolean[size + 1];
                System.arraycopy(s2, 1, resultSigns, 1, size);
                this.signs = resultSigns;
            } else {
                resultSigns = s1;
                i = 1;
                while (i <= size) {
                    if (s2[i]) {
                        resultSigns[i] = true;
                    }
                    ++i;
                }
            }
        } else if (array.isTemporary()) {
            result = array;
            resultDatas = d2;
            if (s1 == null) {
                resultSigns = s2;
            } else if (s2 == null) {
                resultSigns = new boolean[size + 1];
                System.arraycopy(s1, 1, resultSigns, 1, size);
                array.signs = resultSigns;
            } else {
                resultSigns = s2;
                i = 1;
                while (i <= size) {
                    if (s1[i]) {
                        resultSigns[i] = true;
                    }
                    ++i;
                }
            }
        } else {
            resultDatas = new long[size + 1];
            if (s1 != null) {
                resultSigns = new boolean[size + 1];
                if (s2 != null) {
                    System.arraycopy(s2, 1, resultSigns, 1, size);
                    i = 1;
                    while (i <= size) {
                        if (s1[i]) {
                            resultSigns[i] = true;
                        }
                        ++i;
                    }
                } else {
                    System.arraycopy(s1, 1, resultSigns, 1, size);
                }
            } else if (s2 != null) {
                resultSigns = new boolean[size + 1];
                System.arraycopy(s2, 1, resultSigns, 1, size);
            }
            result = new LongArray(resultDatas, resultSigns, size);
            result.setTemporary(true);
        }
        if (resultSigns == null) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = d1[i] % d2[i];
                ++i;
            }
        } else {
            i = 1;
            while (i <= size) {
                if (!resultSigns[i]) {
                    resultDatas[i] = d1[i] % d2[i];
                }
                ++i;
            }
        }
        return result;
    }

    private DoubleArray memberMod(DoubleArray array) {
        int i;
        double[] resultDatas;
        DoubleArray result;
        int size = this.size;
        long[] d1 = this.datas;
        boolean[] s1 = this.signs;
        double[] d2 = array.getDatas();
        boolean[] s2 = array.getSigns();
        boolean[] resultSigns = null;
        if (array.isTemporary()) {
            result = array;
            resultDatas = d2;
            if (s1 == null) {
                resultSigns = s2;
            } else if (s2 == null) {
                resultSigns = new boolean[size + 1];
                System.arraycopy(s1, 1, resultSigns, 1, size);
                array.setSigns(resultSigns);
            } else {
                resultSigns = s2;
                i = 1;
                while (i <= size) {
                    if (s1[i]) {
                        resultSigns[i] = true;
                    }
                    ++i;
                }
            }
        } else {
            resultDatas = new double[size + 1];
            if (s1 != null) {
                resultSigns = new boolean[size + 1];
                if (s2 != null) {
                    System.arraycopy(s2, 1, resultSigns, 1, size);
                    i = 1;
                    while (i <= size) {
                        if (s1[i]) {
                            resultSigns[i] = true;
                        }
                        ++i;
                    }
                } else {
                    System.arraycopy(s1, 1, resultSigns, 1, size);
                }
            } else if (s2 != null) {
                resultSigns = new boolean[size + 1];
                System.arraycopy(s2, 1, resultSigns, 1, size);
            }
            result = new DoubleArray(resultDatas, resultSigns, size);
            result.setTemporary(true);
        }
        if (resultSigns == null) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = (double)d1[i] % d2[i];
                ++i;
            }
        } else {
            i = 1;
            while (i <= size) {
                if (!resultSigns[i]) {
                    resultDatas[i] = (double)d1[i] % d2[i];
                }
                ++i;
            }
        }
        return result;
    }

    private IArray memberMod(Object value) {
        int size = this.size;
        long[] datas = this.datas;
        boolean[] signs = this.signs;
        if (value instanceof Double || value instanceof Float) {
            int i;
            double v = ((Number)value).doubleValue();
            double[] resultDatas = new double[size + 1];
            boolean[] resultSigns = null;
            if (signs == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = (double)datas[i] % v;
                    ++i;
                }
            } else {
                resultSigns = new boolean[size + 1];
                i = 1;
                while (i <= size) {
                    if (signs[i]) {
                        resultSigns[i] = true;
                    } else {
                        resultDatas[i] = (double)datas[i] % v;
                    }
                    ++i;
                }
            }
            DoubleArray result = new DoubleArray(resultDatas, resultSigns, size);
            result.setTemporary(true);
            return result;
        }
        if (value instanceof BigDecimal || value instanceof BigInteger) {
            int i;
            BigInteger v = value instanceof BigDecimal ? ((BigDecimal)value).toBigInteger() : (BigInteger)value;
            Object[] resultDatas = new Object[size + 1];
            if (signs == null) {
                i = 1;
                while (i <= size) {
                    BigInteger bi = BigInteger.valueOf(datas[i]);
                    resultDatas[i] = new BigDecimal(bi.mod(v));
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    if (!signs[i]) {
                        BigInteger bi = BigInteger.valueOf(datas[i]);
                        resultDatas[i] = new BigDecimal(bi.mod(v));
                    }
                    ++i;
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (value instanceof Number) {
            int i;
            long v = ((Number)value).longValue();
            if (this.isTemporary()) {
                if (signs == null) {
                    int i2 = 1;
                    while (i2 <= size) {
                        int n = i2++;
                        datas[n] = datas[n] % v;
                    }
                } else {
                    int i3 = 1;
                    while (i3 <= size) {
                        if (!signs[i3]) {
                            int n = i3;
                            datas[n] = datas[n] % v;
                        }
                        ++i3;
                    }
                }
                return this;
            }
            long[] resultDatas = new long[size + 1];
            boolean[] resultSigns = null;
            if (signs == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = datas[i] % v;
                    ++i;
                }
            } else {
                resultSigns = new boolean[size + 1];
                i = 1;
                while (i <= size) {
                    if (signs[i]) {
                        resultSigns[i] = true;
                    } else {
                        resultDatas[i] = datas[i] % v;
                    }
                    ++i;
                }
            }
            LongArray result = new LongArray(resultDatas, resultSigns, size);
            result.setTemporary(true);
            return result;
        }
        if (value == null) {
            return new ConstArray(null, size);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + Variant.getDataType(value) + mm.getMessage("Variant2.illMod"));
    }

    private IArray memberMod(ObjectArray array) {
        Object[] resultDatas;
        ObjectArray result;
        int size = this.size;
        long[] d1 = this.datas;
        boolean[] s1 = this.signs;
        Object[] d2 = array.getDatas();
        if (array.isTemporary()) {
            result = array;
            resultDatas = d2;
        } else {
            resultDatas = new Object[size + 1];
            result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
        }
        int i = 1;
        while (i <= size) {
            BigInteger bi1;
            Object v = d2[i];
            if (v == null || s1 != null && s1[i]) {
                resultDatas[i] = null;
            } else if (v instanceof Double || v instanceof Float) {
                resultDatas[i] = (double)d1[i] % ((Number)v).doubleValue();
            } else if (v instanceof BigDecimal) {
                bi1 = BigInteger.valueOf(d1[i]);
                BigInteger bi2 = ((BigDecimal)v).toBigInteger();
                resultDatas[i] = new BigDecimal(bi1.mod(bi2));
            } else if (v instanceof BigInteger) {
                bi1 = BigInteger.valueOf(d1[i]);
                resultDatas[i] = new BigDecimal(bi1.mod((BigInteger)v));
            } else if (v instanceof Number) {
                resultDatas[i] = d1[i] % ((Number)v).longValue();
            } else {
                MessageManager mm = EngineMessage.get();
                throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + Variant.getDataType(v) + mm.getMessage("Variant2.illMod"));
            }
            ++i;
        }
        return result;
    }

    @Override
    public IArray memberIntDivide(IArray array) {
        if (array instanceof IntArray) {
            return this.memberIntDivide((IntArray)array);
        }
        if (array instanceof LongArray) {
            return this.memberIntDivide((LongArray)array);
        }
        if (array instanceof DoubleArray) {
            return this.memberIntDivide((DoubleArray)array);
        }
        if (array instanceof ConstArray) {
            return this.memberIntDivide(array.get(1));
        }
        if (array instanceof ObjectArray) {
            return this.memberIntDivide((ObjectArray)array);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illDivide"));
    }

    private LongArray memberIntDivide(IntArray array) {
        int i;
        long[] resultDatas;
        LongArray result;
        int size = this.size;
        long[] d1 = this.datas;
        boolean[] s1 = this.signs;
        int[] d2 = array.getDatas();
        boolean[] s2 = array.getSigns();
        boolean[] resultSigns = null;
        if (this.isTemporary()) {
            result = this;
            resultDatas = d1;
            if (s2 == null) {
                resultSigns = s1;
            } else if (s1 == null) {
                resultSigns = new boolean[size + 1];
                System.arraycopy(s2, 1, resultSigns, 1, size);
                this.signs = resultSigns;
            } else {
                resultSigns = s1;
                i = 1;
                while (i <= size) {
                    if (s2[i]) {
                        resultSigns[i] = true;
                    }
                    ++i;
                }
            }
        } else {
            resultDatas = new long[size + 1];
            if (s1 != null) {
                resultSigns = new boolean[size + 1];
                if (s2 != null) {
                    System.arraycopy(s2, 1, resultSigns, 1, size);
                    i = 1;
                    while (i <= size) {
                        if (s1[i]) {
                            resultSigns[i] = true;
                        }
                        ++i;
                    }
                } else {
                    System.arraycopy(s1, 1, resultSigns, 1, size);
                }
            } else if (s2 != null) {
                resultSigns = new boolean[size + 1];
                System.arraycopy(s2, 1, resultSigns, 1, size);
            }
            result = new LongArray(resultDatas, resultSigns, size);
            result.setTemporary(true);
        }
        if (resultSigns == null) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = d1[i] / (long)d2[i];
                ++i;
            }
        } else {
            i = 1;
            while (i <= size) {
                if (!resultSigns[i]) {
                    resultDatas[i] = d1[i] / (long)d2[i];
                }
                ++i;
            }
        }
        return result;
    }

    private LongArray memberIntDivide(LongArray array) {
        int i;
        long[] resultDatas;
        LongArray result;
        int size = this.size;
        long[] d1 = this.datas;
        boolean[] s1 = this.signs;
        long[] d2 = array.datas;
        boolean[] s2 = array.signs;
        boolean[] resultSigns = null;
        if (this.isTemporary()) {
            result = this;
            resultDatas = d1;
            if (s2 == null) {
                resultSigns = s1;
            } else if (s1 == null) {
                resultSigns = new boolean[size + 1];
                System.arraycopy(s2, 1, resultSigns, 1, size);
                this.signs = resultSigns;
            } else {
                resultSigns = s1;
                i = 1;
                while (i <= size) {
                    if (s2[i]) {
                        resultSigns[i] = true;
                    }
                    ++i;
                }
            }
        } else if (array.isTemporary()) {
            result = array;
            resultDatas = d2;
            if (s1 == null) {
                resultSigns = s2;
            } else if (s2 == null) {
                resultSigns = new boolean[size + 1];
                System.arraycopy(s1, 1, resultSigns, 1, size);
                array.setSigns(resultSigns);
            } else {
                resultSigns = s2;
                i = 1;
                while (i <= size) {
                    if (s1[i]) {
                        resultSigns[i] = true;
                    }
                    ++i;
                }
            }
        } else {
            resultDatas = new long[size + 1];
            if (s1 != null) {
                resultSigns = new boolean[size + 1];
                if (s2 != null) {
                    System.arraycopy(s2, 1, resultSigns, 1, size);
                    i = 1;
                    while (i <= size) {
                        if (s1[i]) {
                            resultSigns[i] = true;
                        }
                        ++i;
                    }
                } else {
                    System.arraycopy(s1, 1, resultSigns, 1, size);
                }
            } else if (s2 != null) {
                resultSigns = new boolean[size + 1];
                System.arraycopy(s2, 1, resultSigns, 1, size);
            }
            result = new LongArray(resultDatas, resultSigns, size);
            result.setTemporary(true);
        }
        if (resultSigns == null) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = d1[i] / d2[i];
                ++i;
            }
        } else {
            i = 1;
            while (i <= size) {
                if (!resultSigns[i]) {
                    resultDatas[i] = d1[i] / d2[i];
                }
                ++i;
            }
        }
        return result;
    }

    private LongArray memberIntDivide(DoubleArray array) {
        int i;
        long[] resultDatas;
        LongArray result;
        int size = this.size;
        long[] d1 = this.datas;
        boolean[] s1 = this.signs;
        double[] d2 = array.getDatas();
        boolean[] s2 = array.getSigns();
        boolean[] resultSigns = null;
        if (this.isTemporary()) {
            result = this;
            resultDatas = d1;
            if (s2 == null) {
                resultSigns = s1;
            } else if (s1 == null) {
                resultSigns = new boolean[size + 1];
                System.arraycopy(s2, 1, resultSigns, 1, size);
                this.signs = resultSigns;
            } else {
                resultSigns = s1;
                i = 1;
                while (i <= size) {
                    if (s2[i]) {
                        resultSigns[i] = true;
                    }
                    ++i;
                }
            }
        } else {
            resultDatas = new long[size + 1];
            if (s1 != null) {
                resultSigns = new boolean[size + 1];
                if (s2 != null) {
                    System.arraycopy(s2, 1, resultSigns, 1, size);
                    i = 1;
                    while (i <= size) {
                        if (s1[i]) {
                            resultSigns[i] = true;
                        }
                        ++i;
                    }
                } else {
                    System.arraycopy(s1, 1, resultSigns, 1, size);
                }
            } else if (s2 != null) {
                resultSigns = new boolean[size + 1];
                System.arraycopy(s2, 1, resultSigns, 1, size);
            }
            result = new LongArray(resultDatas, resultSigns, size);
            result.setTemporary(true);
        }
        if (resultSigns == null) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = d1[i] / (long)d2[i];
                ++i;
            }
        } else {
            i = 1;
            while (i <= size) {
                if (!resultSigns[i]) {
                    resultDatas[i] = d1[i] / (long)d2[i];
                }
                ++i;
            }
        }
        return result;
    }

    private IArray memberIntDivide(Object value) {
        int size = this.size;
        long[] datas = this.datas;
        boolean[] signs = this.signs;
        if (value instanceof BigDecimal || value instanceof BigInteger) {
            int i;
            BigInteger v = value instanceof BigDecimal ? ((BigDecimal)value).toBigInteger() : (BigInteger)value;
            Object[] resultDatas = new Object[size + 1];
            if (signs == null) {
                i = 1;
                while (i <= size) {
                    BigInteger bi = BigInteger.valueOf(datas[i]);
                    resultDatas[i] = new BigDecimal(bi.divide(v));
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    if (!signs[i]) {
                        BigInteger bi = BigInteger.valueOf(datas[i]);
                        resultDatas[i] = new BigDecimal(bi.divide(v));
                    }
                    ++i;
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (value instanceof Number) {
            int i;
            long v = ((Number)value).longValue();
            if (this.isTemporary()) {
                if (signs == null) {
                    int i2 = 1;
                    while (i2 <= size) {
                        int n = i2++;
                        datas[n] = datas[n] / v;
                    }
                } else {
                    int i3 = 1;
                    while (i3 <= size) {
                        if (!signs[i3]) {
                            int n = i3;
                            datas[n] = datas[n] / v;
                        }
                        ++i3;
                    }
                }
                return this;
            }
            long[] resultDatas = new long[size + 1];
            boolean[] resultSigns = null;
            if (signs == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = datas[i] / v;
                    ++i;
                }
            } else {
                resultSigns = new boolean[size + 1];
                i = 1;
                while (i <= size) {
                    if (signs[i]) {
                        resultSigns[i] = true;
                    } else {
                        resultDatas[i] = datas[i] / v;
                    }
                    ++i;
                }
            }
            LongArray result = new LongArray(resultDatas, resultSigns, size);
            result.setTemporary(true);
            return result;
        }
        if (value == null) {
            return new ConstArray(null, size);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + Variant.getDataType(value) + mm.getMessage("Variant2.illDivide"));
    }

    private IArray memberIntDivide(ObjectArray array) {
        Object[] resultDatas;
        ObjectArray result;
        int size = this.size;
        long[] d1 = this.datas;
        boolean[] s1 = this.signs;
        Object[] d2 = array.getDatas();
        if (array.isTemporary()) {
            result = array;
            resultDatas = d2;
        } else {
            resultDatas = new Object[size + 1];
            result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
        }
        int i = 1;
        while (i <= size) {
            BigInteger bi1;
            Object v = d2[i];
            if (v == null || s1 != null && s1[i]) {
                resultDatas[i] = null;
            } else if (v instanceof BigDecimal) {
                bi1 = BigInteger.valueOf(d1[i]);
                BigInteger bi2 = ((BigDecimal)v).toBigInteger();
                resultDatas[i] = new BigDecimal(bi1.divide(bi2));
            } else if (v instanceof BigInteger) {
                bi1 = BigInteger.valueOf(d1[i]);
                resultDatas[i] = new BigDecimal(bi1.divide((BigInteger)v));
            } else if (v instanceof Number) {
                resultDatas[i] = d1[i] / ((Number)v).longValue();
            } else {
                MessageManager mm = EngineMessage.get();
                throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + Variant.getDataType(v) + mm.getMessage("Variant2.illDivide"));
            }
            ++i;
        }
        return result;
    }

    @Override
    public IntArray memberCompare(NumberArray rightArray) {
        NumberArray array;
        int size = this.size;
        long[] d1 = this.datas;
        boolean[] s1 = this.signs;
        int[] resultDatas = new int[size + 1];
        if (rightArray instanceof IntArray) {
            array = (IntArray)rightArray;
            int[] d2 = ((IntArray)array).getDatas();
            boolean[] s2 = ((IntArray)array).getSigns();
            int i = 1;
            while (i <= size) {
                resultDatas[i] = s1 == null || !s1[i] ? (s2 == null || !s2[i] ? (d1[i] < (long)d2[i] ? -1 : (d1[i] == (long)d2[i] ? 0 : 1)) : 1) : (s2 == null || !s2[i] ? -1 : 0);
                ++i;
            }
        } else if (rightArray instanceof LongArray) {
            array = (LongArray)rightArray;
            long[] d2 = ((LongArray)array).getDatas();
            boolean[] s2 = ((LongArray)array).getSigns();
            int i = 1;
            while (i <= size) {
                resultDatas[i] = s1 == null || !s1[i] ? (s2 == null || !s2[i] ? (d1[i] < d2[i] ? -1 : (d1[i] == d2[i] ? 0 : 1)) : 1) : (s2 == null || !s2[i] ? -1 : 0);
                ++i;
            }
        } else {
            array = (DoubleArray)rightArray;
            double[] d2 = ((DoubleArray)array).getDatas();
            boolean[] s2 = ((DoubleArray)array).getSigns();
            int i = 1;
            while (i <= size) {
                resultDatas[i] = s1 == null || !s1[i] ? (s2 == null || !s2[i] ? Double.compare(d1[i], d2[i]) : 1) : (s2 == null || !s2[i] ? -1 : 0);
                ++i;
            }
        }
        IntArray result = new IntArray(resultDatas, null, size);
        result.setTemporary(true);
        return result;
    }

    @Override
    public BoolArray calcRelation(IArray array, int relation) {
        if (array instanceof IntArray) {
            return ((IntArray)array).calcRelation(this, Relation.getInverseRelation(relation));
        }
        if (array instanceof LongArray) {
            return this.calcRelation((LongArray)array, relation);
        }
        if (array instanceof DoubleArray) {
            return this.calcRelation((DoubleArray)array, relation);
        }
        if (array instanceof ConstArray) {
            return this.calcRelation(array.get(1), relation);
        }
        if (array instanceof BoolArray) {
            return ((BoolArray)array).calcRelation(this, Relation.getInverseRelation(relation));
        }
        if (array instanceof DateArray) {
            return this.calcRelation((DateArray)array, relation);
        }
        if (array instanceof StringArray) {
            return this.calcRelation((StringArray)array, relation);
        }
        if (array instanceof ObjectArray) {
            return this.calcRelation((ObjectArray)array, relation);
        }
        return array.calcRelation(this, Relation.getInverseRelation(relation));
    }

    @Override
    public BoolArray calcRelation(Object value, int relation) {
        if (value instanceof Double || value instanceof Float) {
            return this.calcRelation(((Number)value).doubleValue(), relation);
        }
        if (value instanceof BigDecimal) {
            return this.calcRelation((BigDecimal)value, relation);
        }
        if (value instanceof BigInteger) {
            BigDecimal decimal = new BigDecimal((BigInteger)value);
            return this.calcRelation(decimal, relation);
        }
        if (value instanceof Number) {
            return this.calcRelation(((Number)value).longValue(), relation);
        }
        if (value == null) {
            return ArrayUtil.calcRelationNull(this.signs, this.size, relation);
        }
        boolean b = Variant.isTrue(value);
        int size = this.size;
        boolean[] s1 = this.signs;
        if (relation == 7) {
            BoolArray result;
            if (!b) {
                result = new BoolArray(false, size);
            } else if (s1 == null) {
                result = new BoolArray(true, size);
            } else {
                boolean[] resultDatas = new boolean[size + 1];
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = !s1[i];
                    ++i;
                }
                result = new BoolArray(resultDatas, size);
            }
            result.setTemporary(true);
            return result;
        }
        if (relation == 8) {
            BoolArray result;
            if (b || s1 == null) {
                result = new BoolArray(true, size);
            } else {
                boolean[] resultDatas = new boolean[size + 1];
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = !s1[i];
                    ++i;
                }
                result = new BoolArray(resultDatas, size);
            }
            result.setTemporary(true);
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), value, this.getDataType(), Variant.getDataType(value)));
    }

    private BoolArray calcRelation(LongArray array, int relation) {
        int i;
        int size = this.size;
        long[] d1 = this.datas;
        boolean[] s1 = this.signs;
        long[] d2 = array.getDatas();
        boolean[] s2 = array.getSigns();
        boolean[] resultDatas = new boolean[size + 1];
        if (relation == 1) {
            if (s1 == null) {
                if (s2 == null) {
                    i = 1;
                    while (i <= size) {
                        resultDatas[i] = d1[i] == d2[i];
                        ++i;
                    }
                } else {
                    i = 1;
                    while (i <= size) {
                        resultDatas[i] = s2[i] ? false : d1[i] == d2[i];
                        ++i;
                    }
                }
            } else if (s2 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? false : d1[i] == d2[i];
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? s2[i] : (s2[i] ? false : d1[i] == d2[i]);
                    ++i;
                }
            }
        } else if (relation == 2) {
            if (s1 == null) {
                if (s2 == null) {
                    i = 1;
                    while (i <= size) {
                        resultDatas[i] = d1[i] > d2[i];
                        ++i;
                    }
                } else {
                    i = 1;
                    while (i <= size) {
                        resultDatas[i] = s2[i] ? true : d1[i] > d2[i];
                        ++i;
                    }
                }
            } else if (s2 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? false : d1[i] > d2[i];
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? false : (s2[i] ? true : d1[i] > d2[i]);
                    ++i;
                }
            }
        } else if (relation == 3) {
            if (s1 == null) {
                if (s2 == null) {
                    i = 1;
                    while (i <= size) {
                        resultDatas[i] = d1[i] >= d2[i];
                        ++i;
                    }
                } else {
                    i = 1;
                    while (i <= size) {
                        resultDatas[i] = s2[i] ? true : d1[i] >= d2[i];
                        ++i;
                    }
                }
            } else if (s2 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? false : d1[i] >= d2[i];
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? s2[i] : (s2[i] ? true : d1[i] >= d2[i]);
                    ++i;
                }
            }
        } else if (relation == 4) {
            if (s1 == null) {
                if (s2 == null) {
                    i = 1;
                    while (i <= size) {
                        resultDatas[i] = d1[i] < d2[i];
                        ++i;
                    }
                } else {
                    i = 1;
                    while (i <= size) {
                        resultDatas[i] = s2[i] ? false : d1[i] < d2[i];
                        ++i;
                    }
                }
            } else if (s2 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? true : d1[i] < d2[i];
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? !s2[i] : (s2[i] ? false : d1[i] < d2[i]);
                    ++i;
                }
            }
        } else if (relation == 5) {
            if (s1 == null) {
                if (s2 == null) {
                    i = 1;
                    while (i <= size) {
                        resultDatas[i] = d1[i] <= d2[i];
                        ++i;
                    }
                } else {
                    i = 1;
                    while (i <= size) {
                        resultDatas[i] = s2[i] ? false : d1[i] <= d2[i];
                        ++i;
                    }
                }
            } else if (s2 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? true : d1[i] <= d2[i];
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? true : (s2[i] ? false : d1[i] <= d2[i]);
                    ++i;
                }
            }
        } else if (relation == 6) {
            if (s1 == null) {
                if (s2 == null) {
                    i = 1;
                    while (i <= size) {
                        resultDatas[i] = d1[i] != d2[i];
                        ++i;
                    }
                } else {
                    i = 1;
                    while (i <= size) {
                        resultDatas[i] = s2[i] ? true : d1[i] != d2[i];
                        ++i;
                    }
                }
            } else if (s2 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? true : d1[i] != d2[i];
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? !s2[i] : (s2[i] ? true : d1[i] != d2[i]);
                    ++i;
                }
            }
        } else if (relation == 7) {
            if (s1 == null) {
                if (s2 == null) {
                    i = 1;
                    while (i <= size) {
                        resultDatas[i] = true;
                        ++i;
                    }
                } else {
                    i = 1;
                    while (i <= size) {
                        resultDatas[i] = !s2[i];
                        ++i;
                    }
                }
            } else if (s2 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = !s1[i];
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = !s1[i] && !s2[i];
                    ++i;
                }
            }
        } else if (s1 == null || s2 == null) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = true;
                ++i;
            }
        } else {
            i = 1;
            while (i <= size) {
                resultDatas[i] = !s1[i] || !s2[i];
                ++i;
            }
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    protected BoolArray calcRelation(DoubleArray array, int relation) {
        int i;
        int size = this.size;
        long[] d1 = this.datas;
        boolean[] s1 = this.signs;
        double[] d2 = array.getDatas();
        boolean[] s2 = array.getSigns();
        boolean[] resultDatas = new boolean[size + 1];
        if (relation == 1) {
            if (s1 == null) {
                if (s2 == null) {
                    i = 1;
                    while (i <= size) {
                        resultDatas[i] = Double.compare(d1[i], d2[i]) == 0;
                        ++i;
                    }
                } else {
                    i = 1;
                    while (i <= size) {
                        resultDatas[i] = s2[i] ? false : Double.compare(d1[i], d2[i]) == 0;
                        ++i;
                    }
                }
            } else if (s2 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? false : Double.compare(d1[i], d2[i]) == 0;
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? s2[i] : (s2[i] ? false : Double.compare(d1[i], d2[i]) == 0);
                    ++i;
                }
            }
        } else if (relation == 2) {
            if (s1 == null) {
                if (s2 == null) {
                    i = 1;
                    while (i <= size) {
                        resultDatas[i] = Double.compare(d1[i], d2[i]) > 0;
                        ++i;
                    }
                } else {
                    i = 1;
                    while (i <= size) {
                        resultDatas[i] = s2[i] ? true : Double.compare(d1[i], d2[i]) > 0;
                        ++i;
                    }
                }
            } else if (s2 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? false : Double.compare(d1[i], d2[i]) > 0;
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? false : (s2[i] ? true : Double.compare(d1[i], d2[i]) > 0);
                    ++i;
                }
            }
        } else if (relation == 3) {
            if (s1 == null) {
                if (s2 == null) {
                    i = 1;
                    while (i <= size) {
                        resultDatas[i] = Double.compare(d1[i], d2[i]) >= 0;
                        ++i;
                    }
                } else {
                    i = 1;
                    while (i <= size) {
                        resultDatas[i] = s2[i] ? true : Double.compare(d1[i], d2[i]) >= 0;
                        ++i;
                    }
                }
            } else if (s2 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? false : Double.compare(d1[i], d2[i]) >= 0;
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? s2[i] : (s2[i] ? true : Double.compare(d1[i], d2[i]) >= 0);
                    ++i;
                }
            }
        } else if (relation == 4) {
            if (s1 == null) {
                if (s2 == null) {
                    i = 1;
                    while (i <= size) {
                        resultDatas[i] = Double.compare(d1[i], d2[i]) < 0;
                        ++i;
                    }
                } else {
                    i = 1;
                    while (i <= size) {
                        resultDatas[i] = s2[i] ? false : Double.compare(d1[i], d2[i]) < 0;
                        ++i;
                    }
                }
            } else if (s2 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? true : Double.compare(d1[i], d2[i]) < 0;
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? !s2[i] : (s2[i] ? false : Double.compare(d1[i], d2[i]) < 0);
                    ++i;
                }
            }
        } else if (relation == 5) {
            if (s1 == null) {
                if (s2 == null) {
                    i = 1;
                    while (i <= size) {
                        resultDatas[i] = Double.compare(d1[i], d2[i]) <= 0;
                        ++i;
                    }
                } else {
                    i = 1;
                    while (i <= size) {
                        resultDatas[i] = s2[i] ? false : Double.compare(d1[i], d2[i]) <= 0;
                        ++i;
                    }
                }
            } else if (s2 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? true : Double.compare(d1[i], d2[i]) <= 0;
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? true : (s2[i] ? false : Double.compare(d1[i], d2[i]) <= 0);
                    ++i;
                }
            }
        } else if (relation == 6) {
            if (s1 == null) {
                if (s2 == null) {
                    i = 1;
                    while (i <= size) {
                        resultDatas[i] = Double.compare(d1[i], d2[i]) != 0;
                        ++i;
                    }
                } else {
                    i = 1;
                    while (i <= size) {
                        resultDatas[i] = s2[i] ? true : Double.compare(d1[i], d2[i]) != 0;
                        ++i;
                    }
                }
            } else if (s2 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? true : Double.compare(d1[i], d2[i]) != 0;
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? !s2[i] : (s2[i] ? true : Double.compare(d1[i], d2[i]) != 0);
                    ++i;
                }
            }
        } else if (relation == 7) {
            if (s1 == null) {
                if (s2 == null) {
                    i = 1;
                    while (i <= size) {
                        resultDatas[i] = true;
                        ++i;
                    }
                } else {
                    i = 1;
                    while (i <= size) {
                        resultDatas[i] = !s2[i];
                        ++i;
                    }
                }
            } else if (s2 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = !s1[i];
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = !s1[i] && !s2[i];
                    ++i;
                }
            }
        } else if (s1 == null || s2 == null) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = true;
                ++i;
            }
        } else {
            i = 1;
            while (i <= size) {
                resultDatas[i] = !s1[i] || !s2[i];
                ++i;
            }
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    private BoolArray calcRelation(long value, int relation) {
        int i;
        int size = this.size;
        long[] d1 = this.datas;
        boolean[] s1 = this.signs;
        boolean[] resultDatas = new boolean[size + 1];
        if (relation == 1) {
            if (s1 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = d1[i] == value;
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? false : d1[i] == value;
                    ++i;
                }
            }
        } else if (relation == 2) {
            if (s1 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = d1[i] > value;
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? false : d1[i] > value;
                    ++i;
                }
            }
        } else if (relation == 3) {
            if (s1 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = d1[i] >= value;
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? false : d1[i] >= value;
                    ++i;
                }
            }
        } else if (relation == 4) {
            if (s1 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = d1[i] < value;
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? true : d1[i] < value;
                    ++i;
                }
            }
        } else if (relation == 5) {
            if (s1 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = d1[i] <= value;
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? true : d1[i] <= value;
                    ++i;
                }
            }
        } else if (relation == 6) {
            if (s1 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = d1[i] != value;
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? true : d1[i] != value;
                    ++i;
                }
            }
        } else if (relation == 7) {
            if (s1 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = true;
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = !s1[i];
                    ++i;
                }
            }
        } else {
            i = 1;
            while (i <= size) {
                resultDatas[i] = true;
                ++i;
            }
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    private BoolArray calcRelation(double value, int relation) {
        int i;
        int size = this.size;
        long[] d1 = this.datas;
        boolean[] s1 = this.signs;
        boolean[] resultDatas = new boolean[size + 1];
        if (relation == 1) {
            if (s1 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = Double.compare(d1[i], value) == 0;
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? false : Double.compare(d1[i], value) == 0;
                    ++i;
                }
            }
        } else if (relation == 2) {
            if (s1 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = Double.compare(d1[i], value) > 0;
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? false : Double.compare(d1[i], value) > 0;
                    ++i;
                }
            }
        } else if (relation == 3) {
            if (s1 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = Double.compare(d1[i], value) >= 0;
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? false : Double.compare(d1[i], value) >= 0;
                    ++i;
                }
            }
        } else if (relation == 4) {
            if (s1 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = Double.compare(d1[i], value) < 0;
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? true : Double.compare(d1[i], value) < 0;
                    ++i;
                }
            }
        } else if (relation == 5) {
            if (s1 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = Double.compare(d1[i], value) <= 0;
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? true : Double.compare(d1[i], value) <= 0;
                    ++i;
                }
            }
        } else if (relation == 6) {
            if (s1 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = Double.compare(d1[i], value) != 0;
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? true : Double.compare(d1[i], value) != 0;
                    ++i;
                }
            }
        } else if (relation == 7) {
            if (s1 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = true;
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = !s1[i];
                    ++i;
                }
            }
        } else {
            i = 1;
            while (i <= size) {
                resultDatas[i] = true;
                ++i;
            }
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    private BoolArray calcRelation(BigDecimal value, int relation) {
        int i;
        int size = this.size;
        long[] d1 = this.datas;
        boolean[] s1 = this.signs;
        boolean[] resultDatas = new boolean[size + 1];
        if (relation == 1) {
            if (s1 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = new BigDecimal(d1[i]).compareTo(value) == 0;
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? false : new BigDecimal(d1[i]).compareTo(value) == 0;
                    ++i;
                }
            }
        } else if (relation == 2) {
            if (s1 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = new BigDecimal(d1[i]).compareTo(value) > 0;
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? false : new BigDecimal(d1[i]).compareTo(value) > 0;
                    ++i;
                }
            }
        } else if (relation == 3) {
            if (s1 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = new BigDecimal(d1[i]).compareTo(value) >= 0;
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? false : new BigDecimal(d1[i]).compareTo(value) >= 0;
                    ++i;
                }
            }
        } else if (relation == 4) {
            if (s1 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = new BigDecimal(d1[i]).compareTo(value) < 0;
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? true : new BigDecimal(d1[i]).compareTo(value) < 0;
                    ++i;
                }
            }
        } else if (relation == 5) {
            if (s1 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = new BigDecimal(d1[i]).compareTo(value) <= 0;
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? true : new BigDecimal(d1[i]).compareTo(value) <= 0;
                    ++i;
                }
            }
        } else if (relation == 6) {
            if (s1 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = new BigDecimal(d1[i]).compareTo(value) != 0;
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? true : new BigDecimal(d1[i]).compareTo(value) != 0;
                    ++i;
                }
            }
        } else if (relation == 7) {
            if (s1 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = true;
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = !s1[i];
                    ++i;
                }
            }
        } else {
            i = 1;
            while (i <= size) {
                resultDatas[i] = true;
                ++i;
            }
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    protected BoolArray calcRelation(DateArray array, int relation) {
        boolean[] s1 = this.signs;
        Date[] datas2 = array.getDatas();
        if (relation == 7) {
            int i;
            boolean[] resultDatas = new boolean[this.size + 1];
            if (s1 == null) {
                i = 1;
                while (i <= this.size) {
                    resultDatas[i] = datas2[i] != null;
                    ++i;
                }
            } else {
                i = 1;
                while (i <= this.size) {
                    resultDatas[i] = !s1[i] && datas2[i] != null;
                    ++i;
                }
            }
            BoolArray result = new BoolArray(resultDatas, this.size);
            result.setTemporary(true);
            return result;
        }
        if (relation == 8) {
            int i;
            boolean[] resultDatas = new boolean[this.size + 1];
            if (s1 == null) {
                i = 1;
                while (i <= this.size) {
                    resultDatas[i] = true;
                    ++i;
                }
            } else {
                i = 1;
                while (i <= this.size) {
                    resultDatas[i] = !s1[i] || datas2[i] != null;
                    ++i;
                }
            }
            BoolArray result = new BoolArray(resultDatas, this.size);
            result.setTemporary(true);
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), array.get(1), this.getDataType(), array.getDataType()));
    }

    protected BoolArray calcRelation(StringArray array, int relation) {
        boolean[] s1 = this.signs;
        String[] datas2 = array.getDatas();
        if (relation == 7) {
            int i;
            boolean[] resultDatas = new boolean[this.size + 1];
            if (s1 == null) {
                i = 1;
                while (i <= this.size) {
                    resultDatas[i] = datas2[i] != null;
                    ++i;
                }
            } else {
                i = 1;
                while (i <= this.size) {
                    resultDatas[i] = !s1[i] && datas2[i] != null;
                    ++i;
                }
            }
            BoolArray result = new BoolArray(resultDatas, this.size);
            result.setTemporary(true);
            return result;
        }
        if (relation == 8) {
            int i;
            boolean[] resultDatas = new boolean[this.size + 1];
            if (s1 == null) {
                i = 1;
                while (i <= this.size) {
                    resultDatas[i] = true;
                    ++i;
                }
            } else {
                i = 1;
                while (i <= this.size) {
                    resultDatas[i] = !s1[i] || datas2[i] != null;
                    ++i;
                }
            }
            BoolArray result = new BoolArray(resultDatas, this.size);
            result.setTemporary(true);
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), array.get(1), this.getDataType(), array.getDataType()));
    }

    protected BoolArray calcRelation(ObjectArray array, int relation) {
        int i;
        int size = this.size;
        long[] d1 = this.datas;
        boolean[] s1 = this.signs;
        Object[] d2 = array.getDatas();
        boolean[] resultDatas = new boolean[size + 1];
        if (relation == 1) {
            if (s1 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = LongArray.compare(d1[i], d2[i]) == 0;
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? d2[i] == null : LongArray.compare(d1[i], d2[i]) == 0;
                    ++i;
                }
            }
        } else if (relation == 2) {
            if (s1 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = LongArray.compare(d1[i], d2[i]) > 0;
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? false : LongArray.compare(d1[i], d2[i]) > 0;
                    ++i;
                }
            }
        } else if (relation == 3) {
            if (s1 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = LongArray.compare(d1[i], d2[i]) >= 0;
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? d2[i] == null : LongArray.compare(d1[i], d2[i]) >= 0;
                    ++i;
                }
            }
        } else if (relation == 4) {
            if (s1 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = LongArray.compare(d1[i], d2[i]) < 0;
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? d2[i] != null : LongArray.compare(d1[i], d2[i]) < 0;
                    ++i;
                }
            }
        } else if (relation == 5) {
            if (s1 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = LongArray.compare(d1[i], d2[i]) <= 0;
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? true : LongArray.compare(d1[i], d2[i]) <= 0;
                    ++i;
                }
            }
        } else if (relation == 6) {
            if (s1 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = LongArray.compare(d1[i], d2[i]) != 0;
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = s1[i] ? d2[i] != null : LongArray.compare(d1[i], d2[i]) != 0;
                    ++i;
                }
            }
        } else if (relation == 7) {
            if (s1 == null) {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = Variant.isTrue(d2[i]);
                    ++i;
                }
            } else {
                i = 1;
                while (i <= size) {
                    resultDatas[i] = !s1[i] && Variant.isTrue(d2[i]);
                    ++i;
                }
            }
        } else if (s1 == null) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = true;
                ++i;
            }
        } else {
            i = 1;
            while (i <= size) {
                resultDatas[i] = !s1[i] || Variant.isTrue(d2[i]);
                ++i;
            }
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int compareTo(IArray array) {
        block58: {
            block60: {
                block59: {
                    block57: {
                        size1 = this.size;
                        size2 = array.size();
                        d1 = this.datas;
                        s1 = this.signs;
                        size = size1;
                        result = 0;
                        if (size1 < size2) {
                            result = -1;
                        } else if (size1 > size2) {
                            result = 1;
                            size = size2;
                        }
                        if (!(array instanceof IntArray)) break block57;
                        array2 = (IntArray)array;
                        d2 = array2.getDatas();
                        s2 = array2.getSigns();
                        i = 1;
                        while (i <= size) {
                            if (s1 != null && s1[i]) ** GOTO lbl27
                            if (s2 == null || !s2[i]) {
                                if (d1[i] > (long)d2[i]) {
                                    return 1;
                                }
                                if (d1[i] < (long)d2[i]) {
                                    return -1;
                                }
                            } else {
                                return 1;
lbl27:
                                // 1 sources

                                if (s2 == null || !s2[i]) {
                                    return -1;
                                }
                            }
                            ++i;
                        }
                        break block58;
                    }
                    if (!(array instanceof LongArray)) break block59;
                    array2 = (LongArray)array;
                    d2 = array2.datas;
                    s2 = array2.signs;
                    i = 1;
                    while (i <= size) {
                        if (s1 != null && s1[i]) ** GOTO lbl47
                        if (s2 == null || !s2[i]) {
                            if (d1[i] > d2[i]) {
                                return 1;
                            }
                            if (d1[i] < d2[i]) {
                                return -1;
                            }
                        } else {
                            return 1;
lbl47:
                            // 1 sources

                            if (s2 == null || !s2[i]) {
                                return -1;
                            }
                        }
                        ++i;
                    }
                    break block58;
                }
                if (!(array instanceof DoubleArray)) break block60;
                array2 = (DoubleArray)array;
                d2 = array2.getDatas();
                s2 = array2.getSigns();
                i = 1;
                while (i <= size) {
                    if (s1 != null && s1[i]) ** GOTO lbl66
                    if (s2 == null || !s2[i]) {
                        cmp = Double.compare(d1[i], d2[i]);
                        if (cmp != 0) {
                            return cmp;
                        }
                    } else {
                        return 1;
lbl66:
                        // 1 sources

                        if (s2 == null || !s2[i]) {
                            return -1;
                        }
                    }
                    ++i;
                }
                break block58;
            }
            if (!(array instanceof ConstArray)) ** GOTO lbl139
            value = array.get(1);
            if (value instanceof Double || value instanceof Float) {
                d2 = ((Number)value).doubleValue();
                i = 1;
                while (i <= size) {
                    if (s1 == null || !s1[i]) {
                        cmp = Double.compare(d1[i], d2);
                        if (cmp != 0) {
                            return cmp;
                        }
                    } else {
                        return -1;
                    }
                    ++i;
                }
            } else if (value instanceof BigDecimal) {
                d2 = (BigDecimal)value;
                i = 1;
                while (i <= size) {
                    if (s1 == null || !s1[i]) {
                        cmp = new BigDecimal(d1[i]).compareTo(d2);
                        if (cmp != 0) {
                            return cmp;
                        }
                    } else {
                        return -1;
                    }
                    ++i;
                }
            } else if (value instanceof BigInteger) {
                d2 = (BigInteger)value;
                i = 1;
                while (i <= size) {
                    if (s1 == null || !s1[i]) {
                        cmp = BigInteger.valueOf(d1[i]).compareTo(d2);
                        if (cmp != 0) {
                            return cmp;
                        }
                    } else {
                        return -1;
                    }
                    ++i;
                }
            } else if (value instanceof Number) {
                d2 = ((Number)value).longValue();
                i = 1;
                while (i <= size) {
                    if (s1 == null || !s1[i]) {
                        if (d1[i] > d2) {
                            return 1;
                        }
                        if (d1[i] < d2) {
                            return -1;
                        }
                    } else {
                        return -1;
                    }
                    ++i;
                }
            } else if (value == null) {
                if (s1 == null) {
                    return 1;
                }
                i = 1;
                while (i <= size) {
                    if (!s1[i]) {
                        return 1;
                    }
                    ++i;
                }
            } else {
                mm = EngineMessage.get();
                throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), value, this.getDataType(), array.getDataType()));
lbl139:
                // 1 sources

                if (array instanceof ObjectArray) {
                    array2 = (ObjectArray)array;
                    d2 = array2.getDatas();
                    i = 1;
                    while (i <= size) {
                        if (s1 == null || !s1[i]) {
                            cmp = LongArray.compare(d1[i], d2[i]);
                            if (cmp != 0) {
                                return cmp;
                            }
                        } else if (d2[i] != null) {
                            return -1;
                        }
                        ++i;
                    }
                } else {
                    mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), array.get(1), this.getDataType(), array.getDataType()));
                }
            }
        }
        return result;
    }

    @Override
    public int memberCompare(int index1, int index2) {
        if (this.signs == null) {
            return LongArray.compare(this.datas[index1], this.datas[index2]);
        }
        if (this.signs[index1]) {
            return this.signs[index2] ? 0 : -1;
        }
        if (this.signs[index2]) {
            return 1;
        }
        return LongArray.compare(this.datas[index1], this.datas[index2]);
    }

    @Override
    public boolean isMemberEquals(int index1, int index2) {
        if (this.signs == null) {
            return this.datas[index1] == this.datas[index2];
        }
        if (this.signs[index1]) {
            return this.signs[index2];
        }
        if (this.signs[index2]) {
            return false;
        }
        return this.datas[index1] == this.datas[index2];
    }

    @Override
    public boolean isEquals(int curIndex, IArray array, int index) {
        if (this.isNull(curIndex)) {
            return array.isNull(index);
        }
        if (array.isNull(index)) {
            return false;
        }
        if (array instanceof IntArray) {
            return this.datas[curIndex] == (long)array.getInt(index);
        }
        if (array instanceof LongArray) {
            return this.datas[curIndex] == array.getLong(index);
        }
        if (array instanceof DoubleArray) {
            return Double.compare(this.datas[curIndex], ((DoubleArray)array).getDouble(index)) == 0;
        }
        return LongArray.compare(this.datas[curIndex], array.get(index)) == 0;
    }

    @Override
    public boolean isEquals(int curIndex, Object value) {
        if (this.signs == null || !this.signs[curIndex]) {
            if (value instanceof Long || value instanceof Integer) {
                return ((Number)value).longValue() == this.datas[curIndex];
            }
            if (value instanceof BigDecimal) {
                return new BigDecimal(this.datas[curIndex]).equals(value);
            }
            if (value instanceof BigInteger) {
                return BigInteger.valueOf(this.datas[curIndex]).equals(value);
            }
            if (value instanceof Number) {
                return Double.compare(this.datas[curIndex], ((Number)value).doubleValue()) == 0;
            }
            return false;
        }
        return value == null;
    }

    @Override
    public int compareTo(int curIndex, IArray array, int index) {
        if (this.isNull(curIndex)) {
            return array.isNull(index) ? 0 : -1;
        }
        if (array.isNull(index)) {
            return 1;
        }
        if (array instanceof LongArray || array instanceof IntArray) {
            return LongArray.compare(this.datas[curIndex], array.getLong(index));
        }
        if (array instanceof DoubleArray) {
            return Double.compare(this.datas[curIndex], ((DoubleArray)array).getDouble(index));
        }
        return LongArray.compare(this.datas[curIndex], array.get(index));
    }

    @Override
    public int compareTo(int curIndex, Object value) {
        if (this.isNull(curIndex)) {
            return value == null ? 0 : -1;
        }
        if (value == null) {
            return 1;
        }
        return LongArray.compare(this.datas[curIndex], value);
    }

    @Override
    public IArray memberAdd(int curIndex, IArray array, int index) {
        if (array.isNull(index)) {
            return this;
        }
        if (array instanceof LongArray || array instanceof IntArray) {
            if (this.signs == null || !this.signs[curIndex]) {
                int n = curIndex;
                this.datas[n] = this.datas[n] + array.getLong(index);
            } else {
                this.datas[curIndex] = array.getLong(index);
                this.signs[curIndex] = false;
            }
            return this;
        }
        if (array instanceof DoubleArray) {
            return this.memberAdd(curIndex, ((DoubleArray)array).getDouble(index));
        }
        Object obj = array.get(index);
        if (obj instanceof Integer || obj instanceof Long) {
            if (this.signs == null || !this.signs[curIndex]) {
                int n = curIndex;
                this.datas[n] = this.datas[n] + ((Number)obj).longValue();
            } else {
                this.datas[curIndex] = ((Number)obj).longValue();
                this.signs[curIndex] = false;
            }
            return this;
        }
        if (obj instanceof Double) {
            return this.memberAdd(curIndex, ((Number)obj).doubleValue());
        }
        if (obj instanceof Number) {
            ObjectArray result = this.toObjectArray();
            if (this.signs == null || !this.signs[curIndex]) {
                obj = Variant.add(this.datas[curIndex], obj);
            }
            result.set(curIndex, obj);
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illAdd"));
    }

    private IArray memberAdd(int curIndex, double v) {
        long[] datas = this.datas;
        boolean[] signs = this.signs;
        int size = this.size;
        double[] resultDatas = new double[datas.length];
        boolean[] resultSigns = null;
        int i = 1;
        while (i <= size) {
            resultDatas[i] = datas[i];
            ++i;
        }
        if (signs == null) {
            int n = curIndex;
            resultDatas[n] = resultDatas[n] + v;
        } else {
            resultSigns = new boolean[datas.length];
            System.arraycopy(signs, 1, resultSigns, 1, size);
            if (!resultSigns[curIndex]) {
                int n = curIndex;
                resultDatas[n] = resultDatas[n] + v;
            } else {
                resultDatas[curIndex] = v;
                resultSigns[curIndex] = false;
            }
        }
        return new DoubleArray(resultDatas, resultSigns, size);
    }

    @Override
    public int hashCode(int index) {
        if (this.signs == null || !this.signs[index]) {
            return Long.hashCode(this.datas[index]);
        }
        return 0;
    }

    @Override
    public Object sum() {
        long[] datas = this.datas;
        boolean[] signs = this.signs;
        int size = this.size;
        long sum = 0L;
        if (signs == null) {
            int i = 1;
            while (i <= size) {
                sum += datas[i];
                ++i;
            }
            return sum;
        }
        boolean sign = false;
        int i = 1;
        while (i <= size) {
            if (!signs[i]) {
                sum += datas[i];
                sign = true;
            }
            ++i;
        }
        return sign ? Long.valueOf(sum) : null;
    }

    @Override
    public Object average() {
        long[] datas = this.datas;
        boolean[] signs = this.signs;
        int size = this.size;
        long sum = 0L;
        int count = 0;
        if (signs == null) {
            count = size;
            int i = 1;
            while (i <= size) {
                sum += datas[i];
                ++i;
            }
        } else {
            int i = 1;
            while (i <= size) {
                if (!signs[i]) {
                    sum += datas[i];
                    ++count;
                }
                ++i;
            }
        }
        if (count != 0) {
            return (double)sum / (double)count;
        }
        return null;
    }

    @Override
    public Object max() {
        int size = this.size;
        if (size == 0) {
            return null;
        }
        long[] datas = this.datas;
        boolean[] signs = this.signs;
        if (signs == null) {
            long max = datas[1];
            int i = 2;
            while (i <= size) {
                if (max < datas[i]) {
                    max = datas[i];
                }
                ++i;
            }
            return max;
        }
        long max = 0L;
        int i = 1;
        while (i <= size) {
            if (!signs[i]) {
                max = datas[i];
                break;
            }
            ++i;
        }
        if (i > size) {
            return null;
        }
        ++i;
        while (i <= size) {
            if (!signs[i] && max < datas[i]) {
                max = datas[i];
            }
            ++i;
        }
        return max;
    }

    @Override
    public Object min() {
        int size = this.size;
        if (size == 0) {
            return null;
        }
        long[] datas = this.datas;
        boolean[] signs = this.signs;
        if (signs == null) {
            long min = datas[1];
            int i = 2;
            while (i <= size) {
                if (min > datas[i]) {
                    min = datas[i];
                }
                ++i;
            }
            return min;
        }
        long min = 0L;
        int i = 1;
        while (i <= size) {
            if (!signs[i]) {
                min = datas[i];
                break;
            }
            ++i;
        }
        if (i > size) {
            return null;
        }
        ++i;
        while (i <= size) {
            if (!signs[i] && min > datas[i]) {
                min = datas[i];
            }
            ++i;
        }
        return min;
    }

    @Override
    public void calcRelations(IArray array, int relation, BoolArray result, boolean isAnd) {
        if (array instanceof IntArray) {
            ((IntArray)array).calcRelations(this, Relation.getInverseRelation(relation), result, isAnd);
        } else if (array instanceof LongArray) {
            this.calcRelations((LongArray)array, relation, result, isAnd);
        } else if (array instanceof DoubleArray) {
            this.calcRelations((DoubleArray)array, relation, result, isAnd);
        } else if (array instanceof ConstArray) {
            this.calcRelations(array.get(1), relation, result, isAnd);
        } else if (array instanceof ObjectArray) {
            this.calcRelations((ObjectArray)array, relation, result, isAnd);
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), array.get(1), this.getDataType(), array.getDataType()));
        }
    }

    @Override
    public void calcRelations(Object value, int relation, BoolArray result, boolean isAnd) {
        if (value instanceof Double || value instanceof Float) {
            this.calcRelations(((Number)value).doubleValue(), relation, result, isAnd);
        } else if (value instanceof BigDecimal) {
            this.calcRelations((BigDecimal)value, relation, result, isAnd);
        } else if (value instanceof BigInteger) {
            BigDecimal decimal = new BigDecimal((BigInteger)value);
            this.calcRelations(decimal, relation, result, isAnd);
        } else if (value instanceof Number) {
            this.calcRelations(((Number)value).longValue(), relation, result, isAnd);
        } else if (value == null) {
            ArrayUtil.calcRelationsNull(this.signs, this.size, relation, result, isAnd);
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), value, this.getDataType(), Variant.getDataType(value)));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void calcRelations(LongArray array, int relation, BoolArray result, boolean isAnd) {
        int size = this.size;
        long[] d1 = this.datas;
        boolean[] s1 = this.signs;
        long[] d2 = array.getDatas();
        boolean[] s2 = array.getSigns();
        boolean[] resultDatas = result.getDatas();
        if (isAnd) {
            if (relation == 1) {
                if (s1 == null) {
                    if (s2 == null) {
                        int i = 1;
                        while (i <= size) {
                            if (resultDatas[i] && d1[i] != d2[i]) {
                                resultDatas[i] = false;
                            }
                            ++i;
                        }
                        return;
                    } else {
                        int i = 1;
                        while (i <= size) {
                            if (resultDatas[i] && (s2[i] || d1[i] != d2[i])) {
                                resultDatas[i] = false;
                            }
                            ++i;
                        }
                    }
                    return;
                } else if (s2 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[i] || d1[i] != d2[i])) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[i] != s2[i] || !s1[i] && d1[i] != d2[i])) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
                return;
            } else if (relation == 2) {
                if (s1 == null) {
                    if (s2 == null) {
                        int i = 1;
                        while (i <= size) {
                            if (resultDatas[i] && d1[i] <= d2[i]) {
                                resultDatas[i] = false;
                            }
                            ++i;
                        }
                        return;
                    } else {
                        int i = 1;
                        while (i <= size) {
                            if (resultDatas[i] && !s2[i] && d1[i] <= d2[i]) {
                                resultDatas[i] = false;
                            }
                            ++i;
                        }
                    }
                    return;
                } else if (s2 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[i] || d1[i] <= d2[i])) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[i] || !s2[i] && d1[i] <= d2[i])) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
                return;
            } else if (relation == 3) {
                if (s1 == null) {
                    if (s2 == null) {
                        int i = 1;
                        while (i <= size) {
                            if (resultDatas[i] && d1[i] < d2[i]) {
                                resultDatas[i] = false;
                            }
                            ++i;
                        }
                        return;
                    } else {
                        int i = 1;
                        while (i <= size) {
                            if (resultDatas[i] && !s2[i] && d1[i] < d2[i]) {
                                resultDatas[i] = false;
                            }
                            ++i;
                        }
                    }
                    return;
                } else if (s2 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[i] || d1[i] < d2[i])) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && !s2[i] && (s1[i] || d1[i] < d2[i])) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
                return;
            } else if (relation == 4) {
                if (s1 == null) {
                    if (s2 == null) {
                        int i = 1;
                        while (i <= size) {
                            if (resultDatas[i] && d1[i] >= d2[i]) {
                                resultDatas[i] = false;
                            }
                            ++i;
                        }
                        return;
                    } else {
                        int i = 1;
                        while (i <= size) {
                            if (resultDatas[i] && (s2[i] || d1[i] >= d2[i])) {
                                resultDatas[i] = false;
                            }
                            ++i;
                        }
                    }
                    return;
                } else if (s2 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[i] && d1[i] >= d2[i]) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && (s2[i] || !s1[i] && d1[i] >= d2[i])) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
                return;
            } else if (relation == 5) {
                if (s1 == null) {
                    if (s2 == null) {
                        int i = 1;
                        while (i <= size) {
                            if (resultDatas[i] && d1[i] > d2[i]) {
                                resultDatas[i] = false;
                            }
                            ++i;
                        }
                        return;
                    } else {
                        int i = 1;
                        while (i <= size) {
                            if (resultDatas[i] && (s2[i] || d1[i] > d2[i])) {
                                resultDatas[i] = false;
                            }
                            ++i;
                        }
                    }
                    return;
                } else if (s2 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[i] && d1[i] > d2[i]) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[i] && (s2[i] || d1[i] > d2[i])) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
                return;
            } else {
                if (relation != 6) throw new RuntimeException();
                if (s1 == null) {
                    if (s2 == null) {
                        int i = 1;
                        while (i <= size) {
                            if (resultDatas[i] && d1[i] == d2[i]) {
                                resultDatas[i] = false;
                            }
                            ++i;
                        }
                        return;
                    } else {
                        int i = 1;
                        while (i <= size) {
                            if (resultDatas[i] && !s2[i] && d1[i] == d2[i]) {
                                resultDatas[i] = false;
                            }
                            ++i;
                        }
                    }
                    return;
                } else if (s2 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[i] && d1[i] == d2[i]) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && s1[i] == s2[i] && (s1[i] || d1[i] == d2[i])) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
            }
            return;
        } else if (relation == 1) {
            if (s1 == null) {
                if (s2 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (!resultDatas[i] && d1[i] == d2[i]) {
                            resultDatas[i] = true;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (!resultDatas[i] && !s2[i] && d1[i] == d2[i]) {
                            resultDatas[i] = true;
                        }
                        ++i;
                    }
                }
                return;
            } else if (s2 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[i] && d1[i] == d2[i]) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[i] ? s2[i] : !s2[i] && d1[i] == d2[i])) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
            return;
        } else if (relation == 2) {
            if (s1 == null) {
                if (s2 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (!resultDatas[i] && d1[i] > d2[i]) {
                            resultDatas[i] = true;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (!resultDatas[i] && (s2[i] || d1[i] > d2[i])) {
                            resultDatas[i] = true;
                        }
                        ++i;
                    }
                }
                return;
            } else if (s2 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[i] && d1[i] > d2[i]) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!(resultDatas[i] || s1[i] || !s2[i] && d1[i] <= d2[i])) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
            return;
        } else if (relation == 3) {
            if (s1 == null) {
                if (s2 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (!resultDatas[i] && d1[i] >= d2[i]) {
                            resultDatas[i] = true;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (!resultDatas[i] && (s2[i] || d1[i] >= d2[i])) {
                            resultDatas[i] = true;
                        }
                        ++i;
                    }
                }
                return;
            } else if (s2 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[i] && d1[i] >= d2[i]) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && (s2[i] || !s1[i] && d1[i] >= d2[i])) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
            return;
        } else if (relation == 4) {
            if (s1 == null) {
                if (s2 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (!resultDatas[i] && d1[i] < d2[i]) {
                            resultDatas[i] = true;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (!resultDatas[i] && !s2[i] && d1[i] < d2[i]) {
                            resultDatas[i] = true;
                        }
                        ++i;
                    }
                }
                return;
            } else if (s2 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[i] || d1[i] < d2[i])) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!(resultDatas[i] || s2[i] || !s1[i] && d1[i] >= d2[i])) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
            return;
        } else if (relation == 5) {
            if (s1 == null) {
                if (s2 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (!resultDatas[i] && d1[i] <= d2[i]) {
                            resultDatas[i] = true;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (!resultDatas[i] && !s2[i] && d1[i] <= d2[i]) {
                            resultDatas[i] = true;
                        }
                        ++i;
                    }
                }
                return;
            } else if (s2 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[i] || d1[i] <= d2[i])) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[i] || !s2[i] && d1[i] <= d2[i])) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
            return;
        } else {
            if (relation != 6) throw new RuntimeException();
            if (s1 == null) {
                if (s2 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (!resultDatas[i] && d1[i] != d2[i]) {
                            resultDatas[i] = true;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (!resultDatas[i] && (s2[i] || d1[i] != d2[i])) {
                            resultDatas[i] = true;
                        }
                        ++i;
                    }
                }
                return;
            } else if (s2 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[i] || d1[i] != d2[i])) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[i] ? !s2[i] : s2[i] || d1[i] != d2[i])) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void calcRelations(DoubleArray array, int relation, BoolArray result, boolean isAnd) {
        int size = this.size;
        long[] d1 = this.datas;
        boolean[] s1 = this.signs;
        double[] d2 = array.getDatas();
        boolean[] s2 = array.getSigns();
        boolean[] resultDatas = result.getDatas();
        if (isAnd) {
            if (relation == 1) {
                if (s1 == null) {
                    if (s2 == null) {
                        int i = 1;
                        while (i <= size) {
                            if (resultDatas[i] && Double.compare(d1[i], d2[i]) != 0) {
                                resultDatas[i] = false;
                            }
                            ++i;
                        }
                        return;
                    } else {
                        int i = 1;
                        while (i <= size) {
                            if (resultDatas[i] && (s2[i] || Double.compare(d1[i], d2[i]) != 0)) {
                                resultDatas[i] = false;
                            }
                            ++i;
                        }
                    }
                    return;
                } else if (s2 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[i] || Double.compare(d1[i], d2[i]) != 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[i] != s2[i] || !s1[i] && Double.compare(d1[i], d2[i]) != 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
                return;
            } else if (relation == 2) {
                if (s1 == null) {
                    if (s2 == null) {
                        int i = 1;
                        while (i <= size) {
                            if (resultDatas[i] && Double.compare(d1[i], d2[i]) <= 0) {
                                resultDatas[i] = false;
                            }
                            ++i;
                        }
                        return;
                    } else {
                        int i = 1;
                        while (i <= size) {
                            if (resultDatas[i] && !s2[i] && Double.compare(d1[i], d2[i]) <= 0) {
                                resultDatas[i] = false;
                            }
                            ++i;
                        }
                    }
                    return;
                } else if (s2 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[i] || Double.compare(d1[i], d2[i]) <= 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[i] || !s2[i] && Double.compare(d1[i], d2[i]) <= 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
                return;
            } else if (relation == 3) {
                if (s1 == null) {
                    if (s2 == null) {
                        int i = 1;
                        while (i <= size) {
                            if (resultDatas[i] && Double.compare(d1[i], d2[i]) < 0) {
                                resultDatas[i] = false;
                            }
                            ++i;
                        }
                        return;
                    } else {
                        int i = 1;
                        while (i <= size) {
                            if (resultDatas[i] && !s2[i] && Double.compare(d1[i], d2[i]) < 0) {
                                resultDatas[i] = false;
                            }
                            ++i;
                        }
                    }
                    return;
                } else if (s2 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[i] || Double.compare(d1[i], d2[i]) < 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && !s2[i] && (s1[i] || Double.compare(d1[i], d2[i]) < 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
                return;
            } else if (relation == 4) {
                if (s1 == null) {
                    if (s2 == null) {
                        int i = 1;
                        while (i <= size) {
                            if (resultDatas[i] && Double.compare(d1[i], d2[i]) >= 0) {
                                resultDatas[i] = false;
                            }
                            ++i;
                        }
                        return;
                    } else {
                        int i = 1;
                        while (i <= size) {
                            if (resultDatas[i] && (s2[i] || Double.compare(d1[i], d2[i]) >= 0)) {
                                resultDatas[i] = false;
                            }
                            ++i;
                        }
                    }
                    return;
                } else if (s2 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[i] && Double.compare(d1[i], d2[i]) >= 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && (s2[i] || !s1[i] && Double.compare(d1[i], d2[i]) >= 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
                return;
            } else if (relation == 5) {
                if (s1 == null) {
                    if (s2 == null) {
                        int i = 1;
                        while (i <= size) {
                            if (resultDatas[i] && Double.compare(d1[i], d2[i]) > 0) {
                                resultDatas[i] = false;
                            }
                            ++i;
                        }
                        return;
                    } else {
                        int i = 1;
                        while (i <= size) {
                            if (resultDatas[i] && (s2[i] || Double.compare(d1[i], d2[i]) > 0)) {
                                resultDatas[i] = false;
                            }
                            ++i;
                        }
                    }
                    return;
                } else if (s2 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[i] && Double.compare(d1[i], d2[i]) > 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[i] && (s2[i] || Double.compare(d1[i], d2[i]) > 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
                return;
            } else {
                if (relation != 6) throw new RuntimeException();
                if (s1 == null) {
                    if (s2 == null) {
                        int i = 1;
                        while (i <= size) {
                            if (resultDatas[i] && Double.compare(d1[i], d2[i]) == 0) {
                                resultDatas[i] = false;
                            }
                            ++i;
                        }
                        return;
                    } else {
                        int i = 1;
                        while (i <= size) {
                            if (resultDatas[i] && !s2[i] && Double.compare(d1[i], d2[i]) == 0) {
                                resultDatas[i] = false;
                            }
                            ++i;
                        }
                    }
                    return;
                } else if (s2 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[i] && Double.compare(d1[i], d2[i]) == 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && s1[i] == s2[i] && (s1[i] || Double.compare(d1[i], d2[i]) == 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
            }
            return;
        } else if (relation == 1) {
            if (s1 == null) {
                if (s2 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (!resultDatas[i] && Double.compare(d1[i], d2[i]) == 0) {
                            resultDatas[i] = true;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (!resultDatas[i] && !s2[i] && Double.compare(d1[i], d2[i]) == 0) {
                            resultDatas[i] = true;
                        }
                        ++i;
                    }
                }
                return;
            } else if (s2 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[i] && Double.compare(d1[i], d2[i]) == 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[i] ? s2[i] : !s2[i] && Double.compare(d1[i], d2[i]) == 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
            return;
        } else if (relation == 2) {
            if (s1 == null) {
                if (s2 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (!resultDatas[i] && Double.compare(d1[i], d2[i]) > 0) {
                            resultDatas[i] = true;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (!resultDatas[i] && (s2[i] || Double.compare(d1[i], d2[i]) > 0)) {
                            resultDatas[i] = true;
                        }
                        ++i;
                    }
                }
                return;
            } else if (s2 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[i] && Double.compare(d1[i], d2[i]) > 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!(resultDatas[i] || s1[i] || !s2[i] && Double.compare(d1[i], d2[i]) <= 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
            return;
        } else if (relation == 3) {
            if (s1 == null) {
                if (s2 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (!resultDatas[i] && Double.compare(d1[i], d2[i]) >= 0) {
                            resultDatas[i] = true;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (!resultDatas[i] && (s2[i] || Double.compare(d1[i], d2[i]) >= 0)) {
                            resultDatas[i] = true;
                        }
                        ++i;
                    }
                }
                return;
            } else if (s2 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[i] && Double.compare(d1[i], d2[i]) >= 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && (s2[i] || !s1[i] && Double.compare(d1[i], d2[i]) >= 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
            return;
        } else if (relation == 4) {
            if (s1 == null) {
                if (s2 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (!resultDatas[i] && Double.compare(d1[i], d2[i]) < 0) {
                            resultDatas[i] = true;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (!resultDatas[i] && !s2[i] && Double.compare(d1[i], d2[i]) < 0) {
                            resultDatas[i] = true;
                        }
                        ++i;
                    }
                }
                return;
            } else if (s2 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[i] || Double.compare(d1[i], d2[i]) < 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!(resultDatas[i] || s2[i] || !s1[i] && Double.compare(d1[i], d2[i]) >= 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
            return;
        } else if (relation == 5) {
            if (s1 == null) {
                if (s2 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (!resultDatas[i] && Double.compare(d1[i], d2[i]) <= 0) {
                            resultDatas[i] = true;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (!resultDatas[i] && !s2[i] && Double.compare(d1[i], d2[i]) <= 0) {
                            resultDatas[i] = true;
                        }
                        ++i;
                    }
                }
                return;
            } else if (s2 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[i] || Double.compare(d1[i], d2[i]) <= 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[i] || !s2[i] && Double.compare(d1[i], d2[i]) <= 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
            return;
        } else {
            if (relation != 6) throw new RuntimeException();
            if (s1 == null) {
                if (s2 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (!resultDatas[i] && Double.compare(d1[i], d2[i]) != 0) {
                            resultDatas[i] = true;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (!resultDatas[i] && (s2[i] || Double.compare(d1[i], d2[i]) != 0)) {
                            resultDatas[i] = true;
                        }
                        ++i;
                    }
                }
                return;
            } else if (s2 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[i] || Double.compare(d1[i], d2[i]) != 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[i] ? !s2[i] : s2[i] || Double.compare(d1[i], d2[i]) != 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void calcRelations(long value, int relation, BoolArray result, boolean isAnd) {
        int size = this.size;
        long[] d1 = this.datas;
        boolean[] s1 = this.signs;
        boolean[] resultDatas = result.getDatas();
        if (isAnd) {
            if (relation == 1) {
                if (s1 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && d1[i] != value) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[i] || d1[i] != value)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
                return;
            } else if (relation == 2) {
                if (s1 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && d1[i] <= value) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[i] || d1[i] <= value)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
                return;
            } else if (relation == 3) {
                if (s1 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && d1[i] < value) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[i] || d1[i] < value)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
                return;
            } else if (relation == 4) {
                if (s1 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && d1[i] >= value) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[i] && d1[i] >= value) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
                return;
            } else if (relation == 5) {
                if (s1 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && d1[i] > value) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[i] && d1[i] > value) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
                return;
            } else {
                if (relation != 6) throw new RuntimeException();
                if (s1 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && d1[i] == value) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[i] && d1[i] == value) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
            }
            return;
        } else if (relation == 1) {
            if (s1 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && d1[i] == value) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[i] && d1[i] == value) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
            return;
        } else if (relation == 2) {
            if (s1 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && d1[i] > value) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[i] && d1[i] > value) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
            return;
        } else if (relation == 3) {
            if (s1 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && d1[i] >= value) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[i] && d1[i] >= value) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
            return;
        } else if (relation == 4) {
            if (s1 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && d1[i] < value) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[i] || d1[i] < value)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
            return;
        } else if (relation == 5) {
            if (s1 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && d1[i] <= value) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[i] || d1[i] <= value)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
            return;
        } else {
            if (relation != 6) throw new RuntimeException();
            if (s1 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && d1[i] != value) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[i] || d1[i] != value)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void calcRelations(double value, int relation, BoolArray result, boolean isAnd) {
        int size = this.size;
        long[] d1 = this.datas;
        boolean[] s1 = this.signs;
        boolean[] resultDatas = result.getDatas();
        if (isAnd) {
            if (relation == 1) {
                if (s1 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && Double.compare(d1[i], value) != 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[i] || Double.compare(d1[i], value) != 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
                return;
            } else if (relation == 2) {
                if (s1 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && Double.compare(d1[i], value) <= 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[i] || Double.compare(d1[i], value) <= 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
                return;
            } else if (relation == 3) {
                if (s1 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && Double.compare(d1[i], value) < 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[i] || Double.compare(d1[i], value) < 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
                return;
            } else if (relation == 4) {
                if (s1 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && Double.compare(d1[i], value) >= 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[i] && Double.compare(d1[i], value) >= 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
                return;
            } else if (relation == 5) {
                if (s1 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && Double.compare(d1[i], value) > 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[i] && Double.compare(d1[i], value) > 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
                return;
            } else {
                if (relation != 6) throw new RuntimeException();
                if (s1 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && Double.compare(d1[i], value) == 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[i] && Double.compare(d1[i], value) == 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
            }
            return;
        } else if (relation == 1) {
            if (s1 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && Double.compare(d1[i], value) == 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[i] && Double.compare(d1[i], value) == 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
            return;
        } else if (relation == 2) {
            if (s1 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && Double.compare(d1[i], value) > 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[i] && Double.compare(d1[i], value) > 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
            return;
        } else if (relation == 3) {
            if (s1 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && Double.compare(d1[i], value) >= 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[i] && Double.compare(d1[i], value) >= 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
            return;
        } else if (relation == 4) {
            if (s1 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && Double.compare(d1[i], value) < 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[i] || Double.compare(d1[i], value) < 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
            return;
        } else if (relation == 5) {
            if (s1 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && Double.compare(d1[i], value) <= 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[i] || Double.compare(d1[i], value) <= 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
            return;
        } else {
            if (relation != 6) throw new RuntimeException();
            if (s1 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && Double.compare(d1[i], value) != 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[i] || Double.compare(d1[i], value) != 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void calcRelations(BigDecimal value, int relation, BoolArray result, boolean isAnd) {
        int size = this.size;
        long[] d1 = this.datas;
        boolean[] s1 = this.signs;
        boolean[] resultDatas = result.getDatas();
        if (isAnd) {
            if (relation == 1) {
                if (s1 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && new BigDecimal(d1[i]).compareTo(value) != 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[i] || new BigDecimal(d1[i]).compareTo(value) != 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
                return;
            } else if (relation == 2) {
                if (s1 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && new BigDecimal(d1[i]).compareTo(value) <= 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[i] || new BigDecimal(d1[i]).compareTo(value) <= 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
                return;
            } else if (relation == 3) {
                if (s1 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && new BigDecimal(d1[i]).compareTo(value) < 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[i] || new BigDecimal(d1[i]).compareTo(value) < 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
                return;
            } else if (relation == 4) {
                if (s1 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && new BigDecimal(d1[i]).compareTo(value) >= 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[i] && new BigDecimal(d1[i]).compareTo(value) >= 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
                return;
            } else if (relation == 5) {
                if (s1 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && new BigDecimal(d1[i]).compareTo(value) > 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[i] && new BigDecimal(d1[i]).compareTo(value) > 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
                return;
            } else {
                if (relation != 6) throw new RuntimeException();
                if (s1 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && new BigDecimal(d1[i]).compareTo(value) == 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[i] && new BigDecimal(d1[i]).compareTo(value) == 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
            }
            return;
        } else if (relation == 1) {
            if (s1 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && new BigDecimal(d1[i]).compareTo(value) == 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[i] && new BigDecimal(d1[i]).compareTo(value) == 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
            return;
        } else if (relation == 2) {
            if (s1 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && new BigDecimal(d1[i]).compareTo(value) > 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[i] && new BigDecimal(d1[i]).compareTo(value) > 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
            return;
        } else if (relation == 3) {
            if (s1 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && new BigDecimal(d1[i]).compareTo(value) >= 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[i] && new BigDecimal(d1[i]).compareTo(value) >= 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
            return;
        } else if (relation == 4) {
            if (s1 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && new BigDecimal(d1[i]).compareTo(value) < 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[i] || new BigDecimal(d1[i]).compareTo(value) < 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
            return;
        } else if (relation == 5) {
            if (s1 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && new BigDecimal(d1[i]).compareTo(value) <= 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[i] || new BigDecimal(d1[i]).compareTo(value) <= 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
            return;
        } else {
            if (relation != 6) throw new RuntimeException();
            if (s1 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && new BigDecimal(d1[i]).compareTo(value) != 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[i] || new BigDecimal(d1[i]).compareTo(value) != 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void calcRelations(ObjectArray array, int relation, BoolArray result, boolean isAnd) {
        int size = this.size;
        long[] d1 = this.datas;
        boolean[] s1 = this.signs;
        Object[] d2 = array.getDatas();
        boolean[] resultDatas = result.getDatas();
        if (isAnd) {
            if (relation == 1) {
                if (s1 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && LongArray.compare(d1[i], d2[i]) != 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[i] ? d2[i] != null : LongArray.compare(d1[i], d2[i]) != 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
                return;
            } else if (relation == 2) {
                if (s1 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && LongArray.compare(d1[i], d2[i]) <= 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[i] || LongArray.compare(d1[i], d2[i]) <= 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
                return;
            } else if (relation == 3) {
                if (s1 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && LongArray.compare(d1[i], d2[i]) < 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[i] ? d2[i] != null : LongArray.compare(d1[i], d2[i]) < 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
                return;
            } else if (relation == 4) {
                if (s1 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && LongArray.compare(d1[i], d2[i]) >= 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[i] ? d2[i] == null : LongArray.compare(d1[i], d2[i]) >= 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
                return;
            } else if (relation == 5) {
                if (s1 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && LongArray.compare(d1[i], d2[i]) > 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[i] && LongArray.compare(d1[i], d2[i]) > 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
                return;
            } else {
                if (relation != 6) throw new RuntimeException();
                if (s1 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && LongArray.compare(d1[i], d2[i]) == 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                    return;
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[i] ? d2[i] == null : LongArray.compare(d1[i], d2[i]) == 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                    }
                }
            }
            return;
        } else if (relation == 1) {
            if (s1 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && LongArray.compare(d1[i], d2[i]) == 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[i] ? d2[i] == null : LongArray.compare(d1[i], d2[i]) == 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
            return;
        } else if (relation == 2) {
            if (s1 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && LongArray.compare(d1[i], d2[i]) > 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[i] && LongArray.compare(d1[i], d2[i]) > 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
            return;
        } else if (relation == 3) {
            if (s1 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && LongArray.compare(d1[i], d2[i]) >= 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && (d2[i] == null || !s1[i] && LongArray.compare(d1[i], d2[i]) >= 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
            return;
        } else if (relation == 4) {
            if (s1 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && LongArray.compare(d1[i], d2[i]) < 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && d2[i] != null && (s1[i] || LongArray.compare(d1[i], d2[i]) < 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
            return;
        } else if (relation == 5) {
            if (s1 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && LongArray.compare(d1[i], d2[i]) <= 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[i] || LongArray.compare(d1[i], d2[i]) <= 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
            return;
        } else {
            if (relation != 6) throw new RuntimeException();
            if (s1 == null) {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && LongArray.compare(d1[i], d2[i]) != 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
                return;
            } else {
                int i = 1;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[i] ? d2[i] != null : LongArray.compare(d1[i], d2[i]) != 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                }
            }
        }
    }

    @Override
    public IArray bitwiseAnd(IArray array) {
        int size = this.size;
        long[] datas = this.datas;
        boolean[] signs = this.signs;
        if (array instanceof NumberArray) {
            LongArray result = new LongArray(size);
            result.setTemporary(true);
            if (signs == null) {
                int i = 1;
                while (i <= size) {
                    if (array.isNull(i)) {
                        result.pushNull();
                    } else {
                        result.pushLong(datas[i] & array.getLong(i));
                    }
                    ++i;
                }
            } else {
                int i = 1;
                while (i <= size) {
                    if (signs[i] || array.isNull(i)) {
                        result.pushNull();
                    } else {
                        result.pushLong(datas[i] & array.getLong(i));
                    }
                    ++i;
                }
            }
            return result;
        }
        if (array instanceof ConstArray) {
            Object value = array.get(1);
            if (value == null) {
                return new ConstArray(null, size);
            }
            if (!(value instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("and" + mm.getMessage("function.paramTypeError"));
            }
            long n = ((Number)value).longValue();
            LongArray result = new LongArray(size);
            result.setTemporary(true);
            if (signs == null) {
                int i = 1;
                while (i <= size) {
                    result.pushLong(datas[i] & n);
                    ++i;
                }
            } else {
                int i = 1;
                while (i <= size) {
                    if (signs[i]) {
                        result.pushNull();
                    } else {
                        result.pushLong(datas[i] & n);
                    }
                    ++i;
                }
            }
            return result;
        }
        return array.bitwiseAnd(this);
    }

    @Override
    public IArray bitwiseOr(IArray array) {
        int size = this.size;
        long[] datas = this.datas;
        boolean[] signs = this.signs;
        if (array instanceof NumberArray) {
            LongArray result = new LongArray(size);
            result.setTemporary(true);
            if (signs == null) {
                int i = 1;
                while (i <= size) {
                    if (array.isNull(i)) {
                        result.pushNull();
                    } else {
                        result.pushLong(datas[i] | array.getLong(i));
                    }
                    ++i;
                }
            } else {
                int i = 1;
                while (i <= size) {
                    if (signs[i] || array.isNull(i)) {
                        result.pushNull();
                    } else {
                        result.pushLong(datas[i] | array.getLong(i));
                    }
                    ++i;
                }
            }
            return result;
        }
        if (array instanceof ConstArray) {
            Object value = array.get(1);
            if (value == null) {
                return new ConstArray(null, size);
            }
            if (!(value instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("or" + mm.getMessage("function.paramTypeError"));
            }
            long n = ((Number)value).longValue();
            LongArray result = new LongArray(size);
            result.setTemporary(true);
            if (signs == null) {
                int i = 1;
                while (i <= size) {
                    result.pushLong(datas[i] | n);
                    ++i;
                }
            } else {
                int i = 1;
                while (i <= size) {
                    if (signs[i]) {
                        result.pushNull();
                    } else {
                        result.pushLong(datas[i] | n);
                    }
                    ++i;
                }
            }
            return result;
        }
        return array.bitwiseOr(this);
    }

    @Override
    public IArray bitwiseXOr(IArray array) {
        int size = this.size;
        long[] datas = this.datas;
        boolean[] signs = this.signs;
        if (array instanceof NumberArray) {
            LongArray result = new LongArray(size);
            result.setTemporary(true);
            if (signs == null) {
                int i = 1;
                while (i <= size) {
                    if (array.isNull(i)) {
                        result.pushNull();
                    } else {
                        result.pushLong(datas[i] ^ array.getLong(i));
                    }
                    ++i;
                }
            } else {
                int i = 1;
                while (i <= size) {
                    if (signs[i] || array.isNull(i)) {
                        result.pushNull();
                    } else {
                        result.pushLong(datas[i] ^ array.getLong(i));
                    }
                    ++i;
                }
            }
            return result;
        }
        if (array instanceof ConstArray) {
            Object value = array.get(1);
            if (value == null) {
                return new ConstArray(null, size);
            }
            if (!(value instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("xor" + mm.getMessage("function.paramTypeError"));
            }
            long n = ((Number)value).longValue();
            LongArray result = new LongArray(size);
            result.setTemporary(true);
            if (signs == null) {
                int i = 1;
                while (i <= size) {
                    result.pushLong(datas[i] ^ n);
                    ++i;
                }
            } else {
                int i = 1;
                while (i <= size) {
                    if (signs[i]) {
                        result.pushNull();
                    } else {
                        result.pushLong(datas[i] ^ n);
                    }
                    ++i;
                }
            }
            return result;
        }
        return array.bitwiseXOr(this);
    }

    @Override
    public IArray bitwiseNot() {
        int i;
        int size = this.size;
        long[] datas = this.datas;
        boolean[] signs = this.signs;
        if (this.isTemporary()) {
            if (signs == null) {
                int i2 = 1;
                while (i2 <= size) {
                    datas[i2] = datas[i2] ^ 0xFFFFFFFFFFFFFFFFL;
                    ++i2;
                }
            } else {
                int i3 = 1;
                while (i3 <= size) {
                    if (!signs[i3]) {
                        datas[i3] = datas[i3] ^ 0xFFFFFFFFFFFFFFFFL;
                    }
                    ++i3;
                }
            }
            return this;
        }
        long[] resultDatas = new long[size + 1];
        boolean[] resultSigns = null;
        if (signs == null) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = datas[i] ^ 0xFFFFFFFFFFFFFFFFL;
                ++i;
            }
        } else {
            resultSigns = new boolean[size + 1];
            System.arraycopy(signs, 1, resultSigns, 1, size);
            i = 1;
            while (i <= size) {
                if (!signs[i]) {
                    resultDatas[i] = datas[i] ^ 0xFFFFFFFFFFFFFFFFL;
                }
                ++i;
            }
        }
        LongArray result = new LongArray(resultDatas, resultSigns, size);
        result.setTemporary(true);
        return result;
    }

    @Override
    public IArray select(IArray signArray) {
        int size = signArray.size();
        long[] d1 = this.datas;
        boolean[] s1 = this.signs;
        long[] resultDatas = new long[size + 1];
        int resultSize = 0;
        if (s1 == null) {
            if (signArray instanceof BoolArray) {
                BoolArray array = (BoolArray)signArray;
                boolean[] d2 = array.getDatas();
                boolean[] s2 = array.getSigns();
                if (s2 == null) {
                    int i = 1;
                    while (i <= size) {
                        if (d2[i]) {
                            resultDatas[++resultSize] = d1[i];
                        }
                        ++i;
                    }
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (!s2[i] && d2[i]) {
                            resultDatas[++resultSize] = d1[i];
                        }
                        ++i;
                    }
                }
            } else {
                int i = 1;
                while (i <= size) {
                    if (signArray.isTrue(i)) {
                        resultDatas[++resultSize] = d1[i];
                    }
                    ++i;
                }
            }
            return new LongArray(resultDatas, null, resultSize);
        }
        boolean[] resultSigns = new boolean[size + 1];
        int i = 1;
        while (i <= size) {
            if (signArray.isTrue(i)) {
                ++resultSize;
                if (s1[i]) {
                    resultSigns[resultSize] = true;
                } else {
                    resultDatas[resultSize] = d1[i];
                }
            }
            ++i;
        }
        return new LongArray(resultDatas, resultSigns, resultSize);
    }

    @Override
    public IArray select(int start, int end, IArray signArray) {
        long[] d1 = this.datas;
        boolean[] s1 = this.signs;
        long[] resultDatas = new long[end - start + 1];
        int resultSize = 0;
        if (s1 == null) {
            if (signArray instanceof BoolArray) {
                BoolArray array = (BoolArray)signArray;
                boolean[] d2 = array.getDatas();
                boolean[] s2 = array.getSigns();
                if (s2 == null) {
                    int i = start;
                    while (i < end) {
                        if (d2[i]) {
                            resultDatas[++resultSize] = d1[i];
                        }
                        ++i;
                    }
                } else {
                    int i = start;
                    while (i < end) {
                        if (!s2[i] && d2[i]) {
                            resultDatas[++resultSize] = d1[i];
                        }
                        ++i;
                    }
                }
            } else {
                int i = start;
                while (i < end) {
                    if (signArray.isTrue(i)) {
                        resultDatas[++resultSize] = d1[i];
                    }
                    ++i;
                }
            }
            return new LongArray(resultDatas, null, resultSize);
        }
        boolean[] resultSigns = new boolean[end - start + 1];
        int i = start;
        while (i < end) {
            if (signArray.isTrue(i)) {
                ++resultSize;
                if (s1[i]) {
                    resultSigns[resultSize] = true;
                } else {
                    resultDatas[resultSize] = d1[i];
                }
            }
            ++i;
        }
        return new LongArray(resultDatas, resultSigns, resultSize);
    }

    @Override
    public Object[] toArray() {
        int size = this.size;
        long[] datas = this.datas;
        boolean[] signs = this.signs;
        Object[] result = new Object[size];
        if (signs == null) {
            int i = 1;
            while (i <= size) {
                result[i - 1] = datas[i];
                ++i;
            }
        } else {
            int i = 1;
            while (i <= size) {
                if (!signs[i]) {
                    result[i - 1] = datas[i];
                }
                ++i;
            }
        }
        return result;
    }

    @Override
    public void toArray(Object[] result) {
        int size = this.size;
        long[] datas = this.datas;
        boolean[] signs = this.signs;
        if (signs == null) {
            int i = 1;
            while (i <= size) {
                result[i - 1] = datas[i];
                ++i;
            }
        } else {
            int i = 1;
            while (i <= size) {
                if (!signs[i]) {
                    result[i - 1] = datas[i];
                }
                ++i;
            }
        }
    }

    @Override
    public IArray split(int pos) {
        int size = this.size;
        boolean[] signs = this.signs;
        int resultSize = size - pos + 1;
        long[] resultDatas = new long[resultSize + 1];
        System.arraycopy(this.datas, pos, resultDatas, 1, resultSize);
        if (signs == null) {
            this.size = pos - 1;
            return new LongArray(resultDatas, null, resultSize);
        }
        boolean[] resultSigns = new boolean[resultSize + 1];
        System.arraycopy(signs, pos, resultSigns, 1, resultSize);
        int i = pos;
        while (i <= size) {
            signs[i] = false;
            ++i;
        }
        this.size = pos - 1;
        return new LongArray(resultDatas, resultSigns, resultSize);
    }

    @Override
    public IArray split(int from, int to) {
        int oldSize = this.size;
        long[] datas = this.datas;
        boolean[] signs = this.signs;
        int resultSize = to - from + 1;
        long[] resultDatas = new long[resultSize + 1];
        System.arraycopy(datas, from, resultDatas, 1, resultSize);
        System.arraycopy(datas, to + 1, datas, from, oldSize - to);
        this.size -= resultSize;
        if (signs == null) {
            return new LongArray(resultDatas, null, resultSize);
        }
        boolean[] resultSigns = new boolean[resultSize + 1];
        System.arraycopy(signs, from, resultSigns, 1, resultSize);
        System.arraycopy(signs, to + 1, signs, from, oldSize - to);
        return new LongArray(resultDatas, resultSigns, resultSize);
    }

    @Override
    public void sort() {
        int size = this.size;
        boolean[] signs = this.signs;
        if (signs == null) {
            MultithreadUtil.sort(this.datas, 1, size + 1);
            return;
        }
        int nullCount = 0;
        int i = 1;
        while (i <= size) {
            if (signs[i]) {
                ++nullCount;
            }
            ++i;
        }
        if (nullCount == 0) {
            MultithreadUtil.sort(this.datas, 1, size + 1);
            this.signs = null;
        } else if (nullCount != size) {
            long[] datas = this.datas;
            int i2 = size;
            int q = size;
            while (i2 > 0) {
                if (signs[i2]) {
                    signs[i2] = false;
                } else {
                    datas[q--] = datas[i2];
                }
                --i2;
            }
            MultithreadUtil.sort(datas, nullCount + 1, size + 1);
            i2 = 1;
            while (i2 <= nullCount) {
                signs[i2] = true;
                ++i2;
            }
        }
    }

    @Override
    public void sort(Comparator<Object> comparator) {
        int size = this.size;
        long[] datas = this.datas;
        boolean[] signs = this.signs;
        Object[] values = new Long[size + 1];
        if (signs == null) {
            int i = 1;
            while (i <= size) {
                values[i] = datas[i];
                ++i;
            }
            MultithreadUtil.sort(values, 1, size + 1, comparator);
            i = 1;
            while (i <= size) {
                datas[i] = (Long)values[i];
                ++i;
            }
        } else {
            int i = 1;
            while (i <= size) {
                if (!signs[i]) {
                    values[i] = datas[i];
                }
                ++i;
            }
            MultithreadUtil.sort(values, 1, size + 1, comparator);
            i = 1;
            while (i <= size) {
                if (values[i] != null) {
                    datas[i] = (Long)values[i];
                    signs[i] = false;
                } else {
                    signs[i] = true;
                }
                ++i;
            }
        }
    }

    @Override
    public boolean hasRecord() {
        return false;
    }

    @Override
    public boolean isPmt(boolean isPure) {
        return false;
    }

    @Override
    public IArray rvs() {
        int size = this.size;
        long[] datas = this.datas;
        boolean[] signs = this.signs;
        long[] resultDatas = new long[size + 1];
        if (signs == null) {
            int i = 1;
            int q = size;
            while (i <= size) {
                resultDatas[i] = datas[q--];
                ++i;
            }
            return new LongArray(resultDatas, null, size);
        }
        boolean[] resultSigns = new boolean[size + 1];
        int i = 1;
        int q = size;
        while (i <= size) {
            if (signs[q]) {
                resultSigns[i] = true;
            } else {
                resultDatas[i] = datas[q];
            }
            ++i;
            --q;
        }
        return new LongArray(resultDatas, resultSigns, size);
    }

    @Override
    public IntArray ptop(int count, boolean isAll, boolean isLast, boolean ignoreNull) {
        int size = this.size;
        if (size == 0) {
            return new IntArray(0);
        }
        long[] datas = this.datas;
        boolean[] signs = this.signs;
        if (ignoreNull) {
            if (count == 1) {
                long minValue = 0L;
                if (isAll) {
                    IntArray result = new IntArray(8);
                    int i = 1;
                    while (i <= size) {
                        if (signs == null || !signs[i]) {
                            minValue = datas[i];
                            result.addInt(i);
                            break;
                        }
                        ++i;
                    }
                    ++i;
                    while (i <= size) {
                        if (signs == null || !signs[i]) {
                            int cmp = LongArray.compare(datas[i], minValue);
                            if (cmp < 0) {
                                minValue = datas[i];
                                result.clear();
                                result.addInt(i);
                            } else if (cmp == 0) {
                                result.addInt(i);
                            }
                        }
                        ++i;
                    }
                    return result;
                }
                if (isLast) {
                    int i = size;
                    int pos = 0;
                    while (i > 0) {
                        if (signs == null || !signs[i]) {
                            minValue = datas[i];
                            pos = i;
                            break;
                        }
                        --i;
                    }
                    --i;
                    while (i > 0) {
                        if (!(signs != null && signs[i] || LongArray.compare(datas[i], minValue) >= 0)) {
                            minValue = datas[i];
                            pos = i;
                        }
                        --i;
                    }
                    IntArray result = new IntArray(1);
                    if (pos != 0) {
                        result.pushInt(pos);
                    }
                    return result;
                }
                int i = 1;
                int pos = 0;
                while (i <= size) {
                    if (signs == null || !signs[i]) {
                        minValue = datas[i];
                        pos = i;
                        break;
                    }
                    ++i;
                }
                ++i;
                while (i <= size) {
                    if (!(signs != null && signs[i] || LongArray.compare(datas[i], minValue) >= 0)) {
                        minValue = datas[i];
                        pos = i;
                    }
                    ++i;
                }
                IntArray result = new IntArray(1);
                if (pos != 0) {
                    result.pushInt(pos);
                }
                return result;
            }
            if (count > 1) {
                int next = count + 1;
                LongArray valueArray = new LongArray(next);
                IntArray posArray = new IntArray(next);
                int i = 1;
                while (i <= size) {
                    if (signs == null || !signs[i]) {
                        int index = valueArray.binarySearch(datas[i]);
                        if (index < 1) {
                            index = -index;
                        }
                        if (index <= count) {
                            valueArray.insertLong(index, datas[i]);
                            posArray.insertInt(index, i);
                            if (valueArray.size() == next) {
                                valueArray.removeLast();
                                posArray.removeLast();
                            }
                        }
                    }
                    ++i;
                }
                return posArray;
            }
            if (count == -1) {
                long maxValue = 0L;
                if (isAll) {
                    IntArray result = new IntArray(8);
                    int i = 1;
                    while (i <= size) {
                        if (signs == null || !signs[i]) {
                            maxValue = datas[i];
                            result.addInt(i);
                            break;
                        }
                        ++i;
                    }
                    ++i;
                    while (i <= size) {
                        if (signs == null || !signs[i]) {
                            int cmp = LongArray.compare(datas[i], maxValue);
                            if (cmp > 0) {
                                maxValue = datas[i];
                                result.clear();
                                result.addInt(i);
                            } else if (cmp == 0) {
                                result.addInt(i);
                            }
                        }
                        ++i;
                    }
                    return result;
                }
                if (isLast) {
                    int i = size;
                    int pos = 0;
                    while (i > 0) {
                        if (signs == null || !signs[i]) {
                            maxValue = datas[i];
                            pos = i;
                            break;
                        }
                        --i;
                    }
                    --i;
                    while (i > 0) {
                        if (!(signs != null && signs[i] || LongArray.compare(datas[i], maxValue) <= 0)) {
                            maxValue = datas[i];
                            pos = i;
                        }
                        --i;
                    }
                    IntArray result = new IntArray(1);
                    if (pos != 0) {
                        result.pushInt(pos);
                    }
                    return result;
                }
                int i = 1;
                int pos = 0;
                while (i <= size) {
                    if (signs == null || !signs[i]) {
                        maxValue = datas[i];
                        pos = i;
                        break;
                    }
                    ++i;
                }
                ++i;
                while (i <= size) {
                    if (!(signs != null && signs[i] || LongArray.compare(datas[i], maxValue) <= 0)) {
                        maxValue = datas[i];
                        pos = i;
                    }
                    ++i;
                }
                IntArray result = new IntArray(1);
                if (pos != 0) {
                    result.pushInt(pos);
                }
                return result;
            }
            if (count < -1) {
                count = -count;
                int next = count + 1;
                LongArray valueArray = new LongArray(next);
                IntArray posArray = new IntArray(next);
                int i = 1;
                while (i <= size) {
                    if (signs == null || !signs[i]) {
                        int index = valueArray.descBinarySearch(datas[i]);
                        if (index < 1) {
                            index = -index;
                        }
                        if (index <= count) {
                            valueArray.insertLong(index, datas[i]);
                            posArray.insertInt(index, i);
                            if (valueArray.size() == next) {
                                valueArray.remove(next);
                                posArray.remove(next);
                            }
                        }
                    }
                    ++i;
                }
                return posArray;
            }
            return new IntArray(1);
        }
        if (count == 1) {
            if (isAll) {
                IntArray result = new IntArray(8);
                if (signs != null) {
                    int i = 1;
                    while (i <= size) {
                        if (signs[i]) {
                            result.addInt(i);
                        }
                        ++i;
                    }
                    if (result.size() > 0) {
                        return result;
                    }
                }
                result.addInt(1);
                long minValue = datas[1];
                int i = 2;
                while (i <= size) {
                    int cmp = LongArray.compare(datas[i], minValue);
                    if (cmp < 0) {
                        minValue = datas[i];
                        result.clear();
                        result.addInt(i);
                    } else if (cmp == 0) {
                        result.addInt(i);
                    }
                    ++i;
                }
                return result;
            }
            if (isLast) {
                if (signs != null) {
                    int i = size;
                    while (i > 0) {
                        if (signs[i]) {
                            IntArray result = new IntArray(1);
                            result.pushInt(i);
                            return result;
                        }
                        --i;
                    }
                }
                long minValue = datas[size];
                int pos = size;
                int i = size - 1;
                while (i > 0) {
                    if (LongArray.compare(datas[i], minValue) < 0) {
                        minValue = datas[i];
                        pos = i;
                    }
                    --i;
                }
                IntArray result = new IntArray(1);
                result.pushInt(pos);
                return result;
            }
            if (signs != null) {
                int i = 1;
                while (i <= size) {
                    if (signs[i]) {
                        IntArray result = new IntArray(1);
                        result.pushInt(i);
                        return result;
                    }
                    ++i;
                }
            }
            long minValue = datas[1];
            int pos = 1;
            int i = 2;
            while (i <= size) {
                if (LongArray.compare(datas[i], minValue) < 0) {
                    minValue = datas[i];
                    pos = i;
                }
                ++i;
            }
            IntArray result = new IntArray(1);
            result.pushInt(pos);
            return result;
        }
        if (count > 1) {
            int next = count + 1;
            LongArray valueArray = new LongArray(next);
            IntArray posArray = new IntArray(next);
            int i = 1;
            while (i <= size) {
                if (signs == null || !signs[i]) {
                    int index = valueArray.binarySearch(datas[i]);
                    if (index < 1) {
                        index = -index;
                    }
                    if (index <= count) {
                        valueArray.insertLong(index, datas[i]);
                        posArray.insertInt(index, i);
                        if (valueArray.size() == next) {
                            valueArray.removeLast();
                            posArray.removeLast();
                        }
                    }
                } else {
                    valueArray.insert(1, null);
                    posArray.insertInt(1, i);
                    if (valueArray.size() == next) {
                        valueArray.removeLast();
                        posArray.removeLast();
                    }
                }
                ++i;
            }
            return posArray;
        }
        if (count == -1) {
            long maxValue = 0L;
            if (isAll) {
                IntArray result = new IntArray(8);
                int i = 1;
                while (i <= size) {
                    if (signs == null || !signs[i]) {
                        maxValue = datas[i];
                        result.addInt(i);
                        break;
                    }
                    ++i;
                }
                ++i;
                while (i <= size) {
                    if (signs == null || !signs[i]) {
                        int cmp = LongArray.compare(datas[i], maxValue);
                        if (cmp > 0) {
                            maxValue = datas[i];
                            result.clear();
                            result.addInt(i);
                        } else if (cmp == 0) {
                            result.addInt(i);
                        }
                    }
                    ++i;
                }
                return result;
            }
            if (isLast) {
                int i = size;
                int pos = 0;
                while (i > 0) {
                    if (signs == null || !signs[i]) {
                        maxValue = datas[i];
                        pos = i;
                        break;
                    }
                    --i;
                }
                --i;
                while (i > 0) {
                    if (!(signs != null && signs[i] || LongArray.compare(datas[i], maxValue) <= 0)) {
                        maxValue = datas[i];
                        pos = i;
                    }
                    --i;
                }
                IntArray result = new IntArray(1);
                if (pos != 0) {
                    result.pushInt(pos);
                }
                return result;
            }
            int i = 1;
            int pos = 0;
            while (i <= size) {
                if (signs == null || !signs[i]) {
                    maxValue = datas[i];
                    pos = i;
                    break;
                }
                ++i;
            }
            ++i;
            while (i <= size) {
                if (!(signs != null && signs[i] || LongArray.compare(datas[i], maxValue) <= 0)) {
                    maxValue = datas[i];
                    pos = i;
                }
                ++i;
            }
            IntArray result = new IntArray(1);
            if (pos != 0) {
                result.pushInt(pos);
            }
            return result;
        }
        if (count < -1) {
            count = -count;
            int next = count + 1;
            LongArray valueArray = new LongArray(next);
            IntArray posArray = new IntArray(next);
            int i = 1;
            while (i <= size) {
                if (signs == null || !signs[i]) {
                    int index = valueArray.descBinarySearch(datas[i]);
                    if (index < 1) {
                        index = -index;
                    }
                    if (index <= count) {
                        valueArray.insertLong(index, datas[i]);
                        posArray.insertInt(index, i);
                        if (valueArray.size() == next) {
                            valueArray.remove(next);
                            posArray.remove(next);
                        }
                    }
                }
                ++i;
            }
            return posArray;
        }
        return new IntArray(1);
    }

    @Override
    public IntArray ptopRank(int count, boolean ignoreNull, boolean iopt) {
        int size = this.size;
        if (size == 0 || count == 0) {
            return new IntArray(0);
        }
        long[] datas = this.datas;
        boolean[] signs = this.signs;
        if (count > 0) {
            int next = count + 1;
            LongArray valueArray = new LongArray(next);
            IntArray posArray = new IntArray(next);
            if (iopt) {
                int curCount = 0;
                int i = 1;
                while (i <= size) {
                    int curSize;
                    if (signs == null || !signs[i]) {
                        if (curCount < count) {
                            int index = valueArray.binarySearch(datas[i]);
                            if (index < 1) {
                                ++curCount;
                                index = -index;
                            }
                            valueArray.insertLong(index, datas[i]);
                            posArray.insertInt(index, i);
                        } else {
                            curSize = valueArray.size();
                            int cmp = this.compareTo(i, valueArray, curSize);
                            if (cmp < 0) {
                                int index = valueArray.binarySearch(datas[i]);
                                if (index < 1) {
                                    index = -index;
                                    long value = valueArray.getLong(curSize);
                                    valueArray.removeLast();
                                    posArray.removeLast();
                                    int j = curSize - 1;
                                    while (j >= count) {
                                        if (valueArray.getLong(j) != value) break;
                                        valueArray.removeLast();
                                        posArray.removeLast();
                                        --j;
                                    }
                                }
                                valueArray.insertLong(index, datas[i]);
                                posArray.insertInt(index, i);
                            } else if (cmp == 0) {
                                valueArray.addLong(datas[i]);
                                posArray.addInt(i);
                            }
                        }
                    } else if (!ignoreNull) {
                        if (curCount < count) {
                            if (curCount == 0 || !valueArray.isNull(1)) {
                                ++curCount;
                            }
                            valueArray.insert(1, null);
                            posArray.insertInt(1, i);
                        } else if (valueArray.isNull(1)) {
                            valueArray.addLong(datas[i]);
                            posArray.addInt(i);
                        } else {
                            curSize = valueArray.size();
                            long value = valueArray.getLong(curSize);
                            valueArray.removeLast();
                            posArray.removeLast();
                            int j = curSize - 1;
                            while (j >= count) {
                                if (valueArray.getLong(j) != value) break;
                                valueArray.removeLast();
                                posArray.removeLast();
                                --j;
                            }
                            valueArray.insert(1, null);
                            posArray.insertInt(1, i);
                        }
                    }
                    ++i;
                }
            } else {
                int i = 1;
                while (i <= size) {
                    int curSize;
                    if (signs == null || !signs[i]) {
                        curSize = valueArray.size();
                        if (curSize < count) {
                            int index = valueArray.binarySearch(datas[i]);
                            if (index < 1) {
                                index = -index;
                            }
                            valueArray.insertLong(index, datas[i]);
                            posArray.insertInt(index, i);
                        } else {
                            int cmp = this.compareTo(i, valueArray, curSize);
                            if (cmp < 0) {
                                int index = valueArray.binarySearch(datas[i]);
                                if (index < 1) {
                                    index = -index;
                                }
                                valueArray.insertLong(index, datas[i]);
                                posArray.insertInt(index, i);
                                if (valueArray.memberCompare(count, curSize + 1) != 0) {
                                    long value = valueArray.getLong(curSize + 1);
                                    valueArray.removeLast();
                                    posArray.removeLast();
                                    int j = curSize;
                                    while (j > count) {
                                        if (valueArray.getLong(j) == value) {
                                            valueArray.removeLast();
                                            posArray.removeLast();
                                            --j;
                                            continue;
                                        }
                                        break;
                                    }
                                }
                            } else if (cmp == 0) {
                                valueArray.addLong(datas[i]);
                                posArray.addInt(i);
                            }
                        }
                    } else if (!ignoreNull) {
                        curSize = valueArray.size();
                        if (curSize < count) {
                            valueArray.insert(1, null);
                            posArray.insertInt(1, i);
                        } else if (valueArray.isNull(curSize)) {
                            valueArray.addLong(datas[i]);
                            posArray.addInt(i);
                        } else {
                            valueArray.insert(1, null);
                            posArray.insertInt(1, i);
                            if (valueArray.memberCompare(count, curSize + 1) != 0) {
                                long value = valueArray.getLong(curSize + 1);
                                valueArray.removeLast();
                                posArray.removeLast();
                                int j = curSize;
                                while (j > count) {
                                    if (valueArray.getLong(j) == value) {
                                        valueArray.removeLast();
                                        posArray.removeLast();
                                        --j;
                                        continue;
                                    }
                                    break;
                                }
                            }
                        }
                    }
                    ++i;
                }
            }
            return posArray;
        }
        count = -count;
        int next = count + 1;
        LongArray valueArray = new LongArray(next);
        IntArray posArray = new IntArray(next);
        if (iopt) {
            int curCount = 0;
            int i = 1;
            while (i <= size) {
                if (signs == null || !signs[i]) {
                    if (curCount < count) {
                        int index = valueArray.descBinarySearch(datas[i]);
                        if (index < 1) {
                            ++curCount;
                            index = -index;
                        }
                        valueArray.insertLong(index, datas[i]);
                        posArray.insertInt(index, i);
                    } else {
                        int curSize = valueArray.size();
                        int cmp = this.compareTo(i, valueArray, curSize);
                        if (cmp > 0) {
                            int index = valueArray.descBinarySearch(datas[i]);
                            if (index < 1) {
                                index = -index;
                                long value = valueArray.getLong(curSize);
                                valueArray.removeLast();
                                posArray.removeLast();
                                int j = curSize - 1;
                                while (j >= count) {
                                    if (valueArray.getLong(j) != value) break;
                                    valueArray.removeLast();
                                    posArray.removeLast();
                                    --j;
                                }
                            }
                            valueArray.insertLong(index, datas[i]);
                            posArray.insertInt(index, i);
                        } else if (cmp == 0) {
                            valueArray.addLong(datas[i]);
                            posArray.addInt(i);
                        }
                    }
                }
                ++i;
            }
        } else {
            int i = 1;
            while (i <= size) {
                if (signs == null || !signs[i]) {
                    int curSize = valueArray.size();
                    if (curSize < count) {
                        int index = valueArray.descBinarySearch(datas[i]);
                        if (index < 1) {
                            index = -index;
                        }
                        valueArray.insertLong(index, datas[i]);
                        posArray.insertInt(index, i);
                    } else {
                        int cmp = this.compareTo(i, valueArray, curSize);
                        if (cmp > 0) {
                            int index = valueArray.descBinarySearch(datas[i]);
                            if (index < 1) {
                                index = -index;
                            }
                            valueArray.insertLong(index, datas[i]);
                            posArray.insertInt(index, i);
                            if (valueArray.memberCompare(count, curSize + 1) != 0) {
                                long value = valueArray.getLong(curSize + 1);
                                valueArray.removeLast();
                                posArray.removeLast();
                                int j = curSize;
                                while (j > count) {
                                    if (valueArray.getLong(j) == value) {
                                        valueArray.removeLast();
                                        posArray.removeLast();
                                        --j;
                                        continue;
                                    }
                                    break;
                                }
                            }
                        } else if (cmp == 0) {
                            valueArray.addLong(datas[i]);
                            posArray.addInt(i);
                        }
                    }
                }
                ++i;
            }
        }
        return posArray;
    }

    @Override
    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public ObjectArray toObjectArray() {
        int size = this.size;
        long[] datas = this.datas;
        boolean[] signs = this.signs;
        Object[] resultDatas = new Object[size + 1];
        if (signs == null) {
            int i = 1;
            while (i <= size) {
                resultDatas[i] = datas[i];
                ++i;
            }
        } else {
            int i = 1;
            while (i <= size) {
                if (!signs[i]) {
                    resultDatas[i] = datas[i];
                }
                ++i;
            }
        }
        return new ObjectArray(resultDatas, size);
    }

    @Override
    public IArray toPureArray() {
        return this;
    }

    public void setLong(int index, long value) {
        this.datas[index] = value;
    }

    @Override
    public IArray reserve(boolean refOrigin) {
        if (this.isTemporary()) {
            this.setTemporary(false);
            return this;
        }
        if (refOrigin) {
            return this;
        }
        return this.dup();
    }

    @Override
    public IArray combine(IArray signArray, IArray other) {
        IArray result;
        if (other instanceof ConstArray) {
            return this.combine(signArray, ((ConstArray)other).getData());
        }
        int size = this.size;
        long[] datas = this.datas;
        boolean[] signs = this.signs;
        if (other instanceof LongArray || other instanceof IntArray) {
            if (this.isTemporary()) {
                result = this;
                int i = 1;
                while (i <= size) {
                    if (signArray.isFalse(i)) {
                        if (other.isNull(i)) {
                            if (signs == null) {
                                this.signs = signs = new boolean[size + 1];
                            }
                            signs[i] = true;
                        } else {
                            datas[i] = other.getLong(i);
                            if (signs != null) {
                                signs[i] = false;
                            }
                        }
                    }
                    ++i;
                }
            } else {
                LongArray resultArray;
                result = resultArray = new LongArray(size);
                if (signs == null) {
                    int i = 1;
                    while (i <= size) {
                        if (signArray.isTrue(i)) {
                            resultArray.pushLong(datas[i]);
                        } else if (other.isNull(i)) {
                            resultArray.pushNull();
                        } else {
                            resultArray.pushLong(other.getLong(i));
                        }
                        ++i;
                    }
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (signArray.isTrue(i)) {
                            if (signs[i]) {
                                resultArray.pushNull();
                            } else {
                                resultArray.pushLong(datas[i]);
                            }
                        } else if (other.isNull(i)) {
                            resultArray.pushNull();
                        } else {
                            resultArray.pushLong(other.getLong(i));
                        }
                        ++i;
                    }
                }
            }
        } else if (other instanceof DoubleArray) {
            DoubleArray otherArray = (DoubleArray)other;
            DoubleArray resultArray = new DoubleArray(size);
            result = resultArray;
            if (signs == null) {
                int i = 1;
                while (i <= size) {
                    if (signArray.isTrue(i)) {
                        resultArray.pushDouble(datas[i]);
                    } else if (otherArray.isNull(i)) {
                        resultArray.pushNull();
                    } else {
                        resultArray.pushDouble(otherArray.getDouble(i));
                    }
                    ++i;
                }
            } else {
                int i = 1;
                while (i <= size) {
                    if (signArray.isTrue(i)) {
                        if (signs[i]) {
                            resultArray.pushNull();
                        } else {
                            resultArray.pushDouble(datas[i]);
                        }
                    } else if (otherArray.isNull(i)) {
                        resultArray.pushNull();
                    } else {
                        resultArray.pushDouble(otherArray.getDouble(i));
                    }
                    ++i;
                }
            }
        } else {
            Object[] resultDatas = new Object[size + 1];
            if (signs == null) {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = signArray.isTrue(i) ? Long.valueOf(datas[i]) : other.get(i);
                    ++i;
                }
            } else {
                int i = 1;
                while (i <= size) {
                    if (signArray.isTrue(i)) {
                        if (!signs[i]) {
                            resultDatas[i] = datas[i];
                        }
                    } else {
                        resultDatas[i] = other.get(i);
                    }
                    ++i;
                }
            }
            result = new ObjectArray(resultDatas, size);
        }
        result.setTemporary(true);
        return result;
    }

    @Override
    public IArray combine(IArray signArray, Object value) {
        IArray result;
        int size = this.size;
        long[] datas = this.datas;
        boolean[] signs = this.signs;
        if (value instanceof Long || value instanceof Integer) {
            long v = ((Number)value).longValue();
            if (this.isTemporary()) {
                result = this;
                if (signs == null) {
                    int i = 1;
                    while (i <= size) {
                        if (signArray.isFalse(i)) {
                            datas[i] = v;
                        }
                        ++i;
                    }
                } else {
                    int i = 1;
                    while (i <= size) {
                        if (signArray.isFalse(i)) {
                            datas[i] = v;
                            signs[i] = false;
                        }
                        ++i;
                    }
                }
            } else {
                long[] resultDatas = new long[size + 1];
                boolean[] resultSigns = null;
                if (signs == null) {
                    int i = 1;
                    while (i <= size) {
                        resultDatas[i] = signArray.isTrue(i) ? datas[i] : v;
                        ++i;
                    }
                } else {
                    resultSigns = new boolean[size + 1];
                    int i = 1;
                    while (i <= size) {
                        if (signArray.isTrue(i)) {
                            if (signs[i]) {
                                resultSigns[i] = true;
                            } else {
                                resultDatas[i] = datas[i];
                            }
                        } else {
                            resultDatas[i] = v;
                        }
                        ++i;
                    }
                }
                result = new LongArray(resultDatas, resultSigns, size);
            }
        } else if (value instanceof Double) {
            double v = ((Number)value).doubleValue();
            double[] resultDatas = new double[size + 1];
            boolean[] resultSigns = null;
            if (signs == null) {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = signArray.isTrue(i) ? (double)datas[i] : v;
                    ++i;
                }
            } else {
                resultSigns = new boolean[size + 1];
                int i = 1;
                while (i <= size) {
                    if (signArray.isTrue(i)) {
                        if (signs[i]) {
                            resultSigns[i] = true;
                        } else {
                            resultDatas[i] = datas[i];
                        }
                    } else {
                        resultDatas[i] = v;
                    }
                    ++i;
                }
            }
            result = new DoubleArray(resultDatas, resultSigns, size);
        } else if (value == null) {
            if (this.isTemporary()) {
                result = this;
                if (signs == null) {
                    this.signs = signs = new boolean[size + 1];
                }
                int i = 1;
                while (i <= size) {
                    if (signArray.isFalse(i)) {
                        signs[i] = true;
                    }
                    ++i;
                }
            } else {
                boolean[] resultSigns = new boolean[size + 1];
                long[] resultDatas = new long[size + 1];
                int i = 1;
                while (i <= size) {
                    if (signArray.isTrue(i) && (signs == null || !signs[i])) {
                        resultDatas[i] = datas[i];
                    } else {
                        resultSigns[i] = true;
                    }
                    ++i;
                }
                result = new LongArray(resultDatas, resultSigns, size);
            }
        } else {
            Object[] resultDatas = new Object[size + 1];
            if (signs == null) {
                int i = 1;
                while (i <= size) {
                    resultDatas[i] = signArray.isTrue(i) ? Long.valueOf(datas[i]) : value;
                    ++i;
                }
            } else {
                int i = 1;
                while (i <= size) {
                    if (signArray.isTrue(i)) {
                        if (!signs[i]) {
                            resultDatas[i] = datas[i];
                        }
                    } else {
                        resultDatas[i] = value;
                    }
                    ++i;
                }
            }
            result = new ObjectArray(resultDatas, size);
        }
        result.setTemporary(true);
        return result;
    }

    @Override
    public Object pos(IArray array, String opt) {
        if (array instanceof LongArray || array instanceof IntArray) {
            int len = this.size;
            int subLen = array.size();
            if (len < subLen) {
                return null;
            }
            boolean isSorted = false;
            boolean isIncre = false;
            boolean isContinuous = false;
            if (opt != null) {
                if (opt.indexOf(98) != -1) {
                    isSorted = true;
                }
                if (opt.indexOf(105) != -1) {
                    isIncre = true;
                }
                if (opt.indexOf(99) != -1) {
                    isContinuous = true;
                }
            }
            if (isIncre) {
                IntArray result = new IntArray(subLen);
                if (isSorted) {
                    int pos = 1;
                    int t = 1;
                    while (t <= subLen) {
                        pos = array.isNull(t) ? this.binarySearch(null, pos, len) : this.binarySearch(array.getLong(t), pos, len);
                        if (pos > 0) {
                            result.pushInt(pos);
                            ++pos;
                        } else {
                            return null;
                        }
                        ++t;
                    }
                } else {
                    int pos = 1;
                    int t = 1;
                    while (t <= subLen) {
                        pos = array.isNull(t) ? this.firstIndexOf(null, pos) : this.firstIndexOf(array.getLong(t), pos);
                        if (pos > 0) {
                            result.pushInt(pos);
                            ++pos;
                        } else {
                            return null;
                        }
                        ++t;
                    }
                }
                return new Sequence(result);
            }
            if (isContinuous) {
                int maxCandidate = len - subLen + 1;
                if (isSorted) {
                    int candidate = 1;
                    block2: while (candidate <= maxCandidate) {
                        int result = this.compareTo(candidate, array, 1);
                        if (result < 0) {
                            ++candidate;
                            continue;
                        }
                        if (result == 0) {
                            int i = 2;
                            int j = candidate + 1;
                            while (i <= subLen) {
                                if (!this.isEquals(j, array, i)) {
                                    ++candidate;
                                    continue block2;
                                }
                                ++i;
                                ++j;
                            }
                            return candidate;
                        }
                        return null;
                    }
                } else {
                    int candidate = 1;
                    while (candidate <= maxCandidate) {
                        block32: {
                            int i = 1;
                            int j = candidate;
                            while (i <= subLen) {
                                if (this.isEquals(j, array, i)) {
                                    ++i;
                                    ++j;
                                    continue;
                                }
                                break block32;
                            }
                            return candidate;
                        }
                        ++candidate;
                    }
                }
                return null;
            }
            IntArray result = new IntArray(subLen);
            if (isSorted) {
                int t = 1;
                while (t <= subLen) {
                    int pos = array.isNull(t) ? this.binarySearch(null) : this.binarySearch(array.getLong(t));
                    if (pos <= 0) {
                        return null;
                    }
                    result.pushInt(pos);
                    ++t;
                }
            } else {
                int t = 1;
                while (t <= subLen) {
                    int pos = array.isNull(t) ? this.firstIndexOf(null, 1) : this.firstIndexOf(array.getLong(t), 1);
                    if (pos <= 0) {
                        return null;
                    }
                    result.pushInt(pos);
                    ++t;
                }
            }
            return new Sequence(result);
        }
        return ArrayUtil.pos(this, array, opt);
    }

    @Override
    public int bit1() {
        long[] datas = this.datas;
        boolean[] signs = this.signs;
        int size = this.size;
        int sum = 0;
        if (signs == null) {
            int i = 1;
            while (i <= size) {
                sum += Long.bitCount(datas[i]);
                ++i;
            }
        } else {
            int i = 1;
            while (i <= size) {
                if (!signs[i]) {
                    sum += Long.bitCount(datas[i]);
                }
                ++i;
            }
        }
        return sum;
    }

    @Override
    public int bit1(IArray array) {
        if (array instanceof LongArray) {
            return this.bit1((LongArray)array);
        }
        if (array instanceof IntArray) {
            return this.bit1((IntArray)array);
        }
        int size = this.size;
        int count = 0;
        int i = 1;
        while (i <= size) {
            count += Bit1.bitCount(this.get(i), array.get(i));
            ++i;
        }
        return count;
    }

    public static int bitCount(long v) {
        v -= v >>> 1 & 0x5555555555555555L;
        v = (v & 0x3333333333333333L) + (v >>> 2 & 0x3333333333333333L);
        v = v + (v >>> 4) & 0xF0F0F0F0F0F0F0FL;
        v += v >>> 8;
        v += v >>> 16;
        v += v >>> 32;
        return (int)v & 0x7F;
    }

    private int bit1(LongArray array) {
        int size = this.size;
        long[] d1 = this.datas;
        boolean[] s1 = this.signs;
        long[] d2 = array.datas;
        boolean[] s2 = array.signs;
        int count = 0;
        if (s1 == null) {
            if (s2 == null) {
                int i = 1;
                while (i <= size) {
                    count += Long.bitCount(d1[i] ^ d2[i]);
                    ++i;
                }
            } else {
                int i = 1;
                while (i <= size) {
                    if (!s2[i]) {
                        count += Long.bitCount(d1[i] ^ d2[i]);
                    }
                    ++i;
                }
            }
        } else if (s2 == null) {
            int i = 1;
            while (i <= size) {
                if (!s1[i]) {
                    count += Long.bitCount(d1[i] ^ d2[i]);
                }
                ++i;
            }
        } else {
            int i = 1;
            while (i <= size) {
                if (!s1[i] && !s2[i]) {
                    count += Long.bitCount(d1[i] ^ d2[i]);
                }
                ++i;
            }
        }
        return count;
    }

    public int bit1(IntArray array) {
        int size = this.size;
        long[] d1 = this.datas;
        boolean[] s1 = this.signs;
        int[] d2 = array.getDatas();
        boolean[] s2 = array.getSigns();
        int count = 0;
        if (s1 == null) {
            if (s2 == null) {
                int i = 1;
                while (i <= size) {
                    count += Long.bitCount(d1[i] ^ (long)d2[i]);
                    ++i;
                }
            } else {
                int i = 1;
                while (i <= size) {
                    if (!s2[i]) {
                        count += Long.bitCount(d1[i] ^ (long)d2[i]);
                    }
                    ++i;
                }
            }
        } else if (s2 == null) {
            int i = 1;
            while (i <= size) {
                if (!s1[i]) {
                    count += Long.bitCount(d1[i] ^ (long)d2[i]);
                }
                ++i;
            }
        } else {
            int i = 1;
            while (i <= size) {
                if (!s1[i] && !s2[i]) {
                    count += Long.bitCount(d1[i] ^ (long)d2[i]);
                }
                ++i;
            }
        }
        return count;
    }

    @Override
    public boolean hasSigns() {
        return this.signs != null;
    }

    @Override
    public int getNextEqualCount(int index) {
        long[] datas = this.datas;
        boolean[] signs = this.signs;
        int size = this.size;
        int count = 1;
        if (signs == null) {
            long value = datas[index];
            ++index;
            while (index <= size) {
                if (datas[index] == value) {
                    ++count;
                    ++index;
                    continue;
                }
                break;
            }
        } else if (signs[index]) {
            ++index;
            while (index <= size) {
                if (signs[index]) {
                    ++count;
                    ++index;
                    continue;
                }
                break;
            }
        } else {
            long value = datas[index];
            ++index;
            while (index <= size) {
                if (!signs[index] && datas[index] == value) {
                    ++count;
                    ++index;
                    continue;
                }
                break;
            }
        }
        return count;
    }
}

