/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.array;

import com.scudata.array.ArrayUtil;
import com.scudata.array.BoolArray;
import com.scudata.array.ConstArray;
import com.scudata.array.DateArray;
import com.scudata.array.DoubleArray;
import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.array.LongArray;
import com.scudata.array.StringArray;
import com.scudata.common.ByteArrayInputRecord;
import com.scudata.common.ByteArrayOutputRecord;
import com.scudata.common.MessageManager;
import com.scudata.common.ObjectCache;
import com.scudata.common.RQException;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Sequence;
import com.scudata.expression.Relation;
import com.scudata.expression.fn.math.And;
import com.scudata.expression.fn.math.Bit1;
import com.scudata.expression.fn.math.Not;
import com.scudata.expression.fn.math.Or;
import com.scudata.expression.fn.math.Xor;
import com.scudata.resources.EngineMessage;
import com.scudata.thread.MultithreadUtil;
import com.scudata.util.CursorUtil;
import com.scudata.util.Variant;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.Date;

public class ObjectArray
implements IArray {
    private static final long serialVersionUID = 1L;
    private Object[] datas;
    private int size;

    public ObjectArray() {
        this.datas = new Object[8];
    }

    public ObjectArray(int initialCapacity) {
        this.datas = new Object[++initialCapacity];
    }

    public ObjectArray(Object[] values) {
        this.size = values.length;
        this.datas = new Object[this.size + 1];
        System.arraycopy(values, 0, this.datas, 1, this.size);
    }

    public ObjectArray(Object[] datas, int size) {
        this.datas = datas;
        this.size = size;
    }

    public Object[] getDatas() {
        return this.datas;
    }

    @Override
    public String getDataType() {
        Object[] datas = this.datas;
        int i = 1;
        int size = this.size;
        while (i <= size) {
            if (datas[i] != null) {
                return Variant.getDataType(datas[i]);
            }
            ++i;
        }
        MessageManager mm = EngineMessage.get();
        return mm.getMessage("DataType.Null");
    }

    @Override
    public IArray dup() {
        int len = this.size + 1;
        Object[] newDatas = new Object[len];
        System.arraycopy(this.datas, 0, newDatas, 0, len);
        return new ObjectArray(newDatas, this.size);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int size = this.size;
        Object[] datas = this.datas;
        out.writeByte(1);
        out.writeInt(size);
        int i = 1;
        while (i <= size) {
            out.writeObject(datas[i]);
            ++i;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        this.size = in.readInt();
        int len = this.size + 1;
        this.datas = new Object[len];
        Object[] datas = this.datas;
        int i = 1;
        while (i < len) {
            datas[i] = in.readObject();
            ++i;
        }
    }

    @Override
    public byte[] serialize() throws IOException {
        ByteArrayOutputRecord out = new ByteArrayOutputRecord();
        int size = this.size;
        Object[] datas = this.datas;
        out.writeInt(size);
        out.writeInt(datas.length);
        int i = 1;
        while (i <= size) {
            out.writeObject(datas[i], true);
            ++i;
        }
        return out.toByteArray();
    }

    @Override
    public void fillRecord(byte[] buf) throws IOException, ClassNotFoundException {
        ByteArrayInputRecord in = new ByteArrayInputRecord(buf);
        int size = this.size = in.readInt();
        in.readInt();
        this.datas = new Object[size + 1];
        Object[] datas = this.datas;
        int i = 1;
        while (i <= size) {
            datas[i] = in.readObject(true);
            ++i;
        }
    }

    @Override
    public IArray newInstance(int count) {
        return new ObjectArray(count);
    }

    @Override
    public void add(Object o) {
        this.ensureCapacity(this.size + 1);
        this.datas[++this.size] = o;
    }

    @Override
    public void addAll(IArray array) {
        int size2 = array.size();
        if (size2 != 0) {
            if (array instanceof ObjectArray) {
                ObjectArray objectArray = (ObjectArray)array;
                this.ensureCapacity(this.size + size2);
                System.arraycopy(objectArray.datas, 1, this.datas, this.size + 1, size2);
                this.size += size2;
            } else {
                this.ensureCapacity(this.size + size2);
                Object[] datas = this.datas;
                int i = 1;
                while (i <= size2) {
                    datas[++this.size] = array.get(i);
                    ++i;
                }
            }
        }
    }

    @Override
    public void addAll(IArray array, int count) {
        if (array instanceof ObjectArray) {
            ObjectArray objectArray = (ObjectArray)array;
            this.ensureCapacity(this.size + count);
            System.arraycopy(objectArray.datas, 1, this.datas, this.size + 1, count);
            this.size += count;
        } else {
            this.ensureCapacity(this.size + count);
            Object[] datas = this.datas;
            int i = 1;
            while (i <= count) {
                datas[++this.size] = array.get(i);
                ++i;
            }
        }
    }

    @Override
    public void addAll(IArray array, int index, int count) {
        if (array instanceof ObjectArray) {
            ObjectArray objectArray = (ObjectArray)array;
            this.ensureCapacity(this.size + count);
            System.arraycopy(objectArray.datas, index, this.datas, this.size + 1, count);
            this.size += count;
        } else {
            this.ensureCapacity(this.size + count);
            Object[] datas = this.datas;
            int i = 1;
            while (i <= count) {
                datas[++this.size] = array.get(index);
                ++i;
                ++index;
            }
        }
    }

    @Override
    public void addAll(Object[] array) {
        int size2 = array.length;
        this.ensureCapacity(this.size + size2);
        System.arraycopy(array, 0, this.datas, this.size + 1, size2);
        this.size += size2;
    }

    @Override
    public void insert(int index, Object o) {
        this.ensureCapacity(this.size + 1);
        ++this.size;
        System.arraycopy(this.datas, index, this.datas, index + 1, this.size - index);
        this.datas[index] = o;
    }

    @Override
    public void insertAll(int pos, IArray array) {
        int numNew = array.size();
        this.ensureCapacity(this.size + numNew);
        Object[] datas = this.datas;
        System.arraycopy(datas, pos, datas, pos + numNew, this.size - pos + 1);
        int i = 1;
        while (i <= numNew) {
            datas[pos] = array.get(i);
            ++i;
            ++pos;
        }
        this.size += numNew;
    }

    @Override
    public void insertAll(int pos, Object[] array) {
        int numNew = array.length;
        this.ensureCapacity(this.size + numNew);
        System.arraycopy(this.datas, pos, this.datas, pos + numNew, this.size - pos + 1);
        System.arraycopy(array, 0, this.datas, pos, numNew);
        this.size += numNew;
    }

    @Override
    public void push(Object o) {
        this.datas[++this.size] = o;
    }

    @Override
    public void pushNull() {
        this.datas[++this.size] = null;
    }

    @Override
    public void push(IArray array, int index) {
        this.datas[++this.size] = array.get(index);
    }

    @Override
    public void add(IArray array, int index) {
        this.ensureCapacity(this.size + 1);
        this.datas[++this.size] = array.get(index);
    }

    @Override
    public void set(int curIndex, IArray array, int index) {
        this.datas[curIndex] = array.get(index);
    }

    @Override
    public Object get(int index) {
        return this.datas[index];
    }

    @Override
    public int getInt(int index) {
        return ((Number)this.datas[index]).intValue();
    }

    @Override
    public long getLong(int index) {
        return ((Number)this.datas[index]).longValue();
    }

    @Override
    public IArray get(int[] indexArray) {
        Object[] datas = this.datas;
        int len = indexArray.length;
        ObjectArray result = new ObjectArray(len);
        int[] nArray = indexArray;
        int n = indexArray.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            result.push(datas[i]);
            ++n2;
        }
        return result;
    }

    @Override
    public IArray get(int[] indexArray, int start, int end, boolean doCheck) {
        Object[] datas = this.datas;
        int len = end - start + 1;
        Object[] resultDatas = new Object[len + 1];
        if (doCheck) {
            int i = 1;
            while (start <= end) {
                int q = indexArray[start];
                if (q > 0) {
                    resultDatas[i] = datas[q];
                }
                ++start;
                ++i;
            }
        } else {
            int i = 1;
            while (start <= end) {
                resultDatas[i++] = datas[indexArray[start]];
                ++start;
            }
        }
        return new ObjectArray(resultDatas, len);
    }

    @Override
    public IArray get(IArray indexArray) {
        Object[] datas = this.datas;
        int len = indexArray.size();
        ObjectArray result = new ObjectArray(len);
        int i = 1;
        while (i <= len) {
            if (indexArray.isNull(i)) {
                result.pushNull();
            } else {
                result.push(datas[indexArray.getInt(i)]);
            }
            ++i;
        }
        return result;
    }

    @Override
    public IArray get(int start, int end) {
        int newSize = end - start;
        Object[] newDatas = new Object[newSize + 1];
        System.arraycopy(this.datas, start, newDatas, 1, newSize);
        return new ObjectArray(newDatas, newSize);
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.datas.length;
        if (oldCapacity <= minCapacity) {
            int newCapacity;
            if (minCapacity < 8) {
                newCapacity = 8;
            } else {
                newCapacity = oldCapacity + (oldCapacity >> 1);
                if (newCapacity < 0) {
                    newCapacity = oldCapacity + 0xFFFFFFF;
                    if (newCapacity < 0) {
                        newCapacity = Integer.MAX_VALUE;
                    }
                } else if (newCapacity <= minCapacity) {
                    newCapacity = minCapacity + 1;
                }
            }
            Object[] newDatas = new Object[newCapacity];
            System.arraycopy(this.datas, 0, newDatas, 0, this.size + 1);
            this.datas = newDatas;
        }
    }

    @Override
    public void trimToSize() {
        int newLen = this.size + 1;
        if (newLen < this.datas.length) {
            Object[] newDatas = new Object[newLen];
            System.arraycopy(this.datas, 0, newDatas, 0, newLen);
            this.datas = newDatas;
        }
    }

    @Override
    public boolean isNull(int index) {
        return this.datas[index] == null;
    }

    @Override
    public BoolArray isTrue() {
        int size = this.size;
        Object[] datas = this.datas;
        boolean[] resultDatas = new boolean[size + 1];
        int i = 1;
        while (i <= size) {
            resultDatas[i] = Variant.isTrue(datas[i]);
            ++i;
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    @Override
    public BoolArray isFalse() {
        int size = this.size;
        Object[] datas = this.datas;
        boolean[] resultDatas = new boolean[size + 1];
        int i = 1;
        while (i <= size) {
            resultDatas[i] = Variant.isFalse(datas[i]);
            ++i;
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    @Override
    public boolean isTrue(int index) {
        return Variant.isTrue(this.datas[index]);
    }

    @Override
    public boolean isFalse(int index) {
        return Variant.isFalse(this.datas[index]);
    }

    @Override
    public boolean isTemporary() {
        return this.datas[0] == Boolean.TRUE;
    }

    @Override
    public void setTemporary(boolean ifTemporary) {
        this.datas[0] = this.isTemporary();
    }

    @Override
    public void remove(int index) {
        System.arraycopy(this.datas, index + 1, this.datas, index, this.size - index);
        this.datas[this.size--] = null;
    }

    @Override
    public void removeLast() {
        this.datas[this.size--] = null;
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        System.arraycopy(this.datas, toIndex + 1, this.datas, fromIndex, this.size - toIndex);
        int newSize = this.size - (toIndex - fromIndex + 1);
        while (this.size != newSize) {
            this.datas[this.size--] = null;
        }
    }

    @Override
    public void remove(int[] seqs) {
        int delCount = 0;
        Object[] datas = this.datas;
        int i = 0;
        int len = seqs.length;
        while (i < len) {
            int moveCount;
            int cur = seqs[i];
            if ((moveCount = ++i < len ? seqs[i] - cur - 1 : this.size - cur) > 0) {
                System.arraycopy(datas, cur + 1, datas, cur - delCount, moveCount);
            }
            ++delCount;
        }
        i = 0;
        int q = this.size;
        while (i < delCount) {
            datas[q - i] = null;
            ++i;
        }
        this.size -= delCount;
    }

    @Override
    public void reserve(int start, int end) {
        int newSize = end - start + 1;
        System.arraycopy(this.datas, start, this.datas, 1, newSize);
        int i = this.size;
        while (i > newSize) {
            this.datas[i] = null;
            --i;
        }
        this.size = newSize;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int count() {
        int size;
        Object[] datas = this.datas;
        int count = size = this.size;
        int i = 1;
        while (i <= size) {
            if (Variant.isFalse(datas[i])) {
                --count;
            }
            ++i;
        }
        return count;
    }

    @Override
    public boolean containTrue() {
        int size = this.size;
        if (size == 0) {
            return false;
        }
        Object[] datas = this.datas;
        int i = 1;
        while (i <= size) {
            if (Variant.isTrue(datas[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public Object ifn() {
        int size = this.size;
        Object[] datas = this.datas;
        int i = 1;
        while (i <= size) {
            if (datas[i] != null) {
                return datas[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public void set(int index, Object obj) {
        this.datas[index] = obj;
    }

    @Override
    public void clear() {
        Object[] datas = this.datas;
        int size = this.size;
        this.size = 0;
        while (size > 0) {
            datas[size--] = null;
        }
    }

    public int binarySearch(Object elem, Comparator<Object> comparator) {
        Object[] datas = this.datas;
        int low = 1;
        int high = this.size;
        while (low <= high) {
            int mid = low + high >> 1;
            int cmp = comparator.compare(datas[mid], elem);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -low;
    }

    @Override
    public int binarySearch(Object elem) {
        if (elem != null) {
            Object[] datas = this.datas;
            int low = 1;
            int high = this.size;
            while (low <= high) {
                int mid = low + high >> 1;
                int cmp = Variant.compare(datas[mid], elem, true);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return -low;
        }
        if (this.size > 0 && this.datas[1] == null) {
            return 1;
        }
        return -1;
    }

    private int descBinarySearch(Object elem) {
        Object[] datas = this.datas;
        int low = 1;
        int high = this.size;
        while (low <= high) {
            int mid = low + high >> 1;
            int cmp = Variant.compare(datas[mid], elem, true);
            if (cmp < 0) {
                high = mid - 1;
                continue;
            }
            if (cmp > 0) {
                low = mid + 1;
                continue;
            }
            return mid;
        }
        return -low;
    }

    @Override
    public int binarySearch(Object elem, int start, int end) {
        if (elem != null) {
            Object[] datas = this.datas;
            int low = start;
            int high = end;
            while (low <= high) {
                int mid = low + high >> 1;
                int cmp = Variant.compare(datas[mid], elem, true);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return -low;
        }
        if (end > 0 && this.datas[start] == null) {
            return start;
        }
        return -1;
    }

    @Override
    public boolean contains(Object elem) {
        if (elem != null) {
            Object[] datas = this.datas;
            int size = this.size;
            int i = 1;
            while (i <= size) {
                if (Variant.isEquals(datas[i], elem)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        int size = this.size;
        Object[] datas = this.datas;
        int i = 1;
        while (i <= size) {
            if (datas[i] == null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void contains(boolean isSorted, IArray array, BoolArray result) {
        int resultSize = result.size();
        if (isSorted) {
            int i = 1;
            while (i <= resultSize) {
                if (result.isTrue(i) && this.binarySearch(array.get(i)) < 1) {
                    result.set(i, false);
                }
                ++i;
            }
        } else {
            int i = 1;
            while (i <= resultSize) {
                if (result.isTrue(i) && !this.contains(array.get(i))) {
                    result.set(i, false);
                }
                ++i;
            }
        }
    }

    @Override
    public boolean objectContains(Object elem) {
        Object[] datas = this.datas;
        int i = 1;
        int size = this.size;
        while (i <= size) {
            if (datas[i] == elem) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public int firstIndexOf(Object elem, int start) {
        if (elem != null) {
            Object[] datas = this.datas;
            int size = this.size;
            int i = start;
            while (i <= size) {
                if (Variant.isEquals(datas[i], elem)) {
                    return i;
                }
                ++i;
            }
            return 0;
        }
        int size = this.size;
        Object[] datas = this.datas;
        int i = start;
        while (i <= size) {
            if (datas[i] == null) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    @Override
    public int lastIndexOf(Object elem, int start) {
        if (elem != null) {
            Object[] datas = this.datas;
            int i = start;
            while (i > 0) {
                if (Variant.isEquals(datas[i], elem)) {
                    return i;
                }
                --i;
            }
            return 0;
        }
        Object[] datas = this.datas;
        int i = start;
        while (i > 0) {
            if (datas[i] == null) {
                return i;
            }
            --i;
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public IntArray indexOfAll(Object elem, int start, boolean isSorted, boolean isFromHead) {
        block28: {
            block29: {
                size = this.size;
                datas = this.datas;
                if (elem == null) {
                    result = new IntArray(7);
                    if (isSorted) {
                        if (isFromHead) {
                            i = start;
                            while (i <= size) {
                                if (datas[i] == null) {
                                    result.addInt(i);
                                    ++i;
                                    continue;
                                }
                                break;
                            }
                        } else {
                            i = start;
                            while (i > 0) {
                                if (datas[i] == null) {
                                    result.addInt(i);
                                }
                                --i;
                            }
                        }
                    } else if (isFromHead) {
                        i = start;
                        while (i <= size) {
                            if (datas[i] == null) {
                                result.addInt(i);
                            }
                            ++i;
                        }
                    } else {
                        i = start;
                        while (i > 0) {
                            if (datas[i] == null) {
                                result.addInt(i);
                            }
                            --i;
                        }
                    }
                    return result;
                }
                if (!isSorted) break block28;
                end = size;
                if (!isFromHead) {
                    end = start;
                    start = 1;
                }
                if ((index = this.binarySearch(elem, start, end)) < 1) {
                    return new IntArray(1);
                }
                first = index;
                while (first > start && Variant.isEquals(datas[first - 1], elem)) {
                    --first;
                }
                last = index;
                while (last < end && Variant.isEquals(datas[last + 1], elem)) {
                    ++last;
                }
                result = new IntArray(last - first + 1);
                if (!isFromHead) ** GOTO lbl62
                while (first <= last) {
                    result.pushInt(first);
                    ++first;
                }
                break block29;
lbl-1000:
                // 1 sources

                {
                    result.pushInt(last);
                    --last;
lbl62:
                    // 2 sources

                    ** while (last >= first)
                }
            }
            return result;
        }
        result = new IntArray(7);
        if (isFromHead) {
            i = start;
            while (i <= size) {
                if (Variant.isEquals(datas[i], elem)) {
                    result.addInt(i);
                }
                ++i;
            }
        } else {
            i = start;
            while (i > 0) {
                if (Variant.isEquals(datas[i], elem)) {
                    result.addInt(i);
                }
                --i;
            }
        }
        return result;
    }

    @Override
    public IArray abs() {
        int size = this.size;
        Object[] datas = this.datas;
        if (this.isTemporary()) {
            int i = 1;
            while (i <= size) {
                datas[i] = Variant.abs(datas[i]);
                ++i;
            }
            return this;
        }
        Object[] newDatas = new Object[size + 1];
        int i = 1;
        while (i <= size) {
            newDatas[i] = Variant.abs(datas[i]);
            ++i;
        }
        ObjectArray result = new ObjectArray(newDatas, size);
        result.setTemporary(true);
        return result;
    }

    @Override
    public IArray negate() {
        int size = this.size;
        Object[] datas = this.datas;
        if (this.isTemporary()) {
            int i = 1;
            while (i <= size) {
                Object obj = datas[i];
                if (obj instanceof Number) {
                    datas[i] = Variant.negate((Number)obj);
                } else if (obj instanceof Date) {
                    datas[i] = Variant.negate((Date)obj);
                } else if (obj instanceof String) {
                    datas[i] = Variant.negate((String)obj);
                } else if (obj != null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("\"-\"" + mm.getMessage("operator.numberRightOperation"));
                }
                ++i;
            }
            return this;
        }
        Object[] newDatas = new Object[size + 1];
        int i = 1;
        while (i <= size) {
            Object obj = datas[i];
            if (obj instanceof Number) {
                newDatas[i] = Variant.negate((Number)obj);
            } else if (obj instanceof Date) {
                newDatas[i] = Variant.negate((Date)obj);
            } else if (obj instanceof String) {
                newDatas[i] = Variant.negate((String)obj);
            } else if (obj != null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("\"-\"" + mm.getMessage("operator.numberRightOperation"));
            }
            ++i;
        }
        ObjectArray result = new ObjectArray(newDatas, size);
        result.setTemporary(true);
        return result;
    }

    @Override
    public IArray not() {
        Object[] datas = this.datas;
        int size = this.size;
        boolean[] newDatas = new boolean[size + 1];
        int i = 1;
        while (i <= size) {
            newDatas[i] = Variant.isFalse(datas[i]);
            ++i;
        }
        BoolArray result = new BoolArray(newDatas, size);
        result.setTemporary(true);
        return result;
    }

    @Override
    public boolean isNumberArray() {
        Object[] datas = this.datas;
        int size = this.size;
        int i = 1;
        while (i <= size) {
            if (datas[i] != null && !(datas[i] instanceof Number)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public IArray memberAdd(IArray array) {
        if (array instanceof IntArray) {
            return this.memberAdd((IntArray)array);
        }
        if (array instanceof LongArray) {
            return this.memberAdd((LongArray)array);
        }
        if (array instanceof DoubleArray) {
            return this.memberAdd((DoubleArray)array);
        }
        if (array instanceof ConstArray) {
            return this.memberAdd(array.get(1));
        }
        if (array instanceof ObjectArray) {
            return this.memberAdd((ObjectArray)array);
        }
        if (array instanceof DateArray) {
            return ((DateArray)array).memberAdd(this);
        }
        if (array instanceof StringArray) {
            return this.memberAdd((StringArray)array);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illAdd"));
    }

    @Override
    public IArray memberAdd(Object value) {
        if (value == null) {
            return this;
        }
        int size = this.size;
        Object[] datas = this.datas;
        if (this.isTemporary()) {
            int i = 1;
            while (i <= size) {
                datas[i] = Variant.add(datas[i], value);
                ++i;
            }
            return this;
        }
        Object[] resultDatas = new Object[size + 1];
        int i = 1;
        while (i <= size) {
            resultDatas[i] = Variant.add(datas[i], value);
            ++i;
        }
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    protected IArray memberAdd(IntArray array) {
        Object[] resultDatas;
        ObjectArray result;
        int size = this.size;
        Object[] datas = this.datas;
        int[] d2 = array.getDatas();
        if (this.isTemporary()) {
            result = this;
            resultDatas = datas;
        } else {
            resultDatas = new Object[size + 1];
            result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
        }
        int i = 1;
        while (i <= size) {
            Object v = datas[i];
            if (v == null) {
                if (!array.isNull(i)) {
                    resultDatas[i] = d2[i];
                }
            } else if (array.isNull(i)) {
                resultDatas[i] = v;
            } else if (v instanceof Double || v instanceof Float) {
                resultDatas[i] = ((Number)v).doubleValue() + (double)d2[i];
            } else if (v instanceof BigDecimal) {
                resultDatas[i] = ((BigDecimal)v).add(new BigDecimal(d2[i]));
            } else if (v instanceof BigInteger) {
                BigDecimal decimal = new BigDecimal((BigInteger)v);
                resultDatas[i] = decimal.add(new BigDecimal(d2[i]));
            } else if (v instanceof Number) {
                resultDatas[i] = ((Number)v).longValue() + (long)d2[i];
            } else if (v instanceof String) {
                Number number = Variant.parseNumber((String)v);
                resultDatas[i] = number == null ? (Number)d2[i] : (Number)(number instanceof Double ? (Number)(number.doubleValue() + (double)d2[i]) : (Number)(number.longValue() + (long)d2[i]));
            } else if (v instanceof Date) {
                resultDatas[i] = Variant.elapse((Date)v, d2[i], null);
            } else {
                MessageManager mm = EngineMessage.get();
                throw new RQException(String.valueOf(Variant.getDataType(v)) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illAdd"));
            }
            ++i;
        }
        return result;
    }

    protected IArray memberAdd(LongArray array) {
        Object[] resultDatas;
        ObjectArray result;
        int size = this.size;
        Object[] datas = this.datas;
        long[] d2 = array.getDatas();
        if (this.isTemporary()) {
            result = this;
            resultDatas = datas;
        } else {
            resultDatas = new Object[size + 1];
            result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
        }
        int i = 1;
        while (i <= size) {
            Object v = datas[i];
            if (v == null) {
                if (!array.isNull(i)) {
                    resultDatas[i] = d2[i];
                }
            } else if (array.isNull(i)) {
                resultDatas[i] = v;
            } else if (v instanceof Double || v instanceof Float) {
                resultDatas[i] = ((Number)v).doubleValue() + (double)d2[i];
            } else if (v instanceof BigDecimal) {
                resultDatas[i] = ((BigDecimal)v).add(new BigDecimal(d2[i]));
            } else if (v instanceof BigInteger) {
                BigDecimal decimal = new BigDecimal((BigInteger)v);
                resultDatas[i] = decimal.add(new BigDecimal(d2[i]));
            } else if (v instanceof Number) {
                resultDatas[i] = ((Number)v).longValue() + d2[i];
            } else if (v instanceof String) {
                Number number = Variant.parseNumber((String)v);
                resultDatas[i] = number == null ? (Number)d2[i] : (Number)(number instanceof Double ? (Number)(number.doubleValue() + (double)d2[i]) : (Number)(number.longValue() + d2[i]));
            } else if (v instanceof Date) {
                resultDatas[i] = Variant.elapse((Date)v, (int)d2[i], null);
            } else {
                MessageManager mm = EngineMessage.get();
                throw new RQException(String.valueOf(Variant.getDataType(v)) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illAdd"));
            }
            ++i;
        }
        return result;
    }

    protected IArray memberAdd(DoubleArray array) {
        Object[] resultDatas;
        ObjectArray result;
        int size = this.size;
        Object[] datas = this.datas;
        double[] d2 = array.getDatas();
        if (this.isTemporary()) {
            result = this;
            resultDatas = datas;
        } else {
            resultDatas = new Object[size + 1];
            result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
        }
        int i = 1;
        while (i <= size) {
            Object v = datas[i];
            if (v == null) {
                if (!array.isNull(i)) {
                    resultDatas[i] = d2[i];
                }
            } else if (array.isNull(i)) {
                resultDatas[i] = v;
            } else if (v instanceof BigDecimal) {
                resultDatas[i] = ((BigDecimal)v).add(new BigDecimal(d2[i]));
            } else if (v instanceof BigInteger) {
                BigDecimal decimal = new BigDecimal((BigInteger)v);
                resultDatas[i] = decimal.add(new BigDecimal(d2[i]));
            } else if (v instanceof Number) {
                resultDatas[i] = ((Number)v).doubleValue() + d2[i];
            } else if (v instanceof String) {
                Number number = Variant.parseNumber((String)v);
                resultDatas[i] = number == null ? Double.valueOf(d2[i]) : Double.valueOf(number.doubleValue() + d2[i]);
            } else if (v instanceof Date) {
                resultDatas[i] = Variant.elapse((Date)v, (int)d2[i], null);
            } else {
                MessageManager mm = EngineMessage.get();
                throw new RQException(String.valueOf(Variant.getDataType(v)) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illAdd"));
            }
            ++i;
        }
        return result;
    }

    protected ObjectArray memberAdd(StringArray array) {
        int size = this.size;
        Object[] d1 = this.datas;
        String[] d2 = array.getDatas();
        if (this.isTemporary()) {
            int i = 1;
            while (i <= size) {
                d1[i] = Variant.add(d1[i], d2[i]);
                ++i;
            }
            return this;
        }
        Object[] resultDatas = new Object[size + 1];
        int i = 1;
        while (i <= size) {
            resultDatas[i] = Variant.add(d1[i], d2[i]);
            ++i;
        }
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    private ObjectArray memberAdd(ObjectArray array) {
        int size = this.size;
        Object[] d1 = this.datas;
        Object[] d2 = array.datas;
        if (this.isTemporary()) {
            int i = 1;
            while (i <= size) {
                d1[i] = Variant.add(d1[i], d2[i]);
                ++i;
            }
            return this;
        }
        if (array.isTemporary()) {
            int i = 1;
            while (i <= size) {
                d2[i] = Variant.add(d1[i], d2[i]);
                ++i;
            }
            return array;
        }
        Object[] resultDatas = new Object[size + 1];
        int i = 1;
        while (i <= size) {
            resultDatas[i] = Variant.add(d1[i], d2[i]);
            ++i;
        }
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    @Override
    public IArray memberSubtract(IArray array) {
        if (array instanceof IntArray) {
            return this.memberSubtract((IntArray)array);
        }
        if (array instanceof LongArray) {
            return this.memberSubtract((LongArray)array);
        }
        if (array instanceof DoubleArray) {
            return this.memberSubtract((DoubleArray)array);
        }
        if (array instanceof ConstArray) {
            return this.memberSubtract(array.get(1));
        }
        if (array instanceof ObjectArray) {
            return this.memberSubtract((ObjectArray)array);
        }
        if (array instanceof DateArray) {
            return this.memberSubtract((DateArray)array);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illSubtract"));
    }

    private IArray memberSubtract(Object value) {
        if (value == null) {
            return this;
        }
        int size = this.size;
        Object[] datas = this.datas;
        if (this.isTemporary()) {
            int i = 1;
            while (i <= size) {
                datas[i] = Variant.subtract(datas[i], value);
                ++i;
            }
            return this;
        }
        Object[] resultDatas = new Object[size + 1];
        int i = 1;
        while (i <= size) {
            resultDatas[i] = Variant.subtract(datas[i], value);
            ++i;
        }
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    private IArray memberSubtract(IntArray array) {
        Object[] resultDatas;
        ObjectArray result;
        int size = this.size;
        Object[] datas = this.datas;
        int[] d2 = array.getDatas();
        if (this.isTemporary()) {
            result = this;
            resultDatas = datas;
        } else {
            resultDatas = new Object[size + 1];
            result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
        }
        int i = 1;
        while (i <= size) {
            Object v = datas[i];
            if (v == null) {
                if (!array.isNull(i)) {
                    resultDatas[i] = -d2[i];
                }
            } else if (array.isNull(i)) {
                resultDatas[i] = v;
            } else if (v instanceof Long) {
                resultDatas[i] = (Long)v - (long)d2[i];
            } else if (v instanceof Double || v instanceof Float) {
                resultDatas[i] = ((Number)v).doubleValue() - (double)d2[i];
            } else if (v instanceof BigDecimal) {
                resultDatas[i] = ((BigDecimal)v).subtract(new BigDecimal(d2[i]));
            } else if (v instanceof BigInteger) {
                BigDecimal decimal = new BigDecimal((BigInteger)v);
                resultDatas[i] = decimal.subtract(new BigDecimal(d2[i]));
            } else if (v instanceof Number) {
                resultDatas[i] = ((Number)v).intValue() - d2[i];
            } else if (v instanceof Date) {
                resultDatas[i] = Variant.elapse((Date)v, -d2[i], null);
            } else {
                MessageManager mm = EngineMessage.get();
                throw new RQException(String.valueOf(Variant.getDataType(v)) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illSubtract"));
            }
            ++i;
        }
        return result;
    }

    private IArray memberSubtract(LongArray array) {
        Object[] resultDatas;
        ObjectArray result;
        int size = this.size;
        Object[] datas = this.datas;
        long[] d2 = array.getDatas();
        if (this.isTemporary()) {
            result = this;
            resultDatas = datas;
        } else {
            resultDatas = new Object[size + 1];
            result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
        }
        int i = 1;
        while (i <= size) {
            Object v = datas[i];
            if (v == null) {
                if (!array.isNull(i)) {
                    resultDatas[i] = -d2[i];
                }
            } else if (array.isNull(i)) {
                resultDatas[i] = v;
            } else if (v instanceof Double || v instanceof Float) {
                resultDatas[i] = ((Number)v).doubleValue() - (double)d2[i];
            } else if (v instanceof BigDecimal) {
                resultDatas[i] = ((BigDecimal)v).subtract(new BigDecimal(d2[i]));
            } else if (v instanceof BigInteger) {
                BigDecimal decimal = new BigDecimal((BigInteger)v);
                resultDatas[i] = decimal.subtract(new BigDecimal(d2[i]));
            } else if (v instanceof Number) {
                resultDatas[i] = ((Number)v).longValue() - d2[i];
            } else if (v instanceof Date) {
                resultDatas[i] = Variant.elapse((Date)v, -((int)d2[i]), null);
            } else {
                MessageManager mm = EngineMessage.get();
                throw new RQException(String.valueOf(Variant.getDataType(v)) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illSubtract"));
            }
            ++i;
        }
        return result;
    }

    private IArray memberSubtract(DoubleArray array) {
        Object[] resultDatas;
        ObjectArray result;
        int size = this.size;
        Object[] datas = this.datas;
        double[] d2 = array.getDatas();
        if (this.isTemporary()) {
            result = this;
            resultDatas = datas;
        } else {
            resultDatas = new Object[size + 1];
            result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
        }
        int i = 1;
        while (i <= size) {
            Object v = datas[i];
            if (v == null) {
                if (!array.isNull(i)) {
                    resultDatas[i] = -d2[i];
                }
            } else if (array.isNull(i)) {
                resultDatas[i] = v;
            } else if (v instanceof BigDecimal) {
                resultDatas[i] = ((BigDecimal)v).subtract(new BigDecimal(d2[i]));
            } else if (v instanceof BigInteger) {
                BigDecimal decimal = new BigDecimal((BigInteger)v);
                resultDatas[i] = decimal.subtract(new BigDecimal(d2[i]));
            } else if (v instanceof Number) {
                resultDatas[i] = ((Number)v).doubleValue() - d2[i];
            } else if (v instanceof Date) {
                resultDatas[i] = Variant.elapse((Date)v, -((int)d2[i]), null);
            } else {
                MessageManager mm = EngineMessage.get();
                throw new RQException(String.valueOf(Variant.getDataType(v)) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illSubtract"));
            }
            ++i;
        }
        return result;
    }

    private ObjectArray memberSubtract(ObjectArray array) {
        Object[] resultDatas;
        ObjectArray result;
        int size = this.size;
        Object[] d1 = this.datas;
        Object[] d2 = array.datas;
        if (this.isTemporary()) {
            result = this;
            resultDatas = d1;
        } else if (array.isTemporary()) {
            result = array;
            resultDatas = d2;
        } else {
            resultDatas = new Object[size + 1];
            result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
        }
        int i = 1;
        while (i <= size) {
            resultDatas[i] = Variant.subtract(d1[i], d2[i]);
            ++i;
        }
        return result;
    }

    private LongArray memberSubtract(DateArray array) {
        int size = this.size;
        Object[] d1 = this.datas;
        Date[] d2 = array.getDatas();
        long[] resultDatas = new long[size + 1];
        boolean[] resultSigns = null;
        int i = 1;
        while (i <= size) {
            if (d1[i] == null || d2[i] == null) {
                if (resultSigns == null) {
                    resultSigns = new boolean[size + 1];
                }
                resultSigns[i] = true;
            }
            if (!(d1[i] instanceof Date)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(String.valueOf(Variant.getDataType(d1[i])) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illSubtract"));
            }
            resultDatas[i] = Variant.dayInterval(d2[i], (Date)d1[i]);
            ++i;
        }
        LongArray result = new LongArray(resultDatas, resultSigns, size);
        result.setTemporary(true);
        return result;
    }

    @Override
    public IArray memberMultiply(IArray array) {
        if (array instanceof IntArray) {
            return this.memberMultiply((IntArray)array);
        }
        if (array instanceof LongArray) {
            return this.memberMultiply((LongArray)array);
        }
        if (array instanceof DoubleArray) {
            return this.memberMultiply((DoubleArray)array);
        }
        if (array instanceof ConstArray) {
            return this.memberMultiply(array.get(1));
        }
        if (array instanceof ObjectArray) {
            return this.memberMultiply((ObjectArray)array);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMultiply"));
    }

    @Override
    public IArray memberMultiply(Object value) {
        if (value == null) {
            return new ConstArray(null, this.size);
        }
        int size = this.size;
        Object[] datas = this.datas;
        if (this.isTemporary()) {
            int i = 1;
            while (i <= size) {
                datas[i] = Variant.multiply(datas[i], value);
                ++i;
            }
            return this;
        }
        Object[] resultDatas = new Object[size + 1];
        int i = 1;
        while (i <= size) {
            resultDatas[i] = Variant.multiply(datas[i], value);
            ++i;
        }
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    protected ObjectArray memberMultiply(IntArray array) {
        Object[] resultDatas;
        ObjectArray result;
        int size = this.size;
        Object[] datas = this.datas;
        int[] d2 = array.getDatas();
        if (this.isTemporary()) {
            result = this;
            resultDatas = datas;
        } else {
            resultDatas = new Object[size + 1];
            result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
        }
        int i = 1;
        while (i <= size) {
            Object v = datas[i];
            if (array.isNull(i)) {
                resultDatas[i] = null;
            } else if (v instanceof Double || v instanceof Float) {
                resultDatas[i] = ((Number)v).doubleValue() * (double)d2[i];
            } else if (v instanceof BigDecimal) {
                resultDatas[i] = ((BigDecimal)v).multiply(new BigDecimal(d2[i]));
            } else if (v instanceof BigInteger) {
                BigDecimal decimal = new BigDecimal((BigInteger)v);
                resultDatas[i] = decimal.multiply(new BigDecimal(d2[i]));
            } else if (v instanceof Number) {
                resultDatas[i] = ((Number)v).longValue() * (long)d2[i];
            } else if (v instanceof Sequence) {
                Sequence sequence = (Sequence)v;
                resultDatas[i] = sequence.multiply(d2[i]);
            } else if (v != null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(String.valueOf(Variant.getDataType(v)) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMultiply"));
            }
            ++i;
        }
        return result;
    }

    protected ObjectArray memberMultiply(LongArray array) {
        Object[] resultDatas;
        ObjectArray result;
        int size = this.size;
        Object[] datas = this.datas;
        long[] d2 = array.getDatas();
        if (this.isTemporary()) {
            result = this;
            resultDatas = datas;
        } else {
            resultDatas = new Object[size + 1];
            result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
        }
        int i = 1;
        while (i <= size) {
            Object v = datas[i];
            if (array.isNull(i)) {
                resultDatas[i] = null;
            } else if (v instanceof Double || v instanceof Float) {
                resultDatas[i] = ((Number)v).doubleValue() * (double)d2[i];
            } else if (v instanceof BigDecimal) {
                resultDatas[i] = ((BigDecimal)v).multiply(new BigDecimal(d2[i]));
            } else if (v instanceof BigInteger) {
                BigDecimal decimal = new BigDecimal((BigInteger)v);
                resultDatas[i] = decimal.multiply(new BigDecimal(d2[i]));
            } else if (v instanceof Number) {
                resultDatas[i] = ((Number)v).longValue() * d2[i];
            } else if (v instanceof Sequence) {
                Sequence sequence = (Sequence)v;
                resultDatas[i] = sequence.multiply((int)d2[i]);
            } else if (v != null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(String.valueOf(Variant.getDataType(v)) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMultiply"));
            }
            ++i;
        }
        return result;
    }

    protected ObjectArray memberMultiply(DoubleArray array) {
        Object[] resultDatas;
        ObjectArray result;
        int size = this.size;
        Object[] datas = this.datas;
        double[] d2 = array.getDatas();
        if (this.isTemporary()) {
            result = this;
            resultDatas = datas;
        } else {
            resultDatas = new Object[size + 1];
            result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
        }
        int i = 1;
        while (i <= size) {
            Object v = datas[i];
            if (array.isNull(i)) {
                resultDatas[i] = null;
            } else if (v instanceof BigDecimal) {
                resultDatas[i] = ((BigDecimal)v).multiply(new BigDecimal(d2[i]));
            } else if (v instanceof BigInteger) {
                BigDecimal decimal = new BigDecimal((BigInteger)v);
                resultDatas[i] = decimal.multiply(new BigDecimal(d2[i]));
            } else if (v instanceof Number) {
                resultDatas[i] = ((Number)v).doubleValue() * d2[i];
            } else if (v instanceof Sequence) {
                Sequence sequence = (Sequence)v;
                resultDatas[i] = sequence.multiply((int)d2[i]);
            } else if (v != null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(String.valueOf(Variant.getDataType(v)) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMultiply"));
            }
            ++i;
        }
        return result;
    }

    private ObjectArray memberMultiply(ObjectArray array) {
        Object[] resultDatas;
        ObjectArray result;
        int size = this.size;
        Object[] d1 = this.datas;
        Object[] d2 = array.datas;
        if (this.isTemporary()) {
            result = this;
            resultDatas = d1;
        } else if (array.isTemporary()) {
            result = array;
            resultDatas = d2;
        } else {
            resultDatas = new Object[size + 1];
            result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
        }
        int i = 1;
        while (i <= size) {
            resultDatas[i] = Variant.multiply(d1[i], d2[i]);
            ++i;
        }
        return result;
    }

    @Override
    public IArray memberDivide(IArray array) {
        if (array instanceof IntArray) {
            return this.memberDivide((IntArray)array);
        }
        if (array instanceof LongArray) {
            return this.memberDivide((LongArray)array);
        }
        if (array instanceof DoubleArray) {
            return this.memberDivide((DoubleArray)array);
        }
        if (array instanceof ConstArray) {
            return this.memberDivide(array.get(1));
        }
        if (array instanceof ObjectArray) {
            return this.memberDivide((ObjectArray)array);
        }
        if (array instanceof StringArray) {
            return this.memberDivide((StringArray)array);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illDivide"));
    }

    private IArray memberDivide(Object value) {
        if (value == null) {
            return new ConstArray(null, this.size);
        }
        int size = this.size;
        Object[] datas = this.datas;
        if (this.isTemporary()) {
            int i = 1;
            while (i <= size) {
                datas[i] = Variant.divide(datas[i], value);
                ++i;
            }
            return this;
        }
        Object[] resultDatas = new Object[size + 1];
        int i = 1;
        while (i <= size) {
            resultDatas[i] = Variant.divide(datas[i], value);
            ++i;
        }
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    private ObjectArray memberDivide(IntArray array) {
        Object[] resultDatas;
        ObjectArray result;
        int size = this.size;
        Object[] datas = this.datas;
        int[] d2 = array.getDatas();
        if (this.isTemporary()) {
            result = this;
            resultDatas = datas;
        } else {
            resultDatas = new Object[size + 1];
            result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
        }
        int i = 1;
        while (i <= size) {
            Object v = datas[i];
            if (array.isNull(i)) {
                resultDatas[i] = v instanceof String ? v : null;
            } else if (d2[i] == 0) {
                resultDatas[i] = v instanceof String ? String.valueOf((String)v) + 0 : null;
            } else if (v instanceof BigDecimal) {
                resultDatas[i] = ((BigDecimal)v).divide(new BigDecimal(d2[i]), 16, 4);
            } else if (v instanceof BigInteger) {
                BigDecimal decimal = new BigDecimal((BigInteger)v);
                resultDatas[i] = decimal.divide(new BigDecimal(d2[i]), 16, 4);
            } else if (v instanceof Number) {
                resultDatas[i] = ((Number)v).doubleValue() / (double)d2[i];
            } else if (v instanceof String) {
                resultDatas[i] = String.valueOf((String)v) + d2[i];
            } else if (v != null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(String.valueOf(Variant.getDataType(v)) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMultiply"));
            }
            ++i;
        }
        return result;
    }

    private ObjectArray memberDivide(LongArray array) {
        Object[] resultDatas;
        ObjectArray result;
        int size = this.size;
        Object[] datas = this.datas;
        long[] d2 = array.getDatas();
        if (this.isTemporary()) {
            result = this;
            resultDatas = datas;
        } else {
            resultDatas = new Object[size + 1];
            result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
        }
        int i = 1;
        while (i <= size) {
            Object v = datas[i];
            if (array.isNull(i)) {
                resultDatas[i] = v instanceof String ? v : null;
            } else if (d2[i] == 0L) {
                resultDatas[i] = v instanceof String ? String.valueOf((String)v) + 0 : null;
            } else if (v instanceof BigDecimal) {
                resultDatas[i] = ((BigDecimal)v).divide(new BigDecimal(d2[i]), 16, 4);
            } else if (v instanceof BigInteger) {
                BigDecimal decimal = new BigDecimal((BigInteger)v);
                resultDatas[i] = decimal.divide(new BigDecimal(d2[i]), 16, 4);
            } else if (v instanceof Number) {
                resultDatas[i] = ((Number)v).doubleValue() / (double)d2[i];
            } else if (v instanceof String) {
                resultDatas[i] = String.valueOf((String)v) + d2[i];
            } else if (v != null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(String.valueOf(Variant.getDataType(v)) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMultiply"));
            }
            ++i;
        }
        return result;
    }

    private ObjectArray memberDivide(DoubleArray array) {
        Object[] resultDatas;
        ObjectArray result;
        int size = this.size;
        Object[] datas = this.datas;
        double[] d2 = array.getDatas();
        if (this.isTemporary()) {
            result = this;
            resultDatas = datas;
        } else {
            resultDatas = new Object[size + 1];
            result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
        }
        int i = 1;
        while (i <= size) {
            Object v = datas[i];
            if (array.isNull(i)) {
                resultDatas[i] = v instanceof String ? v : null;
            } else if (d2[i] == 0.0) {
                resultDatas[i] = v instanceof String ? String.valueOf((String)v) + 0 : null;
            } else if (v instanceof BigDecimal) {
                resultDatas[i] = ((BigDecimal)v).divide(new BigDecimal(d2[i]), 16, 4);
            } else if (v instanceof BigInteger) {
                BigDecimal decimal = new BigDecimal((BigInteger)v);
                resultDatas[i] = decimal.divide(new BigDecimal(d2[i]), 16, 4);
            } else if (v instanceof Number) {
                resultDatas[i] = ((Number)v).doubleValue() / d2[i];
            } else if (v instanceof String) {
                resultDatas[i] = String.valueOf((String)v) + d2[i];
            } else if (v != null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(String.valueOf(Variant.getDataType(v)) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMultiply"));
            }
            ++i;
        }
        return result;
    }

    private StringArray memberDivide(StringArray array) {
        int size = this.size;
        Object[] d1 = this.datas;
        String[] d2 = array.getDatas();
        if (array.isTemporary()) {
            int i = 1;
            while (i <= size) {
                if (d1 != null) {
                    d2[i] = d2[i] != null ? d1[i] + d2[i] : d1[i].toString();
                }
                ++i;
            }
            return array;
        }
        String[] resultDatas = new String[size + 1];
        int i = 1;
        while (i <= size) {
            if (d2[i] != null) {
                resultDatas[i] = d1 != null ? d1[i] + d2[i] : d2[i];
            } else if (d1 != null) {
                resultDatas[i] = d1[i].toString();
            }
            ++i;
        }
        StringArray result = new StringArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    private ObjectArray memberDivide(ObjectArray array) {
        Object[] resultDatas;
        ObjectArray result;
        int size = this.size;
        Object[] d1 = this.datas;
        Object[] d2 = array.datas;
        if (this.isTemporary()) {
            result = this;
            resultDatas = d1;
        } else if (array.isTemporary()) {
            result = array;
            resultDatas = d2;
        } else {
            resultDatas = new Object[size + 1];
            result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
        }
        int i = 1;
        while (i <= size) {
            resultDatas[i] = Variant.divide(d1[i], d2[i]);
            ++i;
        }
        return result;
    }

    @Override
    public IArray memberMod(IArray array) {
        if (array instanceof IntArray) {
            return this.memberMod((IntArray)array);
        }
        if (array instanceof LongArray) {
            return this.memberMod((LongArray)array);
        }
        if (array instanceof DoubleArray) {
            return this.memberMod((DoubleArray)array);
        }
        if (array instanceof ConstArray) {
            return this.memberMod(array.get(1));
        }
        if (array instanceof ObjectArray) {
            return this.memberMod((ObjectArray)array);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMod"));
    }

    /*
     * Enabled aggressive block sorting
     */
    private IArray memberMod(IntArray array) {
        Object[] resultDatas;
        ObjectArray result;
        int size = this.size;
        Object[] d1 = this.datas;
        int[] d2 = array.getDatas();
        if (this.isTemporary()) {
            result = this;
            resultDatas = d1;
        } else {
            resultDatas = new Object[size + 1];
            result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
        }
        int i = 1;
        while (i <= size) {
            BigInteger bi;
            MessageManager mm;
            Object v = d1[i];
            if (array.isNull(i)) {
                if (v instanceof Number || v == null) {
                    resultDatas[i] = null;
                } else {
                    if (!(v instanceof Sequence)) {
                        mm = EngineMessage.get();
                        throw new RQException(String.valueOf(Variant.getDataType(v)) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMod"));
                    }
                    resultDatas[i] = v;
                }
            } else if (v instanceof Long) {
                resultDatas[i] = ((Number)v).longValue() % (long)d2[i];
            } else if (v instanceof Double || v instanceof Float) {
                resultDatas[i] = ((Number)v).doubleValue() % (double)d2[i];
            } else if (v instanceof BigDecimal) {
                bi = ((BigDecimal)v).toBigInteger();
                resultDatas[i] = new BigDecimal(bi.mod(BigInteger.valueOf(d2[i])));
            } else if (v instanceof BigInteger) {
                bi = (BigInteger)v;
                resultDatas[i] = new BigDecimal(bi.mod(BigInteger.valueOf(d2[i])));
            } else if (v instanceof Number) {
                resultDatas[i] = ((Number)v).intValue() % d2[i];
            } else if (v instanceof Sequence) {
                Sequence seq2 = new Sequence(1);
                seq2.add(d2[i]);
                resultDatas[i] = CursorUtil.xor((Sequence)v, seq2);
            } else if (v != null) {
                mm = EngineMessage.get();
                throw new RQException(String.valueOf(Variant.getDataType(v)) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMod"));
            }
            ++i;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private IArray memberMod(LongArray array) {
        Object[] resultDatas;
        ObjectArray result;
        int size = this.size;
        Object[] d1 = this.datas;
        long[] d2 = array.getDatas();
        if (this.isTemporary()) {
            result = this;
            resultDatas = d1;
        } else {
            resultDatas = new Object[size + 1];
            result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
        }
        int i = 1;
        while (i <= size) {
            BigInteger bi;
            MessageManager mm;
            Object v = d1[i];
            if (array.isNull(i)) {
                if (v instanceof Number || v == null) {
                    resultDatas[i] = null;
                } else {
                    if (!(v instanceof Sequence)) {
                        mm = EngineMessage.get();
                        throw new RQException(String.valueOf(Variant.getDataType(v)) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMod"));
                    }
                    resultDatas[i] = v;
                }
            } else if (v instanceof Double || v instanceof Float) {
                resultDatas[i] = ((Number)v).doubleValue() % (double)d2[i];
            } else if (v instanceof BigDecimal) {
                bi = ((BigDecimal)v).toBigInteger();
                resultDatas[i] = new BigDecimal(bi.mod(BigInteger.valueOf(d2[i])));
            } else if (v instanceof BigInteger) {
                bi = (BigInteger)v;
                resultDatas[i] = new BigDecimal(bi.mod(BigInteger.valueOf(d2[i])));
            } else if (v instanceof Number) {
                resultDatas[i] = ((Number)v).longValue() % d2[i];
            } else if (v instanceof Sequence) {
                Sequence seq2 = new Sequence(1);
                seq2.add(d2[i]);
                resultDatas[i] = CursorUtil.xor((Sequence)v, seq2);
            } else if (v != null) {
                mm = EngineMessage.get();
                throw new RQException(String.valueOf(Variant.getDataType(v)) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMod"));
            }
            ++i;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private IArray memberMod(DoubleArray array) {
        Object[] resultDatas;
        ObjectArray result;
        int size = this.size;
        Object[] d1 = this.datas;
        double[] d2 = array.getDatas();
        if (this.isTemporary()) {
            result = this;
            resultDatas = d1;
        } else {
            resultDatas = new Object[size + 1];
            result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
        }
        int i = 1;
        while (i <= size) {
            BigInteger bi;
            MessageManager mm;
            Object v = d1[i];
            if (array.isNull(i)) {
                if (v instanceof Number || v == null) {
                    resultDatas[i] = null;
                } else {
                    if (!(v instanceof Sequence)) {
                        mm = EngineMessage.get();
                        throw new RQException(String.valueOf(Variant.getDataType(v)) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMod"));
                    }
                    resultDatas[i] = v;
                }
            } else if (v instanceof BigDecimal) {
                bi = ((BigDecimal)v).toBigInteger();
                resultDatas[i] = new BigDecimal(bi.mod(BigInteger.valueOf((long)d2[i])));
            } else if (v instanceof BigInteger) {
                bi = (BigInteger)v;
                resultDatas[i] = new BigDecimal(bi.mod(BigInteger.valueOf((long)d2[i])));
            } else if (v instanceof Number) {
                resultDatas[i] = ((Number)v).doubleValue() % d2[i];
            } else if (v instanceof Sequence) {
                Sequence seq2 = new Sequence(1);
                seq2.add(d2[i]);
                resultDatas[i] = CursorUtil.xor((Sequence)v, seq2);
            } else if (v != null) {
                mm = EngineMessage.get();
                throw new RQException(String.valueOf(Variant.getDataType(v)) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMod"));
            }
            ++i;
        }
        return result;
    }

    private IArray memberMod(Object value) {
        int size = this.size;
        Object[] datas = this.datas;
        if (this.isTemporary()) {
            int i = 1;
            while (i <= size) {
                datas[i] = ArrayUtil.mod(datas[i], value);
                ++i;
            }
            return this;
        }
        Object[] resultDatas = new Object[size + 1];
        int i = 1;
        while (i <= size) {
            resultDatas[i] = ArrayUtil.mod(datas[i], value);
            ++i;
        }
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    private IArray memberMod(ObjectArray array) {
        int size = this.size;
        Object[] d1 = this.datas;
        Object[] d2 = array.datas;
        if (this.isTemporary()) {
            int i = 1;
            while (i <= size) {
                d1[i] = ArrayUtil.mod(d1[i], d2[i]);
                ++i;
            }
            return this;
        }
        if (array.isTemporary()) {
            int i = 1;
            while (i <= size) {
                d2[i] = ArrayUtil.mod(d1[i], d2[i]);
                ++i;
            }
            return array;
        }
        Object[] resultDatas = new Object[size + 1];
        int i = 1;
        while (i <= size) {
            resultDatas[i] = ArrayUtil.mod(d1[i], d2[i]);
            ++i;
        }
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    @Override
    public IArray memberIntDivide(IArray array) {
        if (array instanceof IntArray) {
            return this.memberIntDivide((IntArray)array);
        }
        if (array instanceof LongArray) {
            return this.memberIntDivide((LongArray)array);
        }
        if (array instanceof DoubleArray) {
            return this.memberIntDivide((DoubleArray)array);
        }
        if (array instanceof ConstArray) {
            return this.memberIntDivide(array.get(1));
        }
        if (array instanceof ObjectArray) {
            return this.memberIntDivide((ObjectArray)array);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illDivide"));
    }

    private IArray memberIntDivide(IntArray array) {
        Object[] resultDatas;
        ObjectArray result;
        int size = this.size;
        Object[] d1 = this.datas;
        int[] d2 = array.getDatas();
        boolean[] s2 = array.getSigns();
        if (this.isTemporary()) {
            result = this;
            resultDatas = d1;
        } else {
            resultDatas = new Object[size + 1];
            result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
        }
        int i = 1;
        while (i <= size) {
            Object v = d1[i];
            if (v == null || s2 != null && s2[i]) {
                resultDatas[i] = null;
            } else if (v instanceof Long || v instanceof Double || v instanceof Float) {
                resultDatas[i] = ((Number)v).longValue() / (long)d2[i];
            } else if (v instanceof BigDecimal) {
                BigInteger bi1 = ((BigDecimal)v).toBigInteger();
                BigInteger bi2 = BigInteger.valueOf(d2[i]);
                resultDatas[i] = new BigDecimal(bi1.divide(bi2));
            } else if (v instanceof BigInteger) {
                BigInteger bi2 = BigInteger.valueOf(d2[i]);
                resultDatas[i] = new BigDecimal(((BigInteger)v).divide(bi2));
            } else if (v instanceof Number) {
                resultDatas[i] = ObjectCache.getInteger(((Number)v).intValue() / d2[i]);
            } else if (v instanceof Sequence) {
                Sequence seq2 = new Sequence(1);
                seq2.add(d2[i]);
                resultDatas[i] = ((Sequence)v).diff(seq2, false);
            } else {
                MessageManager mm = EngineMessage.get();
                throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + Variant.getDataType(v) + mm.getMessage("Variant2.illDivide"));
            }
            ++i;
        }
        return result;
    }

    private IArray memberIntDivide(LongArray array) {
        Object[] resultDatas;
        ObjectArray result;
        int size = this.size;
        Object[] d1 = this.datas;
        long[] d2 = array.getDatas();
        boolean[] s2 = array.getSigns();
        if (this.isTemporary()) {
            result = this;
            resultDatas = d1;
        } else {
            resultDatas = new Object[size + 1];
            result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
        }
        int i = 1;
        while (i <= size) {
            Object v = d1[i];
            if (v == null || s2 != null && s2[i]) {
                resultDatas[i] = null;
            } else if (v instanceof BigDecimal) {
                BigInteger bi1 = ((BigDecimal)v).toBigInteger();
                BigInteger bi2 = BigInteger.valueOf(d2[i]);
                resultDatas[i] = new BigDecimal(bi1.divide(bi2));
            } else if (v instanceof BigInteger) {
                BigInteger bi2 = BigInteger.valueOf(d2[i]);
                resultDatas[i] = new BigDecimal(((BigInteger)v).divide(bi2));
            } else if (v instanceof Number) {
                resultDatas[i] = ((Number)v).longValue() / d2[i];
            } else if (v instanceof Sequence) {
                Sequence seq2 = new Sequence(1);
                seq2.add(d2[i]);
                resultDatas[i] = ((Sequence)v).diff(seq2, false);
            } else {
                MessageManager mm = EngineMessage.get();
                throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + Variant.getDataType(v) + mm.getMessage("Variant2.illDivide"));
            }
            ++i;
        }
        return result;
    }

    private IArray memberIntDivide(DoubleArray array) {
        Object[] resultDatas;
        ObjectArray result;
        int size = this.size;
        Object[] d1 = this.datas;
        double[] d2 = array.getDatas();
        boolean[] s2 = array.getSigns();
        if (this.isTemporary()) {
            result = this;
            resultDatas = d1;
        } else {
            resultDatas = new Object[size + 1];
            result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
        }
        int i = 1;
        while (i <= size) {
            Object v = d1[i];
            if (v == null || s2 != null && s2[i]) {
                resultDatas[i] = null;
            } else if (v instanceof BigDecimal) {
                BigInteger bi1 = ((BigDecimal)v).toBigInteger();
                BigInteger bi2 = BigInteger.valueOf((long)d2[i]);
                resultDatas[i] = new BigDecimal(bi1.divide(bi2));
            } else if (v instanceof BigInteger) {
                BigInteger bi2 = BigInteger.valueOf((long)d2[i]);
                resultDatas[i] = new BigDecimal(((BigInteger)v).divide(bi2));
            } else if (v instanceof Number) {
                resultDatas[i] = (double)((Number)v).longValue() / d2[i];
            } else if (v instanceof Sequence) {
                Sequence seq2 = new Sequence(1);
                seq2.add(d2[i]);
                resultDatas[i] = ((Sequence)v).diff(seq2, false);
            } else {
                MessageManager mm = EngineMessage.get();
                throw new RQException(String.valueOf(this.getDataType()) + mm.getMessage("Variant2.with") + Variant.getDataType(v) + mm.getMessage("Variant2.illDivide"));
            }
            ++i;
        }
        return result;
    }

    private IArray memberIntDivide(Object value) {
        int size = this.size;
        Object[] datas = this.datas;
        if (this.isTemporary()) {
            int i = 1;
            while (i <= size) {
                datas[i] = ArrayUtil.intDivide(datas[i], value);
                ++i;
            }
            return this;
        }
        Object[] resultDatas = new Object[size + 1];
        int i = 1;
        while (i <= size) {
            resultDatas[i] = ArrayUtil.intDivide(datas[i], value);
            ++i;
        }
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    private IArray memberIntDivide(ObjectArray array) {
        int size = this.size;
        Object[] d1 = this.datas;
        Object[] d2 = array.datas;
        if (this.isTemporary()) {
            int i = 1;
            while (i <= size) {
                d1[i] = ArrayUtil.intDivide(d1[i], d2[i]);
                ++i;
            }
            return this;
        }
        if (array.isTemporary()) {
            int i = 1;
            while (i <= size) {
                d2[i] = ArrayUtil.intDivide(d1[i], d2[i]);
                ++i;
            }
            return array;
        }
        Object[] resultDatas = new Object[size + 1];
        int i = 1;
        while (i <= size) {
            resultDatas[i] = ArrayUtil.intDivide(d1[i], d2[i]);
            ++i;
        }
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    @Override
    public BoolArray calcRelation(IArray array, int relation) {
        if (array instanceof IntArray) {
            return ((IntArray)array).calcRelation(this, Relation.getInverseRelation(relation));
        }
        if (array instanceof LongArray) {
            return ((LongArray)array).calcRelation(this, Relation.getInverseRelation(relation));
        }
        if (array instanceof DoubleArray) {
            return ((DoubleArray)array).calcRelation(this, Relation.getInverseRelation(relation));
        }
        if (array instanceof StringArray) {
            return ((StringArray)array).calcRelation(this, Relation.getInverseRelation(relation));
        }
        if (array instanceof DateArray) {
            return ((DateArray)array).calcRelation(this, Relation.getInverseRelation(relation));
        }
        if (array instanceof BoolArray) {
            return ((BoolArray)array).calcRelation(this, Relation.getInverseRelation(relation));
        }
        if (array instanceof ConstArray) {
            return this.calcRelation(array.get(1), relation);
        }
        if (array instanceof ObjectArray) {
            return this.calcRelation((ObjectArray)array, relation);
        }
        return array.calcRelation(this, Relation.getInverseRelation(relation));
    }

    @Override
    public BoolArray calcRelation(Object value, int relation) {
        boolean b;
        int i;
        if (value == null) {
            return ArrayUtil.calcRelationNull(this.datas, this.size, relation);
        }
        int size = this.size;
        Object[] d1 = this.datas;
        boolean[] resultDatas = new boolean[size + 1];
        if (relation == 1) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = Variant.compare(d1[i], value) == 0;
                ++i;
            }
        } else if (relation == 2) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = Variant.compare(d1[i], value) > 0;
                ++i;
            }
        } else if (relation == 3) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = Variant.compare(d1[i], value) >= 0;
                ++i;
            }
        } else if (relation == 4) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = Variant.compare(d1[i], value) < 0;
                ++i;
            }
        } else if (relation == 5) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = Variant.compare(d1[i], value) <= 0;
                ++i;
            }
        } else if (relation == 6) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = Variant.compare(d1[i], value) != 0;
                ++i;
            }
        } else if (relation == 7) {
            b = Variant.isTrue(value);
            if (b) {
                int i2 = 1;
                while (i2 <= size) {
                    resultDatas[i2] = Variant.isTrue(d1[i2]);
                    ++i2;
                }
            }
        } else {
            b = Variant.isTrue(value);
            if (b) {
                int i3 = 1;
                while (i3 <= size) {
                    resultDatas[i3] = true;
                    ++i3;
                }
            } else {
                int i4 = 1;
                while (i4 <= size) {
                    resultDatas[i4] = Variant.isTrue(d1[i4]);
                    ++i4;
                }
            }
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    private BoolArray calcRelation(ObjectArray array, int relation) {
        int i;
        int size = this.size;
        Object[] d1 = this.datas;
        Object[] d2 = array.datas;
        boolean[] resultDatas = new boolean[size + 1];
        if (relation == 1) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = Variant.compare(d1[i], d2[i]) == 0;
                ++i;
            }
        } else if (relation == 2) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = Variant.compare(d1[i], d2[i]) > 0;
                ++i;
            }
        } else if (relation == 3) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = Variant.compare(d1[i], d2[i]) >= 0;
                ++i;
            }
        } else if (relation == 4) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = Variant.compare(d1[i], d2[i]) < 0;
                ++i;
            }
        } else if (relation == 5) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = Variant.compare(d1[i], d2[i]) <= 0;
                ++i;
            }
        } else if (relation == 6) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = Variant.compare(d1[i], d2[i]) != 0;
                ++i;
            }
        } else if (relation == 7) {
            i = 1;
            while (i <= size) {
                resultDatas[i] = Variant.isTrue(d1[i]) && Variant.isTrue(d2[i]);
                ++i;
            }
        } else {
            i = 1;
            while (i <= size) {
                resultDatas[i] = Variant.isTrue(d1[i]) || Variant.isTrue(d2[i]);
                ++i;
            }
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    @Override
    public int compareTo(IArray array) {
        if (array instanceof ObjectArray) {
            int size1 = this.size;
            int size2 = array.size();
            Object[] d1 = this.datas;
            int size = size1;
            int result = 0;
            if (size1 < size2) {
                result = -1;
            } else if (size1 > size2) {
                result = 1;
                size = size2;
            }
            ObjectArray array2 = (ObjectArray)array;
            Object[] d2 = array2.getDatas();
            int i = 1;
            while (i <= size) {
                int cmp = Variant.compare(d1[i], d2[i], true);
                if (cmp != 0) {
                    return cmp;
                }
                ++i;
            }
            return result;
        }
        if (array instanceof ConstArray) {
            int size1 = this.size;
            int size2 = array.size();
            Object[] d1 = this.datas;
            Object d2 = array.get(1);
            int size = size1;
            int result = 0;
            if (size1 < size2) {
                result = -1;
            } else if (size1 > size2) {
                result = 1;
                size = size2;
            }
            int i = 1;
            while (i <= size) {
                int cmp = Variant.compare(d1[i], d2, true);
                if (cmp != 0) {
                    return cmp;
                }
                ++i;
            }
            return result;
        }
        return -array.compareTo(this);
    }

    @Override
    public int memberCompare(int index1, int index2) {
        return Variant.compare(this.datas[index1], this.datas[index2]);
    }

    @Override
    public boolean isMemberEquals(int index1, int index2) {
        return Variant.isEquals(this.datas[index1], this.datas[index2]);
    }

    @Override
    public boolean isEquals(int curIndex, IArray array, int index) {
        return Variant.isEquals(this.datas[curIndex], array.get(index));
    }

    @Override
    public boolean isEquals(int curIndex, Object value) {
        return Variant.isEquals(this.datas[curIndex], value);
    }

    @Override
    public int compareTo(int curIndex, IArray array, int index) {
        return Variant.compare(this.datas[curIndex], array.get(index), true);
    }

    @Override
    public int compareTo(int curIndex, Object value) {
        return Variant.compare(this.datas[curIndex], value, true);
    }

    @Override
    public IArray memberAdd(int curIndex, IArray array, int index) {
        if (!array.isNull(index)) {
            Object obj = array.get(index);
            this.datas[curIndex] = Variant.add(this.datas[curIndex], obj);
        }
        return this;
    }

    @Override
    public int hashCode(int index) {
        if (this.datas[index] != null) {
            return this.datas[index].hashCode();
        }
        return 0;
    }

    @Override
    public Object sum() {
        int size = this.size;
        if (size < 1) {
            return null;
        }
        Object[] datas = this.datas;
        Object result = datas[1];
        int i = 2;
        while (i <= size) {
            result = Variant.add(result, datas[i]);
            ++i;
        }
        return result;
    }

    @Override
    public Object average() {
        Object[] datas = this.datas;
        int size = this.size;
        Number sum = null;
        int count = 0;
        int i = 1;
        while (i <= size) {
            if (datas[i] instanceof Number) {
                ++count;
                sum = (Number)datas[i];
                break;
            }
            ++i;
        }
        ++i;
        while (i <= size) {
            if (datas[i] instanceof Number) {
                sum = Variant.addNum(sum, (Number)datas[i]);
                ++count;
            }
            ++i;
        }
        return Variant.avg(sum, count);
    }

    @Override
    public Object max() {
        int size = this.size;
        if (size == 0) {
            return null;
        }
        Object[] datas = this.datas;
        Object max = null;
        int i = 1;
        while (i <= size) {
            if (datas[i] != null) {
                max = datas[i];
                break;
            }
            ++i;
        }
        ++i;
        while (i <= size) {
            if (datas[i] != null && Variant.compare(max, datas[i], true) < 0) {
                max = datas[i];
            }
            ++i;
        }
        return max;
    }

    @Override
    public Object min() {
        int size = this.size;
        if (size == 0) {
            return null;
        }
        Object[] datas = this.datas;
        Object min = null;
        int i = 1;
        while (i <= size) {
            if (datas[i] != null) {
                min = datas[i];
                break;
            }
            ++i;
        }
        ++i;
        while (i <= size) {
            if (datas[i] != null && Variant.compare(min, datas[i], true) > 0) {
                min = datas[i];
            }
            ++i;
        }
        return min;
    }

    @Override
    public void calcRelations(IArray array, int relation, BoolArray result, boolean isAnd) {
        if (array instanceof IntArray) {
            ((IntArray)array).calcRelations(this, Relation.getInverseRelation(relation), result, isAnd);
        } else if (array instanceof LongArray) {
            ((LongArray)array).calcRelations(this, Relation.getInverseRelation(relation), result, isAnd);
        } else if (array instanceof DoubleArray) {
            ((DoubleArray)array).calcRelations(this, Relation.getInverseRelation(relation), result, isAnd);
        } else if (array instanceof StringArray) {
            ((StringArray)array).calcRelations(this, Relation.getInverseRelation(relation), result, isAnd);
        } else if (array instanceof DateArray) {
            ((DateArray)array).calcRelations(this, Relation.getInverseRelation(relation), result, isAnd);
        } else if (array instanceof BoolArray) {
            ((BoolArray)array).calcRelations(this, Relation.getInverseRelation(relation), result, isAnd);
        } else if (array instanceof ConstArray) {
            this.calcRelations(array.get(1), relation, result, isAnd);
        } else if (array instanceof ObjectArray) {
            this.calcRelations((ObjectArray)array, relation, result, isAnd);
        } else {
            array.calcRelations(this, Relation.getInverseRelation(relation), result, isAnd);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void calcRelations(Object value, int relation, BoolArray result, boolean isAnd) {
        if (value == null) {
            ArrayUtil.calcRelationsNull(this.datas, this.size, relation, result, isAnd);
        }
        int size = this.size;
        Object[] d1 = this.datas;
        boolean[] resultDatas = result.getDatas();
        if (isAnd) {
            if (relation == 1) {
                int i = 1;
                while (i <= size) {
                    if (resultDatas[i] && Variant.compare(d1[i], value) != 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
                return;
            } else if (relation == 2) {
                int i = 1;
                while (i <= size) {
                    if (resultDatas[i] && Variant.compare(d1[i], value) <= 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
                return;
            } else if (relation == 3) {
                int i = 1;
                while (i <= size) {
                    if (resultDatas[i] && Variant.compare(d1[i], value) < 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
                return;
            } else if (relation == 4) {
                int i = 1;
                while (i <= size) {
                    if (resultDatas[i] && Variant.compare(d1[i], value) >= 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
                return;
            } else if (relation == 5) {
                int i = 1;
                while (i <= size) {
                    if (resultDatas[i] && Variant.compare(d1[i], value) > 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
                return;
            } else {
                if (relation != 6) throw new RuntimeException();
                int i = 1;
                while (i <= size) {
                    if (resultDatas[i] && Variant.compare(d1[i], value) == 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
            }
            return;
        } else if (relation == 1) {
            int i = 1;
            while (i <= size) {
                if (!resultDatas[i] && Variant.compare(d1[i], value) == 0) {
                    resultDatas[i] = true;
                }
                ++i;
            }
            return;
        } else if (relation == 2) {
            int i = 1;
            while (i <= size) {
                if (!resultDatas[i] && Variant.compare(d1[i], value) > 0) {
                    resultDatas[i] = true;
                }
                ++i;
            }
            return;
        } else if (relation == 3) {
            int i = 1;
            while (i <= size) {
                if (!resultDatas[i] && Variant.compare(d1[i], value) >= 0) {
                    resultDatas[i] = true;
                }
                ++i;
            }
            return;
        } else if (relation == 4) {
            int i = 1;
            while (i <= size) {
                if (!resultDatas[i] && Variant.compare(d1[i], value) < 0) {
                    resultDatas[i] = true;
                }
                ++i;
            }
            return;
        } else if (relation == 5) {
            int i = 1;
            while (i <= size) {
                if (!resultDatas[i] && Variant.compare(d1[i], value) <= 0) {
                    resultDatas[i] = true;
                }
                ++i;
            }
            return;
        } else {
            if (relation != 6) throw new RuntimeException();
            int i = 1;
            while (i <= size) {
                if (!resultDatas[i] && Variant.compare(d1[i], value) != 0) {
                    resultDatas[i] = true;
                }
                ++i;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void calcRelations(ObjectArray array, int relation, BoolArray result, boolean isAnd) {
        int size = this.size;
        Object[] d1 = this.datas;
        Object[] d2 = array.getDatas();
        boolean[] resultDatas = result.getDatas();
        if (isAnd) {
            if (relation == 1) {
                int i = 1;
                while (i <= size) {
                    if (resultDatas[i] && Variant.compare(d1[i], d2[i]) != 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
                return;
            } else if (relation == 2) {
                int i = 1;
                while (i <= size) {
                    if (resultDatas[i] && Variant.compare(d1[i], d2[i]) <= 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
                return;
            } else if (relation == 3) {
                int i = 1;
                while (i <= size) {
                    if (resultDatas[i] && Variant.compare(d1[i], d2[i]) < 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
                return;
            } else if (relation == 4) {
                int i = 1;
                while (i <= size) {
                    if (resultDatas[i] && Variant.compare(d1[i], d2[i]) >= 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
                return;
            } else if (relation == 5) {
                int i = 1;
                while (i <= size) {
                    if (resultDatas[i] && Variant.compare(d1[i], d2[i]) > 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
                return;
            } else {
                if (relation != 6) throw new RuntimeException();
                int i = 1;
                while (i <= size) {
                    if (resultDatas[i] && Variant.compare(d1[i], d2[i]) == 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                }
            }
            return;
        } else if (relation == 1) {
            int i = 1;
            while (i <= size) {
                if (!resultDatas[i] && Variant.compare(d1[i], d2[i]) == 0) {
                    resultDatas[i] = true;
                }
                ++i;
            }
            return;
        } else if (relation == 2) {
            int i = 1;
            while (i <= size) {
                if (!resultDatas[i] && Variant.compare(d1[i], d2[i]) > 0) {
                    resultDatas[i] = true;
                }
                ++i;
            }
            return;
        } else if (relation == 3) {
            int i = 1;
            while (i <= size) {
                if (!resultDatas[i] && Variant.compare(d1[i], d2[i]) >= 0) {
                    resultDatas[i] = true;
                }
                ++i;
            }
            return;
        } else if (relation == 4) {
            int i = 1;
            while (i <= size) {
                if (!resultDatas[i] && Variant.compare(d1[i], d2[i]) < 0) {
                    resultDatas[i] = true;
                }
                ++i;
            }
            return;
        } else if (relation == 5) {
            int i = 1;
            while (i <= size) {
                if (!resultDatas[i] && Variant.compare(d1[i], d2[i]) <= 0) {
                    resultDatas[i] = true;
                }
                ++i;
            }
            return;
        } else {
            if (relation != 6) throw new RuntimeException();
            int i = 1;
            while (i <= size) {
                if (!resultDatas[i] && Variant.compare(d1[i], d2[i]) != 0) {
                    resultDatas[i] = true;
                }
                ++i;
            }
        }
    }

    @Override
    public IArray bitwiseAnd(IArray array) {
        int size = this.size;
        Object[] datas = this.datas;
        if (array instanceof ConstArray) {
            Object value = array.get(1);
            if (value == null) {
                return new ConstArray(null, size);
            }
            if (!(value instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("and" + mm.getMessage("function.paramTypeError"));
            }
            ObjectArray result = new ObjectArray(size);
            result.setTemporary(true);
            int i = 1;
            while (i <= size) {
                result.push(And.and(datas[i], value));
                ++i;
            }
            return result;
        }
        Object[] d2 = ((ObjectArray)array).datas;
        ObjectArray result = new ObjectArray(size);
        result.setTemporary(true);
        int i = 1;
        while (i <= size) {
            result.push(And.and(datas[i], d2[i]));
            ++i;
        }
        return result;
    }

    @Override
    public IArray bitwiseOr(IArray array) {
        int size = this.size;
        Object[] datas = this.datas;
        if (array instanceof ConstArray) {
            Object value = array.get(1);
            if (value == null) {
                return new ConstArray(null, size);
            }
            ObjectArray result = new ObjectArray(size);
            result.setTemporary(true);
            int i = 1;
            while (i <= size) {
                result.push(Or.or(datas[i], value));
                ++i;
            }
            return result;
        }
        ObjectArray result = new ObjectArray(size);
        result.setTemporary(true);
        int i = 1;
        while (i <= size) {
            result.push(Or.or(datas[i], array.get(i)));
            ++i;
        }
        return result;
    }

    @Override
    public IArray bitwiseXOr(IArray array) {
        int size = this.size;
        Object[] datas = this.datas;
        if (array instanceof ConstArray) {
            Object value = array.get(1);
            if (value == null) {
                return new ConstArray(null, size);
            }
            ObjectArray result = new ObjectArray(size);
            result.setTemporary(true);
            int i = 1;
            while (i <= size) {
                result.push(Xor.xor(datas[i], value));
                ++i;
            }
            return result;
        }
        ObjectArray result = new ObjectArray(size);
        result.setTemporary(true);
        int i = 1;
        while (i <= size) {
            result.push(Xor.xor(datas[i], array.get(i)));
            ++i;
        }
        return result;
    }

    @Override
    public IArray bitwiseNot() {
        int size = this.size;
        Object[] datas = this.datas;
        if (this.isTemporary()) {
            int i = 1;
            while (i <= size) {
                datas[i] = Not.not(datas[i]);
                ++i;
            }
            return this;
        }
        Object[] resultDatas = new Object[size + 1];
        int i = 1;
        while (i <= size) {
            resultDatas[i] = Not.not(datas[i]);
            ++i;
        }
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    @Override
    public IArray select(IArray signArray) {
        int size = signArray.size();
        Object[] d1 = this.datas;
        Object[] resultDatas = new Object[size + 1];
        int count = 0;
        if (signArray instanceof BoolArray) {
            BoolArray array = (BoolArray)signArray;
            boolean[] d2 = array.getDatas();
            boolean[] s2 = array.getSigns();
            if (s2 == null) {
                int i = 1;
                while (i <= size) {
                    if (d2[i]) {
                        resultDatas[++count] = d1[i];
                    }
                    ++i;
                }
            } else {
                int i = 1;
                while (i <= size) {
                    if (!s2[i] && d2[i]) {
                        resultDatas[++count] = d1[i];
                    }
                    ++i;
                }
            }
        } else {
            int i = 1;
            while (i <= size) {
                if (signArray.isTrue(i)) {
                    resultDatas[++count] = d1[i];
                }
                ++i;
            }
        }
        return new ObjectArray(resultDatas, count);
    }

    @Override
    public IArray select(int start, int end, IArray signArray) {
        Object[] d1 = this.datas;
        Object[] resultDatas = new Object[end - start + 1];
        int count = 0;
        if (signArray instanceof BoolArray) {
            BoolArray array = (BoolArray)signArray;
            boolean[] d2 = array.getDatas();
            boolean[] s2 = array.getSigns();
            if (s2 == null) {
                int i = start;
                while (i < end) {
                    if (d2[i]) {
                        resultDatas[++count] = d1[i];
                    }
                    ++i;
                }
            } else {
                int i = start;
                while (i < end) {
                    if (!s2[i] && d2[i]) {
                        resultDatas[++count] = d1[i];
                    }
                    ++i;
                }
            }
        } else {
            int i = start;
            while (i < end) {
                if (signArray.isTrue(i)) {
                    resultDatas[++count] = d1[i];
                }
                ++i;
            }
        }
        return new ObjectArray(resultDatas, count);
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size];
        System.arraycopy(this.datas, 1, result, 0, this.size);
        return result;
    }

    @Override
    public void toArray(Object[] result) {
        System.arraycopy(this.datas, 1, result, 0, this.size);
    }

    @Override
    public IArray split(int pos) {
        Object[] datas = this.datas;
        int size = this.size;
        int resultSize = size - pos + 1;
        Object[] resultDatas = new Object[resultSize + 1];
        System.arraycopy(datas, pos, resultDatas, 1, resultSize);
        int i = pos;
        while (i <= size) {
            datas[i] = null;
            ++i;
        }
        this.size = pos - 1;
        return new ObjectArray(resultDatas, resultSize);
    }

    @Override
    public IArray split(int from, int to) {
        Object[] datas = this.datas;
        int oldSize = this.size;
        int resultSize = to - from + 1;
        Object[] resultDatas = new Object[resultSize + 1];
        System.arraycopy(datas, from, resultDatas, 1, resultSize);
        System.arraycopy(datas, to + 1, datas, from, oldSize - to);
        this.size -= resultSize;
        int i = this.size + 1;
        while (i <= oldSize) {
            datas[i] = null;
            ++i;
        }
        return new ObjectArray(resultDatas, resultSize);
    }

    @Override
    public void sort() {
        MultithreadUtil.sort(this.datas, 1, this.size + 1);
    }

    @Override
    public void sort(Comparator<Object> comparator) {
        MultithreadUtil.sort(this.datas, 1, this.size + 1, comparator);
    }

    @Override
    public boolean hasRecord() {
        Object[] datas = this.datas;
        int i = 1;
        int size = this.size;
        while (i <= size) {
            if (datas[i] instanceof BaseRecord) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean isPmt(boolean isPure) {
        Object[] datas = this.datas;
        int size = this.size;
        if (size == 0) {
            return false;
        }
        if (isPure) {
            if (!(datas[1] instanceof BaseRecord)) {
                return false;
            }
            DataStruct ds = ((BaseRecord)datas[1]).dataStruct();
            int i = 2;
            while (i <= size) {
                if (!(datas[i] instanceof BaseRecord) || !((BaseRecord)datas[i]).dataStruct().isCompatible(ds)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        boolean hasRecord = false;
        int i = 1;
        while (i <= size) {
            if (datas[i] instanceof BaseRecord) {
                hasRecord = true;
            } else if (datas[i] != null) {
                return false;
            }
            ++i;
        }
        return hasRecord;
    }

    @Override
    public IArray rvs() {
        int size = this.size;
        Object[] datas = this.datas;
        Object[] resultDatas = new Object[size + 1];
        int i = 1;
        int q = size;
        while (i <= size) {
            resultDatas[i] = datas[q--];
            ++i;
        }
        return new ObjectArray(resultDatas, size);
    }

    @Override
    public IntArray ptop(int count, boolean isAll, boolean isLast, boolean ignoreNull) {
        int size = this.size;
        if (size == 0) {
            return new IntArray(0);
        }
        Object[] datas = this.datas;
        if (ignoreNull) {
            if (count == 1) {
                Object minValue = null;
                if (isAll) {
                    IntArray result = new IntArray(8);
                    int i = 1;
                    while (i <= size) {
                        if (datas[i] != null) {
                            minValue = datas[i];
                            result.addInt(i);
                            break;
                        }
                        ++i;
                    }
                    ++i;
                    while (i <= size) {
                        if (datas[i] != null) {
                            int cmp = Variant.compare(datas[i], minValue, true);
                            if (cmp < 0) {
                                minValue = datas[i];
                                result.clear();
                                result.addInt(i);
                            } else if (cmp == 0) {
                                result.addInt(i);
                            }
                        }
                        ++i;
                    }
                    return result;
                }
                if (isLast) {
                    int i = size;
                    int pos = 0;
                    while (i > 0) {
                        if (datas[i] != null) {
                            minValue = datas[i];
                            pos = i;
                            break;
                        }
                        --i;
                    }
                    --i;
                    while (i > 0) {
                        if (datas[i] != null && Variant.compare(datas[i], minValue, true) < 0) {
                            minValue = datas[i];
                            pos = i;
                        }
                        --i;
                    }
                    IntArray result = new IntArray(1);
                    if (pos != 0) {
                        result.pushInt(pos);
                    }
                    return result;
                }
                int i = 1;
                int pos = 0;
                while (i <= size) {
                    if (datas[i] != null) {
                        minValue = datas[i];
                        pos = i;
                        break;
                    }
                    ++i;
                }
                ++i;
                while (i <= size) {
                    if (datas[i] != null && Variant.compare(datas[i], minValue, true) < 0) {
                        minValue = datas[i];
                        pos = i;
                    }
                    ++i;
                }
                IntArray result = new IntArray(1);
                if (pos != 0) {
                    result.pushInt(pos);
                }
                return result;
            }
            if (count > 1) {
                int next = count + 1;
                ObjectArray valueArray = new ObjectArray(next);
                IntArray posArray = new IntArray(next);
                int i = 1;
                while (i <= size) {
                    if (datas[i] != null) {
                        int index = valueArray.binarySearch(datas[i]);
                        if (index < 1) {
                            index = -index;
                        }
                        if (index <= count) {
                            valueArray.insert(index, datas[i]);
                            posArray.insertInt(index, i);
                            if (valueArray.size() == next) {
                                valueArray.removeLast();
                                posArray.removeLast();
                            }
                        }
                    }
                    ++i;
                }
                return posArray;
            }
            if (count == -1) {
                Object maxValue = null;
                if (isAll) {
                    IntArray result = new IntArray(8);
                    int i = 1;
                    while (i <= size) {
                        if (datas[i] != null) {
                            maxValue = datas[i];
                            result.addInt(i);
                            break;
                        }
                        ++i;
                    }
                    ++i;
                    while (i <= size) {
                        if (datas[i] != null) {
                            int cmp = Variant.compare(datas[i], maxValue, true);
                            if (cmp > 0) {
                                maxValue = datas[i];
                                result.clear();
                                result.addInt(i);
                            } else if (cmp == 0) {
                                result.addInt(i);
                            }
                        }
                        ++i;
                    }
                    return result;
                }
                if (isLast) {
                    int i = size;
                    int pos = 0;
                    while (i > 0) {
                        if (datas[i] != null) {
                            maxValue = datas[i];
                            pos = i;
                            break;
                        }
                        --i;
                    }
                    --i;
                    while (i > 0) {
                        if (datas[i] != null && Variant.compare(datas[i], maxValue, true) > 0) {
                            maxValue = datas[i];
                            pos = i;
                        }
                        --i;
                    }
                    IntArray result = new IntArray(1);
                    if (pos != 0) {
                        result.pushInt(pos);
                    }
                    return result;
                }
                int i = 1;
                int pos = 0;
                while (i <= size) {
                    if (datas[i] != null) {
                        maxValue = datas[i];
                        pos = i;
                        break;
                    }
                    ++i;
                }
                ++i;
                while (i <= size) {
                    if (datas[i] != null && Variant.compare(datas[i], maxValue, true) > 0) {
                        maxValue = datas[i];
                        pos = i;
                    }
                    ++i;
                }
                IntArray result = new IntArray(1);
                if (pos != 0) {
                    result.pushInt(pos);
                }
                return result;
            }
            if (count < -1) {
                count = -count;
                int next = count + 1;
                ObjectArray valueArray = new ObjectArray(next);
                IntArray posArray = new IntArray(next);
                int i = 1;
                while (i <= size) {
                    if (datas[i] != null) {
                        int index = valueArray.descBinarySearch(datas[i]);
                        if (index < 1) {
                            index = -index;
                        }
                        if (index <= count) {
                            valueArray.insert(index, datas[i]);
                            posArray.insertInt(index, i);
                            if (valueArray.size() == next) {
                                valueArray.remove(next);
                                posArray.remove(next);
                            }
                        }
                    }
                    ++i;
                }
                return posArray;
            }
            return new IntArray(1);
        }
        if (count == 1) {
            if (isAll) {
                IntArray result = new IntArray(8);
                result.addInt(1);
                Object minValue = datas[1];
                int i = 2;
                while (i <= size) {
                    int cmp = Variant.compare(datas[i], minValue, true);
                    if (cmp < 0) {
                        minValue = datas[i];
                        result.clear();
                        result.addInt(i);
                    } else if (cmp == 0) {
                        result.addInt(i);
                    }
                    ++i;
                }
                return result;
            }
            if (isLast) {
                Object minValue = datas[size];
                int pos = size;
                int i = size - 1;
                while (i > 0) {
                    if (Variant.compare(datas[i], minValue, true) < 0) {
                        minValue = datas[i];
                        pos = i;
                    }
                    --i;
                }
                IntArray result = new IntArray(1);
                result.pushInt(pos);
                return result;
            }
            Object minValue = datas[1];
            int pos = 1;
            int i = 2;
            while (i <= size) {
                if (Variant.compare(datas[i], minValue, true) < 0) {
                    minValue = datas[i];
                    pos = i;
                }
                ++i;
            }
            IntArray result = new IntArray(1);
            result.pushInt(pos);
            return result;
        }
        if (count > 1) {
            int next = count + 1;
            ObjectArray valueArray = new ObjectArray(next);
            IntArray posArray = new IntArray(next);
            int i = 1;
            while (i <= size) {
                int index = valueArray.binarySearch(datas[i]);
                if (index < 1) {
                    index = -index;
                }
                if (index <= count) {
                    valueArray.insert(index, datas[i]);
                    posArray.insertInt(index, i);
                    if (valueArray.size() == next) {
                        valueArray.removeLast();
                        posArray.removeLast();
                    }
                }
                ++i;
            }
            return posArray;
        }
        if (count == -1) {
            if (isAll) {
                IntArray result = new IntArray(8);
                Object maxValue = datas[1];
                result.addInt(1);
                int i = 2;
                while (i <= size) {
                    int cmp = Variant.compare(datas[i], maxValue, true);
                    if (cmp > 0) {
                        maxValue = datas[i];
                        result.clear();
                        result.addInt(i);
                    } else if (cmp == 0) {
                        result.addInt(i);
                    }
                    ++i;
                }
                return result;
            }
            if (isLast) {
                Object maxValue = datas[size];
                int pos = size;
                int i = size - 1;
                while (i > 0) {
                    if (Variant.compare(datas[i], maxValue, true) > 0) {
                        maxValue = datas[i];
                        pos = i;
                    }
                    --i;
                }
                IntArray result = new IntArray(1);
                result.pushInt(pos);
                return result;
            }
            Object maxValue = datas[1];
            int pos = 1;
            int i = 2;
            while (i <= size) {
                if (Variant.compare(datas[i], maxValue, true) > 0) {
                    maxValue = datas[i];
                    pos = i;
                }
                ++i;
            }
            IntArray result = new IntArray(1);
            result.pushInt(pos);
            return result;
        }
        if (count < -1) {
            count = -count;
            int next = count + 1;
            ObjectArray valueArray = new ObjectArray(next);
            IntArray posArray = new IntArray(next);
            int i = 1;
            while (i <= size) {
                int index = valueArray.descBinarySearch(datas[i]);
                if (index < 1) {
                    index = -index;
                }
                if (index <= count) {
                    valueArray.insert(index, datas[i]);
                    posArray.insertInt(index, i);
                    if (valueArray.size() == next) {
                        valueArray.remove(next);
                        posArray.remove(next);
                    }
                }
                ++i;
            }
            return posArray;
        }
        return new IntArray(1);
    }

    @Override
    public IntArray ptopRank(int count, boolean ignoreNull, boolean iopt) {
        int size = this.size;
        if (size == 0 || count == 0) {
            return new IntArray(0);
        }
        Object[] datas = this.datas;
        if (count > 0) {
            int next = count + 1;
            ObjectArray valueArray = new ObjectArray(next);
            IntArray posArray = new IntArray(next);
            if (iopt) {
                int curCount = 0;
                int i = 1;
                while (i <= size) {
                    int curSize;
                    if (datas[i] != null) {
                        if (curCount < count) {
                            int index = valueArray.binarySearch(datas[i]);
                            if (index < 1) {
                                ++curCount;
                                index = -index;
                            }
                            valueArray.insert(index, datas[i]);
                            posArray.insertInt(index, i);
                        } else {
                            curSize = valueArray.size();
                            int cmp = this.compareTo(i, valueArray, curSize);
                            if (cmp < 0) {
                                int index = valueArray.binarySearch(datas[i]);
                                if (index < 1) {
                                    index = -index;
                                    Object value = valueArray.get(curSize);
                                    valueArray.removeLast();
                                    posArray.removeLast();
                                    int j = curSize - 1;
                                    while (j >= count) {
                                        if (!Variant.isEquals(valueArray.get(j), value)) break;
                                        valueArray.removeLast();
                                        posArray.removeLast();
                                        --j;
                                    }
                                }
                                valueArray.insert(index, datas[i]);
                                posArray.insertInt(index, i);
                            } else if (cmp == 0) {
                                valueArray.add(datas[i]);
                                posArray.addInt(i);
                            }
                        }
                    } else if (!ignoreNull) {
                        if (curCount < count) {
                            if (curCount == 0 || !valueArray.isNull(1)) {
                                ++curCount;
                            }
                            valueArray.insert(1, null);
                            posArray.insertInt(1, i);
                        } else if (valueArray.isNull(1)) {
                            valueArray.add(datas[i]);
                            posArray.addInt(i);
                        } else {
                            curSize = valueArray.size();
                            Object value = valueArray.get(curSize);
                            valueArray.removeLast();
                            posArray.removeLast();
                            int j = curSize - 1;
                            while (j >= count) {
                                if (!Variant.isEquals(valueArray.get(j), value)) break;
                                valueArray.removeLast();
                                posArray.removeLast();
                                --j;
                            }
                            valueArray.insert(1, null);
                            posArray.insertInt(1, i);
                        }
                    }
                    ++i;
                }
            } else {
                int i = 1;
                while (i <= size) {
                    int curSize;
                    if (datas[i] != null) {
                        curSize = valueArray.size();
                        if (curSize < count) {
                            int index = valueArray.binarySearch(datas[i]);
                            if (index < 1) {
                                index = -index;
                            }
                            valueArray.insert(index, datas[i]);
                            posArray.insertInt(index, i);
                        } else {
                            int cmp = this.compareTo(i, valueArray, curSize);
                            if (cmp < 0) {
                                int index = valueArray.binarySearch(datas[i]);
                                if (index < 1) {
                                    index = -index;
                                }
                                valueArray.insert(index, datas[i]);
                                posArray.insertInt(index, i);
                                if (valueArray.memberCompare(count, curSize + 1) != 0) {
                                    Object value = valueArray.get(curSize + 1);
                                    valueArray.removeLast();
                                    posArray.removeLast();
                                    int j = curSize;
                                    while (j > count) {
                                        if (Variant.isEquals(valueArray.get(j), value)) {
                                            valueArray.removeLast();
                                            posArray.removeLast();
                                            --j;
                                            continue;
                                        }
                                        break;
                                    }
                                }
                            } else if (cmp == 0) {
                                valueArray.add(datas[i]);
                                posArray.addInt(i);
                            }
                        }
                    } else if (!ignoreNull) {
                        curSize = valueArray.size();
                        if (curSize < count) {
                            valueArray.insert(1, null);
                            posArray.insertInt(1, i);
                        } else if (valueArray.isNull(curSize)) {
                            valueArray.add(datas[i]);
                            posArray.addInt(i);
                        } else {
                            valueArray.insert(1, null);
                            posArray.insertInt(1, i);
                            if (valueArray.memberCompare(count, curSize + 1) != 0) {
                                Object value = valueArray.get(curSize + 1);
                                valueArray.removeLast();
                                posArray.removeLast();
                                int j = curSize;
                                while (j > count) {
                                    if (Variant.isEquals(valueArray.get(j), value)) {
                                        valueArray.removeLast();
                                        posArray.removeLast();
                                        --j;
                                        continue;
                                    }
                                    break;
                                }
                            }
                        }
                    }
                    ++i;
                }
            }
            return posArray;
        }
        count = -count;
        int next = count + 1;
        ObjectArray valueArray = new ObjectArray(next);
        IntArray posArray = new IntArray(next);
        if (iopt) {
            int curCount = 0;
            int i = 1;
            while (i <= size) {
                if (datas[i] != null) {
                    if (curCount < count) {
                        int index = valueArray.descBinarySearch(datas[i]);
                        if (index < 1) {
                            ++curCount;
                            index = -index;
                        }
                        valueArray.insert(index, datas[i]);
                        posArray.insertInt(index, i);
                    } else {
                        int curSize = valueArray.size();
                        int cmp = this.compareTo(i, valueArray, curSize);
                        if (cmp > 0) {
                            int index = valueArray.descBinarySearch(datas[i]);
                            if (index < 1) {
                                index = -index;
                                Object value = valueArray.get(curSize);
                                valueArray.removeLast();
                                posArray.removeLast();
                                int j = curSize - 1;
                                while (j >= count) {
                                    if (!Variant.isEquals(valueArray.get(j), value)) break;
                                    valueArray.removeLast();
                                    posArray.removeLast();
                                    --j;
                                }
                            }
                            valueArray.insert(index, datas[i]);
                            posArray.insertInt(index, i);
                        } else if (cmp == 0) {
                            valueArray.add(datas[i]);
                            posArray.addInt(i);
                        }
                    }
                }
                ++i;
            }
        } else {
            int i = 1;
            while (i <= size) {
                if (datas[i] != null) {
                    int curSize = valueArray.size();
                    if (curSize < count) {
                        int index = valueArray.descBinarySearch(datas[i]);
                        if (index < 1) {
                            index = -index;
                        }
                        valueArray.insert(index, datas[i]);
                        posArray.insertInt(index, i);
                    } else {
                        int cmp = this.compareTo(i, valueArray, curSize);
                        if (cmp > 0) {
                            int index = valueArray.descBinarySearch(datas[i]);
                            if (index < 1) {
                                index = -index;
                            }
                            valueArray.insert(index, datas[i]);
                            posArray.insertInt(index, i);
                            if (valueArray.memberCompare(count, curSize + 1) != 0) {
                                Object value = valueArray.get(curSize + 1);
                                valueArray.removeLast();
                                posArray.removeLast();
                                int j = curSize;
                                while (j > count) {
                                    if (Variant.isEquals(valueArray.get(j), value)) {
                                        valueArray.removeLast();
                                        posArray.removeLast();
                                        --j;
                                        continue;
                                    }
                                    break;
                                }
                            }
                        } else if (cmp == 0) {
                            valueArray.add(datas[i]);
                            posArray.addInt(i);
                        }
                    }
                }
                ++i;
            }
        }
        return posArray;
    }

    @Override
    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public ObjectArray toObjectArray() {
        return this;
    }

    @Override
    public IArray toPureArray() {
        int size = this.size;
        Object[] datas = this.datas;
        IArray resultArray = null;
        int numType = 0;
        int i = 1;
        while (i <= size) {
            Object obj = datas[i];
            if (obj instanceof String) {
                resultArray = new StringArray(size);
                break;
            }
            if (obj instanceof Date) {
                resultArray = new DateArray(size);
                break;
            }
            if (obj instanceof Double) {
                resultArray = new DoubleArray(size);
                break;
            }
            if (obj instanceof Long) {
                numType = 2;
            } else if (obj instanceof Integer) {
                if (numType < 1) {
                    numType = 1;
                }
            } else {
                if (obj instanceof Boolean) {
                    resultArray = new BoolArray(size);
                    break;
                }
                if (obj != null) {
                    return this;
                }
            }
            ++i;
        }
        if (resultArray == null) {
            if (numType == 1) {
                resultArray = new IntArray(size);
            } else if (numType == 2) {
                resultArray = new LongArray(size);
            } else {
                return this;
            }
        }
        i = 1;
        while (i <= size) {
            resultArray.push(datas[i]);
            ++i;
        }
        return resultArray;
    }

    @Override
    public IArray reserve(boolean refOrigin) {
        if (this.isTemporary()) {
            this.setTemporary(false);
            return this;
        }
        if (refOrigin) {
            return this;
        }
        return this.dup();
    }

    @Override
    public IArray combine(IArray signArray, IArray other) {
        if (other instanceof ConstArray) {
            return this.combine(signArray, ((ConstArray)other).getData());
        }
        int size = this.size;
        Object[] datas = this.datas;
        if (this.isTemporary()) {
            int i = 1;
            while (i <= size) {
                if (signArray.isFalse(i)) {
                    datas[i] = other.get(i);
                }
                ++i;
            }
            return this;
        }
        Object[] resultDatas = new Object[size + 1];
        System.arraycopy(datas, 1, resultDatas, 1, size);
        int i = 1;
        while (i <= size) {
            if (signArray.isFalse(i)) {
                resultDatas[i] = other.get(i);
            }
            ++i;
        }
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    @Override
    public IArray combine(IArray signArray, Object value) {
        int size = this.size;
        Object[] datas = this.datas;
        if (this.isTemporary()) {
            int i = 1;
            while (i <= size) {
                if (signArray.isFalse(i)) {
                    datas[i] = value;
                }
                ++i;
            }
            return this;
        }
        Object[] resultDatas = new Object[size + 1];
        System.arraycopy(datas, 1, resultDatas, 1, size);
        int i = 1;
        while (i <= size) {
            if (signArray.isFalse(i)) {
                resultDatas[i] = value;
            }
            ++i;
        }
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    @Override
    public Object pos(IArray array, String opt) {
        return ArrayUtil.pos(this, array, opt);
    }

    @Override
    public int bit1() {
        Object[] datas = this.datas;
        int size = this.size;
        int sum = 0;
        int i = 1;
        while (i <= size) {
            sum += Bit1.bitCount(datas[i]);
            ++i;
        }
        return sum;
    }

    @Override
    public int bit1(IArray array) {
        Object[] datas = this.datas;
        int size = this.size;
        int count = 0;
        int i = 1;
        while (i <= size) {
            count += Bit1.bitCount(datas[i], array.get(i));
            ++i;
        }
        return count;
    }

    @Override
    public int getNextEqualCount(int index) {
        Object[] datas = this.datas;
        int size = this.size;
        int count = 1;
        Object value = datas[index];
        if (value == null) {
            ++index;
            while (index <= size) {
                if (datas[index] == null) {
                    ++count;
                    ++index;
                    continue;
                }
                break;
            }
        } else {
            ++index;
            while (index <= size) {
                if (datas[index] != null && Variant.isEquals(datas[index], value)) {
                    ++count;
                    ++index;
                    continue;
                }
                break;
            }
        }
        return count;
    }
}

