/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.cellset;

import com.scudata.common.ByteArrayInputRecord;
import com.scudata.common.ByteArrayOutputRecord;
import com.scudata.common.ICloneable;
import com.scudata.common.IRecord;
import com.scudata.common.Logger;
import com.scudata.common.StringUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.imageio.ImageIO;

public class BackGraphConfig
implements Externalizable,
ICloneable,
Cloneable,
IRecord {
    private static final long serialVersionUID = 1L;
    public static final byte TYPE_URL = 0;
    public static final byte TYPE_EXP = 1;
    public static final byte DISP_NONE = 10;
    public static final byte DISP_PER_PAGE = 11;
    public static final byte SOURCE_NONE = 0;
    public static final byte SOURCE_PICTURE = 1;
    public static final byte SOURCE_TEXT = 2;
    public static final byte MODE_NONE = 0;
    public static final byte MODE_FILL = 1;
    public static final byte MODE_TILE = 2;
    public static final byte TEXT_NORMAL = 0;
    public static final byte TEXT_TILT = 1;
    private byte _$17 = 0;
    private String _$16;
    private byte _$15 = (byte)11;
    private byte _$14 = 1;
    private byte _$13 = 0;
    private String _$12 = "Dialog";
    private int _$11 = 12;
    private int _$10 = Color.LIGHT_GRAY.getRGB();
    private int _$9 = 40;
    private int _$8 = 30;
    private byte[] _$7 = null;
    public transient byte[] tmpImageBytes = null;
    private transient String _$6 = null;
    private int _$5 = -1;
    private int _$4 = -1;
    private int _$3 = -1;
    private int _$2 = -1;
    private Image _$1 = null;

    public BackGraphConfig() {
    }

    public BackGraphConfig(byte type, String value, byte dispMode) {
        this._$17 = type;
        this._$16 = value;
        this._$15 = dispMode;
    }

    public void setType(byte type) {
        this._$17 = type;
    }

    public byte getType() {
        return this._$17;
    }

    public void setValue(String value) {
        this._$16 = value;
        this.tmpImageBytes = null;
    }

    public String getValue() {
        return this._$16;
    }

    public void setDispMode(byte dispMode) {
        this._$15 = dispMode;
    }

    public byte getDispMode() {
        return this._$15;
    }

    public byte[] getImageBytes() {
        return this._$7;
    }

    public BufferedImage getBufferedImage() {
        if (this._$7 == null) {
            return null;
        }
        return BackGraphConfig.getBufferedImage(this._$7);
    }

    public static BufferedImage getBufferedImage(byte[] imageBytes) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(imageBytes);
            return ImageIO.read(bis);
        }
        catch (Exception e) {
            Logger.error(e);
            return null;
        }
    }

    public Image getBackImage(int w, int h) {
        return this.getBackImage(w, h, 1.0f);
    }

    public void drawImage(Graphics g, int w, int h, float scale) {
        this.drawImage(g, w, h, scale, 0, 0, w, h);
    }

    public void drawImage(Graphics g, int w, int h, float scale, int x1, int y1, int x2, int y2) {
        this.drawImage(g, w, h, scale, x1, y1, x2, y2, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void drawImage(Graphics g, int w, int h, float scale, int x1, int y1, int x2, int y2, int dx, int dy) {
        block6 : switch (this._$14) {
            case 1: {
                Image image;
                int ih;
                int iw;
                boolean graphChanged;
                boolean bl = graphChanged = this._$1 == null || w != this._$3 || h != this._$2;
                if (graphChanged) {
                    BufferedImage bimage = BackGraphConfig.getBufferedImage(this._$7);
                    if (bimage == null) {
                        return;
                    }
                    iw = ((Image)bimage).getWidth(null);
                    if (iw * (ih = ((Image)bimage).getHeight(null)) <= 0) {
                        return;
                    }
                    iw = (int)((float)iw * scale);
                    ih = (int)((float)ih * scale);
                    image = scale != 1.0f ? bimage.getScaledInstance(iw, ih, 4) : bimage;
                    this._$3 = w;
                    this._$2 = h;
                    this._$1 = image;
                    this._$5 = iw;
                    this._$4 = ih;
                } else {
                    image = this._$1;
                    iw = this._$5;
                    ih = this._$4;
                }
                Shape oldClip = g.getClip();
                switch (this._$13) {
                    case 0: {
                        try {
                            g.setClip(x1, y1, x2 - x1, y2 - y1);
                            g.drawImage(image, dx, dy, iw, ih, null);
                            break block6;
                        }
                        catch (Exception x) {
                            break block6;
                        }
                        finally {
                            g.setClip(oldClip);
                        }
                    }
                    case 1: {
                        try {
                            g.setClip(x1, y1, x2 - x1, y2 - y1);
                            g.drawImage(image, dx, dy, w, h, null);
                            break block6;
                        }
                        catch (Exception x) {
                            break block6;
                        }
                        finally {
                            g.setClip(oldClip);
                        }
                    }
                    case 2: {
                        try {
                            int x = dx;
                            int y = dy;
                            while (x < x2) {
                                if (x + iw <= x1) {
                                    x += iw;
                                    continue;
                                }
                                y = dy;
                                while (y < y2) {
                                    if (y + ih <= y1) {
                                        y += ih;
                                        continue;
                                    }
                                    int clipx = Math.max(x, x1);
                                    int clipy = Math.max(y, y1);
                                    g.setClip(clipx, clipy, Math.min(iw, x2 - clipx), Math.min(ih, y2 - clipy));
                                    g.drawImage(image, x, y, iw, ih, null);
                                    y += ih;
                                }
                                x += iw;
                            }
                            break block6;
                        }
                        catch (Exception x) {
                            break block6;
                        }
                        finally {
                            g.setClip(oldClip);
                        }
                    }
                }
                break;
            }
            case 2: {
                if (!StringUtils.isValidString(this._$6)) {
                    return;
                }
                Composite old = BackGraphConfig.setTransparent((Graphics2D)g, (float)this._$8 / 100.0f);
                Color c1 = new Color(this._$10);
                int textAngle = 0;
                if (this._$13 == 1) {
                    textAngle = -45;
                }
                int fSize = StringUtils.getScaledFontSize(this._$11, scale);
                Rectangle textRect = BackGraphConfig.getTextRect(this._$12, fSize, this._$6);
                int iw = textRect.width;
                int ih = textRect.height;
                int x = dx;
                int y = dy;
                Font font = BackGraphConfig.getFont(this._$12, 0, fSize);
                Color c = c1;
                int row = 0;
                int col = 0;
                while (x < w) {
                    row = 0;
                    for (y = dy; y < h; y += ih + this._$9) {
                        int mod;
                        if ((mod = (++row + col) % 2) != 1) continue;
                        BackGraphConfig.drawText(this._$6, x + iw / 2, y + ih / 2, font, c, textAngle, (Graphics2D)g);
                    }
                    x += iw + this._$9;
                    ++col;
                }
                if (old == null) break;
                ((Graphics2D)g).setComposite(old);
            }
        }
    }

    public Image getBackImage(int w, int h, float scale) {
        if (this._$14 == 0) {
            return null;
        }
        if (this._$14 == 1 && this._$7 == null) {
            return null;
        }
        if (this._$14 == 2 && this._$6 == null) {
            return null;
        }
        BufferedImage bimage = null;
        bimage = new BufferedImage(w, h, 2);
        Graphics2D g = bimage.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, w, h);
        this.drawImage(g, w, h, scale);
        return bimage;
    }

    public void setImageBytes(byte[] b) {
        this._$7 = b;
        this._$6 = null;
    }

    public String getWaterMark() {
        return this._$6;
    }

    public void setWaterMark(String wm) {
        this._$6 = wm;
        this._$7 = null;
    }

    public byte getMode() {
        return this._$13;
    }

    public void setMode(byte m) {
        this._$13 = m;
    }

    public int getTextGap() {
        return this._$9;
    }

    public void setTextGap(int g) {
        this._$9 = g;
    }

    public void setTransparency(int tran) {
        this._$8 = tran;
    }

    public int getTransparency() {
        return this._$8;
    }

    public byte getImageSource() {
        return this._$14;
    }

    public void setImageSource(byte src) {
        this._$14 = src;
    }

    public String getFontName() {
        return this._$12;
    }

    public void setFontName(String fn) {
        this._$12 = fn;
    }

    public int getFontSize() {
        return this._$11;
    }

    public void setFontSize(int size) {
        this._$11 = size;
    }

    public int getTextColor() {
        return this._$10;
    }

    public void setTextColor(int c) {
        this._$10 = c;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(3);
        out.writeByte(this._$17);
        out.writeObject(this._$16);
        out.writeByte(this._$15);
        out.writeObject(this._$7);
        out.writeByte(this._$14);
        out.writeByte(this._$13);
        out.writeObject(this._$12);
        out.writeInt(this._$11);
        out.writeInt(this._$10);
        out.writeInt(this._$9);
        out.writeInt(this._$8);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        this._$17 = in.readByte();
        this._$16 = (String)in.readObject();
        this._$15 = in.readByte();
        this._$7 = (byte[])in.readObject();
        if (version > 1) {
            this._$14 = in.readByte();
            this._$13 = in.readByte();
            this._$12 = (String)in.readObject();
            this._$11 = in.readInt();
            this._$10 = in.readInt();
            this._$9 = in.readInt();
        }
        if (version > 2) {
            this._$8 = in.readInt();
        }
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputRecord out = new ByteArrayOutputRecord();
        out.writeByte(this._$17);
        out.writeString(this._$16);
        out.writeByte(this._$15);
        out.writeBytes(this._$7);
        out.writeByte(this._$14);
        out.writeByte(this._$13);
        out.writeString(this._$12);
        out.writeInt(this._$11);
        out.writeInt(this._$10);
        out.writeInt(this._$9);
        out.writeInt(this._$8);
        return out.toByteArray();
    }

    public void fillRecord(byte[] buf) throws IOException, ClassNotFoundException {
        ByteArrayInputRecord in = new ByteArrayInputRecord(buf);
        this._$17 = in.readByte();
        this._$16 = in.readString();
        this._$15 = in.readByte();
        this._$7 = in.readBytes();
        if (in.available() > 0) {
            this._$14 = in.readByte();
            this._$13 = in.readByte();
            this._$12 = in.readString();
            this._$11 = in.readInt();
            this._$10 = in.readInt();
            this._$9 = in.readInt();
        }
        if (in.available() > 0) {
            this._$8 = in.readInt();
        }
    }

    public Object deepClone() {
        BackGraphConfig bgc = new BackGraphConfig();
        bgc.setType(this._$17);
        bgc.setValue(this._$16);
        bgc.setDispMode(this._$15);
        bgc.setImageBytes(this._$7);
        bgc.setImageSource(this._$14);
        bgc.setMode(this._$13);
        bgc.setFontName(this._$12);
        bgc.setFontSize(this._$11);
        bgc.setTextColor(this._$10);
        bgc.setTextGap(this._$9);
        bgc.setTransparency(this._$8);
        return bgc;
    }

    public static Composite setTransparent(Graphics2D g, float transparent) {
        if (transparent >= 1.0f) {
            return null;
        }
        if (transparent < 0.0f) {
            transparent = 0.0f;
        }
        Composite old = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, transparent));
        return old;
    }

    public static Rectangle getTextRect(String textFont, int textSize, String text) {
        Font font = new Font(textFont, 0, textSize);
        Graphics2D g = new BufferedImage(1, 1, 1).createGraphics();
        FontMetrics fm = g.getFontMetrics(font);
        int txtHeight = fm.getHeight();
        g.dispose();
        return new Rectangle(0, 0, fm.stringWidth(text), txtHeight);
    }

    public static synchronized Font getFont(String fontName, int fontStyle, int fontSize) {
        if (fontName == null || fontName.trim().length() < 1) {
            fontName = "dialog";
        }
        Font f = new Font(fontName, fontStyle, fontSize);
        return f;
    }

    public static Rectangle getHorizonArea(String text, Graphics g, Font font) {
        Rectangle area = new Rectangle();
        FontMetrics fm = g.getFontMetrics(font);
        int hw = fm.stringWidth(text);
        int hh = fm.getAscent() + fm.getDescent();
        area.width = hw;
        area.height = hh;
        return area;
    }

    public static Rectangle getRotationArea(String text, Graphics g, int angle, Font font) {
        Rectangle area = new Rectangle();
        if ((angle %= 360) < 0) {
            angle += 360;
        }
        Rectangle area0 = BackGraphConfig.getTextSize(text, g, 0, font);
        double sin = Math.sin((double)angle * Math.PI / 180.0);
        double cos = Math.cos((double)angle * Math.PI / 180.0);
        if (sin < 0.0) {
            sin = -sin;
        }
        if (cos < 0.0) {
            cos = -cos;
        }
        int aw = (int)((double)area0.height * sin + (double)area0.width * cos);
        int ah = (int)((double)area0.width * sin + (double)area0.height * cos);
        area.width = aw;
        area.height = ah;
        return area;
    }

    public static Rectangle getTextSize(String text, Graphics g, int angle, Font font) {
        if (text == null) {
            return new Rectangle();
        }
        Rectangle rect = null;
        rect = angle == 0 ? BackGraphConfig.getHorizonArea(text, g, font) : BackGraphConfig.getRotationArea(text, g, angle, font);
        if (rect.width < 0) {
            rect.width = -rect.width;
        }
        if (rect.height < 0) {
            rect.height = -rect.height;
        }
        return rect;
    }

    public static Point getRealDrawPoint(Rectangle posDesc) {
        Rectangle rect = posDesc;
        int xloc = rect.x;
        int yloc = rect.y;
        return new Point(xloc -= rect.width / 2, yloc += rect.height / 2);
    }

    public static void drawText(String txt, double dx, double dy, Font font, Color c, int angle, Graphics2D g) {
        if (txt == null || txt.trim().length() < 1 || font.getSize() == 0) {
            return;
        }
        int x = (int)dx;
        int y = (int)dy;
        Rectangle rect = BackGraphConfig.getTextSize(txt, g, angle, font);
        rect.x = x;
        rect.y = y;
        g.setFont(font);
        g.setColor(c);
        Point drawPoint = BackGraphConfig.getRealDrawPoint(rect);
        int xloc = drawPoint.x;
        int yloc = drawPoint.y;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        if (angle != 0) {
            AffineTransform at = g.getTransform();
            Rectangle rect2 = BackGraphConfig.getTextSize(txt, g, 0, font);
            rect2.setLocation(xloc, yloc - rect2.height);
            int delx = 0;
            int dely = 0;
            if ((angle %= 360) < 0) {
                angle += 360;
            }
            if (angle >= 0 && angle < 90) {
                delx = 0;
                dely = (int)((double)rect2.width * Math.sin((double)angle * Math.PI / 180.0));
            } else if (angle < 180) {
                dely = rect.height;
                delx = (int)((double)rect2.width * Math.cos((double)angle * Math.PI / 180.0));
            } else if (angle < 270) {
                delx = -rect.width;
                dely = (int)((double)(-rect2.height) * Math.sin((double)angle * Math.PI / 180.0));
            } else {
                dely = 0;
                delx = (int)((double)rect2.height * Math.sin((double)angle * Math.PI / 180.0));
            }
            AffineTransform at1 = AffineTransform.getRotateInstance((double)angle * Math.PI / 180.0, xloc - delx, yloc - dely);
            g.transform(at1);
            g.setColor(c);
            g.drawString(txt, xloc - delx, yloc - dely);
            g.setTransform(at);
        } else {
            g.setColor(c);
            g.drawString(txt, xloc, yloc);
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }
}

