/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.cellset.datamodel;

import com.scudata.cellset.CellRefUtil;
import com.scudata.cellset.ICellSet;
import com.scudata.cellset.IColCell;
import com.scudata.cellset.INormalCell;
import com.scudata.cellset.IRowCell;
import com.scudata.cellset.datamodel.ColCell;
import com.scudata.cellset.datamodel.NormalCell;
import com.scudata.cellset.datamodel.RowCell;
import com.scudata.cellset.datamodel.llIllllIIllIIlIl;
import com.scudata.common.ByteArrayInputRecord;
import com.scudata.common.ByteArrayOutputRecord;
import com.scudata.common.ByteMap;
import com.scudata.common.CellLocation;
import com.scudata.common.Matrix;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.common.Sentence;
import com.scudata.dm.Context;
import com.scudata.dm.KeyWord;
import com.scudata.dm.Param;
import com.scudata.dm.ParamList;
import com.scudata.resources.EngineMessage;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CellSet
implements ICellSet {
    private static final long serialVersionUID = 0x2010010L;
    protected Matrix cellMatrix;
    protected ParamList paramList;
    private transient boolean _$2 = true;
    private transient Context _$1 = new Context();

    public CellSet() {
        this(10, 10);
    }

    public CellSet(int row, int col) {
        if (row < 1) {
            row = 1;
        }
        if (col < 1) {
            col = 1;
        }
        this.cellMatrix = new Matrix(row + 1, col + 1);
        this._$2(1, row);
        this._$1(1, col);
        this._$1(1, row, 1, col);
    }

    public abstract NormalCell newCell(int var1, int var2);

    public abstract RowCell newRowCell(int var1);

    public abstract ColCell newColCell(int var1);

    @Override
    public INormalCell getCell(int row, int col) {
        return (INormalCell)this.cellMatrix.get(row, col);
    }

    protected NormalCell getNormalCell(int row, int col) {
        return (NormalCell)this.cellMatrix.get(row, col);
    }

    @Override
    public INormalCell getCell(String id) {
        CellLocation cl = CellLocation.parse(id);
        if (cl != null) {
            int row = cl.getRow();
            int col = cl.getCol();
            if (row > 0 && row <= this.getRowCount() && col > 0 && col <= this.getColCount()) {
                return this.getCell(row, col);
            }
        }
        return null;
    }

    @Override
    public void setCell(int r, int c, INormalCell cell) {
        cell.setRow(r);
        cell.setCol(c);
        this.cellMatrix.set(r, c, cell);
    }

    @Override
    public IRowCell getRowCell(int r) {
        return (IRowCell)this.cellMatrix.get(r, 0);
    }

    @Override
    public void setRowCell(int r, IRowCell rc) {
        rc.setRow(r);
        this.cellMatrix.set(r, 0, rc);
    }

    @Override
    public IColCell getColCell(int c) {
        return (IColCell)this.cellMatrix.get(0, c);
    }

    @Override
    public void setColCell(int c, IColCell cc) {
        cc.setCol(c);
        this.cellMatrix.set(0, c, cc);
    }

    @Override
    public int getRowCount() {
        return this.cellMatrix.getRowSize() - 1;
    }

    @Override
    public int getColCount() {
        return this.cellMatrix.getColSize() - 1;
    }

    public List<NormalCell> insertRow(int r) {
        return this.insertRow(r, 1);
    }

    public List<NormalCell> insertRow(int r, int count) {
        ArrayList<NormalCell> errorCells = new ArrayList<NormalCell>();
        if (count < 1) {
            return errorCells;
        }
        int oldCount = this.getRowCount();
        if (r == oldCount + 1) {
            this.addRow(count);
            return errorCells;
        }
        if (r < 1 || r > oldCount) {
            return errorCells;
        }
        int colCount = this.getColCount();
        if (this._$2) {
            this._$1(r, count, -1, 0, oldCount, colCount, errorCells);
        }
        this.cellMatrix.insertRows(r, count);
        this._$2(r, count);
        this._$1(r, count, 1, colCount);
        this.adjustRow(r + count);
        return errorCells;
    }

    public List<NormalCell> insertCol(int c) {
        return this.insertCol(c, 1);
    }

    public List<NormalCell> insertCol(int c, int count) {
        ArrayList<NormalCell> errorCells = new ArrayList<NormalCell>();
        if (count < 1) {
            return errorCells;
        }
        int oldCount = this.getColCount();
        if (c == oldCount + 1) {
            this.addCol(count);
            return errorCells;
        }
        if (c < 1 || c > oldCount) {
            return errorCells;
        }
        int rowCount = this.getRowCount();
        if (this._$2) {
            this._$1(-1, 0, c, count, rowCount, oldCount, errorCells);
        }
        this.cellMatrix.insertCols(c, count);
        this._$1(c, count);
        this._$1(1, rowCount, c, count);
        this.adjustCol(c + count);
        return errorCells;
    }

    public void addRow() {
        this.addRow(1);
    }

    public void addRow(int count) {
        if (count < 1) {
            return;
        }
        int rowIndex = this.getRowCount() + 1;
        int colCount = this.getColCount();
        this.cellMatrix.addRows(count);
        this._$2(rowIndex, count);
        this._$1(rowIndex, count, 1, colCount);
    }

    public void addCol() {
        this.addCol(1);
    }

    public void addCol(int count) {
        if (count < 1) {
            return;
        }
        int colIndex = this.getColCount() + 1;
        int rowCount = this.getRowCount();
        this.cellMatrix.addCols(count);
        this._$1(colIndex, count);
        this._$1(1, rowCount, colIndex, count);
    }

    public List<NormalCell> removeRow(int r) {
        return this.removeRow(r, 1);
    }

    public List<NormalCell> removeRow(int r, int count) {
        ArrayList<NormalCell> errorCells = new ArrayList<NormalCell>();
        if (count < 1) {
            return errorCells;
        }
        int oldRowCount = this.getRowCount();
        int oldColCount = this.getColCount();
        this.cellMatrix.deleteRows(r, count);
        if (this._$2) {
            this._$1(r, -count, -1, 0, oldRowCount, oldColCount, errorCells);
        }
        this.adjustRow(r);
        return errorCells;
    }

    public List<NormalCell> removeCol(int c) {
        return this.removeCol(c, 1);
    }

    public List<NormalCell> removeCol(int c, int count) {
        ArrayList<NormalCell> errorCells = new ArrayList<NormalCell>();
        if (count < 1) {
            return errorCells;
        }
        int oldRowCount = this.getRowCount();
        int oldColCount = this.getColCount();
        this.cellMatrix.deleteCols(c, count);
        if (this._$2) {
            this._$1(-1, 0, c, -count, oldRowCount, oldColCount, errorCells);
        }
        this.adjustCol(c);
        return errorCells;
    }

    public Object removeRows(int[] rows) {
        if (rows == null || rows.length == 0) {
            return null;
        }
        int count = rows.length;
        ArrayList<NormalCell> errorCells = new ArrayList<NormalCell>();
        int colCount = this.getColCount();
        Object[][] deleteRows = new Object[count][];
        for (int i = 0; i < count; ++i) {
            int r = rows[i];
            Object[] row = new Object[colCount + 1];
            deleteRows[i] = row;
            row[0] = this.getRowCell(r);
            for (int c = 1; c <= colCount; ++c) {
                row[c] = this.getCell(r, c);
            }
        }
        int oldRowCount = this.getRowCount();
        this.cellMatrix.deleteRows(rows);
        this.adjustRow(rows[0]);
        this._$1(rows, false, oldRowCount, errorCells);
        llIllllIIllIIlIl removeResult = new llIllllIIllIIlIl(deleteRows, rows, errorCells);
        return removeResult;
    }

    public void undoRemoveRows(Object removeRetVal) {
        if (removeRetVal == null) {
            return;
        }
        llIllllIIllIIlIl removeResult = (llIllllIIllIIlIl)removeRetVal;
        int[] rowSeqs = llIllllIIllIIlIl._$3(removeResult);
        Object[][] rows = llIllllIIllIIlIl._$2(removeResult);
        List errorRefCells = llIllllIIllIIlIl._$1(removeResult);
        int deleteCount = rowSeqs.length;
        int[] insertSeqs = new int[deleteCount];
        for (int i = 0; i < deleteCount; ++i) {
            insertSeqs[i] = rowSeqs[i] - i;
        }
        this.insertRows(insertSeqs, 0);
        int colCount = this.getColCount();
        for (int i = 0; i < deleteCount; ++i) {
            int r = rowSeqs[i];
            Object[] row = rows[i];
            this.setRowCell(r, (IRowCell)row[0]);
            for (int c = 1; c <= colCount; ++c) {
                this.setCell(r, c, (INormalCell)row[c]);
            }
        }
        int size = errorRefCells == null ? 0 : errorRefCells.size();
        for (int i = 0; i < size; ++i) {
            INormalCell cell = (INormalCell)errorRefCells.get(i);
            this.setCell(cell.getRow(), cell.getCol(), cell);
        }
    }

    private void _$1(int startRow, int rowCount, int startCol, int colCount) {
        int endRow = startRow + rowCount;
        int endCol = startCol + colCount;
        for (int r = startRow; r < endRow; ++r) {
            for (int c = startCol; c < endCol; ++c) {
                this.cellMatrix.set(r, c, this.newCell(r, c));
            }
        }
    }

    private void _$2(int startRow, int rowCount) {
        int endRow = startRow + rowCount;
        for (int r = startRow; r < endRow; ++r) {
            this.cellMatrix.set(r, 0, this.newRowCell(r));
        }
    }

    private void _$1(int startCol, int colCount) {
        int endCol = startCol + colCount;
        for (int c = startCol; c < endCol; ++c) {
            this.cellMatrix.set(0, c, this.newColCell(c));
        }
    }

    protected void adjustRow(int startRow) {
        int rowCount = this.getRowCount();
        int colCount = this.getColCount();
        for (int r = startRow; r <= rowCount; ++r) {
            IRowCell rowCell = this.getRowCell(r);
            rowCell.setRow(r);
            for (int c = 1; c <= colCount; ++c) {
                INormalCell cell = this.getCell(r, c);
                if (cell == null) continue;
                cell.setRow(r);
            }
        }
    }

    protected void adjustCol(int startCol) {
        int rowCount = this.getRowCount();
        int colCount = this.getColCount();
        for (int c = startCol; c <= colCount; ++c) {
            IColCell colCell = this.getColCell(c);
            colCell.setCol(c);
            for (int r = 1; r <= rowCount; ++r) {
                INormalCell cell = this.getCell(r, c);
                if (cell == null) continue;
                cell.setCol(c);
            }
        }
    }

    public ParamList getParamList() {
        return this.paramList;
    }

    public void setParamList(ParamList paramList) {
        this.paramList = paramList;
    }

    @Override
    public Context getContext() {
        if (this._$1 == null) {
            this._$1 = new Context();
        }
        return this._$1;
    }

    public void setContext(Context ctx) {
        this._$1 = ctx;
    }

    public void reset() {
        int rowCount = this.getRowCount();
        int colCount = this.getColCount();
        for (int r = 1; r <= rowCount; ++r) {
            for (int c = 1; c <= colCount; ++c) {
                NormalCell cell = this.getNormalCell(r, c);
                if (cell == null) continue;
                cell.reset();
            }
        }
        this.runFinished();
        Context ctx = this.getContext();
        if (ctx != null) {
            ctx.getComputeStack().reset();
            ParamList list = ctx.getParamList();
            if (list != null) {
                list.clear();
            }
        }
        this.setParamToContext();
    }

    public abstract void run();

    public abstract void runCell(int var1, int var2);

    public void runFinished() {
    }

    public void setParamToContext() {
        Context ctx = this.getContext();
        ParamList paramList = this.paramList;
        if (paramList != null) {
            int count = paramList.count();
            for (int i = 0; i < count; ++i) {
                Param param = paramList.get(i);
                if (ctx.getParam(param.getName()) != null) continue;
                Object value = param.getValue();
                ctx.setParamValue(param.getName(), value, param.getKind());
            }
        }
    }

    public void resetParam() {
        ParamList ctxParam = new ParamList();
        this._$1.setParamList(ctxParam);
        ParamList paramList = this.paramList;
        if (paramList != null) {
            int count = paramList.count();
            for (int i = 0; i < count; ++i) {
                Param param = paramList.get(i);
                Object value = param.getValue();
                this._$1.setParamValue(param.getName(), value);
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        out.writeObject(this.cellMatrix);
        out.writeObject(this.paramList);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        this.cellMatrix = (Matrix)in.readObject();
        this.paramList = (ParamList)in.readObject();
    }

    @Override
    public byte[] serialize() throws IOException {
        int row;
        ByteArrayOutputRecord out = new ByteArrayOutputRecord();
        int rowCount = this.getRowCount();
        int colCount = this.getColCount();
        out.writeInt(rowCount);
        out.writeInt(colCount);
        for (row = 1; row <= rowCount; ++row) {
            IRowCell rc = this.getRowCell(row);
            out.writeRecord(rc);
        }
        for (int col = 1; col <= colCount; ++col) {
            IColCell cc = this.getColCell(col);
            out.writeRecord(cc);
        }
        for (row = 1; row <= rowCount; ++row) {
            for (int col = 1; col <= colCount; ++col) {
                INormalCell nc = this.getCell(row, col);
                out.writeRecord(nc);
            }
        }
        out.writeRecord(this.paramList);
        return out.toByteArray();
    }

    @Override
    public void fillRecord(byte[] buf) throws IOException, ClassNotFoundException {
        int row;
        ByteArrayInputRecord in = new ByteArrayInputRecord(buf);
        int rowCount = in.readInt();
        int colCount = in.readInt();
        this.cellMatrix = new Matrix(rowCount + 1, colCount + 1);
        for (row = 1; row <= rowCount; ++row) {
            RowCell rc = (RowCell)in.readRecord(this.newRowCell(row));
            this.cellMatrix.set(row, 0, rc);
        }
        for (int col = 1; col <= colCount; ++col) {
            ColCell cc = (ColCell)in.readRecord(this.newColCell(col));
            this.cellMatrix.set(0, col, cc);
        }
        for (row = 1; row <= rowCount; ++row) {
            for (int col = 1; col <= colCount; ++col) {
                NormalCell nc = (NormalCell)in.readRecord(this.newCell(row, col));
                this.cellMatrix.set(row, col, nc);
            }
        }
        this.paramList = (ParamList)in.readRecord(new ParamList());
    }

    public List<NormalCell> adjustCell(ICellSet srcCs, NormalCell cell, int rowOff, int colOff) {
        ByteMap expMap;
        NormalCell cellClone = (NormalCell)cell.deepClone();
        boolean isErrRef = false;
        boolean[] error = new boolean[1];
        ArrayList<NormalCell> errorCells = new ArrayList<NormalCell>();
        if (cell.needRegulateString()) {
            cell.setExpString(this.relativeRegulateString(srcCs, cell.getExpString(), rowOff, colOff, error));
            if (error[0]) {
                isErrRef = true;
            }
        }
        if ((expMap = cell.getExpMap(true)) != null) {
            int size = expMap.size();
            for (int i = 0; i < size; ++i) {
                String expStr = (String)expMap.getValue(i);
                expMap.setValue(i, this.relativeRegulateString(srcCs, expStr, rowOff, colOff, error));
                if (!error[0]) continue;
                isErrRef = true;
            }
            cell.setExpMap(expMap);
        }
        if (isErrRef) {
            errorCells.add(cellClone);
        }
        return errorCells;
    }

    public List<NormalCell> adjustReference(CellLocation srcLct, CellLocation tgtLct) {
        ArrayList<NormalCell> errorCells = new ArrayList<NormalCell>();
        if (!this._$2) {
            return errorCells;
        }
        if (srcLct == null || tgtLct == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("function.paramValNull"));
        }
        boolean[] error = new boolean[1];
        int rowCount = this.getRowCount();
        int colCount = this.getColCount();
        for (int row = 1; row <= rowCount; ++row) {
            for (int col = 1; col <= colCount; ++col) {
                ByteMap expMap;
                NormalCell cell = this.getNormalCell(row, col);
                if (cell == null) continue;
                boolean isErrRef = false;
                boolean needRegulateString = cell.needRegulateString();
                String newExpStr = null;
                if (needRegulateString) {
                    newExpStr = CellSet._$1(cell.getExpString(), srcLct, tgtLct, error);
                    if (error[0]) {
                        isErrRef = true;
                    }
                }
                if ((expMap = cell.getExpMap(true)) != null) {
                    int size = expMap.size();
                    for (int i = 0; i < size; ++i) {
                        String expStr = (String)expMap.getValue(i);
                        expMap.setValue(i, CellSet._$1(expStr, srcLct, tgtLct, error));
                        if (!error[0]) continue;
                        isErrRef = true;
                    }
                }
                if (isErrRef) {
                    errorCells.add((NormalCell)cell.deepClone());
                }
                if (needRegulateString) {
                    cell.setExpString(newExpStr);
                }
                if (expMap == null) continue;
                cell.setExpMap(expMap);
            }
        }
        return errorCells;
    }

    public void exchangeReference(CellLocation lct1, CellLocation lct2) {
        if (!this._$2) {
            return;
        }
        int rowCount = this.getRowCount();
        int colCount = this.getColCount();
        for (int row = 1; row <= rowCount; ++row) {
            for (int col = 1; col <= colCount; ++col) {
                ByteMap expMap;
                NormalCell cell = this.getNormalCell(row, col);
                if (cell == null) continue;
                if (cell.needRegulateString()) {
                    cell.setExpString(CellRefUtil.exchangeCellString(cell.getExpString(), lct1, lct2));
                }
                if ((expMap = cell.getExpMap(false)) == null) continue;
                int size = expMap.size();
                for (int i = 0; i < size; ++i) {
                    String expStr = (String)expMap.getValue(i);
                    expMap.setValue(i, CellRefUtil.exchangeCellString(expStr, lct1, lct2));
                }
            }
        }
    }

    public void adjustRowReference(int sr, int tr) {
        if (!this._$2) {
            return;
        }
        int rowCount = this.getRowCount();
        int colCount = this.getColCount();
        for (int row = 1; row <= rowCount; ++row) {
            for (int col = 1; col <= colCount; ++col) {
                ByteMap expMap;
                NormalCell cell = this.getNormalCell(row, col);
                if (cell == null) continue;
                if (cell.needRegulateString()) {
                    cell.setExpString(this._$1(cell.getExpString(), sr, tr));
                }
                if ((expMap = cell.getExpMap(false)) == null) continue;
                int size = expMap.size();
                for (int i = 0; i < size; ++i) {
                    String expStr = (String)expMap.getValue(i);
                    expMap.setValue(i, this._$1(expStr, sr, tr));
                }
            }
        }
    }

    protected void adjustRowReference(int[] newSeqs) {
        if (!this._$2) {
            return;
        }
        int rowCount = this.getRowCount();
        int colCount = this.getColCount();
        for (int row = 1; row <= rowCount; ++row) {
            for (int col = 1; col <= colCount; ++col) {
                ByteMap expMap;
                NormalCell cell = this.getNormalCell(row, col);
                if (cell == null) continue;
                if (cell.needRegulateString()) {
                    cell.setExpString(this._$1(cell.getExpString(), newSeqs));
                }
                if ((expMap = cell.getExpMap(false)) == null) continue;
                int size = expMap.size();
                for (int i = 0; i < size; ++i) {
                    String expStr = (String)expMap.getValue(i);
                    expMap.setValue(i, this._$1(expStr, newSeqs));
                }
            }
        }
    }

    public String relativeRegulateString(ICellSet srcCs, String str, int rowIncrement, int colIncrement, boolean[] error) {
        error[0] = false;
        if (str == null || str.length() == 0 || str.startsWith("#REF!")) {
            return str;
        }
        StringBuffer strNew = null;
        int len = str.length();
        int idx = 0;
        while (idx < len) {
            char ch = str.charAt(idx);
            if (ch == '\'' || ch == '\"') {
                int tmp = Sentence.scanQuotation(str, idx);
                if (tmp < 0) {
                    if (strNew == null) break;
                    strNew.append(str.substring(idx));
                    break;
                }
                ++tmp;
                if (strNew != null) {
                    strNew.append(str.substring(idx, tmp));
                }
                idx = tmp;
                continue;
            }
            if (KeyWord.isSymbol(ch) || ch == '#') {
                if (strNew != null) {
                    strNew.append(ch);
                }
                ++idx;
                continue;
            }
            int last = CellSet.scanId(str, idx);
            if (last - idx < 2 || !CellRefUtil.isColChar(ch) && ch != '$' || CellRefUtil.isPrevDot(str, idx)) {
                if (strNew != null) {
                    strNew.append(str.substring(idx, last));
                }
                idx = last;
                continue;
            }
            int macroIndex = -1;
            int numIndex = -1;
            for (int i = idx + 1; i < last; ++i) {
                char tmp = str.charAt(i);
                if (tmp == '$') {
                    macroIndex = i;
                    numIndex = i + 1;
                    break;
                }
                if (CellRefUtil.isRowChar(tmp)) {
                    numIndex = i;
                    break;
                }
                if (!CellRefUtil.isColChar(tmp)) break;
            }
            if (numIndex == -1) {
                if (strNew != null) {
                    strNew.append(str.substring(idx, last));
                }
                idx = last;
                continue;
            }
            int rowCount = this.getRowCount();
            int colCount = this.getColCount();
            int srcRowCount = srcCs.getRowCount();
            int srcColCount = srcCs.getColCount();
            if (ch == '$') {
                if (macroIndex == -1) {
                    CellLocation lct = CellLocation.parse(str.substring(idx + 1, last));
                    if (lct == null || lct.getRow() > srcRowCount || lct.getCol() > srcColCount) {
                        if (strNew != null) {
                            strNew.append(str.substring(idx, last));
                        }
                    } else {
                        String strRow = CellRefUtil.changeRow(lct.getRow(), rowIncrement, rowCount);
                        if (strRow == null) {
                            error[0] = true;
                            return "#REF!" + str;
                        }
                        if (strNew == null) {
                            strNew = new StringBuffer(64);
                            strNew.append(str.substring(0, idx));
                        }
                        strNew.append(str.substring(idx, numIndex));
                        strNew.append(strRow);
                    }
                } else if (strNew != null) {
                    strNew.append(str.substring(idx, last));
                }
            } else if (macroIndex == -1) {
                CellLocation lct = CellLocation.parse(str.substring(idx, last));
                if (lct == null || lct.getRow() > srcRowCount || lct.getCol() > srcColCount) {
                    if (strNew != null) {
                        strNew.append(str.substring(idx, last));
                    }
                } else {
                    String strCol = CellRefUtil.changeCol(lct.getCol(), colIncrement, colCount);
                    if (strCol == null) {
                        error[0] = true;
                        return "#REF!" + str;
                    }
                    String strRow = CellRefUtil.changeRow(lct.getRow(), rowIncrement, rowCount);
                    if (strRow == null) {
                        error[0] = true;
                        return "#REF!" + str;
                    }
                    if (strNew == null) {
                        strNew = new StringBuffer(64);
                        strNew.append(str.substring(0, idx));
                    }
                    strNew.append(strCol);
                    strNew.append(strRow);
                }
            } else {
                int col = CellLocation.parseCol(str.substring(idx, macroIndex));
                int row = CellLocation.parseRow(str.substring(numIndex, last));
                if (col <= 0 || row <= 0 || col > srcColCount || row > srcRowCount) {
                    if (strNew != null) {
                        strNew.append(str.substring(idx, last));
                    }
                } else {
                    String strCol = CellRefUtil.changeCol(col, colIncrement, colCount);
                    if (strCol == null) {
                        error[0] = true;
                        return "#REF!" + str;
                    }
                    if (strNew == null) {
                        strNew = new StringBuffer(64);
                        strNew.append(str.substring(0, idx));
                    }
                    strNew.append(strCol);
                    strNew.append(str.substring(macroIndex, last));
                }
            }
            idx = last;
        }
        return strNew == null ? str : strNew.toString();
    }

    private void _$1(int rowBase, int rowIncrement, int colBase, int colIncrement, int oldRowCount, int oldColCount, List<NormalCell> errorCells) {
        int rowCount = this.getRowCount();
        int colCount = this.getColCount();
        boolean[] error = new boolean[1];
        for (int row = 1; row <= rowCount; ++row) {
            for (int col = 1; col <= colCount; ++col) {
                ByteMap expMap;
                NormalCell cell = this.getNormalCell(row, col);
                if (cell == null) continue;
                boolean isErrRef = false;
                boolean needRegulateString = cell.needRegulateString();
                String newExpStr = null;
                if (needRegulateString) {
                    newExpStr = CellSet._$1(cell.getExpString(), rowBase, rowIncrement, colBase, colIncrement, oldRowCount, oldColCount, error);
                    if (error[0]) {
                        isErrRef = true;
                    }
                }
                if ((expMap = cell.getExpMap(true)) != null) {
                    int size = expMap.size();
                    for (int i = 0; i < size; ++i) {
                        String expStr = (String)expMap.getValue(i);
                        expMap.setValue(i, CellSet._$1(expStr, rowBase, rowIncrement, colBase, colIncrement, oldRowCount, oldColCount, error));
                        if (!error[0]) continue;
                        isErrRef = true;
                    }
                }
                if (isErrRef) {
                    errorCells.add((NormalCell)cell.deepClone());
                }
                if (needRegulateString) {
                    cell.setExpString(newExpStr);
                }
                if (expMap == null) continue;
                cell.setExpMap(expMap);
            }
        }
    }

    private static String _$1(String str, int rowBase, int rowIncrement, int colBase, int colIncrement, int oldRowCount, int oldColCount, boolean[] error) {
        error[0] = false;
        if (str == null || str.length() == 0 || str.startsWith("#REF!")) {
            return str;
        }
        StringBuffer strNew = null;
        int len = str.length();
        int idx = 0;
        while (idx < len) {
            String strRow;
            String strCol;
            int row;
            int col;
            String strRow2;
            char ch = str.charAt(idx);
            if (ch == '\'' || ch == '\"') {
                int tmp = Sentence.scanQuotation(str, idx);
                if (tmp < 0) {
                    if (strNew == null) break;
                    strNew.append(str.substring(idx));
                    break;
                }
                ++tmp;
                if (strNew != null) {
                    strNew.append(str.substring(idx, tmp));
                }
                idx = tmp;
                continue;
            }
            if (KeyWord.isSymbol(ch) || ch == '#') {
                if (strNew != null) {
                    strNew.append(ch);
                }
                ++idx;
                continue;
            }
            int last = CellSet.scanId(str, idx);
            if (last - idx < 2 || !CellRefUtil.isColChar(ch) && ch != '$' || CellRefUtil.isPrevDot(str, idx)) {
                if (strNew != null) {
                    strNew.append(str.substring(idx, last));
                }
                idx = last;
                continue;
            }
            int macroIndex = -1;
            int numIndex = -1;
            for (int i = idx + 1; i < last; ++i) {
                char tmp = str.charAt(i);
                if (tmp == '$') {
                    macroIndex = i;
                    numIndex = i + 1;
                    break;
                }
                if (CellRefUtil.isRowChar(tmp)) {
                    numIndex = i;
                    break;
                }
                if (!CellRefUtil.isColChar(tmp)) break;
            }
            if (numIndex == -1) {
                if (strNew != null) {
                    strNew.append(str.substring(idx, last));
                }
                idx = last;
                continue;
            }
            if (ch == '$') {
                if (macroIndex == -1) {
                    CellLocation lct = CellLocation.parse(str.substring(idx + 1, last));
                    if (lct == null || lct.getRow() > oldRowCount || lct.getCol() > oldColCount) {
                        if (strNew != null) {
                            strNew.append(str.substring(idx, last));
                        }
                    } else {
                        String strCol2 = CellRefUtil.changeCol(lct.getCol(), colBase, colIncrement, oldColCount);
                        if (strCol2 == null) {
                            error[0] = true;
                            return "#REF!" + str;
                        }
                        strRow2 = CellRefUtil.changeRow(lct.getRow(), rowBase, rowIncrement, oldRowCount);
                        if (strRow2 == null) {
                            error[0] = true;
                            return "#REF!" + str;
                        }
                        if (strNew == null) {
                            strNew = new StringBuffer(64);
                            strNew.append(str.substring(0, idx));
                        }
                        strNew.append('$');
                        strNew.append(strCol2);
                        strNew.append(strRow2);
                    }
                } else {
                    col = CellLocation.parseCol(str.substring(idx + 1, macroIndex));
                    row = CellLocation.parseRow(str.substring(numIndex, last));
                    if (col <= 0 || row <= 0 || row > oldRowCount || col > oldColCount) {
                        if (strNew != null) {
                            strNew.append(str.substring(idx, last));
                        }
                    } else {
                        strCol = CellRefUtil.changeCol(col, colBase, colIncrement, oldColCount);
                        if (strCol == null) {
                            error[0] = true;
                            return "#REF!" + str;
                        }
                        strRow = CellRefUtil.changeRow(row, rowBase, rowIncrement, oldRowCount);
                        if (strRow == null) {
                            error[0] = true;
                            return "#REF!" + str;
                        }
                        if (strNew == null) {
                            strNew = new StringBuffer(64);
                            strNew.append(str.substring(0, idx));
                        }
                        strNew.append('$');
                        strNew.append(strCol);
                        strNew.append('$');
                        strNew.append(strRow);
                    }
                }
            } else if (macroIndex == -1) {
                CellLocation lct = CellLocation.parse(str.substring(idx, last));
                if (lct == null || lct.getRow() > oldRowCount || lct.getCol() > oldColCount) {
                    if (strNew != null) {
                        strNew.append(str.substring(idx, last));
                    }
                } else {
                    String strCol3 = CellRefUtil.changeCol(lct.getCol(), colBase, colIncrement, oldColCount);
                    if (strCol3 == null) {
                        error[0] = true;
                        return "#REF!" + str;
                    }
                    strRow2 = CellRefUtil.changeRow(lct.getRow(), rowBase, rowIncrement, oldRowCount);
                    if (strRow2 == null) {
                        error[0] = true;
                        return "#REF!" + str;
                    }
                    if (strNew == null) {
                        strNew = new StringBuffer(64);
                        strNew.append(str.substring(0, idx));
                    }
                    strNew.append(strCol3);
                    strNew.append(strRow2);
                }
            } else {
                col = CellLocation.parseCol(str.substring(idx, macroIndex));
                row = CellLocation.parseRow(str.substring(numIndex, last));
                if (col <= 0 || row <= 0 || row > oldRowCount || col > oldColCount) {
                    if (strNew != null) {
                        strNew.append(str.substring(idx, last));
                    }
                } else {
                    strCol = CellRefUtil.changeCol(col, colBase, colIncrement, oldColCount);
                    if (strCol == null) {
                        error[0] = true;
                        return "#REF!" + str;
                    }
                    strRow = CellRefUtil.changeRow(row, rowBase, rowIncrement, oldRowCount);
                    if (strRow == null) {
                        error[0] = true;
                        return "#REF!" + str;
                    }
                    if (strNew == null) {
                        strNew = new StringBuffer(64);
                        strNew.append(str.substring(0, idx));
                    }
                    strNew.append(strCol);
                    strNew.append('$');
                    strNew.append(strRow);
                }
            }
            idx = last;
        }
        return strNew == null ? str : strNew.toString();
    }

    private static String _$1(String str, CellLocation srcLct, CellLocation tgtLct, boolean[] error) {
        error[0] = false;
        if (str == null || str.length() == 0 || str.startsWith("#REF!")) {
            return str;
        }
        StringBuffer strNew = null;
        int len = str.length();
        int idx = 0;
        while (idx < len) {
            int row;
            int col;
            char ch = str.charAt(idx);
            if (ch == '\'' || ch == '\"') {
                int tmp = Sentence.scanQuotation(str, idx);
                if (tmp < 0) {
                    if (strNew == null) break;
                    strNew.append(str.substring(idx));
                    break;
                }
                ++tmp;
                if (strNew != null) {
                    strNew.append(str.substring(idx, tmp));
                }
                idx = tmp;
                continue;
            }
            if (KeyWord.isSymbol(ch) || ch == '#') {
                if (strNew != null) {
                    strNew.append(ch);
                }
                ++idx;
                continue;
            }
            int last = CellSet.scanId(str, idx);
            if (last - idx < 2 || !CellRefUtil.isColChar(ch) && ch != '$' || CellRefUtil.isPrevDot(str, idx)) {
                if (strNew != null) {
                    strNew.append(str.substring(idx, last));
                }
                idx = last;
                continue;
            }
            int macroIndex = -1;
            int numIndex = -1;
            for (int i = idx + 1; i < last; ++i) {
                char tmp = str.charAt(i);
                if (tmp == '$') {
                    macroIndex = i;
                    numIndex = i + 1;
                    break;
                }
                if (CellRefUtil.isRowChar(tmp)) {
                    numIndex = i;
                    break;
                }
                if (!CellRefUtil.isColChar(tmp)) break;
            }
            if (numIndex == -1) {
                if (strNew != null) {
                    strNew.append(str.substring(idx, last));
                }
                idx = last;
                continue;
            }
            if (ch == '$') {
                if (macroIndex == -1) {
                    CellLocation lct = CellLocation.parse(str.substring(idx + 1, last));
                    if (srcLct.equals(lct)) {
                        if (strNew == null) {
                            strNew = new StringBuffer(64);
                            strNew.append(str.substring(0, idx));
                        }
                        strNew.append('$');
                        strNew.append(tgtLct.toString());
                    } else {
                        if (tgtLct.equals(lct)) {
                            error[0] = true;
                            return "#REF!" + str;
                        }
                        if (strNew != null) {
                            strNew.append(str.substring(idx, last));
                        }
                    }
                } else {
                    col = CellLocation.parseCol(str.substring(idx + 1, macroIndex));
                    row = CellLocation.parseRow(str.substring(numIndex, last));
                    if (col == srcLct.getCol() && row == srcLct.getRow()) {
                        if (strNew == null) {
                            strNew = new StringBuffer(64);
                            strNew.append(str.substring(0, idx));
                        }
                        strNew.append('$');
                        strNew.append(CellLocation.toCol(tgtLct.getCol()));
                        strNew.append('$');
                        strNew.append(CellLocation.toRow(tgtLct.getRow()));
                    } else {
                        if (col == tgtLct.getCol() && row == tgtLct.getRow()) {
                            error[0] = true;
                            return "#REF!" + str;
                        }
                        if (strNew != null) {
                            strNew.append(str.substring(idx, last));
                        }
                    }
                }
            } else if (macroIndex == -1) {
                CellLocation lct = CellLocation.parse(str.substring(idx, last));
                if (srcLct.equals(lct)) {
                    if (strNew == null) {
                        strNew = new StringBuffer(64);
                        strNew.append(str.substring(0, idx));
                    }
                    strNew.append(tgtLct.toString());
                } else {
                    if (tgtLct.equals(lct)) {
                        error[0] = true;
                        return "#REF!" + str;
                    }
                    if (strNew != null) {
                        strNew.append(str.substring(idx, last));
                    }
                }
            } else {
                col = CellLocation.parseCol(str.substring(idx, macroIndex));
                row = CellLocation.parseRow(str.substring(numIndex, last));
                if (col == srcLct.getCol() && row == srcLct.getRow()) {
                    if (strNew == null) {
                        strNew = new StringBuffer(64);
                        strNew.append(str.substring(0, idx));
                    }
                    strNew.append(CellLocation.toCol(tgtLct.getCol()));
                    strNew.append('$');
                    strNew.append(CellLocation.toRow(tgtLct.getRow()));
                } else {
                    if (col == tgtLct.getCol() && row == tgtLct.getRow()) {
                        error[0] = true;
                        return "#REF!" + str;
                    }
                    if (strNew != null) {
                        strNew.append(str.substring(idx, last));
                    }
                }
            }
            idx = last;
        }
        return strNew == null ? str : strNew.toString();
    }

    private String _$1(String str, int sr, int tr) {
        if (str == null || str.length() == 0 || str.startsWith("#REF!")) {
            return str;
        }
        StringBuffer strNew = null;
        int len = str.length();
        int colCount = this.getColCount();
        int idx = 0;
        while (idx < len) {
            int row;
            int col;
            char ch = str.charAt(idx);
            if (ch == '\'' || ch == '\"') {
                int tmp = Sentence.scanQuotation(str, idx);
                if (tmp < 0) {
                    if (strNew == null) break;
                    strNew.append(str.substring(idx));
                    break;
                }
                ++tmp;
                if (strNew != null) {
                    strNew.append(str.substring(idx, tmp));
                }
                idx = tmp;
                continue;
            }
            if (KeyWord.isSymbol(ch) || ch == '#') {
                if (strNew != null) {
                    strNew.append(ch);
                }
                ++idx;
                continue;
            }
            int last = CellSet.scanId(str, idx);
            if (last - idx < 2 || !CellRefUtil.isColChar(ch) && ch != '$' || CellRefUtil.isPrevDot(str, idx)) {
                if (strNew != null) {
                    strNew.append(str.substring(idx, last));
                }
                idx = last;
                continue;
            }
            int macroIndex = -1;
            int numIndex = -1;
            for (int i = idx + 1; i < last; ++i) {
                char tmp = str.charAt(i);
                if (tmp == '$') {
                    macroIndex = i;
                    numIndex = i + 1;
                    break;
                }
                if (CellRefUtil.isRowChar(tmp)) {
                    numIndex = i;
                    break;
                }
                if (!CellRefUtil.isColChar(tmp)) break;
            }
            if (numIndex == -1) {
                if (strNew != null) {
                    strNew.append(str.substring(idx, last));
                }
                idx = last;
                continue;
            }
            if (ch == '$') {
                if (macroIndex == -1) {
                    CellLocation lct = CellLocation.parse(str.substring(idx + 1, last));
                    if (lct != null && lct.getRow() == sr && lct.getCol() <= colCount) {
                        if (strNew == null) {
                            strNew = new StringBuffer(64);
                            strNew.append(str.substring(0, idx));
                        }
                        strNew.append(str.substring(idx, numIndex));
                        strNew.append(CellLocation.toRow(tr));
                    } else if (strNew != null) {
                        strNew.append(str.substring(idx, last));
                    }
                } else {
                    col = CellLocation.parseCol(str.substring(idx + 1, macroIndex));
                    row = CellLocation.parseRow(str.substring(numIndex, last));
                    if (col != -1 && row == sr && col <= colCount) {
                        if (strNew == null) {
                            strNew = new StringBuffer(64);
                            strNew.append(str.substring(0, idx));
                        }
                        strNew.append(str.substring(idx, numIndex));
                        strNew.append(CellLocation.toRow(tr));
                    } else if (strNew != null) {
                        strNew.append(str.substring(idx, last));
                    }
                }
            } else if (macroIndex == -1) {
                CellLocation lct = CellLocation.parse(str.substring(idx, last));
                if (lct != null && lct.getRow() == sr && lct.getCol() <= colCount) {
                    if (strNew == null) {
                        strNew = new StringBuffer(64);
                        strNew.append(str.substring(0, idx));
                    }
                    strNew.append(str.substring(idx, numIndex));
                    strNew.append(CellLocation.toRow(tr));
                } else if (strNew != null) {
                    strNew.append(str.substring(idx, last));
                }
            } else {
                col = CellLocation.parseCol(str.substring(idx, macroIndex));
                row = CellLocation.parseRow(str.substring(numIndex, last));
                if (col != -1 && row == sr && col <= colCount) {
                    if (strNew == null) {
                        strNew = new StringBuffer(64);
                        strNew.append(str.substring(0, idx));
                    }
                    strNew.append(str.substring(idx, numIndex));
                    strNew.append(CellLocation.toRow(tr));
                } else if (strNew != null) {
                    strNew.append(str.substring(idx, last));
                }
            }
            idx = last;
        }
        return strNew == null ? str : strNew.toString();
    }

    private String _$1(String str, int[] newSeqs) {
        if (str == null || str.length() == 0 || str.startsWith("#REF!")) {
            return str;
        }
        int rowCount = newSeqs.length;
        int colCount = this.getColCount();
        StringBuffer strNew = null;
        int len = str.length();
        int idx = 0;
        while (idx < len) {
            int c;
            int r;
            char ch = str.charAt(idx);
            if (ch == '\'' || ch == '\"') {
                int tmp = Sentence.scanQuotation(str, idx);
                if (tmp < 0) {
                    if (strNew == null) break;
                    strNew.append(str.substring(idx));
                    break;
                }
                ++tmp;
                if (strNew != null) {
                    strNew.append(str.substring(idx, tmp));
                }
                idx = tmp;
                continue;
            }
            if (KeyWord.isSymbol(ch) || ch == '#') {
                if (strNew != null) {
                    strNew.append(ch);
                }
                ++idx;
                continue;
            }
            int last = CellSet.scanId(str, idx);
            if (last - idx < 2 || !CellRefUtil.isColChar(ch) && ch != '$' || CellRefUtil.isPrevDot(str, idx)) {
                if (strNew != null) {
                    strNew.append(str.substring(idx, last));
                }
                idx = last;
                continue;
            }
            int macroIndex = -1;
            int numIndex = -1;
            for (int i = idx + 1; i < last; ++i) {
                char tmp = str.charAt(i);
                if (tmp == '$') {
                    macroIndex = i;
                    numIndex = i + 1;
                    break;
                }
                if (CellRefUtil.isRowChar(tmp)) {
                    numIndex = i;
                    break;
                }
                if (!CellRefUtil.isColChar(tmp)) break;
            }
            if (numIndex == -1) {
                if (strNew != null) {
                    strNew.append(str.substring(idx, last));
                }
                idx = last;
                continue;
            }
            if (ch == '$') {
                if (macroIndex == -1) {
                    CellLocation lct = CellLocation.parse(str.substring(idx + 1, last));
                    int n = r = lct == null ? 0 : lct.getRow();
                    if (r > 0 && r < rowCount && newSeqs[r] > 0 && lct.getCol() <= colCount) {
                        if (strNew == null) {
                            strNew = new StringBuffer(64);
                            strNew.append(str.substring(0, idx));
                        }
                        strNew.append(str.substring(idx, numIndex));
                        strNew.append(CellLocation.toRow(newSeqs[r]));
                    } else if (strNew != null) {
                        strNew.append(str.substring(idx, last));
                    }
                } else {
                    c = CellLocation.parseCol(str.substring(idx + 1, macroIndex));
                    r = CellLocation.parseRow(str.substring(numIndex, last));
                    if (c != -1 && r > 0 && r < rowCount && newSeqs[r] > 0 && c <= colCount) {
                        if (strNew == null) {
                            strNew = new StringBuffer(64);
                            strNew.append(str.substring(0, idx));
                        }
                        strNew.append(str.substring(idx, numIndex));
                        strNew.append(CellLocation.toRow(newSeqs[r]));
                    } else if (strNew != null) {
                        strNew.append(str.substring(idx, last));
                    }
                }
            } else if (macroIndex == -1) {
                CellLocation lct = CellLocation.parse(str.substring(idx, last));
                int n = r = lct == null ? 0 : lct.getRow();
                if (r > 0 && r < rowCount && newSeqs[r] > 0 && lct.getCol() <= colCount) {
                    if (strNew == null) {
                        strNew = new StringBuffer(64);
                        strNew.append(str.substring(0, idx));
                    }
                    strNew.append(str.substring(idx, numIndex));
                    strNew.append(CellLocation.toRow(newSeqs[r]));
                } else if (strNew != null) {
                    strNew.append(str.substring(idx, last));
                }
            } else {
                c = CellLocation.parseCol(str.substring(idx, macroIndex));
                r = CellLocation.parseRow(str.substring(numIndex, last));
                if (c != -1 && r > 0 && r < rowCount && newSeqs[r] > 0 && c <= colCount) {
                    if (strNew == null) {
                        strNew = new StringBuffer(64);
                        strNew.append(str.substring(0, idx));
                    }
                    strNew.append(str.substring(idx, numIndex));
                    strNew.append(CellLocation.toRow(newSeqs[r]));
                } else if (strNew != null) {
                    strNew.append(str.substring(idx, last));
                }
            }
            idx = last;
        }
        return strNew == null ? str : strNew.toString();
    }

    public void setAdjustExpMode(boolean isAuto) {
        this._$2 = isAuto;
    }

    public boolean getAdjustExpMode() {
        return this._$2;
    }

    protected abstract void setCurrent(INormalCell var1);

    protected abstract void setParseCurrent(int var1, int var2);

    public abstract String getMacroReplaceString(String var1);

    @Override
    public int getRowLevel(int r) {
        return ((RowCell)this.getRowCell(r)).getLevel();
    }

    public void setRowLevel(int r, int level) {
        ((RowCell)this.getRowCell(r)).setLevel(level);
    }

    @Override
    public int getColLevel(int c) {
        return ((ColCell)this.getColCell(c)).getLevel();
    }

    public void setColLevel(int c, int level) {
        ((ColCell)this.getColCell(c)).setLevel(level);
    }

    public List<NormalCell> transpose() {
        int r;
        Matrix newMatrix;
        Matrix cellMatrix = this.cellMatrix;
        int rowSize = cellMatrix.getRowSize();
        int colSize = cellMatrix.getColSize();
        int oldRowCount = rowSize - 1;
        int oldColCount = colSize - 1;
        this.cellMatrix = newMatrix = new Matrix(colSize, rowSize);
        for (r = 1; r < colSize; ++r) {
            ColCell cc = (ColCell)cellMatrix.get(0, r);
            RowCell rc = this.newRowCell(r);
            rc.setLevel(cc.getLevel());
            newMatrix.set(r, 0, rc);
        }
        for (int c = 1; c < rowSize; ++c) {
            RowCell rc = (RowCell)cellMatrix.get(c, 0);
            ColCell cc = this.newColCell(c);
            cc.setLevel(rc.getLevel());
            newMatrix.set(0, c, cc);
        }
        for (r = 1; r < colSize; ++r) {
            for (int c = 1; c < rowSize; ++c) {
                NormalCell cell = (NormalCell)cellMatrix.get(c, r);
                if (cell == null) continue;
                cell.setRow(r);
                cell.setCol(c);
                newMatrix.set(r, c, cell);
            }
        }
        ArrayList<NormalCell> errorCells = new ArrayList<NormalCell>();
        if (this.getAdjustExpMode()) {
            this._$1(errorCells, oldRowCount, oldColCount);
            int size = errorCells.size();
            for (int i = 0; i < size; ++i) {
                NormalCell cell = (NormalCell)errorCells.get(i);
                int r2 = cell.getRow();
                cell.setRow(cell.getCol());
                cell.setCol(r2);
            }
        }
        return errorCells;
    }

    private void _$1(List<NormalCell> errorCells, int oldRowCount, int oldColCount) {
        int rowCount = this.getRowCount();
        int colCount = this.getColCount();
        boolean[] error = new boolean[1];
        for (int row = 1; row <= rowCount; ++row) {
            for (int col = 1; col <= colCount; ++col) {
                ByteMap expMap;
                NormalCell cell = this.getNormalCell(row, col);
                if (cell == null) continue;
                boolean isErrRef = false;
                boolean needRegulateString = cell.needRegulateString();
                String newExpStr = null;
                if (needRegulateString) {
                    newExpStr = this._$1(cell.getExpString(), error, oldRowCount, oldColCount);
                    if (error[0]) {
                        isErrRef = true;
                    }
                }
                if ((expMap = cell.getExpMap(true)) != null) {
                    int size = expMap.size();
                    for (int i = 0; i < size; ++i) {
                        String expStr = (String)expMap.getValue(i);
                        expMap.setValue(i, this._$1(expStr, error, oldRowCount, oldColCount));
                        if (!error[0]) continue;
                        isErrRef = true;
                    }
                }
                if (isErrRef) {
                    errorCells.add((NormalCell)cell.deepClone());
                }
                if (needRegulateString) {
                    cell.setExpString(newExpStr);
                }
                if (expMap == null) continue;
                cell.setExpMap(expMap);
            }
        }
    }

    private String _$1(String str, boolean[] error, int oldRowCount, int oldColCount) {
        error[0] = false;
        if (str == null || str.length() == 0 || str.startsWith("#REF!")) {
            return str;
        }
        StringBuffer strNew = null;
        int len = str.length();
        int idx = 0;
        while (idx < len) {
            int row;
            int col;
            char ch = str.charAt(idx);
            if (ch == '\'' || ch == '\"') {
                int tmp = Sentence.scanQuotation(str, idx);
                if (tmp < 0) {
                    if (strNew == null) break;
                    strNew.append(str.substring(idx));
                    break;
                }
                ++tmp;
                if (strNew != null) {
                    strNew.append(str.substring(idx, tmp));
                }
                idx = tmp;
                continue;
            }
            if (KeyWord.isSymbol(ch) || ch == '#') {
                if (strNew != null) {
                    strNew.append(ch);
                }
                ++idx;
                continue;
            }
            int last = KeyWord.scanId(str, idx);
            if (last - idx < 2 || !CellRefUtil.isColChar(ch) && ch != '$' || CellRefUtil.isPrevDot(str, idx)) {
                if (strNew != null) {
                    strNew.append(str.substring(idx, last));
                }
                idx = last;
                continue;
            }
            int macroIndex = -1;
            int numIndex = -1;
            for (int i = idx + 1; i < last; ++i) {
                char tmp = str.charAt(i);
                if (tmp == '$') {
                    macroIndex = i;
                    numIndex = i + 1;
                    break;
                }
                if (CellRefUtil.isRowChar(tmp)) {
                    numIndex = i;
                    break;
                }
                if (!CellRefUtil.isColChar(tmp)) break;
            }
            if (numIndex == -1) {
                if (strNew != null) {
                    strNew.append(str.substring(idx, last));
                }
                idx = last;
                continue;
            }
            if (ch == '$') {
                if (macroIndex == -1) {
                    CellLocation lct = CellLocation.parse(str.substring(idx + 1, last));
                    if (lct == null || lct.getRow() > oldRowCount || lct.getCol() > oldColCount) {
                        if (strNew != null) {
                            strNew.append(str.substring(idx, last));
                        }
                    } else {
                        if (strNew == null) {
                            strNew = new StringBuffer(64);
                            strNew.append(str.substring(0, idx));
                        }
                        strNew.append('$');
                        strNew.append(CellLocation.toCol(lct.getRow()));
                        strNew.append(CellLocation.toRow(lct.getCol()));
                    }
                } else {
                    col = CellLocation.parseCol(str.substring(idx + 1, macroIndex));
                    row = CellLocation.parseRow(str.substring(numIndex, last));
                    if (col == -1 || row == -1 || row > oldRowCount || col > oldColCount) {
                        if (strNew != null) {
                            strNew.append(str.substring(idx, last));
                        }
                    } else {
                        if (strNew == null) {
                            strNew = new StringBuffer(64);
                            strNew.append(str.substring(0, idx));
                        }
                        strNew.append('$');
                        strNew.append(CellLocation.toCol(row));
                        strNew.append('$');
                        strNew.append(CellLocation.toRow(col));
                    }
                }
            } else if (macroIndex == -1) {
                CellLocation lct = CellLocation.parse(str.substring(idx, last));
                if (lct == null || lct.getRow() > oldRowCount || lct.getCol() > oldColCount) {
                    if (strNew != null) {
                        strNew.append(str.substring(idx, last));
                    }
                } else {
                    if (strNew == null) {
                        strNew = new StringBuffer(64);
                        strNew.append(str.substring(0, idx));
                    }
                    strNew.append(CellLocation.toCol(lct.getRow()));
                    strNew.append(CellLocation.toRow(lct.getCol()));
                }
            } else {
                col = CellLocation.parseCol(str.substring(idx, macroIndex));
                row = CellLocation.parseRow(str.substring(numIndex, last));
                if (col == -1 || row == -1 || row > oldRowCount || col > oldColCount) {
                    if (strNew != null) {
                        strNew.append(str.substring(idx, last));
                    }
                } else {
                    if (strNew == null) {
                        strNew = new StringBuffer(64);
                        strNew.append(str.substring(0, idx));
                    }
                    strNew.append(CellLocation.toCol(row));
                    strNew.append('$');
                    strNew.append(CellLocation.toRow(col));
                }
            }
            idx = last;
        }
        return strNew == null ? str : strNew.toString();
    }

    protected void insertRows(int[] rows, int level) {
        int count = rows.length;
        if (count == 0) {
            return;
        }
        int oldRowCount = this.getRowCount();
        ArrayList<NormalCell> errorCells = new ArrayList<NormalCell>();
        this._$1(rows, true, oldRowCount, errorCells);
        this.cellMatrix.insertRows(rows);
        int colCount = this.getColCount();
        for (int i = 0; i < count; ++i) {
            int r = rows[i] + i;
            this._$2(r, 1);
            this._$1(r, 1, 1, colCount);
            this.setRowLevel(r, level);
        }
        this.adjustRow(rows[0]);
    }

    private void _$1(int[] rows, boolean isInsert, int oldRowCount, List<NormalCell> errorCells) {
        int rowCount = this.getRowCount();
        int colCount = this.getColCount();
        boolean[] error = new boolean[1];
        for (int row = 1; row <= rowCount; ++row) {
            for (int col = 1; col <= colCount; ++col) {
                ByteMap expMap;
                NormalCell cell = this.getNormalCell(row, col);
                if (cell == null) continue;
                boolean isErrRef = false;
                boolean needRegulateString = cell.needRegulateString();
                String newExpStr = null;
                if (needRegulateString) {
                    newExpStr = this._$1(cell.getExpString(), rows, isInsert, oldRowCount, error);
                    if (error[0]) {
                        isErrRef = true;
                    }
                }
                if ((expMap = cell.getExpMap(true)) != null) {
                    int size = expMap.size();
                    for (int i = 0; i < size; ++i) {
                        String expStr = (String)expMap.getValue(i);
                        expMap.setValue(i, this._$1(expStr, rows, isInsert, oldRowCount, error));
                        if (!error[0]) continue;
                        isErrRef = true;
                    }
                }
                if (isErrRef) {
                    errorCells.add((NormalCell)cell.deepClone());
                }
                if (needRegulateString) {
                    cell.setExpString(newExpStr);
                }
                if (expMap == null) continue;
                cell.setExpMap(expMap);
            }
        }
    }

    private String _$1(String str, int[] rows, boolean isInsert, int oldRowCount, boolean[] error) {
        error[0] = false;
        if (str == null || str.length() == 0 || str.startsWith("#REF!")) {
            return str;
        }
        int oldColCount = this.getColCount();
        StringBuffer strNew = null;
        int len = str.length();
        int idx = 0;
        while (idx < len) {
            int c;
            int nr;
            int r;
            char ch = str.charAt(idx);
            if (ch == '\'' || ch == '\"') {
                int tmp = Sentence.scanQuotation(str, idx);
                if (tmp < 0) {
                    if (strNew == null) break;
                    strNew.append(str.substring(idx));
                    break;
                }
                ++tmp;
                if (strNew != null) {
                    strNew.append(str.substring(idx, tmp));
                }
                idx = tmp;
                continue;
            }
            if (KeyWord.isSymbol(ch) || ch == '#') {
                if (strNew != null) {
                    strNew.append(ch);
                }
                ++idx;
                continue;
            }
            int last = CellSet.scanId(str, idx);
            if (last - idx < 2 || !CellRefUtil.isColChar(ch) && ch != '$' || CellRefUtil.isPrevDot(str, idx)) {
                if (strNew != null) {
                    strNew.append(str.substring(idx, last));
                }
                idx = last;
                continue;
            }
            int macroIndex = -1;
            int numIndex = -1;
            for (int i = idx + 1; i < last; ++i) {
                char tmp = str.charAt(i);
                if (tmp == '$') {
                    macroIndex = i;
                    numIndex = i + 1;
                    break;
                }
                if (CellRefUtil.isRowChar(tmp)) {
                    numIndex = i;
                    break;
                }
                if (!CellRefUtil.isColChar(tmp)) break;
            }
            if (numIndex == -1) {
                if (strNew != null) {
                    strNew.append(str.substring(idx, last));
                }
                idx = last;
                continue;
            }
            if (ch == '$') {
                if (macroIndex == -1) {
                    CellLocation lct = CellLocation.parse(str.substring(idx + 1, last));
                    if (lct != null && lct.getRow() <= oldRowCount && lct.getCol() <= oldColCount) {
                        r = lct.getRow();
                        nr = CellRefUtil.adjustRowReference(r, rows, isInsert);
                        if (nr < 0) {
                            error[0] = true;
                            return "#REF!" + str;
                        }
                        if (nr != r) {
                            if (strNew == null) {
                                strNew = new StringBuffer(64);
                                strNew.append(str.substring(0, idx));
                            }
                            strNew.append(str.substring(idx, numIndex));
                            strNew.append(CellLocation.toRow(nr));
                        } else if (strNew != null) {
                            strNew.append(str.substring(idx, last));
                        }
                    } else if (strNew != null) {
                        strNew.append(str.substring(idx, last));
                    }
                } else {
                    c = CellLocation.parseCol(str.substring(idx + 1, macroIndex));
                    r = CellLocation.parseRow(str.substring(numIndex, last));
                    if (c > 0 && r > 0 && c <= oldColCount && r <= oldRowCount) {
                        nr = CellRefUtil.adjustRowReference(r, rows, isInsert);
                        if (nr < 0) {
                            error[0] = true;
                            return "#REF!" + str;
                        }
                        if (nr != r) {
                            if (strNew == null) {
                                strNew = new StringBuffer(64);
                                strNew.append(str.substring(0, idx));
                            }
                            strNew.append(str.substring(idx, numIndex));
                            strNew.append(CellLocation.toRow(nr));
                        } else if (strNew != null) {
                            strNew.append(str.substring(idx, last));
                        }
                    } else if (strNew != null) {
                        strNew.append(str.substring(idx, last));
                    }
                }
            } else if (macroIndex == -1) {
                CellLocation lct = CellLocation.parse(str.substring(idx, last));
                if (lct != null && lct.getRow() <= oldRowCount && lct.getCol() <= oldColCount) {
                    r = lct.getRow();
                    nr = CellRefUtil.adjustRowReference(r, rows, isInsert);
                    if (nr < 0) {
                        error[0] = true;
                        return "#REF!" + str;
                    }
                    if (nr != r) {
                        if (strNew == null) {
                            strNew = new StringBuffer(64);
                            strNew.append(str.substring(0, idx));
                        }
                        strNew.append(str.substring(idx, numIndex));
                        strNew.append(CellLocation.toRow(nr));
                    } else if (strNew != null) {
                        strNew.append(str.substring(idx, last));
                    }
                } else if (strNew != null) {
                    strNew.append(str.substring(idx, last));
                }
            } else {
                c = CellLocation.parseCol(str.substring(idx, macroIndex));
                r = CellLocation.parseRow(str.substring(numIndex, last));
                if (c > 0 && r > 0 && c <= oldColCount && r <= oldRowCount) {
                    nr = CellRefUtil.adjustRowReference(r, rows, isInsert);
                    if (nr < 0) {
                        error[0] = true;
                        return "#REF!" + str;
                    }
                    if (nr != r) {
                        if (strNew == null) {
                            strNew = new StringBuffer(64);
                            strNew.append(str.substring(0, idx));
                        }
                        strNew.append(str.substring(idx, numIndex));
                        strNew.append(CellLocation.toRow(nr));
                    } else if (strNew != null) {
                        strNew.append(str.substring(idx, last));
                    }
                } else if (strNew != null) {
                    strNew.append(str.substring(idx, last));
                }
            }
            idx = last;
        }
        return strNew == null ? str : strNew.toString();
    }

    public static int scanId(String expStr, int start) {
        int len = expStr.length();
        char c = expStr.charAt(start);
        if (c >= '\u0001' && c <= '\u007f') {
            ++start;
        } else {
            return start + 1;
        }
        while (start < len && !KeyWord.isSymbol(c = expStr.charAt(start)) && c >= '\u0001' && c <= '\u007f') {
            ++start;
        }
        return start;
    }
}

