/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.cellset.datamodel;

import com.scudata.cellset.ICellSet;
import com.scudata.cellset.INormalCell;
import com.scudata.cellset.datamodel.SqlCommand;
import com.scudata.common.CellLocation;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.common.Sentence;
import com.scudata.dm.Context;
import com.scudata.dm.KeyWord;
import com.scudata.expression.Expression;
import com.scudata.expression.IParam;
import com.scudata.expression.ParamParser;
import com.scudata.resources.EngineMessage;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Command {
    public static final byte IF = 1;
    public static final byte ELSE = 2;
    public static final byte ELSEIF = 3;
    public static final byte FOR = 4;
    public static final byte CONTINUE = 5;
    public static final byte BREAK = 6;
    public static final byte FUNC = 8;
    public static final byte RETURN = 9;
    public static final byte END = 10;
    public static final byte RESULT = 11;
    public static final byte SQL = 12;
    public static final byte CLEAR = 13;
    public static final byte FORK = 15;
    public static final byte REDUCE = 16;
    public static final byte GOTO = 17;
    public static final byte CHANNEL = 18;
    public static final byte TRY = 19;
    private static final HashMap<String, Byte> _$5 = new HashMap(20);
    private byte _$4;
    private String _$3;
    private CellLocation _$2;
    protected String expStr;
    private IParam _$1;

    public Command(byte type, String lctStr, String expStr) {
        this._$4 = type;
        this.expStr = expStr;
        if (lctStr != null && lctStr.length() != 0) {
            this._$3 = lctStr;
        }
    }

    public byte getType() {
        return this._$4;
    }

    public String getLocation() {
        return this._$3;
    }

    public CellLocation getCellLocation(Context ctx) {
        if (this._$2 != null) {
            return this._$2;
        }
        if (this._$3 != null) {
            this._$2 = CellLocation.parse(this._$3);
            if (this._$2 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(this._$3 + mm.getMessage("cellset.cellNotExist"));
            }
        }
        return this._$2;
    }

    public String getExpression() {
        return this.expStr;
    }

    public IParam getParam(ICellSet cs, Context ctx) {
        if (this._$1 == null && this.expStr != null) {
            this._$1 = ParamParser.parse(this.expStr, cs, ctx, true);
        }
        return this._$1;
    }

    public Expression getExpression(ICellSet cs, Context ctx) {
        IParam sub;
        IParam param = this.getParam(cs, ctx);
        if (param == null) {
            return null;
        }
        if (param.isLeaf()) {
            return param.getLeafExpression();
        }
        for (sub = param.getSub(0); sub != null && !sub.isLeaf(); sub = sub.getSub(0)) {
        }
        return sub == null ? Expression.NULL : sub.getLeafExpression();
    }

    public Expression[] getExpressions(ICellSet cs, Context ctx) {
        IParam param = this.getParam(cs, ctx);
        if (param == null) {
            return new Expression[0];
        }
        if (param.isLeaf()) {
            return new Expression[]{param.getLeafExpression()};
        }
        int size = param.getSubSize();
        Expression[] exps = new Expression[size];
        for (int i = 0; i < size; ++i) {
            IParam sub = param.getSub(i);
            if (sub == null) continue;
            exps[i] = sub.getLeafExpression();
        }
        return exps;
    }

    public static boolean isResultCommand(String cmdStr) {
        return cmdStr.startsWith("result");
    }

    public static boolean isSqlCommand(String cmdStr) {
        return cmdStr != null && cmdStr.length() > 0 && cmdStr.charAt(0) == '$';
    }

    public static boolean isCommand(String cmdStr) {
        String key;
        if (cmdStr == null || cmdStr.length() == 0) {
            return false;
        }
        if (cmdStr.charAt(0) == '$') {
            return true;
        }
        int pos = KeyWord.scanId(cmdStr, 0);
        int atIndex = cmdStr.lastIndexOf(64, pos);
        if (atIndex != -1) {
            pos = atIndex;
        }
        return _$5.get(key = cmdStr.substring(0, pos)) != null;
    }

    public static Command parse(String cmdStr) {
        Byte value;
        if (cmdStr == null || cmdStr.length() == 0) {
            return null;
        }
        if (cmdStr.charAt(0) == '$') {
            return Command._$1(cmdStr);
        }
        int pos = KeyWord.scanId(cmdStr, 0);
        int atIndex = cmdStr.lastIndexOf(64, pos);
        if (atIndex != -1) {
            pos = atIndex;
        }
        if ((value = _$5.get(cmdStr.substring(0, pos))) == null) {
            return null;
        }
        return Command._$1(value, cmdStr.substring(pos));
    }

    private static int _$1(String str, int start) {
        int idx = 0;
        int len = str.length();
        while (idx < len) {
            char ch = str.charAt(idx);
            if (ch == '\'' || ch == '\"') {
                if ((idx = Sentence.scanQuotation(str, idx)) < 0) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("\",'" + mm.getMessage("Expression.illMatched"));
                }
                ++idx;
                continue;
            }
            if (ch == '{') {
                if ((idx = Sentence.scanBrace(str, idx)) < 0) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("{,}" + mm.getMessage("Expression.illMatched"));
                }
                ++idx;
                continue;
            }
            if (ch == '(') {
                if ((idx = Sentence.scanParenthesis(str, idx)) < 0) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("(,)" + mm.getMessage("Expression.illMatched"));
                }
                ++idx;
                continue;
            }
            if (ch == ';') {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    private static Command _$1(String str) {
        String sql;
        int paramPos;
        String opt = null;
        String db = null;
        String param = null;
        int len = str.length();
        int sqlStart = 1;
        while (sqlStart < len) {
            char c = str.charAt(sqlStart);
            if (c == '@') {
                int pos = KeyWord.scanId(str, ++sqlStart);
                opt = str.substring(sqlStart, pos);
                sqlStart = pos;
                continue;
            }
            if (c == '(') {
                int match = Sentence.scanParenthesis(str, sqlStart);
                if (match == -1) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("(,)" + mm.getMessage("Expression.illMatched"));
                }
                db = str.substring(sqlStart + 1, match).trim();
                sqlStart = match + 1;
                break;
            }
            if (!Character.isWhitespace(c)) break;
            ++sqlStart;
        }
        if ((paramPos = Command._$1(str, sqlStart)) == -1) {
            sql = str.substring(sqlStart, len);
        } else {
            sql = str.substring(sqlStart, paramPos);
            param = str.substring(paramPos + 1);
        }
        sql = sql.trim();
        if (sql.length() == 0) {
            sql = null;
        }
        return new SqlCommand(sql, db, opt, param);
    }

    private static Command _$1(byte type, String param) {
        param = param.trim();
        String location = null;
        String exp = null;
        switch (type) {
            case 1: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 18: {
                exp = param;
                break;
            }
            case 5: 
            case 6: 
            case 17: {
                location = param;
                break;
            }
            case 2: {
                if (param.length() <= 0) break;
                if (param.startsWith("if")) {
                    type = (byte)3;
                    exp = param.substring(2).trim();
                    break;
                }
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("engine.unknownSentence"));
            }
            case 16: 
            case 19: {
                if (param.length() <= 0) break;
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("engine.unknownSentence"));
            }
            default: {
                throw new RuntimeException();
            }
        }
        Command command = new Command(type, location, exp);
        return command;
    }

    public void getUsedCells(ICellSet cs, Context ctx, List<INormalCell> resultList) {
        INormalCell cell;
        CellLocation lct;
        IParam param = this.getParam(cs, ctx);
        if (param != null) {
            param.getUsedCells(resultList);
        }
        if ((lct = this.getCellLocation(ctx)) != null && !resultList.contains(cell = cs.getCell(lct.getRow(), lct.getCol()))) {
            resultList.add(cell);
        }
    }

    static {
        _$5.put("if", new Byte(1));
        _$5.put("else", new Byte(2));
        _$5.put("elseif", new Byte(3));
        _$5.put("for", new Byte(4));
        _$5.put("next", new Byte(5));
        _$5.put("break", new Byte(6));
        _$5.put("func", new Byte(8));
        _$5.put("return", new Byte(9));
        _$5.put("end", new Byte(10));
        _$5.put("result", new Byte(11));
        _$5.put("$", new Byte(12));
        _$5.put("clear", new Byte(13));
        _$5.put("fork", new Byte(15));
        _$5.put("reduce", new Byte(16));
        _$5.put("goto", new Byte(17));
        _$5.put("cursor", new Byte(18));
        _$5.put("try", new Byte(19));
    }
}

