/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.cellset.datamodel;

import com.scudata.cellset.ICellSet;
import com.scudata.cellset.INormalCell;
import com.scudata.cellset.datamodel.CellSet;
import com.scudata.common.ByteArrayInputRecord;
import com.scudata.common.ByteArrayOutputRecord;
import com.scudata.common.ByteMap;
import com.scudata.common.CellLocation;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class NormalCell
implements INormalCell {
    private static final long serialVersionUID = 33619988L;
    public static final int TYPE_CALCULABLE_CELL = 1;
    public static final int TYPE_CALCULABLE_BLOCK = 2;
    public static final int TYPE_EXECUTABLE_CELL = 4;
    public static final int TYPE_EXECUTABLE_BLOCK = 8;
    public static final int TYPE_COMMAND_CELL = 16;
    public static final int TYPE_CONST_CELL = 32;
    public static final int TYPE_NOTE_CELL = 64;
    public static final int TYPE_NOTE_BLOCK = 128;
    public static final int TYPE_BLANK_CELL = 256;
    protected CellSet cs;
    protected int row;
    protected int col;
    protected String expStr;
    protected String tip;
    protected Object value;

    public NormalCell() {
    }

    public NormalCell(CellSet cs, int r, int c) {
        this.row = r;
        this.col = c;
        this.cs = cs;
    }

    public int getRow() {
        return this.row;
    }

    public int getCol() {
        return this.col;
    }

    public void setRow(int r) {
        this.row = r;
    }

    public void setCol(int c) {
        this.col = c;
    }

    public void setCellSet(ICellSet cs) {
        this.cs = (CellSet)cs;
    }

    public ICellSet getCellSet() {
        return this.cs;
    }

    public String getCellId() {
        return CellLocation.getCellId(this.row, this.col);
    }

    public void setExpString(String exp) {
        this.expStr = exp;
    }

    public String getExpString() {
        return this.expStr;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public abstract Object getValue(boolean var1);

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(2);
        out.writeObject(this.cs);
        out.writeInt(this.row);
        out.writeInt(this.col);
        out.writeObject(this.expStr);
        out.writeObject(this.tip);
        out.writeObject(this.value);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        this.cs = (CellSet)in.readObject();
        this.row = in.readInt();
        this.col = in.readInt();
        this.setExpString((String)in.readObject());
        this.tip = (String)in.readObject();
        this.value = in.readObject();
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputRecord out = new ByteArrayOutputRecord();
        out.writeInt(this.row);
        out.writeInt(this.col);
        out.writeString(this.expStr);
        out.writeString(this.tip);
        return out.toByteArray();
    }

    public void fillRecord(byte[] buf) throws IOException, ClassNotFoundException {
        ByteArrayInputRecord in = new ByteArrayInputRecord(buf);
        this.row = in.readInt();
        this.col = in.readInt();
        this.setExpString(in.readString());
        this.tip = in.readString();
    }

    public abstract void calculate();

    public abstract void reset();

    public abstract int getType();

    public abstract boolean isCalculableBlock();

    public abstract boolean isCalculableCell();

    protected abstract boolean needRegulateString();

    public void undoErrorRef() {
        this.cs.setCell(this.row, this.col, this);
    }

    protected ByteMap getExpMap(boolean isClone) {
        return null;
    }

    protected void setExpMap(ByteMap map) {
    }

    public void setTip(String tip) {
        this.tip = tip;
    }

    public String getTip() {
        return this.tip;
    }
}

