/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.cellset.datamodel;

import com.scudata.cellset.ICellSet;
import com.scudata.cellset.IColCell;
import com.scudata.cellset.INormalCell;
import com.scudata.cellset.IRowCell;
import com.scudata.cellset.datamodel.CellSet;
import com.scudata.cellset.datamodel.ColCell;
import com.scudata.cellset.datamodel.Command;
import com.scudata.cellset.datamodel.IIIIIlIllIIIIIll;
import com.scudata.cellset.datamodel.IIllIlIIIIllIllI;
import com.scudata.cellset.datamodel.IlIIlIlIIlIllIIl;
import com.scudata.cellset.datamodel.NormalCell;
import com.scudata.cellset.datamodel.PgmNormalCell;
import com.scudata.cellset.datamodel.RowCell;
import com.scudata.cellset.datamodel.SqlCommand;
import com.scudata.cellset.datamodel.lIIIIlIIlllllllI;
import com.scudata.cellset.datamodel.lIlllllIIIIIIIlI;
import com.scudata.cellset.datamodel.llIlIIlIlIIlIIII;
import com.scudata.cellset.datamodel.llIlllIIIllIIllI;
import com.scudata.cellset.datamodel.llIlllIlIIllllll;
import com.scudata.cellset.datamodel.lllIlllIlIlIIlII;
import com.scudata.cellset.datamodel.llllIlIlIIlIIIlI;
import com.scudata.common.ByteArrayInputRecord;
import com.scudata.common.ByteArrayOutputRecord;
import com.scudata.common.ByteMap;
import com.scudata.common.CellLocation;
import com.scudata.common.DBSession;
import com.scudata.common.Logger;
import com.scudata.common.MD5;
import com.scudata.common.Matrix;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.DBObject;
import com.scudata.dm.FileObject;
import com.scudata.dm.IQueryable;
import com.scudata.dm.JobSpace;
import com.scudata.dm.KeyWord;
import com.scudata.dm.Machines;
import com.scudata.dm.ParallelCaller;
import com.scudata.dm.Param;
import com.scudata.dm.ParamList;
import com.scudata.dm.RetryException;
import com.scudata.dm.Sequence;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.cursor.MultipathCursors;
import com.scudata.dm.op.Channel;
import com.scudata.expression.Expression;
import com.scudata.expression.IParam;
import com.scudata.expression.ParamInfo2;
import com.scudata.expression.ParamParser;
import com.scudata.resources.EngineMessage;
import com.scudata.thread.CursorLooper;
import com.scudata.thread.ThreadPool;
import com.scudata.util.Variant;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PgmCellSet
extends CellSet {
    private static final long serialVersionUID = 0x2010010L;
    public static final int PRIVILEGE_FULL = 0;
    public static final int PRIVILEGE_EXEC = 1;
    private static final int _$22 = 16;
    private static final int _$21 = 16;
    private int _$20 = 0;
    private ByteMap _$19;
    private String _$18;
    private int _$17 = 1;
    private transient int _$16 = 0;
    protected transient CellLocation curLct;
    private transient Object _$15;
    private transient LinkedList<llIlllIIIllIIllI> _$14 = new LinkedList();
    private transient CellLocation _$13;
    private transient Sequence _$12;
    private transient int _$11;
    private transient CellLocation _$10;
    private transient boolean _$9;
    private transient boolean _$8;
    private transient boolean _$7 = false;
    private transient String _$6;
    private transient HashMap<String, FuncInfo> _$5;
    private transient lIIIIlIIlllllllI _$4;
    private String _$3;

    public PgmCellSet() {
    }

    public PgmCellSet(int row, int col) {
        super(row, col);
    }

    @Override
    public NormalCell newCell(int r, int c) {
        return new PgmNormalCell(this, r, c);
    }

    @Override
    public RowCell newRowCell(int r) {
        return new RowCell(r);
    }

    @Override
    public ColCell newColCell(int c) {
        return new ColCell(c);
    }

    public PgmNormalCell getPgmNormalCell(int row, int col) {
        return (PgmNormalCell)this.cellMatrix.get(row, col);
    }

    @Override
    public INormalCell getCurrent() {
        return this.curLct == null ? null : this.getNormalCell(this.curLct.getRow(), this.curLct.getCol());
    }

    @Override
    public void setCurrent(INormalCell cell) {
        if (cell == null) {
            this.curLct = null;
        } else if (this.curLct == null) {
            this.curLct = new CellLocation(cell.getRow(), cell.getCol());
        } else {
            this.curLct.set(cell.getRow(), cell.getCol());
        }
    }

    public PgmCellSet newCalc() {
        Context ctx = this.getContext();
        return this.newCalc(ctx);
    }

    public PgmCellSet newCalc(Context ctx) {
        Matrix m2;
        Matrix m1 = this.cellMatrix;
        int colSize = this.cellMatrix.getColSize();
        int rowSize = this.cellMatrix.getRowSize();
        PgmCellSet pcs = new PgmCellSet();
        pcs.cellMatrix = m2 = new Matrix(rowSize, colSize);
        for (int r = 0; r < rowSize; ++r) {
            for (int c = 0; c < colSize; ++c) {
                m2.set(r, c, m1.get(r, c));
            }
        }
        pcs._$20 = this._$20;
        pcs._$18 = this._$18;
        pcs._$17 = this._$17;
        ctx = ctx.newComputeContext();
        ctx.setParent(null);
        pcs.setContext(ctx);
        pcs._$6 = this._$6;
        return pcs;
    }

    public PgmCellSet newCursorDFX(INormalCell cell, Object[] args) {
        Object val;
        int c;
        int r;
        int rowCount = this.getRowCount();
        int colCount = this.getColCount();
        PgmCellSet newPcs = new PgmCellSet(rowCount, colCount);
        int row = cell.getRow();
        int col = cell.getCol();
        int endRow = this.getCodeBlockEndRow(row, col);
        for (r = 1; r < row; ++r) {
            for (c = 1; c <= colCount; ++c) {
                val = this.getPgmNormalCell(r, c).getValue();
                newPcs.getPgmNormalCell(r, c).setValue(val);
            }
        }
        for (r = endRow + 1; r <= rowCount; ++r) {
            for (c = 1; c <= colCount; ++c) {
                val = this.getPgmNormalCell(r, c).getValue();
                newPcs.getPgmNormalCell(r, c).setValue(val);
            }
        }
        for (r = row; r <= endRow; ++r) {
            for (c = 1; c < col; ++c) {
                val = this.getPgmNormalCell(r, c).getValue();
                newPcs.getPgmNormalCell(r, c).setValue(val);
            }
            for (c = col; c <= colCount; ++c) {
                INormalCell tmp = this.getCell(r, c);
                INormalCell cellClone = (INormalCell)tmp.deepClone();
                cellClone.setCellSet(newPcs);
                newPcs.setCell(r, c, cellClone);
            }
        }
        if (args != null) {
            int paramRow = row;
            int paramCol = col;
            int pcount = args.length;
            for (int i = 0; i < pcount; ++i) {
                newPcs.getPgmNormalCell(paramRow, paramCol).setValue(args[i]);
                if (paramCol >= colCount) break;
                ++paramCol;
            }
        }
        newPcs.setContext(this.getContext());
        newPcs.setCurrent(cell);
        newPcs.setNext(row, col + 1, false);
        newPcs._$6 = this._$6;
        return newPcs;
    }

    public PgmCellSet newCursorDFX(FuncInfo fi, Object[] args) {
        Object val;
        int c;
        int r;
        int rowCount = this.getRowCount();
        int colCount = this.getColCount();
        PgmCellSet newPcs = new PgmCellSet(rowCount, colCount);
        PgmNormalCell cell = fi.getCell();
        int row = cell.getRow();
        int col = cell.getCol();
        int endRow = this.getCodeBlockEndRow(row, col);
        for (r = 1; r < row; ++r) {
            for (c = 1; c <= colCount; ++c) {
                val = this.getPgmNormalCell(r, c).getValue();
                newPcs.getPgmNormalCell(r, c).setValue(val);
            }
        }
        for (r = endRow + 1; r <= rowCount; ++r) {
            for (c = 1; c <= colCount; ++c) {
                val = this.getPgmNormalCell(r, c).getValue();
                newPcs.getPgmNormalCell(r, c).setValue(val);
            }
        }
        for (r = row; r <= endRow; ++r) {
            for (c = 1; c < col; ++c) {
                val = this.getPgmNormalCell(r, c).getValue();
                newPcs.getPgmNormalCell(r, c).setValue(val);
            }
            for (c = col; c <= colCount; ++c) {
                INormalCell tmp = this.getCell(r, c);
                INormalCell cellClone = (INormalCell)tmp.deepClone();
                cellClone.setCellSet(newPcs);
                newPcs.setCell(r, c, cellClone);
            }
        }
        Context ctx = this.getContext().newComputeContext();
        if (args != null) {
            if (fi.getArgNames() != null) {
                String[] argNames = fi.getArgNames();
                int argCount = argNames.length;
                if (args == null || args.length != argCount) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(fi.getFnName() + mm.getMessage("function.paramCountNotMatch"));
                }
                for (int i = 0; i < argCount; ++i) {
                    ctx.setParamValue(argNames[i], args[i]);
                }
            } else {
                int paramRow = row;
                int paramCol = col;
                int pcount = args.length;
                for (int i = 0; i < pcount; ++i) {
                    newPcs.getPgmNormalCell(paramRow, paramCol).setValue(args[i]);
                    if (paramCol < colCount) {
                        ++paramCol;
                        continue;
                    }
                    break;
                }
            }
        }
        newPcs.setContext(ctx);
        newPcs.setCurrent(cell);
        newPcs.setNext(row, col + 1, false);
        newPcs._$6 = this._$6;
        return newPcs;
    }

    @Override
    public Object deepClone() {
        int col;
        PgmCellSet pcs = new PgmCellSet();
        int colSize = this.cellMatrix.getColSize();
        int rowSize = this.cellMatrix.getRowSize();
        pcs.cellMatrix = new Matrix(rowSize, colSize);
        for (col = 1; col < colSize; ++col) {
            for (int row = 1; row < rowSize; ++row) {
                INormalCell cell = this.getCell(row, col);
                INormalCell cellClone = (INormalCell)cell.deepClone();
                cellClone.setCellSet(pcs);
                pcs.cellMatrix.set(row, col, cellClone);
            }
        }
        for (col = 1; col < colSize; ++col) {
            pcs.cellMatrix.set(0, col, this.getColCell(col).deepClone());
        }
        for (int row = 1; row < rowSize; ++row) {
            pcs.cellMatrix.set(row, 0, this.getRowCell(row).deepClone());
        }
        ParamList param = this.getParamList();
        if (param != null) {
            pcs.setParamList((ParamList)param.deepClone());
        }
        pcs._$20 = this._$20;
        if (this._$19 != null) {
            pcs._$19 = (ByteMap)this._$19.deepClone();
        }
        pcs._$18 = this._$18;
        pcs._$17 = this._$17;
        pcs._$6 = this._$6;
        return pcs;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeByte(2);
        out.writeInt(this._$20);
        out.writeObject(this._$19);
        out.writeObject(this._$18);
        out.writeInt(this._$17);
        out.writeObject(this._$6);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        byte v = in.readByte();
        this._$20 = in.readInt();
        this._$19 = (ByteMap)in.readObject();
        this._$18 = (String)in.readObject();
        this._$17 = in.readInt();
        if (v > 1) {
            this._$6 = (String)in.readObject();
        }
    }

    @Override
    public byte[] serialize() throws IOException {
        int row;
        ByteArrayOutputRecord out = new ByteArrayOutputRecord();
        int rowCount = this.getRowCount();
        int colCount = this.getColCount();
        out.writeInt(rowCount);
        out.writeInt(colCount);
        for (row = 1; row <= rowCount; ++row) {
            IRowCell rc = this.getRowCell(row);
            out.writeRecord(rc);
        }
        for (int col = 1; col <= colCount; ++col) {
            IColCell cc = this.getColCell(col);
            out.writeRecord(cc);
        }
        for (row = 1; row <= rowCount; ++row) {
            for (int col = 1; col <= colCount; ++col) {
                INormalCell nc = this.getCell(row, col);
                out.writeRecord(nc);
            }
        }
        out.writeRecord(this.paramList);
        out.writeInt(this._$20);
        out.writeRecord(this._$19);
        out.writeStrings(null);
        out.writeInt(0);
        out.writeString(this._$18);
        out.writeInt(this._$17);
        this._$3 = null;
        out.writeString(this._$3);
        return out.toByteArray();
    }

    @Override
    public void fillRecord(byte[] buf) throws IOException, ClassNotFoundException {
        int row;
        ByteArrayInputRecord in = new ByteArrayInputRecord(buf);
        int rowCount = in.readInt();
        int colCount = in.readInt();
        this.cellMatrix = new Matrix(rowCount + 1, colCount + 1);
        for (row = 1; row <= rowCount; ++row) {
            RowCell rc = (RowCell)in.readRecord(this.newRowCell(row));
            this.cellMatrix.set(row, 0, rc);
        }
        for (int col = 1; col <= colCount; ++col) {
            ColCell cc = (ColCell)in.readRecord(this.newColCell(col));
            this.cellMatrix.set(0, col, cc);
        }
        for (row = 1; row <= rowCount; ++row) {
            for (int col = 1; col <= colCount; ++col) {
                NormalCell nc = (NormalCell)in.readRecord(this.newCell(row, col));
                this.cellMatrix.set(row, col, nc);
            }
        }
        this.paramList = (ParamList)in.readRecord(new ParamList());
        this._$20 = in.readInt();
        this._$19 = (ByteMap)in.readRecord(new ByteMap());
        if (in.available() > 0) {
            in.readStrings();
            if (in.available() > 0) {
                in.readInt();
                if (in.available() > 0) {
                    this._$18 = in.readString();
                    this._$17 = in.readInt();
                    if (in.available() > 0) {
                        this._$3 = in.readString();
                    }
                }
            }
        }
    }

    private void _$4() {
        int curRow = this.curLct.getRow();
        int curCol = this.curLct.getCol();
        int endBlock = this.getCodeBlockEndRow(curRow, curCol);
        this.setNext(endBlock + 1, 1, true);
    }

    private void _$3() {
        Command command;
        int curRow = this.curLct.getRow();
        int curCol = this.curLct.getCol();
        int totalCol = this.getColCount();
        int level = 0;
        for (int c = curCol + 1; c <= totalCol; ++c) {
            PgmNormalCell cell = this.getPgmNormalCell(curRow, c);
            command = cell.getCommand();
            if (command == null) continue;
            byte type = command.getType();
            if (type == 2) {
                if (level == 0) {
                    this.setNext(curRow, c + 1, false);
                    return;
                }
                --level;
                continue;
            }
            if (type == 3) {
                if (level != 0) continue;
                this.setNext(curRow, c, false);
                this._$3(cell, command);
                return;
            }
            if (type != 1) continue;
            ++level;
        }
        int endBlock = this.getCodeBlockEndRow(curRow, curCol);
        int nextRow = endBlock + 1;
        if (nextRow <= this.getRowCount()) {
            for (int c = 1; c <= totalCol; ++c) {
                PgmNormalCell cell = this.getPgmNormalCell(nextRow, c);
                if (cell.isBlankCell()) continue;
                if (c != curCol) {
                    this.setNext(nextRow, c, true);
                } else {
                    command = cell.getCommand();
                    if (command == null) {
                        this.setNext(nextRow, c, true);
                    } else {
                        byte type = command.getType();
                        if (type == 2) {
                            this.setNext(nextRow, c + 1, false);
                        } else if (type == 3) {
                            this.setNext(nextRow, c, false);
                            this._$3(cell, command);
                        } else {
                            this.setNext(nextRow, c, true);
                        }
                    }
                }
                return;
            }
        } else {
            this.setNext(nextRow, 1, true);
        }
    }

    private int _$3(int prow, int pcol) {
        int totalRow;
        Command command;
        int level = 0;
        int totalCol = this.getColCount();
        for (int c = pcol + 1; c <= totalCol; ++c) {
            PgmNormalCell cell = this.getPgmNormalCell(prow, c);
            command = cell.getCommand();
            if (command == null) continue;
            byte type = command.getType();
            if (type == 2) {
                if (level == 0) {
                    return prow;
                }
                --level;
                continue;
            }
            if (type == 3) {
                if (level != 0) continue;
                return prow;
            }
            if (type != 1) continue;
            ++level;
        }
        int endBlock = this.getCodeBlockEndRow(prow, pcol);
        if (endBlock < (totalRow = this.getRowCount())) {
            int nextRow = endBlock + 1;
            for (int c = 1; c <= totalCol; ++c) {
                PgmNormalCell cell = this.getPgmNormalCell(nextRow, c);
                if (cell.isBlankCell()) continue;
                command = cell.getCommand();
                if (command == null) {
                    return endBlock;
                }
                byte type = command.getType();
                if (type == 2) {
                    return this.getCodeBlockEndRow(nextRow, c);
                }
                if (type == 3) {
                    return this._$3(nextRow, c);
                }
                return endBlock;
            }
            throw new RuntimeException();
        }
        return endBlock;
    }

    private void _$3(NormalCell cell, Command command) {
        Context ctx = this.getContext();
        Expression exp = command.getExpression(this, ctx);
        if (exp == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("if" + mm.getMessage("function.invalidParam"));
        }
        Object value = exp.calculate(ctx);
        cell.setValue(value);
        if (Variant.isTrue(value)) {
            this.setNext(this.curLct.getRow(), this.curLct.getCol() + 1, false);
        } else {
            this._$3();
        }
    }

    public int getForCellRepeatSeq(int r, int c) {
        for (int i = 0; i < this._$14.size(); ++i) {
            llIlllIIIllIIllI cmd = this._$14.get(i);
            if (cmd.row != r || cmd.col != c) continue;
            if (cmd.type != 4) break;
            return ((llIlIIlIlIIlIIII)cmd).getSeq();
        }
        if (this._$4 != null && this._$4.row == r && this._$4.col == c) {
            return this._$4.seq;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("#" + CellLocation.getCellId(r, c) + mm.getMessage("engine.needInFor"));
    }

    /*
     * Enabled aggressive block sorting
     */
    private void _$2(NormalCell cell, Command command) {
        llIlIIlIlIIlIIII cmdCode;
        llIlllIIIllIIllI cmd;
        int row = this.curLct.getRow();
        int col = this.curLct.getCol();
        if (this._$14.size() > 0 && (cmd = this._$14.getFirst()) != null && cmd.row == row && cmd.col == col) {
            llIlIIlIlIIlIIII forCmd = (llIlIIlIlIIlIIII)cmd;
            if (forCmd.hasNextValue()) {
                cell.setValue(forCmd.nextValue());
                this.setNext(row, col + 1, false);
                return;
            }
            cell.setValue(forCmd.endValue());
            this._$14.removeFirst();
            this._$1(forCmd);
            this.setNext(cmd.blockEndRow + 1, 1, true);
            return;
        }
        Context ctx = this.getContext();
        int endRow = this.getCodeBlockEndRow(row, col);
        Expression exp = command.getExpression(this, ctx);
        if (exp == null) {
            cmdCode = new IIllIlIIIIllIllI(row, col, endRow);
        } else {
            Object value = exp.calculate(ctx);
            if (value instanceof Number) {
                IParam param = command.getParam(this, ctx);
                if (param.isLeaf()) {
                    cmdCode = new llllIlIlIIlIIIlI(row, col, endRow, 1, ((Number)value).intValue(), 1);
                } else {
                    int step;
                    int size = param.getSubSize();
                    if (size > 3) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("for" + mm.getMessage("function.invalidParam"));
                    }
                    IParam sub = param.getSub(1);
                    if (sub == null) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("for" + mm.getMessage("function.invalidParam"));
                    }
                    Object obj = sub.getLeafExpression().calculate(ctx);
                    if (!(obj instanceof Number)) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(mm.getMessage("engine.forVarTypeError"));
                    }
                    int start = ((Number)value).intValue();
                    int end = ((Number)obj).intValue();
                    if (size > 2) {
                        sub = param.getSub(2);
                        if (sub == null) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException("for" + mm.getMessage("function.invalidParam"));
                        }
                        obj = sub.getLeafExpression().calculate(ctx);
                        if (!(obj instanceof Number)) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException(mm.getMessage("engine.forVarTypeError"));
                        }
                        step = ((Number)obj).intValue();
                    } else {
                        step = start <= end ? 1 : -1;
                    }
                    cmdCode = new llllIlIlIIlIIIlI(row, col, endRow, start, end, step);
                }
            } else if (value instanceof Sequence) {
                cmdCode = new IIIIIlIllIIIIIll(row, col, endRow, (Sequence)value, ctx);
            } else {
                if (value instanceof Boolean) {
                    cell.setValue(value);
                    if (((Boolean)value).booleanValue()) {
                        cmdCode = new lIlllllIIIIIIIlI(row, col, endRow, exp, ctx);
                        cmdCode.setSeq(1);
                        this._$14.addFirst(cmdCode);
                        this.setNext(row, col + 1, false);
                        return;
                    }
                    this.setNext(endRow + 1, 1, true);
                    return;
                }
                if (value instanceof ICursor) {
                    IParam param = command.getParam(this, ctx);
                    int count = ICursor.FETCHCOUNT;
                    Expression gexp = null;
                    if (param.getType() == ';') {
                        if (param.getSubSize() != 2) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException("for" + mm.getMessage("function.invalidParam"));
                        }
                        IParam sub = param.getSub(1);
                        if (sub == null) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException("for" + mm.getMessage("function.invalidParam"));
                        }
                        if (!sub.isLeaf()) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException("for" + mm.getMessage("function.invalidParam"));
                        }
                        gexp = sub.getLeafExpression();
                    } else if (!param.isLeaf()) {
                        if (param.getSubSize() != 2) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException("for" + mm.getMessage("function.invalidParam"));
                        }
                        IParam sub = param.getSub(1);
                        if (sub != null) {
                            Object countObj = sub.getLeafExpression().calculate(ctx);
                            if (!(countObj instanceof Number)) {
                                MessageManager mm = EngineMessage.get();
                                throw new RQException(mm.getMessage("engine.forVarTypeError"));
                            }
                            count = ((Number)countObj).intValue();
                            if (count < 1) {
                                MessageManager mm = EngineMessage.get();
                                throw new RQException("for" + mm.getMessage("function.invalidParam"));
                            }
                        }
                    }
                    cmdCode = new lllIlllIlIlIIlII(row, col, endRow, (ICursor)value, count, gexp, ctx);
                } else {
                    if (value != null) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(mm.getMessage("engine.forVarTypeError"));
                    }
                    cmdCode = null;
                }
            }
        }
        if (cmdCode != null && cmdCode.hasNextValue()) {
            cell.setValue(cmdCode.nextValue());
            this._$14.addFirst(cmdCode);
            this.setNext(row, col + 1, false);
            return;
        }
        this.setNext(endRow + 1, 1, true);
    }

    private void _$6(Command command) {
        int i;
        CellLocation forLct = command.getCellLocation(this.getContext());
        int index = -1;
        int size = this._$14.size();
        for (i = 0; i < size; ++i) {
            llIlllIIIllIIllI cmd = this._$14.get(i);
            if (cmd.type != 4 || forLct != null && (forLct.getRow() != cmd.row || forLct.getCol() != cmd.col)) continue;
            index = i;
            break;
        }
        if (index == -1) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("next" + mm.getMessage("engine.needInFor"));
        }
        for (i = 0; i < index; ++i) {
            llIlllIIIllIIllI cmd = this._$14.removeFirst();
            if (cmd.type != 4) continue;
            this._$1((llIlIIlIlIIlIIII)cmd);
        }
        llIlllIIIllIIllI cmd = this._$14.getFirst();
        this.setNext(cmd.row, cmd.col, false);
    }

    private void _$5(Command command) {
        int i;
        CellLocation forLct = command.getCellLocation(this.getContext());
        int index = -1;
        int size = this._$14.size();
        for (i = 0; i < size; ++i) {
            llIlllIIIllIIllI cmd = this._$14.get(i);
            if (cmd.type != 4 || forLct != null && (forLct.getRow() != cmd.row || forLct.getCol() != cmd.col)) continue;
            index = i;
            break;
        }
        if (index == -1) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("break" + mm.getMessage("engine.needInFor"));
        }
        for (i = 0; i < index; ++i) {
            llIlllIIIllIIllI cmd = this._$14.removeFirst();
            if (cmd.type != 4) continue;
            this._$1((llIlIIlIlIIlIIII)cmd);
        }
        llIlllIIIllIIllI cmd = this._$14.removeFirst();
        this._$1((llIlIIlIlIIlIIII)cmd);
        this.setNext(cmd.blockEndRow + 1, 1, true);
    }

    private void _$4(Command command) {
        int i;
        CellLocation lct = command.getCellLocation(this.getContext());
        if (lct == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(command.getLocation() + mm.getMessage("cellset.cellNotExist"));
        }
        int r = lct.getRow();
        int c = lct.getCol();
        int index = -1;
        int size = this._$14.size();
        for (i = 0; i < size; ++i) {
            llIlllIIIllIIllI cmd = this._$14.get(i);
            if (r > cmd.blockEndRow || r < cmd.row) {
                index = i;
                continue;
            }
            if (c > cmd.col) break;
            if (r == cmd.row) {
                index = i;
                continue;
            }
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("cellset.invalidGotoCell"));
        }
        for (i = 0; i <= index; ++i) {
            llIlllIIIllIIllI cmd = this._$14.removeFirst();
            if (cmd.type != 4) continue;
            this._$1((llIlIIlIlIIlIIII)cmd);
        }
        this.setNext(r, c, false);
    }

    private void _$1(llIlIIlIlIIlIIII cmd) {
        cmd.close();
    }

    private PgmCellSet _$1(int row, int col, int endRow, Context ctx, boolean isLocal) {
        int rowCount = this.getRowCount();
        int colCount = this.getColCount();
        PgmCellSet pcs = new PgmCellSet(rowCount, colCount);
        if (isLocal) {
            for (int r = 1; r <= rowCount; ++r) {
                for (int c = 1; c <= colCount; ++c) {
                    PgmNormalCell cell = this.getPgmNormalCell(r, c);
                    PgmNormalCell newCell = pcs.getPgmNormalCell(r, c);
                    newCell.setExpString(cell.getExpString());
                    newCell.setValue(cell.getValue());
                }
            }
            pcs.setContext(ctx.newComputeContext());
        } else {
            ParamList usedParams = new ParamList();
            ArrayList<INormalCell> usedCells = new ArrayList<INormalCell>();
            for (int r = row; r <= endRow; ++r) {
                for (int c = col + 1; c <= colCount; ++c) {
                    PgmNormalCell cell = this.getPgmNormalCell(r, c);
                    cell.getUsedParamsAndCells(usedParams, usedCells);
                    PgmNormalCell newCell = pcs.getPgmNormalCell(r, c);
                    newCell.setExpString(cell.getExpString());
                }
            }
            pcs.setParamList(usedParams);
            for (INormalCell cell : usedCells) {
                int r = cell.getRow();
                int c = cell.getCol();
                if (r >= row && r <= endRow && c >= col) continue;
                pcs.getPgmNormalCell(r, c).setValue(cell.getValue());
            }
        }
        pcs._$6 = this._$6;
        return pcs;
    }

    private void _$1(int row, int col, int endRow) {
        this.curLct = new CellLocation(row, col);
        this.setNext(row, col + 1, false);
        CellLocation lct = this.curLct;
        if (lct == null || lct.getRow() > endRow) {
            return;
        }
        while ((lct = this._$1()) != null && lct.getRow() <= endRow && this._$12 == null) {
        }
        if (this._$12 == null) {
            int colCount = this.getColCount();
            for (int r = endRow; r >= row; --r) {
                for (int c = colCount; c > col; --c) {
                    PgmNormalCell cell = this.getPgmNormalCell(r, c);
                    if (!cell.isCalculableCell() && !cell.isCalculableBlock()) continue;
                    Object val = cell.getValue();
                    this._$12 = new Sequence(1);
                    this._$12.add(val);
                    return;
                }
            }
        }
    }

    private Object _$2() {
        if (this._$12 != null) {
            if (this._$12.length() == 0) {
                return null;
            }
            if (this._$12.length() == 1) {
                return this._$12.get(1);
            }
            return this._$12;
        }
        return null;
    }

    private boolean _$1(int prevEndRow, int col, byte cmdType) {
        int totalRowCount = this.getRowCount();
        if (prevEndRow == totalRowCount) {
            return false;
        }
        int nextRow = prevEndRow + 1;
        PgmNormalCell cell = this.getPgmNormalCell(nextRow, col);
        Command nextCommand = cell.getCommand();
        if (nextCommand == null || nextCommand.getType() != cmdType) {
            return false;
        }
        for (int c = 1; c < col; ++c) {
            cell = this.getPgmNormalCell(nextRow, c);
            if (cell.isBlankCell()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _$2(Command command, Context ctx) {
        int row = this.curLct.getRow();
        int col = this.curLct.getCol();
        int endRow = this.getCodeBlockEndRow(row, col);
        IParam param = command.getParam(this, ctx);
        if (!this._$1(endRow, col, (byte)15)) {
            this._$1(param, row, col, endRow, ctx);
        } else {
            ArrayList<llIlllIlIIllllll> list = new ArrayList<llIlllIlIIllllll>();
            while (true) {
                llIlllIlIIllllll job = new llIlllIlIIllllll(this, param, row, col, endRow, ctx);
                list.add(job);
                if (!this._$1(endRow, col, (byte)15)) break;
                row = endRow + 1;
                endRow = this.getCodeBlockEndRow(row, col);
                PgmNormalCell cell = this.getPgmNormalCell(row, col);
                command = cell.getCommand();
                param = command.getParam(this, ctx);
            }
            ThreadPool pool = ThreadPool.newInstance(list.size());
            try {
                for (llIlllIlIIllllll job : list) {
                    pool.submit(job);
                }
                for (llIlllIlIIllllll job : list) {
                    job.join();
                }
            }
            finally {
                pool.shutdown();
            }
        }
        this.setNext(endRow + 1, 1, true);
    }

    private void _$2(IParam param, int row, int col, int endRow, Context ctx) {
        JobSpace js;
        Command command;
        if (param.getSubSize() != 2) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("fork" + mm.getMessage("function.invalidParam"));
        }
        IParam leftParam = param.getSub(0);
        IParam rightParam = param.getSub(1);
        if (rightParam == null || !rightParam.isLeaf()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("fork" + mm.getMessage("function.invalidParam"));
        }
        Machines mc = new Machines();
        Object hostObj = rightParam.getLeafExpression().calculate(ctx);
        if (!mc.set(hostObj)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("callx" + mm.getMessage("function.invalidParam"));
        }
        String[] hosts = mc.getHosts();
        int[] ports = mc.getPorts();
        int mcount = -1;
        Object[] args = null;
        if (leftParam != null) {
            if (leftParam.isLeaf()) {
                Object val = leftParam.getLeafExpression().calculate(ctx);
                if (val instanceof Sequence) {
                    int len = ((Sequence)val).length();
                    if (len == 0) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("fork" + mm.getMessage("function.invalidParam"));
                    }
                    mcount = len;
                }
                args = new Object[]{val};
            } else {
                int pcount = leftParam.getSubSize();
                args = new Object[pcount];
                for (int p = 0; p < pcount; ++p) {
                    IParam sub = leftParam.getSub(p);
                    if (sub == null) continue;
                    args[p] = sub.getLeafExpression().calculate(ctx);
                    if (!(args[p] instanceof Sequence)) continue;
                    int len = ((Sequence)args[p]).length();
                    if (len == 0) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("fork" + mm.getMessage("function.invalidParam"));
                    }
                    if (mcount == -1) {
                        mcount = len;
                        continue;
                    }
                    if (mcount == len) continue;
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("fork" + mm.getMessage("function.paramCountNotMatch"));
                }
            }
        }
        PgmCellSet pcs = this._$1(row, col, endRow, ctx, false);
        ParallelCaller caller = new ParallelCaller(pcs, hosts, ports);
        caller.setContext(ctx);
        int nextRow = endRow + 1;
        if (nextRow <= this.getRowCount() && (command = this.getPgmNormalCell(nextRow, col).getCommand()) != null && command.getType() == 16) {
            int reduceEndRow = this.getCodeBlockEndRow(nextRow, col);
            PgmCellSet reduce = this._$1(nextRow, col, reduceEndRow, ctx, false);
            caller.setReduce(reduce, new CellLocation(row, col), new CellLocation(nextRow, col));
        }
        if (args != null) {
            String pname = "tmp_fork_param";
            ParamList pl = pcs.getParamList();
            if (pl == null) {
                pl = new ParamList();
                pcs.setParamList(pl);
            }
            pl.add(0, new Param("tmp_fork_param", 0, null));
            pcs.getPgmNormalCell(row, col).setExpString("=tmp_fork_param");
            if (mcount == -1) {
                mcount = 1;
            }
            int pcount = args.length;
            for (int i = 1; i <= mcount; ++i) {
                ArrayList<Object> list = new ArrayList<Object>(1);
                if (pcount == 1) {
                    if (args[0] instanceof Sequence) {
                        Sequence sequence = (Sequence)args[0];
                        list.add(sequence.get(i));
                    } else {
                        list.add(args[0]);
                    }
                } else {
                    Sequence seq = new Sequence(pcount);
                    list.add(seq);
                    for (int p = 0; p < pcount; ++p) {
                        if (args[p] instanceof Sequence) {
                            Sequence sequence = (Sequence)args[p];
                            seq.add(sequence.get(i));
                            continue;
                        }
                        seq.add(args[p]);
                    }
                }
                caller.addCall(list);
            }
        }
        if ((js = ctx.getJobSpace()) != null) {
            caller.setJobSpaceId(js.getID());
        }
        Object result = caller.execute();
        this.getPgmNormalCell(row, col).setValue(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _$1(IParam param, int row, int col, int endRow, Context ctx) {
        Object[] args;
        if (param == null) {
            args = new Object[]{null};
        } else {
            if (param.getType() == ';') {
                this._$2(param, row, col, endRow, ctx);
                return;
            }
            if (param.isLeaf()) {
                Object val = param.getLeafExpression().calculate(ctx);
                if (val instanceof MultipathCursors) {
                    Object[] cursors = ((MultipathCursors)val).getParallelCursors();
                    val = new Sequence(cursors);
                }
                args = new Object[]{val};
            } else {
                int pcount = param.getSubSize();
                args = new Object[pcount];
                for (int i = 0; i < pcount; ++i) {
                    IParam sub = param.getSub(i);
                    if (sub == null) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("fork" + mm.getMessage("function.invalidParam"));
                    }
                    args[i] = sub.getLeafExpression().calculate(ctx);
                }
            }
        }
        int pcount = args.length;
        int mcount = -1;
        for (int i = 0; i < pcount; ++i) {
            if (!(args[i] instanceof Sequence)) continue;
            int len = ((Sequence)args[i]).length();
            if (len == 0) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("fork" + mm.getMessage("function.invalidParam"));
            }
            if (mcount == -1) {
                mcount = len;
                continue;
            }
            if (mcount == len) continue;
            MessageManager mm = EngineMessage.get();
            throw new RQException("fork" + mm.getMessage("function.paramCountNotMatch"));
        }
        if (mcount == -1) {
            mcount = 1;
        }
        IlIIlIlIIlIllIIl[] jobs = new IlIIlIlIIlIllIIl[mcount];
        Sequence result = new Sequence(mcount);
        ThreadPool pool = ThreadPool.newInstance(mcount);
        try {
            int i;
            for (i = 0; i < mcount; ++i) {
                Object val;
                PgmCellSet pcs = this._$1(row, col, endRow, ctx, true);
                pcs._$4 = new lIIIIlIIlllllllI(row, col, endRow, i + 1);
                Context newCtx = pcs.getContext();
                if (pcount == 1) {
                    val = args[0] instanceof Sequence ? ((Sequence)args[0]).get(i + 1) : args[0];
                    if (val instanceof ICursor) {
                        ((ICursor)val).setContext(newCtx);
                    }
                } else {
                    Sequence seq = new Sequence(pcount);
                    val = seq;
                    for (int p = 0; p < pcount; ++p) {
                        if (args[p] instanceof Sequence) {
                            Object mem = ((Sequence)args[p]).get(i + 1);
                            seq.add(mem);
                            if (!(mem instanceof ICursor)) continue;
                            ((ICursor)mem).setContext(newCtx);
                            continue;
                        }
                        seq.add(args[p]);
                        if (!(args[p] instanceof ICursor)) continue;
                        ((ICursor)args[p]).setContext(newCtx);
                    }
                }
                pcs.getPgmNormalCell(row, col).setValue(val);
                jobs[i] = new IlIIlIlIIlIllIIl(pcs, row, col, endRow);
                pool.submit(jobs[i]);
            }
            for (i = 0; i < mcount; ++i) {
                jobs[i].join();
                result.add(jobs[i].getResult());
            }
        }
        finally {
            pool.shutdown();
        }
        this.getPgmNormalCell(row, col).setValue(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _$1(Command command, Context ctx) {
        IParam param = command.getParam(this, ctx);
        if (param == null || !param.isLeaf()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("channel" + mm.getMessage("function.invalidParam"));
        }
        Object obj = param.getLeafExpression().calculate(ctx);
        if (!(obj instanceof ICursor)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("channel" + mm.getMessage("function.paramTypeError"));
        }
        ICursor cs = (ICursor)obj;
        CellLocation curLct = this.curLct;
        int row = curLct.getRow();
        int col = curLct.getCol();
        int endRow = this.getCodeBlockEndRow(row, col);
        ArrayList<PgmNormalCell> cellList = new ArrayList<PgmNormalCell>();
        PgmNormalCell cell = this.getPgmNormalCell(row, col);
        Channel channel = cs.newChannel(ctx, false);
        cell.setValue(channel);
        cellList.add(cell);
        this.setNext(row, col + 1, false);
        while ((curLct = this._$1()) != null && curLct.getRow() <= endRow) {
        }
        channel.addPushToCursor(cs);
        while (this._$1(endRow, col, (byte)18) && (cell = this.getPgmNormalCell(row = endRow + 1, col)).getCommand().getParam(this, ctx) == null) {
            endRow = this.getCodeBlockEndRow(row, col);
            channel = cs.newChannel(ctx, false);
            cell.setValue(channel);
            cellList.add(cell);
            this.setNext(row, col + 1, false);
            while ((curLct = this._$1()) != null && curLct.getRow() <= endRow) {
            }
            channel.addPushToCursor(cs);
        }
        if (cs instanceof MultipathCursors) {
            MultipathCursors mcs = (MultipathCursors)cs;
            ICursor[] cursors = mcs.getCursors();
            int csCount = cursors.length;
            ThreadPool pool = ThreadPool.newInstance(csCount);
            try {
                CursorLooper[] loopers = new CursorLooper[csCount];
                for (int i = 0; i < csCount; ++i) {
                    loopers[i] = new CursorLooper(cursors[i]);
                    pool.submit(loopers[i]);
                }
                for (CursorLooper looper : loopers) {
                    looper.join();
                }
            }
            finally {
                pool.shutdown();
            }
        } else {
            Sequence src;
            while ((src = cs.fuzzyFetch(ICursor.FETCHCOUNT)) != null && src.length() != 0) {
            }
        }
        for (PgmNormalCell chCell : cellList) {
            channel = (Channel)chCell.getValue();
            chCell.setValue(channel.result());
        }
        this.setNext(endRow + 1, 1, true);
    }

    private void _$3(Command command) {
        this._$7 = true;
        Context ctx = this.getContext();
        Expression[] exps = command.getExpressions(this, ctx);
        int count = exps.length;
        this._$12 = new Sequence(count);
        for (int i = 0; i < count; ++i) {
            if (exps[i] == null) {
                this._$12.add(null);
                continue;
            }
            Object obj = exps[i].calculate(ctx);
            this._$12.add(obj);
        }
        int r = this.curLct.getRow();
        int c = this.curLct.getCol();
        this.getCell(r, c).setValue(this._$12);
        this._$10 = new CellLocation(r, c);
        this.setNext(r, c + 1, false);
    }

    private void _$1(NormalCell cell, SqlCommand command) {
        Object val;
        Object dbObj;
        Context ctx = this.getContext();
        Expression dbExp = command.getDbExpression(this, ctx);
        if (dbExp != null) {
            if (command.isLogicSql()) {
                this._$15 = dbObj = FileObject.createSimpleQuery();
            } else {
                Object obj = dbExp.calculate(ctx);
                if (!(obj instanceof DBObject) && !(obj instanceof IQueryable)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(command.getDb() + mm.getMessage("engine.dbsfNotExist"));
                }
                this._$15 = dbObj = obj;
            }
        } else if (this._$15 == null) {
            DBSession dbs = ctx.getDBSession();
            this._$15 = dbs == null ? (dbObj = FileObject.createSimpleQuery()) : (dbObj = new DBObject(dbs));
        } else {
            dbObj = this._$15;
        }
        String sql = command.getSql();
        if (sql == null) {
            this.setNext(this.curLct.getRow(), this.curLct.getCol() + 1, false);
            return;
        }
        IParam param = command.getParam(this, ctx);
        Object[] paramVals = null;
        byte[] types = null;
        if (param != null) {
            ParamInfo2 pi = ParamInfo2.parse(param, "SQL command", true, false);
            paramVals = pi.getValues1(ctx);
            Object[] typeObjs = pi.getValues2(ctx);
            int count = typeObjs.length;
            types = new byte[count];
            for (int i = 0; i < count; ++i) {
                if (typeObjs[i] == null) continue;
                if (!(typeObjs[i] instanceof Number)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("SQL command" + mm.getMessage("function.paramTypeError"));
                }
                types[i] = ((Number)typeObjs[i]).byteValue();
            }
        }
        if (dbObj instanceof DBObject) {
            String opt = command.getOption();
            val = command.isQuery() ? (opt == null || opt.indexOf(49) == -1 ? ((DBObject)dbObj).query(sql, paramVals, types, opt, ctx) : ((DBObject)dbObj).query1(sql, paramVals, types, opt)) : ((DBObject)dbObj).execute(sql, paramVals, types, opt);
        } else {
            val = ((IQueryable)dbObj).query(sql, paramVals, this, ctx);
        }
        cell.setValue(val);
        this.setNext(this.curLct.getRow(), this.curLct.getCol() + 1, false);
    }

    private void _$1(NormalCell cell, Command command) {
        int row = cell.getRow();
        int col = cell.getCol();
        int endRow = this.getCodeBlockEndRow(row, col);
        llIlllIIIllIIllI cmdCode = new llIlllIIIllIIllI(19, row, col, endRow);
        this._$14.addFirst(cmdCode);
        this.setNext(row, col + 1, false);
    }

    private void _$1(IParam startParam, IParam endParam, Context ctx) {
        int bottom;
        int right;
        if (startParam == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("clear" + mm.getMessage("function.invalidParam"));
        }
        INormalCell startCell = startParam.getLeafExpression().calculateCell(ctx);
        if (startCell == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("clear" + mm.getMessage("function.invalidParam"));
        }
        ICellSet cs = startCell.getCellSet();
        int left = startCell.getCol();
        int top = startCell.getRow();
        if (endParam == null) {
            right = this.getColCount();
            bottom = this.getCodeBlockEndRow(top, left);
        } else {
            INormalCell endCell = endParam.getLeafExpression().calculateCell(ctx);
            if (endCell == null || endCell.getCellSet() != cs) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("clear" + mm.getMessage("function.invalidParam"));
            }
            right = endCell.getCol();
            bottom = endCell.getRow();
        }
        if (top <= bottom) {
            if (left <= right) {
                for (int r = top; r <= bottom; ++r) {
                    for (int c = left; c <= right; ++c) {
                        cs.getCell(r, c).clear();
                    }
                }
            } else {
                for (int r = top; r <= bottom; ++r) {
                    for (int c = left; c >= right; --c) {
                        cs.getCell(r, c).clear();
                    }
                }
            }
        } else if (left <= right) {
            for (int r = top; r >= bottom; --r) {
                for (int c = left; c <= right; ++c) {
                    cs.getCell(r, c).clear();
                }
            }
        } else {
            for (int r = top; r >= bottom; --r) {
                for (int c = left; c >= right; --c) {
                    cs.getCell(r, c).clear();
                }
            }
        }
    }

    private void _$2(Command command) {
        Context ctx = this.getContext();
        IParam param = command.getParam(this, ctx);
        if (param != null) {
            if (param.isLeaf()) {
                INormalCell cell = param.getLeafExpression().calculateCell(ctx);
                if (cell == null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("[]" + mm.getMessage("function.invalidParam"));
                }
                cell.clear();
            } else if (param.getType() == ',') {
                int size = param.getSubSize();
                for (int i = 0; i < size; ++i) {
                    IParam sub = param.getSub(i);
                    if (sub == null) continue;
                    if (sub.isLeaf()) {
                        INormalCell cell = sub.getLeafExpression().calculateCell(ctx);
                        if (cell == null) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException("[]" + mm.getMessage("function.invalidParam"));
                        }
                        cell.clear();
                        continue;
                    }
                    this._$1(sub.getSub(0), sub.getSub(1), ctx);
                }
            } else if (param.getType() == ':') {
                this._$1(param.getSub(0), param.getSub(1), ctx);
            } else {
                MessageManager mm = EngineMessage.get();
                throw new RQException("clear" + mm.getMessage("function.invalidParam"));
            }
        }
        this.setNext(this.curLct.getRow(), this.curLct.getCol() + 1, false);
    }

    private void _$1(Command command) {
        Context ctx = this.getContext();
        IParam param = command.getParam(this, ctx);
        if (param != null) {
            if (param.isLeaf()) {
                Object obj = param.getLeafExpression().calculate(ctx);
                this.runFinished();
                throw new RetryException("error " + Variant.toString(obj));
            }
            MessageManager mm = EngineMessage.get();
            throw new RQException("error" + mm.getMessage("function.invalidParam"));
        }
        this.runFinished();
    }

    public void setNext(int row, int col, boolean isCheckStack) {
        int colCount = this.getColCount();
        if (col > colCount) {
            ++row;
            col = 1;
            isCheckStack = true;
        }
        if (isCheckStack) {
            while (this._$14.size() > 0) {
                llIlllIIIllIIllI cmd = this._$14.getFirst();
                if (row <= cmd.blockEndRow) break;
                if (cmd.type == 4) {
                    this.curLct.set(cmd.row, cmd.col);
                    return;
                }
                this._$14.removeFirst();
            }
        }
        if (row > this.getRowCount()) {
            this.runFinished();
        } else {
            PgmNormalCell cell = this.getPgmNormalCell(row, col);
            if (cell.isBlankCell() || cell.isNoteCell() || cell.isConstCell()) {
                this.setNext(row, col + 1, false);
            } else if (cell.isNoteBlock()) {
                this.setNext(this.getCodeBlockEndRow(row, col) + 1, 1, true);
            } else {
                this.curLct.set(row, col);
            }
        }
    }

    public int getCodeBlockEndRow(int prow, int pcol) {
        int totalRow = this.getRowCount();
        for (int row = prow + 1; row <= totalRow; ++row) {
            for (int c = 1; c <= pcol; ++c) {
                PgmNormalCell cell = this.getPgmNormalCell(row, c);
                if (cell.isBlankCell()) continue;
                return row - 1;
            }
        }
        return totalRow;
    }

    public int getFuncEndRow(int prow, int pcol) {
        int totalRow;
        int endRow = totalRow = this.getRowCount();
        block0: for (int row = prow + 1; row <= totalRow; ++row) {
            for (int c = 1; c <= pcol; ++c) {
                PgmNormalCell cell = this.getPgmNormalCell(row, c);
                if (cell.isBlankCell()) continue;
                endRow = row - 1;
                break block0;
            }
        }
        int totalCol = this.getColCount();
        for (int row = endRow; row > prow; --row) {
            for (int c = pcol + 1; c <= totalCol; ++c) {
                PgmNormalCell cell = this.getPgmNormalCell(row, c);
                if (cell.isBlankCell()) continue;
                return row;
            }
        }
        return prow;
    }

    private CellLocation _$1() {
        Context ctx = this.getContext();
        if (this.curLct == null) {
            this.curLct = new CellLocation();
            this.setNext(1, 1, false);
            this._$7 = false;
            return this.curLct;
        }
        try {
            PgmNormalCell cell = this.getPgmNormalCell(this.curLct.getRow(), this.curLct.getCol());
            Command command = cell.getCommand();
            if (command == null) {
                cell.calculate();
                if (cell.isCalculableBlock() || cell.isExecutableBlock()) {
                    int endRow = this.getCodeBlockEndRow(this.curLct.getRow(), this.curLct.getCol());
                    this.setNext(endRow + 1, 1, true);
                } else {
                    this.setNext(this.curLct.getRow(), this.curLct.getCol() + 1, false);
                }
            } else {
                byte type = command.getType();
                switch (type) {
                    case 1: {
                        this._$3(cell, command);
                        break;
                    }
                    case 2: 
                    case 3: {
                        this._$4();
                        break;
                    }
                    case 4: {
                        this._$2(cell, command);
                        break;
                    }
                    case 5: {
                        this._$6(command);
                        break;
                    }
                    case 6: {
                        this._$5(command);
                        break;
                    }
                    case 8: 
                    case 16: {
                        this._$4();
                        break;
                    }
                    case 9: 
                    case 11: {
                        this._$3(command);
                        break;
                    }
                    case 12: {
                        this._$1((NormalCell)cell, (SqlCommand)command);
                        break;
                    }
                    case 13: {
                        this._$2(command);
                        break;
                    }
                    case 10: {
                        this._$1(command);
                        break;
                    }
                    case 15: {
                        this._$2(command, ctx);
                        break;
                    }
                    case 17: {
                        this._$4(command);
                        break;
                    }
                    case 18: {
                        this._$1(command, ctx);
                        break;
                    }
                    case 19: {
                        this._$1((NormalCell)cell, command);
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
            }
        }
        catch (RetryException re) {
            throw re;
        }
        catch (RQException re) {
            String cellId = this.curLct.toString();
            if (this._$6 != null) {
                cellId = "[" + this._$6 + "]." + cellId;
            }
            String msg = re.getMessage();
            if (this._$1(cellId + ' ' + msg)) {
                MessageManager mm = EngineMessage.get();
                msg = mm.getMessage("error.cell", cellId) + msg;
                Logger.error(msg, re);
            }
            MessageManager mm = EngineMessage.get();
            msg = mm.getMessage("error.cell", cellId) + msg;
            re.setMessage(msg);
            throw re;
        }
        catch (Throwable e) {
            String msg;
            String cellId = this.curLct.toString();
            if (this._$6 != null) {
                cellId = "[" + this._$6 + "]." + cellId;
            }
            if (this._$1(msg = e.getMessage())) {
                MessageManager mm = EngineMessage.get();
                msg = mm.getMessage("error.cell", cellId) + msg;
                Logger.error(msg, e);
            }
            MessageManager mm = EngineMessage.get();
            msg = mm.getMessage("error.cell", cellId) + msg;
            throw new RQException(msg, e);
        }
        return this.curLct;
    }

    private boolean _$1(String error) {
        while (this._$14.size() > 0) {
            llIlllIIIllIIllI cmd = this._$14.getFirst();
            if (cmd.type == 19) {
                this._$14.removeFirst();
                this.setNext(cmd.blockEndRow + 1, 1, true);
                this.getPgmNormalCell(cmd.row, cmd.col).setValue(error);
                return true;
            }
            this._$14.removeFirst();
        }
        return false;
    }

    public CellLocation runNext() {
        return this._$1();
    }

    @Override
    public void run() {
        block2: {
            do {
                if (this._$8) {
                    this._$8 = false;
                    break block2;
                }
                if (this._$1() == null) break block2;
            } while (!this.hasReturn());
            this.runFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeSubCell(int row, int col) {
        int rowCount = this.getRowCount();
        int colCount = this.getColCount();
        if (row < 1 || row > rowCount || col < 1 || col > colCount) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(CellLocation.getCellId(row, col) + mm.getMessage("cellset.cellNotExist"));
        }
        if (col == colCount) {
            return null;
        }
        CellLocation oldLct = this.curLct;
        LinkedList<llIlllIIIllIIllI> oldStack = this._$14;
        Object retVal = null;
        try {
            this.curLct = new CellLocation();
            this._$14 = new LinkedList();
            int endRow = this.getCodeBlockEndRow(row, col);
            this.setNext(row, col + 1, false);
            while (this.curLct != null) {
                int curRow = this.curLct.getRow();
                if (curRow > endRow) {
                    break;
                }
                int curCol = this.curLct.getCol();
                this._$1();
                PgmNormalCell cell = this.getPgmNormalCell(curRow, curCol);
                if (!cell.isCalculableCell() && !cell.isCalculableBlock()) continue;
                retVal = cell.getValue();
            }
        }
        finally {
            this.curLct = oldLct;
            this._$14 = oldStack;
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void runCell(int row, int col) {
        PgmNormalCell cell = this.getPgmNormalCell(row, col);
        if (!cell.needCalculate()) {
            return;
        }
        CellLocation oldLct = this.curLct;
        LinkedList<llIlllIIIllIIllI> oldStack = this._$14;
        try {
            this.curLct = new CellLocation(row, col);
            this._$14 = new LinkedList();
            Command cmd = cell.getCommand();
            if (cmd == null) {
                cell.calculate();
                return;
            }
            byte type = cmd.getType();
            switch (type) {
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 16: {
                    return;
                }
                case 9: 
                case 11: {
                    this._$3(cmd);
                    return;
                }
                case 1: {
                    CellLocation lct;
                    int endRow = this._$3(row, col);
                    while ((lct = this._$1()) != null) {
                        if (lct.getRow() <= endRow) continue;
                        return;
                    }
                    return;
                }
                case 4: {
                    CellLocation lct;
                    int endRow = this.getCodeBlockEndRow(row, col);
                    while ((lct = this._$1()) != null) {
                        if (lct.getRow() <= endRow) continue;
                        return;
                    }
                    return;
                }
                case 12: {
                    this._$1((NormalCell)cell, (SqlCommand)cmd);
                    return;
                }
                case 13: {
                    this._$2(cmd);
                    return;
                }
                case 10: {
                    this._$1(cmd);
                    return;
                }
                case 15: {
                    this._$2(cmd, this.getContext());
                    return;
                }
                case 18: {
                    this._$1(cmd, this.getContext());
                    return;
                }
                case 19: {
                    return;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
        finally {
            this.curLct = oldLct;
            this._$14 = oldStack;
        }
    }

    public Object executeFunc(int row, int col, Object[] args, String opt) {
        PgmNormalCell cell = this.getPgmNormalCell(row, col);
        Command cmd = cell.getCommand();
        if (cmd == null || cmd.getType() != 8) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.callNeedSub"));
        }
        String expStr = cmd.getExpression();
        if (expStr != null && expStr.length() > 0) {
            int nameEnd = KeyWord.scanId(expStr, 0);
            String fnName = expStr.substring(0, nameEnd);
            return this.executeFunc(fnName, args);
        }
        int endRow = this.getFuncEndRow(row, col);
        if (opt != null && opt.indexOf(105) != -1) {
            CellLocation oldLct = this.curLct;
            LinkedList<llIlllIIIllIIllI> oldStack = this._$14;
            this._$14 = new LinkedList();
            Object result = this._$1(row, col, endRow, args);
            this._$14 = oldStack;
            this.curLct = oldLct;
            return result;
        }
        PgmCellSet pcs = this.newCalc();
        int colCount = this.getColCount();
        for (int r = row; r <= endRow; ++r) {
            for (int c = col; c <= colCount; ++c) {
                INormalCell tmp = this.getCell(r, c);
                INormalCell cellClone = (INormalCell)tmp.deepClone();
                cellClone.setCellSet(pcs);
                pcs.cellMatrix.set(r, c, cellClone);
            }
        }
        return pcs._$1(row, col, endRow, args);
    }

    public FuncInfo getFuncInfo(String fnName) {
        return this.getFunctionMap().get(fnName);
    }

    public FuncInfo getFuncInfo(INormalCell cell) {
        HashMap<String, FuncInfo> map = this.getFunctionMap();
        for (FuncInfo fi : map.values()) {
            if (fi.getCell() != cell) continue;
            return fi;
        }
        return null;
    }

    public Object executeFunc(FuncInfo funcInfo, Object[] args) {
        Context ctx = this.getContext();
        return this.executeFunc(funcInfo, args, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeFunc(FuncInfo funcInfo, Object[] args, Context ctx) {
        PgmNormalCell cell = funcInfo.getCell();
        int row = cell.getRow();
        int col = cell.getCol();
        int colCount = this.getColCount();
        int endRow = funcInfo.getEndRow();
        String[] argNames = funcInfo.getArgNames();
        if (funcInfo.isRecursiveMode()) {
            PgmCellSet pcs = this.newCalc(ctx);
            if (argNames != null) {
                int argCount = argNames.length;
                if (args == null || args.length != argCount) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(funcInfo.getFnName() + mm.getMessage("function.paramCountNotMatch"));
                }
                Context dfxCtx = pcs.getContext();
                for (int i = 0; i < argCount; ++i) {
                    dfxCtx.setParamValue(argNames[i], args[i]);
                }
            }
            for (int r = row; r <= endRow; ++r) {
                for (int c = col; c <= colCount; ++c) {
                    INormalCell tmp = this.getCell(r, c);
                    INormalCell cellClone = (INormalCell)tmp.deepClone();
                    cellClone.setCellSet(pcs);
                    pcs.cellMatrix.set(r, c, cellClone);
                }
            }
            return pcs._$1(row, col, endRow, null);
        }
        CellLocation oldLct = this.curLct;
        LinkedList<llIlllIIIllIIllI> oldStack = this._$14;
        Context thisCtx = this.getContext();
        if (thisCtx != ctx) {
            thisCtx.setJobSpace(ctx.getJobSpace());
        }
        if (argNames == null) {
            ParamList oldParamList = thisCtx.getParamList();
            ParamList paramList = new ParamList();
            thisCtx.setParamList(paramList);
            try {
                this._$14 = new LinkedList();
                Object object = this._$1(row, col, endRow, null);
                return object;
            }
            finally {
                this.curLct = oldLct;
                this._$14 = oldStack;
                thisCtx.setParamList(oldParamList);
                int count = paramList.count();
                for (int i = 0; i < count; ++i) {
                    paramList.get(i).setDeleted(true);
                }
            }
        }
        int argCount = argNames.length;
        if (args == null || args.length != argCount) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(funcInfo.getFnName() + mm.getMessage("function.paramCountNotMatch"));
        }
        ParamList oldParamList = thisCtx.getParamList();
        ParamList paramList = new ParamList();
        thisCtx.setParamList(paramList);
        try {
            for (int i = 0; i < argCount; ++i) {
                paramList.add(new Param(argNames[i], 0, args[i]));
            }
            this._$14 = new LinkedList();
            Object object = this._$1(row, col, endRow, null);
            return object;
        }
        finally {
            this.curLct = oldLct;
            this._$14 = oldStack;
            thisCtx.setParamList(oldParamList);
            int count = paramList.count();
            for (int i = 0; i < count; ++i) {
                paramList.get(i).setDeleted(true);
            }
        }
    }

    public Object executeFunc(String fnName, Object[] args) {
        FuncInfo funcInfo = this.getFuncInfo(fnName);
        if (funcInfo == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(fnName + mm.getMessage("Expression.unknownFunction"));
        }
        return this.executeFunc(funcInfo, args);
    }

    private Object _$1(int row, int col, int endRow, Object[] args) {
        int curRow;
        int colCount = this.getColCount();
        if (args != null) {
            int paramRow = row;
            int paramCol = col;
            int pcount = args.length;
            for (int i = 0; i < pcount; ++i) {
                this.getPgmNormalCell(paramRow, paramCol).setValue(args[i]);
                if (paramCol >= colCount) break;
                ++paramCol;
            }
        }
        this.curLct = new CellLocation(row, col);
        this.setNext(row, col + 1, false);
        while (this.curLct != null && (curRow = this.curLct.getRow()) <= endRow) {
            int curCol = this.curLct.getCol();
            PgmNormalCell cell = this.getPgmNormalCell(curRow, curCol);
            Command cmd = cell.getCommand();
            if (cmd == null) {
                this._$1();
                continue;
            }
            if (cmd.getType() == 9) {
                Context ctx = this.getContext();
                Expression exp = cmd.getExpression(this, ctx);
                if (exp != null) {
                    return exp.calculate(ctx);
                }
                return null;
            }
            this._$1();
        }
        for (int r = endRow; r >= row; --r) {
            for (int c = colCount; c > col; --c) {
                PgmNormalCell cell = this.getPgmNormalCell(r, c);
                if (!cell.isCalculableCell() && !cell.isCalculableBlock()) continue;
                return cell.getValue();
            }
        }
        return null;
    }

    @Override
    public void runFinished() {
        super.runFinished();
        this.curLct = null;
        this._$14.clear();
        this._$15 = null;
    }

    @Override
    public void reset() {
        super.reset();
        this._$12 = null;
        this._$11 = 0;
        this._$10 = null;
        this._$9 = false;
        this._$8 = false;
        this._$7 = false;
        this._$5 = null;
    }

    @Override
    protected void setParseCurrent(int row, int col) {
        if (this._$13 == null) {
            this._$13 = new CellLocation(row, col);
        } else {
            this._$13.set(row, col);
        }
    }

    @Override
    public String getMacroReplaceString(String strCell) {
        int ec;
        int er;
        int sc;
        int sr;
        int colonIndex;
        Context ctx = this.getContext();
        strCell = Expression.replaceMacros(strCell, this, ctx);
        if ((strCell = strCell.trim()) != null && (colonIndex = strCell.indexOf(58)) != -1) {
            String startStr = strCell.substring(0, colonIndex);
            INormalCell startCell = this.getCell(startStr);
            if (startCell == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(startStr + mm.getMessage("cellset.cellNotExist"));
            }
            String endStr = strCell.substring(colonIndex + 1);
            INormalCell endCell = this.getCell(endStr);
            if (endCell == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(endStr + mm.getMessage("cellset.cellNotExist"));
            }
            sr = startCell.getRow();
            sc = startCell.getCol();
            er = endCell.getRow();
            ec = endCell.getCol();
            if (sr > er || sc > ec) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("\":\"" + mm.getMessage("operator.cellLocation"));
            }
        } else {
            INormalCell cell = this.getCell(strCell);
            if (cell == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(strCell + mm.getMessage("cellset.cellNotExist"));
            }
            er = sr = cell.getRow();
            ec = sc = cell.getCol();
        }
        StringBuffer buffer = new StringBuffer(100);
        block0: for (int r = sr; r <= er; ++r) {
            for (int c = sc; c <= ec; ++c) {
                PgmNormalCell cell = this.getPgmNormalCell(r, c);
                if (cell.isBlankCell() || cell.isNoteCell()) continue;
                if (cell.isNoteBlock()) {
                    r = this.getCodeBlockEndRow(r, c);
                    continue block0;
                }
                this.setParseCurrent(r, c);
                String cellStr = cell.getMacroReplaceString();
                buffer.append(Expression.replaceMacros(cellStr, this, ctx));
                buffer.append(',');
            }
        }
        int len = buffer.length();
        return len > 0 ? buffer.substring(0, len - 1) : "";
    }

    public String getPrevCellSet(String str, int pos) {
        return null;
    }

    public boolean isCallInterrupted() {
        return this.curLct != null && this._$12 == null;
    }

    public Object execute() {
        this._$12 = null;
        while (this._$1() != null && this._$12 == null) {
            if (!this._$8) continue;
            this._$8 = false;
            break;
        }
        if (this._$12 != null) {
            if (this._$12.length() == 0) {
                return null;
            }
            if (this._$12.length() == 1) {
                return this._$12.get(1);
            }
            return this._$12;
        }
        return this.getLastCalculableCellValue();
    }

    public Object getLastCalculableCellValue() {
        int colCount = this.getColCount();
        for (int r = this.getRowCount(); r > 0; --r) {
            for (int c = colCount; c > 0; --c) {
                PgmNormalCell cell = this.getPgmNormalCell(r, c);
                if (!cell.isCalculableCell() && !cell.isCalculableBlock()) continue;
                Object val = cell.getValue();
                this._$12 = new Sequence(1);
                this._$12.add(val);
                return val;
            }
        }
        return null;
    }

    public void calculateResult() {
        this.execute();
    }

    public boolean hasNextResult() {
        if (this._$12 != null && this._$12.length() > 0) {
            return true;
        }
        if (this.curLct == null) {
            return false;
        }
        this._$12 = null;
        this._$11 = 0;
        while (this._$1() != null && this._$12 == null) {
            if (!this._$8) continue;
            this._$8 = false;
            return false;
        }
        return this.hasNextResult();
    }

    public boolean hasReturn() {
        return this._$7;
    }

    public Object nextResult() {
        if (!this.hasNextResult()) {
            return null;
        }
        if (this._$11 < 1) {
            this._$11 = 1;
        }
        Object obj = this._$12.get(this._$11);
        if (this._$11 < this._$12.length()) {
            this._$12.set(this._$11, null);
            ++this._$11;
        } else {
            this._$12 = null;
        }
        return obj;
    }

    public CellLocation nextResultLocation() {
        if (!this.hasNextResult()) {
            return null;
        }
        return this._$10;
    }

    public void interrupt() {
        this._$9 = true;
        this._$8 = true;
    }

    public boolean getInterrupt() {
        return this._$9;
    }

    public void setAutoCalc(boolean b) {
        this._$20 = b ? (this._$20 |= 0x10) : (this._$20 &= 0xFFFFFFEF);
    }

    public boolean isAutoCalc() {
        return (this._$20 & 0x10) == 16;
    }

    public void setDynamicParam(boolean b) {
        this._$20 = b ? (this._$20 |= 0x10) : (this._$20 &= 0xFFFFFFEF);
    }

    public boolean isDynamicParam() {
        return (this._$20 & 0x10) == 16;
    }

    public void setName(String name) {
        this._$6 = name;
    }

    public String getName() {
        return this._$6;
    }

    public ByteMap getCustomPropMap() {
        return this._$19;
    }

    public void setCustomPropMap(ByteMap map) {
        if (!this.isExecuteOnly()) {
            this._$19 = map;
        }
    }

    public void setPassword(String psw) {
        if (psw == null || psw.length() == 0) {
            this._$18 = null;
        } else {
            MD5 md5 = new MD5();
            this._$18 = md5.getMD5ofStr(psw);
        }
    }

    public String getPasswordHash() {
        return this._$18;
    }

    public int getNullPasswordPrivilege() {
        return this._$17;
    }

    public void setCurrentPassword(String psw) {
        this._$16 = PgmCellSet.getPrivilege(this._$18, psw, this._$17);
    }

    public static int getPrivilege(String pswHash, String psw, int nullPswPrivilege) {
        if (pswHash == null) {
            return 0;
        }
        if (psw == null || psw.length() == 0) {
            return nullPswPrivilege;
        }
        MD5 md5 = new MD5();
        if ((psw = md5.getMD5ofStr(psw)).equals(pswHash)) {
            return 0;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("cellset.pswError"));
    }

    public int getCurrentPrivilege() {
        return this._$16;
    }

    public boolean isExecuteOnly() {
        return this._$16 == 1;
    }

    public HashMap<String, FuncInfo> getFunctionMap() {
        if (this._$5 == null) {
            this._$5 = new HashMap();
            int rowCount = this.getRowCount();
            int colCount = this.getColCount();
            Context ctx = this.getContext();
            for (int r = 1; r <= rowCount; ++r) {
                for (int c = 1; c <= colCount; ++c) {
                    FuncInfo funcInfo;
                    String expStr;
                    PgmNormalCell cell = this.getPgmNormalCell(r, c);
                    Command command = cell.getCommand();
                    if (command == null || command.getType() != 8 || (expStr = command.getExpression()) == null || expStr.length() == 0) continue;
                    int len = expStr.length();
                    int nameEnd = KeyWord.scanId(expStr, 0);
                    String fnName = expStr.substring(0, nameEnd);
                    String fnOpt = null;
                    int atIdx = fnName.indexOf(64);
                    if (atIdx != -1) {
                        fnOpt = fnName.substring(atIdx + 1);
                        fnName = fnName.substring(0, atIdx);
                    }
                    if (nameEnd == len) {
                        funcInfo = new FuncInfo(fnName, cell, null, fnOpt);
                        this._$5.put(expStr, funcInfo);
                        continue;
                    }
                    while (nameEnd < len && Character.isWhitespace(expStr.charAt(nameEnd))) {
                        ++nameEnd;
                    }
                    if (nameEnd == len) {
                        funcInfo = new FuncInfo(fnName, cell, null, fnOpt);
                        this._$5.put(fnName, funcInfo);
                        continue;
                    }
                    if (expStr.charAt(nameEnd) == '(' && expStr.charAt(len - 1) == ')') {
                        String[] argNames = null;
                        Object[] defaultValues = null;
                        IParam param = ParamParser.parse(expStr.substring(nameEnd + 1, len - 1), this, ctx, false);
                        if (param != null) {
                            argNames = param.toStringArray("func", false);
                            int argCount = argNames.length;
                            defaultValues = new Object[argCount];
                            for (int i = 0; i < argCount; ++i) {
                                int index = argNames[i].indexOf(61);
                                if (index == -1) continue;
                                Expression exp = new Expression(this, ctx, argNames[i].substring(index + 1));
                                argNames[i] = argNames[i].substring(0, index);
                                defaultValues[i] = exp.calculate(ctx);
                            }
                        }
                        FuncInfo funcInfo2 = new FuncInfo(fnName, cell, argNames, fnOpt);
                        funcInfo2._$1(defaultValues);
                        this._$5.put(fnName, funcInfo2);
                        continue;
                    }
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("func" + mm.getMessage("function.invalidParam"));
                }
            }
        }
        return this._$5;
    }

    static /* synthetic */ void _$1(PgmCellSet x0, int x1, int x2, int x3) {
        x0._$1(x1, x2, x3);
    }

    static /* synthetic */ Object _$1(PgmCellSet x0) {
        return x0._$2();
    }

    static /* synthetic */ void _$1(PgmCellSet x0, IParam x1, int x2, int x3, int x4, Context x5) {
        x0._$1(x1, x2, x3, x4, x5);
    }

    public class FuncInfo {
        private String _$9;
        private String _$8;
        private PgmNormalCell _$7;
        private String[] _$6;
        private boolean[] _$5;
        private Object[] _$4;
        private String _$3;
        private int _$2;

        public FuncInfo(String fnName, PgmNormalCell cell, String[] argNames) {
            this(fnName, cell, argNames, null);
        }

        public FuncInfo(String fnName, PgmNormalCell cell, String[] argNames, String option) {
            this._$9 = fnName;
            this._$7 = cell;
            this._$6 = argNames;
            this._$8 = option;
            if (argNames != null) {
                int count = argNames.length;
                this._$5 = new boolean[count];
                for (int i = 0; i < count; ++i) {
                    if (!argNames[i].startsWith("$")) continue;
                    this._$5[i] = true;
                    argNames[i] = argNames[i].substring(1);
                }
            }
            int row = cell.getRow();
            int col = cell.getCol();
            this._$2 = PgmCellSet.this.getFuncEndRow(row, col);
            if (option != null && option.indexOf(109) != -1) {
                int colCount = PgmCellSet.this.getColCount();
                block1: for (int r = row; r <= this._$2; ++r) {
                    for (int c = col + 1; c <= colCount; ++c) {
                        PgmNormalCell pc = PgmCellSet.this.getPgmNormalCell(r, c);
                        if (!pc.isCalculableCell() && !pc.isExecutableCell()) continue;
                        this._$3 = pc.getExpString().substring(1);
                        break block1;
                    }
                }
            }
        }

        public boolean isMacroArg(int i) {
            return this._$5[i];
        }

        public String getFnName() {
            return this._$9;
        }

        public PgmNormalCell getCell() {
            return this._$7;
        }

        public String[] getArgNames() {
            return this._$6;
        }

        public String getOption() {
            return this._$8;
        }

        public void setOption(String option) {
            this._$8 = option;
        }

        public int getEndRow() {
            return this._$2;
        }

        public boolean hasOptParam() {
            return this._$8 != null && this._$8.indexOf(111) != -1;
        }

        public boolean isMacroMode() {
            return this._$8 != null && this._$8.indexOf(109) != -1;
        }

        public boolean isRecursiveMode() {
            return this._$8 == null || this._$8.indexOf(105) == -1;
        }

        public String getMacroExpression() {
            return this._$3;
        }

        public Object[] getDefaultValues() {
            if (this._$4 == null) {
                return null;
            }
            int len = this._$4.length;
            Object[] vals = new Object[len];
            System.arraycopy(this._$4, 0, vals, 0, len);
            return vals;
        }

        void _$1(Object[] defaultValues) {
            this._$4 = defaultValues;
        }

        public Object execute(Object[] args, Context ctx) {
            return PgmCellSet.this.executeFunc(this, args, ctx);
        }
    }
}

