/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.cellset.datamodel;

import com.scudata.cellset.INormalCell;
import com.scudata.cellset.datamodel.CellSet;
import com.scudata.cellset.datamodel.Command;
import com.scudata.cellset.datamodel.NormalCell;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.dm.Context;
import com.scudata.dm.DBObject;
import com.scudata.dm.Env;
import com.scudata.dm.FileObject;
import com.scudata.dm.ParamList;
import com.scudata.expression.Expression;
import com.scudata.expression.IParam;
import com.scudata.util.Variant;
import java.lang.ref.SoftReference;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PgmNormalCell
extends NormalCell {
    private static final long serialVersionUID = 33619988L;
    protected transient SoftReference<Expression> expRef;
    private transient int _$3 = 256;
    private transient Command _$2;
    private transient boolean _$1 = false;

    public PgmNormalCell() {
    }

    public PgmNormalCell(CellSet cs, int r, int c) {
        super(cs, r, c);
    }

    @Override
    public int getType() {
        return this._$3;
    }

    @Override
    public void reset() {
        if ((this._$3 & 0x20) != 0) {
            this.value = this.expStr.startsWith("'") ? this.expStr.substring(1) : Variant.parse(this.expStr, false);
        } else {
            this.value = null;
            this.expRef = null;
            this._$2 = null;
        }
    }

    @Override
    public void setExpString(String exp) {
        if (exp != null && exp.equals(this.expStr)) {
            return;
        }
        this.expStr = exp;
        this.value = null;
        this.expRef = null;
        this._$2 = null;
        if (exp != null && exp.length() > 0) {
            if (exp.startsWith("==")) {
                this._$3 = 2;
                this._$1 = Expression.containMacro(exp);
            } else if (exp.startsWith("=")) {
                this._$3 = 1;
                this._$1 = Expression.containMacro(exp);
            } else if (exp.startsWith(">>")) {
                this._$3 = 8;
                this._$1 = Expression.containMacro(exp);
            } else if (exp.startsWith(">")) {
                this._$3 = 4;
                this._$1 = Expression.containMacro(exp);
            } else if (exp.startsWith("//")) {
                this._$3 = 128;
            } else if (exp.startsWith("/")) {
                this._$3 = 64;
            } else if (Command.isCommand(exp)) {
                this._$3 = 16;
                this._$1 = Expression.containMacro(exp);
            } else {
                this.value = PgmNormalCell.parseConstValue(exp);
                this._$3 = 32;
            }
        } else {
            this._$3 = 256;
        }
    }

    public static Object parseConstValue(String str) {
        if (str.startsWith("'")) {
            return str.substring(1);
        }
        return Variant.parse(str, false);
    }

    public String getMacroReplaceString() {
        String exp = this.expStr;
        if (exp == null) {
            return null;
        }
        int len = exp.length();
        if (len == 0) {
            return null;
        }
        char c1 = exp.charAt(0);
        if (c1 == '=') {
            char c2;
            char c = c2 = len > 1 ? exp.charAt(1) : (char)'\u0000';
            if (c2 == '=') {
                return this.getCellId() + exp.substring(1);
            }
            return this.getCellId() + exp;
        }
        if (c1 == '>') {
            if (len > 1 && exp.charAt(1) == '>') {
                return exp.substring(2);
            }
            return this.expStr.substring(1);
        }
        if (c1 == '/') {
            return null;
        }
        return exp;
    }

    @Override
    public Object getValue(boolean doCalc) {
        return this.getValue();
    }

    @Override
    public void calculate() {
        Context ctx = this.cs.getContext();
        if ((this._$3 & 1) != 0) {
            Expression exp;
            if (this.expRef == null || (exp = this.expRef.get()) == null) {
                this.cs.setParseCurrent(this.row, this.col);
                exp = new Expression(this.cs, ctx, this.expStr.substring(1) + this._$2());
                if (!this._$1()) {
                    this.expRef = new SoftReference<Expression>(exp);
                }
            }
            this.value = exp.calculate(ctx);
        } else if ((this._$3 & 2) != 0) {
            Expression exp;
            if (this.expRef == null || (exp = this.expRef.get()) == null) {
                this.cs.setParseCurrent(this.row, this.col);
                exp = new Expression(this.cs, ctx, this.expStr.substring(2) + this._$2());
                if (!this._$1()) {
                    this.expRef = new SoftReference<Expression>(exp);
                }
            }
            this.value = exp.calculate(ctx);
        } else if ((this._$3 & 4) != 0) {
            Expression exp;
            if (this.expRef == null || (exp = this.expRef.get()) == null) {
                this.cs.setParseCurrent(this.row, this.col);
                exp = this.expStr.charAt(0) == '>' ? new Expression(this.cs, ctx, this.expStr.substring(1) + this._$2()) : new Expression(this.cs, ctx, this.expStr + this._$2());
                if (!this._$1()) {
                    this.expRef = new SoftReference<Expression>(exp);
                }
            }
            exp.calculate(ctx);
        } else if ((this._$3 & 8) != 0) {
            Expression exp;
            if (this.expRef == null || (exp = this.expRef.get()) == null) {
                this.cs.setParseCurrent(this.row, this.col);
                exp = new Expression(this.cs, ctx, this.expStr.substring(2) + this._$2());
                if (!this._$1()) {
                    this.expRef = new SoftReference<Expression>(exp);
                }
            }
            exp.calculate(ctx);
        }
    }

    private String _$2() {
        char lastChar = this.expStr.charAt(this.expStr.length() - 1);
        if (lastChar != ',' && lastChar != ';' && lastChar != '(') {
            return "";
        }
        StringBuffer sb = new StringBuffer(256);
        PgmCellSet pcs = (PgmCellSet)this.cs;
        int endRow = pcs.getCodeBlockEndRow(this.row, this.col);
        int colCount = this.cs.getColCount();
        int startCol = this.col + 1;
        block0: for (int r = this.row; r <= endRow; ++r) {
            for (int c = startCol; c <= colCount; ++c) {
                PgmNormalCell cell = pcs.getPgmNormalCell(r, c);
                if (cell == null || cell.isNoteCell()) continue;
                if (cell.isNoteBlock()) {
                    r = pcs.getCodeBlockEndRow(r, c);
                    continue block0;
                }
                String subStr = cell.getExpString();
                if (subStr == null || subStr.length() <= 0) continue;
                sb.append(subStr);
                lastChar = subStr.charAt(subStr.length() - 1);
                if (lastChar != ',' && lastChar != ';' && lastChar != '(') break block0;
            }
        }
        return sb.toString();
    }

    public Expression getExpression() {
        Expression exp = null;
        if (this.expRef != null && (exp = this.expRef.get()) != null) {
            return exp;
        }
        Context ctx = this.cs.getContext();
        if ((this._$3 & 1) != 0) {
            this.cs.setParseCurrent(this.row, this.col);
            exp = new Expression(this.cs, ctx, this.expStr.substring(1) + this._$2());
            if (!this._$1()) {
                this.expRef = new SoftReference<Expression>(exp);
            }
        } else if ((this._$3 & 2) != 0) {
            this.cs.setParseCurrent(this.row, this.col);
            exp = new Expression(this.cs, ctx, this.expStr.substring(2) + this._$2());
            if (!this._$1()) {
                this.expRef = new SoftReference<Expression>(exp);
            }
        } else if ((this._$3 & 4) != 0) {
            this.cs.setParseCurrent(this.row, this.col);
            exp = this.expStr.charAt(0) == '>' ? new Expression(this.cs, ctx, this.expStr.substring(1) + this._$2()) : new Expression(this.cs, ctx, this.expStr + this._$2());
            if (!this._$1()) {
                this.expRef = new SoftReference<Expression>(exp);
            }
        } else if ((this._$3 & 8) != 0) {
            this.cs.setParseCurrent(this.row, this.col);
            exp = new Expression(this.cs, ctx, this.expStr.substring(2) + this._$2());
            if (!this._$1()) {
                this.expRef = new SoftReference<Expression>(exp);
            }
        }
        return exp;
    }

    public Command getCommand() {
        if (this._$2 == null && (this._$3 & 0x10) != 0) {
            if (this._$1()) {
                return Command.parse(this.expStr);
            }
            this._$2 = Command.parse(this.expStr);
        }
        return this._$2;
    }

    public boolean isCommandCell() {
        return (this._$3 & 0x10) != 0;
    }

    public boolean isResultCell() {
        return this.isCommandCell() && Command.isResultCommand(this.expStr);
    }

    public boolean needCalculate() {
        int tmp = 31;
        return (this._$3 & tmp) != 0;
    }

    public boolean isBlankCell() {
        return (this._$3 & 0x100) != 0;
    }

    private boolean _$1() {
        return this._$1;
    }

    public boolean isConstCell() {
        return (this._$3 & 0x20) != 0;
    }

    public boolean isNoteCell() {
        return (this._$3 & 0x40) != 0;
    }

    public boolean isNoteBlock() {
        return (this._$3 & 0x80) != 0;
    }

    @Override
    public boolean isCalculableBlock() {
        return (this._$3 & 2) != 0;
    }

    @Override
    public boolean isCalculableCell() {
        return (this._$3 & 1) != 0;
    }

    public boolean isExecutableCell() {
        return (this._$3 & 4) != 0;
    }

    public boolean isExecutableBlock() {
        return (this._$3 & 8) != 0;
    }

    @Override
    public Object deepClone() {
        PgmNormalCell cell = new PgmNormalCell(this.cs, this.row, this.col);
        cell.setExpString(this.expStr);
        cell.tip = this.tip;
        cell.value = this.value;
        return cell;
    }

    @Override
    public boolean needRegulateString() {
        return (this._$3 & 0x20) == 0 && (this._$3 & 0x100) == 0 && ((this._$3 & 0x40) == 0 && (this._$3 & 0x80) == 0 || Env.isAdjustNoteCell());
    }

    @Override
    public byte calcExpValueType(Context ctx) {
        Object val = this.getValue();
        if (val == null) {
            Expression exp = this.getExpression();
            return exp == null ? (byte)101 : exp.getExpValueType(ctx);
        }
        if (val instanceof DBObject) {
            return 1;
        }
        if (val instanceof FileObject) {
            return 2;
        }
        return 101;
    }

    public void getUsedParamsAndCells(ParamList usedParams, List<INormalCell> usedCells) {
        Expression exp;
        Context ctx = this.cs.getContext();
        if ((this._$3 & 1) != 0) {
            this.cs.setParseCurrent(this.row, this.col);
            exp = new Expression(this.cs, ctx, this.expStr.substring(1) + this._$2());
        } else if ((this._$3 & 2) != 0) {
            this.cs.setParseCurrent(this.row, this.col);
            exp = new Expression(this.cs, ctx, this.expStr.substring(2) + this._$2());
        } else if ((this._$3 & 4) != 0) {
            this.cs.setParseCurrent(this.row, this.col);
            exp = this.expStr.charAt(0) == '>' ? new Expression(this.cs, ctx, this.expStr.substring(1) + this._$2()) : new Expression(this.cs, ctx, this.expStr + this._$2());
        } else if ((this._$3 & 8) != 0) {
            this.cs.setParseCurrent(this.row, this.col);
            exp = new Expression(this.cs, ctx, this.expStr.substring(2) + this._$2());
        } else {
            IParam param;
            Command cmd = this.getCommand();
            if (cmd != null && (param = cmd.getParam(this.cs, ctx)) != null) {
                param.getUsedParams(ctx, usedParams);
                param.getUsedCells(usedCells);
            }
            return;
        }
        exp.getUsedParams(ctx, usedParams);
        exp.getUsedCells(usedCells);
    }

    public void getUsedCells(List<INormalCell> resultList) {
        Expression exp;
        Context ctx = this.cs.getContext();
        if ((this._$3 & 1) != 0) {
            this.cs.setParseCurrent(this.row, this.col);
            exp = new Expression(this.cs, ctx, this.expStr.substring(1) + this._$2());
        } else if ((this._$3 & 2) != 0) {
            this.cs.setParseCurrent(this.row, this.col);
            exp = new Expression(this.cs, ctx, this.expStr.substring(2) + this._$2());
        } else if ((this._$3 & 4) != 0) {
            this.cs.setParseCurrent(this.row, this.col);
            exp = this.expStr.charAt(0) == '>' ? new Expression(this.cs, ctx, this.expStr.substring(1) + this._$2()) : new Expression(this.cs, ctx, this.expStr + this._$2());
        } else if ((this._$3 & 8) != 0) {
            this.cs.setParseCurrent(this.row, this.col);
            exp = new Expression(this.cs, ctx, this.expStr.substring(2) + this._$2());
        } else {
            Command cmd = this.getCommand();
            if (cmd != null) {
                cmd.getUsedCells(this.cs, ctx, resultList);
            }
            return;
        }
        exp.getUsedCells(resultList);
    }

    @Override
    public void clear() {
        this.value = null;
        this.expRef = null;
        this._$2 = null;
    }
}

