/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.cellset.graph;

import com.scudata.app.common.AppUtil;
import com.scudata.cellset.BackGraphConfig;
import com.scudata.cellset.graph.PublicProperty;
import com.scudata.cellset.graph.config.Palette;
import com.scudata.cellset.graph.draw.ExtGraphProperty;
import com.scudata.common.ArgumentTokenizer;
import com.scudata.common.ImageUtils;
import com.scudata.common.StringUtils;
import com.scudata.dm.Env;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.swing.ImageIcon;

public class StatisticGraph {
    public static ExtGraphProperty calc1(PublicProperty prop) {
        ArgumentTokenizer st;
        Palette pl;
        ExtGraphProperty catMap = new ExtGraphProperty(prop);
        catMap.setXTitle(prop.getXTitle());
        catMap.setYTitle(prop.getYTitle());
        catMap.setGraphTitle(prop.getGraphTitle());
        catMap.setBarDistance(prop.getBarDistance());
        catMap.setTopData(prop.getTopData());
        catMap.setBackGraphConfig(prop.getBackGraphConfig());
        String str = prop.getDisplayDataFormat();
        if (StringUtils.isValidString(str)) {
            ArgumentTokenizer st2 = new ArgumentTokenizer(str, ';');
            if (st2.hasMoreTokens()) {
                catMap.setDisplayDataFormat1(st2.nextToken());
            }
            if (st2.hasMoreTokens()) {
                catMap.setDisplayDataFormat2(st2.nextToken());
            }
        }
        catMap.setLink(prop.getLink());
        catMap.setLinkTarget(prop.getLinkTarget());
        Palette pltt = Palette.getDefaultPalette();
        str = prop.getColorConfig();
        if (StringUtils.isValidString(str) && (pl = Palette.readColor(str)) != null) {
            pltt = pl;
        }
        catMap.setPalette(pltt);
        str = prop.getYStartValue();
        if (StringUtils.isValidString(str)) {
            st = new ArgumentTokenizer(str, ';');
            if (st.hasMoreTokens()) {
                catMap.setYStartValue1(Double.parseDouble(st.nextToken()));
            }
            if (st.hasMoreTokens()) {
                catMap.setYStartValue2(Double.parseDouble(st.nextToken()));
            }
        }
        if (StringUtils.isValidString(str = prop.getYEndValue())) {
            st = new ArgumentTokenizer(str, ';');
            if (st.hasMoreTokens()) {
                catMap.setYEndValue1(Double.parseDouble(st.nextToken()));
            }
            if (st.hasMoreTokens()) {
                catMap.setYEndValue2(Double.parseDouble(st.nextToken()));
            }
        }
        if (StringUtils.isValidString(str = prop.getYInterval())) {
            st = new ArgumentTokenizer(str, ';');
            if (st.hasMoreTokens()) {
                catMap.setYInterval1(Double.parseDouble(st.nextToken()));
            }
            if (st.hasMoreTokens()) {
                catMap.setYInterval2(Double.parseDouble(st.nextToken()));
            }
        }
        catMap.setYMinMarks(prop.getYMinMarks());
        catMap.setTitleMargin(prop.getTitleMargin());
        catMap.setXInterval(prop.getXInterval());
        return catMap;
    }

    public static byte[] getImageBytes(BufferedImage bi, byte imageFmt) throws Exception {
        byte[] bytes = null;
        switch (imageFmt) {
            case 2: {
                bytes = ImageUtils.writeGIF(bi);
                break;
            }
            case 1: {
                bytes = ImageUtils.writeJPEG(bi);
                break;
            }
            case 3: {
                bytes = ImageUtils.writePNG(bi);
            }
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] _$1(String picFile) {
        byte[] byArray;
        if (picFile == null || picFile.trim().length() == 0) {
            return null;
        }
        InputStream fis = null;
        try {
            File file = new File(picFile);
            if (file.exists()) {
                fis = new FileInputStream(picFile);
            } else {
                String[] paths = Env.getPaths();
                if (paths != null && paths.length > 0) {
                    file = new File(paths[0], picFile);
                    fis = new FileInputStream(file);
                }
            }
            if (fis == null) {
                byArray = null;
                return byArray;
            }
            byArray = AppUtil.getStreamBytes(fis);
        }
        catch (Exception e) {
            byArray = null;
            return byArray;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception e) {}
        }
        return byArray;
    }

    public static void drawBackGraph(Graphics2D g, ExtGraphProperty egp, int w, int h) {
        byte[] backImage;
        BackGraphConfig bgc = egp.getBackGraphConfig();
        if (bgc == null) {
            return;
        }
        byte[] b = StatisticGraph._$1(bgc.getValue());
        if (b != null) {
            bgc.setImageBytes(b);
        }
        if ((backImage = bgc.getImageBytes()) == null) {
            return;
        }
        Image image = new ImageIcon(backImage).getImage();
        g.drawImage(image, 1, 1, w, h, null);
    }
}

