/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.cellset.graph.draw;

import com.scudata.cellset.graph.draw.DrawBase;
import com.scudata.cellset.graph.draw.DrawLine;
import com.scudata.cellset.graph.draw.ExtGraphCategory;
import com.scudata.cellset.graph.draw.ExtGraphProperty;
import com.scudata.cellset.graph.draw.ExtGraphSery;
import com.scudata.cellset.graph.draw.GraphParam;
import com.scudata.cellset.graph.draw.ValueLabel;
import com.scudata.cellset.graph.draw.ValuePoint;
import com.scudata.chart.Utils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class Draw2Y2Line
extends DrawBase {
    public void draw(StringBuffer htmlLink) {
        Draw2Y2Line.drawing(this, htmlLink);
    }

    public static void drawing(DrawBase db, StringBuffer htmlLink) {
        double y;
        double x;
        GraphParam gp = db.gp;
        ExtGraphProperty egp = db.egp;
        Graphics2D g = db.g;
        ArrayList<ValueLabel> labelList = db.labelList;
        int VALUE_RADIUS = db.getPointRadius();
        ArrayList<ValuePoint> pointList = db.pointList;
        gp.coorWidth = 0;
        db.initGraphInset();
        db.createCoorValue();
        db.drawLegend(htmlLink);
        db.drawTitle();
        db.drawLabel();
        db.keepGraphSpace();
        db.adjustCoorInset();
        gp.graphRect = new Rectangle2D.Double(gp.leftInset, gp.topInset, gp.graphWidth - gp.leftInset - gp.rightInset, gp.graphHeight - gp.topInset - gp.bottomInset);
        if (gp.graphRect.width < 10.0 || gp.graphRect.height < 10.0) {
            return;
        }
        if (gp.coorWidth < 0 || gp.coorWidth > 10000) {
            gp.coorWidth = 0;
        }
        double seriesWidth = gp.graphRect.width * 1.0 / ((double)(gp.catNum + 1) * gp.categorySpan / 100.0 + (double)gp.coorWidth / 200.0 + (double)(gp.catNum * gp.serNum));
        double coorWidth = seriesWidth * 1.0 * ((double)gp.coorWidth / 200.0);
        double categorySpan = seriesWidth * 1.0 * (gp.categorySpan / 100.0);
        double tmpInt = (double)(gp.catNum + 1) * categorySpan + coorWidth + (double)(gp.catNum * gp.serNum) * seriesWidth;
        gp.graphRect.x += (gp.graphRect.width - tmpInt) / 2.0;
        gp.graphRect.width = tmpInt;
        double dely = (gp.graphRect.height - coorWidth) / (double)gp.tickNum * 1.0;
        tmpInt = dely * (double)gp.tickNum + coorWidth;
        gp.graphRect.y += (gp.graphRect.height - tmpInt) / 2.0;
        gp.graphRect.height = tmpInt;
        gp.gRect1 = (Rectangle2D.Double)gp.graphRect.clone();
        gp.gRect2 = (Rectangle2D.Double)gp.graphRect.clone();
        db.drawGraphRect();
        g.setStroke(new BasicStroke(1.0E-5f));
        for (int i = 0; i <= gp.tickNum; ++i) {
            db.drawGridLine(dely, i);
            Number coory = (Number)gp.coorValue.get(i);
            String scoory = db.getFormattedValue(coory.doubleValue());
            x = gp.gRect1.x - (double)gp.tickLen;
            y = gp.gRect1.y + gp.gRect1.height - (double)i * dely;
            gp.GFV_YLABEL.outText(x, y, scoory);
            if (coory.doubleValue() != gp.baseValue + gp.minValue) continue;
            gp.valueBaseLine = gp.gRect1.y + gp.gRect1.height - (double)i * dely;
        }
        db.drawWarnLine();
        Point2D.Double[] beginPoint = new Point2D.Double[gp.serNum];
        Point2D.Double[] lastPoint = new Point2D.Double[gp.serNum];
        ArrayList cats = egp.categories;
        int cc = cats.size();
        for (int i = 0; i < cc; ++i) {
            Color c;
            boolean vis;
            ExtGraphCategory egc = (ExtGraphCategory)cats.get(i);
            double posx = DrawLine.getPosX(gp, i, cc, categorySpan, seriesWidth);
            boolean valvis = i % (gp.graphXInterval + 1) == 0;
            boolean bl = vis = valvis && !gp.isDrawTable;
            if (vis) {
                c = egp.getAxisColor(1);
                Utils.setStroke(g, c, 1, 1.0f);
                db.drawLine(posx, gp.gRect1.y + gp.gRect1.height, posx, gp.gRect1.y + gp.gRect1.height + (double)gp.tickLen, c);
                db.drawGridLineCategoryV(posx);
            }
            String value = egc.getNameString();
            x = posx;
            y = gp.gRect1.y + gp.gRect1.height + (double)gp.tickLen;
            gp.GFV_XLABEL.outText(x, y, value, vis);
            for (int j = 0; j < gp.serNum; ++j) {
                boolean vis2;
                ExtGraphSery egs = egc.getExtGraphSery(gp.serNames.get(j));
                double val = egs.getValue();
                double tmp = val - gp.baseValue;
                double len = dely * (double)gp.tickNum * (tmp - gp.minValue) / (gp.maxValue * gp.coorScale);
                if (gp.isDrawTable) {
                    posx = db.getDataTableX(i);
                }
                Point2D.Double endPoint = egs.isNull() ? null : new Point2D.Double(posx, gp.valueBaseLine - len);
                if (gp.dispValueOntop && !egs.isNull() && valvis) {
                    String sval = db.getDispValue(egc, egs, gp.serNum);
                    x = endPoint.x;
                    y = endPoint.y;
                    c = !db.isMultiSeries() ? db.getColor(i) : db.getColor(j);
                    ValueLabel vl = new ValueLabel(sval, new Point2D.Double(x, y - (double)VALUE_RADIUS), c);
                    labelList.add(vl);
                }
                boolean bl2 = vis2 = i % (gp.graphXInterval + 1) == 0;
                if (!egs.isNull() && gp.drawLineDot && vis2) {
                    double ww;
                    double xx = endPoint.x - (double)VALUE_RADIUS;
                    double yy = endPoint.y - (double)VALUE_RADIUS;
                    double hh = ww = (double)(2 * VALUE_RADIUS);
                    Color backColor = !db.isMultiSeries() ? db.getColor(i) : db.getColor(j);
                    ValuePoint vp = new ValuePoint(endPoint, backColor, null, 2, -1);
                    pointList.add(vp);
                    db.htmlLink(xx, yy, ww, hh, htmlLink, egc.getNameString(), egs);
                }
                if (i > 0) {
                    g.setColor(db.getColor(j));
                    if (egp.isIgnoreNull()) {
                        db.drawLine(lastPoint[j], endPoint);
                    } else {
                        db.drawLine(beginPoint[j], endPoint);
                    }
                }
                beginPoint[j] = endPoint;
                if (endPoint == null) continue;
                lastPoint[j] = endPoint;
            }
        }
        db.drawLine(gp.gRect1.x, gp.valueBaseLine, gp.gRect1.x + gp.gRect1.width, gp.valueBaseLine, egp.getAxisColor(1));
        Draw2Y2Line.drawY2Line(db, gp.serNum, htmlLink);
        db.outPoints();
        db.outLabels();
    }

    public static void drawY2Line(DrawBase db, int series1Count, StringBuffer htmlLink) {
        double y;
        double x;
        int VALUE_RADIUS = db.getPointRadius();
        db.gp.graphRect = new Rectangle2D.Double(db.gp.leftInset, db.gp.topInset, db.gp.graphWidth - db.gp.leftInset - db.gp.rightInset, db.gp.graphHeight - db.gp.topInset - db.gp.bottomInset);
        if (db.gp.graphRect.width < 10.0 || db.gp.graphRect.height < 10.0) {
            return;
        }
        if (db.gp.coorWidth < 0 || db.gp.coorWidth > 10000) {
            db.gp.coorWidth = 0;
        }
        double seriesWidth = db.gp.graphRect.width / ((double)(db.gp.catNum + 1) * db.gp.categorySpan / 100.0 + (double)db.gp.coorWidth / 200.0 + (double)(db.gp.catNum * db.gp.serNum));
        double coorWidth = seriesWidth * ((double)db.gp.coorWidth / 200.0);
        double categorySpan = seriesWidth * (db.gp.categorySpan / 100.0);
        double tmpInt = (double)(db.gp.catNum + 1) * categorySpan + coorWidth + (double)(db.gp.catNum * db.gp.serNum) * seriesWidth;
        db.gp.graphRect.x += (db.gp.graphRect.width - tmpInt) / 2.0;
        db.gp.graphRect.width = tmpInt;
        double dely = (db.gp.graphRect.height - coorWidth) / (double)db.gp.tickNum2;
        tmpInt = dely * (double)db.gp.tickNum2 + coorWidth;
        db.gp.graphRect.y += (db.gp.graphRect.height - tmpInt) / 2.0;
        db.gp.graphRect.height = tmpInt;
        db.gp.gRect1 = (Rectangle2D.Double)db.gp.graphRect.clone();
        db.gp.gRect2 = (Rectangle2D.Double)db.gp.graphRect.clone();
        for (int i = 0; i <= db.gp.tickNum2; ++i) {
            double tmpi = db.gp.gRect1.y + db.gp.gRect1.height - (double)i * dely;
            db.g.setStroke(new BasicStroke(1.0f));
            db.drawLine(db.gp.gRect1.x + db.gp.gRect1.width - (double)db.gp.tickLen, tmpi, db.gp.gRect1.x + db.gp.gRect1.width, tmpi, db.egp.getAxisColor(3));
            Number coory = (Number)db.gp.coorValue2.get(i);
            String scoory = db.getFormattedValue(coory.doubleValue(), db.gp.dataMarkFormat2);
            x = db.gp.gRect1.x + db.gp.gRect1.width + (double)db.gp.tickLen;
            y = db.gp.gRect1.y + db.gp.gRect1.height - (double)i * dely;
            db.gp.GFV_YLABEL.outText(x, y, scoory, (byte)4);
            if (coory.doubleValue() != db.gp.baseValue2 + db.gp.minValue2) continue;
            db.gp.valueBaseLine = db.gp.gRect1.y + db.gp.gRect1.height - (double)i * dely;
        }
        db.g.setStroke(new BasicStroke(1.0E-5f));
        Point2D.Double[] beginPoint = new Point2D.Double[db.gp.serNames2.size()];
        Point2D.Double[] lastPoint = new Point2D.Double[db.gp.serNames2.size()];
        ArrayList cats2 = db.egp.category2;
        int cc = cats2.size();
        for (int i = 0; i < cc; ++i) {
            ExtGraphCategory egc = (ExtGraphCategory)cats2.get(i);
            for (int j = 0; j < db.gp.serNum2; ++j) {
                boolean vis2;
                boolean valvis;
                ExtGraphSery egs = egc.getExtGraphSery(db.gp.serNames2.get(j));
                double val = egs.getValue();
                double tmp = val - db.gp.baseValue2;
                double len = dely * (double)db.gp.tickNum2 * (tmp - db.gp.minValue2) / (db.gp.maxValue2 * db.gp.coorScale2);
                double posx = DrawLine.getPosX(db.gp, i, cc, categorySpan, seriesWidth);
                if (db.gp.isDrawTable) {
                    posx = db.getDataTableX(i);
                }
                Point2D.Double endPoint = egs.isNull() ? null : new Point2D.Double(posx, db.gp.valueBaseLine - len);
                boolean bl = valvis = i % (db.gp.graphXInterval + 1) == 0;
                if (db.gp.dispValueOntop2 && !egs.isNull() && valvis) {
                    String sval = db.getDispValue2(egc, egs, db.gp.serNum);
                    x = endPoint.x;
                    y = endPoint.y;
                    Color c = db.getColor(series1Count + j);
                    ValueLabel vl = new ValueLabel(sval, new Point2D.Double(x, y - (double)VALUE_RADIUS), c);
                    db.labelList.add(vl);
                }
                boolean bl2 = vis2 = i % (db.gp.graphXInterval + 1) == 0;
                if (!egs.isNull() && db.gp.drawLineDot && vis2) {
                    double ww;
                    double xx = endPoint.x - (double)VALUE_RADIUS;
                    double yy = endPoint.y - (double)VALUE_RADIUS;
                    double hh = ww = (double)(2 * VALUE_RADIUS);
                    Color backColor = !db.isMultiSeries() ? db.getColor(series1Count + i) : db.getColor(series1Count + j);
                    ValuePoint vp = new ValuePoint(endPoint, backColor);
                    db.pointList.add(vp);
                    db.htmlLink2(xx, yy, ww, hh, htmlLink, egc.getNameString(), egs);
                }
                if (i > 0) {
                    db.g.setColor(db.getColor(series1Count + j));
                    if (db.egp.isIgnoreNull()) {
                        db.drawLine(lastPoint[j], endPoint);
                    } else {
                        db.drawLine(beginPoint[j], endPoint);
                    }
                }
                beginPoint[j] = endPoint;
                if (endPoint == null) continue;
                lastPoint[j] = endPoint;
            }
        }
        db.drawLine(db.gp.gRect1.x, db.gp.valueBaseLine, db.gp.gRect1.x + db.gp.gRect1.width, db.gp.valueBaseLine, db.egp.getAxisColor(1));
    }
}

