/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.cellset.graph.draw;

import com.scudata.cellset.graph.draw.DrawBase;
import com.scudata.cellset.graph.draw.ExtGraphCategory;
import com.scudata.cellset.graph.draw.ExtGraphProperty;
import com.scudata.cellset.graph.draw.ExtGraphSery;
import com.scudata.cellset.graph.draw.GraphParam;
import com.scudata.cellset.graph.draw.ValueLabel;
import com.scudata.chart.Utils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class DrawBar
extends DrawBase {
    public void draw(StringBuffer htmlLink) {
        DrawBar.drawing(this, htmlLink);
    }

    public static void drawing(DrawBase db, StringBuffer htmlLink) {
        double y;
        double x;
        double seriesWidth;
        double categorySpan;
        GraphParam gp = db.gp;
        ExtGraphProperty egp = db.egp;
        Graphics2D g = db.g;
        ArrayList<ValueLabel> labelList = db.labelList;
        gp.coorWidth = 0;
        db.initGraphInset();
        db.createCoorValue();
        db.drawLegend(htmlLink);
        db.drawTitle();
        db.drawLabel();
        db.keepGraphSpace();
        db.adjustCoorInset();
        gp.graphRect = new Rectangle2D.Double(gp.leftInset, gp.topInset, gp.graphWidth - gp.leftInset - gp.rightInset, gp.graphHeight - gp.topInset - gp.bottomInset);
        if (gp.graphRect.width < 10.0 || gp.graphRect.height < 10.0) {
            return;
        }
        if (gp.coorWidth < 0 || gp.coorWidth > 10000) {
            gp.coorWidth = 0;
        }
        if (gp.barDistance > 0.0) {
            double maxCatSpan = (gp.graphRect.height - (double)((float)(gp.serNum * gp.catNum) * 1.0f)) / (double)((float)gp.catNum + 1.0f);
            categorySpan = gp.barDistance <= maxCatSpan ? gp.barDistance : maxCatSpan;
            seriesWidth = (gp.graphRect.height - (double)(gp.catNum + 1) * categorySpan) / (double)(gp.serNum * gp.catNum);
        } else {
            seriesWidth = gp.graphRect.height / ((double)(gp.catNum + 1) * gp.categorySpan / 100.0 + (double)(gp.catNum * gp.serNum));
            categorySpan = seriesWidth * (gp.categorySpan / 100.0);
        }
        double coorWidth = seriesWidth * ((double)gp.coorWidth / 200.0);
        double delx = (gp.graphRect.width - coorWidth) / (double)gp.tickNum;
        gp.gRect1 = (Rectangle2D.Double)gp.graphRect.clone();
        gp.gRect2 = (Rectangle2D.Double)gp.graphRect.clone();
        db.drawGraphRect();
        for (int i = 0; i <= gp.tickNum; ++i) {
            db.drawGridLineV(delx, i);
            Number coorx = (Number)gp.coorValue.get(i);
            String scoorx = db.getFormattedValue(coorx.doubleValue());
            x = gp.gRect1.x + (double)i * delx;
            y = gp.gRect1.y + gp.gRect1.height + (double)gp.tickLen;
            gp.GFV_XLABEL.outText(x, y, scoorx);
            if (coorx.doubleValue() != gp.baseValue + gp.minValue) continue;
            gp.valueBaseLine = gp.gRect1.x + (double)i * delx;
        }
        db.drawWarnLineH();
        ArrayList cats = egp.categories;
        int cc = cats.size();
        Color bc = egp.getAxisColor(5);
        int bs = 1;
        float bw = 1.0f;
        for (int i = 0; i < cc; ++i) {
            Color c;
            boolean vis;
            ExtGraphCategory egc = (ExtGraphCategory)cats.get(i);
            double dely = (double)(i + 1) * categorySpan + (double)i * seriesWidth * (double)gp.serNum + seriesWidth * (double)gp.serNum / 2.0;
            boolean bl = vis = i % (gp.graphXInterval + 1) == 0;
            if (vis) {
                c = egp.getAxisColor(2);
                Utils.setStroke(g, c, 1, 1.0f);
                db.drawLine(gp.gRect1.x, gp.gRect1.y + gp.gRect1.height - dely, gp.gRect1.x - (double)gp.tickLen, gp.gRect1.y + gp.gRect1.height - dely, c);
                db.drawGridLineCategory(gp.gRect1.y + dely);
            }
            String scoory = egc.getNameString();
            x = gp.gRect1.x - (double)gp.tickLen;
            y = gp.gRect1.y + dely;
            gp.GFV_YLABEL.outText(x, y, scoory, vis);
            for (int j = 0; j < gp.serNum; ++j) {
                ExtGraphSery egs = egc.getExtGraphSery(gp.serNames.get(j));
                if (egs.isNull()) continue;
                double val = egs.getValue();
                double len = 0.0;
                double tmp = val - gp.baseValue;
                len = delx * (double)gp.tickNum * (tmp - gp.minValue) / (gp.maxValue * gp.coorScale);
                double lb = gp.gRect1.y + (double)(i + 1) * categorySpan + (double)(i * gp.serNum + j + 1) * seriesWidth;
                int cIndex = !gp.isMultiSeries ? i : j;
                Color tmpc = db.getColor(cIndex);
                if (len >= 0.0) {
                    Utils.draw2DRect(g, gp.valueBaseLine, lb - seriesWidth, len, seriesWidth, bc, bs, bw, egp.isDrawShade(), egp.isRaisedBorder(), db.getTransparent(), db.getChartColor(tmpc), false);
                    db.htmlLink(gp.valueBaseLine, lb - seriesWidth, len, seriesWidth, htmlLink, egc.getNameString(), egs);
                } else {
                    Utils.draw2DRect(g, gp.valueBaseLine + len, lb - seriesWidth, Math.abs(len), seriesWidth, bc, bs, bw, egp.isDrawShade(), egp.isRaisedBorder(), db.getTransparent(), db.getChartColor(tmpc), false);
                    db.htmlLink(gp.valueBaseLine + len, lb - seriesWidth, Math.abs(len), seriesWidth, htmlLink, egc.getNameString(), egs);
                }
                if (!gp.dispValueOntop || egs.isNull() || !vis) continue;
                String sval = db.getDispValue(egc, egs, gp.serNum);
                y = lb - seriesWidth / 2.0;
                len = len < 0.0 ? (len -= 3.0) : (len += 3.0);
                x = gp.valueBaseLine + len;
                c = !gp.isMultiSeries ? db.getColor(i) : db.getColor(j);
                ValueLabel vl = len < 0.0 ? new ValueLabel(sval, new Point2D.Double(x, y), c, 3) : new ValueLabel(sval, new Point2D.Double(x, y), c, 4);
                labelList.add(vl);
            }
        }
        db.outLabels();
        db.drawLine(gp.valueBaseLine, gp.gRect1.y, gp.valueBaseLine, gp.gRect1.y + gp.gRect1.height, egp.getAxisColor(1));
        db.drawLine(gp.valueBaseLine, gp.gRect1.y, gp.valueBaseLine + coorWidth, gp.gRect1.y - coorWidth, egp.getAxisColor(1));
    }
}

