/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.cellset.graph.draw;

import com.scudata.cellset.graph.draw.DrawBase;
import com.scudata.cellset.graph.draw.ExtGraphCategory;
import com.scudata.cellset.graph.draw.ExtGraphProperty;
import com.scudata.cellset.graph.draw.ExtGraphSery;
import com.scudata.cellset.graph.draw.GraphParam;
import com.scudata.cellset.graph.draw.ValueLabel;
import com.scudata.chart.ChartColor;
import com.scudata.chart.Utils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class DrawBar3DObj
extends DrawBase {
    public void draw(StringBuffer htmlLink) {
        DrawBar3DObj.drawing(this, htmlLink);
    }

    public static void drawing(DrawBase db, StringBuffer htmlLink) {
        double seriesWidth;
        double categorySpan;
        GraphParam gp = db.gp;
        ExtGraphProperty egp = db.egp;
        Graphics2D g = db.g;
        ArrayList<ValueLabel> labelList = db.labelList;
        db.initGraphInset();
        db.createCoorValue();
        db.drawLegend(htmlLink);
        db.drawTitle();
        db.drawLabel();
        db.keepGraphSpace();
        db.adjustCoorInset();
        gp.graphRect = new Rectangle2D.Double(gp.leftInset, gp.topInset, gp.graphWidth - gp.leftInset - gp.rightInset, gp.graphHeight - gp.topInset - gp.bottomInset);
        if (gp.graphRect.width < 10.0 || gp.graphRect.height < 10.0) {
            return;
        }
        if (gp.coorWidth < 0 || gp.coorWidth > 10000) {
            gp.coorWidth = 0;
        }
        if (gp.barDistance > 0.0) {
            double maxCatSpan = (gp.graphRect.height - (double)((float)(gp.serNum * gp.catNum) * 1.0f)) / (double)((float)gp.catNum + 1.0f);
            categorySpan = gp.barDistance <= maxCatSpan ? gp.barDistance : maxCatSpan;
            seriesWidth = (gp.graphRect.height - (double)(gp.catNum + 1) * categorySpan) / (double)(gp.serNum * gp.catNum);
        } else {
            seriesWidth = gp.graphRect.height / ((double)(gp.catNum + 1) * gp.categorySpan / 100.0 + (double)gp.coorWidth / 200.0 + (double)(gp.catNum * gp.serNum));
            categorySpan = seriesWidth * (gp.categorySpan / 100.0);
        }
        double coorWidth = seriesWidth * ((double)gp.coorWidth / 200.0);
        double tmpInt = (double)(gp.catNum + 1) * categorySpan + coorWidth + (double)(gp.catNum * gp.serNum) * seriesWidth;
        gp.graphRect.y += (gp.graphRect.height - tmpInt) / 2.0;
        gp.graphRect.height = tmpInt;
        double delx = (gp.graphRect.width - coorWidth) / (double)gp.tickNum;
        tmpInt = delx * (double)gp.tickNum + coorWidth;
        gp.graphRect.x += (gp.graphRect.width - tmpInt) / 2.0;
        gp.graphRect.width = tmpInt;
        gp.gRect1 = (Rectangle2D.Double)gp.graphRect.clone();
        gp.gRect2 = (Rectangle2D.Double)gp.graphRect.clone();
        gp.gRect1.y += coorWidth;
        gp.gRect1.width -= coorWidth;
        gp.gRect1.height -= coorWidth;
        gp.gRect2.x += coorWidth;
        gp.gRect2.width -= coorWidth;
        gp.gRect2.height -= coorWidth;
        db.drawGraphRect();
        for (int i = 0; i <= gp.tickNum; ++i) {
            db.drawGridLineV(delx, i);
            Number coorx = (Number)gp.coorValue.get(i);
            String scoorx = db.getFormattedValue(coorx.doubleValue());
            Point2D.Double p = db._$2((double)i * delx);
            gp.GFV_XLABEL.outText(p.x, p.y + (double)gp.tickLen, scoorx);
            if (coorx.doubleValue() != gp.baseValue + gp.minValue) continue;
            gp.valueBaseLine = gp.gRect1.x + (double)i * delx;
        }
        db.drawWarnLineH();
        ArrayList cats = egp.categories;
        int cc = cats.size();
        for (int i = cc - 1; i >= 0; --i) {
            Color c;
            ExtGraphCategory egc = (ExtGraphCategory)cats.get(i);
            double dely = (double)(i + 1) * categorySpan + (double)i * seriesWidth * (double)gp.serNum + seriesWidth * (double)gp.serNum / 2.0;
            boolean vis = i % (gp.graphXInterval + 1) == 0;
            Point2D.Double p = db._$3(dely);
            if (vis) {
                c = egp.getAxisColor(2);
                Utils.setStroke(g, c, 1, 1.0f);
                db.drawLine(p.x - (double)gp.tickLen, p.y, p.x, p.y, c);
                db.drawGridLineCategory(gp.gRect2.y + dely);
            }
            String value = egc.getNameString();
            double x = gp.gRect1.x - (double)gp.tickLen;
            double y = gp.gRect1.y + dely;
            gp.GFV_YLABEL.outText(x, y, value, vis);
            for (int j = gp.serNum - 1; j >= 0; --j) {
                double hh;
                double ww;
                double yy;
                double xx;
                ExtGraphSery egs = egc.getExtGraphSery(gp.serNames.get(j));
                if (egs.isNull()) continue;
                double len = 0.0;
                double orginLen = 0.0;
                double val = egs.getValue();
                double tmp = val - gp.baseValue;
                orginLen = len = delx * (double)gp.tickNum * (tmp - gp.minValue) / (gp.maxValue * gp.coorScale);
                double lb = gp.gRect1.y + (double)(i + 1) * categorySpan + (double)(i * gp.serNum + j + 1) * seriesWidth;
                ChartColor chartColor = !gp.isMultiSeries ? db.getChartColor(db.getColor(i)) : db.getChartColor(db.getColor(j));
                if (len >= 0.0) {
                    xx = gp.valueBaseLine;
                    yy = lb - seriesWidth;
                    ww = len;
                    hh = seriesWidth;
                } else {
                    xx = gp.valueBaseLine + len;
                    yy = lb - seriesWidth;
                    ww = Math.abs(len);
                    hh = seriesWidth;
                }
                Color bc = null;
                int bs = 0;
                float bw = 0.0f;
                double coorShift = coorWidth;
                Utils.draw3DRect(g, xx, yy, ww, hh, bc, bs, bw, egp.isDrawShade(), egp.isRaisedBorder(), db.getTransparent(), chartColor, !egp.isBarGraph(db), coorShift);
                db.htmlLink(xx, yy, ww, hh, htmlLink, egc.getNameString(), egs);
                if (!gp.dispValueOntop || egs.isNull() || !vis) continue;
                String sval = db.getDispValue(egc, egs, gp.serNum);
                y = lb - seriesWidth / 2.0;
                orginLen = orginLen < 0.0 ? (orginLen -= 3.0) : (orginLen += 3.0);
                x = gp.valueBaseLine + orginLen;
                c = !gp.isMultiSeries ? db.getColor(i) : db.getColor(j);
                ValueLabel vl = orginLen < 0.0 ? new ValueLabel(sval, new Point2D.Double(x, y), c, 3) : new ValueLabel(sval, new Point2D.Double(x, y), c, 4);
                labelList.add(vl);
            }
            if (!gp.graphTransparent) continue;
            g.setComposite(AlphaComposite.getInstance(3, 1.0f));
        }
        db.outLabels();
        if (gp.valueBaseLine != gp.gRect1.x) {
            db.drawLine(gp.valueBaseLine, gp.gRect1.y, gp.valueBaseLine, gp.gRect1.y + gp.gRect1.height, egp.getAxisColor(1));
            db.drawLine(gp.valueBaseLine, gp.gRect1.y, gp.valueBaseLine + coorWidth, gp.gRect1.y - coorWidth, egp.getAxisColor(1));
        }
    }
}

