/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.cellset.graph.draw;

import com.scudata.cellset.graph.draw.DrawBase;
import com.scudata.cellset.graph.draw.ExtGraphCategory;
import com.scudata.cellset.graph.draw.ExtGraphProperty;
import com.scudata.cellset.graph.draw.ExtGraphSery;
import com.scudata.cellset.graph.draw.GraphParam;
import com.scudata.cellset.graph.draw.ValueLabel;
import com.scudata.chart.Utils;
import com.scudata.common.StringUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Vector;

public class DrawBarStacked
extends DrawBase {
    public void draw(StringBuffer htmlLink) {
        DrawBarStacked.drawing(this, htmlLink);
    }

    public static void drawing(DrawBase db, StringBuffer htmlLink) {
        double y;
        double x;
        double seriesWidth;
        double categorySpan;
        GraphParam gp = db.gp;
        ExtGraphProperty egp = db.egp;
        Graphics2D g = db.g;
        gp.maxValue = gp.maxPositive;
        gp.minValue = gp.minNegative;
        gp.coorWidth = 0;
        db.initGraphInset();
        db.createCoorValue();
        db.drawLegend(htmlLink);
        db.drawTitle();
        db.drawLabel();
        db.keepGraphSpace();
        db.adjustCoorInset();
        gp.graphRect = new Rectangle2D.Double(gp.leftInset, gp.topInset, gp.graphWidth - gp.leftInset - gp.rightInset, gp.graphHeight - gp.topInset - gp.bottomInset);
        if (gp.graphRect.width < 10.0 || gp.graphRect.height < 10.0) {
            return;
        }
        if (gp.coorWidth < 0 || gp.coorWidth > 10000) {
            gp.coorWidth = 0;
        }
        int serNum = 1;
        if (egp.category2 != null) {
            serNum = 2;
        }
        if (gp.barDistance > 0.0) {
            double maxCatSpan = (gp.graphRect.height - (double)((float)(serNum * gp.catNum) * 1.0f)) / (double)((float)gp.catNum + 1.0f);
            categorySpan = gp.barDistance <= maxCatSpan ? gp.barDistance : maxCatSpan;
            seriesWidth = (gp.graphRect.height - (double)(gp.catNum + 1) * categorySpan) / (double)(serNum * gp.catNum);
        } else {
            seriesWidth = gp.graphRect.height / ((double)(gp.catNum + 1) * gp.categorySpan / 100.0 + (double)(gp.coorWidth / 200) + (double)(gp.catNum * serNum));
            categorySpan = seriesWidth * (gp.categorySpan / 100.0);
        }
        double coorWidth = seriesWidth * ((double)gp.coorWidth / 200.0);
        double delx = (gp.graphRect.width - coorWidth) / (double)gp.tickNum;
        gp.gRect1 = (Rectangle2D.Double)gp.graphRect.clone();
        gp.gRect2 = (Rectangle2D.Double)gp.graphRect.clone();
        db.drawGraphRect();
        for (int i = 0; i <= gp.tickNum; ++i) {
            db.drawGridLineV(delx, i);
            Number coorx = (Number)gp.coorValue.get(i);
            String scoorx = db.getFormattedValue(coorx.doubleValue());
            x = gp.gRect1.x + (double)i * delx;
            y = gp.gRect1.y + gp.gRect1.height + (double)gp.tickLen;
            gp.GFV_XLABEL.outText(x, y, scoorx);
            if (coorx.doubleValue() != gp.baseValue + gp.minValue) continue;
            gp.valueBaseLine = gp.gRect1.x + (double)i * delx;
        }
        db.drawWarnLineH();
        ArrayList cats = egp.categories;
        int cc = cats.size();
        for (int i = 0; i < cc; ++i) {
            double lb;
            boolean vis;
            ExtGraphCategory egc = (ExtGraphCategory)cats.get(i);
            double dely = (double)(i + 1) * categorySpan + (double)i * seriesWidth * (double)serNum + seriesWidth * (double)serNum / 2.0;
            boolean bl = vis = i % (gp.graphXInterval + 1) == 0;
            if (vis) {
                Color c = egp.getAxisColor(2);
                Utils.setStroke(g, c, 1, 1.0f);
                db.drawLine(gp.gRect1.x, gp.gRect1.y + gp.gRect1.height - dely, gp.gRect1.x - (double)gp.tickLen, gp.gRect1.y + gp.gRect1.height - dely, c);
                db.drawGridLineCategory(gp.gRect1.y + dely);
            }
            String value = egc.getNameString();
            x = gp.gRect1.x - (double)gp.tickLen;
            y = gp.gRect1.y + dely;
            gp.GFV_YLABEL.outText(x, y, value, vis);
            double positiveBase = gp.valueBaseLine;
            double negativeBase = gp.valueBaseLine;
            if (egp.category2 == null) {
                lb = gp.gRect1.y + (double)(i + 1) * categorySpan + (double)i * seriesWidth;
                DrawBarStacked._$1(0, gp.serNames, egc, delx, db, lb, positiveBase, seriesWidth, htmlLink, negativeBase, coorWidth, vis);
                continue;
            }
            lb = gp.gRect1.y + (double)(i + 1) * categorySpan + (double)(i * serNum + 0) * seriesWidth;
            DrawBarStacked._$1(0, gp.serNames, egc, delx, db, lb, positiveBase, seriesWidth, htmlLink, negativeBase, coorWidth, vis);
            lb = gp.gRect1.y + (double)(i + 1) * categorySpan + (double)(i * serNum + 1) * seriesWidth;
            egc = (ExtGraphCategory)egp.category2.get(i);
            DrawBarStacked._$1(gp.serNames.size(), gp.serNames2, egc, delx, db, lb, positiveBase, seriesWidth, htmlLink, negativeBase, coorWidth, vis);
        }
        db.outLabels();
        db.drawLine(gp.valueBaseLine, gp.gRect1.y, gp.valueBaseLine, gp.gRect1.y + gp.gRect1.height, egp.getAxisColor(1));
    }

    private static void _$1(int serNumBase, Vector serNames, ExtGraphCategory egc, double delx, DrawBase db, double dlb, double positiveBase, double seriesWidth, StringBuffer htmlLink, double negativeBase, double coorWidth, boolean vis) {
        double val;
        GraphParam gp = db.gp;
        ExtGraphProperty egp = db.egp;
        Graphics2D g = db.g;
        ArrayList<ValueLabel> labelList = db.labelList;
        double lb = Math.round(dlb);
        int bs = 1;
        float bw = 1.0f;
        int serNum = serNames.size();
        for (int j = 0; j < serNum; ++j) {
            String sval;
            double tmp;
            double len;
            ExtGraphSery egs = egc.getExtGraphSery(serNames.get(j));
            if (egs.isNull() || (len = delx * (double)gp.tickNum * ((tmp = (val = egs.getValue()) - gp.baseValue) - gp.minValue) / (gp.maxValue * gp.coorScale)) == 0.0) continue;
            Color bc = egp.getAxisColor(5);
            Color tmpc = db.getColor(j + serNumBase);
            if (len > 0.0) {
                Utils.draw2DRect(g, positiveBase, lb, len, seriesWidth, bc, bs, bw, egp.isDrawShade(), egp.isRaisedBorder(), db.getTransparent(), db.getChartColor(tmpc), false);
                db.htmlLink(positiveBase, lb, len, seriesWidth, htmlLink, egc.getNameString(), egs);
            } else {
                Utils.draw2DRect(g, negativeBase + len, lb, Math.abs(len), seriesWidth, bc, bs, bw, egp.isDrawShade(), egp.isRaisedBorder(), db.getTransparent(), db.getChartColor(tmpc), false);
                db.htmlLink(negativeBase + len, lb, Math.abs(len), seriesWidth, htmlLink, egc.getNameString(), egs);
            }
            ValueLabel vl = null;
            String percentFmt = null;
            if (vis && (gp.dispValueType == 3 || gp.dispValueType == 6)) {
                percentFmt = StringUtils.isValidString(gp.dataMarkFormat) ? gp.dataMarkFormat : "0.00%";
            }
            double y = lb + seriesWidth / 2.0;
            if (len > 0.0) {
                sval = null;
                if (percentFmt != null) {
                    sval = db.getFormattedValue(egs.getValue() / egc.getPositiveSumSeries(), percentFmt);
                    if (egc != null && gp.dispValueType == 6) {
                        sval = DrawBarStacked.getDispName(egc, egs, serNum) + "," + sval;
                    }
                } else if (egc != null && gp.dispValueType != 1) {
                    sval = db.getDispValue(egc, egs, gp.serNum);
                }
                if (StringUtils.isValidString(sval)) {
                    vl = new ValueLabel(sval, new Point2D.Double(positiveBase + len / 2.0, y), gp.GFV_VALUE.color, 5);
                }
                positiveBase += len;
            } else {
                sval = null;
                if (percentFmt != null) {
                    sval = db.getFormattedValue(egs.getValue() / egc.getNegativeSumSeries(), percentFmt);
                    if (egc != null && gp.dispValueType == 6) {
                        sval = DrawBarStacked.getDispName(egc, egs, serNum) + "," + sval;
                    }
                } else if (egc != null && gp.dispValueType != 1) {
                    sval = db.getDispValue(egc, egs, gp.serNum);
                }
                if (StringUtils.isValidString(sval)) {
                    vl = new ValueLabel(sval, new Point2D.Double(negativeBase + len / 2.0, y), gp.GFV_VALUE.color, 5);
                }
                negativeBase += len;
            }
            if (vl == null) continue;
            labelList.add(vl);
        }
        double y = lb + seriesWidth / 2.0;
        if (gp.dispStackSumValue && vis) {
            double x;
            val = db.getScaledValue(egc.getPositiveSumSeries(), true);
            ValueLabel vl = null;
            if (val > 0.0) {
                String sval = db.getFormattedValue(val);
                x = positiveBase + 3.0;
                vl = new ValueLabel(sval, new Point2D.Double(x, y), gp.GFV_VALUE.color, 4);
            }
            if ((val = db.getScaledValue(egc.getNegativeSumSeries(), true)) < 0.0) {
                String sval = db.getFormattedValue(val);
                x = negativeBase - 3.0;
                vl = new ValueLabel(sval, new Point2D.Double(x, y), gp.GFV_VALUE.color, 3);
            }
            if (vl != null) {
                labelList.add(vl);
            }
        }
    }
}

