/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.cellset.graph.draw;

import com.scudata.cellset.graph.draw.Desc3DRect;
import com.scudata.cellset.graph.draw.DrawBase;
import com.scudata.cellset.graph.draw.ExtGraphCategory;
import com.scudata.cellset.graph.draw.ExtGraphProperty;
import com.scudata.cellset.graph.draw.ExtGraphSery;
import com.scudata.cellset.graph.draw.GraphParam;
import com.scudata.cellset.graph.draw.ValueLabel;
import com.scudata.chart.ChartColor;
import com.scudata.chart.Utils;
import com.scudata.common.StringUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawBarStacked3DObj
extends DrawBase {
    @Override
    public void draw(StringBuffer htmlLink) {
        DrawBarStacked3DObj.drawing(this, htmlLink);
    }

    public static void drawing(DrawBase db, StringBuffer htmlLink) {
        double lb2;
        double lb;
        double y;
        double x;
        String value;
        Color c;
        int i;
        double seriesWidth;
        double categorySpan;
        GraphParam gp = db.gp;
        ExtGraphProperty egp = db.egp;
        Graphics2D g = db.g;
        gp.maxValue = gp.maxPositive;
        gp.minValue = gp.minNegative;
        db.initGraphInset();
        db.createCoorValue();
        db.drawLegend(htmlLink);
        db.drawTitle();
        db.drawLabel();
        db.keepGraphSpace();
        db.adjustCoorInset();
        gp.graphRect = new Rectangle2D.Double(gp.leftInset, gp.topInset, gp.graphWidth - gp.leftInset - gp.rightInset, gp.graphHeight - gp.topInset - gp.bottomInset);
        if (gp.graphRect.width < 10.0 || gp.graphRect.height < 10.0) {
            return;
        }
        if (gp.coorWidth < 0 || gp.coorWidth > 10000) {
            gp.coorWidth = 0;
        }
        int serNum = 1;
        if (egp.category2 != null) {
            serNum = 2;
        }
        if (gp.barDistance > 0.0) {
            double maxCatSpan = (gp.graphRect.height - (double)((float)(serNum * gp.catNum) * 1.0f)) / (double)((float)gp.catNum + 1.0f);
            categorySpan = gp.barDistance <= maxCatSpan ? gp.barDistance : maxCatSpan;
            seriesWidth = (gp.graphRect.height - (double)(gp.catNum + 1) * categorySpan) / (double)(serNum * gp.catNum);
        } else {
            seriesWidth = gp.graphRect.height / ((double)(gp.catNum + 1) * gp.categorySpan / 100.0 + (double)gp.coorWidth / 200.0 + (double)(gp.catNum * serNum));
            categorySpan = seriesWidth * (gp.categorySpan / 100.0);
        }
        double coorWidth = seriesWidth * ((double)gp.coorWidth / 200.0);
        double tmpInt = (double)(gp.catNum + 1) * categorySpan + coorWidth + (double)(gp.catNum * serNum) * seriesWidth;
        gp.graphRect.y += (gp.graphRect.height - tmpInt) / 2.0;
        gp.graphRect.height = tmpInt;
        double delx = (gp.graphRect.width - coorWidth) / (double)gp.tickNum;
        tmpInt = delx * (double)gp.tickNum + coorWidth;
        gp.graphRect.x += (gp.graphRect.width - tmpInt) / 2.0;
        gp.graphRect.width = tmpInt;
        gp.gRect1 = (Rectangle2D.Double)gp.graphRect.clone();
        gp.gRect2 = (Rectangle2D.Double)gp.graphRect.clone();
        gp.gRect1.y += coorWidth;
        gp.gRect1.width -= coorWidth;
        gp.gRect1.height -= coorWidth;
        gp.gRect2.x += coorWidth;
        gp.gRect2.width -= coorWidth;
        gp.gRect2.height -= coorWidth;
        db.drawGraphRect();
        for (int i2 = 0; i2 <= gp.tickNum; ++i2) {
            db.drawGridLineV(delx, i2);
            Number coorx = (Number)gp.coorValue.get(i2);
            String scoorx = db.getFormattedValue(coorx.doubleValue());
            Point2D.Double p = db._$2((double)i2 * delx);
            gp.GFV_XLABEL.outText(p.x, p.y + (double)gp.tickLen, scoorx);
            if (coorx.doubleValue() != gp.baseValue + gp.minValue) continue;
            gp.valueBaseLine = gp.gRect1.x + (double)i2 * delx;
        }
        ArrayList<Desc3DRect> negativeRects = new ArrayList<Desc3DRect>();
        ArrayList cats = egp.categories;
        int cc = cats.size();
        for (i = 0; i < cc; ++i) {
            boolean vis;
            double dely = (double)(i + 1) * categorySpan + (double)i * seriesWidth * (double)serNum + seriesWidth * (double)serNum / 2.0;
            boolean bl = vis = i % (gp.graphXInterval + 1) == 0;
            if (!vis) continue;
            double yy = gp.gRect2.y + dely;
            db.drawGridLineCategory(yy);
        }
        if (gp.minNegative < 0.0) {
            for (i = 0; i < cc; ++i) {
                ExtGraphCategory egc = (ExtGraphCategory)cats.get(i);
                double dely = (double)(i + 1) * categorySpan + (double)i * seriesWidth * (double)serNum + seriesWidth * (double)serNum / 2.0;
                boolean vis = i % (gp.graphXInterval + 1) == 0;
                Point2D.Double p = db._$3(dely);
                if (vis) {
                    c = egp.getAxisColor(2);
                    Utils.setStroke(g, c, 1, 1.0f);
                    db.drawLine(p.x - (double)gp.tickLen, p.y, p.x, p.y, c);
                }
                value = egc.getNameString();
                x = gp.gRect1.x - (double)gp.tickLen;
                y = gp.gRect1.y + dely;
                gp.GFV_YLABEL.outText(x, y, value, vis);
                if (gp.graphTransparent) {
                    g.setComposite(AlphaComposite.getInstance(3, 0.6f));
                }
                double negativeBase = gp.valueBaseLine;
                lb = gp.gRect1.y + (double)(i + 1) * categorySpan + (double)(i * serNum + 0) * seriesWidth;
                if (egp.category2 == null) {
                    DrawBarStacked3DObj._$1(0, gp.serNames, egc, delx, db, lb, seriesWidth, htmlLink, negativeBase, coorWidth, vis, negativeRects);
                    continue;
                }
                lb2 = gp.gRect1.y + (double)(i + 1) * categorySpan + (double)(i * serNum + 1) * seriesWidth;
                egc = (ExtGraphCategory)egp.category2.get(i);
                DrawBarStacked3DObj._$1(gp.serNames.size(), gp.serNames2, egc, delx, db, lb2, seriesWidth, htmlLink, negativeBase, coorWidth, vis, negativeRects);
                egc = (ExtGraphCategory)cats.get(i);
                DrawBarStacked3DObj._$1(0, gp.serNames, egc, delx, db, lb, seriesWidth, htmlLink, negativeBase, coorWidth, vis, negativeRects);
            }
            for (i = negativeRects.size() - 1; i >= 0; --i) {
                Desc3DRect d3 = (Desc3DRect)negativeRects.get(i);
                Utils.draw3DRect(g, d3);
            }
        }
        db.drawLine(gp.valueBaseLine, gp.gRect1.y, gp.valueBaseLine, gp.gRect1.y + gp.gRect1.height, egp.getAxisColor(1));
        if (gp.valueBaseLine != gp.gRect1.x) {
            double[] xx = new double[]{gp.valueBaseLine, gp.valueBaseLine + coorWidth, gp.valueBaseLine + coorWidth, gp.valueBaseLine};
            double[] yy = new double[]{gp.gRect1.y, gp.gRect1.y - coorWidth, gp.gRect1.y + gp.gRect1.height - coorWidth, gp.gRect1.y + gp.gRect1.height};
            Shape poly = Utils.newPolygon2D(xx, yy);
            Color ccc = egp.getAxisColor(1);
            if (ccc == null) {
                ccc = Color.lightGray;
            }
            float trans = 1.0f;
            if (gp.graphTransparent) {
                trans = 0.4f;
            }
            Utils.fill(g, poly, trans, ccc);
        }
        db.drawWarnLineH();
        for (int i3 = cc - 1; i3 >= 0; --i3) {
            ExtGraphCategory egc = (ExtGraphCategory)cats.get(i3);
            double dely = (double)(i3 + 1) * categorySpan + (double)i3 * seriesWidth * (double)serNum + seriesWidth * (double)serNum / 2.0;
            boolean vis = i3 % (gp.graphXInterval + 1) == 0;
            Point2D.Double p = db._$3(dely);
            if (vis) {
                c = egp.getAxisColor(2);
                Utils.setStroke(g, c, 1, 1.0f);
                db.drawLine(p.x - (double)gp.tickLen, p.y, p.x, p.y, c);
            }
            value = egc.getNameString();
            x = gp.gRect1.x - (double)gp.tickLen;
            y = gp.gRect1.y + dely;
            gp.GFV_YLABEL.outText(x, y, value, vis);
            if (gp.graphTransparent) {
                g.setComposite(AlphaComposite.getInstance(3, 0.6f));
            }
            double positiveBase = gp.valueBaseLine;
            lb = gp.gRect1.y + (double)(i3 + 1) * categorySpan + (double)(i3 * serNum + 0) * seriesWidth;
            if (egp.category2 == null) {
                DrawBarStacked3DObj._$1(0, gp.serNames, egc, delx, db, lb, positiveBase, seriesWidth, htmlLink, coorWidth, vis);
                continue;
            }
            lb2 = gp.gRect1.y + (double)(i3 + 1) * categorySpan + (double)(i3 * serNum + 1) * seriesWidth;
            egc = (ExtGraphCategory)egp.category2.get(i3);
            DrawBarStacked3DObj._$1(gp.serNames.size(), gp.serNames2, egc, delx, db, lb2, positiveBase, seriesWidth, htmlLink, coorWidth, vis);
            egc = (ExtGraphCategory)cats.get(i3);
            DrawBarStacked3DObj._$1(0, gp.serNames, egc, delx, db, lb, positiveBase, seriesWidth, htmlLink, coorWidth, vis);
        }
        db.outLabels();
        if (gp.valueBaseLine != gp.gRect1.x) {
            db.drawLine(gp.valueBaseLine, gp.gRect1.y, gp.valueBaseLine, gp.gRect1.y + gp.gRect1.height, egp.getAxisColor(1));
        }
    }

    private static void _$1(int serNumBase, Vector serNames, ExtGraphCategory egc, double delx, DrawBase db, double dlb, double seriesWidth, StringBuffer htmlLink, double negativeBase, double coorWidth, boolean vis, ArrayList<Desc3DRect> negativeRects) {
        GraphParam gp = db.gp;
        ExtGraphProperty egp = db.egp;
        Graphics2D g = db.g;
        ArrayList<ValueLabel> labelList = db.labelList;
        double lb = Math.round(dlb);
        int bs = 1;
        float bw = 1.0f;
        int serNum = serNames.size();
        for (int j = 0; j < serNum; ++j) {
            double val;
            double tmp;
            double len;
            ExtGraphSery egs = egc.getExtGraphSery(serNames.get(j));
            if (egs.isNull() || (len = delx * (double)gp.tickNum * ((tmp = (val = egs.getValue()) - gp.baseValue) - gp.minValue) / (gp.maxValue * gp.coorScale)) == 0.0) continue;
            ChartColor chartColor = db.getChartColor(db.getColor(j + serNumBase));
            if (len >= 0.0) continue;
            double xx = negativeBase + len;
            double yy = lb;
            double ww = Math.abs(len);
            double hh = seriesWidth;
            Color bc = egp.getAxisColor(5);
            double coorShift = coorWidth;
            negativeRects.add(Utils.get3DRect(xx, yy, ww, hh, bc, bs, bw, egp.isDrawShade(), egp.isRaisedBorder(), db.getTransparent(), chartColor, true, coorShift));
            db.htmlLink(xx, yy, ww, hh, htmlLink, egc.getNameString(), egs);
            ValueLabel vl = null;
            String percentFmt = null;
            if (vis && (gp.dispValueType == 3 || gp.dispValueType == 6)) {
                percentFmt = StringUtils.isValidString(gp.dataMarkFormat) ? gp.dataMarkFormat : "0.00%";
            }
            if (!(len > 0.0)) {
                String sval = null;
                if (percentFmt != null) {
                    sval = db.getFormattedValue(egs.getValue() / egc.getNegativeSumSeries(), percentFmt);
                    if (egc != null && gp.dispValueType == 6) {
                        sval = DrawBarStacked3DObj.getDispName(egc, egs, serNum) + "," + sval;
                    }
                } else if (egc != null && gp.dispValueType != 1) {
                    sval = db.getDispValue(egc, egs, gp.serNum);
                }
                if (StringUtils.isValidString(sval)) {
                    vl = new ValueLabel(sval, new Point2D.Double(negativeBase + len / 2.0, lb + seriesWidth / 2.0), gp.GFV_VALUE.color, 5);
                }
                negativeBase += len;
            }
            if (vl == null) continue;
            labelList.add(vl);
        }
        if (gp.graphTransparent) {
            g.setComposite(AlphaComposite.getInstance(3, 1.0f));
        }
        if (gp.dispValueOntop && vis) {
            double val = db.getScaledValue(egc.getPositiveSumSeries(), true);
            ValueLabel vl = null;
            val = db.getScaledValue(egc.getNegativeSumSeries(), true);
            if (val < 0.0) {
                String sval = db.getFormattedValue(val);
                double x = negativeBase - 3.0;
                double y = lb + seriesWidth / 2.0;
                vl = new ValueLabel(sval, new Point2D.Double(x, y), gp.GFV_VALUE.color, 3);
            }
            if (vl != null) {
                labelList.add(vl);
            }
        }
    }

    private static void _$1(int serNumBase, Vector serNames, ExtGraphCategory egc, double delx, DrawBase db, double dlb, double positiveBase, double seriesWidth, StringBuffer htmlLink, double coorWidth, boolean vis) {
        GraphParam gp = db.gp;
        ExtGraphProperty egp = db.egp;
        Graphics2D g = db.g;
        ArrayList<ValueLabel> labelList = db.labelList;
        double lb = Math.round(dlb);
        int bs = 1;
        float bw = 1.0f;
        int serNum = serNames.size();
        for (int j = 0; j < serNum; ++j) {
            double val;
            double tmp;
            double len;
            ExtGraphSery egs = egc.getExtGraphSery(serNames.get(j));
            if (egs.isNull() || (len = delx * (double)gp.tickNum * ((tmp = (val = egs.getValue()) - gp.baseValue) - gp.minValue) / (gp.maxValue * gp.coorScale)) == 0.0) continue;
            ChartColor chartColor = db.getChartColor(db.getColor(j + serNumBase));
            if (!(len >= 0.0)) continue;
            double xx = positiveBase;
            double yy = lb;
            double ww = len;
            double hh = seriesWidth;
            Color bc = egp.getAxisColor(5);
            double coorShift = coorWidth;
            Utils.draw3DRect(g, xx, yy, ww, hh, bc, bs, bw, egp.isDrawShade(), egp.isRaisedBorder(), db.getTransparent(), chartColor, true, coorShift);
            db.htmlLink(xx, yy, ww, hh, htmlLink, egc.getNameString(), egs);
            ValueLabel vl = null;
            String percentFmt = null;
            if (vis && (gp.dispValueType == 3 || gp.dispValueType == 6)) {
                percentFmt = StringUtils.isValidString(gp.dataMarkFormat) ? gp.dataMarkFormat : "0.00%";
            }
            if (len > 0.0) {
                String sval = null;
                if (percentFmt != null) {
                    sval = db.getFormattedValue(egs.getValue() / egc.getPositiveSumSeries(), percentFmt);
                    if (egc != null && gp.dispValueType == 6) {
                        sval = DrawBarStacked3DObj.getDispName(egc, egs, serNum) + "," + sval;
                    }
                } else if (egc != null && gp.dispValueType != 1) {
                    sval = db.getDispValue(egc, egs, gp.serNum);
                }
                if (StringUtils.isValidString(sval)) {
                    vl = new ValueLabel(sval, new Point2D.Double(positiveBase + len / 2.0, lb + seriesWidth / 2.0), gp.GFV_VALUE.color, 5);
                }
                positiveBase += len;
            }
            if (vl == null) continue;
            labelList.add(vl);
        }
        if (gp.graphTransparent) {
            g.setComposite(AlphaComposite.getInstance(3, 1.0f));
        }
        if (gp.dispStackSumValue && vis) {
            double val = db.getScaledValue(egc.getPositiveSumSeries(), true);
            ValueLabel vl = null;
            if (val > 0.0) {
                String sval = db.getFormattedValue(val);
                double x = positiveBase + 3.0;
                double y = lb + seriesWidth / 2.0;
                vl = new ValueLabel(sval, new Point2D.Double(x, y), gp.GFV_VALUE.color, 4);
            }
            if ((val = db.getScaledValue(egc.getNegativeSumSeries(), true)) < 0.0) {
                // empty if block
            }
            if (vl != null) {
                labelList.add(vl);
            }
        }
    }
}

