/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.cellset.graph.draw;

import com.scudata.cellset.IColCell;
import com.scudata.cellset.INormalCell;
import com.scudata.cellset.IRowCell;
import com.scudata.cellset.datamodel.CellSet;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.cellset.graph.config.GraphFont;
import com.scudata.cellset.graph.config.GraphFonts;
import com.scudata.cellset.graph.config.IGraphProperty;
import com.scudata.cellset.graph.config.Palette;
import com.scudata.cellset.graph.draw.Draw2Y2Line;
import com.scudata.cellset.graph.draw.Draw2YColLine;
import com.scudata.cellset.graph.draw.Draw2YColStackedLine;
import com.scudata.cellset.graph.draw.DrawArea;
import com.scudata.cellset.graph.draw.DrawArea3D;
import com.scudata.cellset.graph.draw.DrawBar;
import com.scudata.cellset.graph.draw.DrawBar3DObj;
import com.scudata.cellset.graph.draw.DrawBarStacked;
import com.scudata.cellset.graph.draw.DrawBarStacked3DObj;
import com.scudata.cellset.graph.draw.DrawCol;
import com.scudata.cellset.graph.draw.DrawCol3D;
import com.scudata.cellset.graph.draw.DrawCol3DObj;
import com.scudata.cellset.graph.draw.DrawColStacked;
import com.scudata.cellset.graph.draw.DrawColStacked3DObj;
import com.scudata.cellset.graph.draw.DrawCurve;
import com.scudata.cellset.graph.draw.DrawDot;
import com.scudata.cellset.graph.draw.DrawLine;
import com.scudata.cellset.graph.draw.DrawLine3DObj;
import com.scudata.cellset.graph.draw.DrawPie;
import com.scudata.cellset.graph.draw.DrawPie3DObj;
import com.scudata.cellset.graph.draw.DrawRadar;
import com.scudata.cellset.graph.draw.DrawStringUtils2;
import com.scudata.cellset.graph.draw.ExtAlarmLine;
import com.scudata.cellset.graph.draw.ExtGraphCategory;
import com.scudata.cellset.graph.draw.ExtGraphProperty;
import com.scudata.cellset.graph.draw.ExtGraphSery;
import com.scudata.cellset.graph.draw.GraphFontView;
import com.scudata.cellset.graph.draw.GraphParam;
import com.scudata.cellset.graph.draw.IGraph;
import com.scudata.cellset.graph.draw.ValueLabel;
import com.scudata.cellset.graph.draw.ValuePoint;
import com.scudata.chart.ChartColor;
import com.scudata.chart.CubeColor;
import com.scudata.chart.Utils;
import com.scudata.common.GCBase;
import com.scudata.common.Logger;
import com.scudata.common.Sentence;
import com.scudata.common.StringUtils;
import com.scudata.common.control.UtilsBase;
import com.scudata.util.Variant;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Vector;

public abstract class DrawBase
implements IGraph {
    public ExtGraphProperty egp;
    public Graphics2D g;
    public GraphParam gp;
    public Palette palette;
    public int VALUE_RADIUS = 2;
    public int SHADE_SPAN = 4;
    public Rectangle TR = new Rectangle();
    public ArrayList<ValueLabel> labelList = new ArrayList();
    public ArrayList<ValuePoint> pointList = new ArrayList();
    private boolean _$8 = true;
    private transient Point2D.Double _$7;
    private transient Point2D.Double _$6;
    private ValueLabel _$5;
    private ValueLabel _$4;
    private ValueLabel _$3;
    private ValueLabel _$2;
    protected Rectangle2D.Double rightTop;
    protected Rectangle2D.Double rightBottom;
    protected Rectangle2D.Double leftTop;
    protected Rectangle2D.Double leftBottom;
    private boolean _$1 = true;

    protected boolean isSVG() {
        return this.egp.getImageFormat() == 5;
    }

    Point2D.Double _$3(double shift) {
        double x = this.gp.gRect1.x - this._$7.x;
        double y = this.gp.gRect1.y + this.gp.gRect1.height - shift - this._$7.y;
        return new Point2D.Double(x, y);
    }

    Point2D.Double _$2(double shift) {
        double x = this.gp.gRect1.x + shift + this._$6.x;
        double y = this.gp.gRect1.y + this.gp.gRect1.height + this._$6.y;
        return new Point2D.Double(x, y);
    }

    public void setDisableLink(boolean b) {
        this._$8 = b;
    }

    private boolean _$2() {
        return this._$8;
    }

    public void outLabels() {
        byte direction;
        String text;
        double y;
        double x;
        for (int i = 0; i < this.labelList.size(); ++i) {
            ValueLabel vl = this.labelList.get(i);
            x = vl.p.x;
            y = vl.p.y;
            text = vl.text;
            direction = vl.direction;
            Color c = vl.c;
            if (this.gp.GFV_VALUE.color.getAlpha() == 0) {
                this.gp.GFV_VALUE.outText(x, y, text, direction, c);
                continue;
            }
            this.gp.GFV_VALUE.outText(x, y, text, direction);
        }
        this.labelList.clear();
        if (this._$5 != null) {
            double[] buf = this._$2(this.gp.gRect2, this.egp.getGraphTitleAlign());
            this.TR = this.gp.GFV_TITLE.getTextSize();
            x = buf[0];
            y = this._$5.p.y - (double)this.TR.height;
            text = this._$5.text;
            direction = (byte)buf[1];
            this.gp.GFV_TITLE.outText(x, y, text, direction);
            this._$5 = null;
        }
        if (this._$2 != null) {
            double[] buf = this._$2(this.gp.gRect1, this.egp.getXTitleAlign());
            this.TR = this.gp.GFV_XTITLE.getTextSize();
            x = buf[0];
            y = this._$2.p.y - (double)(this.TR.height / 2);
            text = this._$2.text;
            direction = (byte)buf[1];
            this.gp.GFV_XTITLE.outText(x, y, text, direction);
            this._$2 = null;
        }
        if (this._$4 != null) {
            x = this._$4.p.x;
            y = this._$1(this.gp.gRect1, this.egp.getYTitleAlign());
            text = this._$4.text;
            byte vAlign = this.egp.getYTitleAlign();
            direction = vAlign == 8 ? (byte)2 : (vAlign == 32 ? (byte)1 : 4);
            this.gp.GFV_YTITLE.outText(x, y, text, direction);
            this._$4 = null;
        }
        if (this._$3 != null) {
            x = this._$3.p.x;
            y = this._$1(this.gp.gRect2, this.egp.getYTitleAlign());
            text = this._$3.text;
            byte vAlign = this.egp.getYTitleAlign();
            direction = vAlign == 8 ? (byte)2 : (vAlign == 32 ? (byte)1 : 3);
            this.gp.GFV_YTITLE.outText(x, y, text, direction);
            this._$3 = null;
        }
    }

    private double[] _$2(Rectangle2D.Double rect, byte align) {
        double[] x = new double[2];
        if (align == 0) {
            x[0] = rect.x;
            x[1] = 4.0;
        } else if (align == 4) {
            x[0] = rect.x + this.gp.gRect2.width;
            x[1] = 3.0;
        } else {
            x[0] = rect.x + this.gp.gRect2.width / 2.0;
            x[1] = 1.0;
        }
        return x;
    }

    private double _$1(Rectangle2D.Double rect, byte align) {
        double y = align == 8 ? rect.y : (align == 32 ? rect.y + this.gp.gRect2.height : rect.y + this.gp.gRect2.height / 2.0);
        return y;
    }

    protected int getPointRadius() {
        byte radius = this.gp.getLineThickByte();
        if (radius < 2) {
            return 2;
        }
        return radius;
    }

    public void outPoints() {
        int bs = 1;
        float bw = 1.0f;
        boolean drawShade = false;
        float transparent = this.getTransparent();
        for (int i = 0; i < this.pointList.size(); ++i) {
            ValuePoint vp = this.pointList.get(i);
            Point2D.Double p = vp.p;
            int radius = vp.radius < 0 ? this.getPointRadius() : vp.radius;
            Color fillColor = vp.fillColor == null ? this.egp.getAxisColor(5) : vp.fillColor;
            if (drawShade) {
                Utils.drawCartesianPoint1(this.g, p, vp.shape, radius, radius, radius, bs, bw, transparent);
            }
            Utils.drawCartesianPoint2(this.g, p, vp.shape, radius, radius, radius, bs, bw, this.getChartColor(fillColor), vp.borderColor, transparent);
        }
    }

    public void setGraphics2D(Graphics2D g) {
        this.g = g;
    }

    public void setGraphWH(int w, int h) {
        this.gp.setGraphWH(w, h);
    }

    public static Object getInstance(ExtGraphProperty egp) {
        DrawBase graph = null;
        switch (egp.getType()) {
            case 2: {
                graph = new DrawBar();
                break;
            }
            case 3: 
            case 4: {
                graph = new DrawBar3DObj();
                break;
            }
            case 5: {
                graph = new DrawBarStacked();
                break;
            }
            case 6: {
                graph = new DrawBarStacked3DObj();
                break;
            }
            case 7: {
                graph = new DrawCol();
                break;
            }
            case 8: {
                graph = new DrawCol3D();
                break;
            }
            case 9: {
                graph = new DrawCol3DObj();
                break;
            }
            case 10: {
                graph = new DrawColStacked();
                break;
            }
            case 11: {
                graph = new DrawColStacked3DObj();
                break;
            }
            case 12: {
                graph = new DrawLine();
                break;
            }
            case 29: {
                graph = new DrawCurve();
                break;
            }
            case 16: {
                graph = new DrawLine3DObj();
                break;
            }
            case 13: {
                graph = new DrawPie();
                break;
            }
            case 17: {
                graph = new DrawPie3DObj();
                break;
            }
            case 1: {
                graph = new DrawArea();
                break;
            }
            case 15: {
                graph = new DrawArea3D();
                break;
            }
            case 14: {
                graph = new DrawDot();
                break;
            }
            case 21: {
                graph = new Draw2YColLine();
                break;
            }
            case 30: {
                graph = new Draw2YColStackedLine();
                break;
            }
            case 20: {
                graph = new Draw2Y2Line();
                break;
            }
            case 22: {
                graph = new DrawRadar();
                break;
            }
            default: {
                graph = new DrawCol();
            }
        }
        graph.transProperty(egp);
        graph.VALUE_RADIUS = graph.getPointRadius();
        return graph;
    }

    public ChartColor getChartColor(Color c) {
        ChartColor cc = new ChartColor(c);
        if (this.egp.isGradientColor()) {
            cc.setColor1(c);
            cc.setColor2(c);
            cc.setGradient(true);
        } else {
            cc.setGradient(false);
        }
        return cc;
    }

    public Color getColor(int index) {
        return new Color(this.palette.getColor(index));
    }

    public float getTransparent() {
        if (this.egp.isGraphTransparent()) {
            return 0.6f;
        }
        return 1.0f;
    }

    public void transProperty(ExtGraphProperty egp) {
        this.egp = egp;
        this.gp = new GraphParam();
        this.palette = egp.getPlatte();
        this.gp.catNames = egp.getCategoryNames();
        this.gp.serNames = egp.getSeriesNames(egp.categories);
        this.gp.catNum = this.gp.catNames.size();
        this.gp.serNum = this.gp.serNames.size();
        String text = egp.getGraphTitle();
        GraphFonts fonts = egp.getFonts();
        GraphFont gf = fonts.getTitleFont();
        this.gp.GFV_TITLE = this.getGraphFontView(gf, text, 0);
        text = "";
        gf = fonts.getLegendFont();
        this.gp.GFV_LEGEND = this.getGraphFontView(gf, text, 1);
        gf = fonts.getDataFont();
        this.gp.GFV_VALUE = this.getGraphFontView(gf, text, 6);
        text = egp.getXTitle();
        gf = fonts.getXTitleFont();
        this.gp.GFV_XTITLE = this.getGraphFontView(gf, text, 4);
        text = egp.getYTitle();
        gf = fonts.getYTitleFont();
        this.gp.GFV_YTITLE = this.getGraphFontView(gf, text, 5);
        text = "";
        gf = fonts.getXLabelFont();
        this.gp.GFV_XLABEL = this.getGraphFontView(gf, text, 2);
        gf = fonts.getYLabelFont();
        this.gp.GFV_YLABEL = this.getGraphFontView(gf, text, 3);
        this.gp.imageFormat = egp.getImageFormat();
        this.gp.setBackColor(egp.getGraphBackColor());
        this.gp.dataMarkFormat = egp.getDisplayDataFormat1();
        this.gp.dataMarkFormat2 = egp.getDisplayDataFormat2();
        if (!StringUtils.isValidString(this.gp.dataMarkFormat2)) {
            this.gp.dataMarkFormat2 = this.gp.dataMarkFormat;
        }
        this.gp.maxValue = !egp.isUserSetYEndValue1() ? egp.getMaxValue(egp.getCategories()) : egp.getYEndValue1();
        this.gp.maxValue2 = !egp.isUserSetYEndValue2() ? egp.getMaxValue(egp.category2) : egp.getYEndValue2();
        if (egp.isUserSetYInterval1()) {
            this.gp.interval = egp.getYInterval1();
        }
        if (egp.isUserSetYInterval2()) {
            this.gp.interval2 = egp.getYInterval2();
        }
        if (egp.isUserSetYMinMarks()) {
            this.gp.minTicknum = egp.getYMinMarks();
            this.gp.minTicknum2 = egp.getYMinMarks();
        }
        if (!egp.isUserSetYStartValue1()) {
            this.gp.minValue = egp.getMinValue(egp.getCategories());
        } else {
            this.gp.baseValue = this.gp.minValue = egp.getYStartValue1();
            this.gp.minValue -= this.gp.baseValue;
            this.gp.maxValue -= this.gp.baseValue;
        }
        if (!egp.isUserSetYStartValue2()) {
            this.gp.minValue2 = egp.getMinValue(egp.category2);
        } else {
            this.gp.baseValue2 = this.gp.minValue2 = egp.getYStartValue2();
            this.gp.minValue2 -= this.gp.baseValue2;
            this.gp.maxValue2 -= this.gp.baseValue2;
        }
        if (egp.isUserSetTitleMargin()) {
            this.gp.graphMargin = (int)egp.getTitleMargin();
        }
        if (egp.isUserSetBarDistance()) {
            this.gp.barDistance = egp.getBarDistance();
        }
        if (egp.isUserSetXInterval()) {
            this.gp.graphXInterval = (int)egp.getXInterval();
        }
        if (egp.isUserSetStatusBarWidth()) {
            this.gp.statusBarHeight = egp.getStatusBarWidth();
        }
        if (egp.is2YGraph()) {
            this.gp.serNames2 = egp.getSeriesNames(egp.category2);
            this.gp.serNum2 = this.gp.serNames2.size();
        }
        this.gp.dispValueType = egp.getDisplayData();
        this.gp.dispValueOntop = this.gp.dispValueType == 2 || this.gp.dispValueType == 5 || this.gp.dispValueType == 4;
        this.gp.dispValueType2 = egp.getDisplayData2();
        this.gp.dispValueOntop2 = this.gp.dispValueType2 == 2 || this.gp.dispValueType2 == 5 || this.gp.dispValueType2 == 4;
        this.gp.dispStackSumValue = egp.isDispStackSumValue();
        this.gp.scaleMark = egp.getDataUnit();
        this.gp.drawLineDot = egp.isDrawLineDot();
        this.gp.isOverlapOrigin = egp.isOverlapOrigin();
        this.gp.drawLineTrend = egp.isDrawLineTrend();
        this.gp.setLineThick(egp.getLineThick());
        this.gp.cutPie = egp.isCutPie();
        this.gp.dispIntersectValue = egp.isShowOverlapText();
        this.gp.gradientColor = egp.isGradientColor();
        this.gp.coorColor = new Color(egp.getAxisColor());
        this.gp.gridColor = new Color(egp.getGridLineColor());
        this.gp.gridLineLocation = egp.getGridLocation();
        this.gp.gridLineStyle = egp.getGridLineType();
        this.gp.graphTransparent = egp.isGraphTransparent();
        this.gp.timeScale = egp.getStatusTimeType();
        this.gp.isDrawTable = egp.isDrawDataTable();
        this.gp.isDataCenter = egp.isDataCenter();
        this.gp.meter3DEdge = egp.getMeter3DEdge();
        this.gp.meterRainbowEdge = egp.getMeterRainbowEdge();
        this.gp.pieLine = egp.getPieLine();
        IGraphProperty p = egp.getIGraphProperty();
        this.gp.leftMargin = p.getLeftMargin();
        this.gp.rightMargin = p.getRightMargin();
        this.gp.topMargin = p.getTopMargin();
        this.gp.bottomMargin = p.getBottomMargin();
        this.gp.tickLen = p.getTickLen();
        this.gp.coorWidth = p.getCoorWidth();
        this.gp.categorySpan = p.getCategorySpan();
        this.gp.seriesSpan = p.getSeriesSpan();
        this.gp.pieRotation = p.getPieRotation();
        this.gp.pieHeight = p.getPieHeight();
        if (egp.isStackedGraph(this)) {
            this.gp.maxPositive = egp.getStackedMaxValue();
            this.gp.minNegative = egp.getStackedMinValue();
        }
        this.gp.isMultiSeries = this.gp.serNum + this.gp.serNum2 > 1 || egp.isLegendOnSery();
    }

    public boolean isMultiSeries() {
        if (this.egp.is2YGraph()) {
            return true;
        }
        return this.gp.isMultiSeries;
    }

    protected boolean isLegendOnCategory() {
        byte type = this.egp.getType();
        return type == 13 || type == 17 || !this.isMultiSeries();
    }

    protected boolean isCircleLegend() {
        byte type = this.egp.getType();
        boolean isCircle = type == 12 || type == 14 || type == 31;
        return isCircle;
    }

    protected boolean isShowMeterTick(double tick, Vector values) {
        for (int i = 0; i < values.size(); ++i) {
            Double val = (Double)values.get(i);
            if (val != tick) continue;
            return true;
        }
        return false;
    }

    protected void drawLegendRect(int seriesNo, int series1Count, int x, int y, int fontHeight, int nFontHeight, int textWidth, boolean verticalPillar, boolean isGongZi, String stmp, StringBuffer htmlBuffer) {
        int yy;
        int hh = fontHeight;
        if (this.isCircleLegend() || this.egp.is2YGraph() && this.gp.isMultiSeries && seriesNo >= series1Count) {
            this.g.setStroke(new BasicStroke(1.0E-5f));
            yy = y - nFontHeight;
            this.setPaint((double)x, (double)yy, (double)fontHeight, (double)fontHeight, seriesNo, verticalPillar);
            this.fillOval(x, yy, fontHeight, fontHeight);
            this.g.setColor(this.gp.coorColor);
            this.g.setStroke(new BasicStroke(0.1f));
            this.g.drawOval(x, yy, fontHeight, fontHeight);
        } else {
            int ww;
            int xx = x;
            yy = y - nFontHeight;
            hh = ww = fontHeight;
            Color tmpc = this.getColor(seriesNo);
            Color bc = this.egp.getAxisColor(4);
            int bs = 1;
            float bw = 0.1f;
            Utils.draw2DRect(this.g, xx, yy, ww, hh, bc, bs, bw, this.egp.isDrawShade(), this.egp.isRaisedBorder(), this.getTransparent(), this.getChartColor(tmpc), !this.egp.isBarGraph(this));
        }
        int x1 = x;
        int y1 = y - nFontHeight;
        x += fontHeight + this.egp.getLegendHorizonGap();
        if (isGongZi) {
            stmp = stmp.substring(stmp.indexOf(".") + 1);
        }
        if (fontHeight != nFontHeight) {
            y = y - nFontHeight + fontHeight;
        }
        y -= hh / 2;
        int wrapWidth = textWidth + 2;
        ArrayList<String> al = UtilsBase.wrapString(stmp, this.g.getFontMetrics(this.gp.GFV_LEGEND.font), wrapWidth);
        for (int i = 0; i < al.size(); ++i) {
            String sectText = al.get(i);
            this.gp.GFV_LEGEND.outText(x, y, sectText);
            y += fontHeight;
        }
        int w = textWidth;
        int h = y - y1;
        String coordx = this.isSVG() ? "x=\"" + x1 + "\" y=\"" + y1 + "\" width=\"" + w + "\" height=\"" + h + "\"" : x1 + "," + y1 + "," + (x1 + w) + "," + (y1 + h);
        if (htmlBuffer != null) {
            htmlBuffer.append(this.getStgLinkHtml(this.egp.getLegendLink(), "rect", coordx, this.egp.getLinkTarget(), stmp));
        }
    }

    protected boolean isLegendOnSide() {
        return this.egp.getLegendLocation() == 1 || this.egp.getLegendLocation() == 2;
    }

    protected Rectangle getLegendTextRect(String text) {
        this.TR = this.gp.GFV_LEGEND.getTextSize(text);
        int limitWidth = 0;
        limitWidth = this.isLegendOnSide() ? this.gp.graphWidth / 3 : (int)((float)this.gp.graphWidth * 0.75f);
        if (this.TR.getWidth() > (double)limitWidth) {
            FontMetrics fm = this.g.getFontMetrics(this.gp.GFV_LEGEND.font);
            ArrayList<String> al = UtilsBase.wrapString(text, fm, limitWidth);
            this.TR.setBounds(0, 0, limitWidth, (int)((double)al.size() * this.TR.getHeight()));
        }
        return this.TR;
    }

    public void drawLegend(StringBuffer htmlBuffer) {
        String tmp;
        int i;
        boolean verticalPillar;
        if (this.egp.getLegendLocation() == 5) {
            return;
        }
        int nFontHeight = 0;
        int fontHeight = 0;
        int maxWidth = 0;
        int maxHeight = 0;
        int legendWidth = 0;
        int legendHeight = 0;
        int intTmp = 0;
        int totalWidth = 0;
        int totalHeight = 0;
        boolean isGongZi = this.egp.getType() == 27;
        boolean bl = verticalPillar = !this.egp.isBarGraph(this);
        if (this.isLegendOnCategory()) {
            int cc = this.gp.catNames.size();
            for (i = 0; i < cc; ++i) {
                Object o = this.gp.catNames.get(i);
                tmp = Variant.toString(o);
                if (!StringUtils.isValidString(tmp)) {
                    tmp = "A";
                }
                this.TR = this.getLegendTextRect(tmp);
                intTmp = this.TR.width;
                if (maxWidth >= intTmp) continue;
                maxWidth = intTmp;
                maxHeight = this.TR.height;
            }
        } else {
            int ss = this.gp.serNames.size();
            for (i = 0; i < ss; ++i) {
                Object o = this.gp.serNames.get(i);
                tmp = Variant.toString(o);
                if (isGongZi) {
                    tmp = tmp.substring(tmp.indexOf(".") + 1);
                }
                if (!StringUtils.isValidString(tmp)) {
                    tmp = "A";
                }
                this.TR = this.getLegendTextRect(tmp);
                intTmp = this.TR.width;
                if (maxWidth >= intTmp) continue;
                maxWidth = intTmp;
                maxHeight = this.TR.height;
            }
            if ((this.egp.is2YGraph() || this.egp.isNormalStacked()) && this.gp.serNames2 != null) {
                int ss2 = this.gp.serNames2.size();
                for (int i2 = 0; i2 < ss2; ++i2) {
                    Object o = this.gp.serNames2.get(i2);
                    this.TR = this.getLegendTextRect(Variant.toString(o));
                    intTmp = this.TR.width;
                    if (maxWidth >= intTmp) continue;
                    maxWidth = intTmp;
                    maxHeight = this.TR.height;
                }
            }
        }
        int size = 0;
        size = this.isLegendOnCategory() ? this.gp.catNames.size() : (this.egp.is2YGraph() || this.egp.isNormalStacked() && this.gp.serNames2 != null ? this.gp.serNames.size() + this.gp.serNames2.size() : this.gp.serNames.size());
        int series1Count = this.gp.serNames.size();
        nFontHeight = maxHeight;
        fontHeight = this.gp.GFV_LEGEND.getTextSize((String)"ABC").height;
        if (!this.isLegendOnSide()) {
            int borderwidth;
            int borderx;
            int row;
            totalWidth = this.gp.graphWidth - this.gp.leftMargin - this.gp.rightMargin;
            legendWidth = fontHeight + 3 * this.egp.getLegendHorizonGap() + maxWidth;
            int col = totalWidth / legendWidth;
            if (col < 1) {
                col = 1;
            }
            if ((row = size / col) * col < size) {
                ++row;
            }
            int tmp2 = this.gp.graphHeight - this.gp.bottomInset - ((row + 1) * this.egp.getLegendVerticalGap() + row * nFontHeight);
            if (row > 1) {
                borderx = this.gp.leftMargin + (totalWidth - legendWidth * col) / 2;
                borderwidth = legendWidth * col;
            } else {
                borderx = this.gp.leftMargin + (totalWidth - legendWidth * size) / 2;
                borderwidth = legendWidth * size;
            }
            int bordery = this.egp.getLegendLocation() == 3 ? this.gp.topInset : tmp2;
            int borderheight = nFontHeight * row + (row + 1) * this.egp.getLegendVerticalGap();
            this.drawRect(borderx, bordery, borderwidth, borderheight, this.egp.getAxisColor(4));
            this.gp.legendBoxWidth = borderwidth;
            this.gp.legendBoxHeight = borderheight;
            for (int i3 = 0; i3 < row; ++i3) {
                int x = row > 1 ? this.gp.leftMargin + (totalWidth - legendWidth * col) / 2 : this.gp.leftMargin + (totalWidth - legendWidth * size) / 2;
                for (int j = 0; j < col && i3 * col + j < size; ++j) {
                    int y = this.egp.getLegendLocation() == 3 ? this.gp.topInset + (i3 + 1) * (this.egp.getLegendVerticalGap() + nFontHeight) : tmp2 + (i3 + 1) * (this.egp.getLegendVerticalGap() + nFontHeight);
                    Object o = null;
                    int seriesNo = i3 * col + j;
                    o = this.isLegendOnCategory() ? this.gp.catNames.get(seriesNo) : (seriesNo >= series1Count ? this.gp.serNames2.get(seriesNo - series1Count) : this.gp.serNames.get(seriesNo));
                    this.drawLegendRect(seriesNo, series1Count, x += this.egp.getLegendHorizonGap(), y, fontHeight, nFontHeight, maxWidth, verticalPillar, isGongZi, Variant.toString(o), htmlBuffer);
                    x += nFontHeight + this.egp.getLegendHorizonGap();
                    x += maxWidth + this.egp.getLegendHorizonGap();
                }
            }
            if (this.egp.getLegendLocation() == 3) {
                this.gp.topInset += (row + 1) * this.egp.getLegendVerticalGap() + row * nFontHeight + this.egp.getLegendVerticalGap();
            } else {
                this.gp.bottomInset += (row + 1) * this.egp.getLegendVerticalGap() + row * nFontHeight + this.egp.getLegendVerticalGap();
            }
        } else {
            int borderheight;
            int bordery;
            int col;
            legendWidth = fontHeight + 3 * this.egp.getLegendHorizonGap() + maxWidth;
            totalHeight = this.gp.graphHeight - this.gp.topMargin - this.gp.bottomMargin;
            legendHeight = nFontHeight + 2 * this.egp.getLegendVerticalGap();
            int row = totalHeight / legendHeight;
            if (row < 1) {
                row = 1;
            }
            if (row * (col = size / row) < size) {
                ++col;
            }
            int tmp3 = this.gp.graphWidth - this.gp.rightInset - ((col + 1) * this.egp.getLegendHorizonGap() + col * legendWidth);
            if (col > 1) {
                bordery = this.gp.topMargin + (totalHeight - legendHeight * row) / 2;
                borderheight = legendHeight * row;
            } else {
                bordery = this.gp.topMargin + (totalHeight - legendHeight * size) / 2;
                borderheight = legendHeight * size;
            }
            int borderx = this.egp.getLegendLocation() == 1 ? this.gp.leftInset : tmp3;
            int borderwidth = legendWidth * col;
            this.drawRect(borderx, bordery, borderwidth, borderheight, this.egp.getAxisColor(4));
            this.gp.legendBoxWidth = borderwidth;
            this.gp.legendBoxHeight = borderheight;
            for (int j = 0; j < col; ++j) {
                int y = col > 1 ? this.gp.topMargin + (totalHeight - legendHeight * row) / 2 + nFontHeight + this.egp.getLegendVerticalGap() : this.gp.topMargin + (totalHeight - legendHeight * size) / 2 + nFontHeight + this.egp.getLegendVerticalGap();
                for (int i4 = 0; i4 < row && j * row + i4 < size; ++i4) {
                    int x = this.egp.getLegendLocation() == 1 ? this.gp.leftInset + j * legendWidth : tmp3 + j * legendWidth;
                    Object o = null;
                    int seriesNo = j * row + i4;
                    o = this.isLegendOnCategory() ? this.gp.catNames.get(seriesNo) : (seriesNo >= series1Count ? this.gp.serNames2.get(seriesNo - series1Count) : this.gp.serNames.get(seriesNo));
                    this.drawLegendRect(seriesNo, series1Count, x += this.egp.getLegendHorizonGap(), y, fontHeight, nFontHeight, maxWidth, verticalPillar, isGongZi, Variant.toString(o), htmlBuffer);
                    x += nFontHeight + this.egp.getLegendVerticalGap();
                    y += legendHeight;
                }
            }
            if (this.egp.getLegendLocation() == 1) {
                this.gp.leftInset += (col + 1) * this.egp.getLegendHorizonGap() + col * legendWidth + this.egp.getLegendHorizonGap();
            } else {
                this.gp.rightInset += (col + 1) * this.egp.getLegendHorizonGap() + col * legendWidth + this.egp.getLegendHorizonGap();
            }
        }
    }

    public void setPaint(double x, double y, double w, double h, Color c, boolean verticalPillar) {
        this.setPaint(x, y, w, h, c, verticalPillar, (byte)0);
    }

    public void setPaint(double x, double y, double w, double h, int pIndex, boolean verticalPillar) {
        Color c = this.getColor(pIndex);
        byte p = this.palette.getPattern(pIndex);
        this.setPaint(x, y, w, h, c, verticalPillar, p);
    }

    protected void setPaint(double x, double y, double w, double h, Color c, boolean verticalPillar, byte fillPattern) {
        if (this.gp.gradientColor) {
            Color cc = c;
            Color dd = c;
            int cValue = c.getRGB();
            if (cValue < -13410000) {
                cc = Color.lightGray;
                dd = c;
            } else if (cValue < -8355712) {
                cc = c.brighter();
                dd = cc.darker().darker();
            } else {
                cc = c;
                dd = cc.darker().darker().darker();
            }
            GradientPaint paint = verticalPillar ? new GradientPaint((float)x, (float)y, cc, (float)(x + w), (float)y, dd) : new GradientPaint((float)x, (float)y, cc, (float)x, (float)(y + h), dd);
            this.g.setPaint(paint);
        } else if (this.egp.isRaisedBorder() || fillPattern == 0) {
            this.g.setColor(c);
        } else {
            this.g.setPaint(Palette.getPatternPaint(c, fillPattern));
        }
    }

    protected String getStgLinkHtml(String link, String shape, String coords, Object target, Object legendValue) {
        return this.getStgLinkHtml(link, shape, coords, target, legendValue, null, null, null);
    }

    protected String replaceAll(String src, String sold, String snew) {
        return Sentence.replace(src, 0, sold, snew, 27);
    }

    protected String getTitle(String tips, Object categoryValue, Object legendValue, String fmtedVal) {
        String title = "";
        if (StringUtils.isValidString(tips)) {
            title = tips;
        } else {
            if (StringUtils.isValidString(categoryValue)) {
                title = categoryValue.toString();
            }
            if (StringUtils.isValidString(legendValue)) {
                title = title + " " + legendValue.toString();
            }
            if (fmtedVal != null) {
                title = title + " " + fmtedVal;
            }
        }
        title = this.replaceAll(title, "\"", "&quot;");
        return title;
    }

    protected String getStgLinkHtml(String link, String shape, String coords, Object target, Object legendValue, Object categoryValue, String fmtedVal, String tips) {
        if (link == null) {
            return null;
        }
        if (StringUtils.isValidString(link)) {
            if (StringUtils.isValidString(legendValue)) {
                link = this.replaceAll(link, "@legend", legendValue.toString());
            }
            if (StringUtils.isValidString(categoryValue)) {
                link = this.replaceAll(link, "@category", categoryValue.toString());
            }
            if (StringUtils.isValidString(tips)) {
                link = this.replaceAll(link, "@title", tips);
            }
        }
        String title = this.getTitle(tips, categoryValue, legendValue, fmtedVal);
        StringBuffer sb = new StringBuffer(128);
        if (this.isSVG()) {
            sb.append("<a");
            if (StringUtils.isValidString(link)) {
                sb.append(" xlink:href=\"").append(link).append("\" target=\"");
                sb.append(target).append("\"");
            }
            sb.append(">\n");
            if (StringUtils.isValidString(title)) {
                sb.append("<title>").append(title);
                sb.append("</title>");
            }
            sb.append("<").append(shape);
            sb.append(" ").append(coords);
            sb.append(" style=\"fill:transparent;stroke:transparent\"/>\n");
            sb.append("</a>\n");
        } else {
            sb.append("<area shape=\"").append(shape).append("\" coords=\"");
            sb.append(coords);
            if (StringUtils.isValidString(link)) {
                sb.append("\" href=\"").append(link).append("\" target=\"").append(target);
            }
            if (StringUtils.isValidString(title)) {
                sb.append("\" title=\"").append(title);
            }
            sb.append("\">\n");
        }
        return sb.toString();
    }

    public void drawRectCubeLine(int x, int y, int w, int h, int z) {
        this.g.setColor(this.gp.coorColor);
        int hx = x + z;
        int hy = y + h - z;
        this.g.drawLine(hx, hy, hx - z, hy + z);
        this.g.drawLine(hx, hy, hx, hy - h);
        this.g.drawLine(hx, hy, hx + w, hy);
    }

    public void drawRect(double x, double y, double w, double h, Color c) {
        if (c == null) {
            return;
        }
        this.g.setColor(c);
        Utils.drawRect(this.g, x, y, w, h);
    }

    public void drawLine(double x1, double y1, double x2, double y2, Color c) {
        if (c == null) {
            return;
        }
        this.g.setColor(c);
        Utils.drawLine(this.g, x1, y1, x2, y2);
    }

    public void drawArc(int x, int y, int w, int h, int startAngle, int arcAngle, Color c) {
        if (c == null) {
            return;
        }
        this.g.setColor(c);
        this.g.drawArc(x, y, w, h, startAngle, arcAngle);
    }

    public void drawShape(Shape s, Color c) {
        if (c == null) {
            return;
        }
        this.g.setColor(c);
        this.g.draw(s);
    }

    public void drawPolygon(double[] x, double[] y, int n, Color c) {
        if (c == null) {
            return;
        }
        this.g.setColor(c);
        Shape poly = Utils.newPolygon2D(x, y);
        this.g.draw(poly);
    }

    public void drawPolygon(int[] x, int[] y, int n, Color c) {
        if (c == null) {
            return;
        }
        this.g.setColor(c);
        Polygon poly = new Polygon(x, y, n);
        this.g.draw(poly);
    }

    public void drawOval(int x, int y, int w, int h, Color c) {
        if (c == null) {
            return;
        }
        this.g.setColor(c);
        this.g.drawOval(x, y, w, h);
    }

    public void fillOval(int x, int y, int w, int h) {
        if (this.egp.isDrawShade()) {
            Paint p = this.g.getPaint();
            Color c = this.g.getColor();
            this.g.setColor(Color.lightGray);
            this.g.fillOval(x + this.SHADE_SPAN, y + this.SHADE_SPAN, w, h);
            this.g.setColor(c);
            this.g.setPaint(p);
        }
        this.g.fillOval(x, y, w, h);
    }

    public void fillRect(double x, double y, double w, double h) {
        Color bc = null;
        int bs = 0;
        float bw = 0.0f;
        ChartColor fillColor = this.getChartColor(this.g.getColor());
        Utils.draw2DRect(this.g, x, y, w, h, bc, bs, bw, this.egp.isDrawShade(), this.egp.isRaisedBorder(), this.getTransparent(), fillColor, !this.egp.isBarGraph(this));
    }

    public void fillDotGradientShape(Shape s, Color c1, Color c2, double cx, double cy) {
        Rectangle sBounds = s.getBounds();
        double w = sBounds.getWidth();
        double h = sBounds.getHeight();
        int r = (int)Math.sqrt(w * w + h * h);
        int dAngle = 5;
        int sAngle = 0;
        Arc2D.Double a2dd = new Arc2D.Double(cx - (double)r, cy - (double)r, r * 2, r * 2, sAngle, dAngle + 3, 2);
        Area sA = new Area(s);
        Point2D.Double p1 = new Point2D.Double(cx, cy);
        while (sAngle <= 360) {
            Area da = new Area(a2dd);
            Area a1 = new Area(s);
            a1.add(da);
            a1.subtract(sA);
            da.subtract(a1);
            Point2D p2 = a2dd.getStartPoint();
            p2.setLocation((p1.getX() + p2.getX()) / 2.0, (p1.getY() + p2.getY()) / 2.0);
            this.g.setPaint(new GradientPaint(p1, c1, p2, c2));
            this.g.fill(da);
            a2dd.setAngleStart(sAngle += dAngle);
        }
    }

    public void drawRectCube(double x, double w, double h, double z, double dz, int colorIndex, StringBuffer sb, Object cat, ExtGraphSery egs) {
        double hh;
        double ww;
        double yy;
        double xx;
        ChartColor chartColor = this.getChartColor(this.getColor(colorIndex));
        if (h >= 0.0) {
            xx = x + dz;
            yy = this.gp.valueBaseLine - h - dz;
            ww = w;
            hh = h;
        } else {
            xx = x + dz;
            yy = this.gp.valueBaseLine - dz;
            ww = w;
            hh = Math.abs(h);
        }
        Color bc = this.egp.getAxisColor(5);
        int bs = 1;
        float bw = 1.0f;
        double coorShift = z;
        Utils.draw3DRect(this.g, xx, yy, ww, hh, bc, bs, bw, this.egp.isDrawShade(), this.egp.isRaisedBorder(), this.getTransparent(), chartColor, !this.egp.isBarGraph(this), coorShift);
        this.htmlLink(xx, yy, ww, hh, sb, cat, egs);
    }

    public void drawOutCircleText(GraphFontView gfv, String text, double angle, double x, double y) {
        if (!StringUtils.isValidString(text)) {
            return;
        }
        if (this.egp.isShowOverlapText()) {
            this.drawOutCircleText(gfv, text, angle, x, y, false);
        } else if (!this.drawOutCircleText(gfv, text, angle, x, y, false)) {
            this.drawOutCircleText(gfv, text, angle, x, y, true);
        }
    }

    public void drawInnerCircleText(GraphFontView gfv, String text, double angle, double x, double y) {
        if (!StringUtils.isValidString(text)) {
            return;
        }
        gfv.outText(x, y, text, GraphFontView.reverseDirection(this.angleToPosition(gfv, angle)));
    }

    protected byte angleToPosition(GraphFontView gfv, double angle) {
        if (angle >= 360.0) {
            angle -= 360.0;
        }
        if (gfv.vertical || gfv.angle == 90) {
            if (angle < 5.0) {
                return 4;
            }
            if (angle < 175.0) {
                return 1;
            }
            if (angle < 185.0) {
                return 3;
            }
            if (angle < 355.0) {
                return 2;
            }
            return 4;
        }
        if (gfv.angle == 0) {
            if (angle < 85.0) {
                return 4;
            }
            if (angle < 95.0) {
                return 1;
            }
            if (angle < 265.0) {
                return 3;
            }
            if (angle < 275.0) {
                return 2;
            }
            return 4;
        }
        if (angle < 85.0) {
            return 4;
        }
        if (angle < 95.0) {
            return 1;
        }
        if (angle < (double)(180 + gfv.angle)) {
            return 3;
        }
        if (angle < (double)(360 - gfv.angle)) {
            return 2;
        }
        return 4;
    }

    protected boolean drawOutCircleText(GraphFontView gfv, String text, double angle, double x, double y, boolean drawExtend) {
        double x1;
        boolean isTop;
        double tmpAngle;
        int w = gfv.getTextSize((String)text).width;
        int h = gfv.getTextSize((String)text).height;
        for (tmpAngle = angle; tmpAngle < 0.0; tmpAngle += 360.0) {
        }
        while (tmpAngle > 360.0) {
            tmpAngle -= 360.0;
        }
        boolean isLeft = tmpAngle > 90.0 && tmpAngle < 270.0;
        boolean bl = isTop = !(tmpAngle > 180.0) || !(tmpAngle < 360.0);
        if (drawExtend) {
            x1 = x;
            double y1 = y;
            if (isLeft && isTop) {
                if (this.leftTop == null) {
                    this.leftTop = new Rectangle2D.Double(this.gp.gRect2.x, this.gp.gRect2.y, 0.0, 0.0);
                }
                x = this.leftTop.x;
                y = this.leftTop.y + this.leftTop.height + 5.0;
                this.leftTop = new Rectangle2D.Double(this.leftTop.x, y, w, h);
                Utils.drawLine(this.g, x1, y1, x1, y);
                Utils.drawLine(this.g, x1, y, x, y);
                y += (double)(h / 2);
            } else if (isLeft && !isTop) {
                if (this.leftBottom == null) {
                    this.leftBottom = new Rectangle2D.Double(this.gp.gRect2.x, this.gp.gRect2.y + this.gp.gRect2.height, 0.0, 0.0);
                }
                x = this.leftBottom.x;
                y = this.leftBottom.y - (double)h;
                this.leftBottom = new Rectangle2D.Double(x, this.leftBottom.y, w, h);
                Utils.drawLine(this.g, x1, y1, x1, y);
                Utils.drawLine(this.g, x1, y, x, y);
                w /= 2;
            } else if (!isLeft && isTop) {
                if (this.rightTop == null) {
                    this.rightTop = new Rectangle2D.Double(this.gp.gRect2.x + this.gp.gRect2.width, this.gp.gRect2.y, 0.0, 0.0);
                }
                x = x1 > (x = this.rightTop.x - (double)w - 2.0) ? this.rightTop.x : x;
                y = this.rightTop.y + (double)h;
                this.rightTop = new Rectangle2D.Double(x, this.rightTop.y, w, h);
                Utils.drawLine(this.g, x1, y1, x1, y);
                Utils.drawLine(this.g, x1, y, x, y);
                x -= (double)(w / 2);
            } else {
                if (this.rightBottom == null) {
                    this.rightBottom = new Rectangle2D.Double(this.gp.gRect2.x + this.gp.gRect2.width, this.gp.gRect2.y + this.gp.gRect2.height, 0.0, 0.0);
                }
                x = x1 > (x = this.rightBottom.x - (double)w) ? this.rightBottom.x : x;
                y = this.rightBottom.y - (double)h - 5.0;
                this.rightBottom = new Rectangle2D.Double(this.rightBottom.x, y, w, h);
                Utils.drawLine(this.g, x1, y1, x1, y);
                Utils.drawLine(this.g, x1, y, x, y);
                h /= 2;
            }
        } else {
            byte direction = this.angleToPosition(gfv, angle);
            if (!(this instanceof DrawRadar)) {
                int shiftX = 10;
                double x12 = x;
                double y1 = y;
                double x2 = x;
                double y2 = y;
                if (direction == 3) {
                    x = x12 = x - (double)shiftX;
                } else if (direction == 4) {
                    x = x2 = x + (double)shiftX;
                }
                boolean isOutText = gfv.outText(x, y, text, direction);
                if (isOutText) {
                    Color tmpc = this.egp.getAxisColor(6);
                    Line2D.Double tmpShape = new Line2D.Double(x12, y1, x2, y2);
                    this.g.setStroke(new BasicStroke(1.0f));
                    this.drawShape(tmpShape, tmpc);
                }
                return isOutText;
            }
            return gfv.outText(x, y, text, direction);
        }
        isLeft = x1 > x;
        if (isLeft) {
            x -= (double)w;
        }
        if (!isTop) {
            y += (double)h;
        }
        return gfv.outText(x, y, text, (byte)0);
    }

    public void drawText(String text, int x, int y, GraphFont gf) {
        if (!StringUtils.isValidString(text)) {
            return;
        }
        this.g.setColor(new Color(gf.getColor()));
    }

    public void drawGridLineV(double delx, int ci) {
        if (ci == 0 || ci == this.gp.tickNum || this.gp.gridLineStyle == 0) {
            return;
        }
        if (this.gp.gridLineLocation == 1) {
            return;
        }
        BasicStroke stroke = this.getLineStroke(this.gp.gridLineStyle, 1.0f);
        if (stroke == null) {
            return;
        }
        this.g.setColor(this.gp.gridColor);
        this.g.setStroke(stroke);
        Utils.drawLine(this.g, this.gp.gRect2.x + (double)ci * delx, this.gp.gRect2.y + this.gp.gRect2.height, this.gp.gRect2.x + (double)ci * delx, this.gp.gRect2.y + 1.0);
        this.g.setStroke(new BasicStroke(1.0E-5f));
        Utils.drawLine(this.g, this.gp.gRect1.x + (double)ci * delx, this.gp.gRect1.y + this.gp.gRect1.height, this.gp.gRect2.x + (double)ci * delx, this.gp.gRect2.y + this.gp.gRect2.height);
    }

    public void drawGridLine(double dely, int ci) {
        Color c = this.egp.getAxisColor(2);
        double tmpi = this.gp.gRect1.y + this.gp.gRect1.height - (double)ci * dely;
        if (c != null) {
            Utils.setStroke(this.g, c, 1, 1.0f);
            this.drawLine(this.gp.gRect1.x - this._$7.x - (double)this.gp.tickLen, tmpi, this.gp.gRect1.x - this._$7.x, tmpi, c);
        }
        if (ci == 0 || ci == this.gp.tickNum || this.gp.gridLineStyle == 0) {
            return;
        }
        if (this.gp.gridLineLocation == 1) {
            return;
        }
        BasicStroke bs = this.getLineStroke(this.gp.gridLineStyle, 1.0f);
        if (bs == null) {
            return;
        }
        this.g.setColor(this.gp.gridColor);
        this.g.setStroke(bs);
        Utils.drawLine(this.g, this.gp.gRect2.x, this.gp.gRect2.y + this.gp.gRect2.height - (double)ci * dely, this.gp.gRect2.x + this.gp.gRect2.width - 1.0, this.gp.gRect2.y + this.gp.gRect2.height - (double)ci * dely);
        if (c != null) {
            Utils.drawLine(this.g, this.gp.gRect1.x, this.gp.gRect1.y + this.gp.gRect1.height - (double)ci * dely, this.gp.gRect2.x, this.gp.gRect2.y + this.gp.gRect2.height - (double)ci * dely);
        }
    }

    public void drawGridLineCategoryV(double catX) {
        if (this.gp.gridLineStyle == 0) {
            return;
        }
        if (this.gp.gridLineLocation == 0) {
            return;
        }
        BasicStroke stroke = this.getLineStroke(this.gp.gridLineStyle, 1.0f);
        if (stroke == null) {
            return;
        }
        this.g.setColor(this.gp.gridColor);
        this.g.setStroke(stroke);
        Utils.drawLine(this.g, catX, this.gp.gRect2.y + this.gp.gRect2.height, catX, this.gp.gRect2.y + 1.0);
    }

    public void drawGridLineCategory(double catY) {
        if (this.gp.gridLineStyle == 0) {
            return;
        }
        if (this.gp.gridLineLocation == 0) {
            return;
        }
        BasicStroke stroke = this.getLineStroke(this.gp.gridLineStyle, 1.0f);
        if (stroke == null) {
            return;
        }
        this.g.setColor(this.gp.gridColor);
        this.g.setStroke(stroke);
        Utils.drawLine(this.g, this.gp.gRect2.x + 1.0, catY, this.gp.gRect2.x + this.gp.gRect2.width, catY);
    }

    public void keepGraphSpace() {
        boolean isPie = this instanceof DrawPie || this instanceof DrawPie3DObj;
        int space = this.gp.graphMargin;
        if (isPie) {
            if (space > -1) {
                this.gp.leftInset += space;
                this.gp.rightInset += space;
                this.gp.topInset += space;
                this.gp.bottomInset += space;
                return;
            }
            ArrayList cats = this.egp.categories;
            int cc = cats.size();
            double maxW = 0.0;
            double maxH = 0.0;
            for (int i = 0; i < cc; ++i) {
                ExtGraphCategory egc = (ExtGraphCategory)cats.get(i);
                ArrayList sers = egc.getSeries();
                for (int n = 0; n < sers.size(); ++n) {
                    String text = "";
                    ExtGraphSery egs = (ExtGraphSery)sers.get(n);
                    switch (this.gp.dispValueType) {
                        case 1: {
                            text = "";
                            break;
                        }
                        case 2: {
                            String fmt = StringUtils.isValidString(this.gp.dataMarkFormat) ? this.gp.dataMarkFormat : "";
                            text = this.getFormattedValue(egs.getValue(), fmt);
                            break;
                        }
                        default: {
                            String fmt = StringUtils.isValidString(this.gp.dataMarkFormat) ? this.gp.dataMarkFormat : "0.00%";
                            text = this.getFormattedValue(egs.getValue(), fmt);
                        }
                    }
                    Rectangle rec = this.gp.GFV_VALUE.getTextSize(text);
                    if (rec.getWidth() > maxW) {
                        maxW = rec.getWidth();
                    }
                    if (!(rec.getHeight() > maxH)) continue;
                    maxH = rec.getHeight();
                }
            }
            this.gp.leftInset = (int)((double)this.gp.leftInset + maxW);
            this.gp.rightInset = (int)((double)this.gp.rightInset + maxW);
            this.gp.topInset = (int)((double)this.gp.topInset + maxH);
            this.gp.bottomInset = (int)((double)this.gp.bottomInset + maxH);
        } else {
            if (space == -1) {
                space = 5;
            }
            this.gp.leftInset += space;
            this.gp.rightInset += space;
            this.gp.topInset += space;
            this.gp.bottomInset += space;
        }
    }

    public void drawTitle() {
        if (!StringUtils.isValidString(this.gp.GFV_TITLE.text)) {
            return;
        }
        int y = 0;
        this.TR = this.gp.GFV_TITLE.getTextSize();
        y = this.gp.topInset + this.TR.height;
        Point2D.Double p = new Point2D.Double(0.0, y);
        this._$5 = new ValueLabel(this.gp.GFV_TITLE.text, p, null);
        this.gp.topInset += this.TR.height + 4;
    }

    public void drawGraphRect() {
        ChartColor fillColor;
        double h;
        double w;
        double y;
        double x;
        if (this.gp.graphBackColor != null) {
            double bx = this.gp.gRect2.x;
            double by = this.gp.gRect2.y;
            double bw = this.gp.gRect2.width;
            double bh = this.gp.gRect2.height;
            if (this.egp.isGradientColor()) {
                CubeColor ccr = new CubeColor(this.gp.graphBackColor);
                ChartColor tmpcc = new ChartColor();
                tmpcc.setColor1(ccr.getLight(0.95f));
                tmpcc.setColor2(ccr.getLight(0.65f));
                tmpcc.setAngle(0);
                Utils.setPaint(this.g, bx, by, bw, bh, tmpcc);
            } else {
                this.g.setColor(this.gp.graphBackColor);
            }
            Utils.fillRect(this.g, bx, by, bw, bh);
        }
        double vx = 0.0;
        double vy = 0.0;
        double hx = 0.0;
        double hy = 0.0;
        this.g.setStroke(new BasicStroke(1.0f));
        double x1 = this.gp.gRect2.x;
        double y1 = this.gp.gRect2.y;
        double x2 = x1 + this.gp.gRect2.width;
        double y2 = y1;
        Color c = this.egp.getAxisColor(0);
        this.drawLine(x1, y1, x2, y2, c);
        x1 = x2;
        y1 = y2 + this.gp.gRect2.height;
        c = this.egp.getAxisColor(3);
        this.drawLine(x1, y1, x2, y2, c);
        double coorShift = this.gp.gRect2.x - this.gp.gRect1.x;
        c = this.egp.getAxisColor(1);
        if (c != null) {
            if (coorShift != 0.0) {
                if (this.egp.isGradientColor()) {
                    x = this.gp.gRect1.x;
                    y = this.gp.gRect1.y + this.gp.gRect1.height;
                    w = this.gp.gRect1.width;
                    hy = h = Utils.getPlatformH(coorShift);
                    fillColor = new ChartColor(c);
                    Utils.draw3DRect(this.g, x, y, w, h, null, 0, 0.0f, false, false, 1.0f, fillColor, true, coorShift);
                } else {
                    x2 = x1 - this.gp.gRect2.width;
                    y2 = y1;
                    this.drawLine(x1, y1, x2, y2, c);
                    this.drawLine(this.gp.gRect1.x, this.gp.gRect1.y + this.gp.gRect1.height, this.gp.gRect1.x + this.gp.gRect1.width, this.gp.gRect1.y + this.gp.gRect1.height, c);
                    this.drawLine(this.gp.gRect1.x, this.gp.gRect1.y + this.gp.gRect1.height, this.gp.gRect2.x, this.gp.gRect2.y + this.gp.gRect2.height, c);
                    this.drawLine(this.gp.gRect1.x + this.gp.gRect1.width, this.gp.gRect1.y + this.gp.gRect1.height, this.gp.gRect2.x + this.gp.gRect2.width, this.gp.gRect2.y + this.gp.gRect2.height, c);
                }
            } else {
                x1 = this.gp.gRect1.x;
                y1 = this.gp.gRect1.y + this.gp.gRect1.height;
                x2 = x1 + this.gp.gRect1.width;
                y2 = y1;
                this.drawLine(x1, y1, x2, y2, c);
            }
        } else {
            hx = coorShift;
            hy = -coorShift;
        }
        this._$6 = new Point2D.Double(hx, hy);
        c = this.egp.getAxisColor(2);
        if (c != null) {
            if (coorShift != 0.0) {
                if (this.egp.isGradientColor()) {
                    w = Utils.getPlatformH(coorShift);
                    x = this.gp.gRect1.x - w;
                    y = this.gp.gRect1.y;
                    h = this.gp.gRect1.height;
                    vx = w;
                    fillColor = new ChartColor(c);
                    Utils.draw3DRect(this.g, x, y, w, h, null, 0, 0.0f, false, false, 1.0f, fillColor, false, coorShift);
                } else {
                    x1 = this.gp.gRect2.x;
                    y1 = this.gp.gRect2.y;
                    this.drawLine(x1, y1, x2, y2, c);
                    this.drawLine(this.gp.gRect1.x, this.gp.gRect1.y, this.gp.gRect1.x, this.gp.gRect1.y + this.gp.gRect1.height, c);
                    this.drawLine(this.gp.gRect1.x, this.gp.gRect1.y + this.gp.gRect1.height, this.gp.gRect2.x, this.gp.gRect2.y + this.gp.gRect2.height, c);
                    this.drawLine(this.gp.gRect1.x, this.gp.gRect1.y, this.gp.gRect2.x, this.gp.gRect2.y, c);
                }
            } else {
                x1 = this.gp.gRect1.x;
                y1 = this.gp.gRect1.y;
                x2 = x1;
                y2 = y1 + this.gp.gRect1.height;
                this.drawLine(x1, y1, x2, y2, c);
            }
        } else {
            vx = -coorShift;
            vy = coorShift;
        }
        this._$7 = new Point2D.Double(vx, vy);
    }

    private String _$1() {
        String label = "";
        label = this.egp.isBarGraph(this) ? this.gp.GFV_YTITLE.text : this.gp.GFV_XTITLE.text;
        return label;
    }

    public void drawLabel() {
        String label = this._$1();
        int x = 0;
        int y = 0;
        if (StringUtils.isValidString(label)) {
            this.TR = this.gp.GFV_XTITLE.getTextSize(label);
            y = this.gp.graphHeight - this.gp.bottomInset;
            this._$2 = new ValueLabel(label, new Point2D.Double(0.0, y), null);
            this.gp.bottomInset += this.TR.height + 2;
        }
        if (StringUtils.isValidString(label = this.egp.isBarGraph(this) ? this.gp.GFV_XTITLE.text : this.gp.GFV_YTITLE.text)) {
            this.TR = this.gp.GFV_YTITLE.getTextSize(label);
            x = this.gp.leftInset;
            this._$4 = new ValueLabel(label, new Point2D.Double(x, 0.0), null);
            this.gp.leftInset += this.TR.width + 4;
        }
        if (this.egp.is2YGraph() && StringUtils.isValidString(this.gp.GFV_YTITLE.text2)) {
            this.TR = this.gp.GFV_YTITLE.getTextSize(this.gp.GFV_YTITLE.text2);
            x = this.gp.graphWidth - this.gp.rightInset;
            this._$3 = new ValueLabel(this.gp.GFV_YTITLE.text2, new Point2D.Double(x, 0.0), null);
            this.gp.rightInset += this.TR.width + 4;
        }
    }

    public void drawPoint(Point2D.Double pt, int shape, double radius, int borderStyle, float borderWeight, Color backColor, Color foreColor) {
        if (this.egp.isDrawShade()) {
            Utils.drawCartesianPoint1(this.g, pt, shape, radius, radius, radius, borderStyle, borderWeight, this.getTransparent());
        }
        Utils.drawCartesianPoint2(this.g, pt, shape, radius, radius, radius, borderStyle, borderWeight, this.getChartColor(backColor), foreColor, this.getTransparent());
    }

    public void htmlLink(double x1, double y1, double w, double h, StringBuffer sb, Object category, ExtGraphSery egs) {
        if (this._$2() || sb == null) {
            return;
        }
        int minimum = 10;
        if (w < (double)minimum) {
            w = minimum;
        }
        if (h < (double)minimum) {
            h = minimum;
        }
        String coordx = this.isSVG() ? "x=\"" + (int)x1 + "\" y=\"" + (int)y1 + "\" width=\"" + (int)w + "\" height=\"" + (int)h + "\"" : (int)x1 + "," + (int)y1 + "," + (int)(x1 + w) + "," + (int)(y1 + h);
        sb.append(this.getStgLinkHtml(this.egp.getLink(), "rect", coordx, this.egp.getLinkTarget(), egs.getName(), category, this.getDispValue(egs), egs.getTips()));
    }

    public void htmlLink2(double x1, double y1, double w, double h, StringBuffer sb, Object category, ExtGraphSery egs) {
        String coordx;
        if (this._$2() || sb == null) {
            return;
        }
        int minimum = 10;
        if (w < (double)minimum) {
            w = minimum;
        }
        if (h < (double)minimum) {
            h = minimum;
        }
        if (this.isSVG()) {
            if (!StringUtils.isValidString(this.egp.getLink())) {
                return;
            }
            coordx = "x=\"" + (int)x1 + "\" y=\"" + (int)y1 + "\" width=\"" + (int)w + "\" height=\"" + (int)h + "\"";
        } else {
            coordx = (int)x1 + "," + (int)y1 + "," + (int)(x1 + w) + "," + (int)(y1 + h);
        }
        sb.append(this.getStgLinkHtml(this.egp.getLink(), "rect", coordx, this.egp.getLinkTarget(), egs.getName(), category, this.getDispValue2(egs), egs.getTips()));
    }

    public void htmlLink(Arc2D.Double ddd, StringBuffer sb, Object category, ExtGraphSery egs, Arc2D.Double ddd2) {
        if (this._$2()) {
            return;
        }
        String shape = "";
        if (this.isSVG()) {
            if (!StringUtils.isValidString(this.egp.getLink())) {
                if (this._$1) {
                    Logger.debug("SVG graph must specify link to generate hyper links.");
                    this._$1 = false;
                }
                return;
            }
            shape = "polygon";
        } else {
            shape = "poly";
        }
        StringBuffer coords = new StringBuffer();
        int cx = (int)ddd.getCenterX();
        int cy = (int)ddd.getCenterY();
        double start = ddd.getAngleStart();
        double end = ddd.getAngleStart() + ddd.getAngleExtent();
        double delta = 5.0;
        if (this.isSVG()) {
            coords.append("points=\"");
        }
        String seperator = ",";
        if (this.isSVG()) {
            seperator = " ";
        }
        if (ddd2 == null) {
            coords.append(cx);
            coords.append(seperator + cy + ",");
        }
        coords.append((int)ddd.getStartPoint().getX());
        coords.append(seperator + (int)ddd.getStartPoint().getY());
        start += delta;
        while (start < end) {
            Arc2D.Double tmp = new Arc2D.Double(ddd.getBounds(), start, delta, 2);
            coords.append("," + (int)tmp.getEndPoint().getX());
            coords.append(seperator + (int)tmp.getEndPoint().getY());
            start += delta;
        }
        coords.append("," + (int)ddd.getEndPoint().getX());
        coords.append(seperator + (int)ddd.getEndPoint().getY());
        if (ddd2 != null) {
            coords.append("," + (int)ddd2.getEndPoint().getX());
            coords.append(seperator + (int)ddd2.getEndPoint().getY());
            double start2 = ddd2.getAngleStart();
            for (double end2 = ddd2.getAngleStart() + ddd2.getAngleExtent() - delta; end2 > start2; end2 -= delta) {
                Arc2D.Double tmp = new Arc2D.Double(ddd2.getBounds(), end2, delta, 2);
                coords.append("," + (int)tmp.getStartPoint().getX());
                coords.append(seperator + (int)tmp.getStartPoint().getY());
            }
            coords.append("," + (int)ddd2.getStartPoint().getX());
            coords.append(seperator + (int)ddd2.getStartPoint().getY());
        }
        String dispVal = null;
        if (!egs.isNull()) {
            double scaledVal = this.getScaledValue(egs.getValue(), true);
            dispVal = this.getDispValue(scaledVal, egs.getTips());
        }
        if (this.isSVG()) {
            coords.append("\"");
        }
        sb.append(this.getStgLinkHtml(this.egp.getLink(), shape, coords.toString(), this.egp.getLinkTarget(), egs.getName(), category, dispVal, egs.getTips()));
    }

    public Stroke getLineStroke() {
        return this.getLineStroke(this.egp.getLineStyle(), this.gp.getLineThick());
    }

    public BasicStroke getLineStroke(int style, float thick) {
        if (thick == 0.0f) {
            return null;
        }
        float[] dashes = new float[]{2.0f};
        switch (style) {
            case 1: {
                return new BasicStroke(thick);
            }
            case 5: {
                dashes = new float[]{2.0f, 2.0f, 6.0f, 2.0f};
                break;
            }
            case 4: {
                dashes = new float[]{2.0f, 2.0f, 2.0f, 2.0f, 6.0f, 2.0f};
                break;
            }
            case 2: {
                dashes = new float[]{5.0f};
                break;
            }
            case 3: {
                dashes = new float[]{2.0f};
                break;
            }
            default: {
                return null;
            }
        }
        return new BasicStroke(thick, 0, 2, thick, dashes, 0.0f);
    }

    public Point2D.Double getCoorPoint(double alarmVal) {
        return null;
    }

    public void drawWarnLine() {
        ArrayList warnLines = this.egp.getAlarmLines();
        if (warnLines == null) {
            return;
        }
        Stroke s = this.g.getStroke();
        int cc = warnLines.size();
        double topTickVal = ((Number)this.gp.coorValue.get(this.gp.tickNum)).doubleValue();
        double bottomTickVal = ((Number)this.gp.coorValue.get(0)).doubleValue();
        double tickArea = Math.abs(bottomTickVal - topTickVal);
        for (int i = 0; i < cc; ++i) {
            float thick;
            ExtAlarmLine eal = (ExtAlarmLine)warnLines.get(i);
            byte lineType = eal.getLineType();
            BasicStroke bs = this.getLineStroke(lineType, thick = eal.getLineThick());
            if (bs == null) continue;
            this.g.setStroke(bs);
            int lineColor = eal.getColor();
            this.g.setColor(new Color(lineColor));
            double value = eal.getAlarmValue() / this.gp.scaleMark;
            double y1 = this.gp.gRect2.y + Math.abs(value - topTickVal) / tickArea * this.gp.gRect2.height;
            double x1 = this.gp.gRect2.x;
            double x2 = x1 + this.gp.gRect2.width;
            double y2 = y1;
            Utils.drawLine(this.g, x1, y1, x2, y2);
            if (!eal.isDrawAlarmValue()) continue;
            String scoory = this.getFormattedValue(value);
            this.TR.setBounds(this.gp.GFV_YLABEL.getTextSize(scoory));
            x1 = this.gp.gRect1.x - (double)this.gp.tickLen;
            Color tmp = this.gp.GFV_YLABEL.color;
            this.gp.GFV_YLABEL.color = new Color(lineColor);
            this.gp.GFV_YLABEL.outText(x1, y1 += this.gp.gRect1.y - this.gp.gRect2.y, scoory, (byte)3);
            this.gp.GFV_YLABEL.color = tmp;
        }
        this.g.setStroke(s);
    }

    public void drawWarnLineH() {
        ArrayList warnLines = this.egp.getAlarmLines();
        if (warnLines == null) {
            return;
        }
        Stroke s = this.g.getStroke();
        int cc = warnLines.size();
        double rightTickVal = ((Number)this.gp.coorValue.get(this.gp.tickNum)).doubleValue();
        double leftTickVal = ((Number)this.gp.coorValue.get(0)).doubleValue();
        double tickArea = Math.abs(rightTickVal - leftTickVal);
        for (int i = 0; i < cc; ++i) {
            ExtAlarmLine eal = (ExtAlarmLine)warnLines.get(i);
            byte lineType = eal.getLineType();
            BasicStroke bs = this.getLineStroke(lineType, eal.getLineThick());
            if (bs == null) continue;
            this.g.setStroke(bs);
            int lineColor = eal.getColor();
            this.g.setColor(new Color(lineColor));
            double value = eal.getAlarmValue() / this.gp.scaleMark;
            double x1 = this.gp.gRect2.x + Math.abs(value - leftTickVal) / tickArea * this.gp.gRect2.width;
            double y1 = this.gp.gRect2.y;
            double x2 = x1;
            double y2 = y1 + this.gp.gRect2.height;
            Utils.drawLine(this.g, x1, y1, x2, y2);
            if (!eal.isDrawAlarmValue()) continue;
            String scoory = this.getFormattedValue(value);
            this.TR.setBounds(this.gp.GFV_YLABEL.getTextSize(scoory));
            y1 = y2 + (double)this.gp.tickLen;
            Color tmp = this.gp.GFV_XLABEL.color;
            this.gp.GFV_XLABEL.color = new Color(lineColor);
            this.gp.GFV_XLABEL.outText(x1 -= this.gp.gRect1.x - this.gp.gRect2.x, y1, scoory, (byte)2);
            this.gp.GFV_XLABEL.color = tmp;
        }
        this.g.setStroke(s);
    }

    public GraphFontView getGraphFontView(GraphFont gf, String text, int fontType) {
        GraphFontView gfv = new GraphFontView(this);
        gfv.setAngle(gf.getAngle());
        gfv.setVertical(gf.isVerticalText());
        Color c = new Color(gf.getColor());
        if (gf.getColor() == 0xFFFFFF) {
            c = new Color(c.getRed(), c.getGreen(), c.getBlue(), 0);
        }
        gfv.setColor(c);
        Font font = this.getFont(gf.getFamily(), gf.getSize(), fontType, gf.isAutoResize(), gf.isBold(), false, text);
        gfv.setFont(font);
        gfv.setText(text);
        gfv.setTextPosition(this.getTextDefaultPosition(fontType));
        return gfv;
    }

    protected Font getFont(String face, int size, int fontType, boolean autoSize, boolean isBold, boolean isItalic, String text) {
        int style = 0;
        if (isBold) {
            ++style;
        }
        if (isItalic) {
            style += 2;
        }
        if (face == null || face.trim().length() < 1) {
            face = "dialog";
        }
        if (!autoSize) {
            return new Font(face, style, size);
        }
        int len = 0;
        len = this.egp.getCategories().size() == 0 ? 4 : (this.gp.catNames.get(0) == null ? 0 : Variant.toString(this.gp.catNames.get(0)).length());
        switch (fontType) {
            case 0: {
                size = Math.round((this.gp.graphWidth < this.gp.graphHeight ? this.gp.graphWidth : this.gp.graphHeight) / 15);
                size = size > 17 ? 17 : size;
                break;
            }
            case 1: {
                size = Math.round((this.gp.graphWidth - this.gp.leftInset) / (this.gp.serNames.size() == 0 ? 1 : this.gp.serNames.size()) / (len == 0 ? 1 : len));
                size = size > 13 ? 13 : size;
                size = size < 3 ? 0 : size;
                break;
            }
            case 2: {
                int tmp = 1;
                size = Math.round((this.gp.graphWidth - this.gp.leftInset) / (this.gp.catNames.size() == 0 ? 1 : this.gp.catNames.size()) / tmp);
                size = size > 13 ? 13 : size;
                size = size < 3 ? 0 : size;
                break;
            }
            case 4: {
                size = Math.round((this.gp.graphWidth - this.gp.leftInset - this.gp.rightInset) / (text == null || text.trim().length() == 0 ? 1 : text.length()));
                size = size > 13 ? 13 : size;
                size = size < 3 ? 0 : size;
                break;
            }
            case 3: {
                size = Math.round((this.gp.graphHeight - this.gp.topInset - this.gp.bottomInset) / (this.gp.tickNum == 0 ? 1 : this.gp.tickNum));
                size = size > 13 ? 13 : size;
                size = size < 3 ? 0 : size;
                break;
            }
            case 5: {
                size = Math.round((this.gp.graphHeight - this.gp.topInset - this.gp.bottomInset) / (text == null || text.trim().length() == 0 ? 1 : text.length()));
                size = size > 13 ? 13 : size;
                size = size < 3 ? 0 : size;
                break;
            }
        }
        return new Font(face, style, size);
    }

    protected byte getTextDefaultPosition(int fontType) {
        byte pos = 0;
        switch (fontType) {
            case 0: {
                pos = 2;
                break;
            }
            case 1: {
                pos = 4;
                break;
            }
            case 2: {
                pos = 2;
                break;
            }
            case 4: {
                pos = 1;
                break;
            }
            case 3: {
                pos = 3;
                break;
            }
            case 5: {
                pos = 4;
                break;
            }
            case 6: {
                pos = 1;
            }
        }
        return pos;
    }

    public void createCoorValue() {
        boolean isUserValue = this.egp.isUserSetYEndValue1();
        this.createCoorValue(!isUserValue);
    }

    private double _$1(double max) {
        if (max > 50.0) {
            return 10.0 * this.gp.coorScale;
        }
        if (max > 5.0) {
            return 5.0 * this.gp.coorScale;
        }
        return 1.0 * this.gp.coorScale;
    }

    public void createCoorValue(boolean adjustMaxValue) {
        boolean isChinese;
        double tmp;
        if (!this.egp.isStackedGraph(this)) {
            this.gp.maxPositive = this.gp.maxValue;
            this.gp.minNegative = this.gp.minValue;
        }
        if (this.gp.maxValue < this.gp.minValue && adjustMaxValue) {
            tmp = this.gp.maxValue;
            this.gp.maxValue = this.gp.minValue;
            this.gp.minValue = tmp;
        }
        if (this.gp.maxValue != 0.0 && (tmp = this.gp.maxValue * 0.1) == this.gp.maxValue) {
            throw new RuntimeException("The max value is infinite.");
        }
        if (this.gp.minValue != 0.0 && (tmp = this.gp.minValue * 10.0) == this.gp.minValue) {
            throw new RuntimeException("The min value is infinite.");
        }
        if (this.egp.is2YGraph()) {
            boolean isUserValue2 = this.egp.isUserSetYEndValue2();
            this.createCoorValue2(!isUserValue2);
        }
        double doubleTmp = 0.0;
        this.gp.coorScale = 1.0;
        if (this.gp.minValue >= 0.0) {
            double veryMin;
            if (this.gp.maxValue == 0.0) {
                this.gp.maxValue = 1.0;
            }
            while (this.gp.maxValue > 100.0) {
                this.gp.coorScale *= 10.0;
                this.gp.maxValue *= 0.1;
            }
            while (this.gp.maxValue <= 1.0) {
                this.gp.coorScale *= 0.1;
                this.gp.maxValue *= 10.0;
            }
            if (this.gp.interval == 0.0) {
                this.gp.interval = this._$1(this.gp.maxValue);
            }
            if (this.gp.maxValue % (this.gp.interval / this.gp.coorScale) > (veryMin = 1.0E-6) && adjustMaxValue) {
                this.gp.maxValue = this.gp.maxValue - this.gp.maxValue % (this.gp.interval / this.gp.coorScale) + this.gp.interval / this.gp.coorScale;
            }
            this.gp.tickNum = (int)(this.gp.maxValue / (this.gp.interval / this.gp.coorScale));
            if (this.gp.minTicknum > 0 && this.gp.tickNum < this.gp.minTicknum) {
                this.gp.tickNum = this.gp.minTicknum;
                if (this.gp.maxValue % (double)this.gp.tickNum > 0.0 && adjustMaxValue) {
                    this.gp.maxValue = this.gp.maxValue - this.gp.maxValue % (double)this.gp.tickNum + (double)this.gp.tickNum;
                }
            }
            if (this.gp.maxValue == 0.0) {
                this.gp.maxValue = 1.0;
            }
            for (int i = 0; i <= this.gp.tickNum; ++i) {
                doubleTmp = this.gp.scaleMark == 2.0 ? (double)i * this.gp.maxValue / (double)this.gp.tickNum : (double)i * this.gp.maxValue * (this.gp.coorScale / this.gp.scaleMark) / (double)this.gp.tickNum;
                this.gp.coorValue.add(i, new Double(doubleTmp + this.gp.baseValue));
            }
        } else if (this.gp.maxValue <= 0.0) {
            doubleTmp = this.gp.maxValue;
            this.gp.maxValue = Math.abs(this.gp.minValue);
            this.gp.minValue = Math.abs(doubleTmp);
            if (this.gp.maxValue == 0.0) {
                this.gp.maxValue = 1.0;
            }
            while (this.gp.maxValue > 100.0) {
                this.gp.coorScale *= 10.0;
                this.gp.maxValue *= 0.1;
            }
            while (this.gp.maxValue < 1.0) {
                this.gp.coorScale *= 0.1;
                this.gp.maxValue *= 10.0;
            }
            if (this.gp.interval == 0.0) {
                this.gp.interval = this._$1(this.gp.maxValue);
            }
            if (this.gp.maxValue % (this.gp.interval / this.gp.coorScale) != 0.0 && adjustMaxValue) {
                this.gp.maxValue = this.gp.maxValue - this.gp.maxValue % (this.gp.interval / this.gp.coorScale) + this.gp.interval / this.gp.coorScale;
            }
            this.gp.tickNum = (int)(this.gp.maxValue / (this.gp.interval / this.gp.coorScale));
            if (this.gp.minTicknum > 0 && this.gp.tickNum < this.gp.minTicknum) {
                this.gp.tickNum = this.gp.minTicknum;
                if (this.gp.maxValue % (double)this.gp.tickNum > 0.0 && adjustMaxValue) {
                    this.gp.maxValue = this.gp.maxValue - this.gp.maxValue % (double)this.gp.tickNum + (double)this.gp.tickNum;
                }
            }
            if (this.gp.maxValue == 0.0) {
                this.gp.maxValue = 1.0;
            }
            for (int i = 0; i <= this.gp.tickNum; ++i) {
                doubleTmp = this.gp.scaleMark == 2.0 ? (double)(-(this.gp.tickNum - i)) * this.gp.maxValue / (double)this.gp.tickNum : (double)(-(this.gp.tickNum - i)) * this.gp.maxValue * (this.gp.coorScale / this.gp.scaleMark) / (double)this.gp.tickNum;
                this.gp.coorValue.add(i, new Double(doubleTmp + this.gp.baseValue));
            }
        } else {
            double absMax = this.gp.maxValue;
            double absMin = Math.abs(this.gp.minValue);
            if (this.gp.maxValue < Math.abs(this.gp.minValue)) {
                absMin = absMax;
                absMax = Math.abs(this.gp.minValue);
            }
            if (absMax == 0.0) {
                absMax = 1.0;
            }
            while (absMax > 100.0) {
                this.gp.coorScale *= 10.0;
                absMax *= 0.1;
            }
            while (absMax < 1.0) {
                this.gp.coorScale *= 0.1;
                absMax *= 10.0;
            }
            if (this.gp.interval == 0.0) {
                this.gp.interval = this._$1(absMax);
            }
            if (absMax % (this.gp.interval / this.gp.coorScale) != 0.0 && adjustMaxValue) {
                absMax = absMax - absMax % (this.gp.interval / this.gp.coorScale) + this.gp.interval / this.gp.coorScale;
            }
            this.gp.tickNum = (int)(absMax / (this.gp.interval / this.gp.coorScale));
            if (this.gp.minTicknum > 0 && this.gp.tickNum < this.gp.minTicknum) {
                this.gp.tickNum = this.gp.minTicknum;
                if (absMax % (double)this.gp.tickNum > 0.0 && adjustMaxValue) {
                    absMax = absMax - absMax % (double)this.gp.tickNum + (double)this.gp.tickNum;
                }
            }
            if (this.gp.scaleMark != 2.0) {
                absMin *= this.gp.scaleMark / this.gp.coorScale;
            }
            boolean addPositive = false;
            boolean addNegative = false;
            int intTmp = this.gp.tickNum;
            this.gp.coorValue.add(new Double(0.0 + this.gp.baseValue));
            for (int i = 1; i <= intTmp; ++i) {
                doubleTmp = this.gp.scaleMark == 2.0 ? (double)i * absMax / (double)intTmp : (double)i * absMax * (this.gp.coorScale / this.gp.scaleMark) / (double)intTmp;
                if (doubleTmp < this.gp.maxValue) {
                    this.gp.coorValue.add(new Double(doubleTmp + this.gp.baseValue));
                } else if (!addPositive) {
                    addPositive = true;
                    this.gp.coorValue.add(new Double(doubleTmp + this.gp.baseValue));
                }
                doubleTmp *= -1.0;
                if (doubleTmp > this.gp.minValue) {
                    this.gp.coorValue.add(new Double(doubleTmp + this.gp.baseValue));
                    continue;
                }
                if (addNegative) continue;
                addNegative = true;
                this.gp.coorValue.add(new Double(doubleTmp + this.gp.baseValue));
            }
            Collections.sort(this.gp.coorValue);
            this.gp.tickNum = this.gp.coorValue.size() - 1;
            this.gp.maxValue = Math.abs(((Number)this.gp.coorValue.get(0)).doubleValue()) + Math.abs(((Number)this.gp.coorValue.get(this.gp.tickNum)).doubleValue());
            this.gp.maxValue *= this.gp.scaleMark / this.gp.coorScale;
        }
        this.gp.minValue = 0.0;
        boolean bl = isChinese = GCBase.LANGUAGE == 0;
        if (isChinese) {
            if (this.gp.scaleMark == 2.0 && this.gp.coorScale != 1.0) {
                this.gp.GFV_YTITLE.text = this.gp.coorScale > 1000.0 ? this.gp.GFV_YTITLE.text + "(" + GraphParam.xToChinese(this.gp.coorScale) + ")" : this.gp.GFV_YTITLE.text + "(\u6bd4\u4f8b\uff1a1:" + this.gp.coorScale + ")";
            } else if (this.gp.scaleMark != 1.0) {
                if (this.gp.scaleMark == 1000.0) {
                    this.gp.GFV_YTITLE.text = this.gp.GFV_YTITLE.text + "(\u5343)";
                } else if (this.gp.scaleMark == 10000.0) {
                    this.gp.GFV_YTITLE.text = this.gp.GFV_YTITLE.text + "(\u4e07)";
                } else if (this.gp.scaleMark == 1000000.0) {
                    this.gp.GFV_YTITLE.text = this.gp.GFV_YTITLE.text + "(\u767e\u4e07)";
                } else if (this.gp.scaleMark == 1.0E7) {
                    this.gp.GFV_YTITLE.text = this.gp.GFV_YTITLE.text + "(\u5343\u4e07)";
                } else if (this.gp.scaleMark == 1.0E8) {
                    this.gp.GFV_YTITLE.text = this.gp.GFV_YTITLE.text + "(\u4ebf)";
                } else if (this.gp.scaleMark == 1.0E9) {
                    this.gp.GFV_YTITLE.text = this.gp.GFV_YTITLE.text + "(\u5341\u4ebf)";
                } else if (this.gp.scaleMark == 0.01) {
                    this.gp.GFV_YTITLE.text = this.gp.GFV_YTITLE.text + "(\u767e\u5206\u4e4b\u4e00)";
                } else if (this.gp.scaleMark == 0.001) {
                    this.gp.GFV_YTITLE.text = this.gp.GFV_YTITLE.text + "(\u5343\u5206\u4e4b\u4e00)";
                } else if (this.gp.scaleMark == 1.0E-4) {
                    this.gp.GFV_YTITLE.text = this.gp.GFV_YTITLE.text + "(\u4e07\u5206\u4e4b\u4e00)";
                } else if (this.gp.scaleMark == 1.0E-6) {
                    this.gp.GFV_YTITLE.text = this.gp.GFV_YTITLE.text + "(\u767e\u4e07\u5206\u4e4b\u4e00)";
                }
            }
        } else {
            double unit = 1.0;
            unit = this.gp.scaleMark == 2.0 && this.gp.coorScale != 1.0 ? this.gp.coorScale : this.gp.scaleMark;
            if (unit != 1.0) {
                if (unit == 1000.0) {
                    this.gp.GFV_YTITLE.text = this.gp.GFV_YTITLE.text + "(K)";
                } else if (unit == 10000.0) {
                    this.gp.GFV_YTITLE.text = this.gp.GFV_YTITLE.text + "(10K)";
                } else if (unit == 1000000.0) {
                    this.gp.GFV_YTITLE.text = this.gp.GFV_YTITLE.text + "(M)";
                } else if (unit == 1.0E7) {
                    this.gp.GFV_YTITLE.text = this.gp.GFV_YTITLE.text + "(10M)";
                } else if (unit == 1.0E8) {
                    this.gp.GFV_YTITLE.text = this.gp.GFV_YTITLE.text + "(100M)";
                } else if (unit == 1.0E9) {
                    this.gp.GFV_YTITLE.text = this.gp.GFV_YTITLE.text + "(B)";
                } else if (unit == 0.01) {
                    this.gp.GFV_YTITLE.text = this.gp.GFV_YTITLE.text + "(Percentage%)";
                } else if (unit == 0.001) {
                    this.gp.GFV_YTITLE.text = this.gp.GFV_YTITLE.text + "(\u00d710\u207b\u00b3)";
                } else if (unit == 1.0E-4) {
                    this.gp.GFV_YTITLE.text = this.gp.GFV_YTITLE.text + "(\u00d710\u207b\u2074)";
                } else if (unit == 1.0E-6) {
                    this.gp.GFV_YTITLE.text = this.gp.GFV_YTITLE.text + "(\u00d710\u207b\u2076)";
                }
            }
        }
    }

    public void createCoorValue2(boolean adjustMaxValue) {
        boolean ISCHINESE;
        double doubleTmp = 0.0;
        this.gp.coorScale2 = 1.0;
        if (this.gp.minValue2 >= 0.0) {
            if (this.gp.maxValue2 == 0.0 && adjustMaxValue) {
                this.gp.maxValue2 = 1.0;
            }
            while (this.gp.maxValue2 > 100.0) {
                this.gp.coorScale2 *= 10.0;
                this.gp.maxValue2 *= 0.1;
            }
            while (this.gp.maxValue2 < 1.0) {
                this.gp.coorScale2 *= 0.1;
                this.gp.maxValue2 *= 10.0;
            }
            if (this.gp.interval2 == 0.0) {
                this.gp.interval2 = this.gp.maxValue2 > 50.0 ? 10.0 * this.gp.coorScale2 : 5.0 * this.gp.coorScale2;
            }
            if (this.gp.maxValue2 % (this.gp.interval2 / this.gp.coorScale2) != 0.0 && adjustMaxValue) {
                this.gp.maxValue2 = this.gp.maxValue2 - this.gp.maxValue2 % (this.gp.interval2 / this.gp.coorScale2) + this.gp.interval2 / this.gp.coorScale2;
            }
            this.gp.tickNum2 = (int)(this.gp.maxValue2 / (this.gp.interval2 / this.gp.coorScale2));
            if (this.gp.minTicknum2 > 0 && this.gp.tickNum2 < this.gp.minTicknum2) {
                this.gp.tickNum2 = this.gp.minTicknum2;
                if (this.gp.maxValue2 % (double)this.gp.tickNum2 > 0.0 && adjustMaxValue) {
                    this.gp.maxValue2 = this.gp.maxValue2 - this.gp.maxValue2 % (double)this.gp.tickNum2 + (double)this.gp.tickNum2;
                }
            }
            if (this.gp.maxValue2 == 0.0 && adjustMaxValue) {
                this.gp.maxValue2 = 1.0;
            }
            for (int i = 0; i <= this.gp.tickNum2; ++i) {
                doubleTmp = this.gp.scaleMark == 2.0 ? (double)i * this.gp.maxValue2 / (double)this.gp.tickNum2 : (double)i * this.gp.maxValue2 * (this.gp.coorScale2 / this.gp.scaleMark) / (double)this.gp.tickNum2;
                this.gp.coorValue2.add(i, new Double(doubleTmp + this.gp.baseValue2));
            }
        } else if (this.gp.maxValue2 <= 0.0) {
            doubleTmp = this.gp.maxValue2;
            this.gp.maxValue2 = Math.abs(this.gp.minValue2);
            this.gp.minValue2 = Math.abs(doubleTmp);
            if (this.gp.maxValue2 == 0.0) {
                this.gp.maxValue2 = 1.0;
            }
            while (this.gp.maxValue2 > 100.0) {
                this.gp.coorScale2 *= 10.0;
                this.gp.maxValue2 *= 0.1;
            }
            while (this.gp.maxValue2 < 1.0) {
                this.gp.coorScale2 *= 0.1;
                this.gp.maxValue2 *= 10.0;
            }
            if (this.gp.interval2 == 0.0) {
                this.gp.interval2 = this.gp.maxValue2 > 50.0 ? 10.0 * this.gp.coorScale2 : 5.0 * this.gp.coorScale2;
            }
            if (this.gp.maxValue2 % (this.gp.interval2 / this.gp.coorScale2) != 0.0 && adjustMaxValue) {
                this.gp.maxValue2 = this.gp.maxValue2 - this.gp.maxValue2 % (this.gp.interval2 / this.gp.coorScale2) + this.gp.interval2 / this.gp.coorScale2;
            }
            this.gp.tickNum2 = (int)(this.gp.maxValue2 / (this.gp.interval2 / this.gp.coorScale2));
            if (this.gp.minTicknum2 > 0 && this.gp.tickNum2 < this.gp.minTicknum2) {
                this.gp.tickNum2 = this.gp.minTicknum2;
                if (this.gp.maxValue2 % (double)this.gp.tickNum2 > 0.0 && adjustMaxValue) {
                    this.gp.maxValue2 = this.gp.maxValue2 - this.gp.maxValue2 % (double)this.gp.tickNum2 + (double)this.gp.tickNum2;
                }
            }
            if (this.gp.maxValue2 == 0.0 && adjustMaxValue) {
                this.gp.maxValue2 = 1.0;
            }
            for (int i = 0; i <= this.gp.tickNum2; ++i) {
                doubleTmp = this.gp.scaleMark == 2.0 ? (double)(-(this.gp.tickNum2 - i)) * this.gp.maxValue2 / (double)this.gp.tickNum2 : (double)(-(this.gp.tickNum2 - i)) * this.gp.maxValue2 * (this.gp.coorScale2 / this.gp.scaleMark) / (double)this.gp.tickNum2;
                this.gp.coorValue2.add(i, new Double(doubleTmp));
            }
        } else {
            double absMax = this.gp.maxValue2;
            double absMin = Math.abs(this.gp.minValue2);
            if (this.gp.maxValue2 < Math.abs(this.gp.minValue2)) {
                absMin = absMax;
                absMax = Math.abs(this.gp.minValue2);
            }
            if (absMax == 0.0) {
                absMax = 1.0;
            }
            while (absMax > 100.0) {
                this.gp.coorScale2 *= 10.0;
                absMax *= 0.1;
            }
            while (absMax < 1.0) {
                this.gp.coorScale2 *= 0.1;
                absMax *= 10.0;
            }
            if (this.gp.interval2 == 0.0) {
                this.gp.interval2 = absMax > 50.0 ? 10.0 * this.gp.coorScale2 : 5.0 * this.gp.coorScale2;
            }
            if (absMax % (this.gp.interval2 / this.gp.coorScale2) != 0.0 && adjustMaxValue) {
                absMax = absMax - absMax % (this.gp.interval2 / this.gp.coorScale2) + this.gp.interval2 / this.gp.coorScale2;
            }
            this.gp.tickNum2 = (int)(absMax / (this.gp.interval2 / this.gp.coorScale2));
            if (this.gp.minTicknum > 0 && this.gp.tickNum2 < this.gp.minTicknum) {
                this.gp.tickNum2 = this.gp.minTicknum;
                if (absMax % (double)this.gp.tickNum2 > 0.0 && adjustMaxValue) {
                    absMax = absMax - absMax % (double)this.gp.tickNum2 + (double)this.gp.tickNum2;
                }
            }
            if (this.gp.scaleMark != 2.0) {
                absMin *= this.gp.scaleMark / this.gp.coorScale2;
            }
            boolean addPositive = false;
            boolean addNegative = false;
            int intTmp = this.gp.tickNum2;
            this.gp.coorValue2.add(new Double(0.0 + this.gp.baseValue2));
            for (int i = 1; i <= intTmp; ++i) {
                doubleTmp = this.gp.scaleMark == 2.0 ? (double)i * absMax / (double)intTmp : (double)i * absMax * (this.gp.coorScale2 / this.gp.scaleMark) / (double)intTmp;
                if (doubleTmp < this.gp.maxValue2) {
                    this.gp.coorValue2.add(new Double(doubleTmp + this.gp.baseValue2));
                } else if (!addPositive) {
                    addPositive = true;
                    this.gp.coorValue2.add(new Double(doubleTmp + this.gp.baseValue2));
                }
                doubleTmp *= -1.0;
                if (doubleTmp > this.gp.minValue2) {
                    this.gp.coorValue2.add(new Double(doubleTmp + this.gp.baseValue2));
                    continue;
                }
                if (addNegative) continue;
                addNegative = true;
                this.gp.coorValue2.add(new Double(doubleTmp + this.gp.baseValue2));
            }
            Collections.sort(this.gp.coorValue2);
            this.gp.tickNum2 = this.gp.coorValue2.size() - 1;
            this.gp.maxValue2 = Math.abs(((Number)this.gp.coorValue2.get(0)).doubleValue()) + Math.abs(((Number)this.gp.coorValue2.get(this.gp.tickNum2)).doubleValue());
            this.gp.maxValue2 *= this.gp.scaleMark / this.gp.coorScale2;
        }
        this.gp.minValue2 = 0.0;
        boolean bl = ISCHINESE = Locale.getDefault().equals(Locale.CHINA) || Locale.getDefault().equals(Locale.CHINESE) || Locale.getDefault().equals(Locale.SIMPLIFIED_CHINESE);
        if (ISCHINESE) {
            if (this.gp.scaleMark == 2.0 && this.gp.coorScale2 != 1.0) {
                this.gp.GFV_YTITLE.text2 = this.gp.coorScale2 > 1000.0 ? this.gp.GFV_YTITLE.text2 + "(" + GraphParam.xToChinese(this.gp.coorScale2) + ")" : this.gp.GFV_YTITLE.text2 + "(\u6bd4\u4f8b\uff1a1:" + this.gp.coorScale2 + ")";
            } else if (this.gp.scaleMark != 1.0) {
                if (this.gp.scaleMark == 1000.0) {
                    this.gp.GFV_YTITLE.text2 = this.gp.GFV_YTITLE.text2 + "(\u5343)";
                } else if (this.gp.scaleMark == 10000.0) {
                    this.gp.GFV_YTITLE.text2 = this.gp.GFV_YTITLE.text2 + "(\u4e07)";
                } else if (this.gp.scaleMark == 1000000.0) {
                    this.gp.GFV_YTITLE.text2 = this.gp.GFV_YTITLE.text2 + "(\u767e\u4e07)";
                } else if (this.gp.scaleMark == 1.0E7) {
                    this.gp.GFV_YTITLE.text2 = this.gp.GFV_YTITLE.text2 + "(\u5343\u4e07)";
                } else if (this.gp.scaleMark == 1.0E9) {
                    this.gp.GFV_YTITLE.text2 = this.gp.GFV_YTITLE.text2 + "(\u4ebf)";
                } else if (this.gp.scaleMark == 1.0E8) {
                    this.gp.GFV_YTITLE.text2 = this.gp.GFV_YTITLE.text2 + "(\u5341\u4ebf)";
                } else if (this.gp.scaleMark == 0.01) {
                    this.gp.GFV_YTITLE.text2 = this.gp.GFV_YTITLE.text2 + "(\u767e\u5206\u4e4b\u4e00)";
                } else if (this.gp.scaleMark == 0.001) {
                    this.gp.GFV_YTITLE.text2 = this.gp.GFV_YTITLE.text2 + "(\u5343\u5206\u4e4b\u4e00)";
                } else if (this.gp.scaleMark == 1.0E-4) {
                    this.gp.GFV_YTITLE.text2 = this.gp.GFV_YTITLE.text2 + "(\u4e07\u5206\u4e4b\u4e00)";
                } else if (this.gp.scaleMark == 1.0E-6) {
                    this.gp.GFV_YTITLE.text2 = this.gp.GFV_YTITLE.text2 + "(\u767e\u4e07\u5206\u4e4b\u4e00)";
                }
            }
        } else {
            double unit = 1.0;
            unit = this.gp.scaleMark == 2.0 && this.gp.coorScale != 1.0 ? this.gp.coorScale : this.gp.scaleMark;
            if (unit != 1.0) {
                this.gp.GFV_YTITLE.text = this.gp.GFV_YTITLE.text + "(" + this.getFormattedValue(unit, "#.#E0") + ")";
            }
        }
    }

    String _$1(Object catVal) {
        return Variant.toString(catVal);
    }

    protected float getDataTableX(int catIndex) {
        float axisLen = this.gp.graphWidth - this.gp.leftInset - this.gp.rightInset;
        float catWidth = axisLen / (float)this.gp.catNum;
        float pos = (float)this.gp.leftInset + (float)(catIndex + 1) * catWidth - catWidth / 2.0f;
        return pos;
    }

    public void drawDataTable() {
        float axisWidth = this.gp.graphWidth - this.gp.leftInset - this.gp.rightInset;
        CellSet cs = this.getDataTable(axisWidth);
        float tableH = this.getDataTableHeight(cs);
        Utils.setGraphAntiAliasingOff(this.g);
        IColCell cc1 = cs.getColCell(1);
        float col1W = cc1.getWidth();
        float x = (float)this.gp.leftInset - col1W;
        float y = (float)(this.gp.graphHeight - this.gp.bottomInset) - tableH;
        int rows = cs.getRowCount();
        int cols = cs.getColCount();
        for (int r = 1; r <= rows; ++r) {
            IRowCell rc = cs.getRowCell(r);
            float h = rc.getHeight();
            for (int c = 1; c <= cols; ++c) {
                if (c == 1) {
                    x = (float)this.gp.leftInset - col1W;
                }
                IColCell cc = cs.getColCell(c);
                INormalCell nc = cs.getCell(r, c);
                float w = cc.getWidth();
                if (r != 1 || c != 1) {
                    Color color;
                    Font font;
                    Color cr = this.egp.getAxisColor(1);
                    Rectangle2D.Double rect = new Rectangle2D.Double(x, y, w, h);
                    this.drawShape(rect, cr);
                    boolean isCenter = true;
                    isCenter = r == 1 || c == 1 ? true : this.gp.isDataCenter;
                    if (isCenter) {
                        font = this.gp.GFV_XLABEL.font;
                        color = this.gp.GFV_XLABEL.color;
                    } else {
                        font = this.gp.GFV_VALUE.font;
                        color = this.gp.GFV_VALUE.color;
                    }
                    this._$1(nc.getExpString(), (int)x, (int)y, (int)w, (int)h, isCenter, font, color);
                }
                x += w;
            }
            y += h;
        }
        this.gp.bottomInset = (int)((float)this.gp.bottomInset + tableH);
        Utils.setGraphAntiAliasingOn(this.g);
    }

    private void _$1(String text, int x, int y, int w, int h, boolean isCenter, Font font, Color c) {
        if (text == null || text.trim().length() == 0) {
            return;
        }
        FontMetrics fm = this.g.getFontMetrics(font);
        int fw = 0;
        int ascent = fm.getAscent();
        int height = fm.getHeight();
        ArrayList<String> al = DrawStringUtils2.wrapString(text, fm, w, false);
        int lineH = DrawStringUtils2.getTextRowHeight(fm);
        if (al.size() < 2 && lineH > h) {
            lineH = h;
        }
        int yy = y;
        yy = y + (h - lineH * al.size()) / 2;
        if (yy < y) {
            yy = y;
        }
        for (int i = 0; i < al.size() && (i <= 0 || yy + lineH <= y + h); ++i) {
            String wrapedText = al.get(i);
            fw = fm.stringWidth(wrapedText);
            int x1 = x;
            x1 = isCenter ? x + (w - fw) / 2 : x + w - fw;
            int y1 = yy + (lineH - height) / 2 + ascent;
            this.g.setColor(c);
            this.g.setFont(font);
            this.g.drawString(wrapedText, x1, y1);
            yy += lineH;
        }
    }

    public void adjustCoorInset() {
        DecimalFormat df;
        DecimalFormatSymbols dfs;
        String scoory;
        Object coory;
        int i;
        int maxValW = 0;
        int maxValH = 0;
        int maxCatW = 0;
        int maxCatH = 0;
        int intTmp = 0;
        for (i = 0; i < this.gp.tickNum; ++i) {
            coory = this.gp.coorValue.get(i);
            scoory = Variant.toString(coory);
            if (coory instanceof Number && this.gp.dataMarkFormat != null && this.gp.dataMarkFormat.trim().length() > 0) {
                dfs = new DecimalFormatSymbols(Locale.getDefault());
                df = new DecimalFormat(this.gp.dataMarkFormat, dfs);
                scoory = df.format(((Number)coory).doubleValue());
            }
            this.TR = this.gp.GFV_YLABEL.getTextSize(scoory);
            intTmp = this.TR.width;
            if (maxValW < intTmp) {
                maxValW = intTmp;
            }
            if (maxValH >= (intTmp = this.TR.height)) continue;
            maxValH = intTmp;
        }
        for (int j = 0; j < this.gp.catNum; ++j) {
            Object o = this.gp.catNames.get(j);
            this.TR = this.gp.GFV_XLABEL.getTextSize(this._$1(o));
            intTmp = this.TR.width;
            if (maxCatW < intTmp) {
                maxCatW = intTmp;
            }
            if (maxCatH >= (intTmp = this.TR.height)) continue;
            maxCatH = intTmp;
        }
        if (this.egp.isBarGraph(this)) {
            this.gp.leftInset += maxCatW + 4;
            this.gp.bottomInset += maxValH + 4;
        } else {
            this.gp.leftInset += maxValW + 4;
            if (!this.gp.isDrawTable) {
                this.gp.bottomInset += maxCatH + 4;
            }
            if (this.egp.is2YGraph()) {
                for (i = 0; i < this.gp.tickNum2; ++i) {
                    coory = this.gp.coorValue2.get(i);
                    scoory = Variant.toString(coory);
                    if (coory instanceof Number && this.gp.dataMarkFormat != null && this.gp.dataMarkFormat.trim().length() > 0) {
                        dfs = new DecimalFormatSymbols(Locale.getDefault());
                        df = new DecimalFormat(this.gp.dataMarkFormat, dfs);
                        scoory = df.format(((Number)coory).doubleValue());
                    }
                    this.TR = this.gp.GFV_YLABEL.getTextSize(scoory);
                    intTmp = this.TR.width;
                    if (maxValW < intTmp) {
                        maxValW = intTmp;
                    }
                    if (maxValH >= (intTmp = this.TR.height)) continue;
                    maxValH = intTmp;
                }
                this.gp.rightInset += maxValW + 4;
            }
            if (this.gp.isDrawTable) {
                this.drawDataTable();
            }
        }
    }

    public void initGraphInset() {
        this.gp.leftInset = this.gp.leftMargin;
        this.gp.topInset = this.gp.topMargin;
        this.gp.rightInset = this.gp.rightMargin;
        this.gp.bottomInset = this.gp.bottomMargin;
    }

    public String getFormattedValue(double value, String fmt) {
        double tmp = value;
        String sVal = new Double(tmp).toString();
        if (StringUtils.isValidString(fmt)) {
            DecimalFormatSymbols dfs = new DecimalFormatSymbols(Locale.getDefault());
            DecimalFormat df = new DecimalFormat(fmt, dfs);
            sVal = df.format(tmp);
        }
        return sVal;
    }

    public String getFormattedValue(double value) {
        return this.getFormattedValue(value, this.gp.dataMarkFormat);
    }

    public double getScaledValue(double orginalVal, boolean isFirstAxis) {
        double scaledVal;
        if (this.gp.scaleMark == 2.0) {
            double coorScale = isFirstAxis ? this.gp.coorScale : this.gp.coorScale2;
            scaledVal = orginalVal / coorScale;
        } else {
            scaledVal = orginalVal / this.gp.scaleMark;
        }
        return scaledVal;
    }

    public String getDispValue(ExtGraphSery egs) {
        return this.getDispValue(null, egs, 0);
    }

    public String getDispValue(ExtGraphCategory egc, ExtGraphSery egs, int serNum) {
        if (egs.isNull()) {
            return null;
        }
        double scaledVal = this.getScaledValue(egs.getValue(), true);
        String txt = this.getDispValue(scaledVal, egs.getTips());
        if (egc != null && this.gp.dispValueType == 5) {
            txt = DrawBase.getDispName(egc, egs, serNum) + "," + txt;
        }
        return txt;
    }

    public String getDispValue2(ExtGraphSery egs) {
        return this.getDispValue2(null, egs, 0);
    }

    public String getDispValue2(ExtGraphCategory egc, ExtGraphSery egs, int serNum) {
        if (egs.isNull()) {
            return null;
        }
        double scaledVal = this.getScaledValue(egs.getValue(), false);
        String txt = this.getDispValue2(scaledVal, egs.getTips());
        if (egc != null && this.gp.dispValueType2 == 5) {
            txt = DrawBase.getDispName(egc, egs, serNum) + "," + txt;
        }
        return txt;
    }

    public String getDispValue2(double value, String title) {
        if (this.gp.dispValueType2 == 4) {
            return title;
        }
        String txt = this.getFormattedValue(value, this.gp.dataMarkFormat2);
        return txt;
    }

    public String getDispValue(double value, String title) {
        if (this.gp.dispValueType == 4) {
            return title;
        }
        String txt = this.getFormattedValue(value, this.gp.dataMarkFormat);
        return txt;
    }

    public void drawLine(Point2D.Double b, Point2D.Double e) {
        this.drawLine(b, e, this.egp.isDrawShade());
    }

    public void drawLine(Point2D.Double b, Point2D.Double e, boolean drawShade) {
        if (b == null || e == null) {
            return;
        }
        Stroke old = this.g.getStroke();
        Stroke stroke = this.getLineStroke();
        if (stroke != null) {
            this.g.setStroke(stroke);
            if (drawShade) {
                Color c = this.g.getColor();
                this.g.setColor(Color.lightGray);
                Utils.drawLine(this.g, b.x + (double)this.SHADE_SPAN, b.y + (double)this.SHADE_SPAN, e.x + (double)this.SHADE_SPAN, e.y + (double)this.SHADE_SPAN);
                this.g.setColor(c);
            }
            Utils.drawLine(this.g, b.x, b.y, e.x, e.y);
        }
        this.g.setStroke(old);
    }

    public static boolean isChinese() {
        return Locale.getDefault().equals(Locale.CHINA) || Locale.getDefault().equals(Locale.CHINESE) || Locale.getDefault().equals(Locale.SIMPLIFIED_CHINESE);
    }

    public static String getDispName(ExtGraphCategory egc, ExtGraphSery egs, int serNum) {
        if (serNum == 1) {
            return egc.getNameString();
        }
        return egs.getName();
    }

    public float getDataTableHeight(CellSet cs) {
        int rows = cs.getRowCount();
        float total = 0.0f;
        for (int r = 1; r <= rows; ++r) {
            IRowCell rc = cs.getRowCell(r);
            total += rc.getHeight();
        }
        return total;
    }

    public CellSet getDataTable(double axisLen) {
        int rows = this.gp.serNum + 1;
        int cols = this.gp.catNum + 1;
        if (this.egp.is2YGraph() || this.egp.category2 != null) {
            rows += this.gp.serNum2;
        }
        PgmCellSet cs = new PgmCellSet(rows, cols);
        double catWidth = axisLen / (double)this.gp.catNum;
        IColCell cc = cs.getColCell(1);
        cc.setWidth(this.gp.leftInset - 5);
        ArrayList cats = this.egp.categories;
        ArrayList cats2 = this.egp.category2;
        for (int i = 0; i < this.gp.catNum; ++i) {
            cc = cs.getColCell(i + 2);
            cc.setWidth((float)catWidth);
            ExtGraphCategory egc = (ExtGraphCategory)cats.get(i);
            String value = egc.getNameString();
            INormalCell nc = cs.getCell(1, i + 2);
            nc.setExpString(value);
            for (int j = 0; j < this.gp.serNum; ++j) {
                ExtGraphSery egs;
                String serName = this.gp.serNames.get(j).toString();
                if (i == 0) {
                    nc = cs.getCell(j + 2, 1);
                    nc.setExpString(serName);
                }
                if ((egs = egc.getExtGraphSery(serName)).isNull()) continue;
                double scaledVal = this.getScaledValue(egs.getValue(), true);
                String txt = this.getFormattedValue(scaledVal, this.gp.dataMarkFormat);
                nc = cs.getCell(j + 2, i + 2);
                nc.setExpString(txt);
            }
            if (!this.egp.is2YGraph() && cats2 == null) continue;
            ExtGraphCategory egc2 = (ExtGraphCategory)cats2.get(i);
            for (int j = 0; j < this.gp.serNum2; ++j) {
                ExtGraphSery egs;
                String serName = this.gp.serNames2.get(j).toString();
                if (i == 0) {
                    nc = cs.getCell(this.gp.serNum + j + 2, 1);
                    nc.setExpString(serName);
                }
                if ((egs = egc2.getExtGraphSery(serName)).isNull()) continue;
                double scaledVal = this.getScaledValue(egs.getValue(), true);
                String txt = this.getFormattedValue(scaledVal, this.gp.dataMarkFormat2);
                nc = cs.getCell(this.gp.serNum + j + 2, i + 2);
                nc.setExpString(txt);
            }
        }
        for (int r = 1; r <= rows; ++r) {
            IRowCell rc = cs.getRowCell(r);
            float rowH = rc.getHeight();
            for (int c = 1; c <= cols; ++c) {
                Font font = r == 1 || c == 1 ? this.gp.GFV_XLABEL.font : this.gp.GFV_VALUE.font;
                cc = cs.getColCell(c);
                float w = cc.getWidth();
                INormalCell nc = cs.getCell(r, c);
                float cellH = this._$1(nc, font, w);
                if (!(cellH > rowH)) continue;
                rowH = cellH;
            }
            rc.setHeight(rowH);
        }
        return cs;
    }

    private float _$1(INormalCell nc, Font font, float w) {
        FontMetrics fm = this.g.getFontMetrics(font);
        String text = nc.getExpString();
        ArrayList<String> al = DrawStringUtils2.wrapString(text, fm, w, false);
        int lineH = DrawStringUtils2.getTextRowHeight(fm);
        if (al.size() < 2) {
            return lineH;
        }
        float totalH = lineH * al.size();
        return totalH += 2.0f;
    }
}

