/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.cellset.graph.draw;

import com.scudata.cellset.graph.draw.DrawBase;
import com.scudata.cellset.graph.draw.ExtGraphCategory;
import com.scudata.cellset.graph.draw.ExtGraphProperty;
import com.scudata.cellset.graph.draw.ExtGraphSery;
import com.scudata.cellset.graph.draw.GraphParam;
import com.scudata.cellset.graph.draw.ValueLabel;
import com.scudata.chart.Utils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class DrawCol3DObj
extends DrawBase {
    public void draw(StringBuffer htmlLink) {
        DrawCol3DObj.drawing(this, htmlLink);
    }

    public static void drawing(DrawBase db, StringBuffer htmlLink) {
        double y;
        double x;
        Color c;
        ExtGraphCategory egc;
        int i;
        double seriesWidth;
        double categorySpan;
        GraphParam gp = db.gp;
        ExtGraphProperty egp = db.egp;
        Graphics2D g = db.g;
        ArrayList<ValueLabel> labelList = db.labelList;
        db.initGraphInset();
        db.createCoorValue();
        db.drawLegend(htmlLink);
        db.drawTitle();
        db.drawLabel();
        db.keepGraphSpace();
        db.adjustCoorInset();
        gp.graphRect = new Rectangle2D.Double(gp.leftInset, gp.topInset, gp.graphWidth - gp.leftInset - gp.rightInset, gp.graphHeight - gp.topInset - gp.bottomInset);
        if (gp.graphRect.width < 10.0 || gp.graphRect.height < 10.0) {
            return;
        }
        if (gp.coorWidth < 0 || gp.coorWidth > 10000) {
            gp.coorWidth = 0;
        }
        if (gp.barDistance > 0.0) {
            double maxCatSpan = (gp.graphRect.width - (double)((float)(gp.serNum * gp.catNum) * 1.0f)) / (double)((float)gp.catNum + 1.0f);
            categorySpan = gp.barDistance <= maxCatSpan ? gp.barDistance : maxCatSpan;
            seriesWidth = (gp.graphRect.width - (double)(gp.catNum + 1) * categorySpan) / (double)(gp.serNum * gp.catNum);
        } else {
            seriesWidth = gp.graphRect.width / ((double)(gp.catNum + 1) * gp.categorySpan / 100.0 + (double)gp.coorWidth / 200.0 + (double)(gp.catNum * gp.serNum));
            categorySpan = seriesWidth * (gp.categorySpan / 100.0);
        }
        double coorWidth = seriesWidth * ((double)gp.coorWidth / 200.0);
        double tmpInt = (double)(gp.catNum + 1) * categorySpan + coorWidth + (double)(gp.catNum * gp.serNum) * seriesWidth;
        gp.graphRect.x += (gp.graphRect.width - tmpInt) / 2.0;
        gp.graphRect.width = tmpInt;
        double dely = (gp.graphRect.height - coorWidth) / (double)gp.tickNum;
        tmpInt = dely * (double)gp.tickNum + coorWidth;
        gp.graphRect.y += (gp.graphRect.height - tmpInt) / 2.0;
        gp.graphRect.height = tmpInt;
        gp.gRect1 = (Rectangle2D.Double)gp.graphRect.clone();
        gp.gRect2 = (Rectangle2D.Double)gp.graphRect.clone();
        gp.gRect1.y += coorWidth;
        gp.gRect1.width -= coorWidth;
        gp.gRect1.height -= coorWidth;
        gp.gRect2.x += coorWidth;
        gp.gRect2.width -= coorWidth;
        gp.gRect2.height -= coorWidth;
        db.drawGraphRect();
        for (int i2 = 0; i2 <= gp.tickNum; ++i2) {
            db.drawGridLine(dely, i2);
            Number coory = (Number)gp.coorValue.get(i2);
            String scoory = db.getFormattedValue(coory.doubleValue());
            Point2D.Double p = db._$3((double)i2 * dely);
            gp.GFV_YLABEL.outText(p.x - (double)gp.tickLen, p.y, scoory);
            if (coory.doubleValue() != gp.baseValue + gp.minValue) continue;
            gp.valueBaseLine = gp.gRect1.y + gp.gRect1.height - (double)i2 * dely;
        }
        db.drawWarnLine();
        if (gp.graphTransparent) {
            g.setComposite(AlphaComposite.getInstance(3, 0.6f));
        }
        ArrayList cats = egp.categories;
        int cc = cats.size();
        for (i = 0; i < cc; ++i) {
            egc = (ExtGraphCategory)cats.get(i);
            double delx = (double)(i + 1) * categorySpan + (double)i * seriesWidth * (double)gp.serNum + seriesWidth * (double)gp.serNum / 2.0;
            boolean vis = i % (gp.graphXInterval + 1) == 0;
            Point2D.Double p = db._$2(delx);
            if (vis) {
                c = egp.getAxisColor(1);
                Utils.setStroke(g, c, 1, 1.0f);
                db.drawLine(p.x, p.y, p.x, p.y + (double)gp.tickLen, c);
                db.drawGridLineCategoryV(gp.gRect2.x + delx);
            }
            String value = egc.getNameString();
            gp.GFV_XLABEL.outText(p.x, p.y + (double)gp.tickLen, value, vis);
            for (int j = 0; j < gp.serNum; ++j) {
                ExtGraphSery egs = egc.getExtGraphSery(gp.serNames.get(j));
                if (egs.isNull()) continue;
                double val = egs.getValue();
                double tmp = val - gp.baseValue;
                double len = dely * (double)gp.tickNum * (tmp - gp.minValue) / (gp.maxValue * gp.coorScale);
                double lb = gp.gRect1.x + (double)(i + 1) * categorySpan + (double)(i * gp.serNum + j) * seriesWidth;
                if (len > 0.0) continue;
                int cIndex = !gp.isMultiSeries ? i : j;
                db.drawRectCube(lb, seriesWidth, len, coorWidth, 0.0, cIndex, htmlLink, egc.getNameString(), egs);
                if (!gp.dispValueOntop || egs.isNull() || !vis) continue;
                String sval = db.getDispValue(egc, egs, gp.serNum);
                x = lb + seriesWidth / 2.0;
                y = gp.valueBaseLine - len;
                c = !gp.isMultiSeries ? db.getColor(i) : db.getColor(j);
                ValueLabel vl = len < 0.0 ? new ValueLabel(sval, new Point2D.Double(x, y), c, 2) : new ValueLabel(sval, new Point2D.Double(x, y), c, 1);
                labelList.add(vl);
            }
        }
        if (gp.valueBaseLine != gp.gRect1.y + gp.gRect1.height) {
            double[] xx = new double[]{gp.gRect1.x, gp.gRect1.x + coorWidth, gp.gRect1.x + gp.gRect1.width + coorWidth, gp.gRect1.x + gp.gRect1.width};
            double[] yy = new double[]{gp.valueBaseLine, gp.valueBaseLine - coorWidth, gp.valueBaseLine - coorWidth, gp.valueBaseLine};
            Shape poly = Utils.newPolygon2D(xx, yy);
            Color ccc = egp.getAxisColor(1);
            if (ccc == null) {
                ccc = Color.lightGray;
            }
            float trans = 1.0f;
            if (gp.graphTransparent) {
                trans = 0.4f;
            }
            Utils.fill(g, poly, trans, ccc);
        }
        for (i = 0; i < cc; ++i) {
            egc = (ExtGraphCategory)cats.get(i);
            boolean vis = i % (gp.graphXInterval + 1) == 0;
            for (int j = 0; j < gp.serNum; ++j) {
                ExtGraphSery egs = egc.getExtGraphSery(gp.serNames.get(j));
                if (egs.isNull()) continue;
                double val = egs.getValue();
                double tmp = val - gp.baseValue;
                double len = dely * (double)gp.tickNum * (tmp - gp.minValue) / (gp.maxValue * gp.coorScale);
                double lb = gp.gRect1.x + (double)(i + 1) * categorySpan + (double)(i * gp.serNum + j) * seriesWidth;
                if (len < 0.0) continue;
                int cIndex = !gp.isMultiSeries ? i : j;
                db.drawRectCube(lb, seriesWidth, len, coorWidth, 0.0, cIndex, htmlLink, egc.getNameString(), egs);
                if (!gp.dispValueOntop || egs.isNull() || !vis) continue;
                String sval = db.getDispValue(egc, egs, gp.serNum);
                x = lb + seriesWidth / 2.0;
                y = gp.valueBaseLine - len;
                c = !gp.isMultiSeries ? db.getColor(i) : db.getColor(j);
                ValueLabel vl = len < 0.0 ? new ValueLabel(sval, new Point2D.Double(x, y), c, 2) : new ValueLabel(sval, new Point2D.Double(x, y), c, 1);
                labelList.add(vl);
            }
        }
        if (gp.graphTransparent) {
            g.setComposite(AlphaComposite.getInstance(3, 1.0f));
        }
        db.outLabels();
        if (gp.valueBaseLine != gp.gRect1.y + gp.gRect1.height) {
            db.drawLine(gp.gRect1.x, gp.valueBaseLine, gp.gRect1.x + gp.gRect1.width, gp.valueBaseLine, egp.getAxisColor(1));
            db.drawLine(gp.gRect1.x + gp.gRect1.width, gp.valueBaseLine, gp.gRect1.x + gp.gRect1.width + coorWidth, gp.valueBaseLine - coorWidth, egp.getAxisColor(1));
        }
    }
}

