/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.cellset.graph.draw;

import com.scudata.cellset.graph.draw.Desc3DRect;
import com.scudata.cellset.graph.draw.DrawBase;
import com.scudata.cellset.graph.draw.ExtGraphCategory;
import com.scudata.cellset.graph.draw.ExtGraphProperty;
import com.scudata.cellset.graph.draw.ExtGraphSery;
import com.scudata.cellset.graph.draw.GraphParam;
import com.scudata.cellset.graph.draw.ValueLabel;
import com.scudata.chart.Utils;
import com.scudata.common.Logger;
import com.scudata.common.StringUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawColStacked3DObj
extends DrawBase {
    @Override
    public void draw(StringBuffer htmlLink) {
        DrawColStacked3DObj.drawing(this, htmlLink);
    }

    public static void drawing(DrawBase db, StringBuffer htmlLink) {
        double lb;
        String value;
        Color c;
        boolean vis;
        int i;
        double seriesWidth;
        double categorySpan;
        GraphParam gp = db.gp;
        ExtGraphProperty egp = db.egp;
        Graphics2D g = db.g;
        gp.maxValue = gp.maxPositive;
        gp.minValue = gp.minNegative;
        db.initGraphInset();
        db.createCoorValue();
        db.drawLegend(htmlLink);
        db.drawTitle();
        db.drawLabel();
        db.keepGraphSpace();
        db.adjustCoorInset();
        gp.graphRect = new Rectangle2D.Double(gp.leftInset, gp.topInset, gp.graphWidth - gp.leftInset - gp.rightInset, gp.graphHeight - gp.topInset - gp.bottomInset);
        if (gp.graphRect.width < 10.0 || gp.graphRect.height < 10.0) {
            return;
        }
        if (gp.coorWidth < 0 || gp.coorWidth > 10000) {
            gp.coorWidth = 0;
        }
        int serNum = 1;
        if (egp.category2 != null) {
            serNum = 2;
        }
        if (gp.barDistance > 0.0) {
            double maxCatSpan = (gp.graphRect.width - (double)((float)(serNum * gp.catNum) * 1.0f)) / (double)((float)gp.catNum + 1.0f);
            if (gp.barDistance <= maxCatSpan) {
                categorySpan = gp.barDistance;
            } else {
                categorySpan = maxCatSpan;
                Logger.warning("Category span :" + gp.barDistance + " is too large. Use max limit span:" + maxCatSpan);
            }
            seriesWidth = (gp.graphRect.width - (double)(gp.catNum + 1) * categorySpan) / (double)(serNum * gp.catNum);
        } else {
            seriesWidth = gp.graphRect.width / ((double)(gp.catNum + 1) * gp.categorySpan / 100.0 + (double)gp.coorWidth / 200.0 + (double)(gp.catNum * serNum));
            categorySpan = seriesWidth * (gp.categorySpan / 100.0);
        }
        double coorWidth = seriesWidth * ((double)gp.coorWidth / 200.0);
        double tmpInt = (double)(gp.catNum + 1) * categorySpan + coorWidth + (double)(gp.catNum * serNum) * seriesWidth;
        gp.graphRect.x += (gp.graphRect.width - tmpInt) / 2.0;
        gp.graphRect.width = tmpInt;
        double dely = (gp.graphRect.height - coorWidth) / (double)gp.tickNum;
        tmpInt = dely * (double)gp.tickNum + coorWidth;
        gp.graphRect.y += (gp.graphRect.height - tmpInt) / 2.0;
        gp.graphRect.height = tmpInt;
        gp.gRect1 = (Rectangle2D.Double)gp.graphRect.clone();
        gp.gRect2 = (Rectangle2D.Double)gp.graphRect.clone();
        gp.gRect1.y += coorWidth;
        gp.gRect1.width -= coorWidth;
        gp.gRect1.height -= coorWidth;
        gp.gRect2.x += coorWidth;
        gp.gRect2.width -= coorWidth;
        gp.gRect2.height -= coorWidth;
        db.drawGraphRect();
        for (int i2 = 0; i2 <= gp.tickNum; ++i2) {
            db.drawGridLine(dely, i2);
            Number coory = (Number)gp.coorValue.get(i2);
            String scoory = db.getFormattedValue(coory.doubleValue());
            Point2D.Double p = db._$3((double)i2 * dely);
            gp.GFV_YLABEL.outText(p.x - (double)gp.tickLen, p.y, scoory);
            if (coory.doubleValue() != gp.baseValue + gp.minValue) continue;
            gp.valueBaseLine = gp.gRect1.y + gp.gRect1.height - (double)i2 * dely;
        }
        ArrayList<Desc3DRect> negativeRects = new ArrayList<Desc3DRect>();
        ArrayList cats = egp.categories;
        int cc = cats.size();
        for (i = 0; i < cc; ++i) {
            double delx = (double)(i + 1) * categorySpan + (double)i * seriesWidth * (double)serNum + seriesWidth * (double)serNum / 2.0;
            boolean valvis = i % (gp.graphXInterval + 1) == 0;
            vis = valvis && !gp.isDrawTable;
            Point2D.Double p = db._$2(delx);
            if (!vis) continue;
            db.drawGridLineCategoryV(gp.gRect2.x + delx);
        }
        if (gp.minNegative < 0.0) {
            for (i = cc - 1; i >= 0; --i) {
                ExtGraphCategory egc = (ExtGraphCategory)cats.get(i);
                double delx = (double)(i + 1) * categorySpan + (double)i * seriesWidth * (double)serNum + seriesWidth * (double)serNum / 2.0;
                vis = i % (gp.graphXInterval + 1) == 0;
                Point2D.Double p = db._$2(delx);
                if (vis) {
                    c = egp.getAxisColor(1);
                    Utils.setStroke(g, c, 1, 1.0f);
                    db.drawLine(p.x, p.y, p.x, p.y + (double)gp.tickLen, c);
                }
                value = egc.getNameString();
                gp.GFV_XLABEL.outText(p.x, p.y + (double)gp.tickLen, value, vis);
                double negativeBase = gp.valueBaseLine;
                lb = gp.gRect1.x + (double)(i + 1) * categorySpan + (double)(i * serNum + 0) * seriesWidth;
                if (egp.category2 == null) {
                    DrawColStacked3DObj._$1(0, gp.serNames, egc, dely, db, lb, seriesWidth, htmlLink, negativeBase, coorWidth, vis, negativeRects);
                    continue;
                }
                DrawColStacked3DObj._$1(0, gp.serNames, egc, dely, db, lb, seriesWidth, htmlLink, negativeBase, coorWidth, vis, negativeRects);
                lb = gp.gRect1.x + (double)(i + 1) * categorySpan + (double)(i * serNum + 1) * seriesWidth;
                egc = (ExtGraphCategory)egp.category2.get(i);
                DrawColStacked3DObj._$1(gp.serNames.size(), gp.serNames2, egc, dely, db, lb, seriesWidth, htmlLink, negativeBase, coorWidth, vis, negativeRects);
            }
            for (i = negativeRects.size() - 1; i >= 0; --i) {
                Desc3DRect d3 = (Desc3DRect)negativeRects.get(i);
                Utils.draw3DRect(g, d3);
            }
        }
        if (gp.valueBaseLine != gp.gRect1.y + gp.gRect1.height) {
            double[] xx = new double[]{gp.gRect1.x, gp.gRect1.x + coorWidth, gp.gRect1.x + gp.gRect1.width + coorWidth, gp.gRect1.x + gp.gRect1.width};
            double[] yy = new double[]{gp.valueBaseLine, gp.valueBaseLine - coorWidth, gp.valueBaseLine - coorWidth, gp.valueBaseLine};
            Shape poly = Utils.newPolygon2D(xx, yy);
            Color ccc = egp.getAxisColor(1);
            if (ccc == null) {
                ccc = Color.lightGray;
            }
            float trans = 1.0f;
            if (gp.graphTransparent) {
                trans = 0.4f;
            }
            Utils.fill(g, poly, trans, ccc);
        }
        db.drawWarnLine();
        for (int i3 = 0; i3 < cc; ++i3) {
            ExtGraphCategory egc = (ExtGraphCategory)cats.get(i3);
            double delx = (double)(i3 + 1) * categorySpan + (double)i3 * seriesWidth * (double)serNum + seriesWidth * (double)serNum / 2.0;
            boolean vis2 = i3 % (gp.graphXInterval + 1) == 0;
            Point2D.Double p = db._$2(delx);
            if (vis2) {
                c = egp.getAxisColor(1);
                Utils.setStroke(g, c, 1, 1.0f);
                db.drawLine(p.x, p.y, p.x, p.y + (double)gp.tickLen, c);
            }
            value = egc.getNameString();
            gp.GFV_XLABEL.outText(p.x, p.y + (double)gp.tickLen, value, vis2);
            if (gp.graphTransparent) {
                g.setComposite(AlphaComposite.getInstance(3, 0.6f));
            }
            double positiveBase = gp.valueBaseLine;
            lb = gp.gRect1.x + (double)(i3 + 1) * categorySpan + (double)(i3 * serNum + 0) * seriesWidth;
            if (egp.category2 == null) {
                DrawColStacked3DObj._$1(0, gp.serNames, egc, dely, db, lb, seriesWidth, htmlLink, positiveBase, coorWidth, vis2);
                continue;
            }
            DrawColStacked3DObj._$1(0, gp.serNames, egc, dely, db, lb, seriesWidth, htmlLink, positiveBase, coorWidth, vis2);
            lb = gp.gRect1.x + (double)(i3 + 1) * categorySpan + (double)(i3 * serNum + 1) * seriesWidth;
            egc = (ExtGraphCategory)egp.category2.get(i3);
            DrawColStacked3DObj._$1(gp.serNames.size(), gp.serNames2, egc, dely, db, lb, seriesWidth, htmlLink, positiveBase, coorWidth, vis2);
        }
        db.outLabels();
        if (gp.valueBaseLine != gp.gRect1.y + gp.gRect1.height) {
            db.drawLine(gp.gRect1.x, gp.valueBaseLine, gp.gRect1.x + gp.gRect1.width, gp.valueBaseLine, egp.getAxisColor(1));
            db.drawLine(gp.gRect1.x + gp.gRect1.width, gp.valueBaseLine, gp.gRect1.x + gp.gRect1.width + coorWidth, gp.valueBaseLine - coorWidth, egp.getAxisColor(1));
        }
    }

    private static void _$1(int serNumBase, Vector serNames, ExtGraphCategory egc, double dely, DrawBase db, double dlb, double seriesWidth, StringBuffer htmlLink, double negativeBase, double coorWidth, boolean vis, ArrayList<Desc3DRect> negativeRects) {
        GraphParam gp = db.gp;
        ExtGraphProperty egp = db.egp;
        Graphics2D g = db.g;
        double lb = dlb;
        ArrayList<ValueLabel> labelList = db.labelList;
        if (gp.graphTransparent) {
            g.setComposite(AlphaComposite.getInstance(3, 0.6f));
        }
        int serNum = serNames.size();
        for (int j = 0; j < serNum; ++j) {
            double val;
            double tmp;
            double len;
            ExtGraphSery egs = egc.getExtGraphSery(serNames.get(j));
            if (egs.isNull() || (len = (double)Math.round(dely * (double)gp.tickNum * ((tmp = (val = egs.getValue()) - gp.baseValue) - gp.minValue) / (gp.maxValue * gp.coorScale))) == 0.0 || len >= 0.0) continue;
            double xx = lb;
            double yy = negativeBase;
            double ww = seriesWidth;
            double hh = Math.abs(len);
            Color bc = egp.getAxisColor(5);
            int bs = 1;
            float bw = 1.0f;
            Color tmpc = db.getColor(j + serNumBase);
            double coorShift = coorWidth;
            negativeRects.add(Utils.get3DRect(xx, yy, ww, hh, bc, bs, bw, egp.isDrawShade(), egp.isRaisedBorder(), db.getTransparent(), db.getChartColor(tmpc), false, coorShift));
            String percentFmt = null;
            if (vis && (gp.dispValueType == 3 || gp.dispValueType == 6)) {
                percentFmt = StringUtils.isValidString(gp.dataMarkFormat) ? gp.dataMarkFormat : "0.00%";
            }
            ValueLabel vl = null;
            double x = lb + seriesWidth / 2.0;
            if (!(len > 0.0)) {
                String sval = null;
                if (percentFmt != null) {
                    sval = db.getFormattedValue(egs.getValue() / egc.getNegativeSumSeries(), percentFmt);
                    if (egc != null && gp.dispValueType == 6) {
                        sval = DrawColStacked3DObj.getDispName(egc, egs, serNum) + "," + sval;
                    }
                } else if (egc != null && gp.dispValueType != 1) {
                    sval = db.getDispValue(egc, egs, gp.serNum);
                }
                if (StringUtils.isValidString(sval)) {
                    vl = new ValueLabel(sval, new Point2D.Double(x, negativeBase - len / 2.0), gp.GFV_VALUE.color, 5);
                }
                negativeBase -= len;
            }
            if (vl == null) continue;
            labelList.add(vl);
        }
        if (gp.graphTransparent) {
            g.setComposite(AlphaComposite.getInstance(3, 1.0f));
        }
        if (gp.dispStackSumValue && vis) {
            double val = db.getScaledValue(egc.getPositiveSumSeries(), true);
            ValueLabel vl = null;
            val = db.getScaledValue(egc.getNegativeSumSeries(), true);
            if (val < 0.0) {
                String sval = db.getFormattedValue(val);
                double x = lb + seriesWidth / 2.0;
                double y = negativeBase + 3.0;
                vl = new ValueLabel(sval, new Point2D.Double(x, y), gp.GFV_VALUE.color, 2);
            }
            if (vl != null) {
                labelList.add(vl);
            }
        }
    }

    private static void _$1(int serNumBase, Vector serNames, ExtGraphCategory egc, double dely, DrawBase db, double dlb, double seriesWidth, StringBuffer htmlLink, double positiveBase, double coorWidth, boolean vis) {
        GraphParam gp = db.gp;
        ExtGraphProperty egp = db.egp;
        Graphics2D g = db.g;
        double lb = dlb;
        ArrayList<ValueLabel> labelList = db.labelList;
        if (gp.graphTransparent) {
            g.setComposite(AlphaComposite.getInstance(3, 0.6f));
        }
        int serNum = serNames.size();
        for (int j = 0; j < serNum; ++j) {
            double val;
            double tmp;
            double len;
            ExtGraphSery egs = egc.getExtGraphSery(serNames.get(j));
            if (egs.isNull() || (len = (double)Math.round(dely * (double)gp.tickNum * ((tmp = (val = egs.getValue()) - gp.baseValue) - gp.minValue) / (gp.maxValue * gp.coorScale))) == 0.0 || !(len >= 0.0)) continue;
            double xx = lb;
            double yy = positiveBase - len;
            double ww = seriesWidth;
            double hh = len;
            Color bc = egp.getAxisColor(5);
            int bs = 1;
            float bw = 1.0f;
            Color tmpc = db.getColor(j + serNumBase);
            double coorShift = coorWidth;
            Utils.draw3DRect(g, xx, yy, ww, hh, bc, bs, bw, egp.isDrawShade(), egp.isRaisedBorder(), db.getTransparent(), db.getChartColor(tmpc), false, coorShift);
            db.htmlLink(xx, yy, ww, hh, htmlLink, egc.getNameString(), egs);
            String percentFmt = null;
            if (vis && (gp.dispValueType == 3 || gp.dispValueType == 6)) {
                percentFmt = StringUtils.isValidString(gp.dataMarkFormat) ? gp.dataMarkFormat : "0.00%";
            }
            ValueLabel vl = null;
            double x = lb + seriesWidth / 2.0;
            if (len > 0.0) {
                String sval = null;
                if (percentFmt != null) {
                    sval = db.getFormattedValue(egs.getValue() / egc.getPositiveSumSeries(), percentFmt);
                    if (egc != null && gp.dispValueType == 6) {
                        sval = DrawColStacked3DObj.getDispName(egc, egs, serNum) + "," + sval;
                    }
                } else if (egc != null && gp.dispValueType != 1) {
                    sval = db.getDispValue(egc, egs, gp.serNum);
                }
                if (StringUtils.isValidString(sval)) {
                    vl = new ValueLabel(sval, new Point2D.Double(x, positiveBase - len / 2.0), gp.GFV_VALUE.color, 5);
                }
                positiveBase -= len;
            }
            if (vl == null) continue;
            labelList.add(vl);
        }
        if (gp.graphTransparent) {
            g.setComposite(AlphaComposite.getInstance(3, 1.0f));
        }
        if (gp.dispStackSumValue && vis) {
            double val = db.getScaledValue(egc.getPositiveSumSeries(), true);
            ValueLabel vl = null;
            if (val > 0.0) {
                String sval = db.getFormattedValue(val);
                double x = lb + seriesWidth / 2.0;
                double y = positiveBase - 3.0;
                vl = new ValueLabel(sval, new Point2D.Double(x, y), gp.GFV_VALUE.color, gp.GFV_VALUE._$3);
            }
            if (vl != null) {
                labelList.add(vl);
            }
        }
    }
}

