/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.cellset.graph.draw;

import com.scudata.cellset.graph.draw.DrawBase;
import com.scudata.cellset.graph.draw.DrawLine;
import com.scudata.cellset.graph.draw.ExtGraphCategory;
import com.scudata.cellset.graph.draw.ExtGraphProperty;
import com.scudata.cellset.graph.draw.ExtGraphSery;
import com.scudata.cellset.graph.draw.GraphParam;
import com.scudata.cellset.graph.draw.ValueLabel;
import com.scudata.cellset.graph.draw.ValuePoint;
import com.scudata.chart.Utils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawCurve
extends DrawBase {
    @Override
    public void draw(StringBuffer htmlLink) {
        DrawCurve.drawing(this, htmlLink);
    }

    public static void drawing(DrawBase db, StringBuffer htmlLink) {
        double y;
        double x;
        GraphParam gp = db.gp;
        ExtGraphProperty egp = db.egp;
        Graphics2D g = db.g;
        ArrayList<ValueLabel> labelList = db.labelList;
        int VALUE_RADIUS = db.VALUE_RADIUS;
        ArrayList<ValuePoint> pointList = db.pointList;
        gp.coorWidth = 0;
        db.initGraphInset();
        db.createCoorValue();
        db.drawLegend(htmlLink);
        db.drawTitle();
        db.drawLabel();
        db.keepGraphSpace();
        db.adjustCoorInset();
        gp.graphRect = new Rectangle2D.Double(gp.leftInset, gp.topInset, gp.graphWidth - gp.leftInset - gp.rightInset, gp.graphHeight - gp.topInset - gp.bottomInset);
        if (gp.graphRect.width < 10.0 || gp.graphRect.height < 10.0) {
            return;
        }
        if (gp.coorWidth < 0 || gp.coorWidth > 10000) {
            gp.coorWidth = 0;
        }
        double seriesWidth = gp.graphRect.width / ((double)(gp.catNum + 1) * gp.categorySpan / 100.0 + (double)gp.coorWidth / 200.0 + (double)(gp.catNum * gp.serNum));
        double coorWidth = seriesWidth * ((double)gp.coorWidth / 200.0);
        double categorySpan = seriesWidth * (gp.categorySpan / 100.0);
        double tmpInt = (double)(gp.catNum + 1) * categorySpan + coorWidth + (double)(gp.catNum * gp.serNum) * seriesWidth;
        gp.graphRect.x += (gp.graphRect.width - tmpInt) / 2.0;
        gp.graphRect.width = tmpInt;
        double dely = (gp.graphRect.height - coorWidth) / (double)gp.tickNum;
        tmpInt = dely * (double)gp.tickNum + coorWidth;
        gp.graphRect.y += (gp.graphRect.height - tmpInt) / 2.0;
        gp.graphRect.height = tmpInt;
        gp.gRect1 = (Rectangle2D.Double)gp.graphRect.clone();
        gp.gRect2 = (Rectangle2D.Double)gp.graphRect.clone();
        gp.gRect1.y += coorWidth;
        gp.gRect1.width -= coorWidth;
        gp.gRect1.height -= coorWidth;
        gp.gRect2.x += coorWidth;
        gp.gRect2.width -= coorWidth;
        gp.gRect2.height -= coorWidth;
        db.drawGraphRect();
        for (int i = 0; i <= gp.tickNum; ++i) {
            db.drawGridLine(dely, i);
            Number coory = (Number)gp.coorValue.get(i);
            String scoory = db.getFormattedValue(coory.doubleValue());
            x = gp.gRect1.x - (double)gp.tickLen;
            y = gp.gRect1.y + gp.gRect1.height - (double)i * dely;
            gp.GFV_YLABEL.outText(x, y, scoory);
            if (coory.doubleValue() != gp.baseValue + gp.minValue) continue;
            gp.valueBaseLine = gp.gRect1.y + gp.gRect1.height - (double)i * dely;
        }
        db.drawWarnLine();
        Point2D.Double[] beginPoint = new Point2D.Double[gp.serNum];
        double[] beginVal = new double[gp.serNum];
        ArrayList[] catPoints = new ArrayList[gp.serNum];
        for (int j = 0; j < gp.serNum; ++j) {
            ArrayList catList;
            catPoints[j] = catList = new ArrayList();
        }
        ArrayList cats = egp.categories;
        int cc = cats.size();
        for (int i = 0; i < cc; ++i) {
            Color c;
            boolean vis;
            ExtGraphCategory egc = (ExtGraphCategory)cats.get(i);
            double posx = DrawLine.getPosX(gp, i, cc, categorySpan, seriesWidth);
            boolean valvis = i % (gp.graphXInterval + 1) == 0;
            boolean bl = vis = valvis && !gp.isDrawTable;
            if (vis) {
                c = egp.getAxisColor(1);
                Utils.setStroke(g, c, 1, 1.0f);
                db.drawLine(posx, gp.gRect1.y + gp.gRect1.height, posx, gp.gRect1.y + gp.gRect1.height + (double)gp.tickLen, c);
                db.drawGridLineCategoryV(posx);
            }
            String value = egc.getNameString();
            x = posx;
            y = gp.gRect1.y + gp.gRect1.height + (double)gp.tickLen;
            gp.GFV_XLABEL.outText(x, y, value, vis);
            for (int j = 0; j < gp.serNum; ++j) {
                boolean vis2;
                ExtGraphSery egs = egc.getExtGraphSery(gp.serNames.get(j));
                double val = egs.getValue();
                double tmp = val - gp.baseValue;
                double len = dely * (double)gp.tickNum * (tmp - gp.minValue) / (gp.maxValue * gp.coorScale);
                if (gp.isDrawTable) {
                    posx = db.getDataTableX(i);
                }
                Point2D.Double endPoint = egs.isNull() ? null : new Point2D.Double(posx, gp.valueBaseLine - len);
                if (gp.dispValueOntop && !egs.isNull() && valvis) {
                    String sval = db.getDispValue(egc, egs, gp.serNum);
                    x = endPoint.x;
                    y = endPoint.y;
                    c = !gp.isMultiSeries ? db.getColor(i) : db.getColor(j);
                    ValueLabel vl = new ValueLabel(sval, new Point2D.Double(x, y - (double)VALUE_RADIUS), c);
                    labelList.add(vl);
                }
                boolean bl2 = vis2 = i % (gp.graphXInterval + 1) == 0;
                if (!egs.isNull() && gp.drawLineDot && vis2) {
                    double ww;
                    double xx = endPoint.x - (double)VALUE_RADIUS;
                    double yy = endPoint.y - (double)VALUE_RADIUS;
                    double hh = ww = (double)(2 * VALUE_RADIUS);
                    Color backColor = !gp.isMultiSeries ? db.getColor(i) : db.getColor(j);
                    ValuePoint vp = new ValuePoint(endPoint, backColor);
                    pointList.add(vp);
                    db.htmlLink(xx, yy, ww, hh, htmlLink, egc.getNameString(), egs);
                }
                if (i > 0) {
                    g.setColor(db.getColor(j));
                    DrawLine.drawVTrendLine(db, beginPoint[j], endPoint, val - beginVal[j]);
                }
                DrawLine.drawHTrendLine(db, beginPoint[j]);
                beginPoint[j] = endPoint;
                if (endPoint != null) {
                    ArrayList catList = catPoints[j];
                    catList.add(endPoint);
                }
                beginVal[j] = val;
            }
        }
        Stroke stroke = db.getLineStroke();
        if (stroke != null) {
            g.setStroke(stroke);
        }
        block9: for (int j = 0; j < gp.serNum; ++j) {
            ArrayList serPoints = catPoints[j];
            if (serPoints.size() == 0) continue;
            g.setColor(db.getColor(j));
            byte curveType = egp.getCurveType();
            switch (curveType) {
                case 0: {
                    Line2D.Double dLine;
                    double y2;
                    double x2;
                    Point2D.Double p1 = (Point2D.Double)serPoints.get(0);
                    Point2D.Double p2 = (Point2D.Double)serPoints.get(serPoints.size() - 1);
                    double x1 = p1.x;
                    double y1 = p1.y;
                    double delta = 0.2;
                    for (x2 = p1.x + delta; x2 <= p2.x; x2 += delta) {
                        y2 = DrawCurve._$1(serPoints, x2);
                        dLine = new Line2D.Double(x1, y1, x2, y2);
                        g.draw(dLine);
                        x1 = x2;
                        y1 = y2;
                    }
                    continue block9;
                }
                case 1: {
                    int i;
                    Line2D.Double dLine;
                    double y2;
                    double x2;
                    Point2D.Double p1;
                    int n = serPoints.size();
                    double[] xs = new double[n];
                    double[] ys = new double[n];
                    for (i = 0; i < n; ++i) {
                        Point2D.Double pt = (Point2D.Double)serPoints.get(i);
                        xs[i] = pt.x;
                        ys[i] = pt.y;
                    }
                    for (int k = 0; k < serPoints.size() - 1; ++k) {
                        p1 = (Point2D.Double)serPoints.get(k);
                        double x1 = p1.x;
                        double y1 = p1.y;
                        Point2D.Double p2 = (Point2D.Double)serPoints.get(k + 1);
                        double[] s = DrawCurve._$1(xs, ys, k);
                        for (x2 = p1.x + 1.0; x2 <= p2.x; x2 += 1.0) {
                            y2 = DrawCurve._$1(p1.x, x2, s);
                            dLine = new Line2D.Double(x1, y1, x2, y2);
                            g.draw(dLine);
                            x1 = x2;
                            y1 = y2;
                        }
                    }
                    continue block9;
                }
                case 2: {
                    int i;
                    Line2D.Double dLine;
                    double y2;
                    double x2;
                    int n = serPoints.size();
                    double[] xs = new double[n];
                    double[] ys = new double[n];
                    for (i = 0; i < n; ++i) {
                        Point2D.Double pt = (Point2D.Double)serPoints.get(i);
                        xs[i] = pt.x;
                        ys[i] = pt.y;
                    }
                    Point2D.Double p1 = (Point2D.Double)serPoints.get(0);
                    Point2D.Double p2 = (Point2D.Double)serPoints.get(serPoints.size() - 1);
                    double x1 = p1.x;
                    double y1 = p1.y;
                    for (x2 = p1.x + 1.0; x2 <= p2.x; x2 += 1.0) {
                        y2 = DrawCurve._$1(xs, ys, x2);
                        dLine = new Line2D.Double(x1, y1, x2, y2);
                        g.draw(dLine);
                        x1 = x2;
                        y1 = y2;
                    }
                    continue block9;
                }
            }
        }
        db.outPoints();
        db.outLabels();
        g.setStroke(new BasicStroke());
        db.drawLine(gp.gRect1.x, gp.valueBaseLine, gp.gRect1.x + gp.gRect1.width, gp.valueBaseLine, egp.getAxisColor(1));
        db.drawLine(gp.gRect1.x + gp.gRect1.width, gp.valueBaseLine, gp.gRect1.x + gp.gRect1.width + coorWidth, gp.valueBaseLine - coorWidth, egp.getAxisColor(1));
    }

    private static double _$1(ArrayList<Point2D.Double> points, double deltaX) {
        double sum = 0.0;
        for (int i = 0; i < points.size(); ++i) {
            double L = 1.0;
            Point2D.Double pi = points.get(i);
            for (int j = 0; j < points.size(); ++j) {
                Point2D.Double pj = points.get(j);
                if (j == i) continue;
                L = L * (deltaX - pj.x) / (pi.x - pj.x);
            }
            sum += L * pi.y;
        }
        return sum;
    }

    private static double _$1(double xk, double t, double[] s) {
        double d = t - xk;
        double dd = d * d;
        return s[0] + s[1] * d + s[2] * dd + s[3] * d * dd;
    }

    private static double[] _$1(double[] x, double[] y, int k) {
        int kk;
        double t = 0.0;
        double[] u = new double[5];
        double[] s = new double[5];
        s[4] = 0.0;
        s[0] = 0.0;
        s[1] = 0.0;
        s[2] = 0.0;
        s[3] = 0.0;
        int n = x.length;
        if (n < 1) {
            return s;
        }
        if (n == 1) {
            s[0] = y[0];
            s[4] = y[0];
            return s;
        }
        if (n == 2) {
            s[0] = y[0];
            s[1] = (y[1] - y[0]) / (x[1] - x[0]);
            if (k < 0) {
                s[4] = (y[0] * (t - x[1]) - y[1] * (t - x[0])) / (x[0] - x[1]);
            }
            return s;
        }
        if (k < 0) {
            if (t <= x[1]) {
                kk = 0;
            } else if (t >= x[n - 1]) {
                kk = n - 2;
            } else {
                kk = 1;
                int m = n;
                while (kk - m != 1 && kk - m != -1) {
                    int l = (kk + m) / 2;
                    if (t < x[l - 1]) {
                        m = l;
                        continue;
                    }
                    kk = l;
                }
                --kk;
            }
        } else {
            kk = k;
        }
        if (kk >= n - 1) {
            kk = n - 2;
        }
        u[2] = (y[kk + 1] - y[kk]) / (x[kk + 1] - x[kk]);
        if (n == 3) {
            if (kk == 0) {
                u[3] = (y[2] - y[1]) / (x[2] - x[1]);
                u[4] = 2.0 * u[3] - u[2];
                u[1] = 2.0 * u[2] - u[3];
                u[0] = 2.0 * u[1] - u[2];
            } else {
                u[1] = (y[1] - y[0]) / (x[1] - x[0]);
                u[0] = 2.0 * u[1] - u[2];
                u[3] = 2.0 * u[2] - u[1];
                u[4] = 2.0 * u[3] - u[2];
            }
        } else if (kk <= 1) {
            u[3] = (y[kk + 2] - y[kk + 1]) / (x[kk + 2] - x[kk + 1]);
            if (kk == 1) {
                u[1] = (y[1] - y[0]) / (x[1] - x[0]);
                u[0] = 2.0 * u[1] - u[2];
                u[4] = n == 4 ? 2.0 * u[3] - u[2] : (y[4] - y[3]) / (x[4] - x[3]);
            } else {
                u[1] = 2.0 * u[2] - u[3];
                u[0] = 2.0 * u[1] - u[2];
                u[4] = (y[3] - y[2]) / (x[3] - x[2]);
            }
        } else if (kk >= n - 3) {
            u[1] = (y[kk] - y[kk - 1]) / (x[kk] - x[kk - 1]);
            if (kk == n - 3) {
                u[3] = (y[n - 1] - y[n - 2]) / (x[n - 1] - x[n - 2]);
                u[4] = 2.0 * u[3] - u[2];
                u[0] = n == 4 ? 2.0 * u[1] - u[2] : (y[kk - 1] - y[kk - 2]) / (x[kk - 1] - x[kk - 2]);
            } else {
                u[3] = 2.0 * u[2] - u[1];
                u[4] = 2.0 * u[3] - u[2];
                u[0] = (y[kk - 1] - y[kk - 2]) / (x[kk - 1] - x[kk - 2]);
            }
        } else {
            u[1] = (y[kk] - y[kk - 1]) / (x[kk] - x[kk - 1]);
            u[0] = (y[kk - 1] - y[kk - 2]) / (x[kk - 1] - x[kk - 2]);
            u[3] = (y[kk + 2] - y[kk + 1]) / (x[kk + 2] - x[kk + 1]);
            u[4] = (y[kk + 3] - y[kk + 2]) / (x[kk + 3] - x[kk + 2]);
        }
        s[0] = DrawCurve._$4(u[3] - u[2]);
        s[1] = DrawCurve._$4(u[0] - u[1]);
        double p = s[0] + 1.0 == 1.0 && s[1] + 1.0 == 1.0 ? (u[1] + u[2]) / 2.0 : (s[0] * u[1] + s[1] * u[2]) / (s[0] + s[1]);
        s[0] = DrawCurve._$4(u[3] - u[4]);
        s[1] = DrawCurve._$4(u[2] - u[1]);
        double q = s[0] + 1.0 == 1.0 && s[1] + 1.0 == 1.0 ? (u[2] + u[3]) / 2.0 : (s[0] * u[2] + s[1] * u[3]) / (s[0] + s[1]);
        s[0] = y[kk];
        s[1] = p;
        s[3] = x[kk + 1] - x[kk];
        s[2] = (3.0 * u[2] - 2.0 * p - q) / s[3];
        s[3] = (q + p - 2.0 * u[2]) / (s[3] * s[3]);
        if (k < 0) {
            p = t - x[kk];
            s[4] = s[0] + s[1] * p + s[2] * p * p + s[3] * p * p * p;
        }
        return s;
    }

    private static double _$4(double d) {
        return Math.abs(d);
    }

    private static double _$1(double[] x, double[] y, double tx) {
        int i;
        double h1;
        int j;
        int n = x.length;
        double[] dy = new double[n];
        dy[0] = 1.0;
        dy[n - 1] = -1.0;
        double[] ddy = new double[n];
        double[] t = new double[]{tx};
        int m = 1;
        double[] z = new double[1];
        double[] dz = new double[1];
        double[] ddz = new double[1];
        double[] s = new double[n];
        s[0] = dy[0];
        dy[0] = 0.0;
        double h0 = x[1] - x[0];
        for (j = 1; j <= n - 2; ++j) {
            h1 = x[j + 1] - x[j];
            double alpha = h0 / (h0 + h1);
            double beta = (1.0 - alpha) * (y[j] - y[j - 1]) / h0;
            beta = 3.0 * (beta + alpha * (y[j + 1] - y[j]) / h1);
            dy[j] = -alpha / (2.0 + (1.0 - alpha) * dy[j - 1]);
            s[j] = beta - (1.0 - alpha) * s[j - 1];
            s[j] = s[j] / (2.0 + (1.0 - alpha) * dy[j - 1]);
            h0 = h1;
        }
        for (j = n - 2; j >= 0; --j) {
            dy[j] = dy[j] * dy[j + 1] + s[j];
        }
        for (j = 0; j <= n - 2; ++j) {
            s[j] = x[j + 1] - x[j];
        }
        for (j = 0; j <= n - 2; ++j) {
            h1 = s[j] * s[j];
            ddy[j] = 6.0 * (y[j + 1] - y[j]) / h1 - 2.0 * (2.0 * dy[j] + dy[j + 1]) / s[j];
        }
        h1 = s[n - 2] * s[n - 2];
        ddy[n - 1] = 6.0 * (y[n - 2] - y[n - 1]) / h1 + 2.0 * (2.0 * dy[n - 1] + dy[n - 2]) / s[n - 2];
        double g = 0.0;
        for (i = 0; i <= n - 2; ++i) {
            h1 = 0.5 * s[i] * (y[i] + y[i + 1]);
            g += (h1 -= s[i] * s[i] * s[i] * (ddy[i] + ddy[i + 1]) / 24.0);
        }
        for (j = 0; j <= m - 1; ++j) {
            if (t[j] >= x[n - 1]) {
                i = n - 2;
            } else {
                i = 0;
                while (t[j] > x[i + 1]) {
                    ++i;
                }
            }
            h1 = (x[i + 1] - t[j]) / s[i];
            h0 = h1 * h1;
            z[j] = (3.0 * h0 - 2.0 * h0 * h1) * y[i];
            z[j] = z[j] + s[i] * (h0 - h0 * h1) * dy[i];
            dz[j] = 6.0 * (h0 - h1) * y[i] / s[i];
            dz[j] = dz[j] + (3.0 * h0 - 2.0 * h1) * dy[i];
            ddz[j] = (6.0 - 12.0 * h1) * y[i] / (s[i] * s[i]);
            ddz[j] = ddz[j] + (2.0 - 6.0 * h1) * dy[i] / s[i];
            h1 = (t[j] - x[i]) / s[i];
            h0 = h1 * h1;
            z[j] = z[j] + (3.0 * h0 - 2.0 * h0 * h1) * y[i + 1];
            z[j] = z[j] - s[i] * (h0 - h0 * h1) * dy[i + 1];
            dz[j] = dz[j] - 6.0 * (h0 - h1) * y[i + 1] / s[i];
            dz[j] = dz[j] + (3.0 * h0 - 2.0 * h1) * dy[i + 1];
            ddz[j] = ddz[j] + (6.0 - 12.0 * h1) * y[i + 1] / (s[i] * s[i]);
            ddz[j] = ddz[j] - (2.0 - 6.0 * h1) * dy[i + 1] / s[i];
        }
        return z[0];
    }
}

