/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.cellset.graph.draw;

import com.scudata.cellset.graph.draw.DrawBase;
import com.scudata.cellset.graph.draw.ExtGraphCategory;
import com.scudata.cellset.graph.draw.ExtGraphProperty;
import com.scudata.cellset.graph.draw.ExtGraphSery;
import com.scudata.cellset.graph.draw.GraphParam;
import com.scudata.cellset.graph.draw.ValueLabel;
import com.scudata.chart.Utils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class DrawDot
extends DrawBase {
    public void draw(StringBuffer htmlLink) {
        DrawDot.drawing(this, htmlLink);
    }

    public static void drawing(DrawBase db, StringBuffer htmlLink) {
        double y;
        double x;
        GraphParam gp = db.gp;
        ExtGraphProperty egp = db.egp;
        Graphics2D g = db.g;
        ArrayList<ValueLabel> labelList = db.labelList;
        int VALUE_RADIUS = db.VALUE_RADIUS;
        gp.coorWidth = 0;
        db.initGraphInset();
        db.createCoorValue();
        db.drawLegend(htmlLink);
        db.drawTitle();
        db.drawLabel();
        db.keepGraphSpace();
        db.adjustCoorInset();
        gp.graphRect = new Rectangle2D.Double(gp.leftInset, gp.topInset, gp.graphWidth - gp.leftInset - gp.rightInset, gp.graphHeight - gp.topInset - gp.bottomInset);
        if (gp.graphRect.width < 10.0 || gp.graphRect.height < 10.0) {
            return;
        }
        if (gp.coorWidth < 0 || gp.coorWidth > 10000) {
            gp.coorWidth = 0;
        }
        double seriesWidth = gp.graphRect.width / ((double)(gp.catNum + 1) * gp.categorySpan / 100.0 + (double)gp.coorWidth / 200.0 + (double)(gp.catNum * gp.serNum));
        double coorWidth = seriesWidth * ((double)gp.coorWidth / 200.0);
        double categorySpan = seriesWidth * (gp.categorySpan / 100.0);
        double tmpInt = (double)(gp.catNum + 1) * categorySpan + coorWidth + (double)(gp.catNum * gp.serNum) * seriesWidth;
        gp.graphRect.x += (gp.graphRect.width - tmpInt) / 2.0;
        gp.graphRect.width = tmpInt;
        double dely = (gp.graphRect.height - coorWidth) / (double)gp.tickNum;
        tmpInt = dely * (double)gp.tickNum + coorWidth;
        gp.graphRect.y += (gp.graphRect.height - tmpInt) / 2.0;
        gp.graphRect.height = tmpInt;
        gp.gRect1 = (Rectangle2D.Double)gp.graphRect.clone();
        gp.gRect2 = (Rectangle2D.Double)gp.graphRect.clone();
        gp.gRect1.y += coorWidth;
        gp.gRect1.width -= coorWidth;
        gp.gRect1.height -= coorWidth;
        gp.gRect2.x += coorWidth;
        gp.gRect2.width -= coorWidth;
        gp.gRect2.height -= coorWidth;
        db.drawGraphRect();
        for (int i = 0; i <= gp.tickNum; ++i) {
            db.drawGridLine(dely, i);
            Number coory = (Number)gp.coorValue.get(i);
            String scoory = db.getFormattedValue(coory.doubleValue());
            x = gp.gRect1.x - (double)gp.tickLen;
            y = gp.gRect1.y + gp.gRect1.height - (double)i * dely;
            gp.GFV_YLABEL.outText(x, y, scoory);
            if (coory.doubleValue() != gp.baseValue) continue;
            gp.valueBaseLine = gp.gRect1.y + gp.gRect1.height - (double)i * dely;
        }
        db.drawWarnLine();
        Point2D.Double[] prePoints1 = new Point2D.Double[gp.serNum];
        Point2D.Double[] prePoints2 = new Point2D.Double[gp.serNum];
        ArrayList cats = egp.categories;
        int cc = cats.size();
        for (int i = 0; i < cc; ++i) {
            Color c;
            boolean vis;
            ExtGraphCategory egc = (ExtGraphCategory)cats.get(i);
            double delx = (double)(i + 1) * categorySpan + (double)i * seriesWidth * (double)gp.serNum + seriesWidth * (double)gp.serNum / 2.0;
            boolean valvis = i % (gp.graphXInterval + 1) == 0;
            boolean bl = vis = valvis && !gp.isDrawTable;
            if (vis) {
                c = egp.getAxisColor(1);
                Utils.setStroke(g, c, 1, 1.0f);
                db.drawLine(gp.gRect1.x + delx, gp.gRect1.y + gp.gRect1.height, gp.gRect1.x + delx, gp.gRect1.y + gp.gRect1.height + (double)gp.tickLen, c);
                db.drawGridLineCategoryV(gp.gRect1.x + delx);
            }
            String value = egc.getNameString();
            x = gp.gRect1.x + delx;
            y = gp.gRect1.y + gp.gRect1.height + (double)gp.tickLen;
            gp.GFV_XLABEL.outText(x, y, value, vis);
            for (int j = 0; j < gp.serNum; ++j) {
                ExtGraphSery egs = egc.getExtGraphSery(gp.serNames.get(j));
                if (egs.isNull()) continue;
                double val = egs.getValue();
                double tmp = val - gp.baseValue;
                double len = dely * (double)gp.tickNum * (tmp - gp.minValue) / (gp.maxValue * gp.coorScale);
                double lb = gp.gRect1.x + (double)(i + 1) * categorySpan + (double)((2 * i + 1) * gp.serNum) * seriesWidth / 2.0;
                if (gp.isDrawTable) {
                    lb = db.getDataTableX(i);
                }
                Point2D.Double pt1 = new Point2D.Double(lb, gp.valueBaseLine - len);
                Point2D.Double pt2 = new Point2D.Double(lb + coorWidth, gp.valueBaseLine - len - coorWidth);
                if (gp.dispValueOntop && !egs.isNull() && valvis) {
                    String sval = db.getDispValue(egc, egs, gp.serNum);
                    x = pt1.x;
                    y = pt1.y;
                    c = !gp.isMultiSeries ? db.getColor(i) : db.getColor(j);
                    ValueLabel vl = new ValueLabel(sval, new Point2D.Double(x, y - (double)VALUE_RADIUS), c);
                    labelList.add(vl);
                }
                if (gp.coorWidth == 0) {
                    Color backColor = !gp.isMultiSeries ? db.getColor(i) : db.getColor(j);
                    Color foreColor = egp.getAxisColor(5);
                    int shape = 1;
                    int radius = VALUE_RADIUS;
                    int bs = 1;
                    float bw = 1.0f;
                    db.drawPoint(pt1, shape, radius, bs, bw, backColor, foreColor);
                    db.drawPoint(pt2, shape, radius, bs, bw, backColor, foreColor);
                    db.htmlLink(pt1.x - (double)VALUE_RADIUS, pt1.y - (double)VALUE_RADIUS, 2 * VALUE_RADIUS, 2 * VALUE_RADIUS, htmlLink, egc.getNameString(), egs);
                }
                prePoints1[j] = pt1;
                prePoints2[j] = pt2;
            }
        }
        db.outLabels();
        db.drawLine(gp.gRect1.x, gp.valueBaseLine, gp.gRect1.x + gp.gRect1.width, gp.valueBaseLine, egp.getAxisColor(1));
        db.drawLine(gp.gRect1.x + gp.gRect1.width, gp.valueBaseLine, gp.gRect1.x + gp.gRect1.width + coorWidth, gp.valueBaseLine - coorWidth, egp.getAxisColor(1));
    }
}

