/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.cellset.graph.draw;

import com.scudata.cellset.graph.draw.DrawBase;
import com.scudata.cellset.graph.draw.ExtGraphCategory;
import com.scudata.cellset.graph.draw.ExtGraphProperty;
import com.scudata.cellset.graph.draw.ExtGraphSery;
import com.scudata.cellset.graph.draw.GraphParam;
import com.scudata.cellset.graph.draw.ValueLabel;
import com.scudata.chart.ChartColor;
import com.scudata.chart.Utils;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawDot3D
extends DrawBase {
    @Override
    public void draw(StringBuffer htmlLink) {
        DrawDot3D.drawing(this, htmlLink);
    }

    public static void drawing(DrawBase db, StringBuffer htmlLink) {
        double seriesWidth;
        double categorySpan;
        GraphParam gp = db.gp;
        ExtGraphProperty egp = db.egp;
        Graphics2D g = db.g;
        ArrayList<ValueLabel> labelList = db.labelList;
        double dely = 0.0;
        db.initGraphInset();
        db.createCoorValue();
        db.drawLegend(htmlLink);
        db.drawTitle();
        db.drawLabel();
        db.keepGraphSpace();
        db.adjustCoorInset();
        gp.graphRect = new Rectangle2D.Double(gp.leftInset, gp.topInset, gp.graphWidth - gp.leftInset - gp.rightInset, gp.graphHeight - gp.topInset - gp.bottomInset);
        if (gp.graphRect.width < 10.0 || gp.graphRect.height < 10.0) {
            return;
        }
        gp.gRect1 = (Rectangle2D.Double)gp.graphRect.clone();
        gp.gRect2 = (Rectangle2D.Double)gp.graphRect.clone();
        double coorWidth = Math.min(gp.graphRect.width, gp.graphRect.height) / 2.0;
        gp.gRect1.y += coorWidth;
        gp.gRect1.width -= coorWidth;
        gp.gRect1.height -= coorWidth;
        dely = gp.gRect1.height / (double)gp.tickNum;
        gp.gRect1.y += (gp.gRect1.height - dely * (double)gp.tickNum) / 2.0;
        gp.gRect1.height = dely * (double)gp.tickNum;
        double seriesDeep = coorWidth / ((double)((gp.serNum + 1) * gp.seriesSpan) / 100.0 + (double)gp.serNum);
        double seriesSpan = seriesDeep * ((double)gp.seriesSpan / 100.0);
        double tmpInt = (double)(gp.serNum + 1) * seriesSpan + (double)gp.serNum * seriesDeep;
        tmpInt = (coorWidth - tmpInt) / 2.0;
        gp.gRect1.y += tmpInt;
        if (gp.barDistance > 0.0) {
            double maxCatSpan = (gp.gRect1.width - (double)((float)gp.catNum * 1.0f)) / (double)((float)gp.catNum + 1.0f);
            categorySpan = gp.barDistance <= maxCatSpan ? gp.barDistance : maxCatSpan;
            seriesWidth = (gp.gRect1.width - (double)(gp.catNum + 1) * categorySpan) / (double)gp.catNum;
        } else {
            seriesWidth = gp.gRect1.width / ((double)(gp.catNum + 1) * gp.categorySpan / 100.0 + (double)gp.coorWidth / 200.0 + (double)gp.catNum);
            categorySpan = seriesWidth * (gp.categorySpan / 100.0);
        }
        gp.gRect2.x = gp.gRect1.x + coorWidth;
        gp.gRect2.width = gp.gRect1.width;
        gp.gRect2.y = gp.gRect1.y - coorWidth;
        gp.gRect2.height = gp.gRect1.height;
        db.drawGraphRect();
        for (int i = 0; i <= gp.tickNum; ++i) {
            db.drawGridLine(dely, i);
            Number coory = (Number)gp.coorValue.get(i);
            String scoory = db.getFormattedValue(coory.doubleValue());
            Point2D.Double p = db._$3((double)i * dely);
            gp.GFV_YLABEL.outText(p.x - (double)gp.tickLen, p.y, scoory);
            if (coory.doubleValue() != gp.baseValue + gp.minValue) continue;
            gp.valueBaseLine = gp.gRect1.y + gp.gRect1.height - (double)i * dely;
        }
        db.drawWarnLine();
        if (gp.graphTransparent) {
            g.setComposite(AlphaComposite.getInstance(3, 0.6f));
        }
        ArrayList cats = egp.categories;
        int cc = cats.size();
        for (int i = 0; i < cc; ++i) {
            ExtGraphCategory egc = (ExtGraphCategory)cats.get(i);
            double delx = (double)(i + 1) * categorySpan + (double)i * seriesWidth + seriesWidth / 2.0;
            g.setColor(gp.gridColor);
            float[] dashes = new float[]{2.0f};
            g.setStroke(new BasicStroke(1.0f, 1, 1, 1.0f, dashes, 0.0f));
            Utils.drawLine(g, gp.gRect1.x + delx, gp.valueBaseLine, gp.gRect1.x + delx + coorWidth, gp.valueBaseLine - coorWidth);
            boolean vis = i % (gp.graphXInterval + 1) == 0;
            Point2D.Double p = db._$2(delx);
            if (vis) {
                Color c = egp.getAxisColor(1);
                Utils.setStroke(g, c, 1, 1.0f);
                db.drawLine(p.x, p.y, p.x, p.y + (double)gp.tickLen, c);
                db.drawGridLineCategoryV(gp.gRect2.x + delx);
            }
            String value = egc.getNameString();
            gp.GFV_XLABEL.outText(p.x, p.y + (double)gp.tickLen, value, vis);
        }
        DrawDot3D._$1(cc, cats, categorySpan, seriesWidth, g, gp, coorWidth, dely, seriesSpan, seriesDeep, db, labelList, false, htmlLink);
        db.outLabels();
        if (gp.valueBaseLine != gp.gRect1.y + gp.gRect1.height) {
            double[] xx = new double[]{gp.gRect1.x, gp.gRect1.x + coorWidth, gp.gRect1.x + gp.gRect1.width + coorWidth, gp.gRect1.x + gp.gRect1.width};
            double[] yy = new double[]{gp.valueBaseLine, gp.valueBaseLine - coorWidth, gp.valueBaseLine - coorWidth, gp.valueBaseLine};
            Shape poly = Utils.newPolygon2D(xx, yy);
            Color ccc = egp.getAxisColor(1);
            if (ccc == null) {
                ccc = Color.lightGray;
            }
            float trans = 1.0f;
            if (gp.graphTransparent) {
                trans = 0.4f;
            }
            Utils.fill(g, poly, trans, ccc);
        }
        DrawDot3D._$1(cc, cats, categorySpan, seriesWidth, g, gp, coorWidth, dely, seriesSpan, seriesDeep, db, labelList, true, htmlLink);
        if (gp.graphTransparent) {
            g.setComposite(AlphaComposite.getInstance(3, 1.0f));
        }
        db.outLabels();
        if (gp.valueBaseLine != gp.gRect1.y + gp.gRect1.height) {
            db.drawLine(gp.gRect1.x, gp.valueBaseLine, gp.gRect1.x + gp.gRect1.width, gp.valueBaseLine, egp.getAxisColor(1));
            db.drawLine(gp.gRect1.x + gp.gRect1.width, gp.valueBaseLine, gp.gRect1.x + gp.gRect1.width + coorWidth, gp.valueBaseLine - coorWidth, egp.getAxisColor(1));
        }
    }

    private static void _$1(int cc, ArrayList cats, double categorySpan, double seriesWidth, Graphics2D g, GraphParam gp, double coorWidth, double dely, double seriesSpan, double seriesDeep, DrawBase db, ArrayList<ValueLabel> labelList, boolean drawPositive, StringBuffer htmlLink) {
        for (int i = 0; i < cc; ++i) {
            ExtGraphCategory egc = (ExtGraphCategory)cats.get(i);
            boolean vis = i % (gp.graphXInterval + 1) == 0;
            for (int j = gp.serNum - 1; j >= 0; --j) {
                ExtGraphSery egs = egc.getExtGraphSery(gp.serNames.get(j));
                if (egs.isNull()) continue;
                double val = egs.getValue();
                double tmp = val - gp.baseValue;
                double len = Math.round(dely * (double)gp.tickNum * (tmp - gp.minValue) / (gp.maxValue * gp.coorScale));
                if (drawPositive ? len < 0.0 : len > 0.0) continue;
                double lb = Math.round(gp.gRect1.x + (double)(i + 1) * categorySpan + (double)i * seriesWidth);
                double br = Math.round((double)(j + 1) * seriesSpan + (double)j * seriesDeep);
                int cIndex = !gp.isMultiSeries ? i : j;
                double xx = lb + br + seriesWidth / 2.0;
                double yy = gp.valueBaseLine - len - br;
                Point2D.Double p2 = new Point2D.Double(xx, yy);
                Color foreColor = db.getColor(cIndex);
                ChartColor backColor = new ChartColor(foreColor);
                Shape s = Utils.drawCartesianPoint2(g, p2, 1, 0.0, 0.0, 0.0, 1, db.gp.getLineThick(), backColor, foreColor, 1.0f);
                if (s != null) {
                    Rectangle rect = s.getBounds();
                    db.htmlLink(rect.x, rect.y, rect.width, rect.height, htmlLink, egc.getNameString(), egs);
                }
                if (!gp.dispValueOntop || egs.isNull() || !vis) continue;
                String sval = db.getDispValue(egc, egs, gp.serNum);
                double x = lb + br + seriesWidth / 2.0;
                double y = gp.valueBaseLine - len - br;
                Color c = !gp.isMultiSeries ? db.getColor(i) : db.getColor(j);
                ValueLabel vl = len < 0.0 ? new ValueLabel(sval, new Point2D.Double(x, y), c, 2) : new ValueLabel(sval, new Point2D.Double(x, y), c, 1);
                labelList.add(vl);
            }
        }
    }
}

