/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.cellset.graph.draw;

import com.scudata.cellset.graph.draw.DrawBase;
import com.scudata.cellset.graph.draw.ExtGraphCategory;
import com.scudata.cellset.graph.draw.ExtGraphProperty;
import com.scudata.cellset.graph.draw.ExtGraphSery;
import com.scudata.cellset.graph.draw.GraphParam;
import com.scudata.cellset.graph.draw.ValueLabel;
import com.scudata.cellset.graph.draw.ValuePoint;
import com.scudata.chart.Utils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class DrawLine
extends DrawBase {
    public void draw(StringBuffer htmlLink) {
        DrawLine.drawing(this, htmlLink);
    }

    public static void drawing(DrawBase db, StringBuffer htmlLink) {
        double y;
        double x;
        GraphParam gp = db.gp;
        ExtGraphProperty egp = db.egp;
        Graphics2D g = db.g;
        ArrayList<ValueLabel> labelList = db.labelList;
        int VALUE_RADIUS = db.getPointRadius();
        ArrayList<ValuePoint> pointList = db.pointList;
        gp.coorWidth = 0;
        db.initGraphInset();
        db.createCoorValue();
        db.drawLegend(htmlLink);
        db.drawTitle();
        db.drawLabel();
        db.keepGraphSpace();
        db.adjustCoorInset();
        gp.graphRect = new Rectangle2D.Double(gp.leftInset, gp.topInset, gp.graphWidth - gp.leftInset - gp.rightInset, gp.graphHeight - gp.topInset - gp.bottomInset);
        if (gp.graphRect.width < 10.0 || gp.graphRect.height < 10.0) {
            return;
        }
        if (gp.coorWidth < 0 || gp.coorWidth > 10000) {
            gp.coorWidth = 0;
        }
        double seriesWidth = gp.graphRect.width / ((double)(gp.catNum + 1) * gp.categorySpan / 100.0 + (double)gp.coorWidth / 200.0 + (double)(gp.catNum * gp.serNum));
        double coorWidth = seriesWidth * ((double)gp.coorWidth / 200.0);
        double categorySpan = seriesWidth * (gp.categorySpan / 100.0);
        double tmpInt = (double)(gp.catNum + 1) * categorySpan + coorWidth + (double)(gp.catNum * gp.serNum) * seriesWidth;
        gp.graphRect.x += (gp.graphRect.width - tmpInt) / 2.0;
        gp.graphRect.width = tmpInt;
        double dely = (gp.graphRect.height - coorWidth) / (double)gp.tickNum;
        tmpInt = dely * (double)gp.tickNum + coorWidth;
        gp.graphRect.y += (gp.graphRect.height - tmpInt) / 2.0;
        gp.graphRect.height = tmpInt;
        gp.gRect1 = (Rectangle2D.Double)gp.graphRect.clone();
        gp.gRect2 = (Rectangle2D.Double)gp.graphRect.clone();
        gp.gRect1.y += coorWidth;
        gp.gRect1.width -= coorWidth;
        gp.gRect1.height -= coorWidth;
        gp.gRect2.x += coorWidth;
        gp.gRect2.width -= coorWidth;
        gp.gRect2.height -= coorWidth;
        db.drawGraphRect();
        for (int i = 0; i <= gp.tickNum; ++i) {
            db.drawGridLine(dely, i);
            Number coory = (Number)gp.coorValue.get(i);
            String scoory = db.getFormattedValue(coory.doubleValue());
            x = gp.gRect1.x - (double)gp.tickLen;
            y = gp.gRect1.y + gp.gRect1.height - (double)i * dely;
            gp.GFV_YLABEL.outText(x, y, scoory);
            if (coory.doubleValue() != gp.baseValue + gp.minValue) continue;
            gp.valueBaseLine = gp.gRect1.y + gp.gRect1.height - (double)i * dely;
        }
        db.drawWarnLine();
        Point2D.Double[] beginPoint = new Point2D.Double[gp.serNum];
        Point2D.Double[] lastPoint = new Point2D.Double[gp.serNum];
        double[] beginVal = new double[gp.serNum];
        ArrayList cats = egp.categories;
        int cc = cats.size();
        for (int i = 0; i < cc; ++i) {
            Color c;
            boolean vis;
            ExtGraphCategory egc = (ExtGraphCategory)cats.get(i);
            double posx = DrawLine.getPosX(gp, i, cc, categorySpan, seriesWidth);
            boolean valvis = i % (gp.graphXInterval + 1) == 0;
            boolean bl = vis = valvis && !gp.isDrawTable;
            if (vis) {
                c = egp.getAxisColor(1);
                Utils.setStroke(g, c, 1, 1.0f);
                db.drawLine(posx, gp.gRect1.y + gp.gRect1.height, posx, gp.gRect1.y + gp.gRect1.height + (double)gp.tickLen, c);
                db.drawGridLineCategoryV(posx);
            }
            String value = egc.getNameString();
            x = posx;
            y = gp.gRect1.y + gp.gRect1.height + (double)gp.tickLen;
            gp.GFV_XLABEL.outText(x, y, value, vis);
            for (int j = 0; j < gp.serNum; ++j) {
                boolean vis2;
                ExtGraphSery egs = egc.getExtGraphSery(gp.serNames.get(j));
                double val = egs.getValue();
                double tmp = val - gp.baseValue;
                double len = dely * (double)gp.tickNum * (tmp - gp.minValue) / (gp.maxValue * gp.coorScale);
                if (gp.isDrawTable) {
                    posx = db.getDataTableX(i);
                }
                Point2D.Double endPoint = egs.isNull() ? null : new Point2D.Double(posx, gp.valueBaseLine - len);
                if (gp.dispValueOntop && !egs.isNull() && valvis) {
                    String sval = db.getDispValue(egc, egs, gp.serNum);
                    x = endPoint.x;
                    y = endPoint.y;
                    c = !db.isMultiSeries() ? db.getColor(i) : db.getColor(j);
                    ValueLabel vl = new ValueLabel(sval, new Point2D.Double(x, y - (double)VALUE_RADIUS), c);
                    labelList.add(vl);
                }
                boolean bl2 = vis2 = i % (gp.graphXInterval + 1) == 0;
                if (!egs.isNull() && gp.drawLineDot && vis2) {
                    double ww;
                    double xx = endPoint.x - (double)VALUE_RADIUS;
                    double yy = endPoint.y - (double)VALUE_RADIUS;
                    double hh = ww = (double)(2 * VALUE_RADIUS);
                    Color backColor = !db.isMultiSeries() ? db.getColor(i) : db.getColor(j);
                    ValuePoint vp = new ValuePoint(endPoint, backColor);
                    pointList.add(vp);
                    db.htmlLink(xx, yy, ww, hh, htmlLink, egc.getNameString(), egs);
                }
                if (i > 0) {
                    g.setColor(db.getColor(j));
                    if (egp.isIgnoreNull()) {
                        db.drawLine(lastPoint[j], endPoint);
                    } else {
                        db.drawLine(beginPoint[j], endPoint);
                    }
                    DrawLine.drawVTrendLine(db, beginPoint[j], endPoint, val - beginVal[j]);
                }
                DrawLine.drawHTrendLine(db, beginPoint[j]);
                beginPoint[j] = endPoint;
                if (endPoint != null) {
                    lastPoint[j] = endPoint;
                }
                beginVal[j] = val;
            }
        }
        db.outPoints();
        db.outLabels();
        db.drawLine(gp.gRect1.x, gp.valueBaseLine, gp.gRect1.x + gp.gRect1.width, gp.valueBaseLine, egp.getAxisColor(1));
        db.drawLine(gp.gRect1.x + gp.gRect1.width, gp.valueBaseLine, gp.gRect1.x + gp.gRect1.width + coorWidth, gp.valueBaseLine - coorWidth, egp.getAxisColor(1));
    }

    public static double getPosX(GraphParam gp, int i, int cc, double categorySpan, double seriesWidth) {
        double lb = (double)(i + 1) * categorySpan + (double)((2 * i + 1) * gp.serNum) * seriesWidth / 2.0;
        if (gp.isOverlapOrigin) {
            lb = cc == 1 ? gp.gRect1.width : (double)i * gp.gRect1.width * 1.0 / (double)(cc - 1);
        }
        return gp.gRect1.x + lb;
    }

    public static void drawHTrendLine(DrawBase db, Point2D.Double p) {
        if (p == null || !db.gp.drawLineTrend) {
            return;
        }
        BasicStroke bs = db.getLineStroke(3, 0.1f);
        db.g.setColor(Color.darkGray);
        db.g.setStroke(bs);
        Utils.drawLine(db.g, db.gp.gRect2.x, p.y, db.gp.gRect2.x + db.gp.gRect2.width - 1.0, p.y);
    }

    public static void drawVTrendLine(DrawBase db, Point2D.Double begin, Point2D.Double end, double cha) {
        if (begin == null || end == null || !db.gp.drawLineTrend) {
            return;
        }
        BasicStroke stroke = db.getLineStroke(2, db.gp.getLineThick());
        if (stroke == null) {
            return;
        }
        Stroke old = db.g.getStroke();
        if (end.y < begin.y) {
            db.g.setColor(Color.green.darker());
        } else {
            db.g.setColor(Color.red.darker());
        }
        db.g.setStroke(stroke);
        Utils.drawLine(db.g, end.x, begin.y, end.x, end.y);
        double h = end.y - begin.y;
        double textX = end.x;
        double textY = end.y;
        if (Math.abs(h) > 3.0) {
            db.g.setStroke(db.getLineStroke(1, 0.1f));
            double[] xx = new double[3];
            double[] yy = new double[3];
            if (h > 0.0) {
                textY = begin.y + h / 2.0;
                xx[0] = end.x - 3.0;
                yy[0] = end.y - 12.0;
                xx[1] = end.x;
                yy[1] = end.y;
                xx[2] = end.x + 3.0;
                yy[2] = end.y - 12.0;
            } else {
                textY = end.y - h / 2.0;
                xx[0] = end.x - 3.0;
                yy[0] = end.y + 12.0;
                xx[1] = end.x;
                yy[1] = end.y;
                xx[2] = end.x + 3.0;
                yy[2] = end.y + 12.0;
            }
            Utils.fillPolygon(db.g, xx, yy);
        }
        if (cha != 0.0) {
            String sval = db.getFormattedValue(Math.abs(cha));
            db.gp.GFV_VALUE.outText(textX, textY, sval);
        }
        db.g.setStroke(old);
    }
}

