/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.cellset.graph.draw;

import com.scudata.cellset.graph.draw.DrawBase;
import com.scudata.cellset.graph.draw.DrawLine;
import com.scudata.cellset.graph.draw.ExtGraphCategory;
import com.scudata.cellset.graph.draw.ExtGraphProperty;
import com.scudata.cellset.graph.draw.ExtGraphSery;
import com.scudata.cellset.graph.draw.GraphParam;
import com.scudata.cellset.graph.draw.ValueLabel;
import com.scudata.cellset.graph.draw.ValuePoint;
import com.scudata.chart.Utils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class DrawLine3DObj
extends DrawBase {
    public void draw(StringBuffer htmlLink) {
        DrawLine3DObj.drawing(this, htmlLink);
    }

    public static void drawing(DrawBase db, StringBuffer htmlLink) {
        Point2D.Double p;
        GraphParam gp = db.gp;
        ExtGraphProperty egp = db.egp;
        Graphics2D g = db.g;
        ArrayList<ValueLabel> labelList = db.labelList;
        int VALUE_RADIUS = db.VALUE_RADIUS;
        ArrayList<ValuePoint> pointList = db.pointList;
        db.initGraphInset();
        db.createCoorValue();
        db.drawLegend(htmlLink);
        db.drawTitle();
        db.drawLabel();
        db.keepGraphSpace();
        db.adjustCoorInset();
        gp.graphRect = new Rectangle2D.Double(gp.leftInset, gp.topInset, gp.graphWidth - gp.leftInset - gp.rightInset, gp.graphHeight - gp.topInset - gp.bottomInset);
        if (gp.graphRect.width < 10.0 || gp.graphRect.height < 10.0) {
            return;
        }
        if (gp.coorWidth < 0 || gp.coorWidth > 10000) {
            gp.coorWidth = 0;
        }
        double seriesWidth = gp.graphRect.width / ((double)(gp.catNum + 1) * gp.categorySpan / 100.0 + (double)gp.coorWidth / 200.0 + (double)(gp.catNum * gp.serNum));
        double coorWidth = seriesWidth * ((double)gp.coorWidth / 200.0);
        double categorySpan = seriesWidth * (gp.categorySpan / 100.0);
        double tmpInt = (double)(gp.catNum + 1) * categorySpan + coorWidth + (double)(gp.catNum * gp.serNum) * seriesWidth;
        gp.graphRect.x += (gp.graphRect.width - tmpInt) / 2.0;
        gp.graphRect.width = tmpInt;
        double dely = (gp.graphRect.height - coorWidth) / (double)gp.tickNum;
        tmpInt = dely * (double)gp.tickNum + coorWidth;
        gp.graphRect.y += (gp.graphRect.height - tmpInt) / 2.0;
        gp.graphRect.height = tmpInt;
        gp.gRect1 = (Rectangle2D.Double)gp.graphRect.clone();
        gp.gRect2 = (Rectangle2D.Double)gp.graphRect.clone();
        gp.gRect1.y += coorWidth;
        gp.gRect1.width -= coorWidth;
        gp.gRect1.height -= coorWidth;
        gp.gRect2.x += coorWidth;
        gp.gRect2.width -= coorWidth;
        gp.gRect2.height -= coorWidth;
        db.drawGraphRect();
        for (int i = 0; i <= gp.tickNum; ++i) {
            db.drawGridLine(dely, i);
            Number coory = (Number)gp.coorValue.get(i);
            String scoory = db.getFormattedValue(coory.doubleValue());
            p = db._$3((double)i * dely);
            gp.GFV_YLABEL.outText(p.x - (double)gp.tickLen, p.y, scoory);
            if (coory.doubleValue() != gp.baseValue + gp.minValue) continue;
            gp.valueBaseLine = gp.gRect1.y + gp.gRect1.height - (double)i * dely;
        }
        db.drawWarnLine();
        if (gp.graphTransparent) {
            g.setComposite(AlphaComposite.getInstance(3, 0.6f));
        }
        Point2D.Double[] prePoints1 = new Point2D.Double[gp.serNum];
        Point2D.Double[] prePoints2 = new Point2D.Double[gp.serNum];
        Point2D.Double[] lastPoint1 = new Point2D.Double[gp.serNum];
        Point2D.Double[] lastPoint2 = new Point2D.Double[gp.serNum];
        ArrayList cats = egp.categories;
        int cc = cats.size();
        for (int i = 0; i < cc; ++i) {
            Color c;
            ExtGraphCategory egc = (ExtGraphCategory)cats.get(i);
            double posx = DrawLine.getPosX(gp, i, cc, categorySpan, seriesWidth);
            double delx = posx - gp.gRect1.x;
            boolean vis = i % (gp.graphXInterval + 1) == 0;
            p = db._$2(delx);
            if (vis) {
                c = egp.getAxisColor(1);
                Utils.setStroke(g, c, 1, 1.0f);
                db.drawLine(p.x, p.y, p.x, p.y + (double)gp.tickLen, c);
                db.drawGridLineCategoryV(gp.gRect2.x + delx);
            }
            String value = egc.getNameString();
            gp.GFV_XLABEL.outText(p.x, p.y + (double)gp.tickLen, value, vis);
            for (int j = 0; j < gp.serNum; ++j) {
                ExtGraphSery egs = egc.getExtGraphSery(gp.serNames.get(j));
                double val = egs.getValue();
                double tmp = val - gp.baseValue;
                double len = dely * (double)gp.tickNum * (tmp - gp.minValue) / (gp.maxValue * gp.coorScale);
                Point2D.Double pt1 = new Point2D.Double(posx, gp.valueBaseLine - len);
                Point2D.Double pt2 = new Point2D.Double(posx + coorWidth, gp.valueBaseLine - len - coorWidth);
                if (egs.isNull()) {
                    pt1 = null;
                    pt2 = null;
                }
                if (i > 0) {
                    Point2D.Double p2;
                    Point2D.Double p1;
                    c = !gp.isMultiSeries ? db.getColor(i) : db.getColor(j);
                    if (egp.isIgnoreNull()) {
                        p1 = lastPoint1[j];
                        p2 = lastPoint2[j];
                    } else {
                        p1 = prePoints1[j];
                        p2 = prePoints2[j];
                    }
                    DrawLine3DObj._$1(db, p1, p2, pt1, pt2, c, seriesWidth);
                }
                if (!egs.isNull() && gp.drawLineDot && vis) {
                    Color backColor = gp.serNum == 1 ? db.getColor(i) : db.getColor(j);
                    ValuePoint vp = new ValuePoint(pt1, backColor);
                    pointList.add(vp);
                    db.htmlLink(pt1.x - (double)VALUE_RADIUS, pt1.y - (double)VALUE_RADIUS, VALUE_RADIUS * 2, VALUE_RADIUS * 2, htmlLink, egc.getNameString(), egs);
                }
                if (gp.dispValueOntop && !egs.isNull() && vis) {
                    String sval = db.getDispValue(egc, egs, gp.serNum);
                    double x = pt2.x;
                    double y = pt2.y;
                    c = !gp.isMultiSeries ? db.getColor(i) : db.getColor(j);
                    ValueLabel vl = new ValueLabel(sval, new Point2D.Double(x, y - (double)VALUE_RADIUS), c);
                    labelList.add(vl);
                }
                prePoints1[j] = pt1;
                prePoints2[j] = pt2;
                if (pt1 == null) continue;
                lastPoint1[j] = pt1;
                lastPoint2[j] = pt2;
            }
        }
        db.outPoints();
        db.outLabels();
        if (gp.valueBaseLine != gp.gRect1.y + gp.gRect1.height) {
            db.drawLine(gp.gRect1.x, gp.valueBaseLine, gp.gRect1.x + gp.gRect1.width, gp.valueBaseLine, egp.getAxisColor(1));
            db.drawLine(gp.gRect1.x + gp.gRect1.width, gp.valueBaseLine, gp.gRect1.x + gp.gRect1.width + coorWidth, gp.valueBaseLine - coorWidth, egp.getAxisColor(1));
        }
    }

    private static void _$1(DrawBase db, Point2D.Double p1, Point2D.Double p2, Point2D.Double e1, Point2D.Double e2, Color c, double seriesWidth) {
        if (p1 == null || e1 == null) {
            return;
        }
        double[] ptx1 = new double[]{p1.x, p2.x, e2.x, e1.x};
        double[] pty1 = new double[]{p1.y, p2.y, e2.y, e1.y};
        db.setPaint(ptx1[0], pty1[0], ptx1[3] - ptx1[0], pty1[3] - pty1[0], c, true);
        Utils.fillPolygon(db.g, ptx1, pty1);
        if (db.gp.coorWidth != 0) {
            db.g.setColor(db.gp.coorColor);
        } else {
            db.g.setColor(c);
        }
        if (seriesWidth > 3.0) {
            db.drawPolygon(ptx1, pty1, 4, db.egp.getAxisColor(5));
        }
    }
}

